if Map.Difficulty == "50$ per derrick" then
	cderrick = "OILB.50"
elseif Map.Difficulty == "100$ per derrick" then
	cderrick = "OILB.100"
elseif Map.Difficulty == "150$ per derrick" then
	cderrick = "OILB.150"
elseif Map.Difficulty == "200$ per derrick" then
	cderrick = "OILB.200"
elseif Map.Difficulty == "250$ per derrick" then
	cderrick = "OILB.250"
elseif Map.Difficulty == "300$ per derrick" then
	cderrick = "OILB.300"
elseif Map.Difficulty == "350$ per derrick" then
	cderrick = "OILB.350"
elseif Map.Difficulty == "400$ per derrick" then
	cderrick = "OILB.400"
end

function round(num, idp)
  local mult = 10^(idp or 0)
  return math.floor(num * mult + 0.5) / mult
end

increasing = true

changeLighting = function()
	local ambientChange = 0.1
	local currentAmbient = Lighting.Ambient

	if currentAmbient + ambientChange > 1 then
		increasing = false
	end

	if currentAmbient - ambientChange < 0.5 then
		increasing = true
	end

	if increasing then
		currentAmbient = currentAmbient + ambientChange
	else
		currentAmbient = currentAmbient - ambientChange
	end

	currentAmbient = round(currentAmbient, 1)

	if currentAmbient == 0.5 then
		Lighting.Red = 1.65
		Lighting.Green = 1.35
		Lighting.Blue = 1.45
		--Media.DisplayMessage("0.5")
	elseif currentAmbient == 0.6 then
		Lighting.Red = 1.55
		Lighting.Green = 1.25
		Lighting.Blue = 1.35
		--Media.DisplayMessage("0.6")
	elseif currentAmbient == 0.7 then
		Lighting.Red = 1.45
		Lighting.Green = 1.2
		Lighting.Blue = 1.3
		--Media.DisplayMessage("0.7")
	elseif currentAmbient == 0.8 then
		Lighting.Red = 1.3
		Lighting.Green = 1.1
		Lighting.Blue = 1.2
		--Media.DisplayMessage("0.8")
	elseif currentAmbient == 0.9 then
		Lighting.Red = 1.15
		Lighting.Green = 1.05
		Lighting.Blue = 1.10
		--Media.DisplayMessage("0.9")
	elseif currentAmbient == 1 then
		Lighting.Red = 1
		Lighting.Green = 1
		Lighting.Blue = 1
		--Media.DisplayMessage("1")
	end

	Lighting.Ambient = currentAmbient

	--Media.DisplayMessage(tostring(currentAmbient))
end

WorldLoaded = function()
	Media.PlaySound("rain.aud")

	Trigger.AfterDelay(DateTime.Seconds(0), function()
		Utils.Do(Map.NamedActors, function(a)
			if a.Type == "oilb" then
				local newDerrick = Actor.Create(cderrick, true, { Owner = a.Owner, Location = a.Location })
				a.Destroy()
			end
		end)
	end)	
end

Tick = function()
	-- Perf: access to local variables is faster... in theory
	local Utils = Utils
	local Lighting = Lighting

	if Lighting.Ambient < 0.8 then
		if (Utils.RandomInteger(1, 700) == 10) then
			local delay = Utils.RandomInteger(1, 10)
			Lighting.Flash("LightningStrike", delay)
			Trigger.AfterDelay(delay, function()
				Media.PlaySound("thunder" .. Utils.RandomInteger(1,6) .. ".aud")
			end)
		end
		if (Utils.RandomInteger(1, 700) == 10) then
			Media.PlaySound("thunder-ambient.aud")
		end
		if (DateTime.GameTime % DateTime.Seconds(12) == 0) then
				Media.PlaySound("rain.aud")
		end
	end

	if (DateTime.GameTime % DateTime.Seconds(60) == 0) then
		changeLighting()
	end
end