if Map.Difficulty == "50$ per derrick" then
	cderrick = "OILB.50"
elseif Map.Difficulty == "100$ per derrick" then
	cderrick = "OILB.100"
elseif Map.Difficulty == "150$ per derrick" then
	cderrick = "OILB.150"
elseif Map.Difficulty == "200$ per derrick" then
	cderrick = "OILB.200"
elseif Map.Difficulty == "250$ per derrick" then
	cderrick = "OILB.250"
elseif Map.Difficulty == "300$ per derrick" then
	cderrick = "OILB.300"
elseif Map.Difficulty == "350$ per derrick" then
	cderrick = "OILB.350"
elseif Map.Difficulty == "400$ per derrick" then
	cderrick = "OILB.400"
end


changeLighting = function()
	local ambientChange = 0.1
	local currentAmbient = Lighting.Ambient

	if currentAmbient + ambientChange > 1 then
		currentAmbient = 0.5
	end

	Lighting.Ambient = currentAmbient + ambientChange

	if Lighting.Ambient == 0.6 then
		Lighting.Red = 1.55
		Lighting.Green = 1.25
		Lighting.Blue = 1.35
	elseif Lighting.Ambient == 0.7 then
		Lighting.Red = 1.45
		Lighting.Green = 1.15
		Lighting.Blue = 1.25
	elseif Lighting.Ambient == 0.8 then
		Lighting.Red = 1.35
		Lighting.Green = 1.05
		Lighting.Blue = 1.15
	elseif Lighting.Ambient == 0.9 then
		Lighting.Red = 1.25
		Lighting.Green = 1
		Lighting.Blue = 1.05
	elseif Lighting.Ambient == 1 then
		Lighting.Red = 1
		Lighting.Green = 1
		Lighting.Blue = 1
	end

	Media.DisplayMessage("Lighting")
end

WorldLoaded = function()
	Media.PlaySound("rain.aud")

	Trigger.AfterDelay(DateTime.Seconds(0), function()
		Utils.Do(Map.NamedActors, function(a)
			if a.Type == "oilb" then
				local newDerrick = Actor.Create(cderrick, true, { Owner = a.Owner, Location = a.Location })
				a.Destroy()
			end
		end)
	end)	
end

Tick = function()
	-- Perf: access to local variables is faster... in theory
	local Utils = Utils
	local Lighting = Lighting

	if Lighting.Ambient < 0.8 then
		if (Utils.RandomInteger(1, 1000) == 10) then
			local delay = Utils.RandomInteger(1, 10)
			Lighting.Flash("LightningStrike", delay)
			Trigger.AfterDelay(delay, function()
				Media.PlaySound("thunder" .. Utils.RandomInteger(1,6) .. ".aud")
			end)
		end
		if (Utils.RandomInteger(1, 1000) == 10) then
			Media.PlaySound("thunder-ambient.aud")
		end
		if (DateTime.GameTime % DateTime.Seconds(12) == 0) then
				Media.PlaySound("rain.aud")
		end
	end

	if (DateTime.GameTime % DateTime.Seconds(40) == 0) then
		changeLighting()
	end
end