﻿GasChamberMechanismTrigger = { CPos.New(14,16), CPos.New(14,17), CPos.New(14,18), CPos.New(14,19), CPos.New(14,20) }
KevorkianCameraTrigger = { CPos.New(43,22), CPos.New(43,23), CPos.New(43,24) }
DestroyLabTrigger = { CPos.New(24,13) }
Escape1Trigger = { CPos.New(37,6) }
GuardRevealTrigger = { CPos.New(7,4), CPos.New(7,5), CPos.New(7,6), CPos.New(7,7), CPos.New(7,8), CPos.New(7,9), CPos.New(7,10) }
GuardReveal2Trigger = { CPos.New(33,16), CPos.New(33,17), CPos.New(33,18), CPos.New(33,19), CPos.New(33,20), CPos.New(33,21) }
 
ExplosionWaypoints = { Rally1, Rally2 }

FlameTurrets = { FlameTurret1, FlameTurret2 }

--Actors
ChemTrooper = "e4"
Zombie = "zombie"
LabFire = "flare"
TanyaType = "e7"
Rifleman = "e1"
BioLab = "bio"
Wall = "brik"
Dog = "dog"
C1 = "c1"
C2 = "c2"
C3 = "c3"
C4 = "c4"
C5 = "c5"
C6 = "c6"
C7 = "c7"
C8 = "c8"
C9 = "c9"

ExplosionsTest = function()
	local Spawns = 
	Trigger.AfterDelay(DateTime.Seconds(1), function()
		Utils.Do(Spawns.units, function(units)
			local buildinglocations = Utils.Random(ExplosionWaypoints).Location
			BindActorTriggers(buildinglocations, units)
		end)
	end)
	Trigger.AfterDelay(DateTime.Seconds(10), Explosions)
end

BindActorTriggers = function(ExplosionWaypoints)
	Actor.Create(TanyaType, true, { Location = ExplosionWaypoints, Owner = Multi0 })
	if a.IsInWorld then
		a.Kill()
	end	
end

SendPlayer = function()
	local Tanya = Actor.Create(TanyaType, true, { Location = SpawnPoint.Location, Owner = Multi0 })
	Tanya.Move(Rally1.Location)
	Player1 = { Tanya }
	Trigger.OnKilled(Tanya, MissionFailed)
end

Trigger.OnEnteredFootprint(GuardRevealTrigger, function(a, id)
	if	a.Owner == Multi0 and a.Type == "e7" then
		Trigger.RemoveFootprintTrigger(id)
		GuardsCamera = Actor.Create("Camera.GuardsCam", true, { Owner = Multi0, Location = GuardsCamera.Location })
	end
	if KevorkianGuard1.IsDead and KevorkianGuard2.IsDead then
		Utils.Do(GuardsCamera, function(actor)
			actor.Destroy()
		end)
	end
end)

GasChamber = function()
	KevorkianLab = Actor.Create("Camera.KevorkianLab", true, { Owner = Multi0, Location = LabCam.Location })
	Reinforcements.Reinforce(Civilian, { "c2", "c3", "c4", "c5", "c6", "c7", "c8", "c9" }, { CivilianSpawn1.Location, MutationChamber.Location })
	Reinforcements.Reinforce(Civilian, { "c2", "c3", "c4", "c5", "c6", "c7", "c8", "c9" }, { CivilianSpawn2.Location, MutationChamber.Location })
	Civilian1 = Actor.Create(C1, true, { Location = CivilianSpawn1.Location, Owner = Civilian })
	Civilian2 = Actor.Create(C2, true, { Location = CivilianSpawn1.Location, Owner = Civilian })
	Civilian3 = Actor.Create(C3, true, { Location = CivilianSpawn1.Location, Owner = Civilian })
	Civilian4 = Actor.Create(C4, true, { Location = CivilianSpawn1.Location, Owner = Civilian })
	Civilian5 = Actor.Create(C5, true, { Location = CivilianSpawn2.Location, Owner = Civilian })
	Civilian6 = Actor.Create(C6, true, { Location = CivilianSpawn2.Location, Owner = Civilian })
	Civilian7 = Actor.Create(C7, true, { Location = CivilianSpawn2.Location, Owner = Civilian })
	Civilian8 = Actor.Create(C8, true, { Location = CivilianSpawn2.Location, Owner = Civilian })
	Civilian9 = Actor.Create(C9, true, { Location = CivilianSpawn2.Location, Owner = Civilian })
	Civilian1.Move(MutationChamber.Location)
	Civilian2.Move(MutationChamber.Location)
	Civilian3.Move(MutationChamber.Location)
	Civilian4.Move(MutationChamber.Location)
	Civilian5.Move(MutationChamber.Location)
	Civilian6.Move(MutationChamber.Location)
	Civilian7.Move(MutationChamber.Location)
	Civilian8.Move(MutationChamber.Location)
	Civilian9.Move(MutationChamber.Location)
	Trigger.AfterDelay(DateTime.Seconds(13), function()
		ConcreteWall1 = Actor.Create(Wall, true, { Location = WallBarrier1.Location, Owner = Neutral })
		ConcreteWall2 = Actor.Create(Wall, true, { Location = WallBarrier2.Location, Owner = Neutral })
		Trigger.AfterDelay(DateTime.Seconds(2), function()
			Utils.Do(FlameTurrets, function(actor)
				actor.Owner = BadGuy
			end)
			Trigger.AfterDelay(DateTime.Seconds(10), function()
				Utils.Do(FlameTurrets, function(actor)
					actor.Owner = Neutral
				end)
				ConcreteWall1.Kill()
				ConcreteWall2.Kill()
				if not FlameTurret1.IsDead then
					GasChamber()
				end
			end)
		end)
	end)
end

Trigger.OnEnteredFootprint(GuardReveal2Trigger, function(a, id)
	if	a.Owner == Multi0 and a.Type == "e7" then
		Trigger.RemoveFootprintTrigger(id)
		GuardsCamera = Actor.Create("Camera.Guards2Cam", true, { Owner = Multi0, Location = GuardsCamera2.Location })
	end
end)

Trigger.OnEnteredFootprint(KevorkianCameraTrigger, function(a, id)
	if	a.Owner == Multi0 and a.Type == "e7" then
		Trigger.RemoveFootprintTrigger(id)
		kevorkiancam = Actor.Create("Camera.KevorkianCam", true, { Owner = Multi0, Location = BossCam.Location })
		Trigger.AfterDelay(DateTime.Seconds(15), function()
			if not Kevorkian.IsDead then
				Kevorkian.AttackMove(SpawnPoint.Location)
			end
		end)
	end
end)

MissionAccomplished = function()
	alliedObjective2 = Multi0.AddPrimaryObjective("Destroy The Mutation Chamber")
	LabBarrier.Kill()
	Trigger.AfterDelay(DateTime.Seconds(1), function()
		Multi0.MarkCompletedObjective(alliedObjective1)
		Trigger.AfterDelay(DateTime.Seconds(8), function()
		end)
	end)
end

Escape = function()
	BioDestroy = Actor.Create(BioLab, true, { Location = Explosion2.Location, Owner = Multi0 })
	BioDestroy.Kill()
	BioDestroy1 = Actor.Create(BioLab, true, { Location = Explosion1.Location, Owner = Multi0 })
	BioDestroy1.Kill()
	FlameTurret1.Kill()
	FlameTurret2.Kill()
	KillCivilians()
	KevorkianLab.Destroy()
	Trigger.AfterDelay(DateTime.Seconds(1), function()
		BioDestroy = Actor.Create(BioLab, true, { Location = Explosion2.Location, Owner = Multi0 })
		BioDestroy.Kill()
		BioDestroy1 = Actor.Create(BioLab, true, { Location = Explosion1.Location, Owner = Multi0 })
		BioDestroy1.Kill()
		Explosions()
		Actor.Create(LabFire, true, { Location = Explosion1.Location, Owner = BadGuy })
		Actor.Create(LabFire, true, { Location = Explosion2.Location, Owner = BadGuy })
		Trigger.AfterDelay(DateTime.Seconds(1), function()
			Media.PlaySoundNotification(Multi0, "AlertBuzzer")
		end)
	end)
end

KillCivilians = function()
	if Civilian1.IsDead or Civilian2.IsDead or Civilian3.IsDead or Civilian4.IsDead or Civilian5.IsDead or Civilian6.IsDead or Civilian7.IsDead or Civilian8.IsDead or Civilian9.IsDead then
		Actor.Create(Zombie, true, { Location = Rally1.Location, Owner = BadGuy })
	elseif Civilian1.IsInWorld or Civilian2.IsInWorld or Civilian3.IsInWorld or Civilian4.IsInWorld or Civilian5.IsInWorld or Civilian6.IsInWorld or Civilian7.IsInWorld or Civilian8.IsInWorld or Civilian9.IsInWorld then
			Civilian1.Kill()
			Civilian2.Kill()
			Civilian3.Kill()
			Civilian4.Kill()
			Civilian5.Kill()
			Civilian6.Kill()
			Civilian7.Kill()
			Civilian8.Kill()
			Civilian9.Kill()
	end
end

Explosions = function()
	BioDestroy = Actor.Create(BioLab, true, { Location = Explosion1.Location, Owner = BadGuy })
	BioDestroy.Kill()
	BioDestroy = Actor.Create(BioLab, true, { Location = Explosion3.Location, Owner = BadGuy })
	BioDestroy.Kill()
	Actor.Create(LabFire, true, { Location = Explosion3.Location, Owner = BadGuy })
	Actor.Create(LabFire, true, { Location = Explosion4.Location, Owner = BadGuy })
	Actor.Create(LabFire, true, { Location = Explosion9.Location, Owner = BadGuy })
	Trigger.AfterDelay(DateTime.Seconds(1), function()
		BioDestroy = Actor.Create(BioLab, true, { Location = Explosion2.Location, Owner = BadGuy })
		BioDestroy.Kill()
		BioDestroy = Actor.Create(BioLab, true, { Location = Explosion5.Location, Owner = BadGuy })
		BioDestroy.Kill()
		BioDestroy = Actor.Create(BioLab, true, { Location = Explosion6.Location, Owner = BadGuy })
		BioDestroy.Kill()
		Trigger.AfterDelay(DateTime.Seconds(0.5), function()
			BioDestroy = Actor.Create(BioLab, true, { Location = Explosion7.Location, Owner = BadGuy })
			BioDestroy.Kill()
			BioDestroy = Actor.Create(BioLab, true, { Location = Explosion8.Location, Owner = BadGuy })
			BioDestroy.Kill()
			Trigger.AfterDelay(DateTime.Seconds(1), function()
				BioDestroy = Actor.Create(BioLab, true, { Location = Explosion9.Location, Owner = BadGuy })
				BioDestroy.Kill()
				BioDestroy = Actor.Create(BioLab, true, { Location = Explosion1.Location, Owner = BadGuy })
				BioDestroy.Kill()
				BioDestroy = Actor.Create(BioLab, true, { Location = Explosion2.Location, Owner = BadGuy })
				BioDestroy.Kill()
				BioDestroy = Actor.Create(BioLab, true, { Location = Explosion1.Location, Owner = BadGuy })
				Trigger.AfterDelay(DateTime.Seconds(0.5), function()
					BioDestroy.Kill()
					BioDestroy = Actor.Create(BioLab, true, { Location = Explosion3.Location, Owner = BadGuy })
					BioDestroy.Kill()
					Actor.Create(LabFire, true, { Location = Explosion3.Location, Owner = BadGuy })
					Actor.Create(LabFire, true, { Location = Explosion4.Location, Owner = BadGuy })
					Actor.Create(LabFire, true, { Location = Explosion9.Location, Owner = BadGuy })
					Trigger.AfterDelay(DateTime.Seconds(0.1), function()
						Multi0.MarkCompletedObjective(alliedObjective2)
					end)
				end)
			end)
		end)
	end)
end

MissionFailed = function()
	Multi0.MarkFailedObjective(alliedObjective1)
end

PlayTrack = function()
	Trigger.AfterDelay(DateTime.Seconds(0.000001), function()
		Media.PlaySound("Hanger.aud")
		Trigger.AfterDelay(DateTime.Seconds(424), function()
			PlayTrack()
		end)
	end)
end
WorldLoaded = function()
	Civilian = Player.GetPlayer("Civies")
	BadGuy = Player.GetPlayer("BadGuy")
	Neutral = Player.GetPlayer("Neutral")
	Multi0 = Player.GetPlayer("Multi0")
	GasChamber()
	SendPlayer()
	Media.StopMusic()
	PlayTrack()
	Trigger.OnKilled(Kevorkian, MissionAccomplished)

	Trigger.OnObjectiveAdded(Multi0, function(p, id)
		Trigger.AfterDelay(DateTime.Seconds(5), function()
			Media.DisplayMessage(p.GetObjectiveDescription(id), "New " .. string.lower(p.GetObjectiveType(id)) .. " objective")
		end)
	end)

	alliedObjective1 = Multi0.AddPrimaryObjective("Kill Dr. Kevorkian", "Primary Objective:")

	Trigger.OnObjectiveCompleted(Multi0, function(p, id)
		Media.DisplayMessage(p.GetObjectiveDescription(id), "Objective completed")
	end)
	Trigger.OnObjectiveFailed(Multi0, function(p, id)
		Media.DisplayMessage(p.GetObjectiveDescription(id), "Objective failed")
	end)
	Trigger.OnPlayerLost(Multi0, function()
		Trigger.AfterDelay(DateTime.Seconds(1), function()
			Media.PlaySpeechNotification(Multi0, "MissionFailed")
		end)
	end)
	Trigger.OnPlayerWon(Multi0, function()
		Trigger.AfterDelay(DateTime.Seconds(1), function()
			Media.PlaySpeechNotification(Multi0, "MissionAccomplished")
		end)
	end)
	Trigger.OnEnteredFootprint(GasChamberMechanismTrigger, function(a, id)
		Trigger.AfterDelay(10, function()
			if a.Owner == Multi0 and a.Type == "e7" then
				Trigger.RemoveFootprintTrigger(id)
				Rifleman1 = Actor.Create(Rifleman, true, { Location = InfantrySpawn1.Location, Owner = BadGuy })
				Rifleman2 = Actor.Create(Rifleman, true, { Location = InfantrySpawn1.Location, Owner = BadGuy })
				Rifleman3 = Actor.Create(Rifleman, true, { Location = InfantrySpawn1.Location, Owner = BadGuy })
				Rifleman1.AttackMove(Rally1.Location)
				Rifleman2.AttackMove(Rally1.Location)
				Rifleman3.AttackMove(Rally1.Location)
			end
		end)
	end)
	Trigger.OnEnteredFootprint(DestroyLabTrigger, function(a, id)
		Trigger.RemoveFootprintTrigger(id)
		Trigger.AfterDelay(10, function()
			if	a.Owner == Multi0 and a.Type == "e7" then
				Escape()
			end
		end)
	end)
end