﻿if Map.Difficulty == "Easy" then
	StartingReinforcements = { "e7" }
elseif Map.Difficulty == "Hard" then
	StartingReinforcements = { "e7.noautotarget" }
end

--Triggers
FlameTurretTrigger = { CPos.New(154,18), CPos.New(154,19), CPos.New(154,20)   }
RussiaBaseCameraTrigger = { CPos.New(124,17), CPos.New(124,18), CPos.New(124,19), CPos.New(124,20) }
ZombieTrigger = { CPos.New(83,7), CPos.New(83,8), CPos.New(83,9), CPos.New(83,10)   }
ZombieAttackTrigger = { CPos.New(78,7), CPos.New(78,8)   }

--Patrol Units
PatrolGroup1 = { PatrolUnit1, PatrolUnit2, PatrolUnit3 }
PatrolGroup2 = { PatrolUnit4, PatrolUnit5, PatrolUnit6 }
MedicPrisoner = { Actor346 }
MedicGuards = { Actor342, Actor343, Actor341, Actor345, Actor344  } 
--Starting Units
StartingReinforcements = { "e7.noautotarget" }
--Tanya NoAutoTarget
ChangeStance = true
--Russian Base Patrol Path
InfantryPatrolPath = { Rally6.Location, RescueRally.Location, Rally4.Location }
InfantryPatrolPath2 = { Rally4.Location, Rally6.Location, RescueRally.Location }
--heli Spawn
InsertionPathMulti0 = { InsertionEntryMulti0.Location, ZombieSpawn9.Location }
ExtractionPathMulti0 = { InsertExtractionHeli.Location, Extraction.Location }
--Random Zombie Spawns
ZombieEntryPoints = { RoadSpawn6, RoadSpawn9, RoadSpawn10, RoadSpawn15 }
SpawnPoints = { Rally1, Rally2, Rally3 }
ZombieEntryPoints2 = { RoadSpawn3, RoadSpawn16, RoadSpawn13, RoadSpawn14 }
SpawnPoints2 = { Rally3, Rally4, Rally5 }
ZombieEntryPoints3 = { RoadSpawn17, RoadSpawn18, RoadSpawn2, RoadSpawn1 }
SpawnPoints3 = { Rally7, Rally8, Rally9 }

--Actors
Engineer = "e6"
Sniper = "sniper"
General = "gnrl"
Delphi = "delphi"
InfantryType = "e1"
Chan = "chan"
Medic = "medi"
FlareType = "flare"
Startingheli = "tran.insertion"
Extractionheli = "tran.extraction"
RescueTeam = { "e1", "e1", "e6", "medic" }


ZombieTeam1 = {  "e1" }
ZombieTeam2 = {  "e1", "e1" }
ZombieTeam3 = {  "e1", "e1", "e1" }
ZombieTeam4 = {  "e1" } 
ZombieTeam5 = {  "e1", "e1", "e1" }
ZombieTeam6 = {  "e1", "e2", "e3" }
ZombieTeam7 = {  "e1", "e4", "e2" } 
ZombieTeam8 = {  "e1", "e2", "e4", "shok", "shok" } 
--Team Calls/Times
Wave = 0
Waves =
{
	{ delay = 500, units = { ZombieTeam1 } },
	{ delay = 500, units = { ZombieTeam2 } },
	{ delay = 500, units = { ZombieTeam3 } },
	{ delay = 500, units = { ZombieTeam1 } },
	{ delay = 500, units = { ZombieTeam2 } },
	{ delay = 500, units = { ZombieTeam3 } }
}

ZombieWave = 0
ZombieWaves =
{
	{ delay = 100, units = { ZombieTeam4 } },
	{ delay = 100, units = { ZombieTeam5 } },
	{ delay = 100, units = { ZombieTeam6 } },
	{ delay = 100, units = { ZombieTeam7 } },
	{ delay = 100, units = { ZombieTeam8 } }
}

SendInsertionHelicopterMulti0 = function()
	local passengers = Reinforcements.ReinforceWithTransport(Multi0, Startingheli,
		StartingReinforcements, InsertionPathMulti0, { RoadSpawn10.Location })[2]
	local Player1 = passengers[1]
	Trigger.OnKilled(Player1, MissionFailed)
	Player1.Stance = "HoldFire"
end
ActivatePatrolUnit1 = function() 
	GroupPatrol(PatrolGroup1, InfantryPatrolPath, DateTime.Seconds(1))
end
ActivatePatrolUnit2 = function()
	GroupPatrol(PatrolGroup2, InfantryPatrolPath2, DateTime.Seconds(1))
end

--AI Attacks Player
SendUnits = function(entryCell, unitTypes, targetCell)
	local units = Reinforcements.Reinforce(Russia, unitTypes, { entryCell }, 40, function(a)
		if not a.HasProperty("AttackMove") then
			Trigger.OnIdle(a, function(a)
				a.Move(targetCell)
			end)
			return
		end

		Trigger.OnIdle(a, function(a)
			if a.Location ~= targetCell then
				a.AttackMove(targetCell)
			else
				a.Hunt()
			end
		end)
	end)
end
--Function to call Zombie Teams from random spawns
SendWave = function()
	Wave = Wave + 1
	local wave = Waves[Wave]
	Trigger.AfterDelay(wave.delay, function()
		Utils.Do(wave.units, function(units)
			local entry = Utils.Random(ZombieEntryPoints).Location
			local target = Utils.Random(SpawnPoints).Location
			SendUnits(entry, units, target)
		end)
		if (Wave < #Waves) then
			local delay = Utils.RandomInteger(DateTime.Seconds(10), DateTime.Seconds(10))
			Trigger.AfterDelay(delay, SendWave)
		end
	end)
end

Trigger.OnEnteredFootprint(FlameTurretTrigger, function(a, id)
	Trigger.RemoveFootprintTrigger(id)
	Trigger.AfterDelay(10, function()
		if a.Owner == Multi0 then
			FlameTurretCamera = Actor.Create("Camera.FlameTurret", true, { Owner = Multi0, Location = FlameTurretCamera.Location })
		end
	end)
end)

FlameTurret1Destroyed = function()
	Truck1.Kill()
	FlameTurret1.Kill()
	Trigger.AfterDelay(DateTime.Seconds(3), function()
		FlameTurretCamera.Destroy()
	end)
end
MedicFreed = function()
	Utils.Do(MedicPrisoner, function(actor)
		actor.Owner = Multi0
	end)
	Trigger.AfterDelay(DateTime.Seconds(7), function()
		Actor350.Move(RescueRally.Location)
	end)
end

--Wave2

Trigger.OnEnteredFootprint(RussiaBaseCameraTrigger, function(a, id)
	Trigger.RemoveFootprintTrigger(id)
	Trigger.AfterDelay(10, function()
		if a.Owner == Multi0 then
			BaseCamera = Actor.Create("Camera.RussiaBase", true, { Owner = Multi0, Location = RussianBaseCamera.Location })
			alliedObjective0 = Multi0.AddPrimaryObjective("Destroy All Power Plants, Leave The Technology Center Intact!")
		end
	end)
end)	
RescueObjective = function()
	Actor328.Kill()
	Actor369.Kill()
	Media.PlaySpeechNotification(Multi0, "TargetRescued")
	general = Actor.Create(General, true, { Location = RescueSpawn.Location, Owner = Multi0 })
	chan = Actor.Create(Chan, true, { Location = RescueSpawn.Location, Owner = Multi0 })
	delphi = Actor.Create(Delphi, true, { Location = RescueSpawn.Location, Owner = Multi0 })
	general.Move(RescueRally.Location)
	chan.Move(RescueRally.Location)
	delphi.Move(RescueRally.Location)
	Trigger.AfterDelay(DateTime.Seconds(5), function()
		Media.DisplayMessage("General: Theres A Radar Station Jamming our Evac Signal...")
		ScienceTeam()
		EscapeObjective1 = Multi0.AddPrimaryObjective("Scientist Must Stay Alive.")
		EscapeObjective2 = Multi0.AddPrimaryObjective("Destroy The Radar Station.")
		Trigger.AfterDelay(DateTime.Seconds(7), function()
			Multi0.MarkCompletedObjective(alliedObjective0)
			Multi0.MarkCompletedObjective(alliedObjective1)
			Trigger.AfterDelay(DateTime.Seconds(6), function()
				BaseCamera.Destroy()
			end)
		end)
	end)
end
--Wave3

Trigger.OnEnteredFootprint(ZombieAttackTrigger, function(a, id)
	Trigger.RemoveFootprintTrigger(id)
	Trigger.AfterDelay(10, function()
		if a.Owner == Multi0 then
			Actor.Create("Camera.RavenholmVillage", true, { Owner = Multi0, Location = RavenholmCamera.Location })
		end
	end)
end)	

ZombieApocalypse = function()
	Trigger.AfterDelay(DateTime.Seconds(1), function()
		BioLab.Kill()
		Actor378.Kill()
		Media.DisplayMessage("Good Job Commander, Chopper In Bound.")
		Trigger.AfterDelay(DateTime.Seconds(5), function()
			Actor.Create(FlareType, true, { Location = Extraction.Location, Owner = Multi0	})
			ZombieAttack()
			Trigger.AfterDelay(DateTime.Seconds(30), function()
				Reinforcements.Reinforce(Russia, { "e1", "e1", "e1", "e1" }, { RoadSpawn1.Location, RavenholmCamera.Location })
			end)
		end)
	end)
end


ZombieUnits = function(entryCell, unitTypes, targetCell)
	local units = Reinforcements.Reinforce(Russia, unitTypes, { entryCell }, 40, function(a)
		if not a.HasProperty("AttackMove") then
			Trigger.OnIdle(a, function(a)
				a.Move(targetCell)
			end)
			return
		end

		Trigger.OnIdle(a, function(a)
			if a.Location ~= targetCell then
				a.AttackMove(targetCell)
			else
				a.Hunt()
			end
		end)
	end)
end

ZombieAttack = function()
	ZombieWave = ZombieWave + 1
	local zombiewaves = ZombieWaves[ZombieWave]
	Trigger.AfterDelay(zombiewaves.delay, function()
		Utils.Do(zombiewaves.units, function(units)
			local entry = Utils.Random(ZombieEntryPoints3).Location
			local target = Utils.Random(SpawnPoints3).Location
			ZombieUnits(entry, units, target)
		end)

		if (ZombieWave < #ZombieWaves) then
			local delay = Utils.RandomInteger(DateTime.Seconds(10), DateTime.Seconds(20))
			Trigger.AfterDelay(delay, ZombieAttack)
		else
			Trigger.AfterDelay(DateTime.Seconds(10), SendExtractionHelicopter)
		end
	end)
end

--extraction
SendExtractionHelicopter = function()
	heli = Reinforcements.ReinforceWithTransport(Government, Extractionheli, nil, ExtractionPathMulti0)[1]
	Trigger.AfterDelay(DateTime.Seconds(15), function()
		EvacuateHelicopter()
	end)
	Trigger.OnKilled(heli, RescueFailed)
	Trigger.OnRemovedFromWorld(heli, HelicopterGone)
end

EvacuateHelicopter = function()
	heli.Move(RoadSpawn18.Location)
	Trigger.OnIdle(heli, heli.Destroy)
end

HelicopterGone = function()
	if not heli.IsDead then
		Trigger.AfterDelay(DateTime.Seconds(1), function()
			Multi0.MarkCompletedObjective(alliedObjective1)
			Multi0.MarkCompletedObjective(alliedObjective2)
			Multi0.MarkCompletedObjective(EscapeObjective1)
			Multi0.MarkCompletedObjective(EscapeObjective2)
		end)
	end
end

--Objective Fails/Completions

ScienceTeam = function()
	SciTeam = { general, chan, delphi }
	Trigger.OnAllKilled(SciTeam, RescueFailed)
end

RescueFailed = function()
	Media.DisplayMessage("Scientists Killed")
	if not Multi0.MarkCompletedObjective(alliedObjective0) and 	Multi0.MarkCompletedObjective(alliedObjective1) then
		Trigger.AfterDelay(DateTime.Seconds(3), function()
			Russia.MarkCompletedObjective(RussiaObjective)
			Multi0.MarkFailedObjective(alliedObjective0)
			Multi0.MarkFailedObjective(alliedObjective1)
		end)
	end
	if Multi0.MarkCompletedObjective(alliedObjective0) and 	Multi0.MarkCompletedObjective(alliedObjective1) then
		Trigger.AfterDelay(DateTime.Seconds(3), function()
			Russia.MarkCompletedObjective(RussiaObjective)
			Multi0.MarkFailedObjective(EscapeObjective1)
			Multi0.MarkFailedObjective(EscapeObjective2)
		end)
	end
end

MissionAccomplished = function()
	Trigger.AfterDelay(DateTime.Seconds(1), function()
	Media.PlaySpeechNotification(Multi0, "MissionAccomplished")
	end)
end

MissionFailed = function()
	Multi0.MarkFailedObjective(alliedObjective0)
	Multi0.MarkFailedObjective(alliedObjective1)
end
--Patrol Function
GroupPatrol = function(units, waypoints, delay) 
	local i = 1
	local stop = false
	Utils.Do(units, function(unit)
		Trigger.OnIdle(unit, function()
			if stop then
				return
			end
			if unit.Location == waypoints[i] then
				local bool = Utils.All(units, function(actor) return actor.IsIdle end)
				if bool then
					stop = true
					i = i + 1
					if i > #waypoints then
						i = 1
					end
					Trigger.AfterDelay(delay, function() stop = false end)
				end
			else
				unit.AttackMove(waypoints[i])
			end
		end)
	end)
end

WorldLoaded = function()
	BadGuy = Player.GetPlayer("BadGuy")
	Multi0 = Player.GetPlayer("Multi0")
	Russia = Player.GetPlayer("Russia")
	Government = Player.GetPlayer("Government")
	players = { }
	for i = 0, 7, 1 do
		local player = Player.GetPlayer("Multi" ..i)
		players[i] = player
	end

	Camera.Position = ZombieSpawn9.CenterPosition

--Objectives
	SendInsertionHelicopterMulti0()

	Trigger.OnPlayerLost(Multi0, MissionFailed)

	Trigger.OnPlayerWon(Multi0, MissionAccomplished)

	Trigger.OnObjectiveAdded(Multi0, function(p, id)
		Trigger.AfterDelay(DateTime.Seconds(5), function()
			Media.DisplayMessage(p.GetObjectiveDescription(id), "New " .. string.lower(p.GetObjectiveType(id)) .. " objective")
		end)
	end)

	BadGuy.AddPrimaryObjective("Eat Brains")
 	RussiaObjective = Russia.AddPrimaryObjective("Defeat Allies")
	alliedObjective1 = Multi0.AddPrimaryObjective("Rescue Scientists")

	Trigger.OnObjectiveCompleted(Multi0, function(p, id)
		Media.DisplayMessage(p.GetObjectiveDescription(id), "Objective completed")
	end)
	Trigger.OnObjectiveFailed(Multi0, function(p, id)
		Media.DisplayMessage(p.GetObjectiveDescription(id), "Objective failed")
	end)

	Trigger.OnPlayerLost(Multi0, function()
		Trigger.AfterDelay(DateTime.Seconds(1), function()
			Media.PlaySpeechNotification(Multi0, "MissionFailed")
		end)
	end)
	Trigger.OnPlayerWon(Multi0, function()
		Trigger.AfterDelay(DateTime.Seconds(1), function()
			Media.PlaySpeechNotification(Multi0, "MissionAccomplished")
		end)
	end)
--Initial Activities
	SendWave()

--Patrol Activations
	Trigger.AfterDelay(DateTime.Seconds(Utils.RandomInteger(0, 10)), function()
		ActivatePatrolUnit1()
	end)

	Trigger.AfterDelay(DateTime.Seconds(Utils.RandomInteger(0, 10)), function()
		ActivatePatrolUnit2()
	end)
--Camera Trigger
	Trigger.OnKilled(Truck2, FlameTurret1Destroyed)

	Trigger.OnAllKilled(MedicGuards, MedicFreed)

	Trigger.OnKilled(TechCenter, RescueFailed)

	SovietBase = { Actor469, Actor470, Actor461, Actor374 } 
	Trigger.OnAllKilled(SovietBase, RescueObjective)

	Guards1 = { Actor447, Actor445, Actor492, Actor394 } 
	Trigger.OnAnyKilled(Guards1, ZombieApocalypse)

--Background Music
	Trigger.AfterDelay(DateTime.Seconds(0), function()
		Media.PlaySound("RavenholmTrack1.aud")
	end)
	Trigger.AfterDelay(DateTime.Seconds(110), function()
		Media.PlaySound("RavenholmTrack1.aud")
	end)
	Trigger.AfterDelay(DateTime.Seconds(220), function()
		Media.PlaySound("RavenholmTrack1.aud")
	end)
	Trigger.AfterDelay(DateTime.Seconds(330), function()
		Media.PlaySound("RavenholmTrack1.aud")
	end)
	Trigger.AfterDelay(DateTime.Seconds(440), function()
		Media.PlaySound("RavenholmTrack1.aud")
	end)
	Trigger.AfterDelay(DateTime.Seconds(550), function()
		Media.PlaySound("RavenholmTrack1.aud")
	end)
	Trigger.AfterDelay(DateTime.Seconds(660), function()
		Media.PlaySound("RavenholmTrack1.aud")
	end)
	Trigger.AfterDelay(DateTime.Seconds(770), function()
		Media.PlaySound("RavenholmTrack1.aud")
	end)
	Trigger.AfterDelay(DateTime.Seconds(880), function()
		Media.PlaySound("RavenholmTrack1.aud")
	end)
	Trigger.AfterDelay(DateTime.Seconds(990), function()
		Media.PlaySound("RavenholmTrack1.aud")
	end)
	Trigger.AfterDelay(DateTime.Seconds(1100), function()
		Media.PlaySound("RavenholmTrack1.aud")
	end)
	Trigger.AfterDelay(DateTime.Seconds(1210), function()
		Media.PlaySound("RavenholmTrack1.aud")
	end)
	Trigger.AfterDelay(DateTime.Seconds(1320), function()
		Media.PlaySound("RavenholmTrack1.aud")
	end)
	Trigger.AfterDelay(DateTime.Seconds(1430), function()
		Media.PlaySound("RavenholmTrack1.aud")
	end)
	Trigger.AfterDelay(DateTime.Seconds(1540), function()
		Media.PlaySound("RavenholmTrack1.aud")
	end)
	Trigger.AfterDelay(DateTime.Seconds(1650), function()
		Media.PlaySound("RavenholmTrack1.aud")
	end)
	Trigger.AfterDelay(DateTime.Seconds(1760), function()
		Media.PlaySound("RavenholmTrack1.aud")
	end)
end
--Zombie Triggers
		Tick = function()
			if (Utils.RandomInteger(1, 200) == 10) then
				local delay = Utils.RandomInteger(1, 10)
				Lighting.Flash("LightningStrike", delay)
				Trigger.AfterDelay(delay, function()
					Media.PlaySound("thunder" .. Utils.RandomInteger(1,6) .. ".aud")
				end)
			end
		end