
SovietEntryPoints = { Entry1, Entry2, Entry3, Entry4, Entry5, Entry6, Entry7, Entry8 }
PatrolWaypoints = { Entry2, Entry4, Entry6, Entry8 }
ParadropWaypoints = { Paradrop1, Paradrop2, Paradrop3, Paradrop4 }
SpawnPoints = { Spawn1, Spawn2, Spawn3, Spawn4 }
Snipers = { Sniper1, Sniper2, Sniper3, Sniper4, Sniper5, Sniper6, Sniper7, Sniper8, Sniper9, Sniper10, Sniper11, Sniper12 }

Walls =
{
	{ WallTopRight1, WallTopRight2, WallTopRight3, WallTopRight4, WallTopRight5, WallTopRight6, WallTopRight7, WallTopRight8, WallTopRight9 },
	{ WallTopLeft1, WallTopLeft2, WallTopLeft3, WallTopLeft4, WallTopLeft5, WallTopLeft6, WallTopLeft7, WallTopLeft8, WallTopLeft9 },
	{ WallBottomLeft1, WallBottomLeft2, WallBottomLeft3, WallBottomLeft4, WallBottomLeft5, WallBottomLeft6, WallBottomLeft7, WallBottomLeft8, WallBottomLeft9 },
	{ WallBottomRight1, WallBottomRight2, WallBottomRight3, WallBottomRight4, WallBottomRight5, WallBottomRight6, WallBottomRight7, WallBottomRight8, WallBottomRight9 }
}

Dog = { "megadog" }
Fake = { "fdtrk" }
Civilians = { "c1", "c1", "c3", "c7", "c1", "c7", "c5", "c4", "c1", "c7", "c5", "c4", "c1" }
Yaks = { "yak", "yak" }

if Map.Difficulty == "Very Easy (1P)" then
	ParaChance = 20
	Patrol = { "e1", "e2", "e1" }
	Infantry = { "e4", "e1", "e1", "e2", "e2" }
	Vehicles = { "apc" }
	Tank = { "3tnk" }
	LongRange = { "arty" }
	Boss = { "v2rl" }
	Swarm = { "mini3tnk", "mini3tnk", "mini3tnk" }
	FlameZombies = { "flamezombie", "flamezombie", "flamezombie" }
	DogTanks = { "4tnk.dog" }
	Air = { "flyingdog", "flyingdog" }
elseif Map.Difficulty == "Easy (2P)" then
	ParaChance = 25
	Patrol = { "e1", "e2", "e1" }
	Infantry = { "e4", "e1", "e1", "e2", "e1", "e2", "e1" }
	Vehicles = { "ftrk", "apc", "arty" }
	Tank = { "3tnk" }
	LongRange = { "v2rl" }
	Boss = { "4tnk" }
	Swarm = { "mini3tnk", "mini3tnk", "mini3tnk", "mini3tnk", "mini3tnk" }
	FlameZombies = { "flamezombie", "flamezombie", "flamezombie", "flamezombie" }
	DogTanks = { "4tnk.dog" }
	Air = { "flyingdog", "flyingdog", "flyingdog", "flyingdog" }
elseif Map.Difficulty == "Normal (3P)" then
	ParaChance = 30
	Patrol = { "e1", "e2", "e1", "e1" }
	Infantry = { "e4", "e1", "e1", "e2", "e1", "e2", "e1" }
	Vehicles = { "ftrk", "ftrk", "apc", "arty" }
	Tank = { "3tnk" }
	LongRange = { "v2rl" }
	Boss = { "4tnk" }
	Swarm = { "mini3tnk", "mini3tnk", "mini3tnk", "mini3tnk", "mini3tnk", "mini3tnk", "mini3tnk" }
	FlameZombies = { "flamezombie", "flamezombie", "flamezombie", "flamezombie", "flamezombie" }
	DogTanks = { "4tnk.dog" }
	Air = { "flyingdog", "flyingdog", "flyingdog", "flyingdog", "flyingdog", "flyingdog" }
	Yaks = { "yak", "yak", "yak" }
elseif Map.Difficulty == "Hard (4P)" then
	ParaChance = 35
	Patrol = { "e1", "e2", "e1", "e1", "e4" }
	Infantry = { "e4", "e1", "e1", "e2", "e1", "e2", "e1" }
	Vehicles = { "arty", "ftrk", "ftrk", "apc", "apc" }
	Tank = { "3tnk" }
	LongRange = { "v2rl" }
	Boss = { "4tnk" }
	Swarm = { "mini3tnk", "mini3tnk", "mini3tnk", "mini3tnk", "mini3tnk", "mini3tnk", "mini3tnk", "mini3tnk", "mini3tnk" }
	FlameZombies = { "flamezombie", "flamezombie", "flamezombie", "flamezombie", "flamezombie", "flamezombie" }
	DogTanks = { "4tnk.dog", "4tnk.dog" }
	Air = { "flyingdog", "flyingdog", "flyingdog", "flyingdog", "flyingdog", "flyingdog", "flyingdog", "flyingdog" }
	Yaks = { "yak", "yak", "yak" }
else
	ParaChance = 40
	Patrol = { "e1", "e2", "e1", "e1", "e4", "e4" }
	Infantry = { "e4", "e1", "e1", "e2", "e1", "e2", "e1", "e1" }
	Vehicles = { "arty", "arty", "ftrk", "apc", "apc" }
	Tank = { "ftrk", "3tnk" }
	LongRange = { "v2rl" }
	Boss = { "4tnk" }
	Swarm = { "mini3tnk", "mini3tnk", "mini3tnk", "mini3tnk", "mini3tnk", "mini3tnk", "mini3tnk", "mini3tnk", "mini3tnk", "mini3tnk", "mini3tnk" }
	FlameZombies = { "flamezombie", "flamezombie", "flamezombie", "flamezombie", "flamezombie", "flamezombie", "flamezombie" }
	DogTanks = { "4tnk.dog", "4tnk.dog", "4tnk.dog" }
	Air = { "flyingdog", "flyingdog", "flyingdog", "flyingdog", "flyingdog", "flyingdog", "flyingdog", "flyingdog", "flyingdog", "flyingdog" }
	Yaks = { "yak", "yak", "yak", "yak" }
end

Wave = 0
Waves =
{
	{ delay = 500, units = { Infantry } }, --, specialUnits = { Civilians, DogTanks, FlameZombies, Air, Yaks }
	{ delay = 500, units = { Patrol, Patrol } },
	{ delay = 700, units = { Infantry, Infantry, Vehicles }, },
	{ delay = 1300, units = { Infantry, Infantry, Infantry, Infantry } }, -- 1500 -> 1300
	{ delay = 1500, units = { Infantry, Infantry, Patrol, Vehicles } },
	{ delay = 1500, units = { Infantry, Infantry, Patrol, Infantry, Tank, Vehicles } },
	{ delay = 1500, units = { Infantry, Infantry, Dog, Tank, Vehicles, Infantry } },
	{ delay = 1500, units = { Infantry, Infantry, Patrol, Infantry, Infantry, Infantry, LongRange } }, -- lazy copy
	{ delay = 1500, units = { Infantry, Infantry, Patrol, Infantry, Tank, Tank, Swarm }, specialUnits = { Civilians } },
	{ delay = 1500, units = { Infantry, Infantry, Infantry, Infantry, Infantry, Infantry, Infantry, Infantry, Infantry, Infantry, Infantry, Infantry, Infantry } },
	{ delay = 1500, units = { Infantry, Infantry, Patrol, Infantry, Infantry, Infantry, LongRange } },
	{ delay = 1500, units = { Infantry, Infantry, Vehicles, Tank, Tank, LongRange, Dog } },
	{ delay = 1300, units = { Infantry, Infantry, Patrol, Infantry, Infantry, Infantry, Infantry, LongRange, Tank, LongRange, Dog }, specialUnits = { FlameZombies } }, -- 1500 -> 1300
	{ delay = 1500, units = { Infantry, Infantry, Patrol, Infantry, Infantry, Infantry, Infantry, Infantry, LongRange, LongRange, Tank, Tank, Vehicles } },
	{ delay = 1500, units = { Infantry, Infantry, Patrol, Infantry, Infantry, Infantry, Infantry, Infantry, Infantry, Boss, Dog, Swarm } }
}

SpecialWaves = { Utils.Random({ FlameZombies, Yaks }), Utils.Random({ Civilians, Air }) }

-- Now do some adjustments to the waves
if not (Map.Difficulty == "Very Easy (1P)" or Map.Difficulty == "Easy (2P)") then
	Waves[6] = { delay = 1500, units = { Infantry, Infantry, Patrol, Infantry, Tank, Vehicles }, specialUnits = { Fake } }
	SpecialWaves = { Utils.Random({ DogTanks, FlameZombies, Yaks }), Utils.Random({ Civilians, Air }) }
end

if Map.Difficulty == "Real tough guy" or Map.Difficulty == "Endless mode" then
	Waves[8] = { delay = 1500, units = { Infantry, Infantry, Patrol, Infantry, Infantry, Infantry }, ironUnits = { LongRange } }
	Waves[9] = { delay = 1500, units = { Infantry, Infantry, Patrol, Infantry, Infantry, Infantry, Infantry, Infantry, LongRange, LongRange, Vehicles, Tank }, ironUnits = { Tank } }
	Waves[11] = { delay = 1500, units = { Vehicles, Infantry, Patrol, Patrol, Patrol, Infantry, LongRange, Tank, Boss, Dog, Dog, Infantry, Infantry, Patrol } }
	SpecialWaves = { DogTanks, FlameZombies, Civilians, Air, Yaks }
end

SendUnits = function(entryCell, unitTypes, targetCell, extraData)
	-- OpenRA handles this stuff in a weird way...
	if extraData == "yaks" then
		Utils.Do(Yaks, function(yakType)
			local start = Map.CenterOfCell(entryCell) + WVec.New(0, 0, Actor.CruiseAltitude("yak"))
			local yak = Actor.Create("yak", true, { CenterPosition = start, Owner = soviets, Facing = (Map.CenterOfCell(targetCell) - start).Facing })
			yak.Move(targetCell)
			Trigger.AfterDelay(DateTime.Seconds(7), yak.Kill)
		end)
		return
	end

	Reinforcements.Reinforce(soviets, unitTypes, { entryCell }, 40, function(a)
		if not a.HasProperty("AttackMove") then
			Trigger.OnIdle(a, function(a)
				a.Move(targetCell)
			end)
			return
		end

		a.AttackMove(targetCell)

		-- Air units are special...
		if a.Type == "flyingdog" then
				Trigger.OnIdle(a, function(a)
					FindTargetFor(a)
				end)
			return
		end

		Trigger.OnIdle(a, function(a)
			a.Hunt()
		end)

		if extraData == "IronCurtain" then
			a.GrantTimedUpgrade("invulnerability", DateTime.Seconds(25))
		end
	end)
end

SendWave = function()
	Wave = Wave + 1
	local wave = Waves[Wave]

	Trigger.AfterDelay(wave.delay, function()
		Utils.Do(wave.units, function(units)
			local entry = Utils.Random(SovietEntryPoints).Location
			local target = Utils.Random(SpawnPoints).Location

			SendUnits(entry, units, target)
		end)

		if wave.ironUnits then
			Utils.Do(wave.ironUnits, function(units)
				local entry = Utils.Random(SovietEntryPoints).Location
				local target = Utils.Random(SpawnPoints).Location

				SendUnits(entry, units, target, "IronCurtain")
			end)
		end

		if wave.specialUnits then
			local specialists = wave.specialUnits
			Utils.Do(specialists, function(units)
				local entry = Utils.Random(SovietEntryPoints).Location
				local target = Utils.Random(SpawnPoints).Location

				-- Ugh
				if units[1] == "yak" then
					SendUnits(entry, units, target, "yaks")
				else
					SendUnits(entry, units, target)
				end
			end)
			wave.specialUnits = nil
			SelectNewWaveForSpecialists(specialists)
		end

		Utils.Do(players, function(player)
			Media.PlaySpeechNotification(player, "EnemyUnitsApproaching")
		end)

		if (Wave < #Waves) then
			if Utils.RandomInteger(1, 100) < ParaChance then
				local units = ParaProxy.SendParatroopers(Utils.Random(ParadropWaypoints).CenterPosition)
				Utils.Do(units, function(unit)
					Trigger.OnIdle(unit, function(a)
						if a.IsInWorld then
							a.Hunt()
						end
					end)
				end)

				local delay = Utils.RandomInteger(DateTime.Seconds(20), DateTime.Seconds(45))
				Trigger.AfterDelay(delay, SendWave)
			else
				SendWave()
			end
		else
			if Map.Difficulty == "Endless mode" then
				Wave = 0
				IncreaseDifficulty()
				SupplyWave()
				Trigger.AfterDelay(DateTime.Seconds(10), SendWave)
				return
			end

			Trigger.AfterDelay(DateTime.Minutes(1), SovietsRetreating)
			Media.DisplayMessage("You almost survived the onslaught! No more waves incoming.")
		end
	end)
end

SovietsRetreating = function()
	Utils.Do(Snipers, function(a)
		if not a.IsDead and a.Owner == soviets then
			a.Destroy()
		end
	end)
end

IncreaseDifficulty = function()
	local additions = { Infantry, Patrol, Vehicles, Tank, LongRange, Dog, Boss, Swarm }
	Utils.Do(Waves, function(wave)
		wave.units[#wave.units + 1] = Utils.Random(additions)
	end)
end

--Supplies = { "powerproxy.parabombs", "powerproxy.heal", "Cash", "powerproxy.tanyadrop", "powerproxy.minidrop", "powerproxy.ironcurtain" } -- Mechanics?
--SupplyNames = { "Parabombs!", "a single-use Instant Healing power!", "$1000!", "a Tanya drop!", "a Heavy Tank drop!", "a single-use Iron Curtain power!" }
Supplies = { "powerproxy.heal" }
SupplyNames = { "a single-use Iron Curtain power!" }

SupplyWave = function()
	Utils.Do(players, function(player)
		if not player then --bla
			return
		end

		local supply = Utils.RandomInteger(0, #Supplies) + 1
		if Supplies[supply] == "Cash" then
			player.Cash = player.Cash + 1000
			local barrack = player.GetActorsByType("tent")
			if #barrack > 0 then
				Media.FloatingText("+$1000", barrack[1].CenterPosition, 30, player.Color)
			end
			Media.DisplayMessage(player.Name .. " got " .. SupplyNames[supply], "Supply-Wave")
		else
			Actor.Create(Supplies[supply], true, { Owner = player })
			Media.DisplayMessage(player.Name .. " got " .. SupplyNames[supply], "Supply-Wave")
		end
	end)
end

SelectNewWaveForSpecialists = function(specialists)
	Utils.Random(Utils.Skip(Waves, 5), function(wave)
		if wave.specialUnits then
			SelectNewWaveForSpecialists(specialists)
		else
			wave.specialUnits = specialists
		end
	end)
end

FindTargetFor = function(airunit)
	local enemies = Map.ActorsInBox(Map.TopLeft, Map.BottomRight, function(self) return Utils.Any(players, function(player) return self.Owner == player end) and self.HasProperty("Health") end)
	if #enemies > 0 then
		airunit.Attack(Utils.Random(enemies))
	else
		-- Avoide lags when all units are killed
		Trigger.ClearAll(airunit)
	end
end

Tick = function()
	if (Utils.RandomInteger(1, 200) == 10) then
		local delay = Utils.RandomInteger(1, 10)
		Lighting.Flash("LightningStrike", delay)
		Trigger.AfterDelay(delay, function()
			Media.PlaySound("thunder" .. Utils.RandomInteger(1,6) .. ".aud")
		end)
	end
	if (Utils.RandomInteger(1, 200) == 10) then
		Media.PlaySound("thunder-ambient.aud")
	end
end

SetupWallOwners = function()
	Utils.Do(players, function(player)
		Utils.Do(Walls[player.Spawn], function(wall)
			wall.Owner = player
		end)
	end)
end

WorldLoaded = function()
	soviets = Player.GetPlayer("Soviets")
	players = { }
	for i = 0, 4, 1 do
		local player = Player.GetPlayer("Multi" ..i)
		players[i] = player
	end

	Utils.Do(Snipers, function(a)
		if a.Owner == soviets then
			a.GrantUpgrade("unkillable")
		end
	end)

	Media.DisplayMessage("Defend Fort Lonestar at all costs!")
	Media.DisplayMessage("This version might be inbalanced! :p", "WARNING")

	SetupWallOwners()

	Utils.Do(SpecialWaves, function(special)
		SelectNewWaveForSpecialists(special)
	end)

	ParaProxy = Actor.Create("powerproxy.paratroopers", false, { Owner = soviets })
	Trigger.AfterDelay(DateTime.Seconds(3), SupplyWave)
	SendWave()
end
