ProductionUnits = { "trooper", "trooper", "light_inf" }
ProductionBuildings = { OBarrack }
OrdosInfantryTypes = { "light_inf", "light_inf", "light_inf", "trooper", "trooper", "trooper" }

OrdosAttackPaths =
{
	{ OrdosEntry1.Location, OrdosRally1.Location },
	{ OrdosEntry2.Location, OrdosRally2.Location },
}

SendAttack = function()
	if Attacking then
		return
	end
	Attacking = true
	HoldProduction = true
	
	local units = SetupAttackGroup()
	Utils.Do(units, function(unit)
			IdleHunt(unit)
	end)

	Trigger.OnAllRemovedFromWorld(units, function()
			Attacking = false
			HoldProduction = false
	end)
end

InitAIUnits = function()
 	IdlingUnits = Reinforcements.Reinforce(Ordos, InitialOrdosReinforcements, OrdosPaths[2])
 	IdlingUnits[#IdlingUnits + 1] = Olight_inf
 	IdlingUnits[#IdlingUnits + 1] = Olight_inf2
 	IdlingUnits[#IdlingUnits + 1] = Oquad
 
 	Utils.Do(OrdosBase, function(actor)
 		DefendActor(actor)
 		Trigger.OnDamaged(actor, function(building)
 			if building.Health < building.MaxHealth * 3/4 then
 				building.StartBuildingRepairs()
 			end
 		end)
 	end)
end
	
ProduceInfantry = function()
	if OBarracks.IsDead then
		return
	end

	if HoldProduction then
		Trigger.AfterDelay(DateTime.Minutes(1), ProduceInfantry)
		return
	end

	local delay = Utils.RandomInteger(AttackDelays[Map.Difficulty][1], AttackDelays[Map.Difficulty][2] + 1)
	local toBuild = { Utils.Random(OrdosInfantryTypes) }
	ordos.Build(toBuild, function(unit)
		IdlingUnits[#IdlingUnits + 1] = unit[1]
		Trigger.AfterDelay(delay, ProduceInfantry)
	
		if #IdlingUnits >= (AttackGroupSize[Map.Difficulty] * 2.5) then
		SendAttack()
		end
	end)	
end

