TeamCiv1 = { "c1" }
TeamCiv2 = { "c5", "c6", "c7", "c8" }
TeamCiv3 = { "c5", "c2", "c3", "c4", "c1" }
TeamCiv4 = { "c3", "c9", "c7", "c8" }
TeamCiv5 = { "c2", "c6", "c7" }
TeamCiv6 = { "c1", "c2" }
TeamCiv7 = { "c5" }
TeamCiv8 = { "c2", "c1" }
TeamCiv9 = { "c5", "c6", "c7" }
TeamCiv10 = { "c5", "c6" }
TeamCiv11 = { "c3", "c2", "c1" }

Teams =
{
	{ units = TeamCiv1, entryCell = waypoint1.Location, building = house1 },
	{ units = TeamCiv2, entryCell = waypoint2.Location, building = house2 },
	{ units = TeamCiv3, entryCell = waypoint3.Location, building = house3 },
	{ units = TeamCiv4, entryCell = waypoint4.Location, building = house4 },
	{ units = TeamCiv5, entryCell = waypoint5.Location, building = house5 },
	{ units = TeamCiv6, entryCell = waypoint6.Location, building = house6 },
	{ units = TeamCiv7, entryCell = waypoint7.Location, building = house7 },
	{ units = TeamCiv8, entryCell = waypoint8.Location, building = house8 },
	{ units = TeamCiv9, entryCell = waypoint9.Location, building = house9 },
	{ units = TeamCiv10, entryCell = waypoint10.Location, building = house10 },
	{ units = TeamCiv11, entryCell = waypoint11.Location, building = house11 }
}

--SpawnPoints = { victim1, victim2 }

CreateTeam = function(Team)
	if Team.building.IsDead then
		return
	end
	local units = Reinforcements.Reinforce(BadGuy, Team.units, { Team.entryCell }, 25)
	SendUnits(units)
	Utils.Do(units, function(actor)
		if not actor.IsDead then
			Trigger.OnIdle(actor, actor.Hunt)
		end
	end)
	Trigger.AfterDelay(DateTime.Seconds(110), function()
		CreateTeam(Team)
	end)
end


SendUnits = function(units)
	--Get random player spawnpoint
	local player = Utils.Random(players)
	local waypoint = Map.NamedActor("SPMulti"..tostring(player.Spawn - 1))
	Utils.Do(units, function(unit)
		if not unit.IsDead then
				unit.AttackMove(waypoint.Location)
			unit.Hunt()
		end
	end)
end

WorldLoaded = function()
	BadGuy = Player.GetPlayer("BadGuy")
	players = { }
	for i = 0, 7, 1 do
		local player = Player.GetPlayer("Multi" ..i)
		if player ~= nil then
			table.insert(players, player)
		end
	end

	Trigger.AfterDelay(DateTime.Seconds(30), function()
		CreateTeam(Teams[1])
	end)
	Trigger.AfterDelay(DateTime.Seconds(60), function()
		CreateTeam(Teams[2])
	end)
	Trigger.AfterDelay(DateTime.Minutes(3), function()
		CreateTeam(Teams[3])
	end)
	Trigger.AfterDelay(DateTime.Minutes(8), function()
		CreateTeam(Teams[4])
	end)
	Trigger.AfterDelay(DateTime.Minutes(12), function()
		CreateTeam(Teams[5])
	end)
	Trigger.AfterDelay(DateTime.Minutes(17), function()
		CreateTeam(Teams[6])
	end)
	Trigger.AfterDelay(DateTime.Minutes(22), function()
		CreateTeam(Teams[7])
	end)
	Trigger.AfterDelay(DateTime.Minutes(27), function()
		CreateTeam(Teams[8])
	end)
	Trigger.AfterDelay(DateTime.Minutes(35), function()
		CreateTeam(Teams[9])
	end)
	Trigger.AfterDelay(DateTime.Minutes(41), function()
		CreateTeam(Teams[10])
	end)
	Trigger.AfterDelay(DateTime.Minutes(46), function()
		CreateTeam(Teams[11])
	end)
end
