InsertionHelicopterType = "tran.insertion"
InsertionPathMulti0 = { InsertionEntryMulti0.Location, InsertionLZMulti0.Location }
InsertionPathMulti1 = { InsertionEntryMulti1.Location, InsertionLZMulti1.Location }
InsertionPathMulti2 = { InsertionEntryMulti2.Location, InsertionLZMulti2.Location }
InsertionPathMulti3 = { InsertionEntryMulti3.Location, InsertionLZMulti3.Location }
StartingReinforcements = { "e6", "e1", "e1", "e1" }
Multi0bridgeTrigger = { CPos.New(23,4) }
Multi1bridgeTrigger = { CPos.New(84,6) }
Multi2bridgeTrigger = { CPos.New(23,65) }
Multi3bridgeTrigger = { CPos.New(90,71) }


SendInsertionHelicopterMulti0 = function()
	local passengers = Reinforcements.ReinforceWithTransport(Multi0, InsertionHelicopterType,
		StartingReinforcements, InsertionPathMulti0, { InsertionEntryMulti0.Location })[2]
	local e6 = passengers[1]
end
SendInsertionHelicopterMulti1 = function()
	local passengers = Reinforcements.ReinforceWithTransport(Multi1, InsertionHelicopterType,
		StartingReinforcements, InsertionPathMulti1, { InsertionEntryMulti1.Location })[2]
	local e6 = passengers[1]
end
SendInsertionHelicopterMulti2 = function()
	local passengers = Reinforcements.ReinforceWithTransport(Multi2, InsertionHelicopterType,
		StartingReinforcements, InsertionPathMulti2, { InsertionEntryMulti2.Location })[2]
	local e6 = passengers[1]
end
SendInsertionHelicopterMulti3 = function()
	local passengers = Reinforcements.ReinforceWithTransport(Multi3, InsertionHelicopterType,
		StartingReinforcements, InsertionPathMulti3, { InsertionEntryMulti3.Location })[2]
	local e6 = passengers[1]
end


InsertmcvMulti0 = function()
	-- Media.PlayMovieInRadar("movingin.vqa")
	Trigger.AfterDelay(100, function()
		Media.PlaySpeechNotification(Multi0, "Reinforce")
		Reinforcements.Reinforce(Multi0, { "mcv", "e1", "e6", "e1" }, { Mcv0Entry.Location, Mcv0Rally.Location })
	end)
end
InsertmcvMulti1 = function()
	-- Media.PlayMovieInRadar("movingin.vqa")
	Trigger.AfterDelay(100, function()
		Media.PlaySpeechNotification(Multi1, "Reinforce")
		Reinforcements.Reinforce(Multi1, { "mcv", "e1", "e6", "e1" }, { Mcv1Entry.Location, Mcv1Rally.Location })
	end)
end
InsertmcvMulti2 = function()
	-- Media.PlayMovieInRadar("movingin.vqa")
	Trigger.AfterDelay(100, function()
		Media.PlaySpeechNotification(Multi2, "Reinforce")
		Reinforcements.Reinforce(Multi2, { "mcv", "e1", "e6", "e1" }, { Mcv2Entry.Location, Mcv2Rally.Location })
	end)
end
InsertmcvMulti3 = function()
	-- Media.PlayMovieInRadar("movingin.vqa")
	Trigger.AfterDelay(100, function()
		Media.PlaySpeechNotification(Multi3, "Reinforce")
		Reinforcements.Reinforce(Multi3, { "mcv", "e1", "e6", "e1" }, { Mcv3Entry.Location, Mcv3Rally.Location })
	end)
end


InitPlayers = function()
	Multi0 = Player.GetPlayer("Multi0")
	Multi1 = Player.GetPlayer("Multi1")
	Multi2 = Player.GetPlayer("Multi2")
	Multi3 = Player.GetPlayer("Multi3")
end


WorldLoaded = function()
	InitPlayers()
	SendInsertionHelicopterMulti0()
	SendInsertionHelicopterMulti1()
	SendInsertionHelicopterMulti2()
	SendInsertionHelicopterMulti3()
	Trigger.AfterDelay(DateTime.Seconds(5), function()
		Media.DisplayMessage("Find and repair the bridge")
	end)
	Trigger.AfterDelay(DateTime.Seconds(15), function()
		Media.DisplayMessage("Dont klick when your walking over the bridge!!!")
	end)
	Trigger.OnEnteredFootprint(Multi0bridgeTrigger, function(a, id)
		if a.Owner == Multi0 then
			InsertmcvMulti0()
			Trigger.RemoveFootprintTrigger(id)
		end
	end)
	Trigger.OnEnteredFootprint(Multi1bridgeTrigger, function(a, id)
		if a.Owner == Multi1 then
			InsertmcvMulti1()
			Trigger.RemoveFootprintTrigger(id)
		end
	end)
	Trigger.OnEnteredFootprint(Multi2bridgeTrigger, function(a, id)
		if a.Owner == Multi2 then
			InsertmcvMulti2()
			Trigger.RemoveFootprintTrigger(id)
		end
	end)
	Trigger.OnEnteredFootprint(Multi3bridgeTrigger, function(a, id)
		if a.Owner == Multi3 then
			InsertmcvMulti3()
			Trigger.RemoveFootprintTrigger(id)
		end
	end)
end


Tick = function()
	if (Utils.RandomInteger(1, 200) == 10) then
		local delay = Utils.RandomInteger(1, 10)
		Lighting.Flash("LightningStrike", delay)
		Trigger.AfterDelay(delay, function()
			Media.PlaySound("thunder" .. Utils.RandomInteger(1,6) .. ".aud")
		end)
	end
	if (Utils.RandomInteger(1, 200) == 10) then
		Media.PlaySound("thunder-ambient.aud")
	end
end