-- TODO: Sometimes SF refs get left alive

-- These names need updating once the playoffs have happened.
Winners = {'Fazzz', 'Gargamel', 'Upps'}
Survivors = {'sir123', 'gg', 'toiletbreakbrb', 'Sigil', 'milkman', 'anjew', 'Mo', 'Kalion', 'Jur', 'DukeBones', 'ashleynewson', 'bete', 'Hans', 'Tailix', 'Ruckus', 'fiwo', 'spetsnaz84'}
Strikes = {['Upps'] = 2, ['sir123'] = 1, ['toiletbreakbrb'] = 1, ['Sigil'] = 1, ['anjew'] = 1, ['Kalion'] = 1}
DqPlayers = {'inno', 'jawsh'}
PrizeCount = 1
PlayerUnitType = 'e3'
InternalToSurvivorMap = {}
Finishers = {}
Eliminated = {}
WinnerUnitTypes = {'e7', 'shok', 'dog'}
MapWidth = 50
MapHeight = 50
Ended = false
WaypointCPos = {}
Barracks = {}
TimeInterval = 5
GameStage = 0
MiddleLocation = nil
MiddlePosition = nil
WinnerLocation = {}

CreateUnits = function()
    local destinationOffsets = {CPos.New(-2, -2), CPos.New(2, -2), CPos.New(0, 2)}
    for i = 1, #Survivors do
        local survivor = Survivors[i]
        local playerName = "Multi"..(i-1)
        local player = Player.GetPlayer(playerName)
        local procLocation = player.GetActorsByType('proc')[1].Location
        local playerStart = CPos.New(procLocation.X + 1, procLocation.Y + 1)
        for j = 1, 3 do
            local destination = CPos.New(playerStart.X + destinationOffsets[j].X, playerStart.Y + destinationOffsets[j].Y)
            Reinforcements.Reinforce(player, {PlayerUnitType}, {playerStart, destination})
        end
    end

    Trigger.AfterDelay(1, function()
        -- Handle strikes
        for i = 1, #Survivors do
            local survivor = Survivors[i]
            if Strikes[survivor] ~= nil then
                local playerName = "Multi"..(i-1)
                local player = Player.GetPlayer(playerName)
                local playerUnits = player.GetActorsByType(PlayerUnitType)
                for j = 1, Strikes[survivor] do
                    local playerUnit = playerUnits[j]
                    if playerUnit ~= nil and not playerUnit.IsDead then
                        playerUnit.Destroy()
                    end
                end
            end
        end
    end)
end

PickRandomPlayerUnit = function(callback)
    local allPlayerUnits = {}
    for i = 1, #Survivors do
        local playerName = "Multi"..(i-1)
        local player = Player.GetPlayer(playerName)
        local playerUnits = player.GetActorsByTypes({PlayerUnitType, "proc"})
        for j = 1, #playerUnits do
            local playerUnit = playerUnits[j]
            if playerUnit ~= nil and not playerUnit.IsDead then
                allPlayerUnits[#allPlayerUnits + 1] = playerUnit
            end
        end
    end
    return Utils.Random(allPlayerUnits)
end

ForEachLivingPlayerUnit = function(callback)
    for i = 1, #Survivors do
        local playerName = "Multi"..(i-1)
        local player = Player.GetPlayer(playerName)
        local playerUnits = player.GetActorsByType(PlayerUnitType)
        for j = 1, #playerUnits do
            local playerUnit = playerUnits[j]
            if playerUnit ~= nil and not playerUnit.IsDead then
                callback(playerUnit)
            end
        end
    end
end

ForEachWinner = function(callback)
    local creeps = Player.GetPlayer("Creeps")
    for i = 1, #Winners do
        local winner = Winners[i]
        local winnerUnits = creeps.GetActorsByType(WinnerUnitTypes[i])
        for j = 1, #winnerUnits do
            local winnerUnit = winnerUnits[j]
            if winnerUnit ~= nil and not winnerUnit.IsDead then
                callback(winnerUnit)
            end
        end
    end
end

Dist2 = function(positionA, positionB)
    local deltaX = positionA.X - positionB.X
    local deltaY = positionA.Y - positionB.Y
    return deltaX * deltaX + deltaY * deltaY
end

DisplayOtherNames = function()
    local creeps = Player.GetPlayer("Creeps")
    for i = 1, #Winners do
        local winner = Winners[i]
        local winnerUnits = creeps.GetActorsByType(WinnerUnitTypes[i])
        for j = 1, #winnerUnits do
            local winnerUnit = winnerUnits[j]
            if winnerUnit ~= nil and not winnerUnit.IsDead then
                Media.FloatingText(winner, winnerUnit.CenterPosition, 30, creeps.Color)
            end
        end
    end

    local creeps2 = Player.GetPlayer("Creeps2")
    if not TTTPPP.IsDead then
        Media.FloatingText("TTTPPP", TTTPPP.CenterPosition, 30, creeps2.Color)
    end

    for i = 1, #DqPlayers do
        local dqPlayer = DqPlayers[i]
        local dqUnit = Map.NamedActor("SF"..i)
        if dqUnit ~= nil and not dqUnit.IsDead then
            Media.FloatingText(dqPlayer, dqUnit.CenterPosition, 30, creeps2.Color)
        end
    end

    Trigger.AfterDelay(DateTime.Seconds(1), function()
        DisplayOtherNames()
    end)
end

DisplayNames = function(addTriggers)
    for i = 1, #Survivors do
        local playerName = "Multi"..(i-1)
        local player = Player.GetPlayer(playerName)
        local playerUnits = player.GetActorsByTypes({PlayerUnitType, 'proc'})
        for j = 1, #playerUnits do
            local playerUnit = playerUnits[j]
            local survivor = Survivors[i]
            InternalToSurvivorMap[playerName] = survivor
            playerUnit.GrantCondition(survivor)

            if addTriggers then
                Trigger.OnKilled(playerUnit, function(playerUnit)
                    if not Ended then
                        local remaining = player.GetActorsByTypes({PlayerUnitType, 'proc'})
                        if #remaining == 0 then
                            Media.DisplayMessage(survivor.." is dead")
                            Eliminated[#Eliminated + 1] = survivor
                            player.MarkFailedObjective(0)
                        end
                    end
                end)
            end
        end
    end
end

CheckForEnded = function()
    local remaining = {}
    for i = 1, #Survivors do
        local internalName = "Multi"..(i-1)
        local player = Player.GetPlayer(internalName)
        local playerUnits = player.GetActorsByTypes({PlayerUnitType, "proc"})
        if #playerUnits > 0 then
            remaining[#remaining + 1] = player
        end
    end
    if #remaining < 2 then
        Ended = true
        for i = 1, #remaining do
            local player = remaining[i]
            player.MarkCompletedObjective(0)
            local survivor = InternalToSurvivorMap[player.InternalName]
            Finishers[#Finishers + 1] = survivor
        end
        while #Finishers < PrizeCount do
            Finishers[#Finishers + 1] = Eliminated[#Eliminated - #Finishers + #remaining]
        end
        Media.DisplayMessage("***")
        if PrizeCount == 1 then
            Media.DisplayMessage("*** The prize winner is: "..Finishers[1])
        else
            local winners = Finishers[1]
            for i = 2, PrizeCount do
                winners = winners..", "..Finishers[i]
            end
            Media.DisplayMessage("*** The prize winners are: "..Finishers[1]..", "..Finishers[2]..", "..Finishers[3])
        end
        Media.DisplayMessage("***")
    else
        Trigger.AfterDelay(DateTime.Seconds(1), function()
            CheckForEnded()
        end)
    end
end

DisplayTimerMessages = function()
    for i = 1, TimeInterval do
        Trigger.AfterDelay(DateTime.Seconds(2 * TimeInterval - i), function()
            Media.DisplayMessage(""..(i))
        end)
    end
    Trigger.AfterDelay(DateTime.Seconds(2 * TimeInterval), function()
        Media.DisplayMessage("GO!")
        TechnicianPanic()
    end)
end

CreepAttack = function(creep)
    creep.Stance = "attackanything"
    local nearbySurvivors = Map.ActorsInCircle(creep.CenterPosition, WDist.FromCells(3), function(actor)
        return actor.Type == PlayerUnitType
    end)
    if #nearbySurvivors > 0 then
        local nearbySurvivor = nearbySurvivors[1]
        if nearbySurvivor.Type == "proc" then
            creep.Demolish(nearbySurvivor)
        else
            creep.Attack(nearbySurvivor)
        end
    else
        local playerUnit = PickRandomPlayerUnit()
        creep.AttackMove(playerUnit.Location)
    end
end

WinnerLoop = function()
    ForEachWinner(function(winnerUnit)
        CreepAttack(winnerUnit)

        -- Check for creeps that haven't moved for a long time
        local currentLocation = winnerUnit.Location
        if WinnerLocation[winnerUnit.Type] == 100 * currentLocation.X + currentLocation.Y then
            winnerUnit.Stop()
            local playerUnit = PickRandomPlayerUnit()
            winnerUnit.Stance = "defend"
            winnerUnit.AttackMove(playerUnit.Location)
        end
        WinnerLocation[winnerUnit.Type] = 100 * currentLocation.X + currentLocation.Y
    end)

    Trigger.AfterDelay(DateTime.Seconds(TimeInterval), function()
        WinnerLoop()
    end)
end

InitGameStages = function()
    MiddleLocation = TTTPPP.Location
    MiddlePosition = TTTPPP.CenterPosition

    ForEachLivingPlayerUnit(function(playerUnit)
        playerUnit.Stance = "holdfire"
        playerUnit.Wait(DateTime.Seconds(2 * TimeInterval))
    end)
    for i = 1, 25 * 5 do
        Trigger.AfterDelay(i, function()
            ForEachLivingPlayerUnit(function(playerUnit)
                playerUnit.Stop()
            end)
        end)
    end

    -- Add Special Creeps to the game.
    local creeps = Player.GetPlayer("Creeps")
    for i = 1, #WinnerUnitTypes do
        local randomLocation1 = PickRandomPlayerUnit().Location
        local randomLocation2 = PickRandomPlayerUnit().Location
        Trigger.AfterDelay(DateTime.Seconds((5 - i) * 5 * TimeInterval), function()
            local spawn = Map.CenterOfCell(Map.ClosestEdgeCell(randomLocation1)) + WVec.New(0, 0, Actor.CruiseAltitude("badr"))
            local transport = Actor.Create("badr", true, { CenterPosition = spawn, Owner = creeps, Facing = (MiddlePosition - spawn).Facing })

            local winnerUnit = Actor.Create(WinnerUnitTypes[i], false, { Owner = creeps })
            transport.LoadPassenger(winnerUnit)

            Media.PlaySpeechNotification(creeps, "ReinforcementsArrived")
            transport.Paradrop(randomLocation2)

            Trigger.OnDamaged(winnerUnit, function(creep, attacker, damage)
                creep.Stop()
                creep.Attack(attacker)
            end)

            Trigger.OnIdle(winnerUnit, function(creep)
                CreepAttack(creep)
            end)

            if winnerUnit.Type == "e7" then
                local allActors = Map.ActorsInWorld
                for j = 1, #allActors do
                    local proc = allActors[j]
                    if proc.Type == "proc" then
                        -- If Tanya near to proc
                        Trigger.OnEnteredProximityTrigger(proc.CenterPosition, WDist.FromCells(3), function(actor, id)
                            if actor.Type == "e7" then
                                actor.Stop()
                                actor.Demolish(proc)
                            end
                        end)
                    end
                end
            end
        end)
    end

    Trigger.AfterDelay(DateTime.Seconds(3 * TimeInterval), function()
        -- Start by scattering.
        ForEachLivingPlayerUnit(function(playerUnit)
            playerUnit.Scatter()
            playerUnit.Scatter()
            playerUnit.Stance = "attackanything"
        end)

        ForEachLivingPlayerUnit(function(playerUnit)
            Trigger.OnIdle(playerUnit, function(playerUnit)
                if Utils.RandomInteger(1, 2 + 1) == 1 then
                    playerUnit.Scatter()
                else
                    -- Randomly move some distance.
                    local x = playerUnit.Location.X + (2 * Utils.RandomInteger(1, 2 + 1) - 3) * Utils.RandomInteger(1, 5 + 1)
                    if x < 3 then
                        x = 3
                    elseif x > MapWidth - 2 then
                        x = MapWidth - 2
                    end
                    local y = playerUnit.Location.Y + (2 * Utils.RandomInteger(1, 2 + 1) - 3) * Utils.RandomInteger(1, 5 + 1)
                    if y < 3 then
                        y = 3
                    elseif y > MapHeight - 2 then
                        y = MapHeight - 2
                    end
                    local newLocation = CPos.New(x, y)
                    playerUnit.AttackMove(newLocation)
                end
            end)
        end)

        ForEachWinner(function(winnerUnit)
            winnerUnit.Stance = "attackanything"
        end)
        WinnerLoop()
    end)
end

TechnicianPanic = function()
    if not TTTPPP.IsDead then
        TTTPPP.Stop()
        TTTPPP.Panic()
        Trigger.AfterDelay(DateTime.Seconds(TimeInterval), TechnicianPanic)
    end
end

WorldLoaded = function()
    Survivors = Utils.Shuffle(Survivors)

    Trigger.AfterDelay(DateTime.Seconds(2 * TimeInterval), function()
        CreateUnits()

        -- Retrigger the name display
        Trigger.AfterDelay(1, function()
            DisplayNames(true)
        end)
    end)

    DisplayNames(false)
    DisplayOtherNames()

    DisplayTimerMessages()

    InitGameStages()

    CheckForEnded()
end
