function addTriggers()
	for i, passenger in pairs(Map.NamedActors) do
		if (passenger.HasProperty("HasPassengers")) then
			Trigger.OnPassengerEntered(passenger, function(transport, passenger)
				transport.Owner = passenger.Owner
			end)
			Trigger.OnPassengerExited(passenger, function(transport, passenger)
				if (not transport.HasPassengers) then
					transport.Owner = neutralGarrison
				end
			end)
		end
	end
end

function WorldLoaded()
	neutralGarrison = Player.GetPlayer("NeutralGarrison")
	addTriggers()
    rules()
end

rules = function()
    Trigger.AfterDelay(DateTime.Seconds(3), function()
        Media.DisplayMessage ("Player one: Keep 3 of the higher positions to win.", "Mission", HSLColor.Red)
        Trigger.AfterDelay(DateTime.Seconds(10), function()
            Media.DisplayMessage ("Player 2 and 3: Kick player 1 from his higher position. Capture 3 flags and hold for 8 minutes to win.", "Mission", HSLColor.Green)
        end)
    end)
end

Tick = function ()

end