
CorrinoBase = { Tow1, Tow2 }

CorrinoReinforcements =
{
	easy =
	{
		{ "light_inf_level1", "light_inf_level1" },
		{ "light_inf", "light_inf_level1", "trooper" },
		{ "light_inf", "light_inf_level1", "trooper" },
		{ "light_inf", "light_inf", "light_inf", "light_inf_level1", "light_inf_level1", "light_inf_level4" },
		{ "light_inf", "light_inf", "trooper_level1", "trooper", "trooper" },
		{ "light_inf_level1", "light_inf_level1", "trooper_level1" },
		{ "light_inf", "light_inf", "light_inf_level1", "combat_tank_h", "sardaukar", "sardaukar" },
		{ "light_inf", "light_inf_level1", "combat_tank_h", "sardaukar", "sardaukar" },
		{ "light_inf_level1", "light_inf_level1", "combat_tank_h", "sardaukar", "sardaukar" }
	},

	normal =
	{
		{ "light_inf_level1", "light_inf_level1", "light_inf_level1", "light_inf_level1" },
		{ "light_inf", "light_inf_level1", "light_inf_level1", "trooper", "sardaukar", "sardaukar" },
		{ "light_inf", "light_inf_level1", "light_inf_level1", "trooper", "sardaukar", "sardaukar" },
		{ "light_inf", "light_inf", "light_inf", "light_inf_level1", "light_inf_level1", "light_inf_level1", "light_inf_level4" },
		{ "light_inf", "light_inf", "trooper_level1", "trooper_level1", "sardaukar", "sardaukar" },
		{ "missile_tank", "quad", "siege_tank", "sardaukar", "sardaukar", "sardaukar", "sardaukar" },
		{ "light_inf_level1", "light_inf_level1", "trooper_level1", "sardaukar", "sardaukar", "trooper" },
		{ "light_inf", "light_inf", "light_inf_level1", "combat_tank_h", "combat_tank_h", "missile_tank", "mpsardaukar_level1", "mpsardaukar_level1", "mpsardaukar_level1", "mpsardaukar_level1" },
		{ "light_inf", "light_inf_level1", "trooper_level1", "combat_tank_h", "combat_tank_h", "missile_tank", "mpsardaukar_level1", "mpsardaukar_level1", "mpsardaukar_level1", "mpsardaukar_level1" },
		{ "missile_tank", "quad", "siege_tank", "sardaukar", "sardaukar", "sardaukar", "sardaukar", "sardaukar", "sardaukar", "trooper_level1", "trooper_level1" },
		{ "light_inf_level1", "light_inf_level1", "trooper_level1", "combat_tank_h", "combat_tank_h", "missile_tank", "mpsardaukar_level1", "mpsardaukar_level1", "mpsardaukar_level1", "mpsardaukar_level1" }
	},

	hard =
	{
		{ "light_inf_level1", "light_inf_level1", "light_inf_level1", "light_inf_level1", "sardaukar", "sardaukar" },
		{ "devastator", "sardaukar", "sardaukar", "sardaukar" },
		{ "light_inf", "light_inf_level1", "light_inf_level1", "trooper", "sardaukar", "sardaukar", "sardaukar", "sardaukar" },
		{ "light_inf", "light_inf_level1", "light_inf_level1", "trooper", "sardaukar", "sardaukar", "sardaukar", "sardaukar", "combat_tank_h" },
		{ "light_inf", "light_inf", "light_inf", "trooper", "light_inf_level1", "light_inf_level1", "light_inf_level4", "mpsardaukar_level1" },
		{ "devastator", "sardaukar", "sardaukar", "sardaukar", "trooper_level1", "trooper_level1" },
		{ "light_inf", "light_inf", "light_inf", "light_inf_level1", "light_inf_level1", "light_inf_level1", "light_inf_level4", "combat_tank_h" },
		{ "light_inf", "light_inf", "trooper_level1", "trooper_level1", "sardaukar", "sardaukar", "sardaukar", "sardaukar", "combat_tank_h", "combat_tank_h" },
		{ "missile_tank", "quad", "siege_tank", "sardaukar", "sardaukar", "sardaukar", "sardaukar", "sardaukar", "sardaukar", "combat_tank_h", "siege_tank", "siege_tank"  },
		{ "light_inf", "light_inf", "light_inf_level1", "combat_tank_h", "combat_tank_h", "missile_tank", "mpsardaukar_level1", "mpsardaukar_level1", "mpsardaukar_level1", "mpsardaukar_level1" },
		{ "light_inf_level1", "light_inf_level1", "trooper_level1", "sardaukar", "sardaukar", "trooper", "sardaukar", "sardaukar", "siege_tank", "missile_tank", "quad", "quad" },
		{ "devastator", "devastator", "sardaukar", "sardaukar", "sardaukar", "trooper_level1", "trooper_level1" },
		{ "light_inf", "light_inf", "light_inf_level1", "combat_tank_h", "combat_tank_h", "missile_tank", "mpsardaukar_level1", "mpsardaukar_level1", "mpsardaukar_level1", "mpsardaukar_level1" },
		{ "light_inf", "light_inf_level1", "trooper_level1", "combat_tank_h", "combat_tank_h", "missile_tank", "mpsardaukar_level1", "mpsardaukar_level1", "mpsardaukar_level1", "mpsardaukar_level1" },
		{ "light_inf", "light_inf_level1", "trooper_level1", "combat_tank_h", "combat_tank_h", "missile_tank", "mpsardaukar_level1", "mpsardaukar_level1", "mpsardaukar_level1", "mpsardaukar_level1" },
		{ "missile_tank", "quad", "siege_tank", "sardaukar", "sardaukar", "sardaukar", "sardaukar", "sardaukar", "sardaukar", "trooper_level1", "trooper_level1" },
		{ "light_inf", "light_inf", "light_inf", "trooper", "light_inf_level1", "light_inf_level1", "light_inf_level4", "combat_tank_h", "missile_tank"  },
		{ "light_inf_level1", "light_inf_level1", "trooper_level1", "combat_tank_h", "combat_tank_h", "missile_tank", "mpsardaukar_level1", "mpsardaukar_level1", "mpsardaukar_level1", "mpsardaukar_level1" }
	}
}

CorrinoPaths =
{
	{ CorrinoEntry1.Location, CorrinoRally1.Location },
	{ CorrinoEntry2.Location, CorrinoRally2.Location }
}

CorrinoAttackDelay =
{
	easy = DateTime.Minutes(4),
	normal = DateTime.Minutes(3) + DateTime.Seconds(40),
	hard = DateTime.Minutes(2) + DateTime.Seconds(50)
}

CorrinoAttackWaves =
{
	easy = 9,
	normal = 11,
	hard = 18
}

AtreidesReinforcements = { "nsfremen", "nsfremen", "nsfremen", "nsfremen", "nsfremen", "nsfremen", "nsfremen", "nsfremen", "nsfremen", "nsfremen", "nsfremen", "nsfremen", "nsfremen", "nsfremen", "nsfremen" }

AtreidesPath = { AtreidesEntry.Location, AtreidesRally.Location }

Messages =
{
	"Find-Chanis-rebels-on-the-southwest:-Paul-quest",
	"Imperial-forces-approaching",
	"Destroy-all-invasion-Harkonnen-and-Corrino-forces"
}

Tick = function()
	if Atreides.HasNoRequiredUnits() then
		Harkonnen.MarkCompletedObjective(KillAtreides)
	end

	if Harkonnen.HasNoRequiredUnits() and not Atreides.IsObjectiveCompleted(KillHarkonnen) then
		Media.DisplayMessage(UserInterface.GetFluentMessage("Harkonnen-annihilated"), Mentat)
		Atreides.MarkCompletedObjective(KillHarkonnen)
	end
end

WorldLoaded = function()
	Harkonnen = Player.GetPlayer("Harkonnen")
	Atreides = Player.GetPlayer("Atreides")
	Mercenaries = Player.GetPlayer("Mercenaries")
	Smuggler = Player.GetPlayer("Smugglers")
	Corrino = Player.GetPlayer("Corrino")

	if Difficulty == "easy" then
		Harkonnen.Cash = 1000
		Mercenaries.Cash = 500
		Atreides.Cash = 7000
	elseif Difficulty == "normal" then
		Harkonnen.Cash = 10000
		Mercenaries.Cash = 4000
		Atreides.Cash = 6000
	elseif Difficulty == "hard" then
		Harkonnen.Cash = 50000
		Mercenaries.Cash = 10000
		Atreides.Cash = 5000
	end
	
	InitObjectives(Atreides)
	KillAtreides = AddPrimaryObjective(Harkonnen, "")
	ProtectPaul = AddPrimaryObjective(Atreides, "Protect Paul Mauddib")
	KillHarkonnen = AddPrimaryObjective(Atreides, "destroy-harkonnen-forces")

	Camera.Position = APaul.CenterPosition

	Trigger.AfterDelay(DateTime.Minutes(4) + DateTime.Seconds(10), function()
		Media.DisplayMessage(Messages[1], Mentat)
	end)

	Trigger.OnKilled(APaul, function()
		Atreides.MarkFailedObjective(ProtectPaul)
	end)

	Trigger.OnKilled(CTrooper1, function()
		Media.PlaySpeechNotification(Atreides, "Reinforce")
		Media.DisplayMessage(Messages[3], Mentat)
		Reinforcements.Reinforce(Atreides, AtreidesReinforcements, AtreidesPath)
	end)

	Trigger.OnAllKilled(CorrinoBase, function()
		Utils.Do(Corrino.GetGroundAttackers(), IdleHunt)
		Atreides.MarkCompletedObjective(ProtectPaul)
	end)

	local path = function() return CorrinoPaths[1] end
	SendCarryallReinforcements(Corrino, 1, CorrinoAttackWaves[Difficulty], CorrinoAttackDelay[Difficulty], path, CorrinoReinforcements[Difficulty], waveCondition)

	local path = function() return CorrinoPaths[2] end
	SendCarryallReinforcements(Corrino, 2, CorrinoAttackWaves[Difficulty], CorrinoAttackDelay[Difficulty], path, CorrinoReinforcements[Difficulty], waveCondition)

	local path = function() return HarkonnenPaths[1] end
	SendCarryallReinforcements(Harkonnen, 1, HarkonnenAttackWaves[Difficulty], HarkonnenAttackDelay[Difficulty], path, HarkonnenReinforcements[Difficulty], waveCondition)

	local path = function() return HarkonnenPaths[2] end
	SendCarryallReinforcements(Harkonnen, 2, HarkonnenAttackWaves[Difficulty], HarkonnenAttackDelay[Difficulty], path, HarkonnenReinforcements[Difficulty], waveCondition)
	
	Actor.Create("upgrade.barracks", true, { Owner = Corrino })
end

HarkonnenReinforcements =
{
	easy =
	{
		{ "light_inf", "trooper" },
		{ "light_inf", "trooper", "sardaukar", "combat_tank_h" },
		{ "light_inf", "light_inf", "light_inf", "trooper", "trooper" }
	},

	normal =
	{
		{ "light_inf", "light_inf_level1" },
		{ "light_inf", "light_inf_level1", "trooper" },
		{ "light_inf", "light_inf", "light_inf", "trooper", "light_inf_level1" },
		{ "light_inf", "light_inf", "trooper", "sardaukar", "sardaukar", "combat_tank_h" },
		{ "light_inf", "light_inf", "light_inf", "sardaukar", "sardaukar", "combat_tank_h" },
		{ "light_inf", "light_inf_level1", "sardaukar", "sardaukar", "sardaukar", "combat_tank_h", "siege_tank" }
	},

	hard =
	{
		{ "light_inf_level1", "light_inf_level1" },
		{ "light_inf", "light_inf_level1", "light_inf_level1" },
		{ "combat_tank_h", "light_inf_level1", "light_inf_level1", "light_inf_level1" },
		{ "combat_tank_h", "combat_tank_h", "combat_tank_h", "light_inf_level1", "light_inf_level1", "light_inf_level4" },
		{ "combat_tank_h", "light_inf", "light_inf", "light_inf_level1", "light_inf_level1", "light_inf_level4", "sardaukar" },
		{ "light_inf_level1", "light_inf_level1", "trooper_level1", "combat_tank_h", "missile_tank", "sardaukar", "sardaukar", "combat_tank_h" },
		{ "siege_tank", "light_inf", "light_inf_level1", "trooper_level1", "trooper", "trooper", "sardaukar", "sardaukar", "sardaukar", "combat_tank_h" },
		{ "siege_tank", "light_inf_level1", "light_inf", "light_inf", "light_inf_level1", "combat_tank_h", "sardaukar", "sardaukar", "sardaukar", "combat_tank_h" },
		{ "light_inf_level1", "light_inf_level1", "light_inf_level1", "light_inf_level1", "siege_tank", "missile_tank", "sardaukar", "sardaukar", "sardaukar", "combat_tank_h" }
	}
}

HarkonnenPaths =
{
	{ HarkonnenEntry1.Location, HarkonnenRally2.Location },
	{ HarkonnenEntry2.Location, HarkonnenRally1.Location }
}

HarkonnenAttackDelay =
{
	easy = DateTime.Minutes(8) + DateTime.Seconds(45),
	normal = DateTime.Minutes(7) + DateTime.Seconds(30),
	hard = DateTime.Minutes(6) + DateTime.Seconds(15)
}

HarkonnenAttackWaves =
{
	easy = 3,
	normal = 6,
	hard = 9
}


	




