
AttackGroupSize =
{
	easy = 7,
	normal = 9,
	hard = 11
}
AttackDelays =
{
	easy = { DateTime.Minutes(2), DateTime.Seconds(10) },
	normal = { DateTime.Minutes(1), DateTime.Seconds(45) },
	hard = { DateTime.Minutes(1), DateTime.Seconds(10) }
}

HarkonnenInfantryTypes = { "light_inf", "light_inf", "light_inf","light_inf", "trooper" }

InitAIUnits = function()
	IdlingUnits[Harkonnen] = { }
	IdlingUnits[Mercenaries] = { }
	
	DefendAndRepairBase(Harkonnen, HarkonnenBase, 0.75, AttackGroupSize[Difficulty])
	DefendAndRepairBase(Mercenaries, MercenariesBase, 0.75, AttackGroupSize[Difficulty])
end

ActivateAI = function()
	IdlingUnits[Harkonnen] = { }
	IdlingUnits[Mercenaries] = { }
	DefendAndRepairBase(Harkonnen, HarkonnenBase, 0.75, AttackGroupSize[Difficulty])
	DefendAndRepairBase(Mercenaries, MercenariesBase, 0.75, AttackGroupSize[Difficulty])
		
	local delay = function() return Utils.RandomInteger(AttackDelays[Difficulty][1], AttackDelays[Difficulty][2] + 1) end
	local infantryToBuild = function() return { Utils.Random(HarkonnenInfantryTypes) } end
	local attackThresholdSize = AttackGroupSize[Difficulty] * 2.5

	-- Finish the upgrades first before trying to build something
	Trigger.AfterDelay(DateTime.Seconds(14), function()
		ProduceUnits(Harkonnen, HBarracks, delay, infantryToBuild, AttackGroupSize[Difficulty], attackThresholdSize)
	end)
end

