
HarkonnenReinforcements =
{
	easy =
	{
		{ "light_inf", "trooper" },
		{ "light_inf", "trooper", "sardaukar" },
		{ "light_inf", "light_inf", "light_inf", "trooper", "trooper" }
	},

	normal =
	{
		{ "light_inf", "light_inf_level1" },
		{ "light_inf", "light_inf_level1", "trooper" },
		{ "light_inf", "light_inf", "light_inf", "trooper", "light_inf_level1" },
		{ "light_inf", "light_inf", "trooper", "sardaukar", "sardaukar" },
		{ "light_inf", "light_inf", "light_inf", "sardaukar", "sardaukar" },
		{ "light_inf", "light_inf_level1", "sardaukar", "sardaukar", "sardaukar" }
	},

	hard =
	{
		{ "light_inf_level1", "light_inf_level1" },
		{ "light_inf", "light_inf_level1", "light_inf_level1" },
		{ "light_inf", "light_inf_level1", "light_inf_level1", "light_inf_level1" },
		{ "light_inf", "light_inf", "light_inf", "light_inf_level1", "light_inf_level1", "light_inf_level4" },
		{ "light_inf", "light_inf", "light_inf", "light_inf_level1", "light_inf_level1", "light_inf_level4", "sardaukar" },
		{ "light_inf_level1", "light_inf_level1", "trooper_level1", "combat_tank_h", "missile_tank", "sardaukar", "sardaukar" },
		{ "light_inf", "light_inf", "light_inf_level1", "trooper_level1", "trooper", "trooper", "sardaukar", "sardaukar", "sardaukar" },
		{ "light_inf", "light_inf_level1", "light_inf", "light_inf", "light_inf_level1", "combat_tank_h", "sardaukar", "sardaukar", "sardaukar" },
		{ "light_inf_level1", "light_inf_level1", "light_inf_level1", "light_inf_level1", "sardaukar", "sardaukar", "sardaukar", "sardaukar", "sardaukar" }
	}
}

HarkonnenPaths =
{
	{ HarkonnenEntry1.Location, HarkonnenRally2.Location },
	{ HarkonnenEntry2.Location, HarkonnenRally1.Location },
	{ HarkonnenEntry4.Location, HarkonnenRally3.Location },
	{ HarkonnenEntry3.Location, HarkonnenRally4.Location }
}

HarkonnenAttackDelay =
{
	easy = DateTime.Minutes(8) + DateTime.Seconds(45),
	normal = DateTime.Minutes(7) + DateTime.Seconds(30),
	hard = DateTime.Minutes(6) + DateTime.Seconds(15)
}

HarkonnenAttackWaves =
{
	easy = 3,
	normal = 6,
	hard = 9
}

AtreidesReinforcements =
{
	{ "trike", "quad", "trike", "combat_tank_a", "combat_tank_a" },
	{ "light_inf", "light_inf", "light_inf", "light_inf", "engineer", "trooper", "trooper", "nsfremen", "nsfremen", "nsfremen" }
}

AtreidesPath = { AtreidesEntry.Location, AtreidesRally.Location }


Messages =
{
	"Search-for-the-Fremen-groups",
	"Attack-Smugglers-base-on-the-southwest",
	"Imperial-forces-approaching"
}

Tick = function()
	if Atreides.HasNoRequiredUnits() then
		Harkonnen.MarkCompletedObjective(KillAtreides)
	end

	if Harkonnen.HasNoRequiredUnits() and not Atreides.IsObjectiveCompleted(KillHarkonnen) then
		Media.DisplayMessage(UserInterface.GetFluentMessage("harkonnen-annihilated"), Mentat)
		Atreides.MarkCompletedObjective(KillHarkonnen)
	end
end

WorldLoaded = function()
	Harkonnen = Player.GetPlayer("Harkonnen")
	Atreides = Player.GetPlayer("Atreides")
	Mercenaries = Player.GetPlayer("Mercenaries")
	Smuggler = Player.GetPlayer("Smuggler")

	if Difficulty == "easy" then
		Harkonnen.Cash = 50
		Atreides.Cash = 8000
	elseif Difficulty == "normal" then
		Harkonnen.Cash = 4000
		Atreides.Cash = 6000
	elseif Difficulty == "hard" then
		Harkonnen.Cash = 15000
		Atreides.Cash = 4000
	end
	
	InitObjectives(Atreides)
	KillAtreides = AddPrimaryObjective(Harkonnen, "")
	KillHarkonnen = AddPrimaryObjective(Atreides, "destroy-harkonnen-forces")

	Camera.Position = AOfficer.CenterPosition

	Trigger.AfterDelay(DateTime.Minutes(0) + DateTime.Seconds(30), function()
		Media.DisplayMessage(Messages[1], Mentat)
	end)
	Trigger.AfterDelay(DateTime.Minutes(1) + DateTime.Seconds(30), function()
		Media.DisplayMessage(Messages[2], Mentat)
	end)
	Trigger.AfterDelay(DateTime.Minutes(5) + DateTime.Seconds(30), function()
		Media.DisplayMessage(Messages[3], Mentat)
	end)

	local path = function() return HarkonnenPaths[1] end
	SendCarryallReinforcements(Harkonnen, 4, HarkonnenAttackWaves[Difficulty], HarkonnenAttackDelay[Difficulty], path, HarkonnenReinforcements[Difficulty], waveCondition)

	local path = function() return HarkonnenPaths[2] end
	SendCarryallReinforcements(Harkonnen, 4, HarkonnenAttackWaves[Difficulty], HarkonnenAttackDelay[Difficulty], path, HarkonnenReinforcements[Difficulty], waveCondition)
	
	local path = function() return HarkonnenPaths[3] end
	SendCarryallReinforcements(Harkonnen, 4, HarkonnenAttackWaves[Difficulty], HarkonnenAttackDelay[Difficulty], path, HarkonnenReinforcements[Difficulty], waveCondition)
	
	local path = function() return HarkonnenPaths[4] end
	SendCarryallReinforcements(Harkonnen, 0, HarkonnenAttackWaves[Difficulty], HarkonnenAttackDelay[Difficulty], path, HarkonnenReinforcements[Difficulty], waveCondition)
	
	Trigger.AfterDelay(DateTime.Minutes(6), function()
		Media.PlaySpeechNotification(Atreides, "Reinforce")
		Reinforcements.Reinforce(Atreides, AtreidesReinforcements[1], AtreidesPath)
	end)
	Trigger.AfterDelay(DateTime.Minutes(12) + DateTime.Seconds(40), function()
		Media.PlaySpeechNotification(Atreides, "Reinforce")
		Reinforcements.Reinforce(Atreides, AtreidesReinforcements[2], AtreidesPath)
	end)
end




