SmugglerBase = { SBarracks, SPower1, SPower2 }

OrdosReinforcements =
{
	easy =
	{
		{ "light_inf", "raider", "trooper" },
		{ "light_inf", "grenadier" },
		{ "light_inf", "light_inf", "trooper", "light_inf_level1", "raider" },
		{ "light_inf", "raider", "trooper", "trooper", "light_inf", "light_inf", "saboteur", },
		{ "light_inf", "light_inf", "light_inf", "trooper", "saboteur" }
	},

	normal =
	{
		{ "light_inf", "raider", "trooper" },
		{ "light_inf", "light_inf", "raider", "raider" },
		{ "light_inf", "light_inf", "light_inf", "trooper", "saboteur" },
		{ "light_inf", "light_inf", "trooper", "raider", "trooper", "saboteur" },
		{ "light_inf", "light_inf", "trooper", "trooper", "trooper", "saboteur" },
		{ "light_inf", "light_inf", "light_inf", "grenadier", "trooper", "saboteur" },
		{ "light_inf", "raider", "trooper", "grenadier", "combat_tank_o", "combat_tank_o" },
		{ "light_inf", "light_inf", "light_inf", "light_inf", "trooper", "trooper", "combat_tank_o" },
		{ "raider", "raider", "trooper", "trooper", "light_inf", "light_inf", "grenadier", "grenadier", "saboteur" }
	},

	hard =
	{
		{ "light_inf", "raider", "trooper" },
		{ "light_inf", "light_inf", "raider", "raider" },
		{ "light_inf", "light_inf", "light_inf", "trooper", "saboteur" },
		{ "light_inf", "light_inf", "trooper", "raider", "trooper", "saboteur" },
		{ "light_inf", "light_inf", "trooper", "trooper", "trooper", "saboteur" },
		{ "light_inf", "light_inf", "light_inf", "grenadier", "trooper", "saboteur" },
		{ "light_inf", "light_inf", "trooper", "grenadier", "combat_tank_o", "combat_tank_o" },
		{ "light_inf", "light_inf", "light_inf", "light_inf", "trooper", "trooper", "combat_tank_o" },
		{ "raider", "raider", "trooper", "trooper", "light_inf", "light_inf", "grenadier", "grenadier", "saboteur" },
		{ "trooper", "trooper", "light_inf", "raider", "combat_tank_o", "light_inf", "light_inf", "light_inf_level1", "light_inf_level1", "light_inf_level1", "light_inf_level4" },
		{ "light_inf", "light_inf", "light_inf", "raider", "raider", "light_inf", "light_inf", "light_inf", "light_inf", "saboteur", "saboteur", "grenadier_level1", "grenadier_level1" },
		{ "light_inf", "light_inf", "trooper", "trooper", "combat_tank_o", "light_inf_level1", "light_inf_level1", "light_inf_level1", "light_inf_level4", "light_inf_level1", "light_inf_level1", "light_inf_level4" },
		{ "raider", "raider", "trooper", "trooper", "light_inf", "light_inf", "grenadier", "light_inf_level4", "light_inf_level1", "light_inf_level1", "light_inf_level4", "saboteur" },
		{ "light_inf", "light_inf", "light_inf", "raider", "raider", "light_inf_level1", "light_inf_level1", "light_inf_level1", "light_inf_level4", "grenadier_level1", "grenadier_level1" },
		{ "light_inf", "raider", "light_inf", "trooper", "trooper", "combat_tank_o", "light_inf_level1", "light_inf_level1", "light_inf_level1", "light_inf_level4", "grenadier_level1" },
		{ "raider", "raider", "raider", "combat_tank_o", "light_inf_level1", "light_inf_level1", "light_inf_level1", "light_inf_level4", "grenadier_level1", "grenadier_level1", "grenadier_level1" }
	}
}

OrdosAttackDelay =
{
	easy = DateTime.Minutes(5),
	normal = DateTime.Minutes(4) + DateTime.Seconds(10),
	hard = DateTime.Minutes(3) + DateTime.Seconds(20)
}

OrdosAttackWaves =
{
	easy = 5,
	normal = 9,
	hard = 16
}

InitialOrdosReinforcements = { "light_inf", "light_inf", "grenadier", "trooper" }

OrdosPaths =
{
	{ OrdosEntry1.Location, OrdosRally1.Location },
	{ OrdosEntry2.Location, OrdosRally2.Location },
	{ OrdosEntry3.Location, OrdosRally3.Location },
	{ OrdosEntry4.Location, OrdosRally4.Location },
}

AtreidesReinforcements =
{
	{ "trooper", "trooper", "light_inf", "light_inf", "light_inf", "light_inf_level1", "light_inf_level1", "light_inf_level4", "engineer", "nsfremen", "nsfremen", "nsfremen", "nsfremen" },
	{ "trike", "trike", "combat_tank_a", "combat_tank_a", "quad", "sonic_tank" }
}

AtreidesPath = { AtreidesEntry.Location, AtreidesRally.Location }

Messages =
{
	"Destroy-last-Ordos-mercenary-alliance-on-the-south",
	"Beware-for-dirty-fighting-of-the-assassin-guild",
	"Imperial-forces-approaching"
}

Tick = function()
	if Atreides.HasNoRequiredUnits() then
		Ordos.MarkCompletedObjective(KillAtreides)
	end

	if Ordos.HasNoRequiredUnits() and not Atreides.IsObjectiveCompleted(KillOrdos) then
		Media.DisplayMessage(UserInterface.GetFluentMessage("ordos-annihilated"), Mentat)
		Atreides.MarkCompletedObjective(KillOrdos)
	end
end

WorldLoaded = function()
	Ordos = Player.GetPlayer("Ordos")
	Atreides = Player.GetPlayer("Atreides")
	Mercenaries = Player.GetPlayer("Mercenaries")
	Smuggler = Player.GetPlayer("Smugglers")

	if Difficulty == "easy" then
		Ordos.Cash = 3000
		Mercenaries.Cash = 1000
		Atreides.Cash = 13000
	elseif Difficulty == "normal" then
		Ordos.Cash = 9000
		Mercenaries.Cash = 4000
		Atreides.Cash = 10000
	elseif Difficulty == "hard" then
		Ordos.Cash = 35000
		Mercenaries.Cash = 10000
		Atreides.Cash = 8000
	end

	InitObjectives(Atreides)
	KillAtreides = AddPrimaryObjective(Ordos, "")
	KillOrdos = AddPrimaryObjective(Atreides, "destroy-ordos-forces")

	Camera.Position = AConyard.CenterPosition

	Trigger.OnAllKilled(SmugglerBase, function()
		Utils.Do(Smuggler.GetGroundAttackers(), IdleHunt)
	
	end)

	local path = function() return OrdosPaths[1] end
	SendCarryallReinforcements(Ordos, 2, OrdosAttackWaves[Difficulty], OrdosAttackDelay[Difficulty], path, OrdosReinforcements[Difficulty], waveCondition)

	local path = function() return OrdosPaths[2] end
	SendCarryallReinforcements(Ordos, 4, OrdosAttackWaves[Difficulty], OrdosAttackDelay[Difficulty], path, OrdosReinforcements[Difficulty], waveCondition)
	
	local path = function() return OrdosPaths[3] end
	SendCarryallReinforcements(Ordos, 6, OrdosAttackWaves[Difficulty], OrdosAttackDelay[Difficulty], path, OrdosReinforcements[Difficulty], waveCondition)
	
	local path = function() return OrdosPaths[4] end
	SendCarryallReinforcements(Ordos, 8, OrdosAttackWaves[Difficulty], OrdosAttackDelay[Difficulty], path, OrdosReinforcements[Difficulty], waveCondition)

	Trigger.AfterDelay(DateTime.Minutes(1) + DateTime.Seconds(30), function()
		Media.DisplayMessage(Messages[2], Mentat)
	end)

	Trigger.AfterDelay(DateTime.Minutes(10) + DateTime.Seconds(10), function()
		Media.DisplayMessage(Messages[1], Mentat)
	end)

	Trigger.AfterDelay(DateTime.Minutes(25) + DateTime.Seconds(10), function()
		Media.DisplayMessage(Messages[1], Mentat)
	end)

	Trigger.AfterDelay(DateTime.Minutes(45) + DateTime.Seconds(10), function()
		Media.DisplayMessage(Messages[1], Mentat)
	end)

	Trigger.AfterDelay(DateTime.Minutes(10), function()
		Media.PlaySpeechNotification(Atreides, "Reinforce")
		Reinforcements.Reinforce(Atreides, AtreidesReinforcements[1], AtreidesPath)
	end)
	Trigger.AfterDelay(DateTime.Minutes(20) + DateTime.Seconds(40), function()
		Media.PlaySpeechNotification(Atreides, "Reinforce")
		Reinforcements.Reinforce(Atreides, AtreidesReinforcements[2], AtreidesPath)
	end)
end