
OrdosBase = { OIX }
SmugglerBase = { STurret1 }

OrdosReinforcements =
{
	easy =
	{
		{ "light_inf", "raider", "trooper" },
		{ "light_inf", "grenadier" },
		{ "light_inf", "light_inf", "trooper", "light_inf_level1", "raider" },
		{ "light_inf", "raider", "trooper", "trooper", "light_inf", "light_inf" },
		{ "light_inf", "light_inf", "light_inf", "trooper", "saboteur" }
	},

	normal =
	{
		{ "light_inf", "raider", "trooper" },
		{ "light_inf", "light_inf", "raider", "raider" },
		{ "light_inf", "light_inf", "light_inf", "trooper", },
		{ "light_inf", "light_inf", "trooper", "raider", "trooper" },
		{ "light_inf", "light_inf", "trooper", "trooper", "trooper" },
		{ "light_inf", "light_inf", "light_inf", "grenadier", "trooper", "saboteur" },
		{ "light_inf", "raider", "trooper", "grenadier", "combat_tank_o", "combat_tank_o" },
		{ "light_inf", "light_inf", "light_inf", "light_inf", "trooper", "trooper", "combat_tank_o" },
		{ "raider", "raider", "trooper", "trooper", "light_inf", "light_inf", "grenadier", "grenadier", "saboteur" }
	},

	hard =
	{
		{ "light_inf", "raider", "trooper" },
		{ "light_inf", "light_inf", "raider", "raider" },
		{ "light_inf", "light_inf", "light_inf", "trooper", "saboteur" },
		{ "light_inf", "light_inf", "trooper", "raider", "trooper" },
		{ "light_inf", "light_inf", "trooper", "trooper", "trooper" },
		{ "light_inf", "light_inf", "light_inf", "grenadier", "trooper", "saboteur" },
		{ "light_inf", "light_inf", "trooper", "grenadier", "combat_tank_o", "combat_tank_o" },
		{ "light_inf", "light_inf", "light_inf", "light_inf", "trooper", "trooper", "combat_tank_o" },
		{ "raider", "raider", "trooper", "trooper", "light_inf", "light_inf", "grenadier", "grenadier", "saboteur" },
		{ "trooper", "trooper", "light_inf", "raider", "combat_tank_o", "light_inf", "light_inf", "light_inf_level1", "light_inf_level1", "light_inf_level1", "light_inf_level4" },
		{ "light_inf", "light_inf", "light_inf", "raider", "raider", "light_inf", "light_inf", "light_inf", "light_inf", "grenadier_level1", "grenadier_level1" },
		{ "light_inf", "light_inf", "trooper", "trooper", "combat_tank_o", "light_inf_level1", "light_inf_level1", "light_inf_level1", "light_inf_level4", "light_inf_level1", "light_inf_level1", "light_inf_level4" },
		{ "raider", "raider", "trooper", "trooper", "light_inf", "light_inf", "grenadier", "light_inf_level4", "light_inf_level1", "light_inf_level1", "light_inf_level4", },
		{ "light_inf", "light_inf", "light_inf", "raider", "raider", "light_inf_level1", "light_inf_level1", "light_inf_level1", "light_inf_level4", "grenadier_level1", "grenadier_level1" },
		{ "light_inf", "raider", "light_inf", "trooper", "trooper", "combat_tank_o", "light_inf_level1", "light_inf_level1", "light_inf_level1", "light_inf_level4", "grenadier_level1" },
		{ "raider", "raider", "raider", "combat_tank_o", "light_inf_level1", "light_inf_level1", "light_inf_level1", "light_inf_level4", "grenadier_level1", "grenadier_level1", "grenadier_level1" }
	}
}

OrdosAttackDelay =
{
	easy = DateTime.Minutes(5),
	normal = DateTime.Minutes(4) + DateTime.Seconds(10),
	hard = DateTime.Minutes(2) + DateTime.Seconds(40)
}

OrdosAttackWaves =
{
	easy = 5,
	normal = 8,
	hard = 16
}

ToHarvest =
{
	easy = 5000,
	normal = 6000,
	hard = 7000
}

InitialOrdosReinforcements = { "light_inf", "light_inf", "raider", "raider", "trooper", "trooper" }
InitialSmugglersReinforcements = { "light_inf", "light_inf", "trooper" }


OrdosPaths =
{
	{ OrdosEntry1.Location, OrdosRally1.Location },
	{ OrdosEntry2.Location, OrdosRally2.Location },
	{ OrdosEntry3.Location, OrdosRally3.Location },
	{ OrdosEntry4.Location, OrdosRally4.Location },
}

AtreidesReinforcements = { "trike", "trike", "trooper", "light_inf", "engineer" }
AtreidesPath = { AtreidesEntry.Location, AtreidesRally.Location }

Messages =
{
	"Capture-the-Ixian-technology-center",
	"Imperial-forces-approaching"
}


Tick = function()
	if Atreides.HasNoRequiredUnits() then
		Ordos.MarkCompletedObjective(KillAtreides)
	end

	if Ordos.HasNoRequiredUnits() and not Atreides.IsObjectiveCompleted(KillOrdos) then
		Media.DisplayMessage(UserInterface.GetFluentMessage("ordos-annihilated"), Mentat)
		Atreides.MarkCompletedObjective(KillOrdos)
	end
end

WorldLoaded = function()
	Ordos = Player.GetPlayer("Ordos")
	Atreides = Player.GetPlayer("Atreides")
	Mercenaries = Player.GetPlayer("Mercenaries")
	Smuggler = Player.GetPlayer("Smugglers")

	InitObjectives(Atreides)
	KillAtreides = AddPrimaryObjective(Ordos, "")
	CaptureIX = AddPrimaryObjective(Atreides, "capture IX technology center")
	
	Camera.Position = AConyard.CenterPosition

	Trigger.AfterDelay(DateTime.Minutes(28) + DateTime.Seconds(10), function()
		Media.DisplayMessage(Messages[1], Mentat)
	end)

	Trigger.AfterDelay(DateTime.Minutes(46) + DateTime.Seconds(20), function()
		Media.DisplayMessage(Messages[1], Mentat)
	end)

	Trigger.AfterDelay(DateTime.Minutes(56) + DateTime.Seconds(20), function()
		Media.DisplayMessage(Messages[1], Mentat)
	end)

	local path = function() return OrdosPaths[1] end
	SendCarryallReinforcements(Ordos, 2, OrdosAttackWaves[Difficulty], OrdosAttackDelay[Difficulty], path, OrdosReinforcements[Difficulty], waveCondition)

	local path = function() return OrdosPaths[2] end
	SendCarryallReinforcements(Ordos, 4, OrdosAttackWaves[Difficulty], OrdosAttackDelay[Difficulty], path, OrdosReinforcements[Difficulty], waveCondition)
	
	local path = function() return OrdosPaths[3] end
	SendCarryallReinforcements(Ordos, 6, OrdosAttackWaves[Difficulty], OrdosAttackDelay[Difficulty], path, OrdosReinforcements[Difficulty], waveCondition)
	
	local path = function() return OrdosPaths[4] end
	SendCarryallReinforcements(Ordos, 8, OrdosAttackWaves[Difficulty], OrdosAttackDelay[Difficulty], path, OrdosReinforcements[Difficulty], waveCondition)

	Trigger.OnKilled(OIX, function()
		Atreides.MarkFailedObjective(CaptureIX)
	end)
	
	Trigger.OnCapture(OIX, function()
		Media.DisplayMessage(UserInterface.GetFluentMessage("hostages-released"), Mentat)
		Atreides.MarkCompletedObjective(CaptureIX)
		end)
	end
	
