
PlayerCanLose = false
TOADead = false
TOA2Dead = false
TOA3Dead = false
MorelliDead = false
McNeilDead = false
PrototypesDestroyed = false

ActorRemovals = {
  easy = { MMK26, MMK27 },
  normal = { NRM1, NRM2, MMK27 },
  hard = { NRM1, NRM2, HRM1, HRM2 },
}


-- TOA Attack Production Behavior -----

TOAAttackDelayMin = { easy = DateTime.Seconds(45), normal = DateTime.Seconds(30), hard = DateTime.Seconds(25) }
TOAAttackDelayMax = { easy = DateTime.Seconds(60), normal = DateTime.Seconds(45), hard = DateTime.Seconds(30) }

TOAAirAttackDelayMin = { easy = DateTime.Seconds(270), normal = DateTime.Seconds(210), hard = DateTime.Seconds(180) }
TOAAirAttackDelayMax = { easy = DateTime.Seconds(300), normal = DateTime.Seconds(240), hard = DateTime.Seconds(210) }


TOAAttackVehicleTypes = {
  easy = {
     { "jeep", "jeep", "mtnk", "mtnk" },
     { "jeep", "jeep", "mtnk", "mtnk", "msam" },
     { "mtnk", "mtnk", "mtnk", "mtnk" },
     { "mtnk", "mtnk", "mtnk", "msam", "msam" },
     { "htnk", "htnk", "htnk" },
     { "htnk", "htnk", "msam", "msam" },
     { "exosuit", "exosuit", "exosuit" },
  },
  normal = {
     { "jeep", "jeep", "jeep", "mtnk", "mtnk", "mtnk" },
     { "jeep", "jeep", "mtnk", "mtnk", "msam", "msam" },
     { "mtnk", "mtnk", "mtnk", "mtnk", "mtnk", "mtnk" },
     { "mtnk", "mtnk", "mtnk", "mtnk", "msam", "msam" },
     { "htnk", "htnk", "htnk", "htnk" },
     { "htnk", "htnk", "htnk", "msam", "msam" },
     { "exosuit", "exosuit", "exosuit", "exosuit" },
  },
  hard = {
     { "jeep", "jeep", "jeep", "mtnk", "mtnk", "mtnk", "mtnk" },
     { "jeep", "jeep", "mtnk", "mtnk", "msam", "msam", "msam" },
     { "mtnk", "mtnk", "mtnk", "mtnk", "mtnk", "mtnk", "mtnk" },
     { "mtnk", "mtnk", "mtnk", "mtnk", "msam", "msam", "msam" },
     { "htnk", "htnk", "htnk", "htnk", "htnk" },
     { "htnk", "htnk", "htnk", "msam", "msam", "msam" },
     { "exosuit", "exosuit", "exosuit", "exosuit", "exosuit" },
  }
}

TOA23AttackVehicleTypes = {
  easy = {
     { "jeep", "jeep", "mtnk", "mtnk" },
     { "jeep", "jeep", "mtnk", "mtnk", "msam" },
     { "mtnk", "mtnk", "mtnk", "mtnk" },
     { "mtnk", "mtnk", "mtnk", "msam", "msam" },
  },
  normal = {
     { "jeep", "jeep", "jeep", "mtnk", "mtnk", "mtnk" },
     { "jeep", "jeep", "mtnk", "mtnk", "msam", "msam" },
     { "mtnk", "mtnk", "mtnk", "mtnk", "mtnk", "mtnk" },
     { "mtnk", "mtnk", "mtnk", "mtnk", "msam", "msam" },
  },
  hard = {
     { "jeep", "jeep", "jeep", "mtnk", "mtnk", "mtnk", "mtnk" },
     { "jeep", "jeep", "mtnk", "mtnk", "msam", "msam", "msam" },
     { "mtnk", "mtnk", "mtnk", "mtnk", "mtnk", "mtnk", "mtnk" },
     { "mtnk", "mtnk", "mtnk", "mtnk", "msam", "msam", "msam" },
  }
}

TOAAttackInfantryTypes ={
  easy = {
     { "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1" },
     { "e2", "e2", "e2", "e2", "e2", "e2", "e2", "e2" },
     { "e3", "e3", "e3", "e3", "e3", "e3", "e3", "e3" },
     { "e1", "e1", "e1", "e1", "e3", "e3", "e3", "e3" },
  },
  normal = {
     { "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1" },
     { "e2", "e2", "e2", "e2", "e2", "e2", "e2", "e2", "e2", "e2" },
     { "e3", "e3", "e3", "e3", "e3", "e3", "e3", "e3", "e3", "e3" },
     { "e1", "e1", "e1", "e1", "e1", "e3", "e3", "e3", "e3", "e3" },
  },
  hard = {
     { "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1" },
     { "e2", "e2", "e2", "e2", "e2", "e2", "e2", "e2", "e2", "e2", "e2", "e2", "e2", "e2", "e2" },
     { "e3", "e3", "e3", "e3", "e3", "e3", "e3", "e3", "e3", "e3", "e3", "e3", "e3", "e3", "e3" },
     { "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e3", "e3", "e3", "e3", "e3", "e3", "e3" },
  }
}

TOAAttackAirTypes = {
  easy = {
     { "orca", },
  },
  normal = {
     { "orcad" },
  },
  hard = {
     { "orcad" },
  }
}

TOAAttackPaths = {
  { TOAAtk1A.Location, TOAAtk1B.Location },
  { TOAAtk2A.Location, TOAAtk2B.Location },
}


AiAttackProduction = function(player, paths, productionOptions, factoryType)
  local production = Utils.Random(productionOptions[Difficulty])
  local path = Utils.Random(paths)
  local toBuild = function() return production end
  local factory = GetAvailableFactory(player, factoryType)
  
  if factory ~= nil then
    ProduceUnits(player, factory, nil, toBuild, function(units)
      UpdatePlayerBaseLocation()
      Utils.Do(units, function(unit)
        ErrorGuardAttackPatrol(unit, path)
        AssaultPlayerBaseOrHunt(unit)
      end)
      
      Trigger.AfterDelay(Utils.RandomInteger(TOAAttackDelayMin[Difficulty], TOAAttackDelayMax[Difficulty]), function()
        AiAttackProduction(player, paths, productionOptions, factoryType)
      end)
    end)
  else
    Trigger.AfterDelay(Utils.RandomInteger(TOAAttackDelayMin[Difficulty], TOAAttackDelayMax[Difficulty]), function()
      AiAttackProduction(player, paths, productionOptions, factoryType)
    end)
  end
end


AiAirAttackProduction = function(player, productionOptions)
  local production = Utils.Random(productionOptions[Difficulty])
  local factories = player.GetActorsByType('hpad')
  local airMax = 4
  if Difficulty == 'hard' then airMax = 6 end
  
  if #factories > 0 then
    Utils.Do(factories, function(factory)
      local aircraft = player.GetActorsByTypes({'orca', 'orcad'})
      if #aircraft < airMax then
        Reinforcements.Reinforce(player, production, { factory.Location }, 30, function(unit)
          --
        end)
      end
    end)
  end
  Trigger.AfterDelay(Utils.RandomInteger(TOAAirAttackDelayMin[Difficulty], TOAAirAttackDelayMax[Difficulty]), function()
    AiAirAttackProduction(player, productionOptions)
  end)
end


TOA2McNeilAttackPaths = {
  { TOA2Atk1A.Location, TOA2Atk1B.Location, TOA2Atk1C.Location }
}

TOA2PlayerAttackPaths = {
  { TOA2Atk1A.Location }, { TOA2Atk2A.Location }, { TOA2Atk3A.Location }
}

TOA2AttackProduction = function(productionOptions, factoryType)
  local production = Utils.Random(productionOptions[Difficulty])
  local path = Utils.Random(TOA2McNeilAttackPaths)
  if McNeilDead == true then path = Utils.Random(TOA2PlayerAttackPaths) end
  local toBuild = function() return production end
  local factory = GetAvailableFactory(TOA2, factoryType)
  
  if factory ~= nil then
    ProduceUnits(TOA2, factory, nil, toBuild, function(units)
      UpdatePlayerBaseLocation()
      Utils.Do(units, function(unit)
        ErrorGuardAttackPatrol(unit, path)
        AssaultPlayerBaseOrHunt(unit)
      end)
      
      Trigger.AfterDelay(Utils.RandomInteger(TOAAttackDelayMin[Difficulty], TOAAttackDelayMax[Difficulty]), function()
        TOA2AttackProduction(productionOptions, factoryType)
      end)
    end)
  else
    Trigger.AfterDelay(Utils.RandomInteger(TOAAttackDelayMin[Difficulty], TOAAttackDelayMax[Difficulty]), function()
      TOA2AttackProduction(productionOptions, factoryType)
    end)
  end
end


TOA3MorelliAttackPaths = {
  { TOA3Atk1A.Location, TOA3Atk1B.Location, TOA3Atk1C.Location, TOA3Atk1E },
  { TOA3Atk1A.Location, TOA3Atk1B.Location, TOA3Atk1D.Location, TOA3Atk1E },
  { TOA3Atk1A.Location, TOA3Atk1C.Location, TOA3Atk1E }
}

TOA3PlayerAttackPaths = {
  { TOA3Atk1C.Location }, { TOA3Atk1F.Location }
}

TOA3AttackProduction = function(productionOptions, factoryType)
  local production = Utils.Random(productionOptions[Difficulty])
  local path = Utils.Random(TOA3MorelliAttackPaths)
  if MorelliDead == true then path = Utils.Random(TOA3PlayerAttackPaths) end
  local toBuild = function() return production end
  local factory = GetAvailableFactory(TOA2, factoryType)
  
  if factory ~= nil then
    ProduceUnits(TOA3, factory, nil, toBuild, function(units)
      UpdatePlayerBaseLocation()
      Utils.Do(units, function(unit)
        ErrorGuardAttackPatrol(unit, path)
        AssaultPlayerBaseOrHunt(unit)
      end)
      
      Trigger.AfterDelay(Utils.RandomInteger(TOAAttackDelayMin[Difficulty], TOAAttackDelayMax[Difficulty]), function()
        TOA3AttackProduction(productionOptions, factoryType)
      end)
    end)
  else
    Trigger.AfterDelay(Utils.RandomInteger(TOAAttackDelayMin[Difficulty], TOAAttackDelayMax[Difficulty]), function()
      TOA3AttackProduction(productionOptions, factoryType)
    end)
  end
end


AirstrikeDelayTimes = {
  easy = DateTime.Seconds(480),
  normal = DateTime.Seconds(360),
  hard = DateTime.Seconds(300),
}

AirstrikeAttacks = function()
  local comms = TOA.GetActorsByType('hq')
  if #comms == 0 then return end
  
  local StrikeCounter = 0
  local launchedIt = LaunchAIAirstrike(TOA, { Nod }, { 'a10scrip', 'a10scrip', 'a10scrip' }, { TOAAirstrikeSpawn1, TOAAirstrikeSpawn2, TOAAirstrikeSpawn3 })
  Utils.Do(CoopPlayers,function(PID)
	if PID ~= Nod then
		local ExtraLaunch = LaunchAIAirstrike(TOA, { Nod }, { 'a10scrip', 'a10scrip', 'a10scrip' }, { TOAAirstrikeSpawn1, TOAAirstrikeSpawn2, TOAAirstrikeSpawn3 })
		if ExtraLaunch == true then
			StrikeCounter = StrikeCounter + 1
		end
	end
  end)
  if launchedIt == true then
	StrikeCounter = StrikeCounter + 1
  end
  if StrikeCounter > 0 then
	Media.DisplayMessage("Warning: TOA airstrike incoming.", "EVA", HSLColor.FromHex("00FF00"))
  end
  
  --[[local launchedIt = LaunchAIAirstrike(TOA, { Nod }, { 'a10scrip', 'a10scrip', 'a10scrip' }, { TOAAirstrikeSpawn1, TOAAirstrikeSpawn2, TOAAirstrikeSpawn3 })
  if launchedIt == true then
    Media.DisplayMessage("Warning: TOA airstrike incoming.", "EVA", HSLColor.FromHex("00FF00"))
  end]]
  
  Trigger.AfterDelay(AirstrikeDelayTimes[Difficulty], AirstrikeAttacks)
end

-- End TOA Attack Production Behavior -----


-- McNeil Attack Production Behavior -----

McNeilAttackDelayMin = { easy = DateTime.Seconds(30), normal = DateTime.Seconds(30), hard = DateTime.Seconds(30) }
McNeilAttackDelayMax = { easy = DateTime.Seconds(45), normal = DateTime.Seconds(45), hard = DateTime.Seconds(45) }

McNeilTOA2AttackPaths = {
  { McNeilAtk1A.Location, McNeilAtk1B.Location },
}

McNeilTOAAttackPaths = {
  { McNeilAtk1A.Location, McNeilAtk2A.Location, AllyAtkFinal.Location },
}

McNeilAttackInfantryTypes = {
  easy = {
    { "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1" },
    { "e2", "e2", "e2", "e2", "e2", "e2", "e2", "e2", "e2", "e2" },
    { "e3", "e3", "e3", "e3", "e3", "e3", "e3", "e3", "e3", "e3" },
    { "e1", "e1", "e1", "e1", "e1", "e3", "e3", "e3", "e3", "e3" },
  },
  normal = {
    { "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1" },
    { "e2", "e2", "e2", "e2", "e2", "e2", "e2", "e2", "e2", "e2" },
    { "e3", "e3", "e3", "e3", "e3", "e3", "e3", "e3", "e3", "e3" },
    { "e1", "e1", "e1", "e1", "e1", "e3", "e3", "e3", "e3", "e3" },
  },
  hard = {
    { "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1" },
    { "e2", "e2", "e2", "e2", "e2", "e2", "e2", "e2", "e2", "e2" },
    { "e3", "e3", "e3", "e3", "e3", "e3", "e3", "e3", "e3", "e3" },
    { "e1", "e1", "e1", "e1", "e1", "e3", "e3", "e3", "e3", "e3" },
  }
}

McNeilAttackVehicleTypes = {
  easy = {
    { "jeep", "jeep", "jeep", "mtnk", "mtnk", "mtnk" },
    { "mtnk", "mtnk", "mtnk", "mtnk", "mtnk" },
    { "mtnk", "mtnk", "mtnk", "msam", "msam" },
    { "hovertnk", "hovertnk", "hovertnk", "hovertnk", "hovertnk" },
    { "hovertnk", "hovertnk", "hovertnk", "msam", "msam" },
  },
  normal = {
    { "jeep", "jeep", "jeep", "mtnk", "mtnk", "mtnk" },
    { "mtnk", "mtnk", "mtnk", "mtnk", "mtnk" },
    { "mtnk", "mtnk", "mtnk", "msam", "msam" },
    { "hovertnk", "hovertnk", "hovertnk", "hovertnk", "hovertnk" },
    { "hovertnk", "hovertnk", "hovertnk", "msam", "msam" },
  },
  hard = {
    { "jeep", "jeep", "jeep", "mtnk", "mtnk", "mtnk" },
    { "mtnk", "mtnk", "mtnk", "mtnk", "mtnk" },
    { "mtnk", "mtnk", "mtnk", "msam", "msam" },
    { "hovertnk", "hovertnk", "hovertnk", "hovertnk", "hovertnk" },
    { "hovertnk", "hovertnk", "hovertnk", "msam", "msam" },
  }
}

McNeilInfantryProduction = function()
  local production = Utils.Random(McNeilAttackInfantryTypes[Difficulty])
  local path = Utils.Random(McNeilTOA2AttackPaths)
  if TOA3Dead == true then
    path = Utils.Random(McNeilTOAAttackPaths)
  end
  local toBuild = function() return production end
  local factory = GetAvailableFactory(McNeil, 'pyle')
  
  if factory ~= nil then
    ProduceUnits(McNeil, factory, nil, toBuild, function(units)
      Utils.Do(units, function(unit)
        ErrorGuardAttackPatrol(unit, path)
        unit.Hunt()
      end)
      Trigger.AfterDelay(Utils.RandomInteger(McNeilAttackDelayMin[Difficulty], McNeilAttackDelayMax[Difficulty]), McNeilInfantryProduction)
    end)
  else
    Trigger.AfterDelay(Utils.RandomInteger(McNeilAttackDelayMin[Difficulty], McNeilAttackDelayMax[Difficulty]), McNeilInfantryProduction)
  end
end


McNeilVehicleProduction = function()
  local production = Utils.Random(McNeilAttackVehicleTypes[Difficulty])
  local path = Utils.Random(McNeilTOA2AttackPaths)
  if TOA3Dead == true then
    path = Utils.Random(McNeilTOAAttackPaths)
  end
  local toBuild = function() return production end
  local factory = GetAvailableFactory(McNeil, 'weap')
  
  if factory ~= nil then
    ProduceUnits(McNeil, factory, nil, toBuild, function(units)
      Utils.Do(units, function(unit)
        ErrorGuardAttackPatrol(unit, path)
        if unit.Type ~= 'harv' then unit.Hunt() end
      end)
      Trigger.AfterDelay(Utils.RandomInteger(McNeilAttackDelayMin[Difficulty], McNeilAttackDelayMax[Difficulty]), McNeilVehicleProduction)
    end)
  else
    Trigger.AfterDelay(Utils.RandomInteger(McNeilAttackDelayMin[Difficulty], McNeilAttackDelayMax[Difficulty]), McNeilVehicleProduction)
  end
end

-- End McNeil Attack Production Behavior -----


-- Morelli Attack Production Behavior -----

MorelliAttackDelayMin = { easy = DateTime.Seconds(30), normal = DateTime.Seconds(30), hard = DateTime.Seconds(30) }
MorelliAttackDelayMax = { easy = DateTime.Seconds(45), normal = DateTime.Seconds(45), hard = DateTime.Seconds(45) }

MorelliTOA3AttackPaths = {
  { MorelliAtk1A.Location, MorelliAtk1B.Location, MorelliAtk1C.Location },
}

MorelliTOAAttackPaths = {
  { MorelliAtk2A.Location, AllyAtkFinal.Location },
}

MorelliAttackInfantryTypes = {
  easy = {
    { "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1" },
    { "e2", "e2", "e2", "e2", "e2", "e2", "e2", "e2", "e2", "e2" },
    { "e3", "e3", "e3", "e3", "e3", "e3", "e3", "e3", "e3", "e3" },
    { "e1", "e1", "e1", "e1", "e1", "e3", "e3", "e3", "e3", "e3" },
  },
  normal = {
    { "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1" },
    { "e2", "e2", "e2", "e2", "e2", "e2", "e2", "e2", "e2", "e2" },
    { "e3", "e3", "e3", "e3", "e3", "e3", "e3", "e3", "e3", "e3" },
    { "e1", "e1", "e1", "e1", "e1", "e3", "e3", "e3", "e3", "e3" },
  },
  hard = {
    { "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1" },
    { "e2", "e2", "e2", "e2", "e2", "e2", "e2", "e2", "e2", "e2" },
    { "e3", "e3", "e3", "e3", "e3", "e3", "e3", "e3", "e3", "e3" },
    { "e1", "e1", "e1", "e1", "e1", "e3", "e3", "e3", "e3", "e3" },
  }
}

MorelliAttackVehicleTypes = {
  easy = {
    { "jeep", "jeep", "jeep", "mtnk", "mtnk", "mtnk" },
    { "mtnk", "mtnk", "mtnk", "mtnk", "mtnk" },
    { "mtnk", "mtnk", "mtnk", "msam", "msam" },
  },
  normal = {
    { "jeep", "jeep", "jeep", "mtnk", "mtnk", "mtnk" },
    { "mtnk", "mtnk", "mtnk", "mtnk", "mtnk" },
    { "mtnk", "mtnk", "mtnk", "msam", "msam" },
  },
  hard = {
    { "jeep", "jeep", "jeep", "mtnk", "mtnk", "mtnk" },
    { "mtnk", "mtnk", "mtnk", "mtnk", "mtnk" },
    { "mtnk", "mtnk", "mtnk", "msam", "msam" },
  }
}


MorelliInfantryProduction = function()
  local production = Utils.Random(MorelliAttackInfantryTypes[Difficulty])
  local path = Utils.Random(MorelliTOA3AttackPaths)
  if TOA3Dead == true then
    path = Utils.Random(MorelliTOAAttackPaths)
  end
  local toBuild = function() return production end
  local factory = GetAvailableFactory(Morelli, 'pyle')
  
  if factory ~= nil then
    ProduceUnits(Morelli, factory, nil, toBuild, function(units)
      Utils.Do(units, function(unit)
        ErrorGuardAttackPatrol(unit, path)
        unit.Hunt()
      end)
      Trigger.AfterDelay(Utils.RandomInteger(MorelliAttackDelayMin[Difficulty], MorelliAttackDelayMax[Difficulty]), MorelliInfantryProduction)
    end)
  else
    Trigger.AfterDelay(Utils.RandomInteger(MorelliAttackDelayMin[Difficulty], MorelliAttackDelayMax[Difficulty]), MorelliInfantryProduction)
  end
end


MorelliVehicleProduction = function()
  local production = Utils.Random(MorelliAttackVehicleTypes[Difficulty])
  local path = Utils.Random(MorelliTOA3AttackPaths)
  if TOA3Dead == true then
    path = Utils.Random(MorelliTOAAttackPaths)
  end
  local toBuild = function() return production end
  local factory = GetAvailableFactory(Morelli, 'weap')
  
  if factory ~= nil then
    ProduceUnits(Morelli, factory, nil, toBuild, function(units)
      Utils.Do(units, function(unit)
        ErrorGuardAttackPatrol(unit, path)
        if unit.Type ~= 'harv' then unit.Hunt() end
      end)
      Trigger.AfterDelay(Utils.RandomInteger(MorelliAttackDelayMin[Difficulty], MorelliAttackDelayMax[Difficulty]), MorelliVehicleProduction)
    end)
  else
    Trigger.AfterDelay(Utils.RandomInteger(MorelliAttackDelayMin[Difficulty], MorelliAttackDelayMax[Difficulty]), MorelliVehicleProduction)
  end
end


MorelliAirAttackProduction = function()
  local orcas = Morelli.GetActorsByType('orca.ai')
  
  if #orcas < 4 then
    local deficit = 4 - #orcas
    local newOrcas = 0
    local factories = Morelli.GetActorsByType('hpad')
    Utils.Do(factories, function(factory)
      if newOrcas >= deficit then return end
      local orca = Actor.Create('orca.ai', true, { Owner = Morelli, Location = factory.Location })
      orca.Move(factory.Location)
      newOrcas = newOrcas + 1
    end)
  end
  Trigger.AfterDelay(DateTime.Seconds(90), MorelliAirAttackProduction)
end


MorelliAirDefense = function()
  local targets = Map.ActorsInBox(MorelliBaseNW.CenterPosition, MorelliBaseSE.CenterPosition, function(a)
    return (a.Owner == TOA or a.Owner == TOA2 or a.Owner == TOA3) and
           (a.Type == 'jeep' or a.Type == 'mtnk' or a.Type == 'htnk' or a.Type == 'mmk2' or
            a.Type == 'msam' or a.Type == 'hovertnk' or a.Type == 'orcad' or a.Type == 'orca')
  end)
  
  local orcas = Morelli.GetActorsByType('orca.ai')
  
  if #targets > 0 then
    local target = Utils.Random(targets)
    Utils.Do(orcas, function(orca)
      if target ~= nil and not target.IsDead then orca.AttackMove(target.Location) end
    end)
  else
    Utils.Do(orcas, function(orca)
      orca.Stop()
      orca.AttackMove(OrcaIdle.Location)
    end)
  end
  
  Trigger.AfterDelay(DateTime.Seconds(8), MorelliAirDefense)
end


MorelliAirstrikeAttacks = function()
  if Difficulty == 'hard' then
    Trigger.AfterDelay(DateTime.Seconds(480), MorelliAirstrikeAttacks)
  else
    Trigger.AfterDelay(DateTime.Seconds(360), MorelliAirstrikeAttacks)
  end

  local comms = Morelli.GetActorsByType('hq')
  if TeamMorelli[1] ~= nil then
	Utils.Do(TeamMorelli[1].GetActorsByType('hq'),function(UID)
		table.insert(comms,UID)
	end)
  end
  if #comms == 0 then return end
  
  local launchedIt = false

  if TOA3Dead == false then
    launchedIt = LaunchAIAirstrike(Morelli, { TOA3 }, { 'a10scrip', 'a10scrip', 'a10scrip' }, { MorelliAirstrikeSpawn })
  elseif TOA2Dead == false then
    launchedIt = LaunchAIAirstrike(Morelli, { TOA2 }, { 'a10scrip', 'a10scrip', 'a10scrip' }, { MorelliAirstrikeSpawn })
  elseif TOADead == false then
    launchedIt = LaunchAIAirstrike(Morelli, { TOA }, { 'a10scrip', 'a10scrip', 'a10scrip' }, { MorelliAirstrikeSpawn })
  end
  
  if launchedIt == true then
    Media.DisplayMessage("Colonel Morelli is launching an airstrike.", "EVA", HSLColor.FromHex("00FF00"))
  end
end

-- Morelli Attack Production Behavior -----


AssignObjectives = function()
  DefeatTOAObjective = Nod.AddObjective("Destroy the TOA bases.")
  DestroyPrototypesObjective = Nod.AddObjective("Destroy all Mammoth Mk. II prototypes.")
  CaptureTechCenterObjective = Nod.AddObjective("Capture TOA's technology center.")
end


BeachLanding = function()
	AssignGDIMCVs = false
	Utils.Do(CoopPlayers,function(PID)
		if PID ~= Nod and PID ~= TeamMcNeil[1] and PID ~= TeamMorelli[1] and PID.Faction == "gdi" then
			Actor230.Produce("mcv")
			AssignGDIMCVs = true
		end
	end)
	
	if TeamMorelli[1] ~= nil then
		Media.DisplayMessage("Colonel Morelli is played by " .. TeamMorelli[1].Name .. ".", "EVA", TeamMorelli[1].Color)
		Utils.Do(Morelli.GetActors(),function(UID)
			UID.Owner = TeamMorelli[1]
		end)
	end
	if TeamMcNeil[1] ~= nil then
		Media.DisplayMessage("Commander McNeil is played by " .. TeamMcNeil[1].Name .. ".", "EVA", TeamMcNeil[1].Color)
		Utils.Do(McNeil.GetActors(),function(UID)
			UID.Owner = TeamMcNeil[1]
		end)
	end
  Media.PlaySpeechNotification(All, "Reinforce")
  Actor.Create('boat', true, { Owner = McNeil, Location = GunboatSpawn.Location })
  local cam1 = Actor.Create('camera', true, { Owner = Nod, Location = Cam0F.Location })
  local cam2 = Actor.Create('camera', true, { Owner = Nod, Location = Cam0G.Location })
  
  Trigger.AfterDelay(DateTime.Seconds(60), function()
    cam1.Destroy()
    cam2.Destroy()
  end)
  
  Camera.Position = Cam0E.CenterPosition
  
  Trigger.AfterDelay(DateTime.Seconds(5), function()
    AssignGDIMCVs = false
	Media.PlaySpeechNotification(All, "Reinforce")
    ReinforceWithLandingCraft(BadGuy, {'e4', 'e4', 'e4', 'e4', 'e4'}, LSTSpawn1.Location, LSTMoveTo1.Location, false)
    ReinforceWithLandingCraft(BadGuy, {'e3', 'e3', 'e3', 'e3', 'e3'}, LSTSpawn2.Location, LSTMoveTo2.Location, false)
  end)
  
  Trigger.AfterDelay(DateTime.Seconds(10), function()
    Media.PlaySpeechNotification(All, "Reinforce")
    ReinforceWithLandingCraft(BadGuy, {'ltnk'}, LSTSpawn1.Location, LSTMoveTo1.Location, false)
    ReinforceWithLandingCraft(BadGuy, {'ltnk'}, LSTSpawn2.Location, LSTMoveTo2.Location, false)
    
    local toBuild = function() return {'e1', 'e1', 'e1', 'e1', 'e1', 'e2', 'e2', 'e2', 'e2', 'e2', 'e3', 'e3', 'e3', 'e3', 'e3'} end
    if Difficulty == 'easy' then
      toBuild = function() return {'e1', 'e1', 'e1', 'e1', 'e1', 'e2', 'e2', 'e2', 'e2', 'e2'} end
    end
    if not Pyle1.IsDead then
      ProduceUnits(TOA4, Pyle1, nil, toBuild, function(units)
        Utils.Do(units, function(unit)
          unit.AttackMove(LSTMoveTo3.Location)
          unit.Hunt()
        end)
      end)
    end
  end)
  
  Trigger.AfterDelay(DateTime.Seconds(15), function()
    Media.PlaySpeechNotification(All, "Reinforce")
    ReinforceWithLandingCraft(BadGuy, {'bggy'}, LSTSpawn3.Location, LSTMoveTo3.Location, false)
    ReinforceWithLandingCraft(BadGuy, {'bggy'}, LSTSpawn4.Location, LSTMoveTo4.Location, false)
  end)
  
  Trigger.AfterDelay(DateTime.Seconds(20), function()
    Media.PlaySpeechNotification(All, "Reinforce")
	local MCVlist = {}
	Utils.Do(TeamBeach,function(PID)
		if PID.Faction == "nod" then
			table.insert(MCVlist,"mcv")
		end
	end)
    ReinforceWithLandingCraft(BadGuy, MCVlist, LSTSpawn3.Location, LSTMoveTo3.Location, false)
    ReinforceWithLandingCraft(BadGuy, {'cyborg', 'cyborg', 'cyborg', 'cyborg', 'cyborg'}, LSTSpawn4.Location, LSTMoveTo4.Location, false)
    AssignObjectives()
    PlayerCanLose = true
  end)
  
  local attackDelay = { hard = DateTime.Seconds(120), normal = DateTime.Seconds(150), easy = DateTime.Seconds(210) }
  Trigger.AfterDelay(attackDelay[Difficulty], function()
    McNeilInfantryProduction()
    McNeilVehicleProduction()
    MorelliInfantryProduction()
    MorelliVehicleProduction()
    MorelliAirAttackProduction()
    MorelliAirDefense()

    AiAttackProduction(TOA, TOAAttackPaths, TOAAttackVehicleTypes, 'weap')
    AiAttackProduction(TOA, TOAAttackPaths, TOAAttackInfantryTypes, 'pyle')
    TOA2AttackProduction(TOA23AttackVehicleTypes, 'weap')
    TOA2AttackProduction(TOAAttackInfantryTypes, 'pyle')
    TOA3AttackProduction(TOA23AttackVehicleTypes, 'weap')
    TOA3AttackProduction(TOAAttackInfantryTypes, 'pyle')
    
    Trigger.AfterDelay(TOAAirAttackDelayMax[Difficulty] * 2, function()
      AiAirAttackProduction(TOA, TOAAttackAirTypes)
    end)
    
    Trigger.AfterDelay(DateTime.Seconds(60) + AirstrikeDelayTimes[Difficulty], AirstrikeAttacks)
    
    local conditionToken = TOA.GrantCondition("ion-cannon-active")
    Trigger.OnKilled(Eye, function(self, killer) TOA.RevokeCondition(conditionToken) end)
    
    if Difficulty ~= 'easy' then
      Trigger.AfterDelay(DateTime.Seconds(480), function()
        --local baseBuildings = Nod.GetActorsByTypes( {'fact', 'afld', 'hand', 'nuke', 'nuk2', 'proc', 'hq'} )
		local baseBuildings = {}
		Utils.Do(CoopPlayers,function(PID)
			Utils.Do(PID.GetActorsByTypes( {'fact', 'afld', 'hand', 'nuke', 'nuk2', 'proc', 'hq'} ),function(UID)
				table.insert(baseBuildings,UID)
			end)
		end)
        if #baseBuildings > 0 then
          CmdoRushTargetPlayer = baseBuildings[1].Owner
          Reinforcements.ReinforceWithTransport(TOA, "tran", {"rmbo", "rmbo", "rmbo"}, { CmdoSpawn1.Location }, null, ExecCmdoRush)
          Reinforcements.ReinforceWithTransport(TOA, "tran", {"rmbo", "rmbo", "rmbo"}, { CmdoSpawn2.Location }, null, ExecCmdoRush)
        end
      end)
    end

    local mmk2AttackDelay = { hard = DateTime.Seconds(900), normal = DateTime.Seconds(1200), easy = DateTime.Seconds(1800) }
    Trigger.AfterDelay(mmk2AttackDelay[Difficulty], function()
      local mmk22AttackPaths = Utils.Random(TOA2McNeilAttackPaths)
      if McNeilDead == true then mmk22AttackPaths = Utils.Random(TOA2PlayerAttackPaths) end
      if not MMK22.IsDead then
        Utils.Do(mmk22AttackPaths, function(wp) MMK22.AttackMove(wp) end)
        AssaultPlayerBaseOrHunt(MMK22)
      end
      
      local mmk23AttackPaths = Utils.Random(TOA3MorelliAttackPaths)
      if MorelliDead == true then mmk23AttackPaths = Utils.Random(TOA3PlayerAttackPaths) end
      if not MMK23.IsDead then
        Utils.Do(mmk23AttackPaths, function(wp) MMK23.AttackMove(wp) end)
        AssaultPlayerBaseOrHunt(MMK23)
      end
      
      local mmk24AttackPaths = Utils.Random(TOAAttackPaths)
      if not MMK24.IsDead then
        Utils.Do(mmk24AttackPaths, function(wp) MMK24.AttackMove(wp) end)
        AssaultPlayerBaseOrHunt(MMK24)
      end
    end)
  end)
end

GlobalCurrentCount = 1

AssignToTeamsGlobal = function(units, team)
	local playerCount = #team

	Utils.Do(units, function(unit)
		if unit.Type ~= "player" then
			if GlobalCurrentCount > playerCount then
				GlobalCurrentCount = 1
			end
			local newOwner = team[GlobalCurrentCount]
			unit.Owner = newOwner
			GlobalCurrentCount = GlobalCurrentCount + 1
		end
	end)
end

WorldLoaded = function()
  Nod = Player.GetPlayer("Nod")
  TOA = Player.GetPlayer("TOA")
  TOA2 = Player.GetPlayer("TOA2")
  TOA3 = Player.GetPlayer("TOA3")
  TOA4 = Player.GetPlayer("TOA4")
  Morelli = Player.GetPlayer("Morelli")
  McNeil = Player.GetPlayer("McNeil")
  Trial = Player.GetPlayer("Trial")
  Neutral = Player.GetPlayer("Neutral")
  
  MissionPlayer = Nod
  
  	BadGuy = Player.GetPlayer("BadGuy")

	coopInfo =
	{
		Mainplayer = Nod,
		MainEnemies = {TOA, TOA2, TOA3},
		Dummyplayer = BadGuy
	}
	
	ORAMod = "tibalt"
	Stopspread = true
	CoopInit25(coopInfo)
	
	GDIRole = Map.LobbyOption("GDIRole")
	TeamBeach = {Nod}
	TeamBeachNod = {Nod}
	TeamBeachGDI = {}
	AllGDIs = {}
	TeamMcNeil = {}
	TeamMorelli = {}
	if #CoopPlayers > 1 then
		TeamBeach = {}
		TeamBeachNod = {}
		Utils.Do(CoopPlayers,function(PID)
			if PID ~= GDI and PID.Faction == "gdi" then
				table.insert(AllGDIs,PID)
			end
			if PID.Faction == "nod" then
				table.insert(TeamBeach,PID)
				table.insert(TeamBeachNod,PID)
			end
		end)
		if GDIRole == "mcneil" then
			if AllGDIs[1] ~= nil then
				table.insert(TeamMcNeil,AllGDIs[1])
			end
			if AllGDIs[2] ~= nil then
				table.insert(TeamMorelli,AllGDIs[2])
			end
		end
		if GDIRole == "morelli" then
			if AllGDIs[1] ~= nil then
				table.insert(TeamMorelli,AllGDIs[1])
			end
			if AllGDIs[2] ~= nil then
				table.insert(TeamMcNeil,AllGDIs[2])
			end
		end
		Utils.Do(AllGDIs,function(PID)
			if PID ~= TeamMorelli[1] and PID ~= TeamMcNeil[1] then
				table.insert(TeamBeach,PID)
				table.insert(TeamBeachGDI,PID)
			end
		end)
	end
	
	--Override Sharing options
	BaseShared = false
	TechShared = false

  Camera.Position = StartCam.CenterPosition
  
  --Remove actors based on difficulty
  Utils.Do(ActorRemovals[Difficulty], function(unit)
    unit.Destroy()
  end)
  
  
  
  --Special lighting
  Lighting.Ambient = 0.85
  Lighting.Red = 0.8
  Lighting.Blue = 1.0
  Lighting.Green = 1.1
  
  --Player Reinforcements
  
  --Objectives
  InitObjectives(Nod)

  Trigger.OnCapture(Miss, function(self, captor, oldOwner, newOwner)
    if IsOwnedByCoopPlayer(captor) then Nod.MarkCompletedObjective(CaptureTechCenterObjective) end
  end)
  
  Trigger.OnKilled(Miss, function(self, killer)
    Media.DisplayMessage("A mission-critical structure (technology center) has been destroyed!", "ALERT", HSLColor.FromHex("FF0000"))
    Nod.MarkFailedObjective(CaptureTechCenterObjective)
  end)

  --AI player behavior
  Utils.Do( {TOA, TOA2, TOA3, Morelli, McNeil}, function(player)
    player.Cash = 10000
    player.Resources = player.ResourceCapacity - 500
    SetupRefAndSilosCaptureCredits(player)
    AutoReplaceHarvesters(player)
    AutoRepairAndRebuildBuildings(player, 15)
  end)
  
  TOA4.Cash = 90000
  TOA4.Resources = TOA4.ResourceCapacity - 500
  SetupRefAndSilosCaptureCredits(TOA4)
  
  Trigger.AfterDelay(DateTime.Seconds(360), MorelliAirstrikeAttacks)
  
  Utils.Do(CoopPlayers,function(PID)
	local sellBuildingsTOA = TOA.GetActorsByTypes( { 'fact', 'weap', 'proc', 'pyle', 'eye' } )
	Utils.Do(sellBuildingsTOA, function(building) SellBuildingIfEngyNear(building, 4, PID) end)
  
	local sellBuildingsTOA2 = TOA2.GetActorsByTypes( { 'fact', 'weap', 'proc', 'pyle' } )
	Utils.Do(sellBuildingsTOA2, function(building) SellBuildingIfEngyNear(building, 4, PID) end)
  
	local sellBuildingsTOA3 = TOA3.GetActorsByTypes( { 'fact', 'weap', 'proc', 'pyle' } )
	Utils.Do(sellBuildingsTOA3, function(building) SellBuildingIfEngyNear(building, 4, PID) end)
  end)
  
  --Enemy Predeployed Maneuvers
  MMK25.Patrol({ Patrol3.Location, Patrol4.Location, Patrol1.Location, Patrol2.Location }, true, DateTime.Seconds(8))
  
  if Difficulty ~= 'easy' then
    MMK26.Patrol({ Patrol1.Location, Patrol2.Location, Patrol3.Location, Patrol4.Location }, true, DateTime.Seconds(8))
  end
  
  if Difficulty == 'hard' then
    MMK27.Patrol({ Patrol4.Location, Patrol1.Location, Patrol2.Location, Patrol3.Location }, true, DateTime.Seconds(8))
  end
  
  --Proximity Triggers/Reveals
  --Timer
  --Crate spawns
  --Taunts
  
  --Cutscenes
  Media.DisplayMessage("Initiating mock trial combat for Behemoth Prototype I.", "TOA Officer", HSLColor.FromHex("F62E05"))
  MMK21.Move(MMK2MoveTo1.Location)
  MMK21.CallFunc(function()
    Media.DisplayMessage("Armed with triple 200mm artillery cannons, the Mammoth Mk. II Behemoth's range and firepower make it a mobile artillery fortress.", "TOA Officer", HSLColor.FromHex("F62E05"))
    MMK21.Owner = TOA4
    TestFact.Owner = Trial
    MMK21.Attack(TestFact)
  end)
  
  Trigger.OnKilled(TestFact, function(self, killer)
    Media.DisplayMessage("In addition to its artillery guns, the Behemoth mounts dual missile launchers and has enough durability to shrug off even a Mammoth's 120mm cannon fire.", "TOA Officer", HSLColor.FromHex("F62E05"))
    Htnk1.Owner = Trial
    Htnk2.Owner = Trial
    MMK21.Attack(Htnk2)
    MMK21.Attack(Htnk1)
    Htnk1.Attack(MMK21)
    Htnk2.Attack(MMK21)
  end)
  
  Trigger.OnAllKilled({Htnk1, Htnk2}, function()
    Media.DisplayMessage("With cutting-edge targeting systems, the Behemoth's missile launchers also make short work of aerial threats.", "TOA Officer", HSLColor.FromHex("F62E05"))
    local orca = Actor.Create('orcad', true, { Owner = Trial, Location = TestOrcaSpawn.Location })
    orca.Attack(MMK21)
    MMK21.Attack(orca)
    Trigger.OnKilled(orca, function(self, killer)
      Media.DisplayMessage("This concludes the Mammoth Mk. II Behemoth Prototype I mock combat trial.", "TOA Officer", HSLColor.FromHex("F62E05"))
      MMK21.Owner = TOA
      Miss.Owner = Trial
      MMK21.Move(MMK2MoveTo2.Location)
      Trigger.AfterDelay(DateTime.Seconds(10), function()
        Cam0A.Destroy()
        Cam0B.Destroy()
        Cam0C.Destroy()
        Cam0D.Destroy()
        BeachLanding()
      end)
    end)
  end)
  
  --Testing
end


Tick = function()
	if #BadGuy.GetGroundAttackers() > 0 then
		AssignToTeamsGlobal(BadGuy.GetGroundAttackers(),TeamBeach)
	end
	if #BadGuy.GetActorsByTypes({"mcv"}) > 0 then
		AssignToTeamsGlobal(BadGuy.GetActorsByTypes({"mcv"}),TeamBeachNod)
	end
	if AssignGDIMCVs == true then
		local GDIMCVList = Morelli.GetActorsByTypes({"mcv"})
		if TeamMorelli[1] ~= nil then
			Utils.Do(TeamMorelli[1].GetActorsByTypes({"mcv"}),function(UID)
				table.insert(GDIMCVList,UID)
			end)
		end
		AssignToTeamsGlobal(GDIMCVList,TeamBeachGDI)
	end
	OncePerSecondChecks()
	OncePerThreeSecondChecks()
end

OncePerSecondChecks = function()
  if DateTime.GameTime > 1 and DateTime.GameTime % 25 == 0 then
    --None
  end
end

OncePerThreeSecondChecks = function()
	if DateTime.GameTime > 1 and DateTime.GameTime % 75 == 0 then
  
    --[[if PlayerCanLose == false and HasOneOf(Nod, LossCheckAll) == false then
      PlayerFailMission()
    end]]
	
	if PlayerCanLose == false then
      TibAltCoopLossCheck()
    end
    
    if TOADead == false then
      if HasOneOf(TOA, LossCheckCritical) == false then TOADead = true end
    end
    
    if TOA2Dead == false then
      if HasOneOf(TOA2, LossCheckCritical) == false then TOA2Dead = true end
    end
    
    if TOA3Dead == false then
      if HasOneOf(TOA3, LossCheckCritical) == false then TOA3Dead = true end
    end
    
    if TOADead and TOA2Dead and TOA3Dead then
      Nod.MarkCompletedObjective(DefeatTOAObjective)
    end
    
    if MorelliDead == false and TeamMorelli[1] == nil then
      if HasOneOf(Morelli, LossCheckCritical) == false then 
		MorelliDead = true
	  end
    end
    
    if McNeilDead == false and TeamMcNeil[1] == nil then
      if HasOneOf(McNeil, LossCheckCritical) == false then
		McNeilDead = true
	  end
    end
	
	if MorelliDead == false and TeamMorelli[1] ~= nil then
      if HasOneOf(TeamMorelli[1], LossCheckCritical) == false then 
		MorelliDead = true
	  end
    end
    
    if McNeilDead == false and TeamMcNeil[1] ~= nil then
      if HasOneOf(TeamMcNeil[1], LossCheckCritical) == false then
		McNeilDead = true
	  end
    end
    
    if PrototypesDestroyed == false then
      local prototypes = TOA.GetActorsByType('mmk2')
      if #prototypes == 0 then
        PrototypesDestroyed = true
        Nod.MarkCompletedObjective(DestroyPrototypesObjective)
      end
    end
    
    --manipulate AI funds
    ManipulatePlayerFunds(TOA)
    ManipulatePlayerFunds(TOA2)
    ManipulatePlayerFunds(TOA3)
    ManipulatePlayerFunds(Morelli)
    ManipulatePlayerFunds(McNeil)
    
    ControlAircraft(TOA)
	end
end


PlayerFailMission = function()
  if DefeatTOAObjective ~= nil and not Nod.IsObjectiveCompleted(DefeatTOAObjective) then
    GDI.MarkFailedObjective(DefeatTOAObjective)
  end
  if DestroyPrototypesObjective ~= nil and not Nod.IsObjectiveCompleted(DestroyPrototypesObjective) then
    GDI.MarkFailedObjective(DestroyPrototypesObjective)
  end
  if CaptureTechCenterObjective ~= nil and not Nod.IsObjectiveCompleted(CaptureTechCenterObjective) then
    GDI.MarkFailedObjective(CaptureTechCenterObjective)
  end
end