InitialiseDinoMission = function()
    Media.StopMusic()
    StartDinoMission()
    Media.PlaySpeechNotification(allplayers, "GameLoaded")
    Light = 0
    turnOn()
    setRightGaps()
    SendInsertionHelicopter()
    SetDinoTriggers()
    SetStegosaurusMove()
    SetTriceratopsMove()
    LoadDinoDifficultyRules()
    Trigger.AfterDelay(DateTime.Seconds(2), function()
        Media.DisplayMessage(
        "Commanders you must help me protecting my very special Chronosphere, The research being conducted here is very important.\nDifficulty is " ..
        Difficulty .. "", "Materia", Materia.Color)
    end)
    Trigger.AfterDelay(DateTime.Seconds(17), function()
        ChronoshiftAlliedUnits()
    end)
    Trigger.AfterDelay(DateTime.Seconds(7), function()
        Media.PlaySound("ChronoGateOpenSound.aud")
        Trigger.AfterDelay(DateTime.Seconds(5), function()
            Media.PlaySound("ChronoGateSpawnedSound.aud")
            Trigger.AfterDelay(DateTime.Seconds(1), function()
                Media.PlaySound("Chrono.aud")
            end)
        end)
    end)
end

allDinoSounds = { "AllosaurDeath.aud", "AllosaurVictory.aud", "StegosaurAttackGroan.aud", "StegosaurDeath.aud", "StegosaurVictory.aud", "TrexAttackGrowl.aud", "TrexDeath.aud", "TrexVictory.aud", "TriceratopsAttackGrunt.aud", "TriceratopsDeath.aud" }

PlayDinoSounds = function()
    randomDinoSound = Utils.Random(allDinoSounds)
    Media.PlaySound(randomDinoSound)
    Trigger.AfterDelay(DateTime.Seconds((Utils.RandomInteger(20, 45))), function()
        if Dinos then
            PlayDinoSounds()
        end
    end)
end

Startingheli = "allseetran"
chronoExploded = false

SendInsertionHelicopter = function()
    materiasTran.Move(Chronosphere.Location)
    heliInWorld = true
    Trigger.OnKilled(materiasTran, function()
        heliInWorld = false
        Lighting.Flash("LightningStrike", Utils.RandomInteger(10, 5))
        ChronoLight()
        Media.PlaySound("ChronoGateSpawnedSound.aud")
        Trigger.AfterDelay(10, function()
            Lighting.Flash("LightningStrike", Utils.RandomInteger(10, 5))
            Trigger.AfterDelay(10, function()
                Lighting.Flash("LightningStrike", Utils.RandomInteger(10, 5))
                RemoveMateriasUnits()
                RemoveEnemysUnits()
                Trigger.AfterDelay(55, function()
                    Lighting.Flash("LightningStrike", Utils.RandomInteger(30, 20))
                    Switchview()
                    setLeftGaps()
                    SpawnRandomDinos()
                    BrachioIncome()
                    Trigger.AfterDelay(1, function()
                        SpawnPlayerUnits()
                    end)
                    Trigger.AfterDelay(220, function()
                        missionTime = true
                        Media.DisplayMessage(
                            "The calculated time when you will be chronoed back is " .. dinoTime .. " Minutes",
                            "Materia",
                            Materia.Color)
                            Trigger.AfterDelay((Utils.RandomInteger(100, 300)), function()
                            PlayDinoSounds()
                            Media.DisplayMessage(
                                "Maybe our engineers might find something valuable here.",
                                "Materia",
                                Materia.Color)
                            end)

                    end)
                end)
            end)
        end)
    end)
end

m0Path = { HeliHuskSpawn.Location, m0Way.Location }
m1Path = { HeliHuskSpawn.Location, m1Way.Location }
m2Path = { HeliHuskSpawn.Location, m2Way.Location }
m3Path = { HeliHuskSpawn.Location, m3Way.Location }
m4Path = { HeliHuskSpawn.Location, m4Way.Location }

playerDeadcounter = 0

function SpawnPlayerUnits()
    if Multi0 then
        multi0Units = Reinforcements.Reinforce(Multi0, playerStartingUnits[Multi0.Faction], m0Path)
        Trigger.OnAllKilled(multi0Units, function()
            if Dinos then
                playerDeadcounter = playerDeadcounter + 1
                Media.DisplayMessage("" .. Multi0.Name .. "Your Team has been wiped out,\nPlease wait until the mission is over; the defense game will start afterwards.", "Materia",
                    Materia.Color)
                if playerDeadcounter >= playingPlayers then
--                    Media.DisplayMessage("All Teams have been wiped out! Mission Failed!", "Materia",
 --                       Materia.Color)
                    allPlayersDead = true
                end
            end
        end)
    end
    if Multi1 then
        multi1Units = Reinforcements.Reinforce(Multi1, playerStartingUnits[Multi1.Faction], m1Path)
        Trigger.OnAllKilled(multi1Units, function()
            if Dinos then
                playerDeadcounter = playerDeadcounter + 1
                Media.DisplayMessage("" .. Multi1.Name .. " — Your team has been eliminated.\nPlease stay until the mission ends; the defense game will begin then.", "Materia", Materia.Color)

                if playerDeadcounter >= playingPlayers then
--                    Media.DisplayMessage("All Dino Control Teams have been wiped out! Mission Failed!", "Materia",
--                        Materia.Color)
                    allPlayersDead = true
                end
            end
        end)
    end
    if Multi2 then
        multi2Units = Reinforcements.Reinforce(Multi2, playerStartingUnits[Multi2.Faction], m2Path)
        Trigger.OnAllKilled(multi2Units, function()
            if Dinos then
                playerDeadcounter = playerDeadcounter + 1
                Media.DisplayMessage("" .. Multi2.Name .. ": Your team was wiped out.\nWait until the mission is over; the defense phase starts afterwards.", "Materia", Materia.Color)

                if playerDeadcounter >= playingPlayers then
--                    Media.DisplayMessage("All Dino Control Teams have been wiped out! Mission Failed!", "Materia",
--                        Materia.Color)
                    allPlayersDead = true
                end
            end
        end)
    end
    if Multi3 then
        multi3Units = Reinforcements.Reinforce(Multi3, playerStartingUnits[Multi3.Faction], m3Path)
        Trigger.OnAllKilled(multi3Units, function()
            if Dinos then
                playerDeadcounter = playerDeadcounter + 1
                Media.DisplayMessage("" .. Multi3.Name .. " — All units lost.\nHold on until the mission concludes; the defense game will start afterwards.", "Materia", Materia.Color)
                if playerDeadcounter >= playingPlayers then
                    Media.DisplayMessage("All Dino Control Teams have been wiped out! Mission Failed!", "Materia",
                        Materia.Color)
                    allPlayersDead = true
                end
            end
        end)
    end
    if Multi4 then
        multi4Units = Reinforcements.Reinforce(Multi4, playerStartingUnits[Multi4.Faction], m4Path)
        Trigger.OnAllKilled(multi4Units, function()
            if Dinos then
                playerDeadcounter = playerDeadcounter + 1
                Media.DisplayMessage("" .. Multi0.Name .. " — Your squad has been destroyed.\nPlease remain until the mission ends; the defense phase will follow.", "Materia", Materia.Color)
                if playerDeadcounter >= playingPlayers then
--                    Media.DisplayMessage("All Dino Control Teams have been wiped out! Mission Failed!", "Materia",
--                        Materia.Color)
                    allPlayersDead = true
                end
            end
        end)
    end
end

function RemoveDinoStuff()
    allactors = Neutral.GetActors()
    for i, v in pairs(allactors) do
        if v.Type == "td03" or v.Type == "bigmgg" or v.Type == "td10" or v.Type == "td11" or v.Type == "td12" or v.Type == "td13" or v.Type == "td14" or v.Type == "td15" or v.Type == "td17" or v.Type == "tdd03" or v.Type == "tdd10" or v.Type == "tdd11" or v.Type == "tdd12" or v.Type == "tdd13" or v.Type == "tdd14" or v.Type == "tdd15" or v.Type == "tdd17" or v.Type == "tddd03" or v.Type == "tddd10" or v.Type == "tddd11" or v.Type == "tddd12" or v.Type == "tddd13" or v.Type == "tddd14" or v.Type == "tddd15" or v.Type == "tddd17" or v.Type == "gallimusegg" or v.Type == "allosaurusegg" or v.Type == "triceratopsegg" or v.Type == "parasauregg" or v.Type == "stegosaurusegg" or v.Type == "brachiosaurusegg" or v.Type == "trexegg" or v.Type == "grass" then
            v.Destroy()
        end
    end
    allactors = Enemys.GetActors()
    for i, v in pairs(allactors) do
        if v.Type == "apc" or v.Type == "v2rl" or v.Type == "4tnk" or v.Type == "3tnk" or v.Type == "e4" or v.Type == "shok" or v.Type == "apc" or v.Type == "ttnk" then
            v.Destroy()
        end
    end

    allactors = Herbivores.GetActors()
    for i, v in pairs(allactors) do
        if v.Type == "stegosaur" or v.Type == "stegosaurlg" or v.Type == "stegosaursm" or v.Type == "triceratopssm" or v.Type == "triceratops" or v.Type == "triceratopslg" or v.Type == "parasaur" or v.Type == "parasaursm" or v.Type == "parasaurlg" or v.Type == "brachiosaurus" or v.Type == "brachiosaurussm" or v.Type == "brachiosauruslg" or v.Type == "gallimussm" or v.Type == "gallimuslg" or v.Type == "allosaurussm" or v.Type == "allosauruslg" or v.Type == "tyrex" or v.Type == "tyrexlg" then
            v.Destroy()
        end
    end
    allactors = Carnivores.GetActors()
    for i, v in pairs(allactors) do
        if v.Type == "stegosaur" or v.Type == "stegosaurlg" or v.Type == "stegosaursm" or v.Type == "triceratopssm" or v.Type == "triceratops" or v.Type == "triceratopslg" or v.Type == "parasaur" or v.Type == "parasaursm" or v.Type == "parasaurlg" or v.Type == "brachiosaurus" or v.Type == "brachiosaurussm" or v.Type == "brachiosauruslg" or v.Type == "gallimussm" or v.Type == "gallimuslg" or v.Type == "allosaurussm" or v.Type == "allosauruslg" or v.Type == "tyrex" or v.Type == "tyrexlg" then
            v.Destroy()
        end
    end
    if M0True then
        allactors = Multi0.GetActors()
        for i, v in pairs(allactors) do
            if v.Type == "camera" or v.Type == "e7" or v.Type == "medi" or v.Type == "e1" or v.Type == "e3" or v.Type == "e6" or v.Type == "volk" or v.Type == "e2" or v.Type == "shok" then
                v.Destroy()
            end
        end
    end
    if M1True then
        allactors = Multi1.GetActors()
        for i, v in pairs(allactors) do
            if v.Type == "camera" or v.Type == "e7" or v.Type == "medi" or v.Type == "e1" or v.Type == "e3" or v.Type == "e6" or v.Type == "volk" or v.Type == "e2" or v.Type == "shok" then
                v.Destroy()
            end
        end
    end
    if M2True then
        allactors = Multi2.GetActors()
        for i, v in pairs(allactors) do
            if v.Type == "camera" or v.Type == "e7" or v.Type == "medi" or v.Type == "e1" or v.Type == "e3" or v.Type == "e6" or v.Type == "volk" or v.Type == "e2" or v.Type == "shok" then
                v.Destroy()
            end
        end
    end
    if M3True then
        allactors = Multi3.GetActors()
        for i, v in pairs(allactors) do
            if v.Type == "camera" or v.Type == "e7" or v.Type == "medi" or v.Type == "e1" or v.Type == "e3" or v.Type == "e6" or v.Type == "volk" or v.Type == "e2" or v.Type == "shok" then
                v.Destroy()
            end
        end
    end
    if M4True then
        allactors = Multi4.GetActors()
        for i, v in pairs(allactors) do
            if v.Type == "camera" or v.Type == "e7" or v.Type == "medi" or v.Type == "e1" or v.Type == "e3" or v.Type == "e6" or v.Type == "volk" or v.Type == "e2" or v.Type == "shok" then
                v.Destroy()
            end
        end
    end
end

function RemoveMateriasUnits()
    allactors = Materia.GetActors()
    for i, v in pairs(allactors) do
        if v.HasProperty("Health") and v.Type ~= "td03" then
            if v.HasProperty("Move") then
                v.Stop()
            end
            v.Destroy()
        end
    end
end

function RemoveEnemysUnits()
    allactors = Enemys.GetActors()
    for i, v in pairs(allactors) do
        if v.HasProperty("Health") and v.Type ~= "td03" then
            if v.HasProperty("Move") then
                v.Stop()
            end
            v.Destroy()
        end
    end
end

function StartDinoMission()
    if Multi0 then
        newPP = Actor.Create("td03", true, { Location = CPos.New(0, 0), Owner = Multi0 })
    end
    if Multi1 then
        newPP = Actor.Create("td03", true, { Location = CPos.New(0, 0), Owner = Multi1 })
    end
    if Multi2 then
        newPP = Actor.Create("td03", true, { Location = CPos.New(0, 0), Owner = Multi2 })
    end
    if Multi3 then
        newPP = Actor.Create("td03", true, { Location = CPos.New(0, 0), Owner = Multi3 })
    end
    if Multi4 then
        newPP = Actor.Create("td03", true, { Location = CPos.New(0, 0), Owner = Multi4 })
    end
    newPP = Actor.Create("td03", true, { Location = CPos.New(0, 0), Owner = Enemys })

end

ChronoLight = function()
    Lighting.Ambient = Light
    if Light < 10 then
        Light = Light + 0.5
        Trigger.AfterDelay(1, function()
            ChronoLight()
        end)
    elseif not chronoExploded then
        chronoExploded = true
        Lighting.Ambient = 1
        RainbowLight()
        Trigger.AfterDelay(DateTime.Seconds(2), function()
            rainbowTimeOver = true
            Lighting.Red = 1
            Lighting.Green = 1
            Lighting.Blue = 1
            Lighting.Ambient = 1
            Light = 1
            Lighting.Flash("LightningStrike", 28)
            Trigger.AfterDelay(29, function()
                Lighting.Ambient = 1
            end)
        end)
    end
end
Colours = { "Red", "Yellow", "Blue" }
rainbowTimeOver = false
RainbowLight = function()
    Lighting.Ambient = Utils.RandomInteger(0, 10)
    if not rainbowTimeOver then
        Colour = Utils.Random(Colours)
        if Colour == "Red" then
            Lighting.Red = 1
            Lighting.Green = 0
            Lighting.Blue = 0
        elseif Colour == "Yellow" then
            Lighting.Red = 0
            Lighting.Green = 1
            Lighting.Blue = 0
        elseif Colour == "Blue" then
            Lighting.Red = 0
            Lighting.Green = 0
            Lighting.Blue = 1
        end
        Trigger.AfterDelay(1, function()
            RainbowLight()
        end)
    end
end

Switchview = function()
    burningHeli = Actor.Create("tran.husk2", true, { Location = HeliHuskSpawn.Location, Owner = Materia })
    Camera.Position = burningHeli.CenterPosition
end

setRightGaps = function()
    biggap = Actor.Create("bigmgg", true, { Location = CPos.New(114, 11), Owner = Neutral })
    biggap = Actor.Create("bigmgg", true, { Location = CPos.New(114, 32), Owner = Neutral })
    biggap = Actor.Create("bigmgg", true, { Location = CPos.New(114, 101), Owner = Neutral })
end

setLeftGaps = function()
    biggap = Actor.Create("bigmgg", true, { Location = CPos.New(40, 11), Owner = Neutral })
    biggap = Actor.Create("bigmgg", true, { Location = CPos.New(40, 33), Owner = Neutral })
    biggap = Actor.Create("bigmgg", true, { Location = CPos.New(40, 68), Owner = Neutral })
    biggap = Actor.Create("bigmgg", true, { Location = CPos.New(40, 101), Owner = Neutral })
end

setMissingActors = function()
    NewActor = Actor.Create("ctflagra", true, { Location = ctflagraPoint.Location, Owner = Neutral })
    NewActor = Actor.Create("oilb", true, { Location = oilbPoint.Location, Owner = Neutral })
    NewActor = Actor.Create("ctflag", true, { Location = ctflagPoint.Location, Owner = Neutral })
    NewActor = Actor.Create("ctflag", true, { Location = ctflag2Point.Location, Owner = Neutral })
    NewActor = Actor.Create("ctflag", true, { Location = ctflag3Point.Location, Owner = Neutral })
end

ChronoshiftAlliedUnits = function()
    local cells = Utils.ExpandFootprint({ chronoPoint.Location }, false)
    local units = {}
    for i = 1, #cells do
        local unit = Actor.Create("ftrk", true, { Owner = Enemys, Facing = Angle.North })
        BindActorTriggers(unit)
        units[unit] = cells[i]
    end
    Chronosphere.Chronoshift(units)
end

brachioUnits = { "brachiosaurus", "brachiosaurus", "brachiosauruslg", "brachiosauruslg", "brachiosaurussm" }

BrachioIncome = function()
    if Dinos then
        Attackpath0 = { brachioway1.Location, brachioway2.Location, brachioway3.Location, brachioway4.Location,
            brachioway8.Location, brachioway9.Location, brachioway10.Location }
        randomBrachioUnit = Utils.Random(brachioUnits)
        Brachiosaurus = Actor.Create(randomBrachioUnit, true, { Location = enemyway4.Location, Owner = Herbivores })
        Brachiosaurus.Stance = "ReturnFire"
        Enemy0 = { Brachiosaurus }
        MovePatrol(Enemy0, Attackpath0, DateTime.Seconds(0))
    end
    Trigger.AfterDelay(1, function()
        Trigger.AfterDelay(DateTime.Seconds(Utils.RandomInteger(brachioDelayTimeMin, brachioDelayTimeMax)), function()
            BrachioIncome()
        end)
    end)
end

northGallimusTriggered = false
allosaurusTriggered = false

SetDinoTriggers = function()
    -- Cameratrigger

    Trigger.OnEnteredFootprint({ CPos.New(118, 67), CPos.New(118, 68), CPos.New(118, 69), CPos.New(118, 70) },
        function(a, id)
        if a.Owner ~= Herbivores and a.Owner ~= Carnivores and Dinos then
            Trigger.RemoveFootprintTrigger(id)
            newCam1 = Actor.Create("camera", true, { Location = camspot1.Location, Owner = a.Owner })
            newCam2 = Actor.Create("camera", true, { Location = camspot2.Location, Owner = a.Owner })
            newCam3 = Actor.Create("camera", true, { Location = camspot3.Location, Owner = a.Owner })
            newCam4 = Actor.Create("camera", true, { Location = camspot4.Location, Owner = a.Owner })
        end
    end)

    -- StegoEggTrigger

    Trigger.OnEnteredFootprint(
        { CPos.New(98, 98), CPos.New(98, 99), CPos.New(98, 100), CPos.New(109, 96), CPos.New(109, 97), CPos.New(109, 98),
            CPos.New(109, 99), CPos.New(109, 100) },
        function(a, id)
            if a.Owner ~= Herbivores and a.Owner ~= Carnivores and Dinos then
                Trigger.RemoveFootprintTrigger(id)
                allactors = Herbivores.GetActors()
                for i, v in pairs(allactors) do
                    if v.Type == stegoUnit then
                        if stegoCount > 0 then
                            v.Stop()
                            v.Stance = "AttackAnything"
                            v.AttackMove(stegosaurusway1.Location)
                            stegoCount = stegoCount - 1
                        end
                    end
                end
            end
        end)

    -- TriceraEggTrigger

    Trigger.OnEnteredFootprint({ CPos.New(96, 53), CPos.New(96, 54), CPos.New(96, 55) },
        function(a, id)
            if a.Owner ~= Herbivores and a.Owner ~= Carnivores and Dinos then
                Trigger.RemoveFootprintTrigger(id)
                allactors = Herbivores.GetActors()
                for i, v in pairs(allactors) do
                    if v.Type == triceraUnit then
                        if triceraCount > 0 then
                            v.Stop()
                            v.Stance = "AttackAnything"
                            v.AttackMove(triceratopsway1.Location)
                            triceraCount = triceraCount - 1
                        end
                    end
                end
            end
        end)

    -- AllosaurusEggTrigger

    Trigger.OnEnteredFootprint({ CPos.New(138, 97), CPos.New(138, 98), CPos.New(138, 99), CPos.New(138, 100) },
        function(a, id)
            if a.Owner ~= Herbivores and a.Owner ~= Carnivores and Dinos and Difficulty ~= "easy" and not allosaurusTriggered then
                allosaurusTriggered = true
                Trigger.RemoveFootprintTrigger(id)
                AlloAttack()
            end
        end)

    -- ParasaurAttackTrigger

    Trigger.OnEnteredFootprint({ CPos.New(87, 67), CPos.New(87, 68) }, function(a, id)
        if a.Owner ~= Herbivores and a.Owner ~= Carnivores and Dinos then
            Trigger.RemoveFootprintTrigger(id)
            allactors = Herbivores.GetActors()
            for i, v in pairs(allactors) do
                if v.Type == "parasaur" or v.Type == "parasaurlg" or v.Type == "parasaursm" then
                    v.Stance = "AttackAnything"
                end
            end
        end
    end)

    -- GallimusAttackTriggerNorth

    Trigger.OnEnteredFootprint({ CPos.New(141, 38), CPos.New(141, 39), CPos.New(141, 40) },
        function(a, id)
            if a.Owner ~= Herbivores and a.Owner ~= Carnivores and Dinos and not northGallimusTriggered then
                northGallimusTriggered = true
                Trigger.RemoveFootprintTrigger(id)
                GallimusNorthIncome()
            end
        end)

    -- Brachisaurus Remover

    Trigger.OnEnteredFootprint({ brachioway10.Location }, function(a, id)
        if Dinos then
            a.Destroy()
        end
    end)

    -- Herbivores attacked triggers

    allactors = Herbivores.GetActors()
    for i, v in pairs(allactors) do
        if v.Type == "stegosaur" or v.Type == "stegosaursm" or v.Type == "stegosaurlg" or v.Type == "triceratops" or v.Type == "triceratopssm" or v.Type == "triceratopslg" then
            Trigger.OnDamaged(v, function(unit)
                if unit.Health < unit.MaxHealth * 5 / 6 and Difficulty ~= "easy" then
                    v.Stance = "AttackAnything"
                end
            end)
        end
    end

    -- Egg Triggers

    allGallimusEggs = { gallimusegg1, gallimusegg2, gallimusegg3 }
    allAllosaurusEggs = { allosaurusegg1, allosaurusegg2, allosaurusegg3 }
    alltriceratopseggs = { triceratopsegg1, triceratopsegg2, triceratopsegg3 }
    allparasaureggs = { parasauregg1, parasauregg2, parasauregg3 }
    allstegosauruseggs = { stegosaurusegg1, stegosaurusegg2, stegosaurusegg3 }
    allbrachiosauruseggs = { brachiosaurusegg1, brachiosaurusegg2, brachiosaurusegg4 }
    allTrexeggs = { trexegg1, trexegg2, trexegg3 }

    -- onAllKilledOrCaptured

    Trigger.OnAllKilledOrCaptured(allGallimusEggs, GallimusIncome)
    Trigger.OnAllKilledOrCaptured(alltriceratopseggs, TriceratopsComeHome)
    Trigger.OnAllKilledOrCaptured(allparasaureggs, ParasaurusComeHome)
    Trigger.OnAllKilledOrCaptured(allstegosauruseggs, StegosaurusComeHome)
    Trigger.OnAllKilledOrCaptured(allbrachiosauruseggs, BrachiosaurusGetAngry)
    Trigger.OnAllKilledOrCaptured(allTrexeggs, TrexComeHome)

    -- OnCapture

    Trigger.OnCapture(triceratopsegg1, function()
        TrexAttack()
        TeleportEgg(triceratopsegg1, triceratopsegg1.Owner)
        triceratopsegg1.Destroy()
    end)

    Trigger.OnCapture(triceratopsegg2, function()
        TrexAttack()
        TeleportEgg(triceratopsegg2, triceratopsegg2.Owner)
        triceratopsegg2.Destroy()
    end)

    Trigger.OnCapture(triceratopsegg3, function()
        TrexAttack()
        TeleportEgg(triceratopsegg3, triceratopsegg3.Owner)
        triceratopsegg3.Destroy()
    end)

    Trigger.OnCapture(stegosaurusegg1, function()
        AlloAttack()
        TeleportEgg(stegosaurusegg1, stegosaurusegg1.Owner)
        stegosaurusegg1.Destroy()
    end)


    Trigger.OnCapture(stegosaurusegg2, function()
        AlloAttack()
        TeleportEgg(stegosaurusegg2, stegosaurusegg2.Owner)
        stegosaurusegg2.Destroy()
    end)


    Trigger.OnCapture(stegosaurusegg3, function()
        AlloAttack()
        TeleportEgg(stegosaurusegg3, stegosaurusegg3.Owner)
        stegosaurusegg3.Destroy()
    end)

    Trigger.OnCapture(gallimusegg1, function()
        TeleportEgg(gallimusegg1, gallimusegg1.Owner)
        gallimusegg1.Destroy()
    end)
    Trigger.OnCapture(gallimusegg2, function()
        TeleportEgg(gallimusegg2, gallimusegg2.Owner)
        gallimusegg2.Destroy()
    end)
    Trigger.OnCapture(gallimusegg3, function()
        TeleportEgg(gallimusegg3, gallimusegg3.Owner)
        gallimusegg3.Destroy()
    end)
    Trigger.OnCapture(allosaurusegg1, function()
        TeleportEgg(allosaurusegg1, allosaurusegg1.Owner)
        allosaurusegg1.Destroy()
    end)
    Trigger.OnCapture(allosaurusegg2, function()
        TeleportEgg(allosaurusegg2, allosaurusegg2.Owner)
        allosaurusegg2.Destroy()
    end)
    Trigger.OnCapture(allosaurusegg3, function()
        TeleportEgg(allosaurusegg3, allosaurusegg3.Owner)
        allosaurusegg3.Destroy()
    end)
    Trigger.OnCapture(parasauregg1, function()
        TeleportEgg(parasauregg1, parasauregg1.Owner)
        parasauregg1.Destroy()
    end)
    Trigger.OnCapture(parasauregg2, function()
        TeleportEgg(parasauregg2, parasauregg2.Owner)
        parasauregg2.Destroy()
    end)
    Trigger.OnCapture(parasauregg3, function()
        TeleportEgg(parasauregg3, parasauregg3.Owner)
        parasauregg3.Destroy()
    end)
    Trigger.OnCapture(brachiosaurusegg1, function()
        TeleportEgg(brachiosaurusegg1, brachiosaurusegg1.Owner)
        brachiosaurusegg1.Destroy()
    end)
    Trigger.OnCapture(brachiosaurusegg2, function()
        TeleportEgg(brachiosaurusegg2, brachiosaurusegg2.Owner)
        brachiosaurusegg2.Destroy()
    end)
    Trigger.OnCapture(brachiosaurusegg3, function()
        TeleportEgg(brachiosaurusegg3, brachiosaurusegg3.Owner)
        brachiosaurusegg3.Destroy()
    end)

    Trigger.OnCapture(brachiosaurusegg4, function()
        TeleportEgg(brachiosaurusegg4, brachiosaurusegg4.Owner)
        brachiosaurusegg4.Destroy()
    end)
    Trigger.OnCapture(trexegg1, function()
        TeleportEgg(trexegg1, trexegg1.Owner)
        trexegg1.Destroy()
    end)
    Trigger.OnCapture(trexegg2, function()
        TeleportEgg(trexegg2, trexegg2.Owner)
        trexegg2.Destroy()
    end)
    Trigger.OnCapture(trexegg3, function()
        TeleportEgg(trexegg3, trexegg3.Owner)
        trexegg3.Destroy()
    end)
end

horizontalOffset = 0
verticalOffset = 0
eggPosition = CPos.New(15, 33)

TeleportEgg = function(egg, owner)
    if Dinos then
        if owner == Multi0 then
            eggPosition = CPos.New(16, 23) + CVec.New(horizontalOffset, verticalOffset)
        elseif owner == Multi1 then
            eggPosition = CPos.New(16, 36) + CVec.New(horizontalOffset, verticalOffset)
        elseif owner == Multi2 then
            eggPosition = CPos.New(16, 44) + CVec.New(horizontalOffset, verticalOffset)
        elseif owner == Multi3 then
            eggPosition = CPos.New(16, 64) + CVec.New(horizontalOffset, verticalOffset)
        elseif owner == Multi4 then
            eggPosition = CPos.New(16, 87) + CVec.New(horizontalOffset, verticalOffset)
        end

        newEgg = Actor.Create(egg.Type, true, { Location = eggPosition, Owner = owner })
        horizontalOffset = horizontalOffset + 2
        if horizontalOffset > 10 then
            horizontalOffset = 0
            verticalOffset = verticalOffset + 2
        end
    end
end

function GallimusNorthIncome()
    if Dinos and Difficulty ~= "easy" then
        newGallimus = Actor.Create(gallimusUnit, true, { Location = gallimusNorthway1.Location, Owner = Carnivores })
        Enemy0 = { newGallimus }
        Attackpath0 = { gallimusNorthway2.Location, gallimusNorthway3.Location }
        GroupPatrol(Enemy0, Attackpath0, DateTime.Seconds(0))
        gallimusCount2 = gallimusCount2 - 1
        if gallimusCount2 > 0 then
            Trigger.AfterDelay(DateTime.Seconds(1), function()
                GallimusNorthIncome()
            end)
        end
    end
end

TriceratopsComeHome = function()
    if Dinos and Difficulty ~= "easy" then
        TriceraAlert = true
        allactors = Herbivores.GetActors()
        for i, v in pairs(allactors) do
            if v.Type == "triceratops" or v.Type == "triceratopssm" or v.Type == "triceratopslg" then
                v.Stance = "AttackAnything"
                v.AttackMove(triceratopsway1.Location)
            end
        end
    end
end
ParasaurusComeHome = function()
    if Dinos and Difficulty ~= "easy" then
        allactors = Herbivores.GetActors()
        for i, v in pairs(allactors) do
            if v.Type == "parasaur" or v.Type == "parasaurlg" or v.Type == "parasaursm" then
                v.Stance = "AttackAnything"
                v.AttackMove(parasaurusway1.Location)
            end
        end
    end
end

StegosaurusComeHome = function()
    if Dinos and Difficulty ~= "easy" then
        StegoAlert = true
        allactors = Herbivores.GetActors()
        for i, v in pairs(allactors) do
            if v.Type == "stegosaur" or v.Type == "stegosaursm" or v.Type == "stegosaurlg" then
                v.Stance = "AttackAnything"
                v.AttackMove(stegosaurusway1.Location)
            end
        end
    end
end

BrachiosaurusGetAngry = function()
    if Dinos and Difficulty ~= "easy" then
        allactors = Herbivores.GetActors()
        for i, v in pairs(allactors) do
            if v.Type == "brachiosaurus" or v.Type == "brachiosauruslg" or v.Type == "brachiosaurussm" then
                v.Stance = "AttackAnything"
            end
        end
        AttackingBrachiosaurus = Actor.Create("brachiosauruslg", true,
            { Location = enemyway4.Location, Owner = Herbivores })
        AttackingBrachiosaurus.AttackMove(brachioAttackWay.Location)
    end
end

TrexComeHome = function()
    if Dinos and Difficulty ~= "easy" then
        allactors = Carnivores.GetActors()
        for i, v in pairs(allactors) do
            if v.Type == "trex" or v.Type == "trexlg" or v.Type == "trexsm" then
                v.Stance = "AttackAnything"
                v.Move(trexway1.Location)
            end
        end
    end
end

trexAttacked = false

trexMoves = { trexMove1, southMove1, southMove2, southMove3, southMove4, southMove5, northMove1, northMove2, northMove3,
    northMove4, northMove5 }

TrexAttack = function()
    if Dinos and Difficulty ~= "easy" and not trexAttacked then
        RandomTrexMove = Utils.Random(trexMoves)
        trexAttacked = true
        allactors = Carnivores.GetActors()
        for i, v in pairs(allactors) do
            if v.Type == "tyrex" or v.Type == "tyrexlg" then
                v.Move(RandomTrexMove.Location)
            end
        end
    end
end

AlloAttack = function()
    if Dinos and Difficulty ~= "easy" then
        newAllo = Actor.Create(alloUnit, true, { Location = alloWay1.Location, Owner = Carnivores })
        Enemy0 = { newAllo }
        Attackpath0 = { gallimusway2.Location, gallimusway5.Location, alloWay2.Location, camspot2.Location, }
        GroupPatrol(Enemy0, Attackpath0, DateTime.Seconds(15))
        alloCount = alloCount - 1
        if alloCount > 0 then
            Trigger.AfterDelay(DateTime.Seconds(3), function()
                AlloAttack()
            end)
        end
    end
end

LoadDinoDifficultyRules = function()
    if Difficulty == "easy" then
        playerStartingUnits =
        {
            germany = { "e7.mission", "medi", "e1", "e1", "e3", "e3", "e3", "e6", "e6" },
            france = { "e7.mission", "medi", "medi", "e1", "e1", "e3", "e3", "e3", "e6" },
            england = { "e7.mission", "medi", "e1", "e1", "e1", "e3", "e3", "e3", "e3", "e6" },
            ukraine = { "volk", "e1", "e1", "e1", "e2", "e2", "e2", "e3", "e3", "e3", "e6" },
            russia = { "volk", "e1", "e1", "e2", "shok", "shok", "shok", "e6" },
        }
        brachioDelayTimeMin = 10
        brachioDelayTimeMax = 20
        gallimusCount = 1
        gallimusUnit = "gallimussm"
        stegoCount = 1
        stegoUnit = "stegosaursm"
        triceraCount = 1
        triceraUnit = "triceratopssm"
        alloCount = 1
        alloUnit = "allosaurussm"
    elseif Difficulty == "normal" then
        playerStartingUnits =
        {
            germany = { "e7.mission", "medi", "e1", "e1", "e3", "e3", "e6", "e6" },
            france = { "e7.mission", "medi", "medi", "e1", "e1", "e3", "e3", "e6" },
            england = { "e7.mission", "medi", "e1", "e1", "e1", "e3", "e3", "e3", "e6" },
            ukraine = { "volk", "e1", "e1", "e2", "e2", "e2", "e3", "e3", "e6", "e6" },
            russia = { "volk", "e1", "e1", "e2", "shok", "shok", "e6" },
        }
        brachioDelayTimeMin = 4
        brachioDelayTimeMax = 15
        gallimusCount = 2
        gallimusCount2 = 2
        gallimusUnit = "gallimus"
        stegoCount = 2
        stegoUnit = "stegosaur"
        triceraCount = 2
        triceraUnit = "triceratops"
        alloCount = 2
        alloUnit = "allosaurus"
    elseif Difficulty == "hard" then
        playerStartingUnits =
        {
            germany = { "e7.mission", "medi", "e1", "e3", "e6", "e6" },
            france = { "e7.mission", "medi", "medi", "e1", "e3", "e6" },
            england = { "e7.mission", "medi", "e1", "e1", "e3", "e3", "e6" },
            ukraine = { "volk", "e1", "e1", "e2", "e2", "e3", "e3", "e6" },
            russia = { "volk", "e1", "e2", "shok", "e6" },
        }
        brachioDelayTimeMin = 3
        brachioDelayTimeMax = 10
        gallimusCount = 3
        gallimusCount2 = 3
        gallimusUnit = "gallimuslg"
        stegoCount = 3
        stegoUnit = "stegosaurlg"
        triceraCount = 3
        triceraUnit = "triceratopslg"
        alloCount = 3
        alloUnit = "allosauruslg"
    end
end

GallimusIncome = function()
    if Dinos then
        newGallimus = Actor.Create(gallimusUnit, true, { Location = gallimusway1.Location, Owner = Carnivores })
        Enemy0 = { newGallimus }
        Attackpath0 = { gallimusway2.Location, gallimusway3.Location, gallimusway4.Location, gallimusway5.Location }
        GroupPatrol(Enemy0, Attackpath0, DateTime.Seconds(0))
        gallimusCount = gallimusCount - 1
        if gallimusCount > 0 then
            Trigger.AfterDelay(DateTime.Seconds(1), function()
                GallimusIncome()
            end)
        end
    end
end

ParasaurusMove = function()
    allactors = Herbivores.GetActors()
    for i, v in pairs(allactors) do
        if v.Type == "parasaur" or v.Type == "parasaurlg" or v.Type == "parasaursm" then
            v.Move(parasaurMoveSpot.Location + CVec.New(Utils.RandomInteger(-3, 3), Utils.RandomInteger(-3, 3)))
        end
    end
end

northMoves = { northMove1, northMove2, northMove3, northMove4, northMove5 }
southMoves = { southMove1, southMove2, southMove3, southMove4, southMove5 }
stegosSouth = true
triceratopsNorth = true
stegoCount2 = 0
triceraCount2 = 0
StegoAlert = false
TriceraAlert = false

SetStegosaurusMove = function()
    if Dinos and not StegoAlert then
        if stegoCount2 >= 2 then
            stegosSouth = false
        end
        if stegoCount2 >= 5 then
            stegosSouth = true
        end
        if stegosSouth then
            RandomStegoMove = Utils.Random(southMoves)
        else
            RandomStegoMove = Utils.Random(northMoves)
        end
        Trigger.AfterDelay(DateTime.Seconds(Utils.RandomInteger(45, 100)), function()
            allactors = Herbivores.GetActors()
            for i, v in pairs(allactors) do
                if v.Type == "stegosaur" or v.Type == "stegosaursm" or v.Type == "stegosaurlg" then
                    v.Move(RandomStegoMove.Location + CVec.New(Utils.RandomInteger(-3, 3), Utils.RandomInteger(-3, 3)))
                end
            end
            stegoCount2 = stegoCount2 + 1
            SetStegosaurusMove()
        end)
    end
end

SetTriceratopsMove = function()
    if Dinos and not TriceraAlert then
        if triceraCount2 >= 3 then
            triceratopsNorth = false
        end
        if triceraCount2 >= 6 then
            triceratopsNorth = true
        end
        if triceratopsNorth then
            RandomTriceraMove = Utils.Random(northMoves)
        else
            RandomTriceraMove = Utils.Random(southMoves)
        end
        Trigger.AfterDelay(DateTime.Seconds(Utils.RandomInteger(30, 80)), function()
            allactors = Herbivores.GetActors()
            for i, v in pairs(allactors) do
                if v.Type == "triceratops" or v.Type == "triceratopssm" or v.Type == "triceratopslg" then
                    v.Move(RandomTriceraMove.Location + CVec.New(Utils.RandomInteger(-3, 3), Utils.RandomInteger(-3, 3)))
                end
            end
            triceraCount2 = triceraCount2 + 1
            SetTriceratopsMove()
        end)
    end
end

allDinos = { "gallimus", "allosaurus", "triceratops", "stegosaur", "brachiosaurus", "parasaur", "tyrex" }

SpawnRandomDinos = function()
    randomDino = Utils.Random(allDinos)
    if randomDino == "gallimus" then
        newEgg1 = Actor.Create("gallimusegg", true, { Location = randomEggSpawn1.Location, Owner = Neutral })
        Trigger.OnCapture(newEgg1, function()
            TeleportEgg(newEgg1, newEgg1.Owner)
            newEgg1.Destroy()
        end)
        newEgg2 = Actor.Create("gallimusegg", true, { Location = randomEggSpawn2.Location, Owner = Neutral })
        Trigger.OnCapture(newEgg2, function()
            TeleportEgg(newEgg2, newEgg2.Owner)
            newEgg2.Destroy()
        end)
        newEgg3 = Actor.Create("gallimusegg", true, { Location = randomEggSpawn3.Location, Owner = Neutral })
        Trigger.OnCapture(newEgg3, function()
            TeleportEgg(newEgg3, newEgg3.Owner)
            newEgg3.Destroy()
        end)
        newDino = Actor.Create("gallimus", true,
            {
                Location = randomUnitSpawn.Location + CVec.New(Utils.RandomInteger(-4, 4), Utils.RandomInteger(-4, 4)),
                Owner =
                    Carnivores
            })
        newDino.Scatter()
        newDino = Actor.Create("gallimuslg", true,
            {
                Location = randomUnitSpawn.Location + CVec.New(Utils.RandomInteger(-4, 4), Utils.RandomInteger(-4, 4)),
                Owner =
                    Carnivores
            })
        newDino.Scatter()
        newDino = Actor.Create("gallimus", true,
            {
                Location = randomUnitSpawn.Location + CVec.New(Utils.RandomInteger(-4, 4), Utils.RandomInteger(-4, 4)),
                Owner =
                    Carnivores
            })
        newDino.Scatter()
        newDino = Actor.Create("gallimuslg", true,
            {
                Location = randomUnitSpawn.Location + CVec.New(Utils.RandomInteger(-4, 4), Utils.RandomInteger(-4, 4)),
                Owner =
                    Carnivores
            })
        newDino.Scatter()
        newDino = Actor.Create("gallimussm", true,
            {
                Location = randomUnitSpawn.Location + CVec.New(Utils.RandomInteger(-4, 4), Utils.RandomInteger(-4, 4)),
                Owner =
                    Carnivores
            })
        newDino.Scatter()
        newDino = Actor.Create("gallimussm", true,
            {
                Location = randomUnitSpawn.Location + CVec.New(Utils.RandomInteger(-4, 4), Utils.RandomInteger(-4, 4)),
                Owner =
                    Carnivores
            })
        newDino.Scatter()
    elseif randomDino == "allosaurus" then
        newEgg1 = Actor.Create("allosaurusegg", true, { Location = randomEggSpawn1.Location, Owner = Neutral })
        Trigger.OnCapture(newEgg1, function()
            TeleportEgg(newEgg1, newEgg1.Owner)
            newEgg1.Destroy()
        end)
        newEgg2 = Actor.Create("allosaurusegg", true, { Location = randomEggSpawn2.Location, Owner = Neutral })
        Trigger.OnCapture(newEgg2, function()
            TeleportEgg(newEgg2, newEgg2.Owner)
            newEgg2.Destroy()
        end)
        newEgg3 = Actor.Create("allosaurusegg", true, { Location = randomEggSpawn3.Location, Owner = Neutral })
        Trigger.OnCapture(newEgg3, function()
            TeleportEgg(newEgg3, newEgg3.Owner)
            newEgg3.Destroy()
        end)
        newDino = Actor.Create("allosaurus", true,
            {
                Location = randomUnitSpawn.Location + CVec.New(Utils.RandomInteger(-4, 4), Utils.RandomInteger(-4, 4)),
                Owner =
                    Carnivores
            })
        newDino.Scatter()
        newDino = Actor.Create("allosauruslg", true,
            {
                Location = randomUnitSpawn.Location + CVec.New(Utils.RandomInteger(-4, 4), Utils.RandomInteger(-4, 4)),
                Owner =
                    Carnivores
            })
        newDino.Scatter()
        newDino = Actor.Create("allosaurussm", true,
            {
                Location = randomUnitSpawn.Location + CVec.New(Utils.RandomInteger(-4, 4), Utils.RandomInteger(-4, 4)),
                Owner =
                    Carnivores
            })
        newDino.Scatter()
    elseif randomDino == "triceratops" then
        newEgg1 = Actor.Create("triceratopsegg", true, { Location = randomEggSpawn1.Location, Owner = Neutral })
        Trigger.OnCapture(newEgg1, function()
            TeleportEgg(newEgg1, newEgg1.Owner)
            newEgg1.Destroy()
        end)
        newEgg2 = Actor.Create("triceratopsegg", true, { Location = randomEggSpawn2.Location, Owner = Neutral })
        Trigger.OnCapture(newEgg2, function()
            TeleportEgg(newEgg2, newEgg2.Owner)
            newEgg2.Destroy()
        end)
        newEgg3 = Actor.Create("triceratopsegg", true, { Location = randomEggSpawn3.Location, Owner = Neutral })
        Trigger.OnCapture(newEgg3, function()
            TeleportEgg(newEgg3, newEgg3.Owner)
            newEgg3.Destroy()
        end)
        newDino1 = Actor.Create("triceratops", true,
            {
                Location = randomUnitSpawn.Location + CVec.New(Utils.RandomInteger(-4, 4), Utils.RandomInteger(-4, 4)),
                Owner =
                    Carnivores
            })
        newDino1.Stance = "ReturnFire"
        Trigger.OnDamaged(newDino1, function(unit)
            if unit.Health < unit.MaxHealth * 5 / 6 and Difficulty ~= "easy" then
                unit.Stance = "AttackAnything"
            end
        end)
        newDino1.Scatter()
        newDino2 = Actor.Create("triceratopslg", true,
            {
                Location = randomUnitSpawn.Location + CVec.New(Utils.RandomInteger(-4, 4), Utils.RandomInteger(-4, 4)),
                Owner =
                    Carnivores
            })
        newDino2.Stance = "ReturnFire"
        Trigger.OnDamaged(newDino2, function(unit)
            if unit.Health < unit.MaxHealth * 5 / 6 and Difficulty ~= "easy" then
                unit.Stance = "AttackAnything"
            end
        end)
        newDino2.Scatter()
        newDino3 = Actor.Create("triceratopssm", true,
            {
                Location = randomUnitSpawn.Location + CVec.New(Utils.RandomInteger(-4, 4), Utils.RandomInteger(-4, 4)),
                Owner =
                    Carnivores
            })
        newDino3.Stance = "ReturnFire"
        Trigger.OnDamaged(newDino3, function(unit)
            if unit.Health < unit.MaxHealth * 5 / 6 and Difficulty ~= "easy" then
                unit.Stance = "AttackAnything"
            end
        end)
        newDino3.Scatter()
    elseif randomDino == "stegosaur" then
        newEgg1 = Actor.Create("stegosaurusegg", true, { Location = randomEggSpawn1.Location, Owner = Neutral })
        Trigger.OnCapture(newEgg1, function()
            TeleportEgg(newEgg1, newEgg1.Owner)
            newEgg1.Destroy()
        end)
        newEgg2 = Actor.Create("stegosaurusegg", true, { Location = randomEggSpawn2.Location, Owner = Neutral })
        Trigger.OnCapture(newEgg2, function()
            TeleportEgg(newEgg2, newEgg2.Owner)
            newEgg2.Destroy()
        end)
        newEgg3 = Actor.Create("stegosaurusegg", true, { Location = randomEggSpawn3.Location, Owner = Neutral })
        Trigger.OnCapture(newEgg3, function()
            TeleportEgg(newEgg3, newEgg3.Owner)
            newEgg3.Destroy()
        end)
        newDino1 = Actor.Create("stegosaur", true,
            {
                Location = randomUnitSpawn.Location + CVec.New(Utils.RandomInteger(-4, 4), Utils.RandomInteger(-4, 4)),
                Owner =
                    Carnivores
            })
        newDino1.Stance = "ReturnFire"
        Trigger.OnDamaged(newDino1, function(unit)
            if unit.Health < unit.MaxHealth * 5 / 6 and Difficulty ~= "easy" then
                unit.Stance = "AttackAnything"
            end
        end)
        newDino1.Scatter()
        newDino2 = Actor.Create("stegosaurlg", true,
            {
                Location = randomUnitSpawn.Location + CVec.New(Utils.RandomInteger(-4, 4), Utils.RandomInteger(-4, 4)),
                Owner =
                    Carnivores
            })
        newDino2.Stance = "ReturnFire"
        Trigger.OnDamaged(newDino2, function(unit)
            if unit.Health < unit.MaxHealth * 5 / 6 and Difficulty ~= "easy" then
                unit.Stance = "AttackAnything"
            end
        end)
        newDino2.Scatter()
        newDino3 = Actor.Create("stegosaursm", true,
            {
                Location = randomUnitSpawn.Location + CVec.New(Utils.RandomInteger(-4, 4), Utils.RandomInteger(-4, 4)),
                Owner =
                    Carnivores
            })
        newDino3.Stance = "ReturnFire"
        Trigger.OnDamaged(newDino3, function(unit)
            if unit.Health < unit.MaxHealth * 5 / 6 and Difficulty ~= "easy" then
                unit.Stance = "AttackAnything"
            end
        end)
        newDino3.Scatter()
    elseif randomDino == "brachiosaurus" then
        newEgg1 = Actor.Create("brachiosaurusegg", true, { Location = randomEggSpawn1.Location, Owner = Neutral })
        Trigger.OnCapture(newEgg1, function()
            TeleportEgg(newEgg1, newEgg1.Owner)
            newEgg1.Destroy()
        end)
        newEgg2 = Actor.Create("brachiosaurusegg", true, { Location = randomEggSpawn2.Location, Owner = Neutral })
        Trigger.OnCapture(newEgg2, function()
            TeleportEgg(newEgg2, newEgg2.Owner)
            newEgg2.Destroy()
        end)
        newEgg3 = Actor.Create("brachiosaurusegg", true, { Location = randomEggSpawn3.Location, Owner = Neutral })
        Trigger.OnCapture(newEgg3, function()
            TeleportEgg(newEgg3, newEgg3.Owner)
            newEgg3.Destroy()
        end)
        newDino1 = Actor.Create("brachiosaurus", true,
            {
                Location = randomUnitSpawn.Location + CVec.New(Utils.RandomInteger(-4, 4), Utils.RandomInteger(-4, 4)),
                Owner =
                    Carnivores
            })
        newDino1.Stance = "ReturnFire"
        Trigger.OnDamaged(newDino1, function(unit)
            if unit.Health < unit.MaxHealth * 5 / 6 and Difficulty ~= "easy" then
                unit.Stance = "AttackAnything"
            end
        end)
        newDino1.Scatter()
        newDino2 = Actor.Create("brachiosauruslg", true,
            {
                Location = randomUnitSpawn.Location + CVec.New(Utils.RandomInteger(-4, 4), Utils.RandomInteger(-4, 4)),
                Owner =
                    Carnivores
            })
        newDino2.Stance = "ReturnFire"
        Trigger.OnDamaged(newDino2, function(unit)
            if unit.Health < unit.MaxHealth * 5 / 6 and Difficulty ~= "easy" then
                unit.Stance = "AttackAnything"
            end
        end)
        newDino2.Scatter()
        newDino3 = Actor.Create("brachiosaurussm", true,
            {
                Location = randomUnitSpawn.Location + CVec.New(Utils.RandomInteger(-4, 4), Utils.RandomInteger(-4, 4)),
                Owner =
                    Carnivores
            })
        newDino3.Stance = "ReturnFire"
        Trigger.OnDamaged(newDino3, function(unit)
            if unit.Health < unit.MaxHealth * 5 / 6 and Difficulty ~= "easy" then
                unit.Stance = "AttackAnything"
            end
        end)
        newDino3.Scatter()
    elseif randomDino == "parasaur" then
        newEgg1 = Actor.Create("parasauregg", true, { Location = randomEggSpawn1.Location, Owner = Neutral })
        Trigger.OnCapture(newEgg1, function()
            TeleportEgg(newEgg1, newEgg1.Owner)
            newEgg1.Destroy()
        end)
        newEgg2 = Actor.Create("parasauregg", true, { Location = randomEggSpawn2.Location, Owner = Neutral })
        Trigger.OnCapture(newEgg2, function()
            TeleportEgg(newEgg2, newEgg2.Owner)
            newEgg2.Destroy()
        end)
        newEgg3 = Actor.Create("parasauregg", true, { Location = randomEggSpawn3.Location, Owner = Neutral })
        Trigger.OnCapture(newEgg3, function()
            TeleportEgg(newEgg3, newEgg3.Owner)
            newEgg3.Destroy()
        end)
        newDino = Actor.Create("parasaur", true,
            {
                Location = randomUnitSpawn.Location + CVec.New(Utils.RandomInteger(-4, 4), Utils.RandomInteger(-4, 4)),
                Owner =
                    Carnivores
            })
        newDino.Stance = "ReturnFire"
        newDino.Scatter()
        newDino = Actor.Create("parasaurlg", true,
            {
                Location = randomUnitSpawn.Location + CVec.New(Utils.RandomInteger(-4, 4), Utils.RandomInteger(-4, 4)),
                Owner =
                    Carnivores
            })
        newDino.Stance = "ReturnFire"
        newDino.Scatter()
        newDino = Actor.Create("parasaursm", true,
            {
                Location = randomUnitSpawn.Location + CVec.New(Utils.RandomInteger(-4, 4), Utils.RandomInteger(-4, 4)),
                Owner =
                    Carnivores
            })
        newDino.Stance = "ReturnFire"
        newDino.Scatter()
    elseif randomDino == "tyrex" then
        newEgg1 = Actor.Create("trexegg", true, { Location = randomEggSpawn1.Location, Owner = Neutral })
        Trigger.OnCapture(newEgg1, function()
            TeleportEgg(newEgg1, newEgg1.Owner)
            newEgg1.Destroy()
        end)
        newEgg2 = Actor.Create("trexegg", true, { Location = randomEggSpawn2.Location, Owner = Neutral })
        Trigger.OnCapture(newEgg2, function()
            TeleportEgg(newEgg2, newEgg2.Owner)
            newEgg2.Destroy()
        end)
        newEgg3 = Actor.Create("trexegg", true, { Location = randomEggSpawn3.Location, Owner = Neutral })
        Trigger.OnCapture(newEgg3, function()
            TeleportEgg(newEgg3, newEgg3.Owner)
            newEgg3.Destroy()
        end)
        newDino = Actor.Create("tyrex", true,
            {
                Location = randomUnitSpawn.Location + CVec.New(Utils.RandomInteger(-4, 4), Utils.RandomInteger(-4, 4)),
                Owner =
                    Carnivores
            })
        newDino.Scatter()
        newDino = Actor.Create("tyrexlg", true,
            {
                Location = randomUnitSpawn.Location + CVec.New(Utils.RandomInteger(-4, 4), Utils.RandomInteger(-4, 4)),
                Owner =
                    Carnivores
            })
        newDino.Scatter()
        newDino = Actor.Create("tyrexsm", true,
            {
                Location = randomUnitSpawn.Location + CVec.New(Utils.RandomInteger(-4, 4), Utils.RandomInteger(-4, 4)),
                Owner =
                    Carnivores
            })
        newDino.Scatter()
    end
end

endDinoMission = function()
    Lighting.Flash("LightningStrike", Utils.RandomInteger(30, 20))
    Media.PlaySound("chrotnk1.aud")
    Trigger.AfterDelay(3, function()
        Lighting.Flash("LightningStrike", Utils.RandomInteger(30, 20))
        Media.PlaySound("chrotnk1.aud")
        StartDefendersGame()
        Trigger.AfterDelay(5, function()
            if M0True and Multi0.IsLocalPlayer then
                SetCamera(Multi0)
            elseif M1True and Multi1.IsLocalPlayer then
                SetCamera(Multi1)
            elseif M2True and Multi2.IsLocalPlayer then
                SetCamera(Multi2)
            elseif M3True and Multi3.IsLocalPlayer then
                SetCamera(Multi3)
            elseif M4True and Multi4.IsLocalPlayer then
                SetCamera(Multi4)
            end
            Lighting.Flash("LightningStrike", Utils.RandomInteger(30, 20))
            Media.PlaySound("chrotnk1.aud")
        end)
    end)
    Trigger.AfterDelay(DateTime.Seconds(1), function()
        Dinos = false
        Trigger.AfterDelay(DateTime.Seconds(2), function()

        end)
    end)
    Media.DisplayMessage("The dinos can be built by clicking on the egg, and the large dinos require a service depot and radar to be built.", "Materia", TimerColor)

end
