function addTriggers()
	for i, passenger in pairs(Map.NamedActors) do
		if (passenger.HasProperty("HasPassengers")) then
			Trigger.OnPassengerEntered(passenger, function(transport, passenger)
				transport.Owner = passenger.Owner
			end)
			Trigger.OnPassengerExited(passenger, function(transport, passenger)
				if (not transport.HasPassengers) then
					transport.Owner = neutralGarrison
				end
			end)
		end
	end
end

function WorldLoaded()
	neutralGarrison = Player.GetPlayer("NeutralGarrison")
	addTriggers()
    rules()
end

rules = function()
    Trigger.AfterDelay(DateTime.Seconds(3), function()
        Media.DisplayMessage ("Iraq: The tables have turned. Iran has thwarted our plans to control Khuzestan and are now likely to push for control of the Al Faw peninsula. Prepare for the defensive and then strike with venom!", "Mission", HSLColor.Green)
        Trigger.AfterDelay(DateTime.Seconds(10), function()
            Media.DisplayMessage ("Iran: Iraq failed to destroy our airfleet and we have driven all but a few ot of Khuzestan. Liberate the Jameh Mosque to boost morale. Show these Ba'athists our resolve and take control of the Al Faw Peninsula.", "Mission", HSLColor.Red)
            Trigger.AfterDelay(DateTime.Seconds(10), function()
                Media.DisplayMessage ("Western Powers: Help your ally to achieve victory, but in no case risk escalation by attacking each other. Nuclear world war is on the scales.", "Mission", HSLColor.Blue)
            end)
        end)
    end)
end

Tick = function ()

end