
TOAAwakened = false
SubTOAAwakened = false
Pyle2Awakened = false
TOADead = false

ActorRemovals = {
  easy = { },
  normal = { },
  hard = { },
}


AirstrikeDelayTimes = {
  easy = DateTime.Seconds(480),
  normal = DateTime.Seconds(360),
  hard = DateTime.Seconds(300),
}

AirstrikeAttacks = function()
  local comms = TOA.GetActorsByType('hq')
  if #comms == 0 then return end
  
  local StrikeCounter = 0
  local launchedIt = LaunchAIAirstrike(TOA, { GDI }, { 'a10scrip', 'a10scrip', 'a10scrip' }, { TOAAirstrikeSpawn1, TOAAirstrikeSpawn2, TOAAirstrikeSpawn3 })
  Utils.Do(CoopPlayers,function(PID)
	if PID ~= GDI then
		local ExtraLaunch = LaunchAIAirstrike(TOA, { PID }, { 'a10scrip', 'a10scrip', 'a10scrip' }, { TOAAirstrikeSpawn1, TOAAirstrikeSpawn2, TOAAirstrikeSpawn3 })
		if ExtraLaunch == true then
			StrikeCounter = StrikeCounter + 1
		end
	end
  end)
  if launchedIt == true then
	StrikeCounter = StrikeCounter + 1
  end
  if StrikeCounter > 0 then
	Media.DisplayMessage("Warning: TOA airstrike incoming.", "EVA", HSLColor.FromHex("00FF00"))
  end
  
  Trigger.AfterDelay(AirstrikeDelayTimes[Difficulty], AirstrikeAttacks)
end


AwakenTOA = function()
  if TOAAwakened == true then return end
  TOAAwakened = true
  
  local paths = {
    { TOAAtk1A.Location, TOAAtk1B.Location },
    { TOAAtk2A.Location, TOAAtk2B.Location },
    { TOAAtk3A.Location, TOAAtk3B.Location }
  }
  
  AiAttackProduction(TOA, paths, TOAAttackInfantryTypes, 'pyle')
  AiAttackProduction(TOA, paths, TOAAttackVehicleTypes, 'weap')
  Trigger.AfterDelay(TOAAirAttackDelayMax[Difficulty], function()
    AiAirAttackProduction(TOA, TOAAttackAirTypes)
  end)
  
  Trigger.AfterDelay(DateTime.Seconds(5), function()
    if not Eye.IsDead then
      local conditionToken = TOA.GrantCondition("ion-cannon-active")
      Trigger.OnKilled(Eye, function(self, killer)
        TOA.RevokeCondition(conditionToken)
      end)
    end
  end)
  
  Trigger.AfterDelay(DateTime.Seconds(60) + AirstrikeDelayTimes[Difficulty], AirstrikeAttacks)
end


InfantryRetaliation = {
  easy = { 'e1', 'e1', 'e1', 'e1', 'e1' },
  normal = { 'e1', 'e1', 'e1', 'e3', 'e3' },
  hard = { 'e2', 'e2', 'e2', 'e3', 'e3' }
}

VehicleRetaliation = {
  easy = { 'jeep', 'jeep', 'jeep' },
  normal = { 'jeep', 'jeep', 'mtnk' },
  hard = { 'jeep', 'jeep', 'mtnk', 'mtnk' }
}

AwakenSubTOA = function()
  if SubTOAAwakened == true then return end
  SubTOAAwakened = true
  
  Media.PlaySound('Klaxon.aud')
  
  local cam = Actor.Create("camera", true, { Owner = GDI, Location = Prox9.Location })
  Trigger.AfterDelay(DateTime.Seconds(15), function() cam.Destroy() end)
  
  local toBuildI = function() return InfantryRetaliation[Difficulty] end
  if Pyle3 ~= nil and not Pyle3.IsDead then
    ProduceUnits(SubTOA, Pyle3, nil, toBuildI, function(units)
      Utils.Do(units, function(unit) unit.Hunt() end)
    end)
  end
  
  local toBuildV = function() return VehicleRetaliation[Difficulty] end
  if Weap ~= nil and not Weap.IsDead then
    ProduceUnits(SubTOA, Weap, nil, toBuildV, function(units)
      Utils.Do(units, function(unit) unit.Hunt() end)
    end)
  end
end

AwakenPyle2 = function()
  if Pyle2Awakened == true then return end
  Pyle2Awakened = true
  
  Media.PlaySound('Klaxon.aud')
  
  local cam = Actor.Create("camera", true, { Owner = GDI, Location = Cam4.Location })
  Trigger.AfterDelay(DateTime.Seconds(15), function() cam.Destroy() end)
  
  local toBuildI = function() return InfantryRetaliation[Difficulty] end
  if Pyle2 ~= nil and not Pyle2.IsDead then
    ProduceUnits(TOA2, Pyle2, nil, toBuildI, function(units)
      Utils.Do(units, function(unit) unit.Hunt() end)
    end)
  end
end


-- TOA Attack Production Behavior -----

TOAAttackDelayMin = { easy = DateTime.Seconds(45), normal = DateTime.Seconds(30), hard = DateTime.Seconds(25) }
TOAAttackDelayMax = { easy = DateTime.Seconds(60), normal = DateTime.Seconds(45), hard = DateTime.Seconds(30) }

TOAAirAttackDelayMin = { easy = DateTime.Seconds(360), normal = DateTime.Seconds(270), hard = DateTime.Seconds(210) }
TOAAirAttackDelayMax = { easy = DateTime.Seconds(480), normal = DateTime.Seconds(300), hard = DateTime.Seconds(240) }

TOAAttackVehicleTypes = {
  easy = {
     { "jeep", "jeep", "mtnk", "mtnk" },
     { "jeep", "jeep", "mtnk", "mtnk", "msam" },
     { "mtnk", "mtnk", "mtnk", "mtnk" },
     { "mtnk", "mtnk", "mtnk", "msam", "msam" },
     { "htnk", "htnk", "htnk" },
     { "htnk", "htnk", "msam", "msam" },
     { "exosuit", "exosuit", "mtnk", "mtnk" },
     { "exosuit", "exosuit", "exosuit" },
     { "hovertnk", "hovertnk", "hovertnk", "hovertnk" },
  },
  normal = {
     { "jeep", "jeep", "mtnk", "mtnk", "msam", "msam" },
     { "mtnk", "mtnk", "mtnk", "mtnk", "msam", "msam" },
     { "htnk", "htnk", "htnk", "msam", "msam" },
     { "exosuit", "exosuit", "exosuit", "exosuit", "msam", "msam" },
     { "hovertnk", "hovertnk", "hovertnk", "hovertnk", "msam", "msam" },
  },
  hard = {
     { "jeep", "jeep", "mtnk", "mtnk", "msam", "msam", "msam" },
     { "mtnk", "mtnk", "mtnk", "mtnk", "msam", "msam", "msam" },
     { "htnk", "htnk", "htnk", "msam", "msam", "msam" },
     { "exosuit", "exosuit", "exosuit", "exosuit", "msam", "msam", "msam" },
     { "hovertnk", "hovertnk", "hovertnk", "hovertnk", "msam", "msam", "msam" },
  }
}

TOAAttackInfantryTypes ={
  easy = {
     { "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1" },
     { "e2", "e2", "e2", "e2", "e2", "e2", "e2", "e2" },
     { "e3", "e3", "e3", "e3", "e3", "e3", "e3", "e3" },
     { "e1", "e1", "e1", "e1", "e3", "e3", "e3", "e3" },
  },
  normal = {
     { "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1" },
     { "e2", "e2", "e2", "e2", "e2", "e2", "e2", "e2", "e2", "e2" },
     { "e3", "e3", "e3", "e3", "e3", "e3", "e3", "e3", "e3", "e3" },
     { "e1", "e1", "e1", "e1", "e1", "e3", "e3", "e3", "e3", "e3" },
  },
  hard = {
     { "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1" },
     { "e2", "e2", "e2", "e2", "e2", "e2", "e2", "e2", "e2", "e2", "e2", "e2", "e2", "e2", "e2" },
     { "e3", "e3", "e3", "e3", "e3", "e3", "e3", "e3", "e3", "e3", "e3", "e3", "e3", "e3", "e3" },
     { "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e3", "e3", "e3", "e3", "e3", "e3", "e3" },
  }
}

TOAAttackAirTypes = {
  easy = {
     { "orca", },
  },
  normal = {
     { "orcad" },
  },
  hard = {
     { "orcad" },
  }
}

AiAttackProduction = function(player, paths, productionOptions, factoryType)
  local production = Utils.Random(productionOptions[Difficulty])
  local path = Utils.Random(paths)
  local toBuild = function() return production end
  local factory = GetAvailableFactory(player, factoryType)
  
  if factory ~= nil then
    ProduceUnits(player, factory, nil, toBuild, function(units)
      UpdatePlayerBaseLocation()
      Utils.Do(units, function(unit)
        ErrorGuardAttackPatrol(unit, path)
        AssaultPlayerBaseOrHunt(unit)
      end)
      
      Trigger.AfterDelay(Utils.RandomInteger(TOAAttackDelayMin[Difficulty], TOAAttackDelayMax[Difficulty]), function()
        AiAttackProduction(player, paths, productionOptions, factoryType)
      end)
    end)
  else
    Trigger.AfterDelay(Utils.RandomInteger(TOAAttackDelayMin[Difficulty], TOAAttackDelayMax[Difficulty]), function()
      AiAttackProduction(player, paths, productionOptions, factoryType)
    end)
  end
end


AiAirAttackProduction = function(player, productionOptions)
  local production = Utils.Random(productionOptions[Difficulty])
  local factories = player.GetActorsByType('hpad')
  local airMax = 4
  if Difficulty == 'hard' then airMax = 6 end
  
  if #factories > 0 then
    Utils.Do(factories, function(factory)
      local aircraft = player.GetActorsByTypes({'orca', 'orcad'})
      if #aircraft < airMax then
        Reinforcements.Reinforce(player, production, { factory.Location }, 30, function(unit)
          --
        end)
      end
    end)
  end
  Trigger.AfterDelay(Utils.RandomInteger(TOAAirAttackDelayMin[Difficulty], TOAAirAttackDelayMax[Difficulty]), function()
    AiAirAttackProduction(player, productionOptions)
  end)
end

-- End TOA Attack Production Behavior -----


WorldLoaded = function()
  GDI = Player.GetPlayer("GDI")
  SubTOA = Player.GetPlayer("SubTOA")
  TOA = Player.GetPlayer("TOA")
  TOA2 = Player.GetPlayer("TOA2")
  Neutral = Player.GetPlayer("Neutral")
  
  MissionPlayer = GDI

	GoodGuy = Player.GetPlayer("GoodGuy")

	coopInfo =
	{
		Mainplayer = GDI,
		MainEnemies = {TOA, TOA2, SubTOA},
		Dummyplayer = GoodGuy
	}
	
	ORAMod = "tibalt"

	CoopInit25(coopInfo)

	if #CoopPlayers > 3 then
		Utils.Do(CoopPlayers,function(PID)
			if PID ~= CoopPlayers[1] and PID ~= CoopPlayers[2] and PID ~= CoopPlayers[3] then
				local NewTank = Actor.Create(HDR1.Type, true, { Owner = GoodGuy, Location = HDR1.Location })
				NewTank.Scatter()
			end
		end)
	end

  Camera.Position = StartCam.CenterPosition
  
  --Remove actors based on difficulty
  Utils.Do(ActorRemovals[Difficulty], function(unit)
    unit.Destroy()
  end)
  
  --Special lighting
  Lighting.Ambient = 0.75
  Lighting.Red = 0.7
  Lighting.Blue = 1.0
  Lighting.Green = 1.1
  
  --Player Reinforcements
  
  --Objectives
  InitObjectives(GDI)

  Trigger.AfterDelay(DateTime.Seconds(2), function()
    CaptureBioObjective = GDI.AddObjective("Capture the bio-research lab.")
    DestroyTOAObjective = GDI.AddObjective("Destroy the main TOA base.")
    CaptureFactObjective = GDI.AddObjective("Capture southwest construction yard.", "Secondary", false)
  end)
  
  Trigger.OnKilled(Bio, function(self, killer)
    Media.DisplayMessage("Mission-critical structure (bio-research lab) has been destroyed!", "ALERT", HSLColor.FromHex("FF0000"))
    PlayerFailMission()
  end)
  
  Trigger.OnCapture(Bio, function(self, captor, oldOwner, newOwner)
    if IsOwnedByCoopPlayer(captor) then GDI.MarkCompletedObjective(CaptureBioObjective) end
  end)
  
  Trigger.OnCapture(Fact, function(self, captor, oldOwner, newOwner)
    if IsOwnedByCoopPlayer(captor) then
      GDI.MarkCompletedObjective(CaptureFactObjective)
      AwakenTOA()
      
      local base = Map.ActorsInBox(BaseNW.CenterPosition, BaseSE.CenterPosition, function(actor)
        return actor.Owner == SubTOA and actor.Type ~= 'e1' and actor.Type ~= 'e2'
               and actor.Type ~= 'e3' and actor.Type ~= 'jeep' and actor.Type ~= 'mtnk'
      end)
      --Utils.Do(base, function(a) a.Owner = GDI end)
	  AssignToCoopPlayers(base, nil, true)
      
	  Trigger.AfterDelay(2, function()
		if not Proc1.IsDead then
			Actor.Create("harv", true, { Owner = Proc1.Owner, Location = Harv1.Location })
		end
		if not Proc2.IsDead then
			Actor.Create("harv", true, { Owner = Proc2.Owner, Location = Harv2.Location })
		end
	  end)
	  
	  if #MCVPlayers > 1 then
		Utils.Do(CoopPlayers,function(PID)
			if PID ~= newOwner then
				local NewMCV = Actor.Create("mcv", true, { Owner = PID, Location = Fact.Location })
				NewMCV.Scatter()
			end
		end)
	  end
    end
  end)
  
  --AI player behavior
  TOA.Cash = 10000
  TOA.Resources = TOA.ResourceCapacity - 500
  SetupRefAndSilosCaptureCredits(TOA)
  AutoReplaceHarvesters(TOA)
  AutoRepairAndRebuildBuildings(TOA, 15)
  
  TOA2.Cash = 10000
  
  SubTOA.Cash = 10000
  SubTOA.Resources = SubTOA.ResourceCapacity - 500
  SetupRefAndSilosCaptureCredits(SubTOA)
  
  Utils.Do( { Alert1, Alert2, Alert3, Alert4, Alert5, Alert6, Alert7, Alert8, Alert9, Alert10, Alert11, Alert12 }, function(unit)
    Trigger.OnKilled(unit, function(self, killer) AwakenSubTOA() end)
  end)
  
  Trigger.OnEnteredProximityTrigger(Prox3.CenterPosition, WDist.New(2 * 1024), function(a, id)
    if IsOwnedByCoopPlayer(a) and a.Type ~= 'camera' and a.Type ~= 'camera.small' then
      --local toBuildI = function() return Utils.Random(InfantryRetaliation[Difficulty]) end
	  local toBuildI = function() return InfantryRetaliation[Difficulty] end
      if Pyle1 ~= nil and not Pyle1.IsDead then
        ProduceUnits(TOA2, Pyle1, nil, toBuildI, function(units)
          Utils.Do(units, function(unit) unit.Hunt() end)
        end)
      end
    end
  end)
  
  Utils.Do({ Prox4A, Prox4B }, function(wp)
    Trigger.OnEnteredProximityTrigger(wp.CenterPosition, WDist.New(5 * 1024), function(a, id)
      if IsOwnedByCoopPlayer(a) and a.Type ~= 'camera' and a.Type ~= 'camera.small' then AwakenPyle2() end
    end)
  end)

  --Enemy Predeployed Maneuvers
  Utils.Do({ Patroller1A, Patroller1B, Patroller1C }, function(unit)
    unit.Patrol({ Patrol1B.Location, Patrol1C.Location, Patrol1D.Location,
                  Patrol1E.Location, Patrol1F.Location, Patrol1E.Location,
                  Patrol1D.Location, Patrol1C.Location, Patrol1B.Location, Patrol1A.Location
                  }, true, DateTime.Seconds(8))
  end)
  
  --Proximity Triggers/Reveals
  CoopSetUpProximityReveal(GDI, {Prox1}, {Cam1}, 3, 15, false)
  CoopSetUpProximityReveal(GDI, {Prox2}, {Prox2}, 15, 15, false)
  CoopSetUpProximityReveal(GDI, {Prox5}, {Cam5}, 2, 15, false)
  CoopSetUpProximityReveal(GDI, {Prox6}, {Cam6}, 2, 15, false)
  CoopSetUpProximityReveal(GDI, {Prox7}, {Cam7}, 2, 15, false)
  
  Trigger.OnEnteredProximityTrigger(Prox8.CenterPosition, WDist.New(18 * 1024), function(a, id)
    if IsOwnedByCoopPlayer(a) and a.Type ~= 'camera' and a.Type ~= 'camera.small' then
      Trigger.RemoveProximityTrigger(id)
      AwakenTOA()
    end
  end)
  
  Trigger.OnEnteredProximityTrigger(Prox9.CenterPosition, WDist.New(10 * 1024), function(a, id)
    if IsOwnedByCoopPlayer(a) and a.Type ~= 'camera' and a.Type ~= 'camera.small' then
      Trigger.RemoveProximityTrigger(id)
      AwakenSubTOA()
    end
  end)
  
  --Timer
  
  --Crate spawns
  Trigger.OnKilled(Truck1, function(self, killer)
    Actor.Create("healcrate", true, { Owner = GDI, Location = Truck1.Location })
  end)
  
  Trigger.OnKilled(Truck2, function(self, killer)
    Actor.Create("healcrate", true, { Owner = GDI, Location = Truck2.Location })
  end)
  
  Trigger.OnKilled(Truck3, function(self, killer)
    Actor.Create("moneycrate", true, { Owner = GDI, Location = Truck3.Location })
  end)
  
  Trigger.OnKilled(Truck4, function(self, killer)
    Actor.Create("moneycrate", true, { Owner = GDI, Location = Truck4.Location })
  end)
  
  Truck2.Kill()
  
  --Taunts
  
  --Testing
end


Tick = function()
	AssignToCoopPlayers(GoodGuy.GetActorsByTypes({"e6", "amphapc"}), nil, true)
	OncePerSecondChecks()
	OncePerThreeSecondChecks()
	--[[
	--Debug Functions
	HDR1.Health = HDR1.MaxHealth
	Actor268.Health = Actor268.MaxHealth
	]]
end

OncePerSecondChecks = function()
  if DateTime.GameTime > 1 and DateTime.GameTime % 25 == 0 then
    --
  end
end

OncePerThreeSecondChecks = function()
	if DateTime.GameTime > 1 and DateTime.GameTime % 75 == 0 then
  
    --if HasOneOf(GDI, LossCheckAll) == false then PlayerFailMission() end
	TibAltCoopLossCheck()
    
    if TOADead == false and HasOneOf(TOA, LossCheckCritical) == false then
      TOADead = true
      GDI.MarkCompletedObjective(DestroyTOAObjective)
    end
    
    if TOAAwakened == false then
      --local factories = GDI.GetActorsByTypes( {'weap', 'hpad'} )
	  local factories = {}
		Utils.Do(CoopPlayers,function(PID)
			Utils.Do(PID.GetActorsByTypes( {'weap', 'hpad'} ),function(UID)
				table.insert(factories,UID)
			end)
		end)
      if #factories > 0 then AwakenTOA() end
    end
    
    --manipulate AI funds
    ManipulatePlayerFunds(TOA)
    ControlAircraft(TOA)
	end
end


PlayerFailMission = function()
  if CaptureBioObjective ~= nil and not GDI.IsObjectiveCompleted(CaptureBioObjective) then
    GDI.MarkFailedObjective(CaptureBioObjective)
  end
  if DestroyTOAObjective ~= nil and not GDI.IsObjectiveCompleted(DestroyTOAObjective) then
    GDI.MarkFailedObjective(DestroyTOAObjective)
  end
  if CaptureFactObjective ~= nil and not GDI.IsObjectiveCompleted(CaptureFactObjective) then
    GDI.MarkFailedObjective(CaptureFactObjective)
  end
end
