PlayerCanLose = true
ForgottenFreed = false
Ctrl2Captured = false
Stage2Begin = false
HijackingTrucks = false
PowerPlantsDestroyed = 0

Outpost1Alerted = false
Outpost2Alerted = false
Outpost3Alerted = false

PlayerHasHavoc = false
PlayerHasGhostStalker = false
PlayerHasMedic = false
HijackingMutants = 0
MutantsRespawned = 0
ElitesRespawned = false

ActorRemovals = {
  easy = { Patroller1A, Patroller1B,
           Patroller2A, Patroller2B, Patroller2C, Patroller2D, Patroller2E,
           Patroller3A, Patroller3B,
           Patroller4A, Patroller4B },
  normal = { },
  hard = { HRM1, HRM2, Medic, Truck1 },
}


AlertOutpost1 = function()
  if Outpost1Alerted == true then return end
  Outpost1Alerted = true
  Media.PlaySound('Klaxon.aud')
  Media.DisplayMessage("Enemy forces detected! Battle stations!", "TOA Soldier", HSLColor.FromHex("F62E05"))
  Utils.Do( {Outpost1A, Outpost1B, Outpost1C, Outpost1D, Outpost1E, Outpost1F, Outpost1G}, function(unit)
    if not unit.IsDead then unit.Hunt() end
  end)
end

AlertOutpost2 = function()
  if Outpost2Alerted == true then return end
  Outpost2Alerted = true
  Media.PlaySound('Klaxon.aud')
  Media.DisplayMessage("Enemy forces detected! Battle stations!", "TOA Soldier", HSLColor.FromHex("F62E05"))
  Utils.Do( {Outpost2A, Outpost2B, Outpost2C, Outpost2D, Outpost2E, Outpost2F}, function(unit)
    if not unit.IsDead then unit.Hunt() end
  end)
end

AlertOutpost3 = function()
  if Outpost3Alerted == true then return end
  Outpost3Alerted = true
  Media.PlaySound('Klaxon.aud')
  Media.DisplayMessage("Enemy forces detected! Battle stations!", "TOA Soldier", HSLColor.FromHex("F62E05"))
  Utils.Do( {Outpost3A, Outpost3B, Outpost3C, Outpost3D}, function(unit)
    if not unit.IsDead then unit.Hunt() end
  end)
end


FreePrisoners = function()
  if ForgottenFreed == true then return end
  ForgottenFreed = true
  local prisoners = Forgotten.GetActorsByType('mutsldr')
  Utils.Do(prisoners, function(unit) unit.Owner = GoodGuy end)
  if #prisoners > 0 then
    Media.DisplayMessage("Thank you for freeing us, GDI. Let us take our revenge on these TOA swine!", "Forgotten", HSLColor.FromHex("00FF00"))
  end
  GDI.MarkCompletedObjective(FreeMutantsObjective)
end


HijackedTruckDestroy = function(truck)
  if MutantsRespawned < HijackingMutants then
    local mutantsToSpawn = HijackingMutants - MutantsRespawned
    if mutantsToSpawn > 5 then mutantsToSpawn = 5 end
    MutantsRespawned = MutantsRespawned + mutantsToSpawn
    for nameCount = 1, mutantsToSpawn do
      local location = truck.Location + CVec.New(Utils.RandomInteger(-1, 1), Utils.RandomInteger(-1, 1))
      Actor.Create("mutsldr", true, { Owner = GoodGuy, Location = location })
    end
  else
    if ElitesRespawned == false then
      ElitesRespawned = true
      if PlayerHasHavoc == true then
        local location = truck.Location + CVec.New(Utils.RandomInteger(-1, 1), Utils.RandomInteger(-1, 1))
        Actor.Create("rmbo", true, { Owner = GoodGuy, Location = location })
      end
      if PlayerHasGhostStalker == true then
        local location = truck.Location + CVec.New(Utils.RandomInteger(-1, 1), Utils.RandomInteger(-1, 1))
        Actor.Create("ghstlkr", true, { Owner = GoodGuy, Location = location })
      end
      if PlayerHasMedic == true then
        local location = truck.Location + CVec.New(Utils.RandomInteger(-1, 1), Utils.RandomInteger(-1, 1))
        Actor.Create("medi", true, { Owner = GoodGuy, Location = location })
      end
    end
  end
  PlayerCanLose = true
end


WorldLoaded = function()
  GDI = Player.GetPlayer("GDI")
  RuinedGDI = Player.GetPlayer("RuinedGDI")
  FakeGDI = Player.GetPlayer("FakeGDI")
  TOA = Player.GetPlayer("TOA")
  TOA3 = Player.GetPlayer("TOA3")
  Forgotten = Player.GetPlayer("Forgotten")
  Neutral = Player.GetPlayer("Neutral")
  
  MissionPlayer = GDI

	GoodGuy = Player.GetPlayer("GoodGuy")

	coopInfo =
	{
		Mainplayer = GDI,
		MainEnemies = {TOA, TOA3},
		Dummyplayer = GoodGuy
	}
	
	ORAMod = "tibalt"

	CoopInit25(coopInfo)
	
	if #CoopPlayers > 2 then
		Utils.Do(CoopPlayers,function(PID)
			if PID ~= CoopPlayers[1] and PID ~= CoopPlayers[2] then
				local NewEngi = Actor.Create("e6", true, { Owner = GoodGuy, Location = Actor1752.Location })
				NewEngi.Scatter()
			end
		end)
	end

  Camera.Position = StartCam.CenterPosition
  
  --Remove actors based on difficulty
  Utils.Do(ActorRemovals[Difficulty], function(unit)
    unit.Destroy()
  end)
  
  --Special lighting
  Lighting.Ambient = 0.7
  Lighting.Red = 1.3
  Lighting.Blue = 0.7
  Lighting.Green = 1.1
  
  --Player Reinforcements
  Trigger.OnEnteredProximityTrigger(Prox1.CenterPosition, WDist.New(7 * 1024), function(a, id)
    if IsOwnedByCoopPlayer(a) and a.Type ~= 'camera' and a.Type ~= 'camera.small' then
      Trigger.RemoveProximityTrigger(id)
      Media.PlaySpeechNotification(All, "Reinforce")
      if Difficulty == 'hard' then
        Reinforcements.Reinforce(GoodGuy, {'mutsldr', 'mutsldr', 'mutsldr', 'mutsldr', 'mutsldr'}, { ForgottenSpawn1.Location }, 5, function(unit)
          unit.Move(Prox1.Location)
        end)
      else
        Reinforcements.Reinforce(GoodGuy, {'mutsldr', 'mutsldr', 'mutsldr', 'mutsldr', 'mutsldr', 'mutsldr', 'mutsldr', 'mutsldr', 'mutsldr', 'mutsldr'}, { ForgottenSpawn1.Location }, 5, function(unit)
          unit.Move(Prox1.Location)
        end)
      end
    end
  end)
  
  Trigger.OnAllKilled({ RPG1, RPG2 }, function()
    Media.PlaySpeechNotification(All, "Reinforce")
    ReinforceWithLandingCraftSouth(GoodGuy, {'e6'}, LSTSpawn1.Location, LSTMoveTo1.Location, false)
  end)
  
  Trigger.OnCapture(Ctrl1, function(self, captor, oldOwner, newOwner)
    if IsOwnedByCoopPlayer(captor) then
      Media.DisplayMessage("Sir, I've restored the APCs to operational status.", "Engineer", HSLColor.FromHex("857833"))
      Utils.Do({ APC1, APC2, APC3 }, function(unit) unit.Owner = GoodGuy end)
    end
  end)
  
  --Objectives
  InitObjectives(GDI)

  Trigger.AfterDelay(DateTime.Seconds(2), function()
    DestroyPowerObjective = GDI.AddObjective("Destroy all 9 TOA power plants.")
    FreeMutantsObjective = GDI.AddObjective("Free the mutant prisoners.")
    CaptureControlStationObjective = GDI.AddObjective("Capture control station in the prison.")
    HijackPrisonTrucksObjective = GDI.AddObjective("Hijack the prison trucks.")
  end)
  
  UserInterface.SetMissionText(PowerPlantsDestroyed .. " of 9 power plants destroyed.", HSLColor.Yellow)
  
  Utils.Do({ Nuke1, Nuke2, Nuke3, Nuke4, Nuke5, Nuke6, Nuke7, Nuke8, Nuke9 }, function(nuke)
    Trigger.OnKilled(nuke, function(self, killer)
      PowerPlantsDestroyed = PowerPlantsDestroyed + 1
      UserInterface.SetMissionText(PowerPlantsDestroyed .. " of 9 power plants destroyed.", HSLColor.Yellow)
      if PowerPlantsDestroyed == 9 then GDI.MarkCompletedObjective(DestroyPowerObjective) end
    end)
  end)
  
  Trigger.AfterDelay(DateTime.Seconds(5), function()
    Media.DisplayMessage("My people are hiding to the northeast.", "Ghost Stalker", HSLColor.FromHex("00FF00"))
  end)
  
  Trigger.OnKilled(Ctrl2, function(self, killer)
    if Ctrl2Captured == false then GDI.MarkFailedObjective(CaptureControlStationObjective) end
  end)
  
  Utils.Do({ Truck2, Truck3, Truck4, Truck5, Truck6 }, function(unit)
    Trigger.OnKilled(unit, function(self, killer)
      if Ctrl2Captured == false then
        GDI.MarkFailedObjective(HijackPrisonTrucksObjective)
      elseif Stage2Begin == true then
        HijackedTruckDestroy(self)
      end
    end)
  end)
  
  Trigger.OnKilled(GhostStalker, function(self, killer)
    Media.DisplayMessage("My wounds are too severe to continue. I must withdraw. I have failed.", "Ghost Stalker", HSLColor.FromHex("00FF00"))
  end)
  
  Trigger.OnKilled(Havoc, function(self, killer)
    Media.DisplayMessage("I need medevac! Damn TOA, revenge is coming and she's riding a fast horse!", "Havoc", HSLColor.FromHex("857833"))
  end)
  
  local prisoners = Forgotten.GetActorsByType('mutsldr')
  Utils.Do(prisoners, function(unit)
    Trigger.OnKilled(unit, function(self, killer)
      if ForgottenFreed == false and IsOwnedByCoopPlayer(killer) then
        Media.DisplayMessage("So you are enemies of our people after all!\nVile traitors!", "Forgotten", HSLColor.FromHex("00FF00"))
        PlayerFailMission()
      end
    end)
  end)
  
  Trigger.OnKilled(Gate1, FreePrisoners)
  Trigger.OnKilled(Gate2, FreePrisoners)
  
  Trigger.OnCapture(Ctrl2, function(self, captor, oldOwner, newOwner)
    if IsOwnedByCoopPlayer(captor) then
      Ctrl2Captured = true
      GDI.MarkCompletedObjective(CaptureControlStationObjective)
    end
  end)
  
  --AI player behavior
  Utils.Do( {Outpost1A, Outpost1B, Outpost1C, Outpost1D, Outpost1E, Outpost1F, Outpost1G, Outpost1H, Outpost1I}, function(unit)
    Trigger.OnKilled(unit, function(self, killer)
      if IsOwnedByCoopPlayer(killer) then AlertOutpost1() end
    end)
  end)
  
  Utils.Do( {Outpost2A, Outpost2B, Outpost2C, Outpost2D, Outpost2E, Outpost2F, Outpost2G}, function(unit)
    Trigger.OnKilled(unit, function(self, killer)
      if IsOwnedByCoopPlayer(killer) then AlertOutpost2() end
    end)
  end)
  
  Utils.Do( {Outpost3A, Outpost3B, Outpost3C, Outpost3D, Outpost3E, Outpost3F, Outpost3G}, function(unit)
    Trigger.OnKilled(unit, function(self, killer)
      if IsOwnedByCoopPlayer(killer) then AlertOutpost3() end
    end)
  end)

  --Enemy Predeployed Maneuvers
  if Difficulty ~= 'easy' then
    Utils.Do({ Patroller1A, Patroller1B }, function(unit)
      unit.Patrol({ Patrol1A.Location, Patrol1B.Location, Patrol1C.Location }, true, DateTime.Seconds(8))
    end)
    
    Utils.Do({ Patroller2A, Patroller2B, Patroller2C, Patroller2D, Patroller2E }, function(unit)
      unit.Patrol({ Patrol1B.Location, Patrol1A.Location, Patrol1C.Location }, true, DateTime.Seconds(8))
    end)
    
    Utils.Do({ Patroller3A, Patroller3B }, function(unit)
      unit.Patrol({ Patrol3A.Location, Patrol3B.Location, Patrol3C.Location, Patrol3D.Location }, true, DateTime.Seconds(8))
    end)
    
    Utils.Do({ Patroller4A, Patroller4B }, function(unit)
      unit.Patrol({ Patrol4A.Location, Patrol4B.Location, Patrol4C.Location, Patrol4D.Location }, true, DateTime.Seconds(8))
    end)
  end
  
  --Proximity Triggers/Reveals
  CoopSetUpProximityReveal(GDI, {Prox2}, {Prox2}, 16, 15, false)
  CoopSetUpProximityReveal(GDI, {Prox3}, {Prox3}, 25, 15, false)
  CoopSetUpProximityReveal(GDI, {Prox4A, Prox4B}, {Prox4A}, 25, 15, false)
  CoopSetUpProximityReveal(GDI, {Prox5}, {Prox5}, 20, 15, false)
  CoopSetUpProximityReveal(GDI, {Prox6}, {Prox6}, 25, 15, false)
  CoopSetUpProximityReveal(GDI, {Prox7, Prox8}, {Cam7}, 5, 15, false)
  CoopSetUpProximityReveal(GDI, {Prox10}, {TruckMoveTo1}, 2, 15, false)
  
  Trigger.OnEnteredProximityTrigger(Prox3.CenterPosition, WDist.New(12 * 1024), function(a, id)
    if IsOwnedByCoopPlayer(a) and a.Type ~= 'camera' and a.Type ~= 'camera.small' then
      Trigger.RemoveProximityTrigger(id)
      AlertOutpost1()
    end
  end)
  
  Utils.Do( {Prox4A, Prox4B }, function(waypoint)
    Trigger.OnEnteredProximityTrigger(waypoint.CenterPosition, WDist.New(12 * 1024), function(a, id)
      if IsOwnedByCoopPlayer(a) and a.Type ~= 'camera' and a.Type ~= 'camera.small' then
        Trigger.RemoveProximityTrigger(id)
        AlertOutpost2()
      end
    end)
  end)
  
  Trigger.OnEnteredProximityTrigger(Prox6.CenterPosition, WDist.New(12 * 1024), function(a, id)
    if IsOwnedByCoopPlayer(a) and a.Type ~= 'camera' and a.Type ~= 'camera.small' then
      Trigger.RemoveProximityTrigger(id)
      AlertOutpost3()
    end
  end)
  
  Trigger.OnEnteredProximityTrigger(Prox9.CenterPosition, WDist.New(3 * 1024), function(a, id)
    if IsOwnedByCoopPlayer(a) and a.Type ~= 'camera' and a.Type ~= 'camera.small' then
      Trigger.RemoveProximityTrigger(id)
      FreePrisoners()
    end
  end)
  
  Trigger.OnEnteredProximityTrigger(TruckMoveTo1.CenterPosition, WDist.New(2 * 1024), function(a, id)
    if a.Owner == FakeGDI and a.Type == 'truck' then
      Trigger.RemoveProximityTrigger(id)
      Media.PlaySound('Klaxon.aud')
      Media.DisplayMessage("The prisoners have escaped!\nChange the recognition codes for the troop transports!", "TOA", HSLColor.FromHex("F62E05"))
    end
  end)
  
  Trigger.OnEnteredProximityTrigger(TruckMoveTo4.CenterPosition, WDist.New(2 * 1024), function(a, id)
    if a.Owner == FakeGDI and a.Type == 'truck' then a.Kill() end
  end)
  
  --Timer
  
  --Crate spawns
  if Difficulty ~= 'hard' then
    Trigger.OnKilled(Truck1, function(self, killer)
      Actor.Create("healcrate", true, { Owner = GDI, Location = Truck1.Location })
    end)
  end
  
  --Taunts
  
  --Testing
end


Tick = function()
	AssignToCoopPlayers(GoodGuy.GetActorsByTypes({"e6", "amphapc"}), nil, true)
	OncePerSecondChecks()
	OncePerThreeSecondChecks()
end

OncePerSecondChecks = function()
  if DateTime.GameTime > 1 and DateTime.GameTime % 25 == 0 then
    
    if Ctrl2Captured == true and ForgottenFreed == true and HijackingTrucks == false and
       Nuke1.IsDead and Nuke2.IsDead and Nuke3.IsDead
    then
      HijackingTrucks = true
      PlayerCanLose = false
      GDI.MarkCompletedObjective(HijackPrisonTrucksObjective)
      
      --record how many units of each type the player has so we can respawn them later
      local ghostStalker = Map.ActorsInBox(IslandNW.CenterPosition, IslandSE.CenterPosition, function(a)
        return IsOwnedByCoopPlayer(a) and not a.IsDead and a.Type == 'ghstlkr'
      end)
      if #ghostStalker > 0 then PlayerHasGhostStalker = true end
      
      local havoc = Map.ActorsInBox(IslandNW.CenterPosition, IslandSE.CenterPosition, function(a)
        return IsOwnedByCoopPlayer(a) and not a.IsDead and a.Type == 'rmbo'
      end)
      if #havoc > 0 then PlayerHasHavoc = true end
      
      local medic = Map.ActorsInBox(IslandNW.CenterPosition, IslandSE.CenterPosition, function(a)
        return IsOwnedByCoopPlayer(a) and not a.IsDead and a.Type == 'medi'
      end)
      if #medic > 0 then PlayerHasMedic = true end
      
      local mutants = Map.ActorsInBox(IslandNW.CenterPosition, IslandSE.CenterPosition, function(a)
        return IsOwnedByCoopPlayer(a) and not a.IsDead and a.Type == 'mutsldr'
      end)
      HijackingMutants = #mutants
      
      local units = Map.ActorsInBox(IslandNW.CenterPosition, IslandSE.CenterPosition, function(a)
        return IsOwnedByCoopPlayer(a) and not a.IsDead and
          (a.Type == 'ghstlkr' or a.Type == 'rmbo' or a.Type == 'medi' or a.Type == 'mutsldr')
      end)
      
      --hijack the trucks
      Utils.Do( {Truck2, Truck3, Truck4, Truck5, Truck6}, function(unit)
        if not unit.IsDead then unit.Owner = FakeGDI end
      end)
      
      if not Truck2.IsDead then Truck2.Move(Truck2MoveTo.Location) end
      if not Truck3.IsDead then Truck3.Move(Truck3MoveTo.Location) end
      if not Truck4.IsDead then Truck4.Move(Truck4MoveTo.Location) end
      if not Truck5.IsDead then Truck5.Move(Truck5MoveTo.Location) end
      if not Truck6.IsDead then Truck6.Move(Truck6MoveTo.Location) end
      
      Utils.Do(units, function(unit)
        unit.Owner = FakeGDI
        unit.Move(EscapeeMoveTo.Location)
        unit.Destroy()
      end)
    end
    
    if HijackingTrucks == true and Stage2Begin == false then
      Trigger.AfterDelay(DateTime.Seconds(1), function()
        local units = Map.ActorsInBox(IslandNW.CenterPosition, IslandSE.CenterPosition, function(a)
          --return (a.Type == 'ghstlkr' or a.Type == 'rmbo' or a.Type == 'medi' or a.Type == 'mutsldr')
          return a.Owner == FakeGDI and (a.Type == 'ghstlkr' or a.Type == 'rmbo' or a.Type == 'medi' or a.Type == 'mutsldr')
        end)
        
        if #units == 0 then
          Stage2Begin = true
          local trucks = FakeGDI.GetActorsByType('truck')
          Utils.Do(trucks, function(truck)
            truck.Move(TruckMoveTo1.Location)
            truck.Move(TruckMoveTo2.Location)
            truck.Move(TruckMoveTo3.Location)
            truck.Move(TruckMoveTo4.Location)
          end)
        end
      end)
    end
    
  end
end

OncePerThreeSecondChecks = function()
	if DateTime.GameTime > 1 and DateTime.GameTime % 75 == 0 then
  
    --[[if PlayerCanLose == true and HasOneOf(GDI, LossCheckAll) == false then
      PlayerFailMission()
    end]]
	
	if PlayerCanLose == true then
      TibAltCoopLossCheck()
    end
    
    --manipulate AI funds
	end
end


PlayerFailMission = function()
  if DestroyPowerObjective ~= nil and not GDI.IsObjectiveCompleted(DestroyPowerObjective) then
    GDI.MarkFailedObjective(DestroyPowerObjective)
  end
  if FreeMutantsObjective ~= nil and not GDI.IsObjectiveCompleted(FreeMutantsObjective) then
    GDI.MarkFailedObjective(FreeMutantsObjective)
  end
  if CaptureControlStationObjective ~= nil and not GDI.IsObjectiveCompleted(CaptureControlStationObjective) then
    GDI.MarkFailedObjective(CaptureControlStationObjective)
  end
  if HijackPrisonTrucksObjective ~= nil and not GDI.IsObjectiveCompleted(HijackPrisonTrucksObjective) then
    GDI.MarkFailedObjective(HijackPrisonTrucksObjective)
  end
end