
PlayerCanLose = false
FiendsRevealed = false
FiendsAttacked = false
Pyle1Awakened = false
BaseAwakened = false

EnemyAmbushes = {'e1', 'e1', 'e3'}


ActorRemovals = {
  easy = {  },
  normal = { },
  hard = {  },
}


-- AI Attack Production Behavior --

TOAAttackDelayMin = { easy = DateTime.Seconds(75), normal = DateTime.Seconds(60), hard = DateTime.Seconds(45) }
TOAAttackDelayMax = { easy = DateTime.Seconds(90), normal = DateTime.Seconds(75), hard = DateTime.Seconds(60) }

AiAttackProduction = function(player, production, factory)
  local toBuild = function() return production end
  
  if factory ~= nil and not factory.IsDead then
    ProduceUnits(player, factory, nil, toBuild, function(units)
      UpdatePlayerBaseLocation()
      Utils.Do(units, function(unit) unit.Hunt() end)
      
      Trigger.AfterDelay(Utils.RandomInteger(TOAAttackDelayMin[Difficulty], TOAAttackDelayMax[Difficulty]), function()
        AiAttackProduction(player, production, factory)
      end)
    end)
  end
end

AwakenTOABase = function()
  if BaseAwakened == false then
    BaseAwakened = true
    local cam = Actor.Create("camera", true, { Owner = Nod, Location = Prox7.Location })
    Trigger.AfterDelay(DateTime.Seconds(15), function() cam.Destroy() end)
    AiAttackProduction(TOA, {'e1', 'e1', 'e1', 'e1', 'e1', 'e2', 'e2', 'e2', 'e2', 'e2'}, Pyle2)
    AiAttackProduction(TOA, {'jeep', 'jeep', 'mtnk'}, Weap)
  end
end

AwakenPyle1 = function()
  if Pyle1Awakened == false then
    Pyle1Awakened = true
    local cam = Actor.Create("camera", true, { Owner = Nod, Location = Cam3.Location })
    Trigger.AfterDelay(DateTime.Seconds(15), function() cam.Destroy() end)
    AiAttackProduction(TOA, {'e1', 'e1', 'e1', 'e1', 'e1', 'e2', 'e2', 'e2', 'e2', 'e2'}, Pyle1)
  end
  
  Trigger.AfterDelay(DateTime.Seconds(10), function()
    if FiendsAttacked == false then
      FiendsAttacked = true

      FiendsRevealed = true
      local cam = Actor.Create("camera", true, { Owner = Nod, Location = Cam2.Location })
      Trigger.AfterDelay(DateTime.Seconds(10), function() cam.Destroy() end)
    
      local counter = 1
      local fiends = TibLife.GetActorsByType('tfnd')
      local attackPaths = {
        [1] = { TfndAtk1A.Location, TfndAtk1B.Location, TfndAtk1C.Location },
        [2] = { TfndAtk1A.Location, TfndAtk2A.Location, TfndAtk2B.Location },
        [3] = { TfndAtk3A.Location, TfndAtk3B.Location, TfndAtk3C.Location }
      }
      Utils.Do(fiends, function(fiend)
        if not fiend.IsDead then
          Utils.Do(attackPaths[counter], function(wp) fiend.AttackMove(wp) end)
          counter = counter + 1
          if counter > 3 then counter = 1 end
        end
      end)
    end
  end)
end

-- End AI Attack Production Behavior --


EnemyReinforcementsHunt = function(spawn, moveTo)
  Reinforcements.ReinforceWithTransport(TOA, "tran.insertion", EnemyAmbushes, { spawn.Location }, null, function(transport, cargo)
    transport.Land(moveTo)
    transport.UnloadPassengers()
    transport.CallFunc(function()
      Utils.Do(cargo, function(unit)
        if not unit.IsDead then unit.Hunt() end
      end)
    end)
  end)
end


WorldLoaded = function()
  Nod = Player.GetPlayer("Nod")
  TOA = Player.GetPlayer("TOA")
  TibLife = Player.GetPlayer("TibLife")
  Neutral = Player.GetPlayer("Neutral")
  
  MissionPlayer = Nod

	BadGuy = Player.GetPlayer("BadGuy")

	coopInfo =
	{
		Mainplayer = Nod,
		MainEnemies = {TOA},
		Dummyplayer = BadGuy
	}
	
	ORAMod = "tibalt"
	CoopInit25(coopInfo)

  Camera.Position = StartCam.CenterPosition
  
  --Remove actors based on difficulty
  Utils.Do(ActorRemovals[Difficulty], function(unit)
    unit.Destroy()
  end)
  
  --Special lighting
  Lighting.Ambient = 0.7
  Lighting.Red = 0.7
  Lighting.Blue = 0.7
  Lighting.Green = 0.7
  
  --Player Reinforcements
  local initialCam = Actor.Create("camera", true, { Owner = Nod, Location = StartCam.Location })
  Trigger.AfterDelay(DateTime.Seconds(10), function() initialCam.Destroy() end)
        
  if Difficulty == 'hard' then
    Trigger.AfterDelay(DateTime.Seconds(2), function()
      Reinforcements.Reinforce(BadGuy, {'ltnk', 'bggy', 'bggy', 'spy', 'spy', 'e1', 'e1', 'e1', 'e3', 'e3', 'e3'}, { NodSpawn1.Location }, 10, function(unit)
        unit.Move(StartCam.Location)
      end)
      Media.PlaySpeechNotification(All, "Reinforce")
    end)
  else
    Trigger.AfterDelay(DateTime.Seconds(2), function()
      Reinforcements.Reinforce(BadGuy, {'ltnk', 'bggy', 'bggy', 'spy', 'spy', 'e1', 'e1', 'e1', 'e3', 'e3', 'e3', 'medi'}, { NodSpawn1.Location }, 10, function(unit)
        unit.Move(StartCam.Location)
      end)
      Media.PlaySpeechNotification(All, "Reinforce")
      Media.DisplayMessage("GDI has lent us one of their medics. Let's make good use of him.", "Nod Soldier", HSLColor.FromHex("FF0000"))
    end)
  end
  
  Trigger.OnKilled(Pyle1, function(self, killer)
    Reinforcements.Reinforce(BadGuy, {'bggy', 'e1', 'e1', 'e1', 'e1', 'e1'}, { NodSpawn1.Location }, 10, function(unit)
      unit.Move(StartCam.Location)
    end)
    Media.PlaySpeechNotification(All, "Reinforce")
  end)
  
  Trigger.OnKilled(Tnk1, function(self, killer)
    Reinforcements.Reinforce(BadGuy, {'ltnk'}, { NodSpawn1.Location }, 10, function(unit)
      unit.Move(StartCam.Location)
    end)
    Media.PlaySpeechNotification(All, "Reinforce")
  end)
  
  Trigger.OnKilled(Hq1, function(self, killer)
    Reinforcements.Reinforce(BadGuy, {'bggy', 'e1', 'e1', 'e1', 'e1', 'e1'}, { NodSpawn1.Location }, 10, function(unit)
      unit.Move(StartCam.Location)
    end)
    Media.PlaySpeechNotification(All, "Reinforce")
  end)
  
  Trigger.OnKilled(Hq2, function(self, killer)
    Reinforcements.Reinforce(BadGuy, {'ltnk', 'e1', 'e1', 'e1', 'e1', 'e1'}, { NodSpawn1.Location }, 10, function(unit)
      unit.Move(StartCam.Location)
    end)
    Media.PlaySpeechNotification(All, "Reinforce")
  end)
  
  Trigger.OnKilled(Hq3, function(self, killer)
    Reinforcements.Reinforce(BadGuy, {'ltnk', 'bggy', 'e1', 'e1', 'e1', 'e1', 'e1'}, { NodSpawn1.Location }, 10, function(unit)
      unit.Move(StartCam.Location)
    end)
    Media.PlaySpeechNotification(All, "Reinforce")
  end)
  
  --Objectives
  InitObjectives(Nod)

  Trigger.AfterDelay(DateTime.Seconds(5), function()
    DestroyHqObjective = Nod.AddObjective("Destroy all early warning stations.")
    PlayerCanLose = true
  end)
  
  Trigger.OnAllKilled({Hq1, Hq2, Hq3, Hq4, Hq5, Hq6, Hq7}, function()
    Nod.MarkCompletedObjective(DestroyHqObjective)
  end)
  
  --AI player behavior
  TOA.Cash = 90000
  TOA.Resources = TOA.ResourceCapacity - 500
  SetupRefAndSilosCaptureCredits(TOA)
  
  Trigger.OnEnteredProximityTrigger(Prox3.CenterPosition, WDist.New(10 * 1024), function(a, id)
    if IsOwnedByCoopPlayer(a) and a.Type ~= 'camera' and a.Type ~= 'camera.small' and a.Type ~= 'spy' then
      Trigger.RemoveProximityTrigger(id)
      AwakenPyle1()
    end
  end)
  
  Utils.Do({AlertB1, AlertB2, AlertB3, AlertB4}, function(unit)
    Trigger.OnKilled(unit, function(self, killer) AwakenPyle1() end)
  end)
  
  Trigger.OnEnteredProximityTrigger(Prox7.CenterPosition, WDist.New(11 * 1024), function(a, id)
    if IsOwnedByCoopPlayer(a) and a.Type ~= 'camera' and a.Type ~= 'camera.small' and a.Type ~= 'spy' then
      Trigger.RemoveProximityTrigger(id)
      AwakenTOABase()
    end
  end)
  
  Utils.Do({Alert1, Alert2, Alert3, Alert4, Alert5, Alert6, Alert7, Alert8, Alert9, Alert10, Pyle2, Weap, Fact, Proc}, function(unit)
    Trigger.OnKilled(unit, function(self, killer) AwakenTOABase() end)
  end)
  
  --Enemy Predeployed Maneuvers
  local fiends = TibLife.GetActorsByType('tfnd')
  Utils.Do(fiends, function(fiend)
    Trigger.OnKilled(fiend, function(self, killer)
      if IsOwnedByCoopPlayer(killer) and FiendsAttacked == false then
        FiendsAttacked = true
        local remainingFiends = TibLife.GetActorsByType('tfnd')
        Utils.Do(remainingFiends, function(remainingFiend) remainingFiend.Hunt() end)
      end
    end)
  end)
  
  --Proximity Triggers/Reveals
  if Difficulty ~= 'easy' then
    Trigger.OnEnteredProximityTrigger(Prox1.CenterPosition, WDist.New(5 * 1024), function(a, id)
      if IsOwnedByCoopPlayer(a) and a.Type ~= 'camera' and a.Type ~= 'camera.small' and a.Type ~= 'spy' then
        Trigger.RemoveProximityTrigger(id)
        local cam = Actor.Create("camera", true, { Owner = Nod, Location = Prox1.Location })
        Trigger.AfterDelay(DateTime.Seconds(10), function() cam.Destroy() end)
        EnemyReinforcementsHunt(TOASpawn1, TOAMoveTo1)
        EnemyReinforcementsHunt(TOASpawn2, TOAMoveTo2)
        EnemyReinforcementsHunt(TOASpawn3, TOAMoveTo3)
        Media.PlaySound('Eva-EnemyReinforcements.aud')
      end
    end)
    
    Trigger.OnEnteredProximityTrigger(Prox5.CenterPosition, WDist.New(6 * 1024), function(a, id)
      if IsOwnedByCoopPlayer(a) and a.Type ~= 'camera' and a.Type ~= 'camera.small' and a.Type ~= 'spy' then
        Trigger.RemoveProximityTrigger(id)
        local cam = Actor.Create("camera", true, { Owner = Nod, Location = Prox5.Location })
        Trigger.AfterDelay(DateTime.Seconds(10), function() cam.Destroy() end)
        EnemyReinforcementsHunt(TOASpawn7, TOAMoveTo7)
        EnemyReinforcementsHunt(TOASpawn8, TOAMoveTo8)
        EnemyReinforcementsHunt(TOASpawn9, TOAMoveTo9)
        Media.PlaySound('Eva-EnemyReinforcements.aud')
      end
    end)
    
    Trigger.OnEnteredProximityTrigger(Prox6.CenterPosition, WDist.New(5 * 1024), function(a, id)
      if IsOwnedByCoopPlayer(a) and a.Type ~= 'camera' and a.Type ~= 'camera.small' and a.Type ~= 'spy' then
        Trigger.RemoveProximityTrigger(id)
        local cam = Actor.Create("camera", true, { Owner = Nod, Location = Prox6.Location })
        Trigger.AfterDelay(DateTime.Seconds(10), function() cam.Destroy() end)
        EnemyReinforcementsHunt(TOASpawn10, TOAMoveTo10)
        EnemyReinforcementsHunt(TOASpawn11, TOAMoveTo11)
        Media.PlaySound('Eva-EnemyReinforcements.aud')
      end
    end)
  end
  
  Trigger.OnEnteredProximityTrigger(Prox4.CenterPosition, WDist.New(5 * 1024), function(a, id)
    if IsOwnedByCoopPlayer(a) and a.Type ~= 'camera' and a.Type ~= 'camera.small' then
      Trigger.RemoveProximityTrigger(id)
      local cam = Actor.Create("camera", true, { Owner = Nod, Location = Prox4.Location })
      Trigger.AfterDelay(DateTime.Seconds(10), function() cam.Destroy() end)
      EnemyReinforcementsHunt(TOASpawn4, TOAMoveTo4)
      EnemyReinforcementsHunt(TOASpawn5, TOAMoveTo5)
      EnemyReinforcementsHunt(TOASpawn6, TOAMoveTo6)
      Media.PlaySound('Eva-EnemyReinforcements.aud')
    end
  end)
  
  Utils.Do({Prox2A, Prox2B}, function(wp)
    Trigger.OnEnteredProximityTrigger(wp.CenterPosition, WDist.New(3 * 1024), function(a, id)
      if IsOwnedByCoopPlayer(a) and a.Type ~= 'camera' and a.Type ~= 'camera.small' then
        Trigger.RemoveProximityTrigger(id)
        if FiendsRevealed == false and FiendsAttacked == false then
          FiendsRevealed = true
          Media.DisplayMessage("Those critters don't look too friendly.", "Nod Soldier", HSLColor.FromHex("FF0000"))
          local cam = Actor.Create("camera", true, { Owner = Nod, Location = Cam2.Location })
          Trigger.AfterDelay(DateTime.Seconds(10), function() cam.Destroy() end)
        end
      end
    end)
  end)
  
  --Timer
  
  --Crate spawns
  Trigger.OnKilled(Truck1, function(self, killer)
    Actor.Create("healcrate", true, { Owner = Nod, Location = Truck1.Location })
  end)
  
  Trigger.OnKilled(Truck2, function(self, killer)
    Actor.Create("healcrate", true, { Owner = Nod, Location = Truck2.Location })
  end)
  
  --Taunts
  
  --Testing
end


Tick = function()
	OncePerSecondChecks()
	OncePerThreeSecondChecks()
end

OncePerSecondChecks = function()
  if DateTime.GameTime > 1 and DateTime.GameTime % 25 == 0 then
    --
  end
end

OncePerThreeSecondChecks = function()
	if DateTime.GameTime > 1 and DateTime.GameTime % 75 == 0 then
  
    --[[if PlayerCanLose == true and HasOneOf(Nod, LossCheckAll) == false then
      PlayerFailMission()
    end]]
	
	if PlayerCanLose == true then
      TibAltCoopLossCheck()
    end

    --manipulate AI funds
    ManipulatePlayerFunds(TOA)
    
    --ControlAircraft(Cabal)
	end
end


PlayerFailMission = function()
  if DestroyHqObjective ~= nil and not Nod.IsObjectiveCompleted(DestroyHqObjective) then
    Nod.MarkFailedObjective(DestroyHqObjective)
  end
end