
NodHasFact = true
PlayerCanFail = false
NodHasProc = false
TOA2Dead = false
NodDead = false
MorelliSpawned = false

ActorRemovals = {
  easy = { },
  normal = { },
  hard = { },
}


AirstrikeDelayTimes = {
  easy = DateTime.Seconds(480),
  normal = DateTime.Seconds(360),
  hard = DateTime.Seconds(300),
}


AirstrikeAttacks = function()
  local comms = TOA.GetActorsByType('hq')
  if #comms == 0 then return end
  
  --[[
  local launchedIt = LaunchAIAirstrike(TOA, { GDI }, { 'a10scrip', 'a10scrip', 'a10scrip' }, { AirstrikeSpawn1, AirstrikeSpawn2, AirstrikeSpawn3, AirstrikeSpawn4 })
   Utils.Do(CoopPlayers,function(PID)
	if PID ~= GDI then
		LaunchAIAirstrike(TOA, { PID }, { 'a10scrip', 'a10scrip', 'a10scrip' }, { AirstrikeSpawn1, AirstrikeSpawn2, AirstrikeSpawn3, AirstrikeSpawn4 })
	end
  end)
  if launchedIt == true then
    Media.DisplayMessage("Warning: TOA airstrike incoming.", "EVA", HSLColor.FromHex("00FF00"))
  end
  ]]
  
  local StrikeCounter = 0
  local launchedIt = LaunchAIAirstrike(TOA, { GDI }, { 'a10scrip', 'a10scrip', 'a10scrip' }, { AirstrikeSpawn1, AirstrikeSpawn2, AirstrikeSpawn3, AirstrikeSpawn4 })
  Utils.Do(CoopPlayers,function(PID)
	if PID ~= Nod then
		local ExtraLaunch = LaunchAIAirstrike(TOA, { PID }, { 'a10scrip', 'a10scrip', 'a10scrip' }, { AirstrikeSpawn1, AirstrikeSpawn2, AirstrikeSpawn3, AirstrikeSpawn4 })
		if ExtraLaunch == true then
			StrikeCounter = StrikeCounter + 1
		end
	end
  end)
  if launchedIt == true then
	StrikeCounter = StrikeCounter + 1
  end
  if StrikeCounter > 0 then
	Media.DisplayMessage("Warning: TOA airstrike incoming.", "EVA", HSLColor.FromHex("00FF00"))
  end
  
  Trigger.AfterDelay(AirstrikeDelayTimes[Difficulty], AirstrikeAttacks)
end


TOA4ProduceInfantry = function()
  local infantryProduction = {
    easy = { 'e1', 'e1', 'e1', 'e1', 'e1', 'e3', 'e3', 'e3', 'e3', 'e3' },
    normal = { 'e1', 'e1', 'e1', 'e1', 'e1', 'e3', 'e3', 'e3', 'e3', 'e3' },
    hard = { 'e2', 'e2', 'e2', 'e2', 'e2', 'e3', 'e3', 'e3', 'e3', 'e3' }
  }

  if not Pyle1.IsDead and Pyle1.Owner == TOA4 then
    local production = infantryProduction[Difficulty]
    local toBuild = function() return production end
    
    ProduceUnits(TOA4, Pyle1, nil, toBuild, function(units)
      Utils.Do(units, function(unit) unit.Hunt() end)
      Trigger.AfterDelay(DateTime.Seconds(30), function()
        TOA4ProduceInfantry()
      end)
    end)
  end
end


-- TOA Attack Production Behavior -----

TOAAttackDelayMin = { easy = DateTime.Seconds(45), normal = DateTime.Seconds(30), hard = DateTime.Seconds(25) }
TOAAttackDelayMax = { easy = DateTime.Seconds(60), normal = DateTime.Seconds(45), hard = DateTime.Seconds(30) }

TOAAirAttackDelayMin = { easy = DateTime.Seconds(270), normal = DateTime.Seconds(210), hard = DateTime.Seconds(180) }
TOAAirAttackDelayMax = { easy = DateTime.Seconds(300), normal = DateTime.Seconds(240), hard = DateTime.Seconds(210) }


TOAAttackVehicleTypes = {
  easy = {
     { "jeep", "jeep", "mtnk", "mtnk" },
     { "jeep", "jeep", "mtnk", "mtnk", "msam" },
     { "mtnk", "mtnk", "mtnk", "mtnk" },
     { "mtnk", "mtnk", "mtnk", "msam", "msam" },
     { "htnk", "htnk", "htnk" },
     { "htnk", "htnk", "msam", "msam" },
     { "exosuit", "exosuit", "mtnk", "mtnk" },
     { "exosuit", "exosuit", "exosuit" },
  },
  normal = {
     { "jeep", "jeep", "jeep", "mtnk", "mtnk", "mtnk" },
     { "jeep", "jeep", "mtnk", "mtnk", "msam", "msam" },
     { "mtnk", "mtnk", "mtnk", "mtnk", "mtnk", "mtnk" },
     { "mtnk", "mtnk", "mtnk", "mtnk", "msam", "msam" },
     { "htnk", "htnk", "htnk", "htnk" },
     { "htnk", "htnk", "htnk", "msam", "msam" },
     { "exosuit", "exosuit", "exosuit", "mtnk", "mtnk", "mtnk" },
     { "exosuit", "exosuit", "exosuit", "exosuit" },
  },
  hard = {
     { "jeep", "jeep", "jeep", "mtnk", "mtnk", "mtnk", "mtnk" },
     { "jeep", "jeep", "mtnk", "mtnk", "msam", "msam", "msam" },
     { "mtnk", "mtnk", "mtnk", "mtnk", "mtnk", "mtnk", "mtnk" },
     { "mtnk", "mtnk", "mtnk", "mtnk", "msam", "msam", "msam" },
     { "htnk", "htnk", "htnk", "htnk", "htnk" },
     { "htnk", "htnk", "htnk", "msam", "msam", "msam" },
     { "exosuit", "exosuit", "exosuit", "mtnk", "mtnk", "mtnk" },
     { "exosuit", "exosuit", "exosuit", "exosuit", "exosuit" },
  }
}

TOA23AttackVehicleTypes = {
  easy = {
     { "jeep", "jeep", "mtnk", "mtnk" },
     { "jeep", "jeep", "mtnk", "mtnk", "msam" },
     { "mtnk", "mtnk", "mtnk", "mtnk" },
     { "mtnk", "mtnk", "mtnk", "msam", "msam" },
  },
  normal = {
     { "jeep", "jeep", "jeep", "mtnk", "mtnk", "mtnk" },
     { "jeep", "jeep", "mtnk", "mtnk", "msam", "msam" },
     { "mtnk", "mtnk", "mtnk", "mtnk", "mtnk", "mtnk" },
     { "mtnk", "mtnk", "mtnk", "mtnk", "msam", "msam" },
  },
  hard = {
     { "jeep", "jeep", "jeep", "mtnk", "mtnk", "mtnk", "mtnk" },
     { "jeep", "jeep", "mtnk", "mtnk", "msam", "msam", "msam" },
     { "mtnk", "mtnk", "mtnk", "mtnk", "mtnk", "mtnk", "mtnk" },
     { "mtnk", "mtnk", "mtnk", "mtnk", "msam", "msam", "msam" },
  }
}

TOAAttackInfantryTypes ={
  easy = {
     { "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1" },
     { "e2", "e2", "e2", "e2", "e2", "e2", "e2", "e2" },
     { "e3", "e3", "e3", "e3", "e3", "e3", "e3", "e3" },
     { "e1", "e1", "e1", "e1", "e3", "e3", "e3", "e3" },
  },
  normal = {
     { "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1" },
     { "e2", "e2", "e2", "e2", "e2", "e2", "e2", "e2", "e2", "e2" },
     { "e3", "e3", "e3", "e3", "e3", "e3", "e3", "e3", "e3", "e3" },
     { "e1", "e1", "e1", "e1", "e1", "e3", "e3", "e3", "e3", "e3" },
  },
  hard = {
     { "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1" },
     { "e2", "e2", "e2", "e2", "e2", "e2", "e2", "e2", "e2", "e2", "e2", "e2", "e2", "e2", "e2" },
     { "e3", "e3", "e3", "e3", "e3", "e3", "e3", "e3", "e3", "e3", "e3", "e3", "e3", "e3", "e3" },
     { "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e3", "e3", "e3", "e3", "e3", "e3", "e3" },
  }
}

TOAAttackAirTypes = {
  easy = {
     { "orca", },
  },
  normal = {
     { "orcad" },
  },
  hard = {
     { "orcad" },
  }
}

TOA23AttackAirTypes = {
  easy = {
     { "orca", },
  },
  normal = {
     { "orca" },
  },
  hard = {
     { "orca" },
  }
}


AiAttackProduction = function(player, paths, productionOptions, factoryType)
  local production = Utils.Random(productionOptions[Difficulty])
  local path = Utils.Random(paths)
  local toBuild = function() return production end
  local factory = GetAvailableFactory(player, factoryType)
  
  if factory ~= nil then
    ProduceUnits(player, factory, nil, toBuild, function(units)
      UpdatePlayerBaseLocation()
      Utils.Do(units, function(unit)
        ErrorGuardAttackPatrol(unit, path)
        AssaultPlayerBaseOrHunt(unit)
      end)
      
      Trigger.AfterDelay(Utils.RandomInteger(TOAAttackDelayMin[Difficulty], TOAAttackDelayMax[Difficulty]), function()
        AiAttackProduction(player, paths, productionOptions, factoryType)
      end)
    end)
  else
    Trigger.AfterDelay(Utils.RandomInteger(TOAAttackDelayMin[Difficulty], TOAAttackDelayMax[Difficulty]), function()
      AiAttackProduction(player, paths, productionOptions, factoryType)
    end)
  end
end


AiAirAttackProduction = function(player, productionOptions)
  local production = Utils.Random(productionOptions[Difficulty])
  local factories = player.GetActorsByType('hpad')
  local airMax = 4
  if Difficulty == 'hard' then airMax = 6 end
  
  if #factories > 0 then
    Utils.Do(factories, function(factory)
      local aircraft = player.GetActorsByTypes({'orca', 'orcad'})
      if #aircraft < airMax then
        Reinforcements.Reinforce(player, production, { factory.Location }, 30, function(unit)
          --
        end)
      end
    end)
  end
  Trigger.AfterDelay(Utils.RandomInteger(TOAAirAttackDelayMin[Difficulty], TOAAirAttackDelayMax[Difficulty]), function()
    AiAirAttackProduction(player, productionOptions)
  end)
end


TOA2AttackProduction = function(productionOptions, factoryType)
  local production = Utils.Random(productionOptions[Difficulty])
  local path = { TOA2Atk1D.Location, TOA2Atk1B.Location, TOA2Atk1C.Location }
  if NodDead == true then path = { TOA2Atk1A.Location, TOA3Atk.Location } end
  local toBuild = function() return production end
  local factory = GetAvailableFactory(TOA2, factoryType)
  
  if factory ~= nil then
    ProduceUnits(TOA2, factory, nil, toBuild, function(units)
      UpdatePlayerBaseLocation()
      Utils.Do(units, function(unit)
        ErrorGuardAttackPatrol(unit, path)
        AssaultPlayerBaseOrHunt(unit)
      end)
      
      Trigger.AfterDelay(Utils.RandomInteger(TOAAttackDelayMin[Difficulty], TOAAttackDelayMax[Difficulty]), function()
        TOA2AttackProduction(productionOptions, factoryType)
      end)
    end)
  else
    Trigger.AfterDelay(Utils.RandomInteger(TOAAttackDelayMin[Difficulty], TOAAttackDelayMax[Difficulty]), function()
      TOA2AttackProduction(productionOptions, factoryType)
    end)
  end
end

-- End TOA Attack Production Behavior -----


-- Nod Attack Production Behavior -----

NodAttackDelayMin = { easy = DateTime.Seconds(20), normal = DateTime.Seconds(20), hard = DateTime.Seconds(20) }
NodAttackDelayMax = { easy = DateTime.Seconds(30), normal = DateTime.Seconds(30), hard = DateTime.Seconds(30) }

NodTOA2AttackPaths = {
  { TOA2Atk1B.Location, NodAtk1B.Location, NodAtk1C.Location },
}

NodTOAAttackPaths = {
  { TOA2Atk1B.Location, NodAtk2A.Location, NodAtk2B.Location, NodAtk2C.Location },
}

NodAttackInfantryTypes = {
  easy = {
    { "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1" },
    { "e3", "e3", "e3", "e3", "e3", "e3", "e3", "e3", "e3", "e3" },
    { "e1", "e1", "e1", "e1", "e1", "e3", "e3", "e3", "e3", "e3" },
    { "cyborg", "cyborg", "cyborg", "cyborg", "cyborg", "cyborg", "cyborg", "cyborg" },
    { "cyborg", "cyborg", "cyborg", "cyborg", "cyborg", "e3", "e3", "e3", "e3", "e3" },
  },
  normal = {
    { "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1" },
    { "e3", "e3", "e3", "e3", "e3", "e3", "e3", "e3", "e3", "e3" },
    { "e1", "e1", "e1", "e1", "e1", "e3", "e3", "e3", "e3", "e3" },
    { "cyborg", "cyborg", "cyborg", "cyborg", "cyborg", "cyborg", "cyborg", "cyborg" },
    { "cyborg", "cyborg", "cyborg", "cyborg", "cyborg", "e3", "e3", "e3", "e3", "e3" },
  },
  hard = {
    { "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1" },
    { "e3", "e3", "e3", "e3", "e3", "e3", "e3", "e3", "e3", "e3" },
    { "e1", "e1", "e1", "e1", "e1", "e3", "e3", "e3", "e3", "e3" },
    { "cyborg", "cyborg", "cyborg", "cyborg", "cyborg", "cyborg", "cyborg", "cyborg" },
    { "cyborg", "cyborg", "cyborg", "cyborg", "cyborg", "e3", "e3", "e3", "e3", "e3" },
  }
}

NodAttackVehicleTypes = {
  easy = {
    { "bggy", "bggy", "bggy", "bike", "bike", "bike", "arty", "arty" },
    { "ltnk", "ltnk", "ftnk", "ftnk", "arty", "arty", "arty" },
    { "ltnk", "ltnk", "ltnk", "ltnk", "arty", "arty", "arty" },
    { "ftnk", "ftnk", "ftnk", "ftnk", "arty", "arty", "arty" },
  },
  normal = {
    { "bggy", "bggy", "bggy", "bike", "bike", "bike", "arty", "arty" },
    { "ltnk", "ltnk", "ftnk", "ftnk", "arty", "arty", "arty" },
    { "ltnk", "ltnk", "ltnk", "ltnk", "arty", "arty", "arty" },
    { "ftnk", "ftnk", "ftnk", "ftnk", "arty", "arty", "arty" },
  },
  hard = {
    { "bggy", "bggy", "bggy", "bike", "bike", "bike", "arty", "arty" },
    { "ltnk", "ltnk", "ftnk", "ftnk", "arty", "arty", "arty" },
    { "ltnk", "ltnk", "ltnk", "ltnk", "arty", "arty", "arty" },
    { "ftnk", "ftnk", "ftnk", "ftnk", "arty", "arty", "arty" },
  }
}


NodInfantryProduction = function()
  local production = Utils.Random(NodAttackInfantryTypes[Difficulty])
  local path = Utils.Random(NodTOA2AttackPaths)
  if TOA2Dead == true then path = Utils.Random(NodTOAAttackPaths) end
  local toBuild = function() return production end
  local factory = GetAvailableFactory(Nod, 'hand')
  
  if factory ~= nil then
    ProduceUnits(Nod, factory, nil, toBuild, function(units)
      Utils.Do(units, function(unit)
        ErrorGuardAttackPatrol(unit, path)
        unit.Hunt()
      end)
      Trigger.AfterDelay(Utils.RandomInteger(NodAttackDelayMin[Difficulty], NodAttackDelayMax[Difficulty]), NodInfantryProduction)
    end)
  else
    Trigger.AfterDelay(Utils.RandomInteger(NodAttackDelayMin[Difficulty], NodAttackDelayMax[Difficulty]), NodInfantryProduction)
  end
end


NodVehicleProduction = function()
  local production = Utils.Random(NodAttackVehicleTypes[Difficulty])
  local path = Utils.Random(NodTOA2AttackPaths)
  if TOA2Dead == true then path = Utils.Random(NodTOAAttackPaths) end
  local toBuild = function() return production end
  local factory = GetAvailableFactory(Nod, 'afld')
  
  if factory ~= nil then
    ProduceUnits(Nod, factory, nil, toBuild, function(units)
      Utils.Do(units, function(unit)
        ErrorGuardAttackPatrol(unit, path)
        if unit.Type ~= 'harv' then unit.Hunt() end
      end)
      Trigger.AfterDelay(Utils.RandomInteger(NodAttackDelayMin[Difficulty], NodAttackDelayMax[Difficulty]), NodVehicleProduction)
    end)
  else
    Trigger.AfterDelay(Utils.RandomInteger(NodAttackDelayMin[Difficulty], NodAttackDelayMax[Difficulty]), NodVehicleProduction)
  end
end

-- Nod Attack Production Behavior -----


-- Nod (Elena) Base-Building Behavior -----

BuildBaseOrders = {
  ["hand"]   = { structure = "hand", loc = BuildHand.Location,  tim = 12 },
  ["proc1"]  = { structure = "proc", loc = BuildProc1.Location, tim = 48 },
  ["afld"]   = { structure = "afld", loc = BuildAfld.Location,  tim = 84 },
  ["nuk21"]  = { structure = "nuk2", loc = BuildNuk21.Location, tim = 108 },
  ["proc2"]  = { structure = "proc", loc = BuildProc2.Location, tim = 156 },
  ["nuk22"]  = { structure = "nuk2", loc = BuildNuk22.Location, tim = 180 },
  ["nuk23"]  = { structure = "nuk2", loc = BuildNuk23.Location, tim = 204 },
  
  ["pbox1"] = { structure = "pbox", loc = BuildPbox1.Location, tim = 36 },
  ["pbox2"] = { structure = "pbox", loc = BuildPbox2.Location, tim = 60 },
  ["sam1"]  = { structure = "sam",  loc = BuildSAM1.Location,  tim = 88 },
  ["obli1"] = { structure = "obli", loc = BuildObli1.Location, tim = 138 },
  ["obli2"] = { structure = "obli", loc = BuildObli2.Location, tim = 188 },
  ["sam2"]  = { structure = "sam",  loc = BuildSAM2.Location,  tim = 216 },
  ["sam3"]  = { structure = "sam",  loc = BuildSAM3.Location,  tim = 244 },
}

BuildNodBase = function() --todo
  for id, orders in pairs(BuildBaseOrders) do
    Trigger.AfterDelay(DateTime.Seconds(orders.tim), function()
      if NodHasFact == true then
        local newBuilding = Actor.Create(orders.structure, true, { Owner = Nod, Location = orders.loc })
        AutoRebuildBuilding(newBuilding, Nod)
        if id == 'hand' then
          Trigger.AfterDelay(DateTime.Seconds(5), NodInfantryProduction)
        elseif id == 'afld' then
          Trigger.AfterDelay(DateTime.Seconds(5), NodVehicleProduction)
        elseif id == 'proc1' then
          AutoReplaceHarvesters(Nod)
          Trigger.AfterDelay(DateTime.Seconds(3), function() NodHasProc = true end)
        end
      end
    end)
  end
end

-- End Nod (Elena) Base-Building Behavior -----

GlobalCurrentCount = 1

AssignToTeamsGlobal = function(units, team)
	local playerCount = #team

	Utils.Do(units, function(unit)
		if unit.Type ~= "player" then
			if GlobalCurrentCount > playerCount then
				GlobalCurrentCount = 1
			end
			local newOwner = team[GlobalCurrentCount]
			unit.Owner = newOwner
			GlobalCurrentCount = GlobalCurrentCount + 1
		end
	end)
end

AssignToTeams = function(units, team)
	local playerCount = #team
	local CurrentCount = 1

	Utils.Do(units, function(unit)
		if unit.Type ~= "player" then
			if CurrentCount > playerCount then
				CurrentCount = 1
			end
			local newOwner = team[CurrentCount]
			unit.Owner = newOwner
			CurrentCount = CurrentCount + 1
		end
	end)
end

WorldLoaded = function()
  GDI = Player.GetPlayer("GDI")
  FakeGDI = Player.GetPlayer("FakeGDI")
  Nod = Player.GetPlayer("Nod")
  RuinedNod = Player.GetPlayer("RuinedNod")
  RuinedNod2 = Player.GetPlayer("RuinedNod2")
  TOA = Player.GetPlayer("TOA")
  TOA2 = Player.GetPlayer("TOA2")
  TOA3 = Player.GetPlayer("TOA3")
  TOA4 = Player.GetPlayer("TOA4")
  Neutral = Player.GetPlayer("Neutral")
  
  MissionPlayer = GDI

	GoodGuy = Player.GetPlayer("GoodGuy")

	coopInfo =
	{
		Mainplayer = GDI,
		MainEnemies = {TOA, TOA2, TOA3, TOA4},
		Dummyplayer = GoodGuy
	}
	
	ORAMod = "tibalt"

	Stopspread = true
	CoopInit25(coopInfo)
	
	Actor1004.Owner = GoodGuy
	TeamGDI = {GDI}
	TeamNod = {}
	if #CoopPlayers > 1 then
		Utils.Do(CoopPlayers,function(PID)
			if PID ~= GDI and PID.Faction == "gdi" then
				table.insert(TeamGDI,PID)
			end
			if PID.Faction == "nod" then
				table.insert(TeamNod,PID)
			end
		end)
		if #TeamNod > 0 then
			NodHasFact = false
			Utils.Do(Nod.GetActors(),function(UID)
				UID.Owner = TeamNod[1]
			end)
			AssignToTeams(TeamNod[1].GetGroundAttackers(),TeamNod)
			Utils.Do(TeamNod,function(PID)
				if PID ~= TeamNod[1] then
					local NewMCV = Actor.Create("mcv", true, { Owner = PID, Location = TOA2Atk1C.Location })
				end
			end)
		end
	end
	
	--Override Sharing options
	BaseShared = false
	TechShared = false

  Camera.Position = StartCam.CenterPosition
  
  --Remove actors based on difficulty
  Utils.Do(ActorRemovals[Difficulty], function(unit)
    unit.Destroy()
  end)
  
  --Special lighting
  Lighting.Ambient = 1.1
  Lighting.Red = 1.0
  Lighting.Blue = 0.6
  Lighting.Green = 1.0
  
  --Player Reinforcements
  local initialCam = Actor.Create("camera", true, { Owner = GDI, Location = StartCam.Location })
  Trigger.AfterDelay(DateTime.Seconds(60), function() initialCam.Destroy() end)

  Trigger.AfterDelay(DateTime.Seconds(4), function()
    Media.PlaySpeechNotification(All, "Reinforce")
    local orcad1 = Actor.Create("orcad", true, { Owner = FakeGDI, Location = DragonSpawn.Location })
    orcad1.Attack(DTarget1)
    local orcad2 = Actor.Create("orcad", true, { Owner = FakeGDI, Location = DragonSpawn.Location })
    orcad2.Attack(DTarget2)
    
    Trigger.AfterDelay(DateTime.Seconds(6), function()
      orcad1.Move(DragonSpawn.Location)
      orcad1.Destroy()
      orcad2.Move(DragonSpawn.Location)
      orcad2.Destroy()
    end)
  end)
  
  Trigger.AfterDelay(DateTime.Seconds(8), function()
    Media.PlaySpeechNotification(All, "Reinforce")
    Reinforcements.ReinforceWithTransport(GoodGuy, "tran.insertion", { "e1", "e1", "e1", "e1", "e1" }, { TranSpawn1.Location, TranMoveTo1.Location }, { TranSpawn1.Location })
    Reinforcements.ReinforceWithTransport(GoodGuy, "tran.insertion", { "e2", "e2", "e2", "e2", "medi" }, { TranSpawn2.Location, TranMoveTo2.Location }, { TranSpawn2.Location })
  end)
  
  Trigger.AfterDelay(DateTime.Seconds(16), function()
    Media.PlaySpeechNotification(All, "Reinforce")
    ReinforceWithLandingCraftSouth(GoodGuy, {'mtnk'}, LSTSpawn1.Location, LSTMoveTo1.Location, false)
    ReinforceWithLandingCraftSouth(GoodGuy, {'mtnk'}, LSTSpawn2.Location, LSTMoveTo2.Location, false)
  end)
  
  if Difficulty ~= 'hard' then
    Trigger.AfterDelay(DateTime.Seconds(24), function()
      Media.PlaySpeechNotification(All, "Reinforce")
      Reinforcements.ReinforceWithTransport(GoodGuy, "tran.insertion", { "e6", "e6", "e6" }, { TranSpawn1.Location, TranMoveTo1.Location }, { TranSpawn1.Location })
    end)
  end
  
  Trigger.AfterDelay(DateTime.Seconds(32), function()
    Media.PlaySpeechNotification(All, "Reinforce")
	local MCVlist = {}
	Utils.Do(TeamGDI,function(PID)
		table.insert(MCVlist,"mcv")
	end)
    ReinforceWithLandingCraftSouth(GoodGuy, MCVlist, LSTSpawn1.Location, LSTMoveTo1.Location, false)
    Trigger.AfterDelay(DateTime.Seconds(8), function() PlayerCanFail = true end)
  end)
  
  --Objectives
  InitObjectives(GDI)

  Trigger.AfterDelay(DateTime.Seconds(2), function()
    DefeatTOAObjective = GDI.AddObjective("Destroy TOA base around ruined Nod Temple.")
    ProtectTempleObjective = GDI.AddObjective("Do not destroy the ruined Nod Temple.")
  end)
  
  Trigger.OnKilled(Temple, function(self, killer)
    GDI.MarkFailedObjective(ProtectTempleObjective)
  end)
  
  --AI player behavior
  Utils.Do( {TOA, TOA2, TOA3, TOA4}, function(player)
    player.Cash = 10000
    player.Resources = player.ResourceCapacity - 500
    SetupRefAndSilosCaptureCredits(player)
    AutoReplaceHarvesters(player)
    AutoRepairAndRebuildBuildings(player, 15)
  end)
  
  SetupRefAndSilosCaptureCredits(RuinedNod2)
  
  Nod.Cash = 150000
  BuildNodBase()
  Trigger.OnKilled(NodFact, function(self, killer) NodHasFact = false end)
  
  --superpowers
  local ionCannonDelay = { easy = 16 * 60, normal = 6 * 60, hard = 3 * 60 }
  Trigger.AfterDelay(DateTime.Seconds(ionCannonDelay[Difficulty]), function()
    if not Eye.IsDead then
      local conditionToken = TOA.GrantCondition("ion-cannon-active")
      Trigger.OnKilled(Eye, function(self, killer)
        TOA.RevokeCondition(conditionToken)
      end)
    end
  end)

  Trigger.AfterDelay(DateTime.Seconds(60) + AirstrikeDelayTimes[Difficulty], AirstrikeAttacks)
  
  Trigger.AfterDelay(DateTime.Seconds(60), function()
    TOA2AttackProduction(TOA23AttackVehicleTypes, 'weap')
    TOA2AttackProduction(TOAAttackInfantryTypes, 'pyle')
  end)
  
  Trigger.AfterDelay(DateTime.Seconds(60) + TOAAttackDelayMax[Difficulty] * 2, function()
    AiAttackProduction(TOA3, {{TOA3Atk.Location}}, TOA23AttackVehicleTypes, 'weap')
    AiAttackProduction(TOA3, {{TOA3Atk.Location}}, TOAAttackInfantryTypes, 'pyle')
  end)
  
  Trigger.AfterDelay(DateTime.Seconds(60) + TOAAttackDelayMax[Difficulty] * 4, function()
    AiAttackProduction(TOA, {{TOAAtk1A.Location, TOAAtk1B.Location}}, TOAAttackVehicleTypes, 'weap')
    AiAttackProduction(TOA, {{TOAAtk1A.Location, TOAAtk1B.Location}}, TOAAttackInfantryTypes, 'pyle')
  end)
  
  Trigger.AfterDelay(DateTime.Seconds(60) + TOAAirAttackDelayMin[Difficulty] * 2, function()
    AiAirAttackProduction(TOA, TOAAttackAirTypes)
    AiAirAttackProduction(TOA2, TOA23AttackAirTypes)
  end)

  Trigger.AfterDelay(DateTime.Seconds(16), TOA4ProduceInfantry)

  --Enemy Predeployed Maneuvers
  
  --Proximity Triggers/Reveals
  
  --Timer
  
  --Crate spawns
  
  --Taunts
  
  --Testing
end


Tick = function()
	if #TeamNod > 0 then
		AssignToTeams(Nod.GetGroundAttackers(),TeamNod)
	end
	if #GoodGuy.GetGroundAttackers() > 0 then
		AssignToTeamsGlobal(GoodGuy.GetGroundAttackers(),TeamGDI)
	end
	if #GoodGuy.GetActorsByTypes({"e6","mcv"}) > 0 then
		AssignToTeamsGlobal(GoodGuy.GetActorsByTypes({"e6","mcv"}),TeamGDI)
	end
	OncePerSecondChecks()
	OncePerThreeSecondChecks()
end

OncePerSecondChecks = function()
  if DateTime.GameTime > 1 and DateTime.GameTime % 25 == 0 then
    --None
  end
end

OncePerThreeSecondChecks = function()
	if DateTime.GameTime > 1 and DateTime.GameTime % 75 == 0 then
  
    --[[if PlayerCanFail == true and HasOneOf(GDI, LossCheckAll) == false then
      PlayerFailMission()
    end]]
	
	if PlayerCanFail == true then
		TibAltCoopLossCheck()
	end
    
    if HasOneOf(TOA, LossCheckCritical) == false then
      GDI.MarkCompletedObjective(DefeatTOAObjective)
      GDI.MarkCompletedObjective(ProtectTempleObjective)
    end
    
    if TOA2Dead == false and HasOneOf(TOA2, LossCheckCritical) == false then
      TOA2Dead = true
    end
    
    if #TeamNod == 0 and NodDead == false and HasOneOf(Nod, LossCheckCritical) == false then
      NodDead = true
      Media.DisplayMessage("They're better than I thought. This is humiliating,\nbut my forces are defeated. Good luck, Commander.", "Elena", HSLColor.FromHex("FF0000"))
    end
    
    if MorelliSpawned == false then
      Utils.Do(TeamGDI,function(PID)
	  local hpads = PID.GetActorsByType('hpad')
      if #hpads > 0 then
        MorelliSpawned = true
        Media.DisplayMessage("Let's do this, Commander.", "Morelli", HSLColor.FromHex("857833"))
        local morelli = Actor.Create('morelli', true, { Owner = PID, Location = DragonSpawn.Location })
        morelli.Move(hpads[1].Location)
        Trigger.OnKilled(morelli, function(self, killer)
          Media.PlaySound('Morelli-09M-02.aud')
          Media.DisplayMessage("I can't believe they got me! I'm bailing out!", "Morelli", HSLColor.FromHex("857833"))
        end)
      end
	  end)
    end
    
    --manipulate AI funds
    ManipulatePlayerFunds(TOA)
    ManipulatePlayerFunds(TOA2)
    ManipulatePlayerFunds(TOA3)
    ManipulatePlayerFunds(TOA4)
    if NodHasProc == true then ManipulatePlayerFunds(Nod) end
    
    ControlAircraft(TOA)
    ControlAircraft(TOA2)
	end
end


PlayerFailMission = function()
  if DefeatTOAObjective ~= nil and not GDI.IsObjectiveCompleted(DefeatTOAObjective) then
    GDI.MarkFailedObjective(DefeatTOAObjective)
    GDI.MarkFailedObjective(ProtectTempleObjective)
  end
end