
TriggeredAlert1 = false
TriggeredAlert2 = false
PrisonersFreed = false
EvacuationStarted = false
AAADestroyed = false
ChopperSpawned = false
ChopperLanded = false


ActorRemovals = {
  easy = { Patroller1A, Patroller1B, Patroller1C, Patroller1D, Patroller1E, Patroller4, Patroller8 },
  normal = { Truck1, Truck2 },
  hard = { Truck1, Truck2 },
}


ProduceInfantry = function(factory)
  local infantryProduction = {
    normal = { 'e1', 'e1', 'e1', 'e1', 'e1', 'e3', 'e3', 'e3', 'e3', 'e3' },
    hard = { 'e1', 'e1', 'e1', 'e1', 'e1', 'e3', 'e3', 'e3', 'e3', 'e3', 'e1', 'e1', 'e1', 'e1', 'e1' }
  }

  if not factory.IsDead and factory.Owner == TOA then
    local production = infantryProduction[Difficulty]
    local toBuild = function() return production end
    
    ProduceUnits(TOA, factory, nil, toBuild, function(units)
      Utils.Do(units, function(unit) unit.Hunt() end)
      Trigger.AfterDelay(DateTime.Seconds(60), function()
        ProduceInfantry(factory)
      end)
    end)
  end
end


ProduceVehicles = function(factory)
  local vehicleProduction = {
    normal = { 'jeep', 'jeep', 'jeep' },
    hard = { 'jeep', 'jeep', 'jeep', 'mtnk', 'mtnk' }
  }
    
  if not factory.IsDead and factory.Owner == TOA then
    local production = vehicleProduction[Difficulty]
    local toBuild = function() return production end
    
    ProduceUnits(TOA, factory, nil, toBuild, function(units)
      Utils.Do(units, function(unit) unit.Hunt() end)
      Trigger.AfterDelay(DateTime.Seconds(60), function()
        ProduceVehicles(factory)
      end)
    end)
  end
end


WorldLoaded = function()
  GDI = Player.GetPlayer("GDI")
  FakeGDI = Player.GetPlayer("FakeGDI")
  TOA = Player.GetPlayer("TOA")
  Neutral = Player.GetPlayer("Neutral")
  
  MissionPlayer = GDI

	GoodGuy = Player.GetPlayer("GoodGuy")

	coopInfo =
	{
		Mainplayer = GDI,
		MainEnemies = {TOA},
		Dummyplayer = GoodGuy
	}
	
	ORAMod = "tibalt"

	CoopInit25(coopInfo)
	
	AssignToCoopPlayers(GDI.GetActorsByType("e6"), nil, true)
	BaseShared = true
	TechShared = true
	MoneyShareOverride = 100

  Camera.Position = StartCam.CenterPosition
  
  --Remove actors based on difficulty
  Utils.Do(ActorRemovals[Difficulty], function(unit)
    unit.Destroy()
  end)
  
  --Special lighting
  Lighting.Ambient = 0.9
  Lighting.Red = 0.7
  Lighting.Green = 0.7
  Lighting.Blue = 1.0
  
  --Player Reinforcements
  
  --Objectives
  InitObjectives(GDI)

  Trigger.AfterDelay(DateTime.Seconds(2), function()
    CapturePrisonObjective = GDI.AddObjective("Capture the TOA prison.")
    EvacuatePrisonersObjective = GDI.AddObjective("Evac prisoners to the dustoff zone.")
  end)
  
  Trigger.OnKilled(GhostStalker, function(self, killer)
    Media.DisplayMessage("I've failed you, Commander. My injuries are too severe. I must withdraw.", "Ghost Stalker", HSLColor.FromHex("00FF00"))
  end)
  
  Trigger.OnKilled(Prison, function(self, killer)
    if PrisonersFreed == false then PlayerFailMission() end
  end)
  
  Trigger.OnCapture(Prison, function(self, captor, oldOwner, newOwner)
    if IsOwnedByCoopPlayer(captor) then
      GDI.MarkCompletedObjective(CapturePrisonObjective)
      PrisonersFreed = true
      DateTime.TimeLimit = 0
      
      Reinforcements.Reinforce(newOwner, { "c7", "c7", "c7", "c7", "c7" }, { PrisonerSpawn.Location }, 5, function(unit)
        unit.Move(PrisonerMoveTo.Location)
        Trigger.OnKilled(unit, function(self, killer) GDI.MarkFailedObjective(EvacuatePrisonersObjective) end)
      end)
      
      Media.DisplayMessage("Thanks for the rescue, Commander. I thought I was going to die in that prison.", "Sheppard", HSLColor.FromHex("857833"))
      
      Trigger.AfterDelay(DateTime.Seconds(5), function()
        Media.DisplayMessage("No time to celebrate now, sir. We've got to evac before TOA brings the hammer down on us!", "McNeil", HSLColor.FromHex("857833"))
      end)
      
      Trigger.AfterDelay(DateTime.Seconds(10), function()
        Media.DisplayMessage("TOA anti-air emplacements detected.\nEvacuate to the east and destroy all AAAs so a transport helicopter can be brought in.", "EVA", HSLColor.FromHex("00FF00"))
        DestroyAAAObjective = GDI.AddObjective("Destroy all AAA units on the eastern island.")
        EvacuationStarted = true
      end)
      
      Trigger.AfterDelay(DateTime.Seconds(60), function()
        local hovertanks = TOA.GetActorsByType('hovertnk')
        Utils.Do(hovertanks, function(unit)
          unit.AttackMove(PrisonerSpawn.Location)
          unit.AttackMove(CounterAtk1.Location)
          unit.Patrol({ CounterPatrolPathA.Location, CounterPatrolPathB.Location, CounterPatrolPathC.Location, CounterPatrolPathD.Location }, true, DateTime.Seconds(8))
        end)
        
        if Difficulty ~= 'easy' then
          Reinforcements.Reinforce(TOA, { "hovertnk", "hovertnk", "hovertnk", "hovertnk", "hovertnk", "hovertnk" }, { HoverSpawn.Location }, 15, function(unit)
            unit.AttackMove(PrisonerSpawn.Location)
            unit.AttackMove(CounterAtk1.Location)
            unit.Patrol({ CounterPatrolPathA.Location, CounterPatrolPathB.Location, CounterPatrolPathC.Location, CounterPatrolPathD.Location }, true, DateTime.Seconds(8))
          end)
        end
      end)
    end
  end)
  
  Trigger.OnAllKilled({AAA1, AAA2, AAA3, AAA4, AAA5, AAA6, AAA7}, function()
    AAADestroyed = true
    GDI.MarkCompletedObjective(DestroyAAAObjective)
  end)
  
  --AI player behavior
  TOA.Cash = 10000
  TOA.Resources = TOA.ResourceCapacity - 500
  SetupRefAndSilosCaptureCredits(TOA)
  AutoReplaceHarvesters(TOA)
  if Difficulty ~= 'easy' then AutoRepairAndRebuildBuildings(TOA, 15, {'proc'}) end
  
  Utils.Do(CoopPlayers,function(PID)
	SellBuildingIfEngyNear(Fact, 4, PID)
	SellBuildingIfEngyNear(Proc, 4, PID)
  end)
  
  if Difficulty ~= 'easy' then
    Utils.Do({Alert1A, Alert1B, Alert1C, Alert1D, Alert1E, Alert1F, Alert1G, Alert1H, Alert1I, Alert1J, Alert1K, Alert1L, Alert1M, Alert1N}, function(unit)
      Trigger.OnKilled(unit, function(self, killer)
        if TriggeredAlert1 == false then
          TriggeredAlert1 = true
          ProduceInfantry(Pyle1)
        end
      end)
    end)
    
    Utils.Do({Alert2A, Alert2B, Alert2C, Alert2D, Alert2E, Alert2F, Alert2G, Alert2H, Alert2I, Alert2J}, function(unit)
      Trigger.OnKilled(unit, function(self, killer)
        if TriggeredAlert2 == false then
          TriggeredAlert2 = true
          ProduceInfantry(Pyle2)
        end
      end)
    end)
    
    Trigger.OnEnteredProximityTrigger(AlertProx.CenterPosition, WDist.New(2 * 1024), function(a, id)
      if IsOwnedByCoopPlayer(a) and a.Type ~= 'camera' and a.Type ~= 'camera.small' then
        Trigger.RemoveProximityTrigger(id)
        ProduceVehicles(Weap)
      end
    end)
  end
  
  --Enemy Predeployed Maneuvers
  if Difficulty ~= 'easy' then
    Utils.Do({ Patroller1A, Patroller1B, Patroller1C, Patroller1D, Patroller1E }, function(unit)
      unit.Patrol({ PatrolPath1A.Location, PatrolPath1B.Location, PatrolPath1C.Location, PatrolPath1D.Location }, true, DateTime.Seconds(8))
    end)
    
    Patroller4.Patrol({ PatrolPath4A.Location, PatrolPath4B.Location }, true, DateTime.Seconds(8))
    Patroller8.Patrol({ PatrolPath8A.Location, PatrolPath8B.Location, PatrolPath8C.Location, PatrolPath8D.Location }, true, DateTime.Seconds(8))
  end
  
  Patroller2.Patrol({ PatrolPath2A.Location, PatrolPath2B.Location }, true, DateTime.Seconds(8))
  Patroller3.Patrol({ PatrolPath3A.Location, PatrolPath3B.Location }, true, DateTime.Seconds(8))
  Patroller5.Patrol({ PatrolPath5A.Location, PatrolPath5B.Location, PatrolPath5C.Location, PatrolPath5D.Location }, true, DateTime.Seconds(8))
  Patroller6.Patrol({ PatrolPath6A.Location, PatrolPath6B.Location, PatrolPath6C.Location, PatrolPath6D.Location }, true, DateTime.Seconds(8))
  Patroller7.Patrol({ PatrolPath7A.Location, PatrolPath7B.Location, PatrolPath7C.Location, PatrolPath7D.Location }, true, DateTime.Seconds(8))
  
  Utils.Do({ Patroller9A, Patroller9B, Patroller9C, Patroller9D, Patroller9E }, function(unit)
    unit.Patrol({ CounterPatrolPathD.Location, CounterPatrolPathC.Location, CounterPatrolPathB.Location, CounterPatrolPathA.Location }, true, DateTime.Seconds(8))
  end)
  
  Utils.Do({ Patroller10A, Patroller10B, Patroller10C, Patroller10D, Patroller10E }, function(unit)
    unit.Patrol({ CounterPatrolPathB.Location, CounterPatrolPathC.Location, CounterPatrolPathD.Location, CounterPatrolPathA.Location }, true, DateTime.Seconds(8))
  end)
  
  --Proximity Triggers/Reveals
  CoopSetUpProximityReveal(GDI, {Prox1A, Prox1B}, {Cam1A, Cam1B}, 2, 15, false)
  CoopSetUpProximityReveal(GDI, {Prox2A, Prox2B}, {Cam2}, 4, 15, false)
  CoopSetUpProximityReveal(GDI, {Prox3}, {Cam3A, Cam3B}, 16, 0, false)
  CoopSetUpProximityReveal(GDI, {Prox4A}, {Cam4A, Cam4B, Cam4C, Cam4D}, 5, 0, false)
  CoopSetUpProximityReveal(GDI, {Prox4B}, {Cam4A, Cam4B, Cam4C, Cam4D}, 4, 0, false)
  CoopSetUpProximityReveal(GDI, {Prox4C}, {Cam4A, Cam4B, Cam4C, Cam4D}, 13, 0, false)
  CoopSetUpProximityReveal(GDI, {Prox5A}, {Cam5A, Cam5B, Cam5C, Cam5D, Cam5E, Cam5F}, 4, 0, false)
  CoopSetUpProximityReveal(GDI, {Prox5B}, {Cam5A, Cam5B, Cam5C, Cam5D, Cam5E, Cam5F}, 12, 0, false)
  CoopSetUpProximityReveal(GDI, {Prox6}, {Prox6}, 10, 15, false)
  CoopSetUpProximityReveal(GDI, {Prox7}, {Prox7}, 12, 15, false)
  CoopSetUpProximityReveal(GDI, {Prox8}, {Cam8A, Cam8B, Cam8C, Cam8D, Cam8E, Cam8F, Cam8G, Cam8H}, 12, 0, false)
    
  --Timer
  if Difficulty == 'hard' then
    Trigger.AfterDelay(DateTime.Seconds(10), function()
      Media.DisplayMessage("Bad news, Commander. I just received word that TOA is planning to execute the GDI loyalists.", "McNeil", HSLColor.FromHex("857833"))
    end)
    
    Trigger.AfterDelay(DateTime.Seconds(15), function()
      Media.DisplayMessage("You're on the clock. Capture that prison before they execute everyone!", "McNeil", HSLColor.FromHex("857833"))
      
      TimerDuration = 900
      DateTime.TimeLimit = DateTime.Seconds(TimerDuration)
      Media.PlaySound("Eva-MissionTimer.aud")
      
      Trigger.OnTimerExpired(function()
        if PrisonersFreed == false then
          Media.DisplayMessage("We were too late... the executions have been carried out.\nI'm sorry, my friends. We've failed you.", "McNeil", HSLColor.FromHex("857833"))
          Trigger.AfterDelay(DateTime.Seconds(3), function() PlayerFailMission() end)
        end
      end)
    end)
  end
  
  --Crate spawns
  if Difficulty == 'easy' then
    Utils.Do( {Truck1, Truck2}, function(truck)
      Trigger.OnKilled(truck, function(self, killer)
        Actor.Create("moneycrate", true, { Owner = GDI, Location = truck.Location })
      end)
    end)
  end
  
  --Taunts
  
  --Testing
end


Tick = function()
	OncePerSecondChecks()
	OncePerThreeSecondChecks()
end

OncePerSecondChecks = function()
  if DateTime.GameTime > 1 and DateTime.GameTime % 25 == 0 then
    --none
  end
end

OncePerThreeSecondChecks = function()
	if DateTime.GameTime > 1 and DateTime.GameTime % 75 == 0 then
  
    --[[if HasOneOf(GDI, LossCheckAll) == false then
      PlayerFailMission()
    end]]
	
	TibAltCoopLossCheck()
    
    if EvacuationStarted == true and AAADestroyed == true and ChopperSpawned == false then
      ChopperSpawned = true
      Actor.Create("flare", true, { Owner = GoodGuy, Location = Flare.Location })
      Media.PlaySpeechNotification(All, "Reinforce")
      
      Reinforcements.Reinforce(FakeGDI, { "tran" }, { TranSpawn.Location }, 5, function(tran)
        Trigger.OnKilled(tran, function(self, killer)
          Media.DisplayMessage("The evacuation helicopter was destroyed. Prisoner evacuation is no longer possible.", "EVA", HSLColor.FromHex("00FF00"))
          GDI.MarkFailedObjective(EvacuatePrisonersObjective)
        end)
        
        tran.Move(TranMoveTo.Location)
        tran.Land(TranMoveTo)
        tran.CallFunc(function()
          ChopperLanded = true
          Media.DisplayMessage("Evacuation helicopter has landed on top of the hill.\nBring the prisoners to the dustoff zone for evacuation.", "EVA", HSLColor.FromHex("00FF00"))
        end)
      end)
    end
    
    if ChopperLanded == true then
      local prisoners = Map.ActorsInBox(HilltopNW.CenterPosition, HilltopSE.CenterPosition, function(a)
        return a.Type == 'c7'
      end)
      
      if #prisoners == 5 then
        GDI.MarkCompletedObjective(EvacuatePrisonersObjective)
      end
    end

    --manipulate AI funds
    ManipulatePlayerFunds(TOA)
	end
end


PlayerFailMission = function()
  if CapturePrisonObjective ~= nil and not GDI.IsObjectiveCompleted(CapturePrisonObjective) then
    GDI.MarkFailedObjective(CapturePrisonObjective)
  end
  if EvacuatePrisonersObjective ~= nil and not GDI.IsObjectiveCompleted(EvacuatePrisonersObjective) then
    GDI.MarkFailedObjective(EvacuatePrisonersObjective)
  end
end
