
CivTypesEvacuated = { }
FreezeEvacuations = true
CivilianTownsEvacuated = 0
PlayerCanLose = true
PlayerFoundBase = false
CiviliansKilled = 0

TownsEvacuated = { SW = false, W = false, NW = false, NE = false, E = false }
TownsAttacked = { SW = false, W = false, NW = false, NE = false, E = false }
TownCivs = { SW = 'c2', W = 'c3', NW = 'c4', NE = 'c5', E = 'c6' }

TownAttackOrders = {
  [1] = { [1] = 'SW', [2] = 'W',  [3] = 'NW', [4] = 'NE', [5] = 'E' },
  [2] = { [1] = 'E',  [2] = 'NE', [3] = 'NW', [4] = 'W',  [5] = 'SW' },
  [3] = { [1] = 'W',  [2] = 'E',  [3] = 'SW', [4] = 'NE', [5] = 'NW' },
  [4] = { [1] = 'NW', [2] = 'NE', [3] = 'SW', [4] = 'E',  [5] = 'W' },
  [5] = { [1] = 'NW', [2] = 'NE', [3] = 'SW', [4] = 'W',  [5] = 'E' },
  [6] = { [1] = 'E',  [2] = 'W',  [3] = 'SW', [4] = 'NE', [5] = 'NW' }
}
RandomTownAttackOrder = 1
TownAttackCounter = 1

MonsterAttackDelay = {
  easy = DateTime.Seconds(240),
  normal = DateTime.Seconds(180),
  hard = DateTime.Seconds(120)
}

MonsterAttackCycle = {
  easy = DateTime.Seconds(240),
  normal = DateTime.Seconds(180),
  hard = DateTime.Seconds(150)
}


ActorRemovals = {
  easy = {  },
  normal = { },
  hard = { HardRmv1, HardRmv2, HardRmv3, HardRmv4, HardRmv5, HardRmv6 },
}


SetCivilianDeathTracking = function(civType)
  local civs = {}
  Utils.Do(CoopPlayers,function(PID)
	Utils.Do(PID.GetActorsByType(civType),function(UID)
		table.insert(civs,UID)
	end)
  end)
  Utils.Do(civs, function(civ)
    Trigger.OnKilled(civ, function()
      CiviliansKilled = CiviliansKilled + 1
      Media.DisplayMessage("A civilian has been killed.", "WARNING", HSLColor.FromHex("FFFF00"))
      if CiviliansKilled == 7 then
        Media.DisplayMessage("The number of civilians killed is approaching unacceptable levels.", "WARNING", HSLColor.FromHex("FF0000"))
      elseif CiviliansKilled == 10 then
        GDI.MarkFailedObjective(ProtectCivsObjective)
      end
    end)
  end)
end


ReadyMonsterSpawns = function()
  RandomTownAttackOrder = Utils.RandomInteger(1, 7)
  Trigger.AfterDelay(MonsterAttackDelay[Difficulty]/2 + MonsterAttackCycle[Difficulty], LaunchMonsterAttack)
  Trigger.AfterDelay(MonsterAttackDelay[Difficulty] + MonsterAttackCycle[Difficulty], AttackNextTown)
end


LaunchBossAttack = function()
  Media.DisplayMessage("An unknown species of Tiberium life has been detected approaching the base.", "WARNING!", HSLColor.FromHex("FF0000"))
  Reinforcements.Reinforce(TibLife, {'tibabom'}, { TibSpawn4.Location }, 15, function(monster)
    monster.AttackMove(TibAtk3A.Location)
    monster.AttackMove(TibAtk3B.Location)
    monster.Hunt()
  end)
end


LaunchMonsterAttack = function()
  local random1 = Utils.RandomInteger(1, 100)

  if random1 <= 50 then
    Reinforcements.Reinforce(TibLife, {'tfnd', 'tfnd', 'pvice'}, { TibSpawn1A.Location }, 15, function(monster)
      monster.AttackMove(TibAtk1.Location)
      monster.Hunt()
    end)
    Reinforcements.Reinforce(TibLife, {'tfnd', 'pvice'}, { TibSpawn1B.Location }, 15, function(monster)
      monster.AttackMove(TibAtk1.Location)
      monster.Hunt()
    end)
    Reinforcements.Reinforce(TibLife, {'tfnd', 'pvice'}, { TibSpawn1C.Location }, 15, function(monster)
      monster.AttackMove(TibAtk1.Location)
      monster.Hunt()
    end)
  elseif not Bio.IsDead then
    Reinforcements.Reinforce(TibLife, {'zombie', 'zombie', 'zombie', 'zombie', 'zombie', 'zombie', 'zombie', 'zombie', 'zombie', 'zombie', 'zombie', 'zombie', 'zombie', 'zombie', 'zombie' }, { TibSpawn2.Location }, 15, function(monster)
      monster.AttackMove(TibAtk1.Location)
      monster.Hunt()
    end)
  end
  
  local random2 = Utils.RandomInteger(1, 100)
  --Media.DisplayMessage("DEBUG: Picked " .. random2)
  if random2 <= 50 then
    Reinforcements.Reinforce(TibLife, {'tfnd', 'tfnd', 'tfnd', 'pvice', 'pvice'}, { TibSpawn3.Location }, 15, function(monster)
      monster.AttackMove(TibAtk2.Location)
      monster.Hunt()
    end)
  else
    Reinforcements.Reinforce(TibLife, {'floater', 'floater', 'floater'}, { TibSpawn4.Location }, 15, function(monster)
      monster.AttackMove(TibAtk3A.Location)
      monster.AttackMove(TibAtk3B.Location)
      monster.Hunt()
    end)
  end

  Trigger.AfterDelay(MonsterAttackCycle[Difficulty], LaunchMonsterAttack)
end


AttackNextTown = function()
  if TownAttackCounter >= 6 then return end
  local town = TownAttackOrders[RandomTownAttackOrder][TownAttackCounter]
  TownAttackCounter = TownAttackCounter + 1

  if town == 'SW' then
    AttackCivilianTown('SW', CivCam1A, CivCam1B, CivSpawn1A, CivSpawn1B, CivProx1, 'southwestern', {'pvice', 'pvice', 'tfnd', 'tfnd'}, {'pvice', 'tfnd', 'tfnd', 'tfnd'}, CivTibSpawn1A, CivTibSpawn1B, CivProx1)
  elseif town == 'W' then
    AttackCivilianTown('W', CivCam2, CivCam2, CivSpawn2A, CivSpawn2B, CivCam2, 'western', {'pvice', 'pvice', 'tfnd', 'tfnd'}, {'pvice', 'tfnd', 'tfnd', 'tfnd'}, CivTibSpawn2A, CivTibSpawn2B, CivCam2)
  elseif town == 'E' then
    AttackCivilianTown('NW', CivCam3, CivCam3, CivSpawn3A, CivSpawn3B, CivCam3, 'eastern', {'pvice', 'pvice', 'tfnd', 'tfnd'}, {'pvice', 'tfnd', 'tfnd', 'tfnd'}, CivTibSpawn3A, CivTibSpawn3B, CivCam3)
  elseif town == 'NE' then
    AttackCivilianTown('NE', CivCam4, CivCam4, CivSpawn4A, CivSpawn4B, CivCam4, 'northeastern', {'pvice', 'pvice', 'tfnd', 'tfnd'}, {'floater', 'floater', 'floater'}, CivTibSpawn4A, CivTibSpawn4B, CivCam4)
  elseif town == 'NW' then
    AttackCivilianTown('E', CivProx5, CivProx5, CivSpawn5A, CivSpawn5B, CivProx5, 'northwestern', {'pvice', 'pvice', 'tfnd', 'tfnd'}, {'pvice', 'tfnd', 'tfnd', 'tfnd'}, CivTibSpawn5A, CivTibSpawn5B, CivProx5)
  end

  Trigger.AfterDelay(MonsterAttackCycle[Difficulty], AttackNextTown)
end


AttackCivilianTown = function(town, cam1wp, cam2wp, civSpawn1, civSpawn2, civMoveTo, direction, monsterSpawns1, monsterSpawns2, monsterSpawnWp1, monsterSpawnWp2, monstersMoveTo)
  Actor.Create("camera", true, { Owner = GDI, Location = cam1wp.Location })
  Actor.Create("camera", true, { Owner = GDI, Location = cam2wp.Location })
  
  if TownsEvacuated[town] == false then
    TownsEvacuated[town] = true
    local civType = TownCivs[town]
    Reinforcements.Reinforce(GDI, {civType, civType, civType, civType, civType}, { civSpawn1.Location }, 5, function(civ)
      civ.Move(civMoveTo.Location)
    end)
    Reinforcements.Reinforce(GDI, {civType, civType, civType, civType, civType}, { civSpawn2.Location }, 5, function(civ)
      civ.Move(civMoveTo.Location)
    end)
    
    Media.DisplayMessage("They're coming right at us! Get us out, please!", "Civilian", HSLColor.FromHex("857833"))
    
    Trigger.AfterDelay(DateTime.Seconds(3), function()
      Media.DisplayMessage("The " .. direction .. " town will soon come under attack. Send forces to rescue them immediately.", "EVA", HSLColor.FromHex("00FF00"))
      SetCivilianDeathTracking(civType)
    end)
  end
  
  Trigger.AfterDelay(DateTime.Seconds(45), function()
    Reinforcements.Reinforce(TibLife2, monsterSpawns1, { monsterSpawnWp1.Location }, 15, function(monster)
      monster.AttackMove(monstersMoveTo.Location)
      monster.Hunt()
    end)
    
    Reinforcements.Reinforce(TibLife2, monsterSpawns2, { monsterSpawnWp2.Location }, 15, function(monster)
      monster.AttackMove(monstersMoveTo.Location)
      monster.Hunt()
    end)
  end)
end


SetUpTownEvac = function(town, proxWp, proxDistance, cam1wp, cam2wp, civSpawn1, civSpawn2, civMoveTo)
   Trigger.OnEnteredProximityTrigger(proxWp.CenterPosition, WDist.New(proxDistance * 1024), function(a, id)
    if a.Type == 'ghstlkr' then
      local GhostOwner = a.Owner
	  Trigger.RemoveProximityTrigger(id)
      if TownsEvacuated[town] == true then return end
      TownsEvacuated[town] = true
      Actor.Create("camera", true, { Owner = GDI, Location = cam1wp.Location })
      Actor.Create("camera", true, { Owner = GDI, Location = cam2wp.Location })
      
      Media.DisplayMessage("GDI is here to evacuate you. Go with them if you want to live.", "Ghost Stalker", HSLColor.FromHex("00FF00"))

      Trigger.AfterDelay(DateTime.Seconds(5), function()
        local civType = TownCivs[town]
        Reinforcements.Reinforce(GhostOwner, {civType, civType, civType, civType, civType}, { civSpawn1.Location }, 5, function(civ)
          civ.Move(civMoveTo.Location)
        end)
        Reinforcements.Reinforce(GhostOwner, {civType, civType, civType, civType, civType}, { civSpawn2.Location }, 5, function(civ)
          civ.Move(civMoveTo.Location)
        end)
        
        Media.DisplayMessage("Take the civilians to the transport helicopter for evacuation.", "EVA", HSLColor.FromHex("00FF00"))
        
        Trigger.AfterDelay(DateTime.Seconds(3), function()
          SetCivilianDeathTracking(civType)
        end)
      end)
    end
  end)
end


SendTransportHeli = function()
  Media.PlaySpeechNotification(All, "Reinforce")
  Reinforcements.Reinforce(FakeGDI, {'tran'}, { TranSpawn.Location }, 15, function(tran)
    Trigger.OnKilled(tran, function(self, killer)
      Media.DisplayMessage("Transport helicopter destroyed. Civilian evacuation no longer possible.", "EVA", HSLColor.FromHex("00FF00"))
      GDI.MarkFailedObjective(EvacCivsObjective)
    end)
    tran.Move(TranMoveTo.Location)
    tran.Land(TranMoveTo)
    tran.CallFunc(function() FreezeEvacuations = false end)
  end)
end


CivilianEvacCheck = function()
  if FreezeEvacuations == true then return end
  
  local civTypes = { 'c2', 'c3', 'c4', 'c5', 'c6' }
  Utils.Do(civTypes, function(civType)
    local total = {}
	Utils.Do(CoopPlayers,function(PID)
		Utils.Do(PID.GetActorsByType(civType),function(UID)
			table.insert(total,UID)
		end)
	end)
	local atDustoffZone = Map.ActorsInBox(EvacNW.CenterPosition, EvacSE.CenterPosition, function(a)
      return IsOwnedByCoopPlayer(a) and a.Type == civType
    end)
    local evacTrans = FakeGDI.GetActorsByType('tran')
    
    if #total > 0 and FreezeEvacuations == false and ListContains(CivTypesEvacuated, civType) == false and #total == #atDustoffZone and #evacTrans > 0 then
      FreezeEvacuations = true
      local evacTran = evacTrans[1]
      evacTran.Owner = FakeCiv
      Utils.Do(total, function(civ)
        civ.Owner = FakeCiv
        civ.Move(TranMoveTo.Location)
        civ.Destroy()
      end)
      
      table.insert(CivTypesEvacuated, civType)
      
      Trigger.AfterDelay(DateTime.Seconds(6), function()
        Media.DisplayMessage("Transport chopper is evacuating a group of civilians.", "EVA", HSLColor.FromHex("00FF00"))
        evacTran.Move(TranSpawn.Location)
        evacTran.CallFunc(function()
          CivilianTownsEvacuated = CivilianTownsEvacuated + 1
          UserInterface.SetMissionText(CivilianTownsEvacuated .. " of 5 towns evacuated.", HSLColor.Yellow)
          if CivilianTownsEvacuated < 5 then
            SendTransportHeli()
          else
            GDI.MarkCompletedObjective(EvacCivsObjective)
            GDI.MarkCompletedObjective(ProtectCivsObjective)
            GDI.MarkCompletedObjective(ProtectGhostStalkerObjective)
          end
          
          if Difficulty ~= 'easy' and CivilianTownsEvacuated == 3 then
            Trigger.AfterDelay(DateTime.Seconds(5), LaunchBossAttack)
          end
        end)
        evacTran.Destroy()
      end)
    end
  end)
end


WorldLoaded = function()
  GDI = Player.GetPlayer("GDI")
  FakeGDI = Player.GetPlayer("FakeGDI")
  Forgotten = Player.GetPlayer("Forgotten")
  TibLife = Player.GetPlayer("TibLife")
  TibLife2 = Player.GetPlayer("TibLife2")
  FakeCiv = Player.GetPlayer("FakeCiv")
  TargetableCivs = Player.GetPlayer("TargetableCivs")
  Neutral = Player.GetPlayer("Neutral")
  
  MissionPlayer = GDI

	GoodGuy = Player.GetPlayer("GoodGuy")

	coopInfo =
	{
		Mainplayer = GDI,
		MainEnemies = {TibLife, TibLife2},
		Dummyplayer = GoodGuy
	}
	
	ORAMod = "tibalt"

	CoopInit25(coopInfo)

	BaseShared = true
	TechShared = true
	MoneyShareOverride = 100

  Camera.Position = StartCam.CenterPosition

  --Remove actors based on difficulty
  Utils.Do(ActorRemovals[Difficulty], function(unit)
    unit.Destroy()
  end)
  
  --Special lighting
  Lighting.Ambient = 0.8
  Lighting.Red = 1.25
  Lighting.Blue = 0.75
  Lighting.Green = 1.1
  
  --Player Reinforcements
  Trigger.AfterDelay(DateTime.Seconds(3), function()
    Reinforcements.Reinforce(GoodGuy, {'exosuit', 'exosuit', 'e1', 'e1', 'e1', 'e1', 'e1', 'e2', 'e2', 'e2', 'e2', 'e2'}, { GDISpawn1.Location }, 10, function(unit)
      unit.Move(GDIMoveTo1.Location)
    end)
    Media.PlaySpeechNotification(All, "Reinforce")
  end)
  
  if Difficulty == 'easy' then
    Trigger.AfterDelay(DateTime.Seconds(8), function()
      Reinforcements.Reinforce(GoodGuy, {'exosuit', 'exosuit'}, { GDISpawn1.Location }, 15, function(unit)
        unit.Move(GDIMoveTo1.Location)
      end)
      Media.PlaySpeechNotification(All, "Reinforce")
    end)
  end
  
  Trigger.OnEnteredProximityTrigger(Prox1.CenterPosition, WDist.New(5 * 1024), function(a, id)
    if IsOwnedByCoopPlayer(a) then
      Trigger.RemoveProximityTrigger(id)
      PlayerCanLose = false
	  Cutscenemode = true
      local cam1 = Actor.Create("camera", true, { Owner = GDI, Location = Cam1A.Location })
      local cam2 = Actor.Create("camera", true, { Owner = GDI, Location = Cam1A.Location })
      local playerForces = {}
	  Utils.Do(CoopPlayers,function(PID)
		Utils.Do(PID.GetActors(),function(UID)
			table.insert(playerForces,UID)
		end)
	  end)
      
      Utils.Do(playerForces, function(unit)
        if unit.HasProperty("Move") then
          unit.Owner = FakeGDI
        end
      end)
      
      Trigger.AfterDelay(DateTime.Seconds(2), function()
        Utils.Do(playerForces, function(unit)
          if unit.HasProperty("Move") then
            Trigger.ClearAll(unit)
            unit.Stop()
            unit.AttackMove(Cam1B.Location)
          end
        end)
      end)
      
      Media.DisplayMessage("GDI forces? Are you here to 'relocate' us to your camps?", "Forgotten", HSLColor.FromHex("00FF00"))
      Trigger.AfterDelay(DateTime.Seconds(5), function()
        Media.DisplayMessage("No, we're here to evac you before the Tiberium mutations kill you all.", "GDI", HSLColor.FromHex("857833"))
      end)
      Trigger.AfterDelay(DateTime.Seconds(10), function()
        Media.DisplayMessage("We're offering to take you to a settlement in a safer location.", "GDI", HSLColor.FromHex("857833"))
      end)
      Trigger.AfterDelay(DateTime.Seconds(15), function()
        Media.DisplayMessage("Why should we trust you? My people have suffered much at GDI's hands.", "Forgotten", HSLColor.FromHex("00FF00"))
      end)
      Trigger.AfterDelay(DateTime.Seconds(20), function()
        Media.DisplayMessage("Because we're not forcing you to go with us. You can come or stay as you wish.", "GDI", HSLColor.FromHex("857833"))
      end)
      Trigger.AfterDelay(DateTime.Seconds(25), function()
        Media.DisplayMessage("Very well, we'll give you a chance to prove yourselves.", "Forgotten", HSLColor.FromHex("00FF00"))
      end)
      Trigger.AfterDelay(DateTime.Seconds(30), function()
        Media.DisplayMessage("My name is Ghost Stalker. My warriors and I will lend you our aid.", "Forgotten", HSLColor.FromHex("00FF00"))
      end)
      Trigger.AfterDelay(DateTime.Seconds(35), function()
        Media.DisplayMessage("Take me to the towns. I'm the only one they will trust.", "Ghost Stalker", HSLColor.FromHex("00FF00"))
      end)
      Trigger.AfterDelay(DateTime.Seconds(40), function()
        Media.DisplayMessage("Be wary, there is a village farther west where the people have gone berserk.", "Ghost Stalker", HSLColor.FromHex("00FF00"))
      end)
      Trigger.AfterDelay(DateTime.Seconds(45), function()
        Reinforcements.Reinforce(Forgotten, {'mutsldr', 'mutsldr', 'mutsldr', 'mutsldr', 'mutsldr'}, { ForgottenSpawn1.Location }, 5, function(unit)
          unit.Move(ForgottenMoveTo1.Location)
        end)
        Reinforcements.Reinforce(Forgotten, {'mutsldr', 'mutsldr', 'mutsldr', 'mutsldr', 'mutsldr'}, { ForgottenSpawn2.Location }, 5, function(unit)
          unit.Move(ForgottenMoveTo2.Location)
        end)
      end)
      Trigger.AfterDelay(DateTime.Seconds(50), function()
        local units = Map.ActorsInBox(ForgottenNW.CenterPosition, ForgottenSE.CenterPosition, function(a)
          return a.Type == 'e1' or a.Type == 'e2' or a.Type == 'ghstlkr' or a.Type == 'mutsldr' or a.Type == 'ttnk' or a.Type == 'exosuit'
        end)
        Utils.Do(units, function(unit) unit.Owner = GoodGuy end)
        Media.DisplayMessage("**Battle Control Reestablished**", "EVA", HSLColor.FromHex("00FF00"))
        cam1.Destroy()
        cam2.Destroy()
        PlayerCanLose = true
		Cutscenemode = false
        ProtectGhostStalkerObjective = GDI.AddObjective("Ghost Stalker must survive.")
        Trigger.OnKilled(GhostStalker, function()
          GDI.MarkFailedObjective(ProtectGhostStalkerObjective)
        end)
      end)
    end
  end)
  
  Utils.Do({Prox2A, Prox2B}, function(waypoint)
    Trigger.OnEnteredProximityTrigger(waypoint.CenterPosition, WDist.New(8 * 1024), function(a, id)
      if IsOwnedByCoopPlayer(a) then
        Trigger.RemoveProximityTrigger(id)
        if PlayerFoundBase == false then
          PlayerFoundBase = true
          local base = Map.ActorsInBox(BaseNW.CenterPosition, BaseSE.CenterPosition, function(a)
            return a.Owner == FakeGDI
          end)
          Utils.Do(base, function(unit) unit.Owner = a.Owner end)
          Reinforcements.Reinforce(a.Owner, {'harv'}, { HarvSpawn.Location }, 5, function(unit) end)
          
          Actor.Create("camera.small", true, { Owner = GDI, Location = FlareSpawn.Location })
          Actor.Create("flare", true, { Owner = GoodGuy, Location = FlareSpawn.Location })
          SendTransportHeli()
          ReadyMonsterSpawns()
          
          Trigger.AfterDelay(DateTime.Seconds(5), function()
            Media.PlaySpeechNotification(All, "Reinforce")
            Media.DisplayMessage("Allow me to lend a hand.", "Morelli", HSLColor.FromHex("857833"))
            Reinforcements.Reinforce(a.Owner, {'morelli'}, { GDISpawn1.Location }, 5, function(unit)
              unit.Move(MorelliMoveTo.Location)
              Trigger.OnKilled(unit, function()
                Media.PlaySound('Morelli-09M-02.aud')
                Media.DisplayMessage("I can't believe they got me! I'm bailing out!", "Morelli", HSLColor.FromHex("857833"))
              end)
            end)
          end)
        end
      end
    end)
  end)
  
  --Objectives
  InitObjectives(GDI)

  Trigger.AfterDelay(DateTime.Seconds(2), function()
    EvacCivsObjective = GDI.AddObjective("Evacuate all 5 civilian settlements.")
    ProtectCivsObjective = GDI.AddObjective("Protect the civilians.")
  end)
  
  UserInterface.SetMissionText(CivilianTownsEvacuated .. " of 5 towns evacuated.", HSLColor.Yellow)

  local targetableCivs = GetAllCivilians(TargetableCivs)
  Utils.Do(targetableCivs, function(civ)
    Trigger.OnKilled(civ, function(self, killer)
      if IsOwnedByCoopPlayer(killer) then
        Media.DisplayMessage("You lunatic, the mission is to evacuate the civvies, not massacre them!", "Morelli", HSLColor.FromHex("857833"))
        GDI.MarkFailedObjective(ProtectCivsObjective)
      end
    end)
  end)
  
  --AI player behavior
  
  --Enemy Predeployed Maneuvers
  
  --Proximity Triggers/Reveals
  SetUpTownEvac('SW', CivProx1, 12, CivCam1A, CivCam1B, CivSpawn1A, CivSpawn1B, CivProx1)
  SetUpTownEvac( 'W', CivProx2, 2,  CivCam2,  CivCam2,  CivSpawn2A, CivSpawn2B, CivCam2)
  SetUpTownEvac( 'E', CivProx3, 5,  CivCam3,  CivCam3,  CivSpawn3A, CivSpawn3B, CivCam3)
  SetUpTownEvac('NE', CivProx4, 5,  CivCam4,  CivCam4,  CivSpawn4A, CivSpawn4B, CivCam4)
  SetUpTownEvac('NW', CivProx5, 8,  CivProx5, CivProx5, CivSpawn5A, CivSpawn5B, CivProx5)
  
  Trigger.OnEnteredProximityTrigger(EvacProx1.CenterPosition, WDist.New(2 * 1024), function(a, id)
    if a.Type == 'amphapc' then
      local Originalowner = a.Owner
	  Media.DisplayMessage("APC cannot climb hill. It must unload its passengers at the hill's base.", "NOTICE", HSLColor.FromHex("00FF00"))
      a.Owner = FakeGDI
      a.Stop()
      a.Move(APCMoveTo.Location)
      a.CallFunc(function() a.Owner = Originalowner end)
    end
  end)
  
  --Timer
  
  --Crate spawns
  
  --Taunts
  
  --Testing
end


Tick = function()
	if Cutscenemode == true then
		LockCamKeepHealthy()
	end
	ReassignHarv()
	OncePerSecondChecks()
	OncePerThreeSecondChecks()
end

ReassignHarv = function()
	local RefOwner = GoodGuy
	Utils.Do(CoopPlayers,function(PID)
		if #PID.GetActorsByType("proc") > 0 then
			RefOwner = PID
		end
		if PID ~= RefOwner then
			Utils.Do(PID.GetActorsByType("harv"),function(UID)
				UID.Owner = RefOwner
				Media.DisplayMessage("The Harvester of " .. PID.Name .. " has been reassigned to " .. RefOwner.Name .. ".", "EVA", HSLColor.FromHex("00FF00"))
			end)
		end
	end)
end

LockCamKeepHealthy = function()
	Utils.Do(FakeGDI.GetActors(),function(UID)
		if UID.HasProperty("Move") and UID.IsDead == false and UID.IsInWorld == true then
			UID.Health = UID.MaxHealth
		end
	end)
	Camera.Position = GhostStalker.CenterPosition
end

OncePerSecondChecks = function()
  if DateTime.GameTime > 1 and DateTime.GameTime % 25 == 0 then
    
    local naughtyAPCs = Map.ActorsInBox(EvacNW.CenterPosition, EvacSE.CenterPosition, function(a)
      return a.Type == 'amphapc'
    end)
    
    Utils.Do(naughtyAPCs, function(apc)
      apc.Move(APCMoveTo.Location)
      apc.CallFunc(function() apc.Owner = GDI end)
    end)
    
  end
end

OncePerThreeSecondChecks = function()
	if DateTime.GameTime > 1 and DateTime.GameTime % 75 == 0 then
  
    --[[if PlayerCanLose == true and HasOneOf(GDI, LossCheckAll) == false then
      GDI.MarkFailedObjective(EvacCivsObjective)
    end]]
	
	if PlayerCanLose == true then
		TibAltCoopLossCheck()
	end
    
    CivilianEvacCheck()

    --manipulate AI funds
    
	end
end


PlayerFailMission = function()
  if EvacCivsObjective ~= nil and not GDI.IsObjectiveCompleted(EvacCivsObjective) then
    GDI.MarkFailedObjective(EvacCivsObjective)
  end
  if ProtectCivsObjective ~= nil and not GDI.IsObjectiveCompleted(ProtectCivsObjective) then
    GDI.MarkFailedObjective(ProtectCivsObjective)
  end
end