
PlayerHasPower = false
HassanDead = false
Hassan2Dead = false
Hassan3Dead = false
HassanAwakened = false


ActorRemovals = {
  easy = {  },
  normal = { },
  hard = {  },
}


-- Hassan Attack Production Behavior -----

HassanAttackDelayMin = { easy = DateTime.Seconds(60), normal = DateTime.Seconds(45), hard = DateTime.Seconds(30) }
HassanAttackDelayMax = { easy = DateTime.Seconds(90), normal = DateTime.Seconds(60), hard = DateTime.Seconds(45) }

HassanAttackPaths = {
  { HassanAtkPath5A.Location, HassanAtkPath5B.Location, HassanAtkPath3.Location },
  { HassanAtkPath5A.Location, HassanAtkPath5B.Location, HassanAtkPath4.Location },
  { HassanAtkPath6A.Location, HassanAtkPath6B.Location, HassanAtkPath2.Location },
  { HassanAtkPath6A.Location, HassanAtkPath6B.Location, HassanAtkPath6C.Location, HassanAtkPath1.Location },
}

Hassan2AttackPaths = {
  { HassanAtkPath3.Location },
  { HassanAtkPath4.Location },
}

Hassan3AttackPaths = {
  { HassanAtkPath1.Location },
  { HassanAtkPath2.Location },
}

HassanAttackVehicleTypes = {
  easy = {
     { "bggy", "bggy", "bggy" },
     { "bike", "bike", "bike" },
     { "ltnk", "ltnk", "ltnk", "ltnk" },
     { "ltnk", "ltnk", "arty", "arty" },
     { "ftnk", "ftnk", "arty", "arty" },
     { "ltnk", "ltnk", "ftnk", "ftnk" },
  },
  normal = {
     { "bggy", "bggy", "bggy", "bggy", "bggy" },
     { "bike", "bike", "bike", "bike", "bike" },
     { "ltnk", "ltnk", "ltnk", "ltnk", "ltnk" },
     { "ltnk", "ltnk", "ltnk", "arty", "arty" },
     { "ftnk", "ftnk", "ftnk", "arty", "arty" },
     { "ltnk", "ltnk", "ftnk", "ftnk", "arty" },
  },
  hard = {
     { "bggy", "bggy", "bggy", "bggy", "bggy", "bggy" },
     { "bike", "bike", "bike", "bike", "bike", "bike" },
     { "ltnk", "ltnk", "ltnk", "ltnk", "ltnk", "ltnk" },
     { "ltnk", "ltnk", "ltnk", "ltnk", "arty", "arty" },
     { "ftnk", "ftnk", "ftnk", "ftnk", "arty", "arty" },
     { "ltnk", "ltnk", "ltnk", "ftnk", "ftnk", "ftnk" },
     { "ltnk", "ltnk", "ftnk", "ftnk", "arty", "arty" },
  }
}

HassanAttackInfantryTypes ={
  easy = {
     { "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1" },
     { "e4", "e4", "e4", "e4", "e4", "e4", "e4", "e4" },
     { "e3", "e3", "e3", "e3", "e3", "e3", "e3", "e3" },
     { "e1", "e1", "e1", "e1", "e3", "e3", "e3", "e3" },
     { "cyborg", "cyborg", "cyborg", "cyborg", "cyborg" },
  },
  normal = {
     { "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1" },
     { "e4", "e4", "e4", "e4", "e4", "e4", "e4", "e4", "e4", "e4" },
     { "e3", "e3", "e3", "e3", "e3", "e3", "e3", "e3", "e3", "e3" },
     { "e1", "e1", "e1", "e1", "e1", "e3", "e3", "e3", "e3", "e3" },
     { "cyborg", "cyborg", "cyborg", "cyborg", "cyborg", "cyborg", "cyborg", "cyborg" },
  },
  hard = {
     { "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1" },
     { "e4", "e4", "e4", "e4", "e4", "e4", "e4", "e4", "e4", "e4", "e4", "e4", "e4", "e4", "e4" },
     { "e3", "e3", "e3", "e3", "e3", "e3", "e3", "e3", "e3", "e3", "e3", "e3", "e3", "e3", "e3" },
     { "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e3", "e3", "e3", "e3", "e3", "e3", "e3" },
     { "cyborg", "cyborg", "cyborg", "cyborg", "cyborg", "cyborg", "cyborg", "cyborg", "cyborg", "cyborg" },
  }
}

AiInfantryAttackProduction = function(player, attackPaths)
  local production = Utils.Random(HassanAttackInfantryTypes[Difficulty])
  local path = Utils.Random(attackPaths)
  local toBuild = function() return production end
  local factory = GetAvailableFactory(player, 'hand')
  
  if factory ~= nil then
    ProduceUnits(player, factory, nil, toBuild, function(units)
      UpdatePlayerBaseLocation()
      Utils.Do(units, function(unit)
        ErrorGuardAttackPatrol(unit, path)
        AssaultPlayerBaseOrHunt(unit)
      end)
      Trigger.AfterDelay(Utils.RandomInteger(HassanAttackDelayMin[Difficulty], HassanAttackDelayMax[Difficulty]), function()
        AiInfantryAttackProduction(player, attackPaths)
      end)
    end)
  else
    Trigger.AfterDelay(Utils.RandomInteger(HassanAttackDelayMin[Difficulty], HassanAttackDelayMax[Difficulty]), function()
      AiInfantryAttackProduction(player, attackPaths)
    end)
  end
end

AiVehicleAttackProduction = function(player, attackPaths)
  local production = Utils.Random(HassanAttackVehicleTypes[Difficulty])
  local path = Utils.Random(attackPaths)
  local toBuild = function() return production end
  local factory = GetAvailableFactory(player, 'afld')
  
  if factory ~= nil then
    ProduceUnits(player, factory, nil, toBuild, function(units)
      UpdatePlayerBaseLocation()
      Utils.Do(units, function(unit)
        ErrorGuardAttackPatrol(unit, path)
        AssaultPlayerBaseOrHunt(unit)
      end)
      Trigger.AfterDelay(Utils.RandomInteger(HassanAttackDelayMin[Difficulty], HassanAttackDelayMax[Difficulty]), function()
        AiVehicleAttackProduction(player, attackPaths)
      end)
    end)
  else
    Trigger.AfterDelay(Utils.RandomInteger(HassanAttackDelayMin[Difficulty], HassanAttackDelayMax[Difficulty]), function()
      AiVehicleAttackProduction(player, attackPaths)
    end)
  end
end

-- End Hassan Attack Production Behavior -----


AwakenHassan = function()
  if HassanAwakened == true then return end
  HassanAwakened = true
  
  Trigger.AfterDelay(HassanAttackDelayMax[Difficulty], function()
    AiInfantryAttackProduction(Hassan2, Hassan2AttackPaths)
    AiVehicleAttackProduction(Hassan2, Hassan2AttackPaths)
  end)
  
  Trigger.AfterDelay(HassanAttackDelayMax[Difficulty] * 2, function()
    AiInfantryAttackProduction(Hassan3, Hassan3AttackPaths)
    AiVehicleAttackProduction(Hassan3, Hassan3AttackPaths)
  end)
  
  Trigger.AfterDelay(HassanAttackDelayMax[Difficulty] * 4, function()
    AiInfantryAttackProduction(Hassan, HassanAttackPaths)
    AiVehicleAttackProduction(Hassan, HassanAttackPaths)
  end)
end


WorldLoaded = function()
  Nod = Player.GetPlayer("Nod")
  Hassan = Player.GetPlayer("Hassan")
  Hassan2 = Player.GetPlayer("Hassan2")
  Hassan3 = Player.GetPlayer("Hassan3")
  HassanTV = Player.GetPlayer("HassanTV")
  Neutral = Player.GetPlayer("Neutral")
  
  MissionPlayer = Nod

	BadGuy = Player.GetPlayer("BadGuy")

	coopInfo =
	{
		Mainplayer = Nod,
		MainEnemies = {Hassan, Hassan2, Hassan3},
		Dummyplayer = BadGuy
	}
	
	ORAMod = "tibalt"
	CoopInit25(coopInfo)

  Camera.Position = StartCam.CenterPosition
  
  --Remove actors based on difficulty
  Utils.Do(ActorRemovals[Difficulty], function(unit)
    unit.Destroy()
  end)
  
  --Special lighting
  Lighting.Ambient = 0.7
  Lighting.Red = 1.25
  Lighting.Blue = 0.75
  Lighting.Green = 1.1
  
  --Player Reinforcements
  Trigger.AfterDelay(DateTime.Seconds(5), function()
	Utils.Do(MCVPlayers,function(PID)
		Reinforcements.Reinforce(PID, {'mcv'}, { NodSpawn1.Location }, 15, function(mcv)
			mcv.Move(NodMoveTo1.Location)
		end)
	end)
    Media.PlaySpeechNotification(All, "Reinforce")
  end)
  
  if Difficulty ~= 'hard' then
    Trigger.AfterDelay(DateTime.Seconds(10), function()
      Reinforcements.ReinforceWithTransport(Nod, "apc", {"e6", "e6", "e6"}, { NodSpawn1.Location }, null, function(transport, cargo)
        transport.Move(NodMoveTo1.Location)
      end)
      Media.PlaySpeechNotification(All, "Reinforce")
    end)
  end
  
  --Objectives
  InitObjectives(Nod)

  Trigger.AfterDelay(DateTime.Seconds(2), function()
    DestroyHassanObjective = Nod.AddObjective("Destroy all forces loyal to Hassan.")
    CaptureTVStationObjective = Nod.AddObjective("Capture the TV station.", "Secondary", false)
  end)
  
  Actor.Create("camera.small", true, { Owner = Nod, Location = Cam1.Location })
  
  Trigger.OnCapture(TVStation, function(self, captor, oldOwner, newOwner)
    if IsOwnedByCoopPlayer(captor) then
    
      if Hassan2Dead == true and Hassan3Dead == true then
        
        Media.DisplayMessage("Sorry, Commander. You've killed all Hassan's followers except his elite guard.", "Sierra", HSLColor.FromHex("FF0000"))
        Trigger.AfterDelay(DateTime.Seconds(5), function()
          Media.DisplayMessage("I don't think his personal guard will be receptive to switching sides.", "Sierra", HSLColor.FromHex("FF0000"))
        end)
        Trigger.AfterDelay(DateTime.Seconds(10), function()
          Media.DisplayMessage("It's a shame to lose so many brethren, but at least you've finished off most of the enemies.", "Sierra", HSLColor.FromHex("FF0000"))
          Nod.MarkCompletedObjective(CaptureTVStationObjective)
        end)
        
      else
      
        Media.DisplayMessage("Attention, all Nod forces. Hassan is deceiving you!", "Sierra", HSLColor.FromHex("FF0000"))
        Trigger.AfterDelay(DateTime.Seconds(5), function()
          Media.DisplayMessage("He is nothing but GDI's puppet. He takes his orders from General Solomon!", "Sierra", HSLColor.FromHex("FF0000"))
        end)
        Trigger.AfterDelay(DateTime.Seconds(10), function()
          Media.DisplayMessage("I'm transmitting our evidence of these claims right now.", "Sierra", HSLColor.FromHex("FF0000"))
        end)
        Trigger.AfterDelay(DateTime.Seconds(15), function()
          Media.DisplayMessage("Throw off your shackles of deceit and join us, the true followers of Kane!", "Sierra", HSLColor.FromHex("FF0000"))
        end)
        
        Trigger.AfterDelay(DateTime.Seconds(20), function()
          if Hassan2Dead == false then
            local units = Hassan2.GetActors()
			AssignToCoopPlayers(units, nil, true)
            --Utils.Do(units, function(unit) unit.Owner = newOwner end)
          elseif Hassan3Dead == false then
            local units = Hassan3.GetActors()
			AssignToCoopPlayers(units, nil, true)
            --Utils.Do(units, function(unit) unit.Owner = newOwner end)
          end
          Media.DisplayMessage("We have been touched by the spirit hand of Kane.\nPeace through power!", "Hassan's Forces", HSLColor.FromHex("0000FF"))
          Nod.MarkCompletedObjective(CaptureTVStationObjective)
        end)
        
      end
    end
  end)

  if Difficulty ~= 'easy' then
    Trigger.OnKilled(HassanPyramid, function(self, killer)
      KillHassanObjective = Nod.AddObjective("Destroy Hassan's helicopter before it escapes.")
      local tran = Actor.Create("tran", true, { Owner = Hassan, Location = HassanPyramid.Location })
      tran.Move(NodSpawn1.Location)
      tran.CallFunc(PlayerFailMission)

      Media.DisplayMessage("Hassan is trying to escape in that chopper! Shoot it down, quick!", "Sierra", HSLColor.FromHex("FF0000"))

      Trigger.OnKilled(tran, function(self, killer)
        FireSale(Hassan)
        FireSale(HassanTV)
        Nod.MarkCompletedObjective(KillHassanObjective)
      end)
    end)
  end
  
  --AI player behavior
  Hassan.Cash = 90000
  Hassan.Resources = Hassan.ResourceCapacity - 500
  SetupRefAndSilosCaptureCredits(Hassan)
  AutoReplaceHarvesters(Hassan)
  AutoRepairAndRebuildBuildings(Hassan, 15)
  
  Hassan2.Cash = 90000
  Hassan2.Resources = Hassan2.ResourceCapacity - 500
  SetupRefAndSilosCaptureCredits(Hassan2)
  AutoReplaceHarvesters(Hassan2)
  AutoRepairAndRebuildBuildings(Hassan2, 15)
  
  Hassan3.Cash = 90000
  Hassan3.Resources = Hassan3.ResourceCapacity - 500
  SetupRefAndSilosCaptureCredits(Hassan3)
  AutoReplaceHarvesters(Hassan3)
  AutoRepairAndRebuildBuildings(Hassan3, 15)
  
  --Enemy Predeployed Maneuvers
  
  --Proximity Triggers/Reveals
  Trigger.OnEnteredProximityTrigger(Proxy1.CenterPosition, WDist.New(8 * 1024), function(a, id)
    if IsOwnedByCoopPlayer(a) then
      Trigger.RemoveProximityTrigger(id)
      Media.DisplayMessage("Sound the alarm! The traitors' forces are here!", "Guards", HSLColor.FromHex("0000FF"))
      local introCam = Actor.Create("camera", true, { Owner = Nod, Location = Proxy1.Location })
      Trigger.AfterDelay(DateTime.Seconds(10), function() introCam.Destroy() end)
      if not Bggy1.IsDead then Bggy1.Move(BggyMoveTo1.Location) end
    end
  end)
  
  Trigger.OnEnteredProximityTrigger(Proxy2.CenterPosition, WDist.New(2 * 1024), function(a, id)
    if IsOwnedByCoopPlayer(a) then
      Trigger.RemoveProximityTrigger(id)
      local firstBaseCam = Actor.Create("camera", true, { Owner = Nod, Location = BggyMoveTo1.Location })
      Trigger.AfterDelay(DateTime.Seconds(10), function() firstBaseCam.Destroy() end)
      
      if not Hand1.IsDead then
        Reinforcements.Reinforce(Hassan3, {'cyborg', 'cyborg'}, { HandSpawn1.Location }, 15, function(unit)
          unit.Move(HandMoveTo1.Location)
          unit.Hunt()
        end)
      end
    end
  end)
  
  Trigger.OnEnteredProximityTrigger(AwakenHassan1.CenterPosition, WDist.New(3 * 1024), function(a, id)
    if IsOwnedByCoopPlayer(a) then
      Trigger.RemoveProximityTrigger(id)
      AwakenHassan()
    end
  end)
  
  Trigger.OnEnteredProximityTrigger(AwakenHassan2.CenterPosition, WDist.New(4 * 1024), function(a, id)
    if IsOwnedByCoopPlayer(a) then
      Trigger.RemoveProximityTrigger(id)
      AwakenHassan()
    end
  end)
  
  Trigger.OnEnteredProximityTrigger(AwakenHassan3.CenterPosition, WDist.New(2 * 1024), function(a, id)
    if IsOwnedByCoopPlayer(a) then
      Trigger.RemoveProximityTrigger(id)
      AwakenHassan()
    end
  end)
  
  Trigger.OnEnteredProximityTrigger(AwakenHassan4.CenterPosition, WDist.New(4 * 1024), function(a, id)
    if IsOwnedByCoopPlayer(a) then
      Trigger.RemoveProximityTrigger(id)
      AwakenHassan()
    end
  end)
  
  --Timer
  
  --Crate spawns
  Trigger.OnKilled(Truck1, function(self, killer)
    Actor.Create("moneycrate", true, { Owner = Nod, Location = Truck1.Location })
  end)
  
  --Taunts
  
  --Testing
end


Tick = function()
	OncePerSecondChecks()
	OncePerThreeSecondChecks()
end

OncePerSecondChecks = function()
  if DateTime.GameTime > 1 and DateTime.GameTime % 25 == 0 then
  
    if PlayerHasPower == false then
      local nukes = {}
	  Utils.Do(CoopPlayers,function(PID)
		Utils.Do(PID.GetActorsByType('nuke'),function(UID)
			table.insert(nukes,UID)
		end)
	  end)
      if #nukes > 0 then
        PlayerHasPower = true
        Reinforcements.ReinforceWithTransport(BadGuy, "tran.insertion", { "e5", "e5", "e3", "e3", "e3" }, { NodSpawn2.Location, NodMoveTo2.Location }, { NodSpawn2.Location })
        Reinforcements.ReinforceWithTransport(BadGuy, "tran.insertion", { "e5", "e5", "e3", "e3", "e3" }, { NodSpawn3.Location, NodMoveTo3.Location }, { NodSpawn3.Location })
      end
    end
    
  end
end

OncePerThreeSecondChecks = function()
	if DateTime.GameTime > 1 and DateTime.GameTime % 75 == 0 then
  
    --[[if HasOneOf(Nod, LossCheckAll) == false then
      PlayerFailMission()
    end]]
	TibAltCoopLossCheck()
    
    if HassanDead == false then
      if HasOneOf(Hassan, LossCheckAll) == false then HassanDead = true end
    end
    
    if Hassan2Dead == false then
      if HasOneOf(Hassan2, LossCheckCritical) == false then Hassan2Dead = true end
    end
    
    if Hassan3Dead == false then
      if HasOneOf(Hassan3, LossCheckCritical) == false then Hassan3Dead = true end
    end
    
    if HassanDead == true and Hassan2Dead == true and Hassan3Dead == true then
      if not Nod.IsObjectiveCompleted(DestroyHassanObjective) then
        Nod.MarkCompletedObjective(DestroyHassanObjective)
      end
    end
    
    if HassanAwakened == false then
      local checks = {}
	  Utils.Do(CoopPlayers,function(PID)
		Utils.Do(PID.GetActorsByTypes({'fact', 'hand', 'afld'}),function(UID)
			table.insert(checks,UID)
		end)
	  end)
      if #checks > 0 then AwakenHassan() end
    end

    --manipulate AI funds
    ManipulatePlayerFunds(Hassan)
    ManipulatePlayerFunds(Hassan2)
    ManipulatePlayerFunds(Hassan3)
    
    --ControlAircraft(Cabal)
	end
end


PlayerFailMission = function()
  if DestroyHassanObjective ~= nil and not Nod.IsObjectiveCompleted(DestroyHassanObjective) then
    Nod.MarkFailedObjective(DestroyHassanObjective)
  end
  if CaptureTVStationObjective ~= nil and not Nod.IsObjectiveCompleted(CaptureTVStationObjective) then
    Nod.MarkFailedObjective(CaptureTVStationObjective)
  end
  if KillHassanObjective ~= nil and not Nod.IsObjectiveCompleted(KillHassanObjective) then
    Nod.MarkFailedObjective(KillHassanObjective)
  end
end