
VegaAwakened = false
Vega2Awakened = false


ActorRemovals = {
  easy = {  },
  normal = { NormalRmv1 },
  hard = { NormalRmv1, HardRmv1 },
}


-- Vega Attack Production Behavior -----

VegaAttackDelayMin = { easy = DateTime.Seconds(60), normal = DateTime.Seconds(45), hard = DateTime.Seconds(30) }
VegaAttackDelayMax = { easy = DateTime.Seconds(90), normal = DateTime.Seconds(60), hard = DateTime.Seconds(45) }

VegaAirAttackDelayMin = { easy = DateTime.Seconds(300), normal = DateTime.Seconds(270), hard = DateTime.Seconds(240) }
VegaAirAttackDelayMax = { easy = DateTime.Seconds(360), normal = DateTime.Seconds(300), hard = DateTime.Seconds(270) }

VegaAttackPaths = {
  { VegaAtkPath1.Location, VegaAtkPath2.Location },
}

Vega2AttackPaths = {
  { Vega2AtkPath.Location },
}

Vega3AttackPaths = {
  { VegaAtkPath2.Location },
}

VegaAttackVehicleTypes = {
  easy = {
     { "bggy", "bggy", "bggy", "bggy" },
     { "bike", "bike", "bike", "bike" },
     { "arty", "arty" },
     { "ltnk", "ltnk", "ltnk", "arty" },
     { "ftnk", "ftnk", "ftnk" },
  },
  normal = {
     { "bggy", "bggy", "bggy", "bggy", "bggy", "bggy" },
     { "bike", "bike", "bike", "bike", "bike", "bike" },
     { "arty", "arty", "arty", "arty" },
     { "ltnk", "ltnk", "ltnk", "arty", "arty" },
     { "ftnk", "ftnk", "ftnk", "ftnk" },
  },
  hard = {
     { "bggy", "bggy", "bggy", "bggy", "bggy", "bggy", "bggy", "bggy" },
     { "bike", "bike", "bike", "bike", "bike", "bike", "bike", "bike" },
     { "arty", "arty", "arty", "arty", "arty", "arty" },
     { "ltnk", "ltnk", "ltnk", "ltnk", "arty", "arty" },
     { "ftnk", "ftnk", "ftnk", "ftnk", "ftnk", "ftnk" },
  }
}

VegaAttackInfantryTypes ={
  easy = {
     { "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1" },
     { "e4", "e4", "e4", "e4", "e4", "e4", "e4", "e4" },
     { "e3", "e3", "e3", "e3", "e3", "e3", "e3", "e3" },
     { "e1", "e1", "e1", "e1", "e3", "e3", "e3", "e3" },
     { "cyborg", "cyborg", "cyborg", "cyborg", "cyborg" },
  },
  normal = {
     { "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1" },
     { "e4", "e4", "e4", "e4", "e4", "e4", "e4", "e4", "e4", "e4" },
     { "e3", "e3", "e3", "e3", "e3", "e3", "e3", "e3", "e3", "e3" },
     { "e1", "e1", "e1", "e1", "e1", "e3", "e3", "e3", "e3", "e3" },
     { "cyborg", "cyborg", "cyborg", "cyborg", "cyborg", "cyborg", "cyborg", "cyborg" },
  },
  hard = {
     { "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1" },
     { "e4", "e4", "e4", "e4", "e4", "e4", "e4", "e4", "e4", "e4", "e4", "e4", "e4", "e4", "e4" },
     { "e3", "e3", "e3", "e3", "e3", "e3", "e3", "e3", "e3", "e3", "e3", "e3", "e3", "e3", "e3" },
     { "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e3", "e3", "e3", "e3", "e3", "e3", "e3" },
     { "cyborg", "cyborg", "cyborg", "cyborg", "cyborg", "cyborg", "cyborg", "cyborg", "cyborg", "cyborg" },
  }
}

Vega2AttackInfantryTypes ={
  easy = {
     { "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1" },
     { "e3", "e3", "e3", "e3", "e3", "e3", "e3", "e3" },
     { "e1", "e1", "e1", "e1", "e3", "e3", "e3", "e3" },
  },
  normal = {
     { "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1" },
     { "e3", "e3", "e3", "e3", "e3", "e3", "e3", "e3", "e3", "e3" },
     { "e1", "e1", "e1", "e1", "e1", "e3", "e3", "e3", "e3", "e3" },
  },
  hard = {
     { "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1" },
     { "e3", "e3", "e3", "e3", "e3", "e3", "e3", "e3", "e3", "e3", "e3", "e3", "e3", "e3", "e3" },
     { "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e3", "e3", "e3", "e3", "e3", "e3", "e3" },
  }
}

VegaAttackAirTypes = {
  easy = {
     { "heli", },
  },
  normal = {
     { "heli" },
  },
  hard = {
     { "heli" },
  }
}

AiInfantryAttackProduction = function(player, attackPaths)
  local production = Utils.Random(VegaAttackInfantryTypes[Difficulty])
  local path = Utils.Random(attackPaths)
  local toBuild = function() return production end
  local factory = GetAvailableFactory(player, 'hand')
  
  if factory ~= nil then
    ProduceUnits(player, factory, nil, toBuild, function(units)
      UpdatePlayerBaseLocation()
      Utils.Do(units, function(unit)
        ErrorGuardAttackPatrol(unit, path)
        AssaultPlayerBaseOrHunt(unit)
      end)
      Trigger.AfterDelay(Utils.RandomInteger(VegaAttackDelayMin[Difficulty], VegaAttackDelayMax[Difficulty]), function()
        AiInfantryAttackProduction(player, attackPaths)
      end)
    end)
  else
    Trigger.AfterDelay(Utils.RandomInteger(VegaAttackDelayMin[Difficulty], VegaAttackDelayMax[Difficulty]), function()
      AiInfantryAttackProduction(player, attackPaths)
    end)
  end
end

AiVehicleAttackProduction = function(player, attackPaths)
  local production = Utils.Random(VegaAttackVehicleTypes[Difficulty])
  local path = Utils.Random(attackPaths)
  local toBuild = function() return production end
  local factory = GetAvailableFactory(player, 'afld')
  
  if factory ~= nil then
    ProduceUnits(player, factory, nil, toBuild, function(units)
      UpdatePlayerBaseLocation()
      Utils.Do(units, function(unit)
        ErrorGuardAttackPatrol(unit, path)
        AssaultPlayerBaseOrHunt(unit)
      end)
      Trigger.AfterDelay(Utils.RandomInteger(VegaAttackDelayMin[Difficulty], VegaAttackDelayMax[Difficulty]), function()
        AiVehicleAttackProduction(player, attackPaths)
      end)
    end)
  else
    Trigger.AfterDelay(Utils.RandomInteger(VegaAttackDelayMin[Difficulty], VegaAttackDelayMax[Difficulty]), function()
      AiVehicleAttackProduction(player, attackPaths)
    end)
  end
end


Vega2InfantryAttackProduction = function(player, attackPaths)
  local production = Utils.Random(Vega2AttackInfantryTypes[Difficulty])
  local path = Utils.Random(attackPaths)
  local toBuild = function() return production end
  local factory = GetAvailableFactory(player, 'hand')
  
  if factory ~= nil then
    ProduceUnits(player, factory, nil, toBuild, function(units)
      UpdatePlayerBaseLocation()
      Utils.Do(units, function(unit)
        ErrorGuardAttackPatrol(unit, path)
        AssaultPlayerBaseOrHunt(unit)
      end)
      Trigger.AfterDelay(VegaAttackDelayMax[Difficulty] * 3, function()
        Vega2InfantryAttackProduction(player, attackPaths)
      end)
    end)
  else
    Trigger.AfterDelay(VegaAttackDelayMax[Difficulty] * 3, function()
      Vega2InfantryAttackProduction(player, attackPaths)
    end)
  end
end


VegaAirAttackProduction = function()
  local production = Utils.Random(VegaAttackAirTypes[Difficulty])
  local factories = Vega.GetActorsByType('hpad')
  local vegaAirMax = 6
  
  if #factories > 0 then
    Utils.Do(factories, function(factory)
      local vegaHelis = Vega.GetActorsByType('heli')
      if #vegaHelis < vegaAirMax then
        Reinforcements.Reinforce(Vega, production, { factory.Location }, 30, function(unit)
          --
        end)
      end
    end)
  end

  Trigger.AfterDelay(Utils.RandomInteger(VegaAirAttackDelayMin[Difficulty], VegaAirAttackDelayMax[Difficulty]), VegaAirAttackProduction)
end

-- End Vega Attack Production Behavior -----


AwakenVega = function()
  if VegaAwakened == true then return end
  VegaAwakened = true
  
  Trigger.AfterDelay(VegaAttackDelayMax[Difficulty], function()
    AiInfantryAttackProduction(Vega3, Vega3AttackPaths)
    AiVehicleAttackProduction(Vega3, Vega3AttackPaths)
  end)
  
  Trigger.AfterDelay(VegaAttackDelayMax[Difficulty] * 3, function()
    AiInfantryAttackProduction(Vega, VegaAttackPaths)
    AiVehicleAttackProduction(Vega, VegaAttackPaths)
  end)
  
  Trigger.AfterDelay(VegaAirAttackDelayMax[Difficulty] * 2, function() VegaAirAttackProduction() end)
end


AwakenVega2 = function()
  if Vega2Awakened == true then return end
  Vega2Awakened = true
  
  Trigger.AfterDelay(VegaAttackDelayMax[Difficulty], function()
    Vega2InfantryAttackProduction(Vega2, Vega2AttackPaths)
  end)
end


WorldLoaded = function()
  Nod = Player.GetPlayer("Nod")
  Vega = Player.GetPlayer("Vega")
  Vega2 = Player.GetPlayer("Vega2")
  Vega3 = Player.GetPlayer("Vega3")
  Neutral = Player.GetPlayer("Neutral")
  
  MissionPlayer = Nod
  
	BadGuy = Player.GetPlayer("BadGuy")

	coopInfo =
	{
		Mainplayer = Nod,
		MainEnemies = {Vega, Vega2, Vega3},
		Dummyplayer = BadGuy
	}
	
	ORAMod = "tibalt"
	CoopInit25(coopInfo)

  Camera.Position = StartCam.CenterPosition
  
  --Remove actors based on difficulty
  if #CoopPlayers == 1 then
	Utils.Do(ActorRemovals[Difficulty], function(unit)
		unit.Destroy()
	end)
  else
	local CoopRemoval = { NormalRmv1, HardRmv1 }
	Utils.Do(CoopRemoval,function(UID)
		UID.Destroy()
	end)
	Utils.Do(CoopPlayers,function(PID)
		if PID ~= CoopPlayers[1] then
			local ExtraTank = Actor.Create(Actor515.Type, true, { Owner = PID, Location = Actor515.Location })
			ExtraTank.Scatter()
		end
	end)
  end
  
  --Special lighting
  Lighting.Ambient = 0.6
  Lighting.Red = 0.8
  Lighting.Blue = 1.0
  Lighting.Green = 0.85
  
  --Player Reinforcements
  Trigger.OnKilled(SAM1, function(self, killer)
    local flare = Actor.Create("flare", true, { Owner = BadGuy, Location = Flare1.Location })
    Trigger.AfterDelay(DateTime.Seconds(60), function() flare.Destroy() end)
    
    Media.PlaySpeechNotification(All, "Reinforce")
    
    Reinforcements.ReinforceWithTransport(
      BadGuy,
      "tran.insertion",
      { "e6" },
      { TranSpawn1.Location, Cam4.Location },
      { TranSpawn1.Location },
      null,
      function(transport, cargo)
        Trigger.AfterDelay(DateTime.Seconds(1), function()
          Reinforcements.Reinforce(BadGuy, { "arty", "arty" }, { ArtySpawn1.Location }, 5, function(unit)
            unit.Move(ArtyMoveTo1.Location)
          end)
          if not transport.IsDead then
            transport.Move(TranSpawn1.Location)
            transport.Destroy()
          end
        end)
      end
    )
  end)
  
  Trigger.OnAllKilled({SAM2, SAM3, SAM4}, function()
    local camera6 = Actor.Create("camera", true, { Owner = Nod, Location = Cam6.Location })
    Trigger.AfterDelay(DateTime.Seconds(10), function() camera6.Destroy() end)
    
    local flare2 = Actor.Create("flare", true, { Owner = BadGuy, Location = Flare2.Location })
    Trigger.AfterDelay(DateTime.Seconds(60), function() flare2.Destroy() end)
    
    Media.PlaySpeechNotification(All, "Reinforce")
    
    Reinforcements.ReinforceWithTransport(BadGuy, "tran.insertion", { "e6", "e6", "e6" }, { TranSpawn2.Location, Cam6.Location }, { TranSpawn2.Location })
  end)
  
  Trigger.OnAllKilled( {Nuk21, Nuk22, Nuk23, Nuk24, Nuk25, Nuk26}, function()
    Nod.MarkCompletedObjective(DestroyPowerObjective)
    Media.PlaySpeechNotification(All, "Reinforce")
    
    local camera9 = Actor.Create("camera", true, { Owner = Nod, Location = Cam9.Location })
    Trigger.AfterDelay(DateTime.Seconds(10), function() camera9.Destroy() end)
    
	Utils.Do(MCVPlayers,function(PID)
		Reinforcements.Reinforce(PID, { "mcv" }, { NodRnfSpawn1.Location }, 15, function(unit)
			unit.Move(NodRnfMoveTo1.Location)
		end)
	end)
    
    if Difficulty == 'easy' then
      Reinforcements.Reinforce(BadGuy, { "ltnk", "bike", "bike", "e1", "e1", "e1", "e1", "e1" }, { NodRnfSpawn2.Location }, 15, function(unit)
        unit.Move(NodRnfMoveTo2.Location)
      end)
      Reinforcements.Reinforce(BadGuy, { "ltnk", "bike", "bike", "e1", "e1", "e1", "e1", "e1" }, { NodRnfSpawn3.Location }, 15, function(unit)
        unit.Move(NodRnfMoveTo3.Location)
      end)
    elseif Difficulty == 'normal' then
      Reinforcements.Reinforce(BadGuy, { "ltnk", "e1", "e1", "e1", "e1", "e1" }, { NodRnfSpawn2.Location }, 15, function(unit)
        unit.Move(NodRnfMoveTo2.Location)
      end)
      Reinforcements.Reinforce(BadGuy, { "ltnk", "e1", "e1", "e1", "e1", "e1" }, { NodRnfSpawn3.Location }, 15, function(unit)
        unit.Move(NodRnfMoveTo3.Location)
      end)
    elseif Difficulty == 'hard' then
      Reinforcements.Reinforce(BadGuy, { "e1", "e1", "e1", "e1", "e1" }, { NodRnfSpawn2.Location }, 15, function(unit)
        unit.Move(NodRnfMoveTo2.Location)
      end)
      Reinforcements.Reinforce(BadGuy, { "e1", "e1", "e1", "e1", "e1" }, { NodRnfSpawn3.Location }, 15, function(unit)
        unit.Move(NodRnfMoveTo3.Location)
      end)
    end
    
    Trigger.AfterDelay(DateTime.Seconds(3), function() Media.PlaySound("Eva-ReinforcementsNorth.aud") end)
  end)
  
  Trigger.OnAllKilled({SAM5, SAM6, SAM7, SAM8}, function()
    Media.PlaySpeechNotification(All, "Reinforce")
    
    Reinforcements.ReinforceWithTransport(BadGuy, "tran.insertion", { "e5", "e5", "e5", "e5", "e5" }, { TranSpawn3.Location, TranMoveTo3.Location }, { TranSpawn3.Location })
    Reinforcements.ReinforceWithTransport(BadGuy, "tran.insertion", { "e5", "e5", "e5", "e5", "e5" }, { TranSpawn4.Location, TranMoveTo4.Location }, { TranSpawn4.Location })
  end)
  
  --Objectives
  InitObjectives(Nod)

  Trigger.AfterDelay(DateTime.Seconds(2), function()
    DestroyVegaObjective = Nod.AddObjective("Destroy Vega's main base.")
    DestroyPowerObjective = Nod.AddObjective("Destroy northwestern power farm.", "Secondary", false)
  end)

  --AI player behavior
  Vega.Cash = 90000
  Vega.Resources = Vega.ResourceCapacity - 500
  SetupRefAndSilosCaptureCredits(Vega)
  AutoReplaceHarvesters(Vega)
  AutoRepairAndRebuildBuildings(Vega, 15)
  
  Vega2.Cash = 90000
  Vega2.Resources = Vega2.ResourceCapacity - 500
  SetupRefAndSilosCaptureCredits(Vega2)
  
  Vega3.Cash = 90000
  Vega3.Resources = Vega3.ResourceCapacity - 500
  SetupRefAndSilosCaptureCredits(Vega3)
  
  if Difficulty ~= 'easy' then
    Trigger.OnCapture(Hand1, function(self, captor, oldOwner, newOwner)
      if IsOwnedByCoopPlayer(captor) then AwakenVega2() end
    end)
    
    Trigger.OnKilled(Hand1, function(self, killer) AwakenVega2() end)
  end
  
  Trigger.OnEnteredProximityTrigger(Prox8.CenterPosition, WDist.New(6 * 1024), function(a, id)
    if IsOwnedByCoopPlayer(a) and a.Type ~= 'camera' then
      Trigger.RemoveProximityTrigger(id)
      AwakenVega()
    end
  end)
  
  --Enemy Predeployed Maneuvers
  Utils.Do({Patroller1A, Patroller1B, Patroller1C, Patroller1D, Patroller1E}, function(unit)
    unit.Patrol({Patrol1A.Location, Patrol1B.Location, Patrol1C.Location, Patrol1D.Location}, true, DateTime.Seconds(5))
  end)
  
  Utils.Do({Patroller2A, Patroller2B, Patroller2C, Patroller2D, Patroller2E}, function(unit)
    unit.Patrol({Patrol1C.Location, Patrol1D.Location, Patrol1A.Location, Patrol1B.Location}, true, DateTime.Seconds(5))
  end)
  
  Utils.Do({Patroller3A, Patroller3B, Patroller3C}, function(unit)
    unit.Patrol({Patrol1A.Location, Patrol1D.Location, Patrol1C.Location, Patrol1B.Location}, true, DateTime.Seconds(5))
  end)
  
  Trigger.AfterDelay(DateTime.Seconds(3), function()
    local camera = Actor.Create("camera", true, { Owner = Nod, Location = Cam1.Location })
    Trigger.AfterDelay(DateTime.Seconds(10), function() camera.Destroy() end)
    
    Utils.Do({Bggy1, Bggy2}, function(unit)
      if not unit.IsDead then unit.Hunt() end
    end)
    
    Utils.Do({Baz1, Baz2, Baz3}, function(unit)
      if not unit.IsDead then unit.Move(Prox4.Location) end
    end)
  end)
  
  Trigger.OnEnteredProximityTrigger(Prox4.CenterPosition, WDist.New(8 * 1024), function(a, id)
    if IsOwnedByCoopPlayer(a) and a.Type ~= 'camera' then
      Trigger.RemoveProximityTrigger(id)
      local camera4 = Actor.Create("camera", true, { Owner = Nod, Location = Cam4.Location })
      Trigger.AfterDelay(DateTime.Seconds(10), function() camera4.Destroy() end)
      
      Utils.Do({Baz1, Baz2, Baz3, Baz4, Baz5, Baz6}, function(unit)
        if not unit.IsDead then unit.Hunt() end
      end)
      
      if not Hand2.IsDead then
        Trigger.AfterDelay(DateTime.Seconds(3), function()
          Reinforcements.Reinforce(Vega2, { "cyborg", "cyborg", "cyborg" }, { CybSpawn1.Location }, 10, function(unit)
            unit.Move(CybMoveTo1.Location)
            unit.Hunt()
          end)
        end)
      end
    end
  end)
  
  Trigger.OnEnteredProximityTrigger(Prox5.CenterPosition, WDist.New(8 * 1024), function(a, id)
    if IsOwnedByCoopPlayer(a) and a.Type ~= 'camera' then
      Trigger.RemoveProximityTrigger(id)
      local camera5a = Actor.Create("camera", true, { Owner = Nod, Location = Cam5A.Location })
      Trigger.AfterDelay(DateTime.Seconds(10), function() camera5a.Destroy() end)
      local camera5b = Actor.Create("camera", true, { Owner = Nod, Location = Cam5B.Location })
      Trigger.AfterDelay(DateTime.Seconds(10), function() camera5b.Destroy() end)

      Reinforcements.Reinforce(Vega2, { "e3", "e3", "e3" }, { BazSpawn1.Location }, 5, function(unit)
        unit.Move(BazMoveTo1.Location)
        unit.Hunt()
      end)
    end
  end)
  
  Trigger.OnEnteredProximityTrigger(Prox9.CenterPosition, WDist.New(2 * 1024), function(a, id)
    if IsOwnedByCoopPlayer(a) and a.Type ~= 'camera' then
      Trigger.RemoveProximityTrigger(id)
      local camera10 = Actor.Create("camera", true, { Owner = Nod, Location = Cam10.Location })
      Trigger.AfterDelay(DateTime.Seconds(10), function() camera10.Destroy() end)

      Reinforcements.Reinforce(Vega2, { "cyborg", "cyborg", "cyborg" }, { CybSpawn2.Location }, 5, function(unit)
        unit.Move(Cam10.Location)
        unit.Hunt()
      end)
    end
  end)
  
  --Proximity Triggers/Reveals
  Trigger.OnEnteredProximityTrigger(Prox1.CenterPosition, WDist.New(2 * 1024), function(a, id)
    if IsOwnedByCoopPlayer(a) and a.Type ~= 'camera' then
      Trigger.RemoveProximityTrigger(id)
      local camera2 = Actor.Create("camera", true, { Owner = Nod, Location = Cam2.Location })
      Trigger.AfterDelay(DateTime.Seconds(10), function() camera2.Destroy() end)
    end
  end)
  
  Trigger.OnEnteredProximityTrigger(Prox2.CenterPosition, WDist.New(3 * 1024), function(a, id)
    if IsOwnedByCoopPlayer(a) and a.Type ~= 'camera' then
      Trigger.RemoveProximityTrigger(id)
      local camera2b = Actor.Create("camera", true, { Owner = Nod, Location = Cam2.Location })
      Trigger.AfterDelay(DateTime.Seconds(10), function() camera2b.Destroy() end)
    end
  end)
  
  Trigger.OnEnteredProximityTrigger(Prox3A.CenterPosition, WDist.New(3 * 1024), function(a, id)
    if IsOwnedByCoopPlayer(a) and a.Type ~= 'camera' then
      Trigger.RemoveProximityTrigger(id)
      local camera3 = Actor.Create("camera", true, { Owner = Nod, Location = Cam3.Location })
      Trigger.AfterDelay(DateTime.Seconds(10), function() camera3.Destroy() end)
    end
  end)
  
  Trigger.OnEnteredProximityTrigger(Prox3B.CenterPosition, WDist.New(3 * 1024), function(a, id)
    if IsOwnedByCoopPlayer(a) and a.Type ~= 'camera' then
      Trigger.RemoveProximityTrigger(id)
      local camera3b = Actor.Create("camera", true, { Owner = Nod, Location = Cam3.Location })
      Trigger.AfterDelay(DateTime.Seconds(10), function() camera3b.Destroy() end)
    end
  end)
  
  Trigger.OnEnteredProximityTrigger(Prox6.CenterPosition, WDist.New(2 * 1024), function(a, id)
    if IsOwnedByCoopPlayer(a) and a.Type ~= 'camera' then
      Trigger.RemoveProximityTrigger(id)
      local camera7 = Actor.Create("camera", true, { Owner = Nod, Location = Cam7.Location })
      Trigger.AfterDelay(DateTime.Seconds(10), function() camera7.Destroy() end)
    end
  end)
  
  Trigger.OnEnteredProximityTrigger(Prox7.CenterPosition, WDist.New(4 * 1024), function(a, id)
    if IsOwnedByCoopPlayer(a) and a.Type ~= 'camera' then
      Trigger.RemoveProximityTrigger(id)
      local camera8a = Actor.Create("camera", true, { Owner = Nod, Location = Cam8A.Location })
      Trigger.AfterDelay(DateTime.Seconds(10), function() camera8a.Destroy() end)
      local camera8b = Actor.Create("camera", true, { Owner = Nod, Location = Cam8B.Location })
      Trigger.AfterDelay(DateTime.Seconds(10), function() camera8b.Destroy() end)
    end
  end)
  
  Trigger.OnEnteredProximityTrigger(Prox11.CenterPosition, WDist.New(4 * 1024), function(a, id)
    if IsOwnedByCoopPlayer(a) and a.Type ~= 'camera' then
      Trigger.RemoveProximityTrigger(id)
      local camera11 = Actor.Create("camera", true, { Owner = Nod, Location = Cam11.Location })
      Trigger.AfterDelay(DateTime.Seconds(10), function() camera11.Destroy() end)
    end
  end)
  
  --Timer
  
  --Crate spawns
  Trigger.OnKilled(Truck1, function(self, killer)
    Actor.Create("moneycrate", true, { Owner = Nod, Location = Truck1.Location })
  end)
  Trigger.OnKilled(Truck2, function(self, killer)
    Actor.Create("moneycrate", true, { Owner = Nod, Location = Truck2.Location })
  end)
  Trigger.OnKilled(Truck3, function(self, killer)
    Actor.Create("moneycrate", true, { Owner = Nod, Location = Truck3.Location })
  end)
  
  --Taunts
  
  --Testing
end


Tick = function()
	AssignToCoopPlayers(BadGuy.GetActorsByType("e6"), nil, true)
	OncePerSecondChecks()
	OncePerThreeSecondChecks()
end

OncePerSecondChecks = function()
  if DateTime.GameTime > 1 and DateTime.GameTime % 25 == 0 then
  
    if VegaAwakened == false then
      facts = {}
	  Utils.Do(CoopPlayers,function(PID)
		Utils.Do(PID.GetActorsByType('fact'),function(UID)
			table.insert(facts,UID)
		end)
	  end)
      if #facts > 0 then AwakenVega() end
    end
    
  end
end

OncePerThreeSecondChecks = function()
	if DateTime.GameTime > 1 and DateTime.GameTime % 75 == 0 then
  
    --[[if HasOneOf(Nod, LossCheckAll) == false then
      PlayerFailMission()
    end]]
	TibAltCoopLossCheck()
    
    if HasOneOf(Vega, LossCheckCritical) == false then
      Nod.MarkCompletedObjective(DestroyVegaObjective)
    end
    
    --manipulate AI funds
    ManipulatePlayerFunds(Vega)
    ManipulatePlayerFunds(Vega2)
    
    ControlAircraft(Vega)
	end
end


PlayerFailMission = function()
  if DestroyVegaObjective ~= nil and not Nod.IsObjectiveCompleted(DestroyVegaObjective) then
    Nod.MarkFailedObjective(DestroyVegaObjective)
  end
  if DestroyPowerObjective ~= nil and not Nod.IsObjectiveCompleted(DestroyPowerObjective) then
    Nod.MarkFailedObjective(DestroyPowerObjective)
  end
end