
PlayerCanLose = false
SlavikAwakened = false


ActorRemovals = {
  easy = { },
  normal = { },
  hard = { Truck2, Truck3 },
}


-- Slavik Attack Production Behavior -----

SlavikAttackDelayMin = { easy = DateTime.Seconds(150), normal = DateTime.Seconds(120), hard = DateTime.Seconds(90) }
SlavikAttackDelayMax = { easy = DateTime.Seconds(180), normal = DateTime.Seconds(130), hard = DateTime.Seconds(100) }

SlavikAttackVehicleTypes = {
  easy = {
     { "bggy", "bggy" },
     { "bike", "bike" },
     { "ltnk" },
     { "ftnk" },
  },
  normal = {
     { "bggy", "bggy" },
     { "bike", "bike" },
     { "ltnk", "ltnk" },
     { "ftnk", "ftnk" },
  },
  hard = {
     { "bggy", "bggy", "bggy" },
     { "bike", "bike", "bike" },
     { "ltnk", "ltnk" },
     { "ftnk", "ftnk" },
  }
}

SlavikAttackInfantryTypes ={
  easy = {
     { "e1", "e1", "e1" },
     { "e3", "e3" },
  },
  normal = {
     { "e1", "e1", "e1", "e1" },
     { "e3", "e3", "e3" },
  },
  hard = {
     { "e1", "e1", "e1", "e1", "e1" },
     { "e3", "e3", "e3" },
  }
}

AiInfantryAttackProduction = function(player)
  local production = Utils.Random(SlavikAttackInfantryTypes[Difficulty])
  local toBuild = function() return production end
  local factory = GetAvailableFactory(player, 'hand')
  
  if factory ~= nil then
    ProduceUnits(player, factory, nil, toBuild, function(units)
      UpdatePlayerBaseLocation()
      Utils.Do(units, function(unit)
        AssaultPlayerBaseOrHunt(unit)
      end)
      Trigger.AfterDelay(Utils.RandomInteger(SlavikAttackDelayMin[Difficulty], SlavikAttackDelayMax[Difficulty]), function()
        AiInfantryAttackProduction(player, attackPaths)
      end)
    end)
  else
    Trigger.AfterDelay(Utils.RandomInteger(SlavikAttackDelayMin[Difficulty], SlavikAttackDelayMax[Difficulty]), function()
      AiInfantryAttackProduction(player, attackPaths)
    end)
  end
end

AiVehicleAttackProduction = function(player)
  local production = Utils.Random(SlavikAttackVehicleTypes[Difficulty])
  local toBuild = function() return production end
  local factory = GetAvailableFactory(player, 'afld')
  
  if factory ~= nil then
    ProduceUnits(player, factory, nil, toBuild, function(units)
      UpdatePlayerBaseLocation()
      Utils.Do(units, function(unit)
        AssaultPlayerBaseOrHunt(unit)
      end)
      Trigger.AfterDelay(Utils.RandomInteger(SlavikAttackDelayMin[Difficulty], SlavikAttackDelayMax[Difficulty]), function()
        AiVehicleAttackProduction(player, attackPaths)
      end)
    end)
  else
    Trigger.AfterDelay(Utils.RandomInteger(SlavikAttackDelayMin[Difficulty], SlavikAttackDelayMax[Difficulty]), function()
      AiVehicleAttackProduction(player, attackPaths)
    end)
  end
end

-- End Slavik Attack Production Behavior -----


AwakenSlavik = function()
  Trigger.AfterDelay(SlavikAttackDelayMin[Difficulty], function()
    AiInfantryAttackProduction(Slavik2)
    AiVehicleAttackProduction(Slavik2)
    AiInfantryAttackProduction(Slavik3)
    AiVehicleAttackProduction(Slavik3)
    AiInfantryAttackProduction(Slavik4)
    AiVehicleAttackProduction(Slavik4)
  end)
end


SlavikFlees = function()
  local slavikCam = Actor.Create("camera", true, { Owner = Nod, Location = SlavikMove1E.Location })
  Trigger.AfterDelay(DateTime.Seconds(30), function()
    slavikCam.Destroy()
  end)
  Media.DisplayMessage("There's Slavik! He's making a run for it!", "Sierra", HSLColor.FromHex("FF0000"))

  local escapePath = { SlavikMove2A, SlavikMove2B, SlavikMoveFinal }
  
  local bridge = Utils.Where(Map.ActorsInWorld, function(actor) return actor.Type == "bridge2" end)[1]
  if bridge.IsDead then
    escapePath = { SlavikMove2A, SlavikMove3A, SlavikMove3B, SlavikMove3C, SlavikMoveFinal }
  end
  
  local bikes = Slavik5.GetActorsByType("bike")
  local bggys = Slavik5.GetActorsByType("bggy")
  local ltnks = Slavik5.GetActorsByType("ltnk")
  local ftnks = Slavik5.GetActorsByType("ftnk")

  Utils.Do(bikes, function(unit)
    if not unit.IsDead then
      Utils.Do(escapePath, function(waypoint) unit.AttackMove(waypoint.Location) end)
    end
  end)

  Trigger.AfterDelay(DateTime.Seconds(4), function()
    Utils.Do(ltnks, function(unit)
      if not unit.IsDead then
        Utils.Do(escapePath, function(waypoint) unit.AttackMove(waypoint.Location) end)
      end
    end)
  end)
  
  Trigger.AfterDelay(DateTime.Seconds(8), function()
    if not SlavikMHQ.IsDead then
      Utils.Do(escapePath, function(waypoint) SlavikMHQ.Move(waypoint.Location) end)
    end
  end)
  
  Trigger.AfterDelay(DateTime.Seconds(16), function()
    Utils.Do(ftnks, function(unit)
      if not unit.IsDead then
        Utils.Do(escapePath, function(waypoint) unit.AttackMove(waypoint.Location) end)
      end
    end)
  end)
  
  Trigger.AfterDelay(DateTime.Seconds(24), function()
    Utils.Do(bggys, function(unit)
      if not unit.IsDead then
        Utils.Do(escapePath, function(waypoint) unit.AttackMove(waypoint.Location) end)
      end
    end)
  end)
end


WorldLoaded = function()
  Nod = Player.GetPlayer("Nod")
  FakeNod = Player.GetPlayer("FakeNod")
  Slavik1 = Player.GetPlayer("Slavik1")
  Slavik2 = Player.GetPlayer("Slavik2")
  Slavik3 = Player.GetPlayer("Slavik3")
  Slavik4 = Player.GetPlayer("Slavik4")
  Slavik5 = Player.GetPlayer("Slavik5")
  Neutral = Player.GetPlayer("Neutral")
  
  MissionPlayer = Nod

	BadGuy = Player.GetPlayer("BadGuy")

	coopInfo =
	{
		Mainplayer = Nod,
		MainEnemies = {Slavik1, Slavik2, Slavik3, Slavik4, Slavik5},
		Dummyplayer = BadGuy
	}
	
	ORAMod = "tibalt"
	CoopInit25(coopInfo)

  Camera.Position = StartCam.CenterPosition
  
  --Remove actors based on difficulty
  Utils.Do(ActorRemovals[Difficulty], function(unit)
    unit.Destroy()
  end)
  
  --Special lighting
  --none
  
  --Player Reinforcements
  Media.PlaySpeechNotification(All, "Reinforce")
  
  Reinforcements.Reinforce(BadGuy, {'bike', 'bike', 'bike'}, { NodSpawn2.Location }, 15, function(unit)
    unit.Move(NodMoveTo2.Location)
  end)
  Reinforcements.Reinforce(BadGuy, {'bike', 'bike', 'bike'}, { NodSpawn3.Location }, 15, function(unit)
    unit.Move(NodMoveTo3.Location)
  end)
  
  Trigger.AfterDelay(DateTime.Seconds(5), function()
    Media.PlaySpeechNotification(All, "Reinforce")
    Reinforcements.Reinforce(BadGuy, {'e1', 'e1', 'e1', 'e1', 'e1'}, { NodSpawn2.Location }, 15, function(unit)
      unit.Move(NodMoveTo2.Location)
    end)
    Reinforcements.Reinforce(BadGuy, {'e3', 'e3', 'e3', 'e3', 'e3'}, { NodSpawn3.Location }, 15, function(unit)
      unit.Move(NodMoveTo3.Location)
    end)
  end)
  
  Trigger.AfterDelay(DateTime.Seconds(10), function()
    Media.PlaySpeechNotification(All, "Reinforce")
    Reinforcements.Reinforce(BadGuy, {'ltnk', 'ltnk', 'ltnk', 'ltnk', 'ltnk'}, { NodSpawn1.Location }, 15, function(unit)
      unit.Move(NodMoveTo1.Location)
    end)
  end)
  
  Trigger.AfterDelay(DateTime.Seconds(15), function()
    Media.PlaySpeechNotification(All, "Reinforce")
    Reinforcements.Reinforce(BadGuy, {'e5', 'e5', 'e5', 'e5', 'e5'}, { NodSpawn1.Location }, 15, function(unit)
      unit.Move(NodMoveTo1.Location)
    end)
  end)
  
  Trigger.AfterDelay(DateTime.Seconds(20), function()
    Media.PlaySpeechNotification(All, "Reinforce")
    Reinforcements.Reinforce(BadGuy, {'e1', 'e1', 'e1', 'e1', 'e1'}, { NodSpawn2.Location }, 15, function(unit)
      unit.Move(NodMoveTo2.Location)
    end)
    Reinforcements.Reinforce(BadGuy, {'e3', 'e3', 'e3', 'e3', 'e3'}, { NodSpawn3.Location }, 15, function(unit)
      unit.Move(NodMoveTo3.Location)
    end)
  end)
  
  if Difficulty ~= 'hard' then
    Trigger.AfterDelay(DateTime.Seconds(25), function()
      Media.PlaySpeechNotification(All, "Reinforce")
      Reinforcements.Reinforce(BadGuy, {'e5', 'e5', 'e5', 'e5', 'e5'}, { NodSpawn1.Location }, 15, function(unit)
        unit.Move(NodMoveTo1.Location)
      end)
    end)
  end
  
  if Difficulty == 'easy' then
    Trigger.AfterDelay(DateTime.Seconds(30), function()
      Media.PlaySpeechNotification(All, "Reinforce")
      Reinforcements.Reinforce(BadGuy, {'ltnk', 'ltnk', 'ltnk'}, { NodSpawn1.Location }, 15, function(unit)
        unit.Move(NodMoveTo1.Location)
      end)
    end)
  end
  
  Trigger.AfterDelay(DateTime.Seconds(35), function()
    PlayerCanLose = true
	Media.PlaySpeechNotification(All, "Reinforce")
    Reinforcements.ReinforceWithTransport(
      BadGuy,
      "apc",
      { "e6", "e6", "e6" },
      { NodSpawn1.Location, NodMoveTo1.Location },
      null,
      null,
      function(transport, cargo)
	  AssignToCoopPlayers({transport}, nil, true)
	  end
    )
	Trigger.AfterDelay(DateTime.Seconds(10), function()
		if #BadGuy.GetActorsByType("apc") > 0 then
			BadGuy.GetActorsByType("apc")[1].Owner = Nod
		end
	end)
  end)
  
  Trigger.OnAllKilled({SAM1, SAM2}, function()
    Media.PlaySpeechNotification(All, "Reinforce")
    if not ObliW.IsDead then
      Reinforcements.Reinforce(FakeNod, {'heli', 'heli', 'heli'}, { HeliSpawnW.Location }, 10, function(heli)
        heli.Attack(ObliW)
      end)
    end
    if not ObliE.IsDead then
      Reinforcements.Reinforce(FakeNod, {'heli', 'heli', 'heli'}, { HeliSpawnE.Location }, 10, function(heli)
        heli.Attack(ObliE)
      end)
    end
    Trigger.AfterDelay(DateTime.Seconds(15), function()
      local helis = FakeNod.GetActorsByType("heli")
      Utils.Do(helis, function(heli)
        Trigger.ClearAll(heli)
        heli.Stop()
        heli.Move(HeliSpawnW.Location)
        heli.Destroy()
      end)
    end)
  end)
  
  --capturing eastern base's con yard gives player the whole base
  Trigger.OnCapture(CapFact, function(self, captor, oldOwner, newOwner)
    if IsOwnedByCoopPlayer(captor) then
      local buildings = Map.ActorsInBox(CapNW.CenterPosition, CapSE.CenterPosition, function(a)
        return a.Owner == Slavik3 and
          (a.Type == "gun" or a.Type == "pbox" or a.Type == "obli" or
           a.Type == "sam" or a.Type == "hand" or a.Type == "afld" or a.Type == "nuk2")
      end)
	  
      if #MCVPlayers > 1 then
		Utils.Do(CoopPlayers,function(PID)
			if PID ~= newOwner then
				local NewMCV = Actor.Create("mcv", true, { Owner = PID, Location = CapFact.Location })
				NewMCV.Scatter()
			end
		end)
      end
	  local TeamCash = 0
	  Utils.Do(CoopPlayers,function(PID)
		TeamCash = TeamCash + PID.Cash
	  end)
	  TeamCash = TeamCash / #CoopPlayers
	  Utils.Do(CoopPlayers,function(PID)
		PID.Cash = TeamCash
	  end)
	  
      Utils.Do(buildings, function(a)
		if not IsOwnedByCoopPlayer(a) then
			a.Owner = newOwner
		end
	  end)
    end
  end)
  
  --Objectives
  InitObjectives(Nod)

  Trigger.AfterDelay(DateTime.Seconds(2), function()
    KillSlavikObjective = Nod.AddObjective("Destroy Slavik's mobile headquarters.")
  end)
  
  local initialCam = Actor.Create("camera", true, { Owner = Nod, Location = StartCam.Location })
  Trigger.AfterDelay(DateTime.Seconds(20), function()
    initialCam.Destroy()
  end)
  
  Trigger.OnKilled(SlavikMHQ, function(self, killer)
    Nod.MarkCompletedObjective(KillSlavikObjective)
  end)

  --AI player behavior
  Slavik1.Cash = 90000
  Slavik1.Resources = Slavik1.ResourceCapacity - 500
  SetupRefAndSilosCaptureCredits(Slavik1)
  
  Slavik2.Cash = 90000
  Slavik2.Resources = Slavik2.ResourceCapacity - 500
  SetupRefAndSilosCaptureCredits(Slavik2)
  
  Slavik3.Cash = 90000
  Slavik3.Resources = Slavik3.ResourceCapacity - 500
  SetupRefAndSilosCaptureCredits(Slavik3)
  
  Slavik4.Cash = 90000
  Slavik4.Resources = Slavik4.ResourceCapacity - 500
  SetupRefAndSilosCaptureCredits(Slavik4)
  AutoReplaceHarvesters(Slavik4)
  AutoRepairAndRebuildBuildings(Slavik4, 15)
  
  Trigger.AfterDelay(SlavikAttackDelayMin[Difficulty] * 3, function()
    AiInfantryAttackProduction(Slavik1)
    AiVehicleAttackProduction(Slavik1)
  end)
  
  --Enemy Predeployed Maneuvers
  Trigger.AfterDelay(DateTime.Seconds(3), function()
    SlavikMHQ.Move(SlavikMove1A.Location)
    SlavikMHQ.Move(SlavikMove1B.Location)
    SlavikMHQ.Move(SlavikMove1C.Location)
    SlavikMHQ.Move(SlavikMove1D.Location)
    SlavikMHQ.Move(SlavikMove1E.Location)
  end)
  
  Trigger.AfterDelay(DateTime.Seconds(8), function()
    local units = Map.ActorsInBox(CounterNW.CenterPosition, CounterSE.CenterPosition, function(a)
      return a.Owner == Slavik1 and a.HasProperty("AttackMove")
    end)
    Utils.Do(units, function(unit) unit.AttackMove(NodSpawn1.Location) end)
  end)
  
  Utils.Do({Prox5A, Prox5B, Prox5C}, function(waypoint)
    Trigger.OnEnteredProximityTrigger(waypoint.CenterPosition, WDist.New(9 * 1024), function(a, id)
      if IsOwnedByCoopPlayer(a) then
        Trigger.RemoveProximityTrigger(id)
        SlavikFlees()
      end
    end)
  end)
  
  --Proximity Triggers/Reveals
  Trigger.OnEnteredProximityTrigger(Prox1.CenterPosition, WDist.New(7 * 1024), function(a, id)
    if IsOwnedByCoopPlayer(a) then
      Trigger.RemoveProximityTrigger(id)
      local cam1 = Actor.Create("camera", true, { Owner = Nod, Location = Cam1.Location })
      Trigger.AfterDelay(DateTime.Seconds(10), function() cam1.Destroy() end)
    end
  end)
  
  Trigger.OnEnteredProximityTrigger(Prox2.CenterPosition, WDist.New(2 * 1024), function(a, id)
    if IsOwnedByCoopPlayer(a) then
      Trigger.RemoveProximityTrigger(id)
      local cam2 = Actor.Create("camera", true, { Owner = Nod, Location = Cam2.Location })
      Trigger.AfterDelay(DateTime.Seconds(10), function() cam2.Destroy() end)
    end
  end)
  
  Trigger.OnEnteredProximityTrigger(Prox3.CenterPosition, WDist.New(7 * 1024), function(a, id)
    if IsOwnedByCoopPlayer(a) then
      Trigger.RemoveProximityTrigger(id)
      local cam3 = Actor.Create("camera", true, { Owner = Nod, Location = Cam3.Location })
      Trigger.AfterDelay(DateTime.Seconds(10), function() cam3.Destroy() end)
    end
  end)
  
  Trigger.OnEnteredProximityTrigger(Prox4.CenterPosition, WDist.New(14 * 1024), function(a, id)
    if IsOwnedByCoopPlayer(a) then
      Trigger.RemoveProximityTrigger(id)
      local cam4 = Actor.Create("camera", true, { Owner = Nod, Location = Prox4.Location })
      Trigger.AfterDelay(DateTime.Seconds(10), function() cam4.Destroy() end)
    end
  end)
  
  --Timer
  
  --Crate spawns
  if Difficulty == 'hard' then
    Utils.Do({Truck1, Truck4, Truck5, Truck6, Truck7}, function(truck)
      Trigger.OnKilled(truck, function(self, killer)
        Actor.Create("moneycrate", true, { Owner = Nod, Location = truck.Location })
      end)
    end)
  else
    Utils.Do({Truck1, Truck2, Truck3, Truck4, Truck5, Truck6, Truck7}, function(truck)
      Trigger.OnKilled(truck, function(self, killer)
        Actor.Create("moneycrate", true, { Owner = Nod, Location = truck.Location })
      end)
    end)
  end
  
  --Taunts
  
  --Testing
end


Tick = function()
	AssignToCoopPlayers(BadGuy.GetActorsByType("e6"), nil, true)
	OncePerSecondChecks()
	OncePerThreeSecondChecks()
end

OncePerSecondChecks = function()
  if DateTime.GameTime > 1 and DateTime.GameTime % 25 == 0 then
  
    if SlavikAwakened == false then
      local factories = {}
	  Utils.Do(CoopPlayers,function(PID)
		Utils.Do(PID.GetActorsByTypes({'fact', 'hand', 'afld'}),function(UID)
			table.insert(factories,UID)
		end)
	  end)
      if #factories > 0 then
        SlavikAwakened = true
        AwakenSlavik()
      end
    end
    
  end
end

OncePerThreeSecondChecks = function()
	if DateTime.GameTime > 1 and DateTime.GameTime % 75 == 0 then
  
    if PlayerCanLose then
		TibAltCoopLossCheck()
    end
    
    --manipulate AI funds
    ManipulatePlayerFunds(Slavik4)
    
    --ControlAircraft(Cabal)
	end
end


PlayerFailMission = function()
  if KillSlavikObjective ~= nil and not Nod.IsObjectiveCompleted(KillSlavikObjective) then
    Nod.MarkFailedObjective(KillSlavikObjective)
  end
end