
MorelliHasFact = true
NodDead = false
Nod2Dead = false
Nod3Dead = false
MorelliDead = false
AirstrikeGranted = false
NukeGranted = false
MorelliHasHpads = false
MorelliHasProc = false

ActorRemovals = {
  easy = { },
  normal = { },
  hard = { },
}

-- Nod Attack Production Behavior -----

NodAttackDelayMin = { easy = DateTime.Seconds(60), normal = DateTime.Seconds(45), hard = DateTime.Seconds(30) }
NodAttackDelayMax = { easy = DateTime.Seconds(90), normal = DateTime.Seconds(60), hard = DateTime.Seconds(45) }

NodAirAttackDelayMin = { easy = DateTime.Seconds(300), normal = DateTime.Seconds(270), hard = DateTime.Seconds(240) }
NodAirAttackDelayMax = { easy = DateTime.Seconds(360), normal = DateTime.Seconds(300), hard = DateTime.Seconds(270) }

NodAttackPaths = {
  { NodAtkStage.Location, NodAtkAngle1.Location },
  { NodAtkStage.Location, NodAtkAngle2.Location },
  { NodAtkStage.Location, NodAtkAngle3.Location },
}

Nod2AttackPaths = {
  { NodAtkAngle1.Location },
  { NodAtkAngle2.Location },
  { NodAtkAngle3.Location },
}

Nod3AttackPaths = {
  { Nod3AtkStage.Location, Nod3AtkDest.Location },
}

NodAttackAirTypes = {
  easy = {
     { "heli", },
  },
  normal = {
     { "heli" },
  },
  hard = {
     { "heli" },
  }
}

NodAttackVehicleTypes = {
  easy = {
     { "bggy", "bggy", "bggy", "bike", "bike" },
     { "ltnk", "ltnk", "ltnk", "arty", "arty" },
     { "ftnk", "ftnk", "ftnk", "arty", "arty" },
     { "ltnk", "ltnk", "ltnk", "ftnk", "ftnk" },
  },
  normal = {
     { "ltnk", "ltnk", "ltnk", "arty", "arty", "arty" },
     { "ftnk", "ftnk", "ftnk", "arty", "arty", "arty" },
     { "ltnk", "ltnk", "ltnk", "ftnk", "ftnk", "ftnk" },
     { "ltnk", "ltnk", "ftnk", "ftnk", "arty", "arty" },
  },
  hard = {
     { "ltnk", "ltnk", "ltnk", "ltnk", "arty", "arty", "arty" },
     { "ftnk", "ftnk", "ftnk", "ftnk", "arty", "arty", "arty" },
     { "ltnk", "ltnk", "ltnk", "ftnk", "ftnk", "ftnk", "ltnk" },
     { "ltnk", "ltnk", "ftnk", "ftnk", "arty", "arty", "arty" },
  }
}

NodAttackInfantryTypes ={
  easy = {
     { "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1" },
     { "e5", "e5", "e5", "e5", "e5", "e5", "e5", "e5" },
     { "e3", "e3", "e3", "e3", "e3", "e3", "e3", "e3" },
     { "e1", "e1", "e1", "e1", "e3", "e3", "e3", "e3" },
     { "cyborg", "cyborg", "cyborg", "cyborg", "cyborg" },
     { "cybcmdo" },
  },
  normal = {
     { "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1" },
     { "e5", "e5", "e5", "e5", "e5", "e5", "e5", "e5", "e5", "e5" },
     { "e3", "e3", "e3", "e3", "e3", "e3", "e3", "e3", "e3", "e3" },
     { "e1", "e1", "e1", "e1", "e1", "e3", "e3", "e3", "e3", "e3" },
     { "cyborg", "cyborg", "cyborg", "cyborg", "cyborg", "cyborg", "cyborg", "cyborg" },
     { "cybcmdo", "cybcmdo" },
     { "cyborg", "cyborg", "cyborg", "cyborg", "cyborg", "cyborg", "cyborg", "cybcmdo" },
  },
  hard = {
     { "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1" },
     { "e5", "e5", "e5", "e5", "e5", "e5", "e5", "e5", "e5", "e5", "e5", "e5", "e5", "e5", "e5" },
     { "e3", "e3", "e3", "e3", "e3", "e3", "e3", "e3", "e3", "e3", "e3", "e3", "e3", "e3", "e3" },
     { "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e3", "e3", "e3", "e3", "e3", "e3", "e3" },
     { "cyborg", "cyborg", "cyborg", "cyborg", "cyborg", "cyborg", "cyborg", "cyborg", "cyborg", "cyborg" },
     { "cybcmdo", "cybcmdo", "cybcmdo" },
     { "cyborg", "cyborg", "cyborg", "cyborg", "cyborg", "cyborg", "cyborg", "cyborg", "cyborg", "cybcmdo" },
  }
}

Nod23AttackInfantryTypes ={
  easy = {
     { "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1" },
     { "e4", "e4", "e4", "e4", "e4", "e4", "e4", "e4" },
     { "e3", "e3", "e3", "e3", "e3", "e3", "e3", "e3" },
     { "e1", "e1", "e1", "e1", "e3", "e3", "e3", "e3" },
     { "cyborg", "cyborg", "cyborg", "cyborg", "cyborg" },
  },
  normal = {
     { "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1" },
     { "e4", "e4", "e4", "e4", "e4", "e4", "e4", "e4", "e4", "e4" },
     { "e3", "e3", "e3", "e3", "e3", "e3", "e3", "e3", "e3", "e3" },
     { "e1", "e1", "e1", "e1", "e1", "e3", "e3", "e3", "e3", "e3" },
     { "cyborg", "cyborg", "cyborg", "cyborg", "cyborg", "cyborg", "cyborg", "cyborg" },
  },
  hard = {
     { "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1" },
     { "e4", "e4", "e4", "e4", "e4", "e4", "e4", "e4", "e4", "e4", "e4", "e4", "e4", "e4", "e4" },
     { "e3", "e3", "e3", "e3", "e3", "e3", "e3", "e3", "e3", "e3", "e3", "e3", "e3", "e3", "e3" },
     { "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e3", "e3", "e3", "e3", "e3", "e3", "e3" },
     { "cyborg", "cyborg", "cyborg", "cyborg", "cyborg", "cyborg", "cyborg", "cyborg", "cyborg", "cyborg" },
  }
}

NodInfantryAttackProduction = function()
  local production = Utils.Random(NodAttackInfantryTypes[Difficulty])
  local path = Utils.Random(NodAttackPaths)
  local toBuild = function() return production end
  local factory = GetAvailableFactory(Nod, 'hand')
  
  if factory ~= nil then
    ProduceUnits(Nod, factory, nil, toBuild, function(units)
      UpdatePlayerBaseLocation()
      Utils.Do(units, function(unit)
        ErrorGuardAttackPatrol(unit, path)
        AssaultPlayerBaseOrHunt(unit)
      end)
      Trigger.AfterDelay(Utils.RandomInteger(NodAttackDelayMin[Difficulty], NodAttackDelayMax[Difficulty]), NodInfantryAttackProduction)
    end)
  else
    Trigger.AfterDelay(Utils.RandomInteger(NodAttackDelayMin[Difficulty], NodAttackDelayMax[Difficulty]), NodInfantryAttackProduction)
  end
end

NodVehicleAttackProduction = function()
  local production = Utils.Random(NodAttackVehicleTypes[Difficulty])
  local path = Utils.Random(NodAttackPaths)
  local toBuild = function() return production end
  local factory = GetAvailableFactory(Nod, 'afld')
  
  if factory ~= nil then
    ProduceUnits(Nod, factory, nil, toBuild, function(units)
      UpdatePlayerBaseLocation()
      Utils.Do(units, function(unit)
        ErrorGuardAttackPatrol(unit, path)
        AssaultPlayerBaseOrHunt(unit)
      end)
      Trigger.AfterDelay(Utils.RandomInteger(NodAttackDelayMin[Difficulty], NodAttackDelayMax[Difficulty]), NodVehicleAttackProduction)
    end)
  else
    Trigger.AfterDelay(Utils.RandomInteger(NodAttackDelayMin[Difficulty], NodAttackDelayMax[Difficulty]), NodVehicleAttackProduction)
  end
end

NodAirAttackProduction = function()
  local production = Utils.Random(NodAttackAirTypes[Difficulty])
  local factories = Nod.GetActorsByType('hpad')
  local nodAirMax = 6
  
  if #factories > 0 then
    Utils.Do(factories, function(factory)
      local nodHelis = Nod.GetActorsByType('heli')
      if #nodHelis < nodAirMax then
        Reinforcements.Reinforce(Nod, production, { factory.Location }, 30, function(unit)
          --
        end)
      end
    end)
  end

  Trigger.AfterDelay(Utils.RandomInteger(NodAirAttackDelayMin[Difficulty], NodAirAttackDelayMax[Difficulty]), NodAirAttackProduction)
end

Nod2InfantryAttackProduction = function()
  local production = Utils.Random(Nod23AttackInfantryTypes[Difficulty])
  local path = Utils.Random(Nod2AttackPaths)
  local toBuild = function() return production end
  local factory = GetAvailableFactory(Nod2, 'hand')
  
  if factory ~= nil then
    ProduceUnits(Nod2, factory, nil, toBuild, function(units)
      UpdatePlayerBaseLocation()
      Utils.Do(units, function(unit)
        ErrorGuardAttackPatrol(unit, path)
        AssaultPlayerBaseOrHunt(unit)
      end)
      Trigger.AfterDelay(Utils.RandomInteger(NodAttackDelayMin[Difficulty], NodAttackDelayMax[Difficulty]), Nod2InfantryAttackProduction)
    end)
  else
    Trigger.AfterDelay(Utils.RandomInteger(NodAttackDelayMin[Difficulty], NodAttackDelayMax[Difficulty]), Nod2InfantryAttackProduction)
  end
end

Nod2VehicleAttackProduction = function()
  local production = Utils.Random(NodAttackVehicleTypes[Difficulty])
  local path = Utils.Random(Nod2AttackPaths)
  local toBuild = function() return production end
  local factory = GetAvailableFactory(Nod2, 'afld')
  
  if factory ~= nil then
    ProduceUnits(Nod2, factory, nil, toBuild, function(units)
      UpdatePlayerBaseLocation()
      Utils.Do(units, function(unit)
        ErrorGuardAttackPatrol(unit, path)
        AssaultPlayerBaseOrHunt(unit)
      end)
      Trigger.AfterDelay(Utils.RandomInteger(NodAttackDelayMin[Difficulty], NodAttackDelayMax[Difficulty]), Nod2VehicleAttackProduction)
    end)
  else
    Trigger.AfterDelay(Utils.RandomInteger(NodAttackDelayMin[Difficulty], NodAttackDelayMax[Difficulty]), Nod2VehicleAttackProduction)
  end
end

Nod3InfantryAttackProduction = function()
  local production = Utils.Random(Nod23AttackInfantryTypes[Difficulty])
  local path = Utils.Random(Nod3AttackPaths)
  if MorelliDead == true then path = Utils.Random(NodAttackPaths) end
  local toBuild = function() return production end
  local factory = GetAvailableFactory(Nod3, 'hand')
  
  if factory ~= nil then
    ProduceUnits(Nod3, factory, nil, toBuild, function(units)
      Utils.Do(units, function(unit)
        ErrorGuardAttackPatrol(unit, path)
        unit.Hunt()
      end)
      Trigger.AfterDelay(Utils.RandomInteger(NodAttackDelayMin[Difficulty], NodAttackDelayMax[Difficulty]), Nod3InfantryAttackProduction)
    end)
  else
    Trigger.AfterDelay(Utils.RandomInteger(NodAttackDelayMin[Difficulty], NodAttackDelayMax[Difficulty]), Nod3InfantryAttackProduction)
  end
end

Nod3VehicleAttackProduction = function()
  local production = Utils.Random(NodAttackVehicleTypes[Difficulty])
  local path = Utils.Random(Nod3AttackPaths)
  if MorelliDead == true then path = Utils.Random(NodAttackPaths) end
  local toBuild = function() return production end
  local factory = GetAvailableFactory(Nod3, 'afld')
  
  if factory ~= nil then
    ProduceUnits(Nod3, factory, nil, toBuild, function(units)
      Utils.Do(units, function(unit)
        ErrorGuardAttackPatrol(unit, path)
        if unit.Type ~= 'harv' then unit.Hunt() end
      end)
      Trigger.AfterDelay(Utils.RandomInteger(NodAttackDelayMin[Difficulty], NodAttackDelayMax[Difficulty]), Nod3VehicleAttackProduction)
    end)
  else
    Trigger.AfterDelay(Utils.RandomInteger(NodAttackDelayMin[Difficulty], NodAttackDelayMax[Difficulty]), Nod3VehicleAttackProduction)
  end
end

-- End Nod Attack Production Behavior -----


-- Morelli Attack Production Behavior -----

MorelliAttackDelayMin = { easy = DateTime.Seconds(30), normal = DateTime.Seconds(30), hard = DateTime.Seconds(30) }
MorelliAttackDelayMax = { easy = DateTime.Seconds(45), normal = DateTime.Seconds(45), hard = DateTime.Seconds(45) }

MorelliNod3AttackPaths = {
  { MorelliAtkStage.Location, MorelliAtkDest.Location },
}

MorelliNodAttackPaths = {
  { MorelliAtkStage2A.Location, MorelliAtkStage2B.Location, MorelliAtkDest2.Location },
}

MorelliAttackInfantryTypes = {
  easy = {
    { "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1" },
    { "e2", "e2", "e2", "e2", "e2", "e2", "e2", "e2", "e2", "e2" },
    { "e3", "e3", "e3", "e3", "e3", "e3", "e3", "e3", "e3", "e3" },
    { "e1", "e1", "e1", "e1", "e1", "e3", "e3", "e3", "e3", "e3" },
  },
  normal = {
    { "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1" },
    { "e2", "e2", "e2", "e2", "e2", "e2", "e2", "e2", "e2", "e2" },
    { "e3", "e3", "e3", "e3", "e3", "e3", "e3", "e3", "e3", "e3" },
    { "e1", "e1", "e1", "e1", "e1", "e3", "e3", "e3", "e3", "e3" },
  },
  hard = {
    { "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1" },
    { "e2", "e2", "e2", "e2", "e2", "e2", "e2", "e2", "e2", "e2" },
    { "e3", "e3", "e3", "e3", "e3", "e3", "e3", "e3", "e3", "e3" },
    { "e1", "e1", "e1", "e1", "e1", "e3", "e3", "e3", "e3", "e3" },
  }
}

MorelliAttackVehicleTypes = {
  easy = {
    { "jeep", "jeep", "jeep", "mtnk", "mtnk", "mtnk" },
    { "mtnk", "mtnk", "mtnk", "mtnk", "mtnk" },
    { "mtnk", "mtnk", "mtnk", "msam", "msam" },
  },
  normal = {
    { "jeep", "jeep", "jeep", "mtnk", "mtnk", "mtnk" },
    { "mtnk", "mtnk", "mtnk", "mtnk", "mtnk" },
    { "mtnk", "mtnk", "mtnk", "msam", "msam" },
  },
  hard = {
    { "jeep", "jeep", "jeep", "mtnk", "mtnk", "mtnk" },
    { "mtnk", "mtnk", "mtnk", "mtnk", "mtnk" },
    { "mtnk", "mtnk", "mtnk", "msam", "msam" },
  }
}

MorelliAttackAirTypes = {
  easy = {
     { "orca.ai", },
  },
  normal = {
     { "orca.ai" },
  },
  hard = {
     { "orca.ai" },
  }
}


MorelliInfantryProduction = function()
  local production = Utils.Random(MorelliAttackInfantryTypes[Difficulty])
  local path = Utils.Random(MorelliNod3AttackPaths)
  if Nod3Dead == true then
    path = Utils.Random(MorelliNodAttackPaths)
  end
  local toBuild = function() return production end
  local factory = GetAvailableFactory(Morelli, 'pyle')
  
  if factory ~= nil then
    ProduceUnits(Morelli, factory, nil, toBuild, function(units)
      Utils.Do(units, function(unit)
        ErrorGuardAttackPatrol(unit, path)
        unit.Hunt()
      end)
      Trigger.AfterDelay(Utils.RandomInteger(MorelliAttackDelayMin[Difficulty], MorelliAttackDelayMax[Difficulty]), MorelliInfantryProduction)
    end)
  else
    Trigger.AfterDelay(Utils.RandomInteger(MorelliAttackDelayMin[Difficulty], MorelliAttackDelayMax[Difficulty]), MorelliInfantryProduction)
  end
end


MorelliVehicleProduction = function()
  local production = Utils.Random(MorelliAttackVehicleTypes[Difficulty])
  local path = Utils.Random(MorelliNod3AttackPaths)
  if Nod3Dead == true then
    path = Utils.Random(MorelliNodAttackPaths)
  end
  local toBuild = function() return production end
  local factory = GetAvailableFactory(Morelli, 'weap')
  
  if factory ~= nil then
    ProduceUnits(Morelli, factory, nil, toBuild, function(units)
      Utils.Do(units, function(unit)
        ErrorGuardAttackPatrol(unit, path)
        if unit.Type ~= 'harv' then unit.Hunt() end
      end)
      Trigger.AfterDelay(Utils.RandomInteger(MorelliAttackDelayMin[Difficulty], MorelliAttackDelayMax[Difficulty]), MorelliVehicleProduction)
    end)
  else
    Trigger.AfterDelay(Utils.RandomInteger(MorelliAttackDelayMin[Difficulty], MorelliAttackDelayMax[Difficulty]), MorelliVehicleProduction)
  end
end


MorelliAirAttackProduction = function()
  local orcas = Morelli.GetActorsByType('orca.ai')
  
  if #orcas < 4 then
    local deficit = 4 - #orcas
    local newOrcas = 0
    local factories = Morelli.GetActorsByType('hpad')
    Utils.Do(factories, function(factory)
      if newOrcas >= deficit then return end
      local orca = Actor.Create('orca.ai', true, { Owner = Morelli, Location = factory.Location })
      orca.Move(factory.Location)
      newOrcas = newOrcas + 1
    end)
  end
  Trigger.AfterDelay(DateTime.Seconds(90), MorelliAirAttackProduction)
end


MorelliAirDefense = function()
  local targets = Map.ActorsInBox(MorelliBaseNW.CenterPosition, MorelliBaseSE.CenterPosition, function(a)
    return (a.Owner == Nod or a.Owner == Nod2 or a.Owner == Nod3) and
           (a.Type == 'ltnk' or a.Type == 'arty' or a.Type == 'bggy' or a.Type == 'bike' or a.Type == 'cyborg' or a.Type == 'ftnk')
  end)
  
  local orcas = Morelli.GetActorsByType('orca.ai')
  
  if #targets > 0 then
    local target = Utils.Random(targets)
    Utils.Do(orcas, function(orca)
      if target ~= nil and not target.IsDead then orca.AttackMove(target.Location) end
    end)
  else
    Utils.Do(orcas, function(orca)
      orca.Stop()
      orca.AttackMove(OrcaIdle.Location)
    end)
  end
  
  Trigger.AfterDelay(DateTime.Seconds(8), MorelliAirDefense)
end


AirstrikeAttacks = function()
  if Difficulty == 'hard' then
    Trigger.AfterDelay(DateTime.Seconds(480), AirstrikeAttacks)
  else
    Trigger.AfterDelay(DateTime.Seconds(360), AirstrikeAttacks)
  end

  local comms = Morelli.GetActorsByType('hq')
  Utils.Do(CoopPlayers,function(PID)
	if PID == CoopPlayers[2] or PID == CoopPlayers[4] or PID == CoopPlayers[6] then
		local teamMorelliHQ = PID.GetActorsByType('hq')
		Utils.Do(teamMorelliHQ,function(UID)
			table.insert(comms,UID)
		end)
	end
  end)
  if #comms == 0 then return end
  
  local launchedIt = false

  if Nod3Dead == false then
    launchedIt = LaunchAIAirstrike(Morelli, { Nod3 }, { 'a10scrip', 'a10scrip', 'a10scrip' }, { MorelliAirstrikeSpawn })
  elseif NodDead == false then
    launchedIt = LaunchAIAirstrike(Morelli, { Nod }, { 'a10scrip', 'a10scrip', 'a10scrip' }, { MorelliAirstrikeSpawn })
  elseif Nod2Dead == false then
    launchedIt = LaunchAIAirstrike(Morelli, { Nod2 }, { 'a10scrip', 'a10scrip', 'a10scrip' }, { MorelliAirstrikeSpawn })
  end
  
  if launchedIt == true then
    Media.DisplayMessage("Colonel Morelli is launching an airstrike.", "EVA", HSLColor.FromHex("00FF00"))
  end
end

-- Morelli Attack Production Behavior -----


-- Morelli Base-Building Behavior -----
BuildBaseOrders = {
  ["nuke"]   = { structure = "nuke", loc = BuildNuke.Location,  tim = 12 },
  ["pyle"]   = { structure = "pyle", loc = BuildPyle.Location,  tim = 24 },
  ["proc1"]  = { structure = "proc", loc = BuildProc1.Location, tim = 60 },
  ["hq"]     = { structure = "hq",   loc = BuildComm.Location,  tim = 84 },
  ["nuk21"]  = { structure = "nuk2", loc = BuildNuk21.Location, tim = 108 },
  ["weap"]   = { structure = "weap", loc = BuildWeap.Location,  tim = 156 },
  ["nuk22"]  = { structure = "nuk2", loc = BuildNuk22.Location, tim = 180 },
  ["hpad1"]  = { structure = "hpad", loc = BuildHpad1.Location, tim = 188 },
  ["hpad2"]  = { structure = "hpad", loc = BuildHpad2.Location, tim = 196 },
  ["hpad3"]  = { structure = "hpad", loc = BuildHpad3.Location, tim = 204 },
  ["hpad4"]  = { structure = "hpad", loc = BuildHpad4.Location, tim = 212 },
  ["proc2"]  = { structure = "proc", loc = BuildProc2.Location, tim = 248 },
  
  ["gtwr1"] = { structure = "gtwr",    loc = BuildGtwr1.Location, tim = 48 },
  ["gtwr2"] = { structure = "gtwr",    loc = BuildGtwr2.Location, tim = 72 },
  ["atwr1"] = { structure = "atwr",    loc = BuildAtwr1.Location, tim = 119 },
  ["atwr2"] = { structure = "atwr",    loc = BuildAtwr2.Location, tim = 166 },
  ["rpg1"]  = { structure = "rpgturr", loc = BuildRPG1.Location,  tim = 190 },
  ["rpg2"]  = { structure = "rpgturr", loc = BuildRPG2.Location,  tim = 214 },
  ["rpg3"]  = { structure = "rpgturr", loc = BuildRPG3.Location,  tim = 238 },
}

BuildMorelliBase = function()
  for id, orders in pairs(BuildBaseOrders) do
    Trigger.AfterDelay(DateTime.Seconds(orders.tim), function()
      if MorelliHasFact == true then
        local newBuilding = Actor.Create(orders.structure, true, { Owner = Morelli, Location = orders.loc })
        AutoRebuildBuilding(newBuilding, Morelli)
        if id == 'pyle' then
          Trigger.AfterDelay(DateTime.Seconds(5), MorelliInfantryProduction)
        elseif id == 'weap' then
          Trigger.AfterDelay(DateTime.Seconds(5), MorelliVehicleProduction)
        elseif id == 'hpad4' then
          MorelliHasHpads = true
          Trigger.AfterDelay(DateTime.Seconds(3), MorelliAirAttackProduction)
        elseif id == 'proc1' then
          AutoReplaceHarvesters(Morelli)
          Trigger.AfterDelay(DateTime.Seconds(3), function() MorelliHasProc = true end)
        end
      end
    end)
  end
end

-- End Morelli Base-Building Behavior -----


FloaterAttack = function()
  if NodDead or Nod2Dead or Nod3Dead then
    UpdatePlayerBaseLocation()
    Reinforcements.Reinforce(TibLife, {'floater', 'floater', 'floater'}, { TibLifeSpawn3.Location }, 30, function(unit)
      unit.Move(TibLifeMoveTo3.Location)
      AssaultPlayerBaseOrHunt(unit)
    end)
  end

  Trigger.AfterDelay(DateTime.Seconds(90), FloaterAttack)
end


CheckTibLife = function()
  if Difficulty == 'easy' then return end
  
  local critters = Map.ActorsInBox(TibLifeNW.CenterPosition, TibLifeSE.CenterPosition, function(a)
    return a.Owner == TibLife
  end)
  
  if #critters < 6 then
    Reinforcements.Reinforce(TibLife, {'pvice', 'tfnd', 'tfnd'}, { TibLifeSpawn1.Location }, 30, function(unit)
      unit.Move(TibLifeMoveTo1.Location)
    end)
    Reinforcements.Reinforce(TibLife, {'pvice', 'tfnd', 'tfnd'}, { TibLifeSpawn2.Location }, 30, function(unit)
      unit.Move(TibLifeMoveTo2.Location)
    end)
  end
  
  Trigger.AfterDelay(DateTime.Seconds(60), CheckTibLife)
end


CheckDestroyedSams = function()
  local sams = SubNod.GetActorsByType('sam')
	if #sams == 0 then
    AirstrikeGranted = true
    GDI.MarkCompletedObjective(DestroySamsObjective)
    Trigger.AfterDelay(DateTime.Seconds(5), function()
      Actor.Create("airstrike.proxy", true, { Owner = GDI })
      Media.DisplayMessage("A10 wing ready to commence airstrikes.", "EVA", HSLColor.FromHex("00FF00"))
    end)
  end
end

AssignToTeams = function(units, team)
	local playerCount = #team
	local CurrentCount = 1

	Utils.Do(units, function(unit)
		if unit.Type ~= "player" then
			if CurrentCount > playerCount then
				CurrentCount = 1
			end
			local newOwner = team[CurrentCount]
			unit.Owner = newOwner
			CurrentCount = CurrentCount + 1
		end
	end)
end

WorldLoaded = function()
  GDI = Player.GetPlayer("GDI")
  Nod = Player.GetPlayer("Nod")
  Nod2 = Player.GetPlayer("Nod2")
  Nod3 = Player.GetPlayer("Nod3")
  SubNod = Player.GetPlayer("SubNod")
  Morelli = Player.GetPlayer("Morelli")
  TibLife = Player.GetPlayer("TibLife")
  Neutral = Player.GetPlayer("Neutral")
  
  MissionPlayer = GDI

	GoodGuy = Player.GetPlayer("GoodGuy")

	coopInfo =
	{
		Mainplayer = GDI,
		MainEnemies = {Nod1, Nod2, Nod3, SubNod},
		Dummyplayer = GoodGuy
	}
	
	ORAMod = "tibalt"
	Stopspread = true

	CoopInit25(coopInfo)
	
	if #CoopPlayers > 1 then
		local TeamSouth = {}
		local TeamMorelli = {}
		local MessageTeam = "For this mission, you are split into 2 starting Positions:\n"
		local MessageSolomon = "Team Solomon (SW): "
		local MessageMorelli = "\nTeam Morelli (NE): "
		Utils.Do(CoopPlayers,function(PID)
			if PID == CoopPlayers[1] or PID == CoopPlayers[3] or PID == CoopPlayers[5] then
				table.insert(TeamSouth,PID)
				MessageSolomon = MessageSolomon .. "[" .. PID.Name .. "] "
			elseif PID == CoopPlayers[2] or PID == CoopPlayers[4] or PID == CoopPlayers[6] then
				table.insert(TeamMorelli,PID)
				MessageMorelli = MessageMorelli .. "[" .. PID.Name .. "] "
			end
		end)
		Media.DisplayMessage(MessageTeam .. MessageSolomon .. MessageMorelli, "EVA", HSLColor.FromHex("00FF00"))
		
		MorelliFact.Owner = CoopPlayers[2]
		MorelliHasFact = false
		AssignToTeams(GDI.GetGroundAttackers(), TeamSouth)
		AssignToTeams(Morelli.GetGroundAttackers(), TeamMorelli)
		Utils.Do(MCVPlayers,function(PID)
			local TeamSpawn
			local CustomStartCamPos
			if PID == TeamSouth[1] then
				CustomStartCamPos = Actor775
			elseif PID == TeamMorelli[1] then
				CustomStartCamPos = OrcaIdle
			elseif PID == TeamSouth[2] or PID == TeamSouth[3] then
				TeamSpawn = Actor775
			elseif PID == TeamMorelli[2] or PID == TeamMorelli[3] then
				TeamSpawn = OrcaIdle
			end
			if TeamSpawn ~= nil then
				CustomStartCamPos = TeamSpawn
				local NewMCV = Actor.Create("mcv", true, { Owner = PID, Location = TeamSpawn.Location })
				NewMCV.Scatter()
			end
			if PID.IsLocalPlayer == true then
				Camera.Position = CustomStartCamPos.CenterPosition
			end
		end)
	else
		Camera.Position = Actor775.CenterPosition
	end

  
  --Remove actors based on difficulty
  Utils.Do(ActorRemovals[Difficulty], function(unit)
    unit.Destroy()
  end)
  
  
  --Special lighting
  Lighting.Ambient = 0.7
  Lighting.Red = 1.25
  Lighting.Blue = 0.75
  Lighting.Green = 1.1
  
  --Player Reinforcements
  
  --Objectives
  InitObjectives(GDI)

  Trigger.AfterDelay(DateTime.Seconds(2), function()
    DefeatNodObjective = GDI.AddObjective("Annihilate all Nod forces.")
    DestroySamsObjective = GDI.AddObjective("Destroy all outer (red) SAM sites.", "Secondary", false)
  end)
  
  --AI player behavior
  Utils.Do( {Nod, Nod2, Nod3}, function(player)
    player.Cash = 10000
    player.Resources = player.ResourceCapacity - 500
    SetupRefAndSilosCaptureCredits(player)
    AutoReplaceHarvesters(player)
    AutoRepairAndRebuildBuildings(player, 15)
  end)
  
  if MorelliHasFact == true then
	Morelli.Cash = 150000
	BuildMorelliBase()
	Trigger.OnKilled(MorelliFact, function(self, killer) MorelliHasFact = false end)
	MorelliAirDefense()
  end
  AirstrikeAttacks()
  
  Utils.Do(CoopPlayers,function(PID)
	SellBuildingIfEngyNear(NodAfld, 4, PID)
	SellBuildingIfEngyNear(NodHand, 4, PID)
  
	SellBuildingIfEngyNear(Nod2Fact, 4, PID)
	SellBuildingIfEngyNear(Nod2Afld, 4, PID)
	SellBuildingIfEngyNear(Nod2Hand, 4, PID)
  
	SellBuildingIfEngyNear(Nod3Fact, 4, PID)
	SellBuildingIfEngyNear(Nod3Afld, 4, PID)
	SellBuildingIfEngyNear(Nod3Hand, 4, PID)
  end)
  
  local nukeDelay = { easy = 60 * 120, normal = 60 * 60, hard = 30 * 60 }
  Trigger.AfterDelay(DateTime.Seconds(nukeDelay[Difficulty]), function()
    if NukeGranted == false then
      NukeGranted = true
      Nod.GrantCondition('nuke-active')
    end
  end)

  local nod23ProductionDelay = { easy = 180, normal = 90, hard = 45 }
  Trigger.AfterDelay(DateTime.Seconds(nod23ProductionDelay[Difficulty]), function()
    Nod2InfantryAttackProduction()
    Nod2VehicleAttackProduction()
    Nod3InfantryAttackProduction()
    Nod3VehicleAttackProduction()
  end)
  
  local nodProductionDelay =   { easy = 240, normal = 180, hard = 120 }
  Trigger.AfterDelay(DateTime.Seconds(nodProductionDelay[Difficulty]), function()
    NodInfantryAttackProduction()
    NodVehicleAttackProduction()
    Trigger.AfterDelay(NodAirAttackDelayMin[Difficulty], NodAirAttackProduction)
  end)

  --Enemy Predeployed Maneuvers
  CheckTibLife()
  FloaterAttack()
  
  --Proximity Triggers/Reveals
  
  --Timer
  
  --Crate spawns
  
  --Taunts
  
  --Testing
end


Tick = function()
	OncePerSecondChecks()
	OncePerThreeSecondChecks()
  
  --Thunder and lightning
	if (Utils.RandomInteger(1, 200) == 10) then
		local delay = Utils.RandomInteger(1, 10)
		Lighting.Flash("LightningStrike", delay)
		Trigger.AfterDelay(delay, function()
			Media.PlaySound("thunder" .. Utils.RandomInteger(1,6) .. ".aud")
		end)
	end
	if (Utils.RandomInteger(1, 200) == 10) then
		Media.PlaySound("thunder-ambient.aud")
	end
end

OncePerSecondChecks = function()
  if DateTime.GameTime > 1 and DateTime.GameTime % 25 == 0 then
    --None
  end
end

OncePerThreeSecondChecks = function()
	if DateTime.GameTime > 1 and DateTime.GameTime % 75 == 0 then
  
    --[[if HasOneOf(GDI, LossCheckAll) == false then
      PlayerFailMission()
    end]]
	TibAltCoopLossCheck()
    
    if NodDead == false then
      if HasOneOf(Nod, LossCheckCritical) == false then NodDead = true end
    end
    
    if Nod2Dead == false then
      if HasOneOf(Nod2, LossCheckCritical) == false then
        Nod2Dead = true
        if Difficulty ~= 'easy' and NukeGranted == false then
          NukeGranted = true
          Nod.GrantCondition('nuke-active')
        end
      end
    end
    
    if Nod3Dead == false then
      if HasOneOf(Nod3, LossCheckCritical) == false then
        Nod3Dead = true
        if Difficulty ~= 'easy' and NukeGranted == false then
          NukeGranted = true
          Nod.GrantCondition('nuke-active')
        end
      end
    end
    
    if NodDead and Nod2Dead and Nod3Dead then
      GDI.MarkCompletedObjective(DefeatNodObjective)
    end
    
    if MorelliDead == false then
      if HasOneOf(Morelli, LossCheckCritical) == false then MorelliDead = true end
    end
    
    if AirstrikeGranted == false then CheckDestroyedSams() end

    --manipulate AI funds
    ManipulatePlayerFunds(Nod)
    ManipulatePlayerFunds(Nod2)
    ManipulatePlayerFunds(Nod3)
    if MorelliHasProc == true then ManipulatePlayerFunds(Morelli) end
    
    ControlAircraft(Nod)
	end
end


PlayerFailMission = function()
  if DefeatNodObjective ~= nil and not GDI.IsObjectiveCompleted(DefeatNodObjective) then
    GDI.MarkFailedObjective(DefeatNodObjective)
  end
  if DestroySamsObjective ~= nil and not GDI.IsObjectiveCompleted(DestroySamsObjective) then
    GDI.MarkFailedObjective(DestroySamsObjective)
  end
end