
PlayerCanLose = false
GrantPlayerNuke = false
GDIAwakened = false

ActorRemovals = {
  easy = { },
  normal = { },
  hard = { },
}

-- GDI Attack Production Behavior -----

AwakenGDI = function()
  if GDIAwakened == true then return end
  GDIAwakened = true

  Trigger.AfterDelay(GDIAttackDelayMin[Difficulty] * 2, function()
    GDIInfantryAttackProduction()
    GDIVehicleAttackProduction()
  end)
  
  SubGDIInfantryAttackProduction()
  SubGDIVehicleAttackProduction()
  
  GDI.GrantCondition("ion-cannon-active")
  Trigger.AfterDelay(GDIAirAttackDelayMin[Difficulty] * 2, SubGDIAirAttackProduction)
  Trigger.AfterDelay(AirstrikeDelayTimes[Difficulty], AirstrikeAttacks)
  
  Actor.Create('boat', true, { Owner = GDI, Location = BoatSpawn.Location } )
  if Difficulty ~= 'easy' then
    Trigger.AfterDelay(DateTime.Seconds(4), function()
      Actor.Create('boat', true, { Owner = GDI, Location = BoatSpawn.Location } )
    end)
  end
  if Difficulty == 'hard' then
    Trigger.AfterDelay(DateTime.Seconds(8), function()
      Actor.Create('boat', true, { Owner = GDI, Location = BoatSpawn.Location } )
    end)
  end
  
  if Difficulty ~= 'easy' then
    Trigger.AfterDelay(DateTime.Seconds(270), function()
      local baseBuildings = MissionPlayer.GetActorsByTypes( {'fact', 'afld', 'hand', 'nuke', 'nuk2', 'proc', 'hq'} )
      if #baseBuildings > 0 then
        CmdoRushTargetPlayer = MissionPlayer
        Reinforcements.ReinforceWithTransport(GDI, "tran", {"rmbo", "rmbo", "rmbo"}, { GDIAirSpawn4.Location }, null, ExecCmdoRush)
      end
    end)
  end
end

GDIAttackDelayMin = { easy = DateTime.Seconds(45), normal = DateTime.Seconds(30), hard = DateTime.Seconds(25) }
GDIAttackDelayMax = { easy = DateTime.Seconds(60), normal = DateTime.Seconds(45), hard = DateTime.Seconds(30) }

GDIAirAttackDelayMin = { easy = DateTime.Seconds(270), normal = DateTime.Seconds(240), hard = DateTime.Seconds(210) }
GDIAirAttackDelayMax = { easy = DateTime.Seconds(300), normal = DateTime.Seconds(270), hard = DateTime.Seconds(240) }

SubGDIAttackPaths = {
  { GDIAtkPath1.Location, GDIAtkDest.Location },
  { GDIAtkPath2A.Location, GDIAtkPath2B.Location, GDIAtkDest.Location },
}

GDIAttackPaths = {
  { GDIAtkPath3.Location, GDIAtkPath1.Location, GDIAtkDest.Location },
  { GDIAtkPath3.Location, GDIAtkPath2A.Location, GDIAtkPath2B.Location, GDIAtkDest.Location },
}

SubGDIAttackAirTypes = {
  easy = {
     { "orca", },
  },
  normal = {
     { "orca" },
  },
  hard = {
     { "orca", "orca" },
  }
}

GDIAttackVehicleTypes = {
  easy = {
     { "jeep", "jeep", "mtnk", "mtnk" },
     { "jeep", "jeep", "mtnk", "mtnk", "msam" },
     { "mtnk", "mtnk", "mtnk", "mtnk" },
     { "mtnk", "mtnk", "mtnk", "msam", "msam" },
     { "htnk", "htnk", "htnk" },
     { "htnk", "htnk", "msam", "msam" },
     { "exosuit", "exosuit", "mtnk", "mtnk" },
     { "exosuit", "exosuit", "exosuit" },
  },
  normal = {
     { "jeep", "jeep", "jeep", "mtnk", "mtnk", "mtnk" },
     { "jeep", "jeep", "mtnk", "mtnk", "msam", "msam" },
     { "mtnk", "mtnk", "mtnk", "mtnk", "mtnk", "mtnk" },
     { "mtnk", "mtnk", "mtnk", "mtnk", "msam", "msam" },
     { "htnk", "htnk", "htnk", "htnk" },
     { "htnk", "htnk", "htnk", "msam", "msam" },
     { "exosuit", "exosuit", "exosuit", "mtnk", "mtnk", "mtnk" },
     { "exosuit", "exosuit", "exosuit", "exosuit" },
  },
  hard = {
     { "jeep", "jeep", "jeep", "mtnk", "mtnk", "mtnk", "mtnk" },
     { "jeep", "jeep", "mtnk", "mtnk", "msam", "msam", "msam" },
     { "mtnk", "mtnk", "mtnk", "mtnk", "mtnk", "mtnk", "mtnk" },
     { "mtnk", "mtnk", "mtnk", "mtnk", "msam", "msam", "msam" },
     { "htnk", "htnk", "htnk", "htnk", "htnk" },
     { "htnk", "htnk", "htnk", "msam", "msam", "msam" },
     { "exosuit", "exosuit", "exosuit", "mtnk", "mtnk", "mtnk" },
     { "exosuit", "exosuit", "exosuit", "exosuit", "exosuit" },
  }
}

SubGDIAttackVehicleTypes = {
  easy = {
     { "jeep", "jeep", "mtnk", "mtnk" },
     { "jeep", "jeep", "mtnk", "mtnk", "msam" },
     { "mtnk", "mtnk", "mtnk", "mtnk" },
     { "mtnk", "mtnk", "mtnk", "msam", "msam" },
  },
  normal = {
     { "jeep", "jeep", "jeep", "mtnk", "mtnk", "mtnk" },
     { "jeep", "jeep", "mtnk", "mtnk", "msam", "msam" },
     { "mtnk", "mtnk", "mtnk", "mtnk", "mtnk", "mtnk" },
     { "mtnk", "mtnk", "mtnk", "mtnk", "msam", "msam" },
  },
  hard = {
     { "jeep", "jeep", "jeep", "mtnk", "mtnk", "mtnk", "mtnk" },
     { "jeep", "jeep", "mtnk", "mtnk", "msam", "msam", "msam" },
     { "mtnk", "mtnk", "mtnk", "mtnk", "mtnk", "mtnk", "mtnk" },
     { "mtnk", "mtnk", "mtnk", "mtnk", "msam", "msam", "msam" },
  }
}

GDIAttackInfantryTypes ={
  easy = {
     { "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1" },
     { "e2", "e2", "e2", "e2", "e2", "e2", "e2", "e2" },
     { "e3", "e3", "e3", "e3", "e3", "e3", "e3", "e3" },
     { "e1", "e1", "e1", "e1", "e3", "e3", "e3", "e3" },
  },
  normal = {
     { "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1" },
     { "e2", "e2", "e2", "e2", "e2", "e2", "e2", "e2", "e2", "e2" },
     { "e3", "e3", "e3", "e3", "e3", "e3", "e3", "e3", "e3", "e3" },
     { "e1", "e1", "e1", "e1", "e1", "e3", "e3", "e3", "e3", "e3" },
  },
  hard = {
     { "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1" },
     { "e2", "e2", "e2", "e2", "e2", "e2", "e2", "e2", "e2", "e2", "e2", "e2", "e2", "e2", "e2" },
     { "e3", "e3", "e3", "e3", "e3", "e3", "e3", "e3", "e3", "e3", "e3", "e3", "e3", "e3", "e3" },
     { "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e3", "e3", "e3", "e3", "e3", "e3", "e3" },
  }
}

GDIInfantryAttackProduction = function()
  local production = Utils.Random(GDIAttackInfantryTypes[Difficulty])
  local path = Utils.Random(GDIAttackPaths)
  local toBuild = function() return production end
  local factory = GetAvailableFactory(GDI, 'pyle')
  
  if factory ~= nil then
    ProduceUnits(GDI, factory, nil, toBuild, function(units)
      UpdatePlayerBaseLocation()
      Utils.Do(units, function(unit)
        ErrorGuardAttackPatrol(unit, path)
        AssaultPlayerBaseOrHunt(unit)
      end)
      Trigger.AfterDelay(Utils.RandomInteger(GDIAttackDelayMin[Difficulty], GDIAttackDelayMax[Difficulty]), GDIInfantryAttackProduction)
    end)
  else
    Trigger.AfterDelay(Utils.RandomInteger(GDIAttackDelayMin[Difficulty], GDIAttackDelayMax[Difficulty]), GDIInfantryAttackProduction)
  end
end

GDIVehicleAttackProduction = function()
  local production = Utils.Random(GDIAttackVehicleTypes[Difficulty])
  local path = Utils.Random(GDIAttackPaths)
  local toBuild = function() return production end
  local factory = GetAvailableFactory(GDI, 'weap')
  
  if factory ~= nil then
    ProduceUnits(GDI, factory, nil, toBuild, function(units)
      UpdatePlayerBaseLocation()
      Utils.Do(units, function(unit)
        ErrorGuardAttackPatrol(unit, path)
        AssaultPlayerBaseOrHunt(unit)
      end)
      Trigger.AfterDelay(Utils.RandomInteger(GDIAttackDelayMin[Difficulty], GDIAttackDelayMax[Difficulty]), GDIVehicleAttackProduction)
    end)
  else
    Trigger.AfterDelay(Utils.RandomInteger(GDIAttackDelayMin[Difficulty], GDIAttackDelayMax[Difficulty]), GDIVehicleAttackProduction)
  end
end

SubGDIAirAttackProduction = function()
  local production = Utils.Random(SubGDIAttackAirTypes[Difficulty])
  local factories = SubGDI.GetActorsByType('hpad')
  local gdiAirMax = 6
  
  if #factories > 0 then
    Utils.Do(factories, function(factory)
      local gdiOrcas = SubGDI.GetActorsByType('orca')
      if #gdiOrcas < gdiAirMax then
        Reinforcements.Reinforce(SubGDI, production, { factory.Location }, 30, function(unit)
          --
        end)
      end
    end)
  end
  Trigger.AfterDelay(Utils.RandomInteger(GDIAirAttackDelayMin[Difficulty], GDIAirAttackDelayMax[Difficulty]), SubGDIAirAttackProduction)
end

SubGDIInfantryAttackProduction = function()
  local production = Utils.Random(GDIAttackInfantryTypes[Difficulty])
  local path = Utils.Random(SubGDIAttackPaths)
  local toBuild = function() return production end
  local factory = GetAvailableFactory(SubGDI, 'pyle')
  
  if factory ~= nil then
    ProduceUnits(SubGDI, factory, nil, toBuild, function(units)
      UpdatePlayerBaseLocation()
      Utils.Do(units, function(unit)
        ErrorGuardAttackPatrol(unit, path)
        AssaultPlayerBaseOrHunt(unit)
      end)
      Trigger.AfterDelay(Utils.RandomInteger(GDIAttackDelayMin[Difficulty], GDIAttackDelayMax[Difficulty]), SubGDIInfantryAttackProduction)
    end)
  else
    Trigger.AfterDelay(Utils.RandomInteger(GDIAttackDelayMin[Difficulty], GDIAttackDelayMax[Difficulty]), SubGDIInfantryAttackProduction)
  end
end

SubGDIVehicleAttackProduction = function()
  local production = Utils.Random(SubGDIAttackVehicleTypes[Difficulty])
  local path = Utils.Random(SubGDIAttackPaths)
  local toBuild = function() return production end
  local factory = GetAvailableFactory(SubGDI, 'weap')
  
  if factory ~= nil then
    ProduceUnits(SubGDI, factory, nil, toBuild, function(units)
      UpdatePlayerBaseLocation()
      Utils.Do(units, function(unit)
        ErrorGuardAttackPatrol(unit, path)
        AssaultPlayerBaseOrHunt(unit)
      end)
      Trigger.AfterDelay(Utils.RandomInteger(GDIAttackDelayMin[Difficulty], GDIAttackDelayMax[Difficulty]), SubGDIVehicleAttackProduction)
    end)
  else
    Trigger.AfterDelay(Utils.RandomInteger(GDIAttackDelayMin[Difficulty], GDIAttackDelayMax[Difficulty]), SubGDIVehicleAttackProduction)
  end
end

-- End GDI Attack Production Behavior -----


Reinforce = function(units, voice, start, destination)
  if voice then
    Media.PlaySpeechNotification(All, "Reinforce")
  end
  ReinforceWithLandingCraft(BadGuy, units, start.Location, destination.Location, false)
end


AirstrikeDelayTimes = {
  easy = DateTime.Seconds(480),
  normal = DateTime.Seconds(360),
  hard = DateTime.Seconds(300),
}

AirstrikeAttacks = function()
  local comms = SubGDI.GetActorsByType('hq')
  if #comms == 0 then return end
  
  local launchedIt
  Utils.Do(CoopPlayers,function(PID)
	launchedIt = LaunchAIAirstrike(SubGDI, { PID }, { 'a10scrip', 'a10scrip', 'a10scrip' }, { GDIAirSpawn1, GDIAirSpawn2, GDIAirSpawn3, GDIAirSpawn4 })
  end)
  if launchedIt == true then
    Media.DisplayMessage("Warning: GDI airstrike incoming.", "EVA", HSLColor.FromHex("00FF00"))
  end
  
  Trigger.AfterDelay(AirstrikeDelayTimes[Difficulty], AirstrikeAttacks)
end


WorldLoaded = function()
  Nod = Player.GetPlayer("Nod")
  GDI = Player.GetPlayer("GDI")
  SubGDI = Player.GetPlayer("SubGDI")
  GDI2 = Player.GetPlayer("GDI2")
  Neutral = Player.GetPlayer("Neutral")
  
  MissionPlayer = Nod

	BadGuy = Player.GetPlayer("BadGuy")

	coopInfo =
	{
		Mainplayer = Nod,
		MainEnemies = {GDI, SubGDI, GDI2},
		Dummyplayer = BadGuy
	}
	
	ORAMod = "tibalt"
	CoopInit25(coopInfo)
	
	MCVlist = {}
	Utils.Do(MCVPlayers,function(PID)
		table.insert(MCVlist,"mcv")
	end)

  Camera.Position = StartCam.CenterPosition
  
  --Remove actors based on difficulty
  Utils.Do(ActorRemovals[Difficulty], function(unit)
    unit.Destroy()
  end)
  
  --Special lighting
  Lighting.Ambient = 0.9
  Lighting.Red = 1.0
  Lighting.Blue = 1.1
  Lighting.Green = 1.0
  
  --Special lighting
  
  --Player Reinforcements
  Reinforce({'e1', 'e1', 'e1'}, true, NodRSpawn1, NodRLand1)
  Reinforce({'e3', 'e3', 'e3'}, true, NodRSpawn2, NodRLand2)
  
  Trigger.AfterDelay(DateTime.Seconds(5), function()
    Reinforce({'ltnk'}, true, NodRSpawn3, NodRLand3)
    Reinforce({'ltnk'}, true, NodRSpawn4, NodRLand4)
  end)

  Trigger.AfterDelay(DateTime.Seconds(10), function()
    Reinforce(MCVlist, true, NodRSpawn5, NodRLand5)
  end)
  
  --Objectives
  InitObjectives(Nod)

  Trigger.AfterDelay(DateTime.Seconds(15), function()
    CaptureEyeObjective = Nod.AddObjective("Capture GDI's advanced communications center.")
    PlayerCanLose = true
  end)
  
  Trigger.OnCapture(Eye, function(self, captor, oldOwner, newOwner)
    if IsOwnedByCoopPlayer(captor) then
      Nod.MarkCompletedObjective(CaptureEyeObjective)
    end
  end)
  
  Trigger.OnKilled(Eye, function(self, killer)
    Nod.MarkFailedObjective(CaptureEyeObjective)
  end)
  
  --AI player behavior
  GDI.Cash = 10000
  GDI.Resources = GDI.ResourceCapacity - 500
  SetupRefAndSilosCaptureCredits(GDI)
  AutoReplaceHarvesters(GDI)
  AutoRepairAndRebuildBuildings(GDI, 15)
  
  SubGDI.Cash = 10000
  SubGDI.Resources = SubGDI.ResourceCapacity - 500
  SetupRefAndSilosCaptureCredits(SubGDI)
  AutoReplaceHarvesters(SubGDI)
  AutoRepairAndRebuildBuildings(SubGDI, 15)
  
  Trigger.AfterDelay(DateTime.Seconds(90), AwakenGDI)

  Utils.Do( { ProxAwaken1, ProxAwaken2 }, function(wp)
    Trigger.OnEnteredProximityTrigger(wp.CenterPosition, WDist.New(3 * 1024), function(a, id)
      if IsOwnedByCoopPlayer(a) and a.Type == 'mcv' then
        Trigger.RemoveProximityTrigger(id)
        AwakenGDI()
      end
    end)
  end)
  
  local awakenTriggers1 = SubGDI.GetActorsByTypes( {'rpgturr', 'gtwr', 'atwr', 'harv', 'aaa', 'proc', 'pyle', 'fact', 'weap', 'nuk2', 'hpad', 'fix'} )
  Utils.Do(awakenTriggers1, function(trig)
    Trigger.OnKilled(trig, function(self, killer) AwakenGDI() end)
  end)
  
  local awakenTriggers2 = GDI.GetActorsByTypes( {'rpgturr', 'gtwr', 'atwr', 'harv', 'aaa', 'proc', 'pyle', 'fact', 'weap', 'nuk2', 'hpad', 'fix'} )
  Utils.Do(awakenTriggers2, function(trig)
    Trigger.OnKilled(trig, function(self, killer) AwakenGDI() end)
  end)
  
  --Enemy Predeployed Maneuvers
  
  --Proximity Triggers/Reveals
  
  --Timer
  
  --Crate spawns
  
  --Taunts
  
  --Testing
end


Tick = function()
	AssignToCoopPlayers(BadGuy.GetActorsByType("mcv"), nil, true)
	Utils.Do(BadGuy.GetActorsByType("mcv"),function(UID)
		UID.Scatter()
	end)
	OncePerSecondChecks()
	OncePerThreeSecondChecks()
end

OncePerSecondChecks = function()
  if DateTime.GameTime > 1 and DateTime.GameTime % 25 == 0 then
	Utils.Do(CoopPlayers,function(PID)
		if #PID.GetActorsByType('tmpl') > 0 and #PID.GetActorsByType('nuclear.proxy') == 0 then
			Actor.Create("nuclear.proxy", true, { Owner = PID })
			Media.PlaySound("Eva-PreppingNuke.aud")
			Media.DisplayMessage("Preparing nuclear missile.", "EVA", HSLColor.FromHex("00FF00"))
		elseif #PID.GetActorsByType('tmpl') == 0 then
			Utils.Do(PID.GetActorsByType('nuclear.proxy'),function(UID)
				UID.Destroy()
			end)
		end
	end)
    -- if GrantPlayerNuke == false then
      -- local tmpl = Nod.GetActorsByType('tmpl')
      -- if #tmpl > 0 then
        -- GrantPlayerNuke = true
        -- Actor.Create("nuclear.proxy", true, { Owner = Nod })
        -- Media.PlaySound("Eva-PreppingNuke.aud")
        -- Media.DisplayMessage("Preparing nuclear missile.", "EVA", HSLColor.FromHex("00FF00"))
      -- end
    -- end
    
    -- if GrantPlayerNuke == true then
      -- local tmpl = Nod.GetActorsByType('tmpl')
      -- if #tmpl == 0 then
        -- GrantPlayerNuke = false
        -- local nukestrike = Nod.GetActorsByType('nuclear.proxy')
        -- nukestrike[1].Destroy()
      -- end
    -- end
  end
end

OncePerThreeSecondChecks = function()
	if DateTime.GameTime > 1 and DateTime.GameTime % 75 == 0 then
  
    -- if PlayerCanLose == true and HasOneOf(Nod, LossCheckAll) == false then
      -- PlayerFailMission()
    -- end
	
	if PlayerCanLose == true then
		TibAltCoopLossCheck()
	end

    --manipulate AI funds
    ManipulatePlayerFunds(GDI)
    ManipulatePlayerFunds(SubGDI)
    
    ControlAircraft(SubGDI)
	end
end


PlayerFailMission = function()
  if CaptureEyeObjective ~= nil and not Nod.IsObjectiveCompleted(CaptureEyeObjective) then
    Nod.MarkFailedObjective(CaptureEyeObjective)
  end
end