
ETownAttacked = false
CabalAwakened = false
CommsDestroyed = { false, false, false, false, false }
LaunchedEliteCyborgAttack = false
PrisonersFreed = false

ActorRemovals =
{
  easy = { EZR1, EZR2, EZR3, EZR4, EZR5, EZR6, EZR7, EZR8, EZR9 },
  normal = { },
  hard = { Truck1, Truck2 },
}


-- Cabal Attack Production Behavior -----

AwakenCabal = function()
  if CabalAwakened == true then return end
  CabalAwakened = true
  local delays = { easy = 240, normal = 180, hard = 120 }
  
  Trigger.AfterDelay(DateTime.Seconds(delays[Difficulty]), function()
    CabalInfantryAttackProduction()
    CabalVehicleAttackProduction()
    
    Cabal2InfantryAttackProduction()
    Cabal2VehicleAttackProduction()
    
    Cabal3InfantryAttackProduction()
    Cabal3VehicleAttackProduction()
    
    Trigger.AfterDelay(CabalAirAttackDelayMin[Difficulty] * 2, CabalAirAttackProduction)
    CabalCyborgProduction()
  end)
  
  Media.PlaySound("CabalM1601.aud")
  Media.DisplayMessage("Ah, welcome, Commander. Let the slaughter carnival begin.", "Cabal", HSLColor.FromHex("AE18B8"))
end

CabalAttackDelayMin = { easy = DateTime.Seconds(80), normal = DateTime.Seconds(50), hard = DateTime.Seconds(40) }
CabalAttackDelayMax = { easy = DateTime.Seconds(120), normal = DateTime.Seconds(80), hard = DateTime.Seconds(50) }

CabalAirAttackDelayMin = { easy = DateTime.Seconds(300), normal = DateTime.Seconds(270), hard = DateTime.Seconds(240) }
CabalAirAttackDelayMax = { easy = DateTime.Seconds(360), normal = DateTime.Seconds(300), hard = DateTime.Seconds(270) }


CabalAttackPaths = {
  { CabalAtkPath1A.Location, CabalAtkPath1B.Location, GDIShow2.Location },
  { CabalAtkPath2A.Location, CabalAtkPath2B.Location, GDIShow2.Location },
}

CabalAttackAirTypes = {
  easy = {
     { "heli", },
  },
  normal = {
     { "heli" },
  },
  hard = {
     { "heli" },
  }
}

CabalAttackVehicleTypes = {
  easy = {
     { "bggy", "bggy", "bggy", "bike", "bike" },
     { "ltnk", "ltnk", "ltnk", "arty", "arty" },
     { "ftnk", "ftnk", "ftnk", "arty", "arty" },
     { "ltnk", "ltnk", "ltnk", "ftnk", "ftnk" },
  },
  normal = {
     { "ltnk", "ltnk", "ltnk", "arty", "arty", "arty" },
     { "ftnk", "ftnk", "ftnk", "arty", "arty", "arty" },
     { "ltnk", "ltnk", "ltnk", "ftnk", "ftnk", "ftnk" },
     { "ltnk", "ltnk", "ftnk", "ftnk", "arty", "arty" },
  },
  hard = {
     { "ltnk", "ltnk", "ltnk", "ltnk", "arty", "arty", "arty" },
     { "ftnk", "ftnk", "ftnk", "ftnk", "arty", "arty", "arty" },
     { "ltnk", "ltnk", "ltnk", "ftnk", "ftnk", "ftnk", "ltnk" },
     { "ltnk", "ltnk", "ftnk", "ftnk", "arty", "arty", "arty" },
  }
}

CabalAttackInfantryTypes = {
  easy = {
     { "cyborg", "cyborg", "cyborg", "cyborg", "cyborg" },
     { "cyborg", "cyborg", "cyborg", "cyborg", "cyborg" },
     { "cybcmdo" },
  },
  normal = {
     { "cyborg", "cyborg", "cyborg", "cyborg", "cyborg", "cyborg", "cyborg", "cyborg" },
     { "cyborg", "cyborg", "cyborg", "cyborg", "cyborg", "cyborg", "cyborg", "cyborg" },
     { "cybcmdo", "cybcmdo" },
     { "cybcmdo", "cyborg", "cyborg", "cyborg", "cyborg", "cyborg", "cyborg", "cyborg" },
  },
  hard = {
     { "cyborg", "cyborg", "cyborg", "cyborg", "cyborg", "cyborg", "cyborg", "cyborg", "cyborg", "cyborg" },
     { "cyborg", "cyborg", "cyborg", "cyborg", "cyborg", "cyborg", "cyborg", "cyborg", "cyborg", "cyborg" },
     { "cybcmdo", "cybcmdo", "cybcmdo" },
     { "cybcmdo", "cyborg", "cyborg", "cyborg", "cyborg", "cyborg", "cyborg", "cyborg", "cyborg", "cyborg" },
  }
}

Cabal23AttackInfantryTypes = {
  easy = { { "cyborg", "cyborg", "cyborg", "cyborg", "cyborg" }, },
  normal = { { "cyborg", "cyborg", "cyborg", "cyborg", "cyborg", "cyborg", "cyborg", "cyborg" }, },
  hard = { { "cyborg", "cyborg", "cyborg", "cyborg", "cyborg", "cyborg", "cyborg", "cyborg", "cyborg", "cyborg" }, }
}

CabalInfantryAttackProduction = function()
  local production = Utils.Random(CabalAttackInfantryTypes[Difficulty])
  local path = Utils.Random(CabalAttackPaths)
  local toBuild = function() return production end
  local factory = GetAvailableFactory(Cabal, 'hand')
  
  if factory ~= nil then
    ProduceUnits(Cabal, factory, nil, toBuild, function(units)
      UpdatePlayerBaseLocation()
      Utils.Do(units, function(unit)
        ErrorGuardAttackPatrol(unit, path)
        AssaultPlayerBaseOrHunt(unit)
      end)
      Trigger.AfterDelay(Utils.RandomInteger(CabalAttackDelayMin[Difficulty], CabalAttackDelayMax[Difficulty]), CabalInfantryAttackProduction)
    end)
  else
    Trigger.AfterDelay(Utils.RandomInteger(CabalAttackDelayMin[Difficulty], CabalAttackDelayMax[Difficulty]), CabalInfantryAttackProduction)
  end
end

CabalVehicleAttackProduction = function()
  local production = Utils.Random(CabalAttackVehicleTypes[Difficulty])
  local path = Utils.Random(CabalAttackPaths)
  local toBuild = function() return production end
  local factory = GetAvailableFactory(Cabal, 'afld')
  
  if factory ~= nil then
    ProduceUnits(Cabal, factory, nil, toBuild, function(units)
      UpdatePlayerBaseLocation()
      Utils.Do(units, function(unit)
        ErrorGuardAttackPatrol(unit, path)
        AssaultPlayerBaseOrHunt(unit)
      end)
      Trigger.AfterDelay(Utils.RandomInteger(CabalAttackDelayMin[Difficulty], CabalAttackDelayMax[Difficulty]), CabalInfantryAttackProduction)
    end)
  else
    Trigger.AfterDelay(Utils.RandomInteger(CabalAttackDelayMin[Difficulty], CabalAttackDelayMax[Difficulty]), CabalInfantryAttackProduction)
  end
end

CabalAirAttackProduction = function()
  local production = Utils.Random(CabalAttackAirTypes[Difficulty])
  local factories = Cabal.GetActorsByType('hpad')
  local cabalAirMax = 6
  
  if #factories > 0 then
    Utils.Do(factories, function(factory)
      local cabalHelis = Cabal.GetActorsByType('heli')
      if #cabalHelis < cabalAirMax then
        Reinforcements.Reinforce(Cabal, production, { factory.Location }, 30, function(unit)
          --
        end)
      end
    end)
  end
  Trigger.AfterDelay(Utils.RandomInteger(CabalAirAttackDelayMin[Difficulty], CabalAirAttackDelayMax[Difficulty]), CabalAirAttackProduction)
end

Cabal2InfantryAttackProduction = function()
  local production = Utils.Random(Cabal23AttackInfantryTypes[Difficulty])
  local path = { CabalAtkPath1B.Location, GDIShow2.Location }
  local toBuild = function() return production end
  local factory = GetAvailableFactory(Cabal2, 'hand')
  
  if factory ~= nil then
    ProduceUnits(Cabal2, factory, nil, toBuild, function(units)
      UpdatePlayerBaseLocation()
      Utils.Do(units, function(unit)
        ErrorGuardAttackPatrol(unit, path)
        AssaultPlayerBaseOrHunt(unit)
      end)
      Trigger.AfterDelay(Utils.RandomInteger(CabalAttackDelayMin[Difficulty], CabalAttackDelayMax[Difficulty]), Cabal2InfantryAttackProduction)
    end)
  else
    Trigger.AfterDelay(Utils.RandomInteger(CabalAttackDelayMin[Difficulty], CabalAttackDelayMax[Difficulty]), Cabal2InfantryAttackProduction)
  end
end

Cabal2VehicleAttackProduction = function()
  local production = Utils.Random(CabalAttackVehicleTypes[Difficulty])
  local path = { CabalAtkPath1B.Location, GDIShow2.Location }
  local toBuild = function() return production end
  local factory = GetAvailableFactory(Cabal2, 'afld')
  
  if factory ~= nil then
    ProduceUnits(Cabal2, factory, nil, toBuild, function(units)
      Utils.Do(units, function(unit)
        ErrorGuardAttackPatrol(unit, path)
        if unit.Type ~= 'harv' then unit.Hunt() end
      end)
      Trigger.AfterDelay(Utils.RandomInteger(CabalAttackDelayMin[Difficulty], CabalAttackDelayMax[Difficulty]), Cabal2VehicleAttackProduction)
    end)
  else
    Trigger.AfterDelay(Utils.RandomInteger(CabalAttackDelayMin[Difficulty], CabalAttackDelayMax[Difficulty]), Cabal2VehicleAttackProduction)
  end
end

Cabal3InfantryAttackProduction = function()
  local production = Utils.Random(Cabal23AttackInfantryTypes[Difficulty])
  local path = { CabalAtkPath2B.Location, GDIShow2.Location }
  local toBuild = function() return production end
  local factory = GetAvailableFactory(Cabal3, 'hand')
  
  if factory ~= nil then
    ProduceUnits(Cabal3, factory, nil, toBuild, function(units)
      UpdatePlayerBaseLocation()
      Utils.Do(units, function(unit)
        ErrorGuardAttackPatrol(unit, path)
        AssaultPlayerBaseOrHunt(unit)
      end)
      Trigger.AfterDelay(Utils.RandomInteger(CabalAttackDelayMin[Difficulty], CabalAttackDelayMax[Difficulty]), Cabal3InfantryAttackProduction)
    end)
  else
    Trigger.AfterDelay(Utils.RandomInteger(CabalAttackDelayMin[Difficulty], CabalAttackDelayMax[Difficulty]), Cabal3InfantryAttackProduction)
  end
end

Cabal3VehicleAttackProduction = function()
  local production = Utils.Random(CabalAttackVehicleTypes[Difficulty])
  local path = { CabalAtkPath2B.Location, GDIShow2.Location }
  local toBuild = function() return production end
  local factory = GetAvailableFactory(Cabal3, 'afld')
  
  if factory ~= nil then
    ProduceUnits(Cabal3, factory, nil, toBuild, function(units)
      Utils.Do(units, function(unit)
        ErrorGuardAttackPatrol(unit, path)
        if unit.Type ~= 'harv' then unit.Hunt() end
      end)
      Trigger.AfterDelay(Utils.RandomInteger(CabalAttackDelayMin[Difficulty], CabalAttackDelayMax[Difficulty]), Cabal3VehicleAttackProduction)
    end)
  else
    Trigger.AfterDelay(Utils.RandomInteger(CabalAttackDelayMin[Difficulty], CabalAttackDelayMax[Difficulty]), Cabal3VehicleAttackProduction)
  end
end

-- End Cabal Attack Production Behavior -----

CabalCyborgProduction = function()
  local cyborgProduction = Cabal.GetActorsByTypes( {'hosp', 'bio'} )
  if #cyborgProduction < 2 then return end

  local sacrifices = Map.ActorsInBox(CybProdNW.CenterPosition, CybProdSE.CenterPosition, function(a)
    return (a.Owner == Neutral and a.Type ~= 'waypoint') or (a.Owner == GDI and a.Type == 'e1')
  end)
  if #sacrifices == 0 then return end
  
  if #sacrifices > 0 then
    local sacrifice = sacrifices[1]
    sacrifice.Move(CybProdMoveTo.Location)
    
    sacrifice.CallFunc(function()
      local flare1 = Actor.Create("flare", true, { Owner = Cabal, Location = Flare1.Location })
      local flare2 = Actor.Create("flare", true, { Owner = Cabal, Location = Flare2.Location })
      
      Trigger.AfterDelay(DateTime.Seconds(15), function()
        flare1.Destroy()
        flare2.Destroy()
      end)
      
      Media.PlaySound("Valve.aud")
      
      Trigger.AfterDelay(DateTime.Seconds(5), function()
        Media.PlaySound("DeathScream" .. Utils.RandomInteger(1,4) .. ".aud")
      end)
      
      Trigger.AfterDelay(DateTime.Seconds(10), function()
        Media.PlaySound("22-i006.aud")
        local newCyborg = Actor.Create("elitecyb", true, { Owner = Cabal2, Location = CybProdSpawn.Location })
        newCyborg.Move(CybProdStage.Location)
      end)
    end)
    
    sacrifice.Destroy()
  end
  
  local delays = { easy = 60, normal = 45, hard = 30 }
  Trigger.AfterDelay(DateTime.Seconds(delays[Difficulty]), CabalCyborgProduction)
end


WorldLoaded = function()
  Nod = Player.GetPlayer("Nod")
  GDI = Player.GetPlayer("GDI")
  Cabal = Player.GetPlayer("Cabal")
  Cabal2 = Player.GetPlayer("Cabal2")
  Cabal3 = Player.GetPlayer("Cabal3")
  TibLife = Player.GetPlayer("TibLife")
  Civilians = Player.GetPlayer("Civilians")
  InertCabal = Player.GetPlayer("InertCabal")
  Neutral = Player.GetPlayer("Neutral")
  
  MissionPlayer = Nod

	BadGuy = Player.GetPlayer("BadGuy")

	coopInfo =
	{
		Mainplayer = Nod,
		MainEnemies = {Cabal, Cabal2, Cabal3},
		Dummyplayer = BadGuy
	}
	
	ORAMod = "tibalt"
	CoopInit25(coopInfo)
	
	AssignToCoopPlayers(Nod.GetActorsByType("e6"), nil, true)


  Camera.Position = StartCam.CenterPosition
  
  --Remove actors based on difficulty
  Utils.Do(ActorRemovals[Difficulty], function(unit)
    unit.Destroy()
  end)
  
  --Special lighting
  Lighting.Ambient = 0.85
  Lighting.Red = 1.1
  Lighting.Blue = 1.05
  Lighting.Green = 1.0
  
  --Special lighting
  
  --Player Reinforcements
  Trigger.OnKilled(Comm1, function(self, killer) CommsDestroyed[1] = true end)
  Trigger.OnKilled(Comm2, function(self, killer) CommsDestroyed[2] = true end)
  Trigger.OnKilled(Comm3, function(self, killer) CommsDestroyed[3] = true end)
  Trigger.OnKilled(Comm4, function(self, killer) CommsDestroyed[4] = true end)
  Trigger.OnKilled(Comm5, function(self, killer) CommsDestroyed[5] = true end)

  Trigger.OnEnteredProximityTrigger(Comm1.CenterPosition, WDist.New(3 * 1024), function(a, id)
    if IsOwnedByCoopPlayer(a) and a.Type == 'huey' then
      Trigger.RemoveProximityTrigger(id)
      if CommsDestroyed[1] == false then
        local cyborgs = Map.ActorsInBox(InertCyb1NW.CenterPosition, InertCyb1SE.CenterPosition, function(a)
          return a.Owner == InertCabal
        end)
        Utils.Do(cyborgs, function(cyborg) cyborg.Owner = BadGuy end)
        Media.DisplayMessage("Virus injected into system. Cyborgs brought under your control.", "EVA", HSLColor.FromHex("00FF00"))
        Trigger.AfterDelay(DateTime.Seconds(5), AwakenCabal)
      end
    end
  end)
  
  Trigger.OnEnteredProximityTrigger(Comm2.CenterPosition, WDist.New(3 * 1024), function(a, id)
    if IsOwnedByCoopPlayer(a) and a.Type == 'huey' then
      Trigger.RemoveProximityTrigger(id)
      if CommsDestroyed[2] == false then
        local cyborgs = Map.ActorsInBox(InertCyb2NW.CenterPosition, InertCyb2SE.CenterPosition, function(a)
          return a.Owner == InertCabal
        end)
        Utils.Do(cyborgs, function(cyborg) cyborg.Owner = BadGuy end)
        Media.DisplayMessage("Virus injected into system. Cyborgs brought under your control.", "EVA", HSLColor.FromHex("00FF00"))
        Trigger.AfterDelay(DateTime.Seconds(5), AwakenCabal)
      end
    end
  end)
  
  Trigger.OnEnteredProximityTrigger(Comm3.CenterPosition, WDist.New(3 * 1024), function(a, id)
    if IsOwnedByCoopPlayer(a) and a.Type == 'huey' then
      Trigger.RemoveProximityTrigger(id)
      if CommsDestroyed[3] == false then
        local cyborgs = Map.ActorsInBox(InertCyb3NW.CenterPosition, InertCyb3SE.CenterPosition, function(a)
          return a.Owner == InertCabal
        end)
        Utils.Do(cyborgs, function(cyborg) cyborg.Owner = BadGuy end)
        Media.DisplayMessage("Virus injected into system. Cyborgs brought under your control.", "EVA", HSLColor.FromHex("00FF00"))
        Trigger.AfterDelay(DateTime.Seconds(5), AwakenCabal)
      end
    end
  end)
  
  Trigger.OnEnteredProximityTrigger(Comm4.CenterPosition, WDist.New(3 * 1024), function(a, id)
    if IsOwnedByCoopPlayer(a) and a.Type == 'huey' then
      Trigger.RemoveProximityTrigger(id)
      if CommsDestroyed[4] == false then
        local cyborgs = Cabal2.GetActorsByType('cyborg')
        Utils.Do(cyborgs, function(cyborg) cyborg.Owner = BadGuy end)
        Media.DisplayMessage("Virus injected into system. Cyborgs brought under your control.", "EVA", HSLColor.FromHex("00FF00"))
        Trigger.AfterDelay(DateTime.Seconds(5), AwakenCabal)
      end
    end
  end)
  
  Trigger.OnEnteredProximityTrigger(Comm5.CenterPosition, WDist.New(3 * 1024), function(a, id)
    if IsOwnedByCoopPlayer(a) and a.Type == 'huey' then
      Trigger.RemoveProximityTrigger(id)
      if CommsDestroyed[5] == false then
        local cyborgs = Cabal3.GetActorsByType('cyborg')
        Utils.Do(cyborgs, function(cyborg) cyborg.Owner = BadGuy end)
        Media.DisplayMessage("Virus injected into system. Cyborgs brought under your control.", "EVA", HSLColor.FromHex("00FF00"))
        Trigger.AfterDelay(DateTime.Seconds(5), AwakenCabal)
      end
    end
  end)
  
  Trigger.OnAllKilled( { SAM1, SAM2, SAM3, SAM4 }, function()
    Media.PlaySpeechNotification(GDI, "Reinforce")
    Reinforcements.ReinforceWithTransport(BadGuy, "tran.insertion", {"e5", "e5", "e5", "e5", "e5"}, { TranSpawn1.Location }, null, function(transport, cargo)
      transport.Move(TranLand1.Location)
      transport.UnloadPassengers()
      transport.Move(TranSpawn1.Location)
      transport.Destroy()
    end)
    
    Reinforcements.ReinforceWithTransport(BadGuy, "tran.insertion", {"e5", "e5", "e5", "e5", "e5"}, { TranSpawn2.Location }, null, function(transport, cargo)
      transport.Move(TranLand2.Location)
      transport.UnloadPassengers()
      transport.Move(TranSpawn2.Location)
      transport.Destroy()
    end)
  end)
  
  Utils.Do( {Hosp, Bio, Gate}, function(building)
    Trigger.OnKilled(building, function()
      if PrisonersFreed == false then
        PrisonersFreed = true
        
        local prisoners = Map.ActorsInBox(CybProdNW.CenterPosition, CybProdSE.CenterPosition, function(a)
          return (a.Owner == Neutral and a.Type ~= 'waypoint') or (a.Owner == GDI and a.Type == 'e1')
        end)
        
        if #prisoners > 0 then
          Media.DisplayMessage("There's an opening! Run for it!", "Prisoner", HSLColor.FromHex("AAAAAA"))
          Utils.Do(prisoners, function(prisoner)
            prisoner.Move(GDIShow1.Location)
			--prisoner.Owner = Nod
          end)
		  AssignToCoopPlayers(prisoners, nil, true)
        end
        
      end
    end)
  end)
  
  --Objectives
  InitObjectives(Nod)

  Trigger.AfterDelay(DateTime.Seconds(2), function()
    DestroyCabalObjective = Nod.AddObjective("Destroy Cabal's main data core.")
    CaptureGDIBaseObjective = Nod.AddObjective("Find and capture the GDI base.", "Secondary", false)
  end)
  
  Trigger.OnCapture(GDIFact, function(self, captor, oldOwner, newOwner)
    if IsOwnedByCoopPlayer(captor) then
		Utils.Do(CoopPlayers,function(PID)
			if PID ~= newOwner then
				local NewFact = Actor.Create(GDIFact.Type, true, { Owner = GDI, Location = GDIFact.Location })
				Trigger.AfterDelay(DateTime.Seconds(4),function()
					NewFact.Owner = PID
					NewFact.Deploy()
				end)
			end
		end)
      Nod.MarkCompletedObjective(CaptureGDIBaseObjective)
      local gdiUnits = GDI.GetActorsByTypes( {'mtnk', 'jeep'} )
      Utils.Do(gdiUnits, function(unit) unit.Owner = BadGuy end)
    end
  end)
  
  Trigger.OnKilled(Core, function(self, killer)
    Nod.MarkCompletedObjective(DestroyCabalObjective)
  end)
  
  --AI player behavior
  Cabal.Cash = 90000
  Cabal.Resources = Cabal.ResourceCapacity - 500
  SetupRefAndSilosCaptureCredits(Cabal)
  AutoReplaceHarvesters(Cabal)
  AutoRepairAndRebuildBuildings(Cabal, 15)
  
  Cabal2.Cash = 90000
  Cabal2.Resources = Cabal2.ResourceCapacity - 500
  SetupRefAndSilosCaptureCredits(Cabal2)
  AutoReplaceHarvesters(Cabal2)
  
  Cabal3.Cash = 90000
  Cabal3.Resources = Cabal3.ResourceCapacity - 500
  SetupRefAndSilosCaptureCredits(Cabal3)
  AutoReplaceHarvesters(Cabal3)
  
  --Enemy Predeployed Maneuvers
  Utils.Do( {ETownRvl1, ETownRvl2, ETownRvl3, ETownRvl4, ETownRvl5}, function(wp)
    Trigger.OnEnteredProximityTrigger(wp.CenterPosition, WDist.New(2 * 1024), function(a, id)
      if ETownAttacked == false and IsOwnedByCoopPlayer(a) and a.Type ~= 'camera' and a.Type ~= 'camera.small' then
        ETownAttacked = true
        Trigger.RemoveProximityTrigger(id)
        
        local camActor = Actor.Create("camera", true, { Owner = Nod, Location = ETownShow.Location })
        Trigger.AfterDelay(DateTime.Seconds(10), function() camActor.Destroy() end)
        
        Actor.Create("ftnk", true, { Owner = Cabal2, Location = ETownSpawn1.Location } )
        Actor.Create("elitecyb", true, { Owner = Cabal2, Location = ETownSpawn2.Location } )
        Actor.Create("elitecyb", true, { Owner = Cabal2, Location = ETownSpawn3.Location } )
      end
    end)
  end)

  Trigger.OnEnteredProximityTrigger(WTownRvl.CenterPosition, WDist.New(14 * 1024), function(a, id)
    if IsOwnedByCoopPlayer(a) and a.Type ~= 'camera' and a.Type ~= 'camera.small' then
      Trigger.RemoveProximityTrigger(id)
      
      local camActor = Actor.Create("camera", true, { Owner = Nod, Location = WTownRvl.Location })
      Trigger.AfterDelay(DateTime.Seconds(10), function() camActor.Destroy() end)
      
      Actor.Create("ftnk", true, { Owner = Cabal2, Location = WTownSpawn1.Location } )
      Actor.Create("ftnk", true, { Owner = Cabal2, Location = WTownSpawn2.Location } )
      Actor.Create("elitecyb", true, { Owner = Cabal2, Location = WTownSpawn3.Location } )
      Actor.Create("elitecyb", true, { Owner = Cabal2, Location = WTownSpawn4.Location } )
      Actor.Create("elitecyb", true, { Owner = Cabal2, Location = WTownSpawn5.Location } )
    end
  end)
  
  Trigger.OnEnteredProximityTrigger(CoreProx.CenterPosition, WDist.New(15 * 1024), function(a, id)
    if IsOwnedByCoopPlayer(a) and a.Type ~= 'camera' and a.Type ~= 'camera.small' then
      Trigger.RemoveProximityTrigger(id)
      
      local camActor1 = Actor.Create("camera", true, { Owner = Nod, Location = CoreProx.Location })
      Trigger.AfterDelay(DateTime.Seconds(10), function() camActor1.Destroy() end)
      local camActor2 = Actor.Create("camera", true, { Owner = Nod, Location = CoreShow1.Location })
      Trigger.AfterDelay(DateTime.Seconds(10), function() camActor2.Destroy() end)
      local camActor3 = Actor.Create("camera", true, { Owner = Nod, Location = CoreShow2.Location })
      Trigger.AfterDelay(DateTime.Seconds(10), function() camActor3.Destroy() end)
      
      local defenders = Cabal.GetActorsByType('coredef')
      Utils.Do(defenders, function(defender) defender.Hunt() end)
      
      Media.PlaySound("CabalM1602.aud")
      Media.DisplayMessage("Activating defense protocol: Defender, now.", "Cabal", HSLColor.FromHex("AE18B8"))
    end
  end)
  
  --Proximity Triggers/Reveals
  Trigger.OnEnteredProximityTrigger(ProxRvl1.CenterPosition, WDist.New(2 * 1024), function(a, id)
    if IsOwnedByCoopPlayer(a) and a.Type ~= 'camera' and a.Type ~= 'camera.small' then
      Trigger.RemoveProximityTrigger(id)
      local camActor = Actor.Create("camera", true, { Owner = Nod, Location = ProxShow1.Location })
      Trigger.AfterDelay(DateTime.Seconds(10), function() camActor.Destroy() end)
    end
  end)
  
  Trigger.OnEnteredProximityTrigger(ProxRvl2.CenterPosition, WDist.New(2 * 1024), function(a, id)
    if IsOwnedByCoopPlayer(a) and a.Type ~= 'camera' and a.Type ~= 'camera.small' then
      Trigger.RemoveProximityTrigger(id)
      local camActor = Actor.Create("camera", true, { Owner = Nod, Location = ProxShow2.Location })
      Trigger.AfterDelay(DateTime.Seconds(10), function() camActor.Destroy() end)
    end
  end)
  
  Trigger.OnEnteredProximityTrigger(ProxRvl3.CenterPosition, WDist.New(2 * 1024), function(a, id)
    if IsOwnedByCoopPlayer(a) and a.Type ~= 'camera' and a.Type ~= 'camera.small' then
      Trigger.RemoveProximityTrigger(id)
      local camActor = Actor.Create("camera", true, { Owner = Nod, Location = ProxShow3.Location })
      Trigger.AfterDelay(DateTime.Seconds(10), function() camActor.Destroy() end)
    end
  end)

  Trigger.OnEnteredProximityTrigger(GDIRvl1.CenterPosition, WDist.New(3 * 1024), function(a, id)
    if IsOwnedByCoopPlayer(a) and a.Type ~= 'camera' and a.Type ~= 'camera.small' then
      Trigger.RemoveProximityTrigger(id)
      local camActor1 = Actor.Create("camera", true, { Owner = Nod, Location = GDIShow1.Location })
      Trigger.AfterDelay(DateTime.Seconds(10), function() camActor1.Destroy() end)
      local camActor2 = Actor.Create("camera", true, { Owner = Nod, Location = GDIShow2.Location })
      Trigger.AfterDelay(DateTime.Seconds(10), function() camActor2.Destroy() end)
    end
  end)
  
  Trigger.OnEnteredProximityTrigger(GDIRvl2.CenterPosition, WDist.New(3 * 1024), function(a, id)
    if IsOwnedByCoopPlayer(a) and a.Type ~= 'camera' and a.Type ~= 'camera.small' then
      Trigger.RemoveProximityTrigger(id)
      local camActor1 = Actor.Create("camera", true, { Owner = Nod, Location = GDIShow1.Location })
      Trigger.AfterDelay(DateTime.Seconds(10), function() camActor1.Destroy() end)
      local camActor2 = Actor.Create("camera", true, { Owner = Nod, Location = GDIShow2.Location })
      Trigger.AfterDelay(DateTime.Seconds(10), function() camActor2.Destroy() end)
    end
  end)
  
  --Timer
  
  --Crate spawns
  if Difficulty ~= 'hard' then
    Trigger.OnKilled(Truck1, function(self, killer)
      Actor.Create("moneycrate", true, { Owner = Nod, Location = Truck1.Location })
    end)
    Trigger.OnKilled(Truck2, function(self, killer)
      Actor.Create("moneycrate", true, { Owner = Nod, Location = Truck2.Location })
    end)
  end
  
  --Taunts
  --Trigger.AfterDelay(DateTime.Seconds(60), function()
  --  Media.DisplayMessage("You have been marked for termination.", "Cabal", HSLColor.FromHex("AE18B8"))
  --end)
  
  --Testing
end


Tick = function()
	OncePerSecondChecks()
	OncePerThreeSecondChecks()
end

OncePerSecondChecks = function()
  if DateTime.GameTime > 1 and DateTime.GameTime % 25 == 0 then
    --none
  end
end

OncePerThreeSecondChecks = function()
	if DateTime.GameTime > 1 and DateTime.GameTime % 75 == 0 then
  
    --[[if HasOneOf(Nod, LossCheckAll) == false then
      PlayerFailMission()
    end]]
	TibAltCoopLossCheck()

    if CabalAwakened == false then
      local playerBuildings = {}
      Utils.Do(CoopPlayers,function(PID)
		Utils.Do(PID.GetActorsByTypes( {'fact', 'proc', 'pyle', 'weap', 'hand', 'afld', 'hpad'} ),function(UID)
			table.insert(playerBuildings,UID)
		end)
	  end)
	  if #playerBuildings > 0 then AwakenCabal() end
    end
    
    if LaunchedEliteCyborgAttack == false then
      local eliteCyborgs = Cabal.GetActorsByType( 'elitecyb' )
      if #eliteCyborgs >= 40 then
        LaunchedEliteCyborgAttack = true
        
        Media.PlaySound("CabalTermination.aud")
        Media.DisplayMessage("You have been marked for termination.", "Cabal", HSLColor.FromHex("AE18B8"))
        
        local path = Utils.Random(CabalAttackPaths)
        Utils.Do(eliteCyborgs, function(unit)
          unit.Patrol(path, false)
          AssaultPlayerBaseOrHunt(unit)
        end)
      end
    end
    
    --manipulate AI funds
    ManipulatePlayerFunds(Cabal)
    ManipulatePlayerFunds(Cabal2)
    ManipulatePlayerFunds(Cabal3)
    
    ControlAircraft(Cabal)
	end
end


PlayerFailMission = function()
  if DestroyCabalObjective ~= nil and not Nod.IsObjectiveCompleted(DestroyCabalObjective) then
    Nod.MarkFailedObjective(DestroyCabalObjective)
  end
  if CaptureGDIBaseObjective ~= nil and not Nod.IsObjectiveCompleted(CaptureGDIBaseObjective) then
    Nod.MarkFailedObjective(CaptureGDIBaseObjective)
  end
end