
AirstrikeGranted = false
StopOffboardAttacks = false

OffboardAttackInterval = { easy = 180, normal = 120, hard = 90 }


ActorRemovals =
{
  easy = { EZR1 },
  normal = { },
  hard = { HDR1, HDR2, HDR3 },
}


-- Cabal Attack Production Behavior -----

CabalAttackDelayMin = { easy = DateTime.Seconds(60), normal = DateTime.Seconds(45), hard = DateTime.Seconds(30) }
CabalAttackDelayMax = { easy = DateTime.Seconds(90), normal = DateTime.Seconds(60), hard = DateTime.Seconds(45) }

CabalAirAttackDelayMin = { easy = DateTime.Seconds(180), normal = DateTime.Seconds(150), hard = DateTime.Seconds(150) }
CabalAirAttackDelayMax = { easy = DateTime.Seconds(240), normal = DateTime.Seconds(180), hard = DateTime.Seconds(180) }


CabalAttackPaths = {
  { CabalAtkPath1.Location, GDIBase.Location },
  { CabalAtkPath2.Location, GDIBase.Location },
}

CabalAttackAirTypes = {
  easy = {
     { "heli" },
  },
  normal = {
     { "heli", "heli" },
  },
  hard = {
     { "heli", "heli" },
  }
}

CabalAttackVehicleTypes = {
  easy = {
     { "bggy", "bggy", "bggy", "bike", "bike" },
     { "ltnk", "ltnk", "ltnk", "arty", "arty" },
     { "ftnk", "ftnk", "ftnk", "arty", "arty" },
     { "ltnk", "ltnk", "ltnk", "ftnk", "ftnk" },
  },
  normal = {
     { "bggy", "bggy", "bggy", "bike", "bike", "bike" },
     { "ltnk", "ltnk", "ltnk", "arty", "arty", "arty" },
     { "ftnk", "ftnk", "ftnk", "arty", "arty", "arty" },
     { "ltnk", "ltnk", "ltnk", "ftnk", "ftnk", "ftnk" },
     { "ltnk", "ltnk", "ftnk", "ftnk", "arty", "arty" },
  },
  hard = {
     { "ltnk", "ltnk", "ltnk", "ltnk", "arty", "arty", "arty" },
     { "ftnk", "ftnk", "ftnk", "ftnk", "arty", "arty", "arty" },
     { "ltnk", "ltnk", "ltnk", "ftnk", "ftnk", "ftnk", "ltnk" },
     { "ltnk", "ltnk", "ftnk", "ftnk", "arty", "arty", "arty" },
  }
}

CabalAttackInfantryTypes = {
  easy = {
     { "cyborg", "cyborg", "cyborg", "cyborg", "cyborg" },
     { "cyborg", "cyborg", "cyborg", "cyborg", "cyborg" },
  },
  normal = {
     { "cyborg", "cyborg", "cyborg", "cyborg", "cyborg", "cyborg", "cyborg", "cyborg" },
     { "cyborg", "cyborg", "cyborg", "cyborg", "cyborg", "cyborg", "cyborg", "cyborg" },
     { "elitecyb", "elitecyb", "elitecyb", "elitecyb", "elitecyb" },
  },
  hard = {
     { "cyborg", "cyborg", "cyborg", "cyborg", "cyborg", "cyborg", "cyborg", "cyborg", "cyborg", "cyborg" },
     { "cyborg", "cyborg", "cyborg", "cyborg", "cyborg", "cyborg", "cyborg", "cyborg", "cyborg", "cyborg" },
     { "elitecyb", "elitecyb", "elitecyb", "elitecyb", "elitecyb", "elitecyb", "elitecyb" },
  }
}

CabalInfantryAttackProduction = function()
  local production = Utils.Random(CabalAttackInfantryTypes[Difficulty])
  local path = Utils.Random(CabalAttackPaths)
  local toBuild = function() return production end
  local factory = GetAvailableFactory(Cabal, 'hand')
  
  if factory ~= nil then
    ProduceUnits(Cabal, factory, nil, toBuild, function(units)
      Utils.Do(units, function(unit)
        ErrorGuardAttackPatrol(unit, path)
        unit.Hunt()
      end)
      Trigger.AfterDelay(Utils.RandomInteger(CabalAttackDelayMin[Difficulty], CabalAttackDelayMax[Difficulty]), CabalInfantryAttackProduction)
    end)
  else
    Trigger.AfterDelay(Utils.RandomInteger(CabalAttackDelayMin[Difficulty], CabalAttackDelayMax[Difficulty]), CabalInfantryAttackProduction)
  end
end

CabalVehicleAttackProduction = function()
  local production = Utils.Random(CabalAttackVehicleTypes[Difficulty])
  local path = Utils.Random(CabalAttackPaths)
  local toBuild = function() return production end
  local factory = GetAvailableFactory(Cabal, 'afld')
  
  if factory ~= nil then
    ProduceUnits(Cabal, factory, nil, toBuild, function(units)
      local behavior = Utils.RandomInteger(1,2)
      
      if behavior == 1 then
        Utils.Do(units, function(unit)
          ErrorGuardAttackPatrol(unit, path)
          if unit.Type ~= 'harv' then unit.Hunt() end
        end)
      else
        Utils.Do(units, function(unit)
          if unit.Type == 'arty' then
            unit.AttackMove(CabalAtkPath1.Location)
            unit.AttackMove(AttackOverlook.Location)
          else
            ErrorGuardAttackPatrol(unit, path)
            if unit.Type ~= 'harv' then unit.Hunt() end
          end
        end)
      end
    
      Trigger.AfterDelay(Utils.RandomInteger(CabalAttackDelayMin[Difficulty], CabalAttackDelayMax[Difficulty]), CabalVehicleAttackProduction)
    end)
  else
    Trigger.AfterDelay(Utils.RandomInteger(CabalAttackDelayMin[Difficulty], CabalAttackDelayMax[Difficulty]), CabalVehicleAttackProduction)
  end
end

CabalAirAttackProduction = function()
  local production = Utils.Random(CabalAttackAirTypes[Difficulty])
  local factories = Cabal.GetActorsByType('hpad')
  local cabalAirMax = 6
  
  if #factories > 0 then
    Utils.Do(factories, function(factory)
      local cabalHelis = Cabal.GetActorsByType('heli')
      if #cabalHelis < cabalAirMax then
        Reinforcements.Reinforce(Cabal, production, { factory.Location }, 30, function(unit)
          --
        end)
      end
    end)
  end
  Trigger.AfterDelay(Utils.RandomInteger(CabalAirAttackDelayMin[Difficulty], CabalAirAttackDelayMax[Difficulty]), CabalAirAttackProduction)
end

-- End Cabal Attack Production Behavior -----


-- Cabal Offboard Attacks -----

CabalOffboardAttackPaths = {
  { CabalRMoveTo.Location, CabalAtkPath1.Location, GDIBase.Location },
  { CabalRMoveTo.Location, CabalAtkPath2.Location, GDIBase.Location },
}

LaunchOffboardAttack = function()
  if StopOffboardAttacks == true then return end
  
  Media.PlaySound("Eva-EnemyReinforcements.aud")
  local attackers = Utils.Random(CabalAttackVehicleTypes[Difficulty])
  local path = Utils.Random(CabalOffboardAttackPaths)
  
  Reinforcements.Reinforce(Cabal, attackers, { CabalRSpawn.Location }, 30, function(unit)
    unit.Patrol(path, false)
    unit.Hunt()
  end)
  
  Trigger.AfterDelay(DateTime.Seconds(OffboardAttackInterval[Difficulty]), LaunchOffboardAttack)
end

-- End Cabal Offboard Attacks -----


CheckDestroyedSams = function()
  local sams = SubCabal.GetActorsByType('sam')
	if #sams == 0 then
    AirstrikeGranted = true
    GDI.MarkCompletedObjective(DestroySamsObjective)
    Trigger.AfterDelay(DateTime.Seconds(5), function()
      Actor.Create("airstrike.proxy", true, { Owner = GDI })
      Media.DisplayMessage("A10 wing ready to commence airstrikes.", "EVA", HSLColor.FromHex("00FF00"))
    end)
  end
end


WorldLoaded = function()
  GDI = Player.GetPlayer("GDI")
  Cabal = Player.GetPlayer("Cabal")
  SubCabal = Player.GetPlayer("SubCabal")
  Neutral = Player.GetPlayer("Neutral")
  
  MissionPlayer = GDI

	GoodGuy = Player.GetPlayer("GoodGuy")

	coopInfo =
	{
		Mainplayer = GDI,
		MainEnemies = {Cabal, SubCabal},
		Dummyplayer = GoodGuy
	}
	
	ORAMod = "tibalt"
	CoopInit25(coopInfo)
	
	BaseShared = true
	TechShared = true
	MoneyShareOverride = 100

  Camera.Position = StartCam.CenterPosition
  
  local startingFunds = { easy = 5000, normal = 2500, hard = 1000 }
  Utils.Do(CoopPlayers,function(PID)
	PID.Cash = (startingFunds[Difficulty] / #CoopPlayers)
  end)
  
  --Remove actors based on difficulty
  Utils.Do(ActorRemovals[Difficulty], function(unit)
    unit.Destroy()
  end)
  
  if Difficulty == 'easy' then
    local stanks = Cabal.GetActorsByType('stnk')
    Utils.Do(stanks, function(stank) stank.Destroy() end)
  end
  
  --Special lighting
  
  --Player Reinforcements
    
  --Objectives
  InitObjectives(GDI)

  Trigger.AfterDelay(DateTime.Seconds(2), function()
    SurviveObjective = GDI.AddObjective("Hold out until reinforcements arrive.")
    DestroyCabalObjective = GDI.AddObjective("Destroy the attacking Nod forces.")
    ProtectScientistsObjective = GDI.AddObjective("Protect the research scientists.")
    ProtectExosuitsObjective = GDI.AddObjective("At least one exosuit prototype must survive.")
    DestroySamsObjective = GDI.AddObjective("Destroy all outer (blue) SAMs for air support.", "Secondary", false)
  end)
  
  --AI player behavior
  Cabal.Cash = 90000
  Cabal.Resources = Cabal.ResourceCapacity - 500
  SetupRefAndSilosCaptureCredits(Cabal)
  AutoReplaceHarvesters(Cabal)
  AutoRepairAndRebuildBuildings(Cabal, 15)
  
  Trigger.AfterDelay(Utils.RandomInteger(CabalAttackDelayMin[Difficulty], CabalAttackDelayMax[Difficulty]), function()
    CabalVehicleAttackProduction()
    CabalInfantryAttackProduction()
    CabalAirAttackProduction()
  end)

  --Enemy Predeployed Maneuvers
  LaunchOffboardAttack()
  
  if Difficulty ~= 'easy' then
    Trigger.AfterDelay(DateTime.Seconds(600), function()
      Reinforcements.ReinforceWithTransport(Cabal, "apc", {"elitecyb", "elitecyb", "elitecyb", "elitecyb", "elitecyb"}, { CabalRSpawn.Location }, null, function(transport, cargo)
        transport.Move(CabalRMoveTo.Location)
        transport.Move(CabalAtkPath1.Location)
        transport.Move(GDIBase.Location, 1024 * 2)
        transport.UnloadPassengers()
        transport.CallFunc(function()
          Trigger.AfterDelay(DateTime.Seconds(1), function()
            Utils.Do(cargo, function(unit) unit.Hunt() end)
          end)
        end)
      end)
      
      Reinforcements.ReinforceWithTransport(Cabal, "apc", {"elitecyb", "elitecyb", "elitecyb", "elitecyb", "elitecyb"}, { CabalRSpawn.Location }, null, function(transport, cargo)
        transport.Move(CabalRMoveTo.Location)
        transport.Move(CabalAtkPath2.Location)
        transport.Move(GDIBase.Location, 1024 * 2)
        transport.UnloadPassengers()
        transport.CallFunc(function()
          Trigger.AfterDelay(DateTime.Seconds(1), function()
            Utils.Do(cargo, function(unit) unit.Hunt() end)
          end)
        end)
      end)
    end)
  end
  
  --stop the normal offboard reinforcements 17 minutes in; then 17.5 minutes in, a big final push
  Trigger.AfterDelay(DateTime.Seconds(1020), function() StopOffboardAttacks = true end)
  Trigger.AfterDelay(DateTime.Seconds(1050), function()
    local finalPush = {
      easy = {
                'ltnk', 'ltnk', 'ltnk', 'ltnk', 'ltnk', 'ltnk', 'ltnk', 'ltnk',
                'elitecyb', 'elitecyb', 'elitecyb', 'elitecyb', 'elitecyb', 'elitecyb',
                'elitecyb', 'elitecyb', 'elitecyb', 'elitecyb', 'elitecyb', 'elitecyb',
                'arty', 'arty', 'arty', 'arty', 'arty', 'arty'
             },
      normal = {
                'ltnk', 'ltnk', 'ltnk', 'ltnk', 'ltnk', 'ltnk', 'ltnk', 'ltnk', 'ltnk', 'ltnk',
                'elitecyb', 'elitecyb', 'elitecyb', 'elitecyb', 'elitecyb', 'elitecyb', 'elitecyb', 'elitecyb',
                'elitecyb', 'elitecyb', 'elitecyb', 'elitecyb', 'elitecyb', 'elitecyb', 'elitecyb', 'elitecyb',
                'arty', 'arty', 'arty', 'arty', 'arty', 'arty', 'arty', 'arty'
               },
      hard = {
                'ltnk', 'ltnk', 'ltnk', 'ltnk', 'ltnk', 'ltnk', 'ltnk', 'ltnk', 'ltnk', 'ltnk', 'ltnk', 'ltnk',
                'elitecyb', 'elitecyb', 'elitecyb', 'elitecyb', 'elitecyb', 'elitecyb', 'elitecyb', 'elitecyb',
                'elitecyb', 'elitecyb', 'elitecyb', 'elitecyb', 'elitecyb', 'elitecyb', 'elitecyb', 'elitecyb',
                'elitecyb', 'elitecyb', 'elitecyb', 'elitecyb',
                'arty', 'arty', 'arty', 'arty', 'arty', 'arty', 'arty', 'arty', 'arty', 'arty'
               }
    }
    Media.PlaySound("CabalM1503.aud")
    Media.DisplayMessage("Initiating terminator protocols. All shall be reduced to ashes.", "Cabal", HSLColor.FromHex("AE18B8"))
    local path = Utils.Random(CabalOffboardAttackPaths)
    
    Reinforcements.Reinforce(Cabal, finalPush[Difficulty], { CabalRSpawn.Location }, 30, function(unit)
      unit.Patrol(path, false)
      unit.Hunt()
    end)
  end)
  
  --Proximity Triggers/Reveals
  
  --Timer
  Trigger.AfterDelay(DateTime.Seconds(10), function()
    Media.DisplayMessage("20 minutes until reinforcements arrive.", "EVA", HSLColor.FromHex("00FF00"))
    
    DateTime.TimeLimit = DateTime.Seconds(1200)
    Media.PlaySound("Eva-MissionTimer.aud")
    
    Trigger.OnTimerExpired(function()
      GDI.MarkCompletedObjective(SurviveObjective)
      Media.DisplayMessage("Reinforcements arriving from the northeast.", "EVA", HSLColor.FromHex("00FF00"))
      Media.PlaySound("Eva-ReinforcementsNorth.aud")
      
      Trigger.AfterDelay(DateTime.Seconds(5), function()
        Media.PlaySpeechNotification(All, "Reinforce")
        Reinforcements.Reinforce(GoodGuy, {'jeep', 'htnk', 'htnk', 'msam', 'msam', 'msam', 'msam', 'htnk', 'htnk', 'mhq', 'jeep'}, { GDIRSpawn.Location }, 30, function(unit)
          unit.Move(GDIRMoveTo.Location)
        end)
      end)
    end)
  end)
  
  --Crate spawns
  Trigger.OnKilled(Truck1, function(self, killer)
    Actor.Create("moneycrate", true, { Owner = GDI, Location = Truck1.Location })
  end)
  
  --Taunts
  Trigger.AfterDelay(DateTime.Seconds(60), function()
    Media.PlaySound("CabalTermination.aud")
    Media.DisplayMessage("You have been marked for termination.", "Cabal", HSLColor.FromHex("AE18B8"))
  end)
  
  Trigger.AfterDelay(DateTime.Seconds(600), function()
    Media.PlaySound("CabalM1501.aud")
    Media.DisplayMessage("Your tactical analysis is rather efficient for a human.", "Cabal", HSLColor.FromHex("AE18B8"))
  end)
  Trigger.AfterDelay(DateTime.Seconds(605), function()
    Media.PlaySound("CabalM1502.aud")
    Media.DisplayMessage("I shall have to remove your brain and assimilate your tactical protocols into my own.", "Cabal", HSLColor.FromHex("AE18B8"))
  end)
  
  --Testing
end


Tick = function()
	DerrickManager()
	OncePerSecondChecks()
	OncePerThreeSecondChecks()
end

OncePerSecondChecks = function()
  if DateTime.GameTime > 1 and DateTime.GameTime % 25 == 0 then
    --none
  end
end

OncePerThreeSecondChecks = function()
	if DateTime.GameTime > 1 and DateTime.GameTime % 75 == 0 then
	
	local ObjCounter = 0
    Utils.Do(CoopPlayers,function(PID)
		if HasOneOf(PID, {'exosuit'}) == false then
			ObjCounter = ObjCounter + 1
		end
	end)
	if ObjCounter >= #CoopPlayers then
      GDI.MarkFailedObjective(ProtectExosuitsObjective)
    end
    
    local scientists = GDI.GetActorsByType('chan')
    if #scientists < 3 then
      GDI.MarkFailedObjective(ProtectScientistsObjective)
    end
    
    if HasOneOf(Cabal, LossCheckCritical) == false then
      GDI.MarkCompletedObjective(DestroyCabalObjective)
      if GDI.IsObjectiveCompleted(SurviveObjective) == false then
        GDI.MarkCompletedObjective(SurviveObjective)
      end
      GDI.MarkCompletedObjective(ProtectScientistsObjective)
      GDI.MarkCompletedObjective(ProtectExosuitsObjective)
    end
    
    if AirstrikeGranted == false then CheckDestroyedSams() end
    
    --manipulate AI funds
    ManipulatePlayerFunds(Cabal)
    
    ControlAircraft(Cabal)
	end
end


PlayerFailMission = function()
  if SurviveObjective ~= nil and not GDI.IsObjectiveCompleted(SurviveObjective) then
    GDI.MarkFailedObjective(SurviveObjective)
  end
  if DestroyCabalObjective ~= nil and not GDI.IsObjectiveCompleted(DestroyCabalObjective) then
    GDI.MarkFailedObjective(DestroyCabalObjective)
  end
  if ProtectScientistsObjective ~= nil and not GDI.IsObjectiveCompleted(ProtectScientistsObjective) then
    GDI.MarkFailedObjective(ProtectScientistsObjective)
  end
  if ProtectExosuitsObjective ~= nil and not GDI.IsObjectiveCompleted(ProtectExosuitsObjective) then
    GDI.MarkFailedObjective(ProtectExosuitsObjective)
  end
  if DestroySamsObjective ~= nil and not GDI.IsObjectiveCompleted(DestroySamsObjective) then
    GDI.MarkFailedObjective(DestroySamsObjective)
  end
end

DerrickManager = function()
	Utils.Do(CoopPlayers,function(PID)
		Utils.Do(PID.GetActorsByType("v19"),function(UID)
			UID.Owner = GoodGuy
		end)
		if GoodGuy.Cash > 0 then
			PID.Cash = PID.Cash + (GoodGuy.Cash / #CoopPlayers)
		end
	end)
	GoodGuy.Cash = 0
end