
BeginCyborgProduction = false
FoundForgotten = false
ForgottenHostile = false
CabalLaunchedAttack = false
MutantBasePowered = false

NodBaseFound = false
NodFixDestroyed = false
NodEngineersRescued = false

ActorRemovals =
{
  easy = { PatrolB1, PatrolB2, PatrolB3, PatrolE1, PatrolE2, PatrolE3 },
  normal = {  },
  hard = { Truck4, Truck5 },
}


-- Cabal Attack Production Behavior -----

CabalAttackDelayMin = { easy = DateTime.Seconds(60), normal = DateTime.Seconds(45), hard = DateTime.Seconds(30) }
CabalAttackDelayMax = { easy = DateTime.Seconds(90), normal = DateTime.Seconds(60), hard = DateTime.Seconds(45) }

CabalAttackPaths = {
  { CabalAtk1.Location, ForgottenTrig.Location },
  { CabalAtk2A.Location, CabalAtk2B.Location, ForgottenTrig.Location },
  { CabalAtk3A.Location, CabalAtk3B.Location, ForgottenTrig.Location }
}

CabalAttackVehicleTypes = {
  easy = {
    { types = { "bggy", "bggy", "bggy", "bike", "bike" } },
    { types = { "ltnk", "ltnk", "ltnk", "ltnk", "ltnk" } },
    { types = { "ltnk", "ltnk", "ftnk", "ftnk", "ftnk" } },
  },
  normal = {
    { types = { "bggy", "bggy", "bggy", "bike", "bike" } },
    { types = { "ltnk", "ltnk", "ltnk", "ltnk", "ltnk" } },
    { types = { "ltnk", "ltnk", "ftnk", "ftnk", "ftnk" } },
  },
  hard = {
    { types = { "ltnk", "ltnk", "ltnk", "ltnk", "ltnk", "ltnk" } },
    { types = { "ftnk", "ftnk", "ftnk", "ftnk", "ftnk", "ftnk" } },
    { types = { "ltnk", "ltnk", "ltnk", "ftnk", "ftnk", "ftnk" } },
  }
}

CabalVehicleAttackProduction = function()
  local production = Utils.Random(CabalAttackVehicleTypes[Difficulty])
  local path = Utils.Random(CabalAttackPaths)
  local toBuild = function() return production.types end
  local factory = GetAvailableFactory(Cabal, 'afld')
  
  if factory ~= nil then
    ProduceUnits(Cabal, factory, nil, toBuild, function(units)
      UpdatePlayerBaseLocation()
      Utils.Do(units, function(unit)
        ErrorGuardAttackPatrol(unit, path)
        AssaultPlayerBaseOrHunt(unit)
      end)
      Trigger.AfterDelay(Utils.RandomInteger(CabalAttackDelayMin[Difficulty], CabalAttackDelayMax[Difficulty]), CabalVehicleAttackProduction)
    end)
  else
    Trigger.AfterDelay(Utils.RandomInteger(CabalAttackDelayMin[Difficulty], CabalAttackDelayMax[Difficulty]), CabalVehicleAttackProduction)
  end
end

CabalCyborgProduction = function()
  local cyborgProduction = Cabal.GetActorsByTypes( {'hosp', 'bio'} )
  if #cyborgProduction < 2 then return end

  local sacrifices = Map.ActorsInBox(CybProductionNW.CenterPosition, CybProductionSE.CenterPosition, function(a)
    return (a.Owner == Neutral and a.Type ~= 'waypoint') or a.Type == 'e1'
  end)
  
  if #sacrifices > 0 then
    local sacrifice = sacrifices[1]
    sacrifice.Move(CybProductionMoveTo.Location)
    
    sacrifice.CallFunc(function()
      local flare1 = Actor.Create("flare", true, { Owner = Cabal, Location = Flare1.Location })
      local flare2 = Actor.Create("flare", true, { Owner = Cabal, Location = Flare2.Location })
      
      Trigger.AfterDelay(DateTime.Seconds(15), function()
        flare1.Destroy()
        flare2.Destroy()
      end)
      
      Media.PlaySound("Valve.aud")
      
      Trigger.AfterDelay(DateTime.Seconds(5), function()
        Media.PlaySound("DeathScream" .. Utils.RandomInteger(1,4) .. ".aud")
      end)
      
      Trigger.AfterDelay(DateTime.Seconds(10), function()
        Media.PlaySound("22-i006.aud")
        local newCyborg = Actor.Create("elitecyb", true, { Owner = Cabal2, Location = CybProductionSpawn.Location })
        newCyborg.Move(CybProductionStage.Location)
      end)
    end)
    
    sacrifice.Destroy()
  end
  
  local delays = { easy = 60, normal = 45, hard = 30 }
  Trigger.AfterDelay(DateTime.Seconds(delays[Difficulty]), CabalCyborgProduction)
end

-- End Cabal Attack Production Behavior -----


CyborgAttackCountdown = function()
  local attackDelay = { easy = 960, normal = 720, hard = 480 }
  Trigger.AfterDelay(DateTime.Seconds(attackDelay[Difficulty]), ExecuteCyborgAttack)
end

ExecuteCyborgAttack = function()
  local attackers = Cabal2.GetActorsByTypes( {'elitecyb', 'cyborg'} )
  local path = Utils.Random(CabalAttackPaths)
  UpdatePlayerBaseLocation()
  
  Utils.Do(attackers, function(unit)
    unit.Patrol(path, false)
    AssaultPlayerBaseOrHunt(unit)
  end)
end

RespawnTrigger = function(a)
	if RespawnEnabled then
		Trigger.OnKilled(a, function(self, killer)
			local name = "Spy"
			Media.DisplayMessage("My " .. name .. " was killed. A new one arrives in 30 seconds.",a.Owner.Name ,a.Owner.Color)
			Trigger.AfterDelay(DateTime.Seconds(30), function()
				local respawnedActor = Actor.Create(a.Type, true, { Owner = a.Owner, Location = CurrentSpawnPoint.Location })
				respawnedActor.Scatter()
				Beacon.New(a.Owner, CurrentSpawnPoint.CenterPosition, 125)
				Media.PlaySpeechNotification(a.Owner, "Reinforce")
				RespawnTrigger(respawnedActor)
			end)
		end)
	end
end

WorldLoaded = function()

  Nod = Player.GetPlayer("Nod")
  Cabal = Player.GetPlayer("Cabal")
  Cabal2 = Player.GetPlayer("Cabal2")
  RuinedNod = Player.GetPlayer("RuinedNod")
  Civilians = Player.GetPlayer("Civilians")
  Forgotten = Player.GetPlayer("Forgotten")
  Forgotten2 = Player.GetPlayer("Forgotten2")
  Neutral = Player.GetPlayer("Neutral")
  
  MissionPlayer = Nod
  
	BadGuy = Player.GetPlayer("BadGuy")

	coopInfo =
	{
		Mainplayer = Nod,
		MainEnemies = {Cabal, Cabal2},
		Dummyplayer = BadGuy
	}
	
	ORAMod = "tibalt"
	CoopInit25(coopInfo)
	
	BaseShared = true
	TechShared = true
	MoneyShareOverride = 100
	
	RespawnEnabled = Map.LobbyOption("respawn") == "enabled"
	CurrentSpawnPoint = StartCam
	RespawnTrigger(Actor452)
	Utils.Do(CoopPlayers,function(PID)
		if PID ~= Nod then
			local NewSpy = Actor.Create(Actor452.Type, true, { Owner = PID, Location = Actor452.Location })
			NewSpy.Scatter()
			RespawnTrigger(NewSpy)
		end
	end)

  Camera.Position = StartCam.CenterPosition
  
  --Remove actors based on difficulty
  Utils.Do(ActorRemovals[Difficulty], function(unit)
    unit.Destroy()
  end)
  
  --Special lighting
  Lighting.Ambient = 0.9
  Lighting.Red = 0.75
  Lighting.Blue = 0.9
  Lighting.Green = 1.2
  
  --Player Reinforcements
  
  --Objectives
  InitObjectives(Nod)

  Trigger.AfterDelay(DateTime.Seconds(2), function()
    DestroyCyborgProdObjective = Nod.AddObjective("Destroy Cabal's cyborg production facilities.")
    CaptureHqObjective = Nod.AddObjective("Capture Cabal's comm center.")
  end)
  
  Trigger.OnAllKilled( {Hosp, Bio}, function()
    Nod.MarkCompletedObjective(DestroyCyborgProdObjective)
  end)
  
  Trigger.OnKilled(Hq, function(self, killer)
    Nod.MarkFailedObjective(CaptureHqObjective)
  end)
  
  Trigger.OnCapture(Hq, function(self, captor, oldOwner, newOwner)
    if IsOwnedByCoopPlayer(captor) then Nod.MarkCompletedObjective(CaptureHqObjective) end
  end)
  
  --AI player behavior
  Cabal.Cash = 90000
  Cabal.Resources = Cabal.ResourceCapacity - 500
  SetupRefAndSilosCaptureCredits(Cabal)
  AutoReplaceHarvesters(Cabal)
  
  RuinedNod.Resources = RuinedNod.ResourceCapacity - 500
  SetupRefAndSilosCaptureCredits(RuinedNod, 2000)
  
  Trigger.OnKilled(Civ1, function()
    if BeginCyborgProduction == false then
      BeginCyborgProduction = True
      CabalCyborgProduction()
      CyborgAttackCountdown()
    end
  end)
  
  --Enemy Predeployed Maneuvers
  Utils.Do( { PatrolA1, PatrolA2, PatrolA3 }, function(unit)
    unit.Patrol({PatrolRouteA1.Location, PatrolRouteA2.Location, PatrolRouteA3.Location, PatrolRouteA4.Location}, true, DateTime.Seconds(5))
  end)
  
  Utils.Do( { PatrolC1, PatrolC2, PatrolC3 }, function(unit)
    unit.Patrol({PatrolRouteC1.Location, PatrolRouteC2.Location, PatrolRouteC3.Location, PatrolRouteC2.Location}, true, DateTime.Seconds(5))
  end)
  
  Utils.Do( { PatrolD1, PatrolD2, PatrolD3 }, function(unit)
    unit.Patrol({PatrolRouteD1.Location, PatrolRouteD2.Location, PatrolRouteD3.Location, PatrolRouteD4.Location}, true, DateTime.Seconds(5))
  end)
  
  Utils.Do( { PatrolF1, PatrolF2, PatrolF3 }, function(unit)
    unit.Patrol({PatrolRouteF1.Location, PatrolRouteF2.Location}, true, DateTime.Seconds(5))
  end)
  
  if Difficulty ~= 'easy' then
    Utils.Do( { PatrolB1, PatrolB2, PatrolB3 }, function(unit)
      unit.Patrol({PatrolRouteA2.Location, PatrolRouteA1.Location, PatrolRouteA4.Location, PatrolRouteA3.Location}, true, DateTime.Seconds(5))
    end)
    
    Utils.Do( { PatrolE1, PatrolE2, PatrolE3 }, function(unit)
      unit.Patrol({PatrolRouteD2.Location, PatrolRouteD1.Location, PatrolRouteD4.Location, PatrolRouteD3.Location}, true, DateTime.Seconds(5))
    end)
  end

  --Proximity Triggers/Reveals
  Trigger.OnEnteredProximityTrigger(ProxRvl1.CenterPosition, WDist.New(3 * 1024), function(a, id)
    if IsOwnedByCoopPlayer(a) and a.Type ~= 'camera' and a.Type ~= 'camera.small' then
      Trigger.RemoveProximityTrigger(id)
      local proxCam1 = Actor.Create("camera", true, { Owner = Nod, Location = Rvl1.Location })
      Trigger.AfterDelay(DateTime.Seconds(10), function() proxCam1.Destroy() end)
    end
  end)
  
  Utils.Do( {ProxRvl2, ProxRvl3, ProxRvl4, ProxRvl5, ProxRvl6}, function(wp)
    Trigger.OnEnteredProximityTrigger(wp.CenterPosition, WDist.New(10 * 1024), function(a, id)
      if IsOwnedByCoopPlayer(a) and a.Type ~= 'camera' and a.Type ~= 'camera.small' then
        Trigger.RemoveProximityTrigger(id)
        local proxCam = Actor.Create("camera", true, { Owner = Nod, Location = wp.Location })
        Trigger.AfterDelay(DateTime.Seconds(10), function() proxCam.Destroy() end)
      end
    end)
  end)
  
  Trigger.OnEnteredProximityTrigger(TownTrig.CenterPosition, WDist.New(4 * 1024), function(a, id)
    if IsOwnedByCoopPlayer(a) and a.Type ~= 'camera' and a.Type ~= 'camera.small' then
      Trigger.RemoveProximityTrigger(id)
      
      local townCam1 = Actor.Create("camera", true, { Owner = Nod, Location = TownRvl1.Location })
      Trigger.AfterDelay(DateTime.Seconds(30), function() townCam1.Destroy() end)
      local townCam2 = Actor.Create("camera", true, { Owner = Nod, Location = TownRvl2.Location })
      Trigger.AfterDelay(DateTime.Seconds(30), function() townCam2.Destroy() end)

      local townAttacker1 = Actor.Create("ftnk", true, { Owner = Cabal2, Location = TownSpawn1.Location })
      local townAttacker2 = Actor.Create("cyborg", true, { Owner = Cabal2, Location = TownSpawn2.Location })
      local townAttacker3 = Actor.Create("cyborg", true, { Owner = Cabal2, Location = TownSpawn3.Location })
      
      townAttacker1.Attack(LiquidTank)
      townAttacker2.Attack(QuadMod)
      townAttacker3.Attack(House1)
      
      Cyb1.Move(Cyb1MoveTo.Location)
      Cyb2.Move(Cyb2MoveTo.Location)
      
      Civ1.Move(CivMoveTo1.Location)
      Civ1.CallFunc(function()
        if BeginCyborgProduction == false then
          BeginCyborgProduction = True
          CabalCyborgProduction()
          CyborgAttackCountdown()
        end
        Trigger.AfterDelay(DateTime.Seconds(3), function()
          Actor.Create("barrier", true, { Owner = Cabal, Location = GateSpawn.Location })
        end)
      end)
      
      Utils.Do( {Civ2, Civ3, Civ4, Civ5}, function(civ) civ.Move(CivMoveTo1.Location) end)
    end
  end)
  
  local forgottenUnits = Forgotten.GetActors()
  Utils.Do(forgottenUnits, function(unit)
    Trigger.OnKilled(unit, function(self, killer)
      if FoundForgotten == false and IsOwnedByCoopPlayer(killer) then
        ForgottenHostile = true
        Media.DisplayMessage("Murderous scum, you will die for this!", "Mutant", HSLColor.FromHex("00FF00"))
        Utils.Do(forgottenUnits, function(funit) funit.Owner = Forgotten2 end)
      end
    end)
  end)
  
  Trigger.OnEnteredProximityTrigger(ForgottenTrig.CenterPosition, WDist.New(11 * 1024), function(a, id)
    if IsOwnedByCoopPlayer(a) and a.Type ~= 'camera' and a.Type ~= 'camera.small' then
      Trigger.RemoveProximityTrigger(id)
	  CurrentSpawnPoint = ForgottenTrig
      
      local forCam1 = Actor.Create("camera", true, { Owner = Nod, Location = ForgottenTrig.Location })
      Trigger.AfterDelay(DateTime.Seconds(30), function() forCam1.Destroy() end)
      
      Media.DisplayMessage("Welcome, traveler. You appear to be a Nod soldier.", "Mutant", HSLColor.FromHex("00FF00"))
      Trigger.AfterDelay(DateTime.Seconds(3), function()
        if ForgottenHostile == false then
          Media.DisplayMessage("Yes, I've come to ask your help destroying Cabal's cyborg production facility.", "Nod", HSLColor.FromHex("FF0000"))
        end
      end)
      Trigger.AfterDelay(DateTime.Seconds(7), function()
        if ForgottenHostile == false then
          Media.DisplayMessage("We would like to help, but we are lacking in funds and manpower.", "Mutant", HSLColor.FromHex("00FF00"))
        end
      end)
      Trigger.AfterDelay(DateTime.Seconds(11), function()
        if ForgottenHostile == false then
          Media.DisplayMessage("We repaired the Tesla coils in this old Soviet base,\nbut there is not enough power to operate them.", "Mutant", HSLColor.FromHex("00FF00"))
        end
      end)
      Trigger.AfterDelay(DateTime.Seconds(16), function()
        if ForgottenHostile == false then
          Media.DisplayMessage("We've heard there is an old Nod base in the area.\nPerhaps there may be something of use to you there.", "Mutant", HSLColor.FromHex("00FF00"))
        end
      end)
      Trigger.AfterDelay(DateTime.Seconds(21), function()
        if ForgottenHostile == false then
          Media.DisplayMessage("We have heard of your exploits and shall follow your command.", "Mutant", HSLColor.FromHex("00FF00"))
        end
      end)
      
      Trigger.AfterDelay(DateTime.Seconds(24), function()
        if ForgottenHostile == false then
          FoundForgotten = true
          local forgottenBase = Forgotten.GetActors()
		  local forgottenUnits = Forgotten.GetGroundAttackers()
		  Utils.Do(forgottenBase, function(unit) unit.Owner = Nod end)
          Utils.Do(forgottenUnits, function(unit) unit.Owner = BadGuy end)
          RestorePowerObjective = Nod.AddObjective("Restore power to the Forgotten settlement.", "Secondary", false)
          InvestigateBaseObjective = Nod.AddObjective("Investigate the ruined Nod base.", "Secondary", false)
        end

        local productionDelay = { easy = 600, normal = 450, hard = 300 }
        Trigger.AfterDelay(DateTime.Seconds(productionDelay[Difficulty]), CabalVehicleAttackProduction)
      end)
    end
  end)
  
  Utils.Do({NodBaseTrig1, NodBaseTrig2}, function(wp)
    Trigger.OnEnteredProximityTrigger(wp.CenterPosition, WDist.New(4 * 1024), function(a, id)
      if NodBaseFound == false and IsOwnedByCoopPlayer(a) and a.Type ~= 'camera' and a.Type ~= 'camera.small' then
        NodBaseFound = true
        Trigger.RemoveProximityTrigger(id)
        
        local nodCam1 = Actor.Create("camera", true, { Owner = Nod, Location = NodBaseRvl1.Location })
        Trigger.AfterDelay(DateTime.Seconds(15), function() nodCam1.Destroy() end)
        local nodCam2 = Actor.Create("camera", true, { Owner = Nod, Location = NodBaseRvl2.Location })
        Trigger.AfterDelay(DateTime.Seconds(15), function() nodCam2.Destroy() end)
        
        if Cyb3 ~= nil and not Cyb3.IsDead then
          Cyb3.AttackMove(NodBaseMoveTo.Location)
          Cyb3.AttackMove(Cyb1MoveTo.Location)
        end
        if Cyb4 ~= nil and not Cyb4.IsDead then
          Cyb4.AttackMove(NodBaseMoveTo.Location)
          Cyb4.AttackMove(Cyb2MoveTo.Location)
        end
        
        Rifle1.Move(NodBaseMoveTo.Location)
        Rifle1.Move(RifleMoveTo1.Location)
        Rifle1.CallFunc(function()
          local gate = Cabal.GetActorsByType('barrier')
          if #gate > 0 then gate[1].Destroy() end
          Trigger.AfterDelay(DateTime.Seconds(1), function()
            Rifle1.Move(RifleMoveTo2.Location)
            Trigger.AfterDelay(DateTime.Seconds(6), function()
              Actor.Create("barrier", true, { Owner = Cabal, Location = GateSpawn.Location })
            end)
          end)
        end)
      
        Utils.Do( {Rifle2, Rifle3, Rifle4, Rifle5}, function(rifle)
          rifle.Move(NodBaseMoveTo.Location)
          rifle.Move(RifleMoveTo1.Location)
          rifle.CallFunc(function()
            Trigger.AfterDelay(DateTime.Seconds(3), function() rifle.Move(RifleMoveTo2.Location) end)
          end)
        end)
      end
    end)
  end)
  
  Trigger.OnAllKilled({Cyb3, Cyb4}, function()
    local captives = RuinedNod.GetActorsByType('e1')
    if #captives > 0 then
      Media.DisplayMessage("Thanks for the rescue!", "Nod Soldier", HSLColor.FromHex("FF0000"))
      Utils.Do(captives, function(captive)
        captive.Move(captive.Location)
        captive.Owner = BadGuy
      end)
    end
  end)
  
  Trigger.OnKilled(NodFix, function(self, killer)
    NodFixDestroyed = true
    if NodEngineersRescued == false then
      Media.DisplayMessage("Aaaagggh!", "Engineer", HSLColor.FromHex("FF0000"))
      Trigger.AfterDelay(DateTime.Seconds(3), function()
        Media.DisplayMessage("It appears that engineers hiding in the repair bay have been killed.", "NOTICE", HSLColor.FromHex("FF0000"))
        Nod.MarkFailedObjective(InvestigateBaseObjective)
      end)
    end
  end)
  
  Trigger.OnAllKilled({NodBaseGuard1, NodBaseGuard2, NodBaseGuard3}, function()
    if NodFixDestroyed == false then
      NodEngineersRescued = true
      Reinforcements.Reinforce(BadGuy, {'e6', 'e6', 'e6', 'e6', 'e6'}, { EngySpawn.Location }, 5, function(engy)
        engy.Move(EngyMoveTo.Location)
      end)
      Media.PlaySound("Eva-TargetRescued.aud")
      Media.DisplayMessage("Thanks, we thought we were goners!", "Engineer", HSLColor.FromHex("FF0000"))
      Nod.MarkCompletedObjective(InvestigateBaseObjective)
    end
  end)

  --Timer

  --Crate spawns
  Utils.Do( {Truck1, Truck2, Truck3}, function(truck)
    Trigger.OnKilled(truck, function(self, killer)
      Actor.Create("moneycrate", true, { Owner = Nod, Location = truck.Location })
    end)
  end)
  
  if Difficulty ~= 'hard' then
    Utils.Do( {Truck4, Truck5}, function(truck)
      Trigger.OnKilled(truck, function(self, killer)
        Actor.Create("moneycrate", true, { Owner = Nod, Location = truck.Location })
      end)
    end)
  end
  
  --Testing
end


Tick = function()
	AssignToCoopPlayers(BadGuy.GetActorsByType("e6"), nil, true)
	OncePerSecondChecks()
	OncePerThreeSecondChecks()
end

OncePerSecondChecks = function()
  if DateTime.GameTime > 1 and DateTime.GameTime % 25 == 0 then
    --none
  end
end

OncePerThreeSecondChecks = function()
	if DateTime.GameTime > 1 and DateTime.GameTime % 75 == 0 then
    --[[if HasOneOf(Nod, LossCheckAll) == false then
      PlayerFailMission()
	end]]
		TibAltCoopLossCheck()

		if CabalLaunchedAttack == false then
			local cabalPower = Cabal.GetActorsByType('nuk2')
			if #cabalPower < 6 then
				CabalLaunchedAttack = true
				ExecuteCyborgAttack()
				CabalVehicleAttackProduction()
			end
		end
    
		if MutantBasePowered == false then
			local playerPower = {}
			Utils.Do(CoopPlayers,function(PID)
				Utils.Do(PID.GetActorsByType('nuk2'),function(UID)
					table.insert(playerPower,UID)
				end)
			end)
			if #playerPower >= 2 then
				MutantBasePowered = true
				Nod.MarkCompletedObjective(RestorePowerObjective)
			end
		end
    
		--manipulate AI funds
		ManipulatePlayerFunds(Cabal)
	end
end


PlayerFailMission = function()
  if DestroyCyborgProdObjective ~= nil and not Nod.IsObjectiveCompleted(DestroyCyborgProdObjective) then
    Nod.MarkFailedObjective(DestroyCyborgProdObjective)
  end
  
  if CaptureHqObjective ~= nil and not Nod.IsObjectiveCompleted(CaptureHqObjective) then
    Nod.MarkFailedObjective(CaptureHqObjective)
  end
  
  if RestorePowerObjective ~= nil and not Nod.IsObjectiveCompleted(RestorePowerObjective) then
    Nod.MarkFailedObjective(RestorePowerObjective)
  end
  
  if InvestigateBaseObjective ~= nil and not Nod.IsObjectiveCompleted(InvestigateBaseObjective) then
    Nod.MarkFailedObjective(InvestigateBaseObjective)
  end
end
