
GunboatsSpawned = false
GunboatsDead = false
NodAwake = false


ActorRemovals =
{
  easy = { EZR1, EZR2, EZR3, EZR4, Patrol1, Patrol2 },
  normal = { },
  hard = {  },
}



AwakenNod = function()
  if NodAwake == true then return end
  NodAwake = true

  if Difficulty ~= 'easy' then
    NodVehicleAttackProduction()
    NodInfantryAttackProduction()
  end
  
  SubNodVehicleAttackProduction()
  SubNodInfantryAttackProduction()
end

-- SubNod Attack Production Behavior -----

SubNodAttackDelayMin = { easy = DateTime.Seconds(90), normal = DateTime.Seconds(60), hard = DateTime.Seconds(45) }
SubNodAttackDelayMax = { easy = DateTime.Seconds(120), normal = DateTime.Seconds(90), hard = DateTime.Seconds(60) }

SubNodAttackPaths = {
  { SubNodAtkPath1.Location, SubNodAtkPath2.Location }
}

NodAttackInfantryTypes = {
  easy = {
    { types = { "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1" } },
    { types = { "e1", "e1", "e1", "e1", "e3", "e3", "e3" } },
    { types = { "e3", "e3", "e3", "e3", "e3", "e3" } },
    { types = { "e4", "e4", "e4", "e4", "e4", "e4" } },
    { types = { "spy", "spy", "spy", "spy", "spy", "spy" } },
  },
  normal = {
    { types = { "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1" } },
    { types = { "e1", "e1", "e1", "e1", "e3", "e3", "e3", "e3" } },
    { types = { "e3", "e3", "e3", "e3", "e3", "e3", "e3" } },
    { types = { "spy", "spy", "spy", "spy", "spy", "spy", "spy" } },
    { types = { "e4", "e4", "e4", "e4", "e4", "e4", "e4" } },
  },
  hard = {
    { types = { "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1" } },
    { types = { "e1", "e1", "e1", "e1", "e1", "e3", "e3", "e3", "e3", "e3" } },
    { types = { "e3", "e3", "e3", "e3", "e3", "e3", "e3" } },
    { types = { "spy", "spy", "spy", "spy", "spy", "spy", "spy" } },
    { types = { "e4", "e4", "e4", "e4", "e4", "e4", "e4" } },
  }
}

NodAttackVehicleTypes = {
  easy = {
    { types = { "bggy", "bike" } },
    { types = { "ltnk", "ltnk" } },
    { types = { "ltnk", "arty" } },
  },
  normal = {
    { types = { "bggy", "bggy", "bike", "bike" } },
    { types = { "ltnk", "ltnk", "ltnk" } },
    { types = { "ltnk", "ltnk", "arty", "arty" } },
  },
  hard = {
    { types = { "bggy", "bggy", "bggy", "bggy", "bike", "bike" } },
    { types = { "ltnk", "ltnk", "ltnk", "ltnk" } },
    { types = { "ltnk", "ltnk", "ltnk", "arty", "arty" } },
  }
}

SubNodVehicleAttackProduction = function()
  local production = Utils.Random(NodAttackVehicleTypes[Difficulty])
  local path = Utils.Random(SubNodAttackPaths)
  local toBuild = function() return production.types end
  local factory = GetAvailableFactory(SubNod, 'afld')
  
  if factory ~= nil then
    ProduceUnits(SubNod, factory, nil, toBuild, function(units)
      UpdatePlayerBaseLocation()
      Utils.Do(units, function(unit)
        ErrorGuardAttackPatrol(unit, path)
        AssaultPlayerBaseOrHunt(unit)
      end)
      Trigger.AfterDelay(Utils.RandomInteger(SubNodAttackDelayMin[Difficulty], SubNodAttackDelayMax[Difficulty]), SubNodVehicleAttackProduction)
    end)
  else
    Trigger.AfterDelay(Utils.RandomInteger(SubNodAttackDelayMin[Difficulty], SubNodAttackDelayMax[Difficulty]), SubNodVehicleAttackProduction)
  end
end

SubNodInfantryAttackProduction = function()
  local production = Utils.Random(NodAttackInfantryTypes[Difficulty])
  local path = Utils.Random(SubNodAttackPaths)
  local toBuild = function() return production.types end
  local factory = GetAvailableFactory(SubNod, 'hand')

  if factory ~= nil then
    ProduceUnits(SubNod, factory, nil, toBuild, function(units)
      UpdatePlayerBaseLocation()
      Utils.Do(units, function(unit)
        ErrorGuardAttackPatrol(unit, path)
        AssaultPlayerBaseOrHunt(unit)
      end)
      Trigger.AfterDelay(Utils.RandomInteger(SubNodAttackDelayMin[Difficulty], SubNodAttackDelayMax[Difficulty]), SubNodInfantryAttackProduction)
    end)
  else
    Trigger.AfterDelay(Utils.RandomInteger(SubNodAttackDelayMin[Difficulty], SubNodAttackDelayMax[Difficulty]), SubNodInfantryAttackProduction)
  end
end

-- End SubNod Attack Production Behavior -----


-- Nod Attack Production Behavior -----

NodAttackDelayMin = { easy = DateTime.Seconds(90), normal = DateTime.Seconds(60), hard = DateTime.Seconds(45) }
NodAttackDelayMax = { easy = DateTime.Seconds(120), normal = DateTime.Seconds(90), hard = DateTime.Seconds(60) }

NodAttackPaths =
{
  { Nod3Stage.Location }
}

NodVehicleAttackProduction = function()
  local production = Utils.Random(NodAttackVehicleTypes[Difficulty])
  local path = Utils.Random(NodAttackPaths)
  local toBuild = function() return production.types end
  local factory = NodAfld
  
  if factory ~= nil and not factory.IsDead then
    ProduceUnits(Nod, factory, nil, toBuild, function(units)
      UpdatePlayerBaseLocation()
      Utils.Do(units, function(unit)
        ErrorGuardAttackPatrol(unit, path)
        AssaultPlayerBaseOrHunt(unit)
      end)
      Trigger.AfterDelay(Utils.RandomInteger(NodAttackDelayMin[Difficulty], NodAttackDelayMax[Difficulty]), NodVehicleAttackProduction)
    end)
  else
    Trigger.AfterDelay(Utils.RandomInteger(NodAttackDelayMin[Difficulty], NodAttackDelayMax[Difficulty]), NodVehicleAttackProduction)
  end  
end

NodInfantryAttackProduction = function()  
  local production = Utils.Random(NodAttackInfantryTypes[Difficulty])
  local path = Utils.Random(NodAttackPaths)
  local toBuild = function() return production.types end
  local factory = NodHand3

  if factory ~= nil and not factory.IsDead then
    ProduceUnits(Nod, factory, nil, toBuild, function(units)
      UpdatePlayerBaseLocation()
      Utils.Do(units, function(unit)
        ErrorGuardAttackPatrol(unit, path)
        AssaultPlayerBaseOrHunt(unit)
      end)
      Trigger.AfterDelay(Utils.RandomInteger(NodAttackDelayMin[Difficulty], NodAttackDelayMax[Difficulty]), NodVehicleAttackProduction)
    end)
  else
    Trigger.AfterDelay(Utils.RandomInteger(NodAttackDelayMin[Difficulty], NodAttackDelayMax[Difficulty]), NodVehicleAttackProduction)
  end
end



NodSubBaseProduction = function(factory)
  if Difficulty == 'easy' then return end
  
  if factory ~= nil and not factory.IsDead then
    local production = {'e1', 'e1', 'e1', 'e1', 'e1'}
    if Difficulty == 'hard' then
      production = {'e1', 'e1', 'e1', 'e1', 'e1', 'e1', 'e1', 'e1', 'e1', 'e1'}
    end
    local toBuild = function() return production end
    
    ProduceUnits(Nod, factory, nil, toBuild, function(units)
      Utils.Do(units, function(unit)
        unit.Hunt()
      end)
    end)
  end
end

-- End Nod Attack Production Behavior -----


Reinforce = function(units, voice, start, destination)
  if voice then
    Media.PlaySpeechNotification(All, "Reinforce")
  end
  ReinforceWithLandingCraft(GoodGuy, units, start.Location, destination.Location, false)
end


OrcaStrike = function(spawn, target)
  local orca = Actor.Create("orca", true, { Owner = FakeGDI, Location = spawn.Location })
  orca.Attack(target)
  orca.Move(spawn.Location)
  orca.Destroy()
end


WorldLoaded = function()
  GDI = Player.GetPlayer("GDI")
  FakeGDI = Player.GetPlayer("FakeGDI")
  Nod = Player.GetPlayer("Nod")
  SubNod = Player.GetPlayer("SubNod")
  Neutral = Player.GetPlayer("Neutral")
  
  MissionPlayer = GDI

	GoodGuy = Player.GetPlayer("GoodGuy")

	coopInfo =
	{
		Mainplayer = GDI,
		MainEnemies = {Nod, SubNod},
		Dummyplayer = GoodGuy
	}
	
	ORAMod = "tibalt"
	CoopInit25(coopInfo)
	
	BaseShared = true
	TechShared = true
	MoneyShareOverride = 100

  Camera.Position = StartCam.CenterPosition
  
  Lighting.Ambient = 0.85
  Lighting.Red = 0.85
  Lighting.Blue = 1.2
  Lighting.Green = 1.0
  
  Trigger.AfterDelay(DateTime.Seconds(60), function() Flare1.Destroy() end)
  
  --Remove actors based on difficulty
  Utils.Do(ActorRemovals[Difficulty], function(unit)
    unit.Destroy()
  end)
  
  --Special lighting
  
  --Player Reinforcements
  Trigger.AfterDelay(DateTime.Seconds(3), function()
    Reinforce({'e1', 'e1', 'e1', 'e1', 'e1'}, true, GDIRSpawn1, GDIRUnload1)
    Reinforce({'e2', 'e2', 'e2', 'e2', 'e2'}, false, GDIRSpawn2, GDIRUnload2)
    Reinforce({'e3', 'e3', 'e3', 'e3', 'e3'}, false, GDIRSpawn3, GDIRUnload3)
  end)
  
  Trigger.AfterDelay(DateTime.Seconds(9), function()
    Reinforce({'medi'}, true, GDIRSpawn3, GDIRUnload3)
  end)
  
  if Difficulty == 'easy' then
    Trigger.AfterDelay(DateTime.Seconds(15), function()
      Reinforce({'jeep'}, true, GDIRSpawn1, GDIRUnload1)
      Reinforce({'jeep'}, false, GDIRSpawn2, GDIRUnload2)
    end)
  end
  
  Trigger.OnAllKilled( {SAM1, SAM2, SAM3}, function()
    Media.PlaySound('Morelli-13M-01.aud')
    Media.DisplayMessage("I've got your back, Commander. We'll clear out that blockade.", "Morelli", HSLColor.FromHex("857833"))
    
    local proxCamOrca = Actor.Create("camera", true, { Owner = GDI, Location = ProxRvl2Show.Location })
    Trigger.AfterDelay(DateTime.Seconds(10), function() proxCamOrca.Destroy() end)
    
    if not Blockade1.IsDead then OrcaStrike(Orca1, Blockade1) end
    if not Blockade2.IsDead then OrcaStrike(Orca2, Blockade2) end
    if not Blockade3.IsDead then OrcaStrike(Orca3, Blockade3) end
    if not Blockade4.IsDead then OrcaStrike(Orca4, Blockade4) end
  end)
  
  Trigger.OnKilled(Blockade1, function(self, killer)
    if killer.Type == 'orca' and not Blockade6.IsDead then Blockade6.Kill() end
  end)
  
  Trigger.OnKilled(Blockade2, function(self, killer)
    if killer.Type == 'orca' and not Blockade7.IsDead then Blockade7.Kill() end
  end)
  
  Trigger.OnKilled(Blockade4, function(self, killer)
    if killer.Type == 'orca' and not Blockade8.IsDead then Blockade8.Kill() end
  end)
  
  --for some reason they're ignoring the individual order to leave and despawn, try this
  Trigger.OnAllKilled({Blockade6, Blockade7, Blockade8}, function()
    local orcas = FakeGDI.GetActorsByType('orca')
    Utils.Do(orcas, function(orca)
      orca.Move(Orca1.Location)
      orca.Destroy()
    end)
  end)
  
  Trigger.OnAllKilled( {Gun1, Gun2, Gun3, Gun4, Gun5, Gun6}, function()
    GDI.MarkCompletedObjective(DestroyTurretsObjective)
    Media.PlaySound("CarterM1301.aud")
    Media.DisplayMessage("Time to blast Nod's shore base to bits.\nSit back and watch the fireworks!", "Carter", HSLColor.FromHex("857833"))

    Trigger.AfterDelay(DateTime.Seconds(4), function()
      Media.PlaySpeechNotification(All, "Reinforce")
      Camera.Position = BoatSpawn.CenterPosition
      Actor.Create("boat", true, { Owner = GoodGuy, Location = BoatSpawn.Location })
    end)
    
    Trigger.AfterDelay(DateTime.Seconds(8), function()
      Actor.Create("boat", true, { Owner = GoodGuy, Location = BoatSpawn.Location })
    end)
    
    Trigger.AfterDelay(DateTime.Seconds(12), function()
      Actor.Create("boat", true, { Owner = GoodGuy, Location = BoatSpawn.Location })
      GunboatsSpawned = true
    end)
  end)
  
  --Objectives
  InitObjectives(GDI)

  Trigger.AfterDelay(DateTime.Seconds(2), function()
    DestroyTurretsObjective = GDI.AddObjective("Destroy all gun turrets on the shore.")
    RescueDelphiObjective = GDI.AddObjective("Locate and rescue Agent Delphi.")
  end)
  
  Trigger.OnEnteredProximityTrigger(DelphiSpawn.CenterPosition, WDist.New(3 * 1024), function(a, id)
    if IsOwnedByCoopPlayer(a) and a.Type == 'tran' then
      Trigger.RemoveProximityTrigger(id)
	  Camera.Position = DelphiSpawn.CenterPosition
      GDI.MarkCompletedObjective(RescueDelphiObjective)
      Media.PlaySound("Eva-TargetRescued.aud")
    end
  end)
  
  --AI player behavior
  Nod.Resources = Nod.ResourceCapacity - 500
  Nod.Cash = 90000
  
  SubNod.Resources = SubNod.ResourceCapacity - 500
  SubNod.Cash = 90000
  
  AutoRepairAndRebuildBuildings(SubNod, 15)
  
  AutoReplaceHarvesters(SubNod)
  SetupRefAndSilosCaptureCredits(SubNod)
  
  if Difficulty == 'easy' then SetupRefAndSilosCaptureCredits(Nod, 3000)
  elseif Difficulty == 'normal' then SetupRefAndSilosCaptureCredits(Nod, 2500)
  elseif Difficulty == 'hard' then SetupRefAndSilosCaptureCredits(Nod, 2000)
  end
  
  Trigger.OnEnteredProximityTrigger(NodBaseRvl1.CenterPosition, WDist.New(10 * 1024), function(a, id)
    if IsOwnedByCoopPlayer(a) and a.Type ~= 'camera' and a.Type ~= 'camera' then
      Trigger.RemoveProximityTrigger(id)
      local proxCam5 = Actor.Create("camera", true, { Owner = GDI, Location = NodBaseRvl1.Location })
      Trigger.AfterDelay(DateTime.Seconds(10), function() proxCam5.Destroy() end)
      NodSubBaseProduction(NodHand1)
    end
  end)
  
  Trigger.OnEnteredProximityTrigger(NodBaseRvl2.CenterPosition, WDist.New(9 * 1024), function(a, id)
    if IsOwnedByCoopPlayer(a) and a.Type ~= 'camera' and a.Type ~= 'camera' then
      Trigger.RemoveProximityTrigger(id)
      local proxCam6 = Actor.Create("camera", true, { Owner = GDI, Location = NodBaseRvl2.Location })
      Trigger.AfterDelay(DateTime.Seconds(10), function() proxCam6.Destroy() end)
      NodSubBaseProduction(NodHand2)
    end
  end)
  
  Trigger.OnCapture(NodHpad1, function(self, captor, oldOwner, newOwner)
    if IsOwnedByCoopPlayer(captor) then AwakenNod() end
  end)
  Trigger.OnCapture(NodHpad2, function(self, captor, oldOwner, newOwner)
    if IsOwnedByCoopPlayer(captor) then AwakenNod() end
  end)
  
  Trigger.OnEnteredProximityTrigger(AwakenTrig.CenterPosition, WDist.New(8 * 1024), function(a, id)
    if IsOwnedByCoopPlayer(a) and a.Type ~= 'camera' and a.Type ~= 'camera.small' then
      Trigger.RemoveProximityTrigger(id)
      AwakenNod()
    end
  end)
  
  --Enemy Predeployed Maneuvers
  if Difficulty ~= 'easy' then
    Patrol1.Patrol({PatrolRouteA1.Location, PatrolRouteA2.Location}, true, DateTime.Seconds(10))
    Patrol2.Patrol({PatrolRouteA1.Location, PatrolRouteA2.Location}, true, DateTime.Seconds(10))
  end
  
  Trigger.OnEnteredProximityTrigger(NodRespA.CenterPosition, WDist.New(2 * 1024), function(a, id)
    if IsOwnedByCoopPlayer(a) and a.Type ~= 'camera' and a.Type ~= 'camera.small' then
      Trigger.RemoveProximityTrigger(id)
      Utils.Do( {NodRespA1, NodRespA2, NodRespA3, NodRespA4, NodRespA5, NodRespA6}, function(unit)
        if not unit.IsDead then unit.AttackMove(NodRespA.Location) end
      end)
    end
  end)
  
  Trigger.OnEnteredProximityTrigger(NodRespB.CenterPosition, WDist.New(2 * 1024), function(a, id)
    if IsOwnedByCoopPlayer(a) and a.Type ~= 'camera' and a.Type ~= 'camera.small' then
      Trigger.RemoveProximityTrigger(id)
      Utils.Do( {NodRespB1, NodRespB2, NodRespB3}, function(unit)
        if not unit.IsDead then unit.AttackMove(NodRespB.Location) end
      end)
    end
  end)
  
  Trigger.OnEnteredProximityTrigger(NodRespC.CenterPosition, WDist.New(2 * 1024), function(a, id)
    if IsOwnedByCoopPlayer(a) and a.Type ~= 'camera' and a.Type ~= 'camera.small' then
      Trigger.RemoveProximityTrigger(id)
      Utils.Do( {NodRespC1, NodRespC2, NodRespC3}, function(unit)
        local ftnkCam = Actor.Create("camera", true, { Owner = GDI, Location = NodRespCCam.Location })
        Trigger.AfterDelay(DateTime.Seconds(10), function() ftnkCam.Destroy() end)
        if not unit.IsDead then unit.AttackMove(NodRespC.Location) end
      end)
    end
  end)
  
  Trigger.OnEnteredProximityTrigger(NodRespD.CenterPosition, WDist.New(2 * 1024), function(a, id)
    if IsOwnedByCoopPlayer(a) and a.Type ~= 'camera' and a.Type ~= 'camera.small' then
      Trigger.RemoveProximityTrigger(id)
      Utils.Do( {NodRespD1, NodRespD2}, function(unit)
        if not unit.IsDead then unit.AttackMove(NodRespD.Location) end
      end)
    end
  end)
  
  Utils.Do({ShoreTrig1, ShoreTrig2}, function(wp)
    Trigger.OnEnteredProximityTrigger(wp.CenterPosition, WDist.New(4 * 1024), function(a, id)
      if IsOwnedByCoopPlayer(a) and a.Type ~= 'camera' and a.Type ~= 'camera.small' then
        Trigger.RemoveProximityTrigger(id)
        local shoreDefenders = Map.ActorsInBox(ShoreDefNW.CenterPosition, ShoreDefSE.CenterPosition, function(a)
          return a.Owner == Nod and (a.Type == 'bggy' or a.Type == 'e1' or a.Type == 'e3')
        end)
        Utils.Do(shoreDefenders, function(unit) unit.AttackMove(ShoreDefAtk.Location) end)
      end
    end)
  end)

  --Proximity Triggers/Reveals
  Trigger.OnEnteredProximityTrigger(ProxRvl1.CenterPosition, WDist.New(9 * 1024), function(a, id)
    if IsOwnedByCoopPlayer(a) and a.Type ~= 'camera' and a.Type ~= 'camera.small' then
      Trigger.RemoveProximityTrigger(id)
      local proxCam1 = Actor.Create("camera.small", true, { Owner = GDI, Location = ProxRvl1.Location })
      Trigger.AfterDelay(DateTime.Seconds(10), function() proxCam1.Destroy() end)
    end
  end)
  
  Trigger.OnEnteredProximityTrigger(ProxRvl2.CenterPosition, WDist.New(3 * 1024), function(a, id)
    if IsOwnedByCoopPlayer(a) and a.Type ~= 'camera' and a.Type ~= 'camera.small' then
      Trigger.RemoveProximityTrigger(id)
      local proxCam2 = Actor.Create("camera", true, { Owner = GDI, Location = ProxRvl2Show.Location })
      Trigger.AfterDelay(DateTime.Seconds(10), function() proxCam2.Destroy() end)
    end
  end)
  
  Trigger.OnEnteredProximityTrigger(Obli1.CenterPosition, WDist.New(12 * 1024), function(a, id)
    if IsOwnedByCoopPlayer(a) and a.Type ~= 'camera' and a.Type ~= 'camera.small' then
      Trigger.RemoveProximityTrigger(id)
      local proxCam3 = Actor.Create("camera.small", true, { Owner = GDI, Location = Obli1.Location })
      Trigger.AfterDelay(DateTime.Seconds(10), function() proxCam3.Destroy() end)
    end
  end)
  
  Trigger.OnEnteredProximityTrigger(Obli2.CenterPosition, WDist.New(12 * 1024), function(a, id)
    if IsOwnedByCoopPlayer(a) and a.Type ~= 'camera' and a.Type ~= 'camera.small' then
      Trigger.RemoveProximityTrigger(id)
      local proxCam4 = Actor.Create("camera.small", true, { Owner = GDI, Location = Obli2.Location })
      Trigger.AfterDelay(DateTime.Seconds(10), function() proxCam4.Destroy() end)
    end
  end)
  
  --Crate spawns
  Trigger.OnKilled(Armory, function(self, killer)
    Actor.Create("moneycrate", true, { Owner = Nod, Location = Armory.Location })
  end)
  
  --Testing
end


Tick = function()
	AssignToCoopPlayers(GoodGuy.GetActorsByType("e6"), nil, true)
	AssignToCoopPlayers(GoodGuy.GetActorsByType("amphapc"), nil, true)
	OncePerSecondChecks()
	OncePerThreeSecondChecks()
  
  --Thunder and lightning
	if (Utils.RandomInteger(1, 200) == 10) then
		local delay = Utils.RandomInteger(1, 10)
		Lighting.Flash("LightningStrike", delay)
		Trigger.AfterDelay(delay, function()
			Media.PlaySound("thunder" .. Utils.RandomInteger(1,6) .. ".aud")
		end)
	end
	if (Utils.RandomInteger(1, 200) == 10) then
		Media.PlaySound("thunder-ambient.aud")
	end
end

OncePerSecondChecks = function()
  if DateTime.GameTime > 1 and DateTime.GameTime % 25 == 0 then
    --none
  end
end

OncePerThreeSecondChecks = function()
	if DateTime.GameTime > 1 and DateTime.GameTime % 75 == 0 then
  
    --[[if HasOneOf(GDI, LossCheckAll) == false then
      PlayerFailMission()
    end]]
	TibAltCoopLossCheck()
    
    --manipulate AI funds
    ManipulatePlayerFunds(Nod)
    
    if GunboatsSpawned == true and GunboatsDead == false then
      local gunboats = GoodGuy.GetActorsByType('boat')
      if #gunboats == 1 then
        GunboatsDead = true
        
        Media.PlaySound("CarterM1302.aud")
        Media.DisplayMessage("They've got some kind of laser weapon! It's blowing the gunboats to--Z##x#x===", "Carter", HSLColor.FromHex("857833"))
        
        Trigger.AfterDelay(DateTime.Seconds(5), function()
          Media.PlaySound('Morelli-13M-02.aud')
          Media.DisplayMessage("Carter! Carter, do you read me?!", "Morelli", HSLColor.FromHex("857833"))
        end)
        
        Trigger.AfterDelay(DateTime.Seconds(10), function()
          Media.DisplayMessage("The gunboat assault has failed.\nYou will need to find an alternate method of circumventing the Nod forces in the area.", "EVA", HSLColor.FromHex("00FF00"))
        end)
        
        Trigger.AfterDelay(DateTime.Seconds(16), function()
          Reinforce({'e1', 'e1', 'e1', 'e1', 'e1'}, true, GDIRSpawn1, GDIRUnload1)
          Reinforce({'e2', 'e2', 'e2', 'e2', 'e2'}, false, GDIRSpawn2, GDIRUnload2)
          Reinforce({'e3', 'e3', 'e3', 'e3', 'e3'}, false, GDIRSpawn3, GDIRUnload3)
        end)
        
        Trigger.AfterDelay(DateTime.Seconds(22), function()
          Reinforce({'amphapc'}, true, GDIRSpawn1, GDIRUnload1)
          Reinforce({'amphapc'}, false, GDIRSpawn2, GDIRUnload2)
          Reinforce({'amphapc'}, false, GDIRSpawn3, GDIRUnload3)
        end)
        
        Trigger.AfterDelay(DateTime.Seconds(28), function()
          Reinforce({'e6', 'e6', 'e6', 'e6', 'e6'}, true, GDIRSpawn3, GDIRUnload3)
        end)
        
        Trigger.AfterDelay(DateTime.Seconds(60), function()
          Media.PlaySound("Eva-TargetLocated.aud")
          Media.DisplayMessage("We have received a transmission from Agent Delphi.\nHe is awaiting evacuation in a village to the southwest.", "EVA", HSLColor.FromHex("00FF00"))
          Actor.Create("flare", true, { Owner = GoodGuy, Location = FlareSpawn.Location })
          local delphi = Actor.Create("delphi", true, { Owner = FakeGDI, Location = DelphiSpawn.Location })
          Trigger.OnKilled(delphi, function(self, killer)
			Camera.Position = delphi.CenterPosition
            Media.DisplayMessage("Agent Delphi has been killed!", "NOTICE", HSLColor.FromHex("FF0000"))
            Trigger.AfterDelay(DateTime.Seconds(3), PlayerFailMission)
          end)
        end)
        
        Trigger.AfterDelay(DateTime.Seconds(67), function()
          Media.DisplayMessage("Agent Delphi has also revealed the locations of two subsidiary Nod bases to the north and northwest.", "EVA", HSLColor.FromHex("00FF00"))
          local nodBaseCam1 = Actor.Create("camera", true, { Owner = GDI, Location = NodBaseRvl1.Location })
          local nodBaseCam2 = Actor.Create("camera", true, { Owner = GDI, Location = NodBaseRvl2.Location })
          Trigger.AfterDelay(DateTime.Seconds(10), function()
            nodBaseCam1.Destroy()
            nodBaseCam2.Destroy()
          end)
        end)
      end
    end

	end
end


PlayerFailMission = function()
  if DestroyTurretsObjective ~= nil and not GDI.IsObjectiveCompleted(DestroyTurretsObjective) then
    GDI.MarkFailedObjective(DestroyTurretsObjective)
  end
  if RescueDelphiObjective ~= nil and not GDI.IsObjectiveCompleted(RescueDelphiObjective) then
    GDI.MarkFailedObjective(RescueDelphiObjective)
  end
end