
CabalHand3Destroyed = false
EngyHideBuildingDestroyed = false
FTnkTriggered = false
EngyFleeTriggered = false
SawRuinedBase = false
TriggeredTownAttack = false
TriggeredFinalPursuit = false
TriggeredBlockadeProduction = false


ActorRemovals =
{
  easy = { },
  normal = {  },
  hard = {  },
}


-- CabalHand3 Attack Production Behavior -----

Hand3Production = function()
  if CabalHand3 ~= nil and not CabalHand3.IsDead then
    Reinforcements.Reinforce(Cabal, {'cyborg', 'cyborg', 'cyborg'}, { CabalNESpawn.Location }, 5, function(cyb)
      cyb.AttackMove(CabalNEMoveTo.Location)
      cyb.Hunt()
    end)
  end

  Trigger.AfterDelay(DateTime.Seconds(120), Hand3Production)
end

-- End CabalHand3 Attack Production Behavior -----

-- CabalHand2 Attack Production Behavior -----

Hand2Production = function()
  local counter = {'cyborg', 'cyborg', 'cyborg'}
  if Difficulty == 'normal' then
    counter = {'cyborg', 'cyborg', 'cyborg', 'cyborg', 'cyborg'}
  elseif Difficulty == 'hard' then
    counter = {'cyborg', 'cyborg', 'cyborg', 'cyborg', 'cyborg', 'cyborg', 'cyborg'}
  end
  
  if CabalHand2 ~= nil and not CabalHand2.IsDead then
    Reinforcements.Reinforce(Cabal, counter, { BlockadeSpawn.Location }, 45, function(cyb)
      cyb.AttackMove(BlockadeAtkTo.Location)
      cyb.Hunt()
    end)
  end

  Trigger.AfterDelay(DateTime.Seconds(100), Hand2Production)
end

-- End CabalHand2 Attack Production Behavior -----


WorldLoaded = function()

  Nod = Player.GetPlayer("Nod")
  Cabal = Player.GetPlayer("Cabal")
  Cabal2 = Player.GetPlayer("Cabal2")
  FakeNod = Player.GetPlayer("FakeNod")
  RuinedNod = Player.GetPlayer("RuinedNod")
  Civilians = Player.GetPlayer("Civilians")
  Neutral = Player.GetPlayer("Neutral")
  
  MissionPlayer = Nod

	BadGuy = Player.GetPlayer("BadGuy")

	coopInfo =
	{
		Mainplayer = Nod,
		MainEnemies = {Cabal, Cabal2},
		Dummyplayer = BadGuy
	}
	
	ORAMod = "tibalt"
	CoopInit25(coopInfo)
	
	BaseShared = true
	TechShared = true
	MoneyShareOverride = 100

  Camera.Position = StartCam.CenterPosition
  Actor.Create("camera.small", true, { Owner = Nod, Location = Montauk.Location })
  
  --Remove actors based on difficulty
  Utils.Do(ActorRemovals[Difficulty], function(unit)
    unit.Destroy()
  end)
  
  --Special lighting
  Lighting.Ambient = 1.25
  Lighting.Red = 1.1
  Lighting.Blue = 0.3
  Lighting.Green = 1.0
  
  --Player Reinforcements
  Trigger.OnKilled(EngyHideBuilding, function(self, killer) EngyHideBuildingDestroyed = true end)
  
  Trigger.OnAllKilled( {EngyKiller1, EngyKiller2, EngyKiller3, EngyKiller4}, function()
    if EngyHideBuildingDestroyed == false then
      Reinforcements.Reinforce(BadGuy, {'e6', 'e6', 'e6', 'e6'}, { EngySavedSpawn.Location }, 5, function(engy)
        engy.Move(EngySavedMoveTo.Location)
      end)
      Media.PlaySound("Eva-TargetRescued.aud")
      Media.DisplayMessage("Thanks for the rescue!", "Engineer", HSLColor.FromHex("FF0000"))
    end
  end)
  
  --Objectives
  InitObjectives(Nod)

  Trigger.AfterDelay(DateTime.Seconds(10), function()
    EscapeObjective = Nod.AddObjective("Escape to the Montauk in the west.")
    Media.PlaySound("Eva-SignalFlareWest.aud")
    Trigger.AfterDelay(DateTime.Seconds(5), function()
      BeginningCutsceneCam.Destroy()
    end)
  end)
  
  --AI player behavior
  Cabal.Cash = 90000
  SetupRefAndSilosCaptureCredits(RuinedNod, 2500)
  
  Trigger.AfterDelay(DateTime.Seconds(12), function()
    Actor.Create("pbox", true, { Owner = Cabal, Location = CabalPbox1.Location })
  end)
  
  Trigger.AfterDelay(DateTime.Seconds(24), function()
    Actor.Create("pbox", true, { Owner = Cabal, Location = CabalPbox2.Location })
  end)
  
  Trigger.OnKilled(CabalHand3, function(self, killer) CabalHand3Destroyed = true end)
  
  Utils.Do( {CabalNEDef1, CabalNEDef2, CabalNEDef3}, function(def)
    Trigger.OnKilled(def, function(self, killer)
      if CabalHand3Destroyed == false then
        Reinforcements.Reinforce(Cabal, {'cyborg', 'cyborg', 'cyborg', 'cyborg', 'cyborg'}, { CabalNESpawn.Location }, 5, function(cyb)
          cyb.AttackMove(CabalNEMoveTo.Location)
          cyb.Hunt()
        end)
      end
    end)
  end)
  
  if Difficulty == 'hard' then
    Trigger.AfterDelay(DateTime.Seconds(120), Hand3Production)
  end
  
  Trigger.OnEnteredProximityTrigger(BlockadeProdTrig.CenterPosition, WDist.New(4 * 1024), function(a, id)
    if TriggeredBlockadeProduction == false and IsOwnedByCoopPlayer(a) and a.Type ~= 'camera' and a.Type ~= 'camera.small' then
      Trigger.RemoveProximityTrigger(id)
      TriggeredBlockadeProduction = true
      
      Hand2Production()
      local hand2Cam = Actor.Create('camera', true, { Owner = Nod, Location = BlockadeSpawn.Location })
      Trigger.AfterDelay(DateTime.Seconds(20), function() hand2Cam.Destroy() end)
    end
  end)
  
  Utils.Do( {BlockadeDef1, BlockadeDef2, BlockadeDef3, BlockadeDef4, BlockadeDef5, BlockadeDef6, BlockadeDef7}, function(def)
    Trigger.OnKilled(def, function(self, killer)
      if TriggeredBlockadeProduction == false then
        TriggeredBlockadeProduction = true
        Hand2Production()
        local hand2Cam = Actor.Create('camera', true, { Owner = Nod, Location = BlockadeSpawn.Location })
        Trigger.AfterDelay(DateTime.Seconds(20), function() hand2Cam.Destroy() end)
      end
    end)
  end)
  
  
  --Enemy Predeployed Maneuvers
  Trigger.AfterDelay(DateTime.Seconds(5), function()
    BeginningCutsceneCam = Actor.Create("camera", true, { Owner = Nod, Location = StartCam.Location })
    Media.DisplayMessage("There is no escape for you, flesh bag.", "Cabal", HSLColor.FromHex("AE18B8"))
    Media.PlaySound("CabalM1201.aud")
    
    local pursuers = Map.ActorsInBox(InitialPursuitNW.CenterPosition, InitialPursuitSE.CenterPosition, function(a)
      return a.Owner == Cabal and a.Type == 'cyborg'
    end)
    
    Utils.Do(pursuers, function(unit)
      unit.AttackMove(InitialPursuitGoto.Location)
      unit.Hunt()
    end)
  end)
  
  if Difficulty ~= 'easy' then
    Trigger.AfterDelay(DateTime.Seconds(12), function()
      local tran1 = Actor.Create("tran", true, { Owner = Cabal, Location = Tran1Spawn.Location })
      tran1.Move(Tran1MoveTo.Location)
      tran1.Land(Tran1MoveTo)
      tran1.CallFunc(function()
        if not tran1.IsDead then
          local tranCam = Actor.Create("camera", true, { Owner = Nod, Location = InitialPursuitGoto.Location })
          Trigger.AfterDelay(DateTime.Seconds(10), function() tranCam.Destroy() end)
          
          Trigger.AfterDelay(DateTime.Seconds(1), function()
            Reinforcements.Reinforce(Cabal2, {'cyborg', 'cyborg', 'cyborg'}, { Tran1MoveTo.Location }, 5, function(cyb)
              cyb.Patrol({PatrolRouteB1.Location, PatrolRouteB2.Location, PatrolRouteB3.Location}, true, DateTime.Seconds(10))
            end)
          end)
        end
      end)
      
      local tran2 = Actor.Create("tran", true, { Owner = Cabal, Location = Tran2Spawn.Location })
      tran2.Move(Tran2MoveTo.Location)
      tran2.Land(Tran2MoveTo)
      tran2.CallFunc(function()
        if not tran2.IsDead then
          Trigger.AfterDelay(DateTime.Seconds(1), function()
            Reinforcements.Reinforce(Cabal2, {'cyborg', 'cyborg', 'cyborg'}, { Tran2MoveTo.Location }, 5, function(cyb)
              cyb.Patrol({PatrolRouteB1.Location, PatrolRouteB2.Location, PatrolRouteB3.Location}, true, DateTime.Seconds(10))
            end)
          end)
        end
      end)
    end)
  end

  Utils.Do( {PatrolA1, PatrolA2, PatrolA3}, function(unit)
    unit.Patrol( {PatrolRouteA1.Location, PatrolRouteA2.Location, PatrolRouteA3.Location, PatrolRouteA4.Location}, true, DateTime.Seconds(5))
  end)

  Utils.Do( {BaseGuard1, BaseGuard2}, function(unit)
    unit.Patrol( {BaseGuardRoute1.Location, BaseGuardRoute2.Location, BaseGuardRoute3.Location}, true, DateTime.Seconds(5))
  end)
  
  Utils.Do( {FTnkTrig1, FTnkTrig2, FTnkTrig3, FTnkTrig4, FTnkTrig5}, function(wp)
    Trigger.OnEnteredProximityTrigger(wp.CenterPosition, WDist.New(2 * 1024), function(a, id)
      if FTnkTriggered == false and IsOwnedByCoopPlayer(a) and a.Type ~= 'camera' and a.Type ~= 'camera.small' then
        FTnkTriggered = true
        Trigger.RemoveProximityTrigger(id)
        local ftnkCam = Actor.Create("camera", true, { Owner = Nod, Location = FTnkCam.Location })
        Trigger.AfterDelay(DateTime.Seconds(10), function() ftnkCam.Destroy() end)
        
        Utils.Do( {FTnk1, FTnk2}, function(unit)
          unit.Patrol( {FTnkPatrol1.Location, FTnkPatrol2.Location, FTnkPatrol3.Location}, true, DateTime.Seconds(10))
        end)
      end
    end)
  end)
  
  Utils.Do( {EngyFlee1, EngyFlee2}, function(wp)
    Trigger.OnEnteredProximityTrigger(wp.CenterPosition, WDist.New(3 * 1024), function(a, id)
      if EngyFleeTriggered == false and IsOwnedByCoopPlayer(a) and a.Type ~= 'camera' and a.Type ~= 'camera.small' then
        EngyFleeTriggered = True
        Trigger.RemoveProximityTrigger(id)
        
        local engyCam = Actor.Create("camera", true, { Owner = Nod, Location = EngyRunCam.Location })
        Trigger.AfterDelay(DateTime.Seconds(15), function() engyCam.Destroy() end)
        local engyCam2 = Actor.Create("camera", true, { Owner = Nod, Location = EngyRunTo.Location })
        Trigger.AfterDelay(DateTime.Seconds(25), function() engyCam2.Destroy() end)
        
        Utils.Do( {Engy1, Engy2, Engy3, Engy4}, function(engy)
          engy.Move(EngyRunTo.Location)
          engy.Destroy()
        end)
        
        EngyKiller1.Attack(EngyHideBuilding)
        EngyKiller2.Attack(EngyHideBuilding)
        EngyKiller3.AttackMove(EngyKillerMoveTo.Location)
        EngyKiller4.AttackMove(EngyKillerMoveTo.Location)
      end
    end)
  end)

  --Proximity Triggers/Reveals
  Trigger.OnEnteredProximityTrigger(NodBikes.CenterPosition, WDist.New(3 * 1024), function(a, id)
    if IsOwnedByCoopPlayer(a) then
      Trigger.RemoveProximityTrigger(id)
      Utils.Do( {NodBike1, NodBike2, NodBike3}, function(unit) unit.Owner = BadGuy end)
      Media.PlaySound("Eva-TargetRescued.aud")
    end
  end)
  
  Trigger.OnEnteredProximityTrigger(NodLtnks.CenterPosition, WDist.New(3 * 1024), function(a, id)
    if IsOwnedByCoopPlayer(a) then
      Trigger.RemoveProximityTrigger(id)
      Utils.Do( {NodLtnk1, NodLtnk2}, function(unit) unit.Owner = BadGuy end)
      Media.PlaySound("Eva-TargetRescued.aud")
    end
  end)
  
  Trigger.OnEnteredProximityTrigger(NodE3s.CenterPosition, WDist.New(3 * 1024), function(a, id)
    if IsOwnedByCoopPlayer(a) then
      Trigger.RemoveProximityTrigger(id)
      Utils.Do( {NodE31, NodE32, NodE33}, function(unit) unit.Owner = BadGuy end)
      Media.PlaySound("Eva-TargetRescued.aud")
    end
  end)
  
  Trigger.OnEnteredProximityTrigger(BlockadeCamTrig.CenterPosition, WDist.New(4 * 1024), function(a, id)
    if IsOwnedByCoopPlayer(a) and a.Type ~= 'camera' and a.Type ~= 'camera.small' then
      Trigger.RemoveProximityTrigger(id)
      local blockadeCam = Actor.Create("camera", true, { Owner = Nod, Location = BlockadeCam.Location })
      Trigger.AfterDelay(DateTime.Seconds(10), function() blockadeCam.Destroy() end)
    end
  end)
  
  Utils.Do( {RuinedBaseTrig1, RuinedBaseTrig2, RuinedBaseTrig3}, function(wp)
    Trigger.OnEnteredProximityTrigger(wp.CenterPosition, WDist.New(3 * 1024), function(a, id)
      if SawRuinedBase == false and IsOwnedByCoopPlayer(a) and a.Type ~= 'camera' and a.Type ~= 'camera.small' then
        Trigger.RemoveProximityTrigger(id)
        SawRuinedBase = true
        local ruinedBaseCam = Actor.Create("camera", true, { Owner = Nod, Location = RuinedBaseCam.Location })
        Trigger.AfterDelay(DateTime.Seconds(10), function() ruinedBaseCam.Destroy() end)
      end
    end)
  end)
  
  Utils.Do( {TownAtkTrig1, TownAtkTrig2, TownAtkTrig3, TownAtkTrig4}, function(wp)
    Trigger.OnEnteredProximityTrigger(wp.CenterPosition, WDist.New(2 * 1024), function(a, id)
      if TriggeredTownAttack == false and IsOwnedByCoopPlayer(a) and a.Type ~= 'camera' and a.Type ~= 'camera.small' then
        Trigger.RemoveProximityTrigger(id)
        TriggeredTownAttack = true
        
        local townCam = Actor.Create("camera", true, { Owner = Nod, Location = TownAtkCam.Location })
        Trigger.AfterDelay(DateTime.Seconds(15), function() townCam.Destroy() end)
        
        local townCam2 = Actor.Create("camera", true, { Owner = Nod, Location = SpawnCiv2.Location })
        Trigger.AfterDelay(DateTime.Seconds(15), function() townCam2.Destroy() end)
        
        local townFtnk = Actor.Create("ftnk", true, { Owner = Cabal, Location = FTnkSpawn.Location })
        townFtnk.Attack( Industrial )
        
        local townCyborg1 = Actor.Create("cyborg", true, { Owner = Cabal, Location = CyborgSpawn1.Location })
        townCyborg1.Attack( LiquidTank )
        
        local townCyborg2 = Actor.Create("cyborg", true, { Owner = Cabal, Location = CyborgSpawn2.Location })
        townCyborg2.Attack( House1 )
        
        local townCyborg3 = Actor.Create("cyborg", true, { Owner = Cabal, Location = CyborgSpawn3.Location })
        townCyborg3.Move(Cyborg3MoveTo.Location)
        
        local townCyborg4 = Actor.Create("cyborg", true, { Owner = Cabal, Location = CyborgSpawn4.Location })
        townCyborg4.Move(Cyborg4MoveTo.Location)
        
        local civvie1 = Actor.Create("c2", true, { Owner = Neutral, Location = SpawnCiv1.Location })
        local civvie2 = Actor.Create("c3", true, { Owner = Neutral, Location = SpawnCiv2.Location })
        local civvie3 = Actor.Create("c4", true, { Owner = Neutral, Location = SpawnCiv3.Location })
        local civvie4 = Actor.Create("c5", true, { Owner = Neutral, Location = SpawnCiv4.Location })
        local civvie5 = Actor.Create("c6", true, { Owner = Neutral, Location = SpawnCiv5.Location })
        local civvie6 = Actor.Create("c7", true, { Owner = Neutral, Location = SpawnCiv6.Location })
        
        civvie1.Move(CivMoveTo1.Location)
        civvie1.CallFunc(function()
          local civCam1 = Actor.Create("camera", true, { Owner = Nod, Location = CivMoveTo1.Location })
          Trigger.AfterDelay(DateTime.Seconds(10), function() civCam1.Destroy() end)
        end)
        civvie1.Move(CivMoveTo2.Location)
        civvie1.CallFunc(function()
          local civCam2 = Actor.Create("camera.small", true, { Owner = Nod, Location = CivMoveTo2.Location })
          Trigger.AfterDelay(DateTime.Seconds(10), function() civCam2.Destroy() end)
          Gate.Destroy()
          Trigger.AfterDelay(DateTime.Seconds(7), function()
            Actor.Create("barrier", true, { Owner = Cabal, Location = GateSpawn.Location })
          end)
        end)
        civvie1.CallFunc(function()
          Trigger.AfterDelay(DateTime.Seconds(2), function()
            civvie1.Move(CivMoveTo3.Location)
          end)
        end)
        
        Utils.Do( {civvie2, civvie3, civvie4, civvie5, civvie6}, function(civ)
          civ.Move(CivMoveTo1.Location)
          civ.Move(CivMoveTo2.Location)
          civ.CallFunc(function()
            Trigger.AfterDelay(DateTime.Seconds(2), function()
              civ.Move(CivMoveTo3.Location)
            end)
          end)
        end)
      end
    end)
  end)
  
  if Difficulty ~= 'easy' then
    Trigger.OnEnteredProximityTrigger(FinalPursuitTrig.CenterPosition, WDist.New(2 * 1024), function(a, id)
      if TriggeredFinalPursuit == false and IsOwnedByCoopPlayer(a) and a.Type ~= 'camera' and a.Type ~= 'camera.small' then
        Trigger.RemoveProximityTrigger(id)
        TriggeredFinalPursuit = true
        
        local finalPursuers = { 'cyborg', 'cyborg', 'cyborg', 'cyborg', 'cyborg', 'ltnk', 'ftnk' }
        
        Utils.Do( {FinalPursuitSpawn1, FinalPursuitSpawn2, FinalPursuitSpawn3}, function(wp)
          Reinforcements.Reinforce(Cabal, finalPursuers, { wp.Location }, 90, function(cyb)
            cyb.AttackMove(FinalPursuitMoveTo.Location)
          end)
        end)
      end
    end)
  end
  
  Trigger.OnEnteredProximityTrigger(Montauk.CenterPosition, WDist.New(4 * 1024), function(a, id)
    if IsOwnedByCoopPlayer(a) and a.Type ~= 'flare' and a.Type ~= 'camera' and a.Type ~= 'camera.small' then
      Trigger.RemoveProximityTrigger(id)
      Media.DisplayMessage("Glad to see you made it out alive, Commander.\nLet's get out of here!", "Sierra", HSLColor.FromHex("FF0000"))
      Media.PlaySound("SierraM1201.aud")
      Trigger.AfterDelay(DateTime.Seconds(3), function()
        Nod.MarkCompletedObjective(EscapeObjective)
      end)
    end
  end)
  
  --Timer

  --Crate spawns
  
  --Testing
end


Tick = function()
	AssignToCoopPlayers(BadGuy.GetActorsByType("e6"), nil, true)
	OncePerSecondChecks()
	OncePerThreeSecondChecks()
end

OncePerSecondChecks = function()
  if DateTime.GameTime > 1 and DateTime.GameTime % 25 == 0 then
    --none
  end
end

OncePerThreeSecondChecks = function()
	if DateTime.GameTime > 1 and DateTime.GameTime % 75 == 0 then
    --[[if HasOneOf(Nod, LossCheckAll) == false then
      PlayerFailMission()
    end]]
	TibAltCoopLossCheck()
    
    --Manipulate AI funds
    Cabal.Cash = 10000
	end
end


PlayerFailMission = function()
  if EscapeObjective ~= nil and not Nod.IsObjectiveCompleted(EscapeObjective) then
    Nod.MarkFailedObjective(EscapeObjective)
  end
end
