
FirstPlayerBaseDead = false
ForwardFactExists = false
MainBaseCountered = false
SamsDestroyed = false
BackupSubNodProductionActivated = false

--Elena taunts
SawElenaWinningTaunt1 = false
SawElenaWinningTaunt2 = false
SawElenaCapturedTaunt = false
SawElenaSellTaunt = false
SawElenaLossTaunt = false


ActorRemovals =
{
  easy = { MCV, ForwardDefA1, ForwardDefA2, ForwardDefA3, ForwardDefB1, ForwardDefB2, ForwardDefB3, ForwardDefC1, ForwardDefC2, ForwardDefC3, EZR1, EZR2, EZR3, EZR4 },
  normal = { },
  hard = { ForwardDefA1, ForwardDefA2, ForwardDefA3 },
}


SellBuildingIfEngyNearWithTaunt = function(building, enemy, distance)
  if distance == nil then distance = 4 end
  Trigger.OnEnteredProximityTrigger(building.CenterPosition, WDist.New(distance * 1024), function(a, id)
    --if a.Owner == enemy and a.Type == 'e6' then
	if IsOwnedByCoopPlayer(a) and a.Type == 'e6' then
      Trigger.RemoveProximityTrigger(id)
      if building ~= nil and not building.IsDead then
        building.Sell()
        if SawElenaSellTaunt == false then
          SawElenaSellTaunt = true
          Media.PlaySound('Elena-11M-03.aud')
          Media.DisplayMessage("That is mine, comrade, not yours.\nWe are not communists here.", "Elena Cherkovna", HSLColor.FromHex("FF0000"))
        end
      end
    end
  end)
end


-- Helicopter Attack Production Behavior -----

HeliAttackDelayMin = { easy = DateTime.Seconds(300), normal = DateTime.Seconds(270), hard = DateTime.Seconds(240) }
HeliAttackDelayMax = { easy = DateTime.Seconds(360), normal = DateTime.Seconds(300), hard = DateTime.Seconds(270) }

HeliProduction = function()
  Utils.Do( { NodHpad1, NodHpad2, NodHpad3, NodHpad4, NodHpad5, NodHpad6 }, function(hpad)
    if hpad ~= nil and not hpad.IsDead then
      Actor.Create('heli', true, { Owner = SubNod, Location = hpad.Location })
    end
  end)

  Trigger.AfterDelay(Utils.RandomInteger(HeliAttackDelayMin[Difficulty], HeliAttackDelayMax[Difficulty]), HeliProduction)
end

-- End Helicopter Attack Production Behavior -----


-- SubNod Attack Production Behavior -----

SubNodAttackDelayMin = { easy = DateTime.Seconds(120), normal = DateTime.Seconds(90), hard = DateTime.Seconds(60) }
SubNodAttackDelayMax = { easy = DateTime.Seconds(150), normal = DateTime.Seconds(120), hard = DateTime.Seconds(90) }

SubNodProduction = function()
  if SubNodAfld ~= nil and not SubNodAfld.IsDead then
    local production = Utils.Random(NodAttackVehicleTypes[Difficulty])
    local toBuild = function() return production end
    local path = { AttackAngle2.Location }
    
    ProduceUnits(SubNod, SubNodAfld, nil, toBuild, function(units)
      Utils.Do(units, function(unit)
        ErrorGuardAttackPatrol(unit, path)
        AssaultPlayerBaseOrHunt(unit)
      end)
    end)
  end
  
  if SubNodHand1 ~= nil and not SubNodHand1.IsDead then
    local production = Utils.Random(NodAttackInfantryTypes[Difficulty])
    local toBuild = function() return production end
    local path = { AttackAngle4.Location }
    
    ProduceUnits(SubNod, SubNodHand1, nil, toBuild, function(units)
      Utils.Do(units, function(unit)
        unit.Patrol(path, false)
        AssaultPlayerBaseOrHunt(unit)
      end)
    end)
  end
  
  if BackupSubNodProductionActivated == true then
    Utils.Do( {SubNodHand2, SubNodHand3}, function(factory)
      if factory ~= nil and not factory.IsDead then
        local production = Utils.Random(NodAttackInfantryTypes[Difficulty])
        local toBuild = function() return production end
        local path = { AttackAngle3.Location }
        
        ProduceUnits(SubNod, factory, nil, toBuild, function(units)
          Utils.Do(units, function(unit)
            unit.Patrol(path, false)
            AssaultPlayerBaseOrHunt(unit)
          end)
        end)
      end
    end)
  end
  
  Trigger.AfterDelay(Utils.RandomInteger(SubNodAttackDelayMin[Difficulty], SubNodAttackDelayMax[Difficulty]), SubNodProduction)
end

-- End SubNod Attack Production Behavior -----


-- Nod Attack Production Behavior -----

NodAttackDelayMin = { easy = DateTime.Seconds(45), normal = DateTime.Seconds(30), hard = DateTime.Seconds(15) }
NodAttackDelayMax = { easy = DateTime.Seconds(60), normal = DateTime.Seconds(45), hard = DateTime.Seconds(30) }

NodAttackPaths =
{
  { AttackAngle1.Location },
  { AttackAngle2.Location },
  { AttackAngle3.Location },
}

NodAttackInfantryTypes = {
  easy = {
    { "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1" },
    { "e1", "e1", "e1", "e1", "e1", "e3", "e3", "e3", "e3", "e3" },
    { "e3", "e3", "e3", "e3", "e3" },
    { "e4", "e4", "e4", "e4", "e4" },
  },
  normal = {
    { "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1" },
    { "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e3", "e3", "e3", "e3" },
    { "e3", "e3", "e3", "e3", "e3", "e3", "e3", "e3" },
    { "e4", "e4", "e4", "e4", "e4", "e4", "e4", "e4" },
  },
  hard = {
    { "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1" },
    { "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e3", "e3", "e3", "e3", "e3" },
    { "e3", "e3", "e3", "e3", "e3", "e3", "e3", "e3", "e3", "e3" },
    { "e4", "e4", "e4", "e4", "e4", "e4", "e4", "e4", "e4", "e4", },
  }
}

NodAttackVehicleTypes = {
  easy = {
    { "ltnk", "ltnk", "ltnk", "ltnk" },
    { "ftnk", "ftnk", "ftnk", "ftnk" },
    { "ltnk", "ltnk", "ftnk", "ftnk" },
    { "ltnk", "ftnk", "ftnk", "arty", "arty" },
    { "ftnk", "ftnk", "ftnk", "arty", "arty" },
    { "ltnk", "ltnk", "ltnk", "arty", "arty" },
  },
  normal = {
    { "ltnk", "ltnk", "ltnk", "ltnk", "ltnk", "ltnk" },
    { "ftnk", "ftnk", "ftnk", "ftnk", "ftnk", "ftnk" },
    { "ltnk", "ltnk", "ltnk", "ftnk", "ftnk", "ftnk" },
    { "ltnk", "ltnk", "ftnk", "ftnk", "arty", "arty", "arty" },
    { "ftnk", "ftnk", "ftnk", "ftnk", "ftnk", "arty", "arty" },
    { "ltnk", "ltnk", "ltnk", "ltnk", "ltnk", "arty", "arty" },
  },
  hard = {
    { "ltnk", "ltnk", "ltnk", "ltnk", "ltnk", "ltnk", "ltnk", "ltnk" },
    { "ftnk", "ftnk", "ftnk", "ftnk", "ftnk", "ftnk", "ftnk", "ftnk" },
    { "ltnk", "ltnk", "ltnk", "ltnk", "ftnk", "ftnk", "ftnk", "ftnk" },
    { "ltnk", "ltnk", "ltnk", "ftnk", "ftnk", "ftnk", "arty", "arty", "arty" },
    { "ftnk", "ftnk", "ftnk", "ftnk", "ftnk", "ftnk", "arty", "arty", "arty" },
    { "ltnk", "ltnk", "ltnk", "ltnk", "ltnk", "ltnk", "arty", "arty", "arty" },
  }
}

NodInfantryProduction = function()
  local production = Utils.Random(NodAttackInfantryTypes[Difficulty])
  local path = Utils.Random(NodAttackPaths)
  local toBuild = function() return production end
  local factory = GetAvailableFactoryInBox(Nod, 'hand', MainBaseNW, MainBaseSE)
  
  if factory ~= nil then
    ProduceUnits(Nod, factory, nil, toBuild, function(units)
      UpdatePlayerBaseLocation()
      Utils.Do(units, function(unit)
        ErrorGuardAttackPatrol(unit, path)
        AssaultPlayerBaseOrHunt(unit)
      end)
      Trigger.AfterDelay(Utils.RandomInteger(NodAttackDelayMin[Difficulty], NodAttackDelayMax[Difficulty]), NodInfantryProduction)
    end)
  else
    Trigger.AfterDelay(Utils.RandomInteger(NodAttackDelayMin[Difficulty], NodAttackDelayMax[Difficulty]), NodInfantryProduction)
  end
end


NodVehicleProduction = function()
  local production = Utils.Random(NodAttackVehicleTypes[Difficulty])
  local path = Utils.Random(NodAttackPaths)
  local toBuild = function() return production end
  local factory = GetAvailableFactoryInBox(Nod, 'afld', MainBaseNW, MainBaseSE)
  
  if factory ~= nil then
    ProduceUnits(Nod, factory, nil, toBuild, function(units)
      UpdatePlayerBaseLocation()
      Utils.Do(units, function(unit)
        ErrorGuardAttackPatrol(unit, path)
        AssaultPlayerBaseOrHunt(unit)
      end)
      Trigger.AfterDelay(Utils.RandomInteger(NodAttackDelayMin[Difficulty], NodAttackDelayMax[Difficulty]), NodVehicleProduction)
    end)
  else
    Trigger.AfterDelay(Utils.RandomInteger(NodAttackDelayMin[Difficulty], NodAttackDelayMax[Difficulty]), NodVehicleProduction)
  end  
end

-- End Nod Attack Production Behavior -----


-- Elena's AI base building behavior -----

BuildBaseOrders = {
  ["hand"] = { structure = "hand", loc = BuildHand.Location, tim = 12 },
  ["afld"] = { structure = "afld", loc = BuildAfld.Location, tim = 60 },
  ["nuk2"] = { structure = "nuk2", loc = BuildNuk2.Location, tim = 84 },
  ["proc"] = { structure = "proc", loc = BuildProc.Location, tim = 120 },
  
  ["pbox1"]  =   { structure = "pbox",   loc = BuildPbox1.Location,    tim = 24 },
  ["pbox2"]  =   { structure = "pbox",   loc = BuildPbox2.Location,    tim = 48 },
  ["pbox3"]  =   { structure = "pbox",   loc = BuildPbox3.Location,    tim = 96 },
  ["gun1"]  =    { structure = "gun",    loc = BuildGun1.Location,     tim = 120 },
  ["gun2"]  =    { structure = "gun",    loc = BuildGun2.Location,     tim = 144 },
  ["gun3"]  =    { structure = "gun",    loc = BuildGun3.Location,     tim = 168 },
  ["gun4"]  =    { structure = "gun",    loc = BuildGun7.Location,     tim = 192 },
  ["gun5"]  =    { structure = "gun",    loc = BuildGun8.Location,     tim = 216 },
  ["gun6"]  =    { structure = "gun",    loc = BuildGun9.Location,     tim = 240 },
  ["gun7"]  =    { structure = "gun",    loc = BuildGun4.Location,     tim = 264 },
  ["gun8"]  =    { structure = "gun",    loc = BuildGun5.Location,     tim = 288 },
  ["gun9"]  =    { structure = "gun",    loc = BuildGun6.Location,     tim = 312 },
}

BuildElenaBase = function()
  for id, orders in pairs(BuildBaseOrders) do
    Trigger.AfterDelay(DateTime.Seconds(orders.tim), function()
      if ForwardFactExists == true then
        local newBuilding = Actor.Create(orders.structure, true, { Owner = Nod2, Location = orders.loc })
        AutoRebuildBuilding(newBuilding, Nod2)
        if id == 'hand' then
          SellBuildingIfEngyNearWithTaunt(newBuilding, GDI)
          Trigger.AfterDelay(DateTime.Seconds(5), function() ForwardBaseInfantryProduction() end)
        elseif id == 'afld' then
          SellBuildingIfEngyNearWithTaunt(newBuilding, GDI)
          Trigger.AfterDelay(DateTime.Seconds(5), function() ForwardBaseVehicleProduction() end)
        elseif id == 'proc' then
          SellBuildingIfEngyNearWithTaunt(newBuilding, GDI)
          AutoReplaceHarvesters(Nod2)
        end
      end
    end)
  end
end


ForwardBaseDelayMin = { easy = DateTime.Seconds(60), normal = DateTime.Seconds(45), hard = DateTime.Seconds(30) }
ForwardBaseDelayMax = { easy = DateTime.Seconds(90), normal = DateTime.Seconds(60), hard = DateTime.Seconds(45) }

ForwardBaseAttackPaths =
{
  { AttackAngle3.Location },
}

ForwardBaseInfantryProduction = function()
  local production = Utils.Random(NodAttackInfantryTypes[Difficulty])
  local path = Utils.Random(ForwardBaseAttackPaths)
  local toBuild = function() return production end
  local factory = GetAvailableFactoryInBox(Nod2, 'hand', ForwardBaseNW, ForwardBaseSE)
  
  if factory ~= nil then
    ProduceUnits(Nod2, factory, nil, toBuild, function(units)
      UpdatePlayerBaseLocation()
      Utils.Do(units, function(unit)
        ErrorGuardAttackPatrol(unit, path)
        AssaultPlayerBaseOrHunt(unit)
      end)
      Trigger.AfterDelay(Utils.RandomInteger(ForwardBaseDelayMin[Difficulty], ForwardBaseDelayMax[Difficulty]), ForwardBaseInfantryProduction)
    end)
  else
    Trigger.AfterDelay(Utils.RandomInteger(ForwardBaseDelayMin[Difficulty], ForwardBaseDelayMax[Difficulty]), ForwardBaseInfantryProduction)
  end
end


ForwardBaseVehicleProduction = function()
  local production = Utils.Random(NodAttackVehicleTypes[Difficulty])
  local path = Utils.Random(ForwardBaseAttackPaths)
  local toBuild = function() return production end
  local factory = GetAvailableFactoryInBox(Nod2, 'afld', ForwardBaseNW, ForwardBaseSE)
  
  if factory ~= nil then
    ProduceUnits(Nod2, factory, nil, toBuild, function(units)
      UpdatePlayerBaseLocation()
      Utils.Do(units, function(unit)
        ErrorGuardAttackPatrol(unit, path)
        AssaultPlayerBaseOrHunt(unit)
      end)
      Trigger.AfterDelay(Utils.RandomInteger(ForwardBaseDelayMin[Difficulty], ForwardBaseDelayMax[Difficulty]), ForwardBaseVehicleProduction)
    end)
  else
    Trigger.AfterDelay(Utils.RandomInteger(ForwardBaseDelayMin[Difficulty], ForwardBaseDelayMax[Difficulty]), ForwardBaseInfantryProduction)
  end  
end

-- End Elena's AI base building behavior -----


WorldLoaded = function()
  GDI = Player.GetPlayer("GDI")
  FakeGDI = Player.GetPlayer("FakeGDI")
  Nod = Player.GetPlayer("Nod")
  Nod2 = Player.GetPlayer("Nod2")
  SubNod = Player.GetPlayer("SubNod")
  Neutral = Player.GetPlayer("Neutral")
  
  MissionPlayer = GDI

	GoodGuy = Player.GetPlayer("GoodGuy")

	coopInfo =
	{
		Mainplayer = GDI,
		MainEnemies = {Nod, Nod2, SubNod},
		Dummyplayer = GoodGuy
	}
	
	ORAMod = "tibalt"
	CoopInit25(coopInfo)
	
	--Override Sharing options
	BaseShared = true
	TechShared = true
	MoneyShareOverride = 100

  Camera.Position = StartCam.CenterPosition
  
  --Remove actors based on difficulty
  Utils.Do(ActorRemovals[Difficulty], function(unit)
    unit.Destroy()
  end)
  
  --Special lighting
  
  --Player Reinforcements

  --Objectives
  InitObjectives(GDI)

  Trigger.AfterDelay(DateTime.Seconds(2), function()
    DestroySamsObjective = GDI.AddObjective("Destroy all the outer (red) SAM sites.")
    EvacMoebiusObjective = GDI.AddObjective("Evacuate Dr. Moebius.")
  end)
  
  Trigger.OnKilled(DrMoebius, function(self, killer)
	Camera.Position = DrMoebius.CenterPosition
    Media.DisplayMessage("Dr. Moebius has been killed!", "NOTICE", HSLColor.FromHex("FF0000"))
    GDI.MarkFailedObjective(EvacMoebiusObjective)
  end)
  
  --AI player behavior
  Nod.Resources = Nod.ResourceCapacity - 500
  Nod.Cash = 90000
  
  Nod2.Cash = 90000
  
  SubNod.Resources = SubNod.ResourceCapacity - 500
  SubNod.Cash = 90000
  
  AutoRepairAndRebuildBuildings(Nod, 15)
  AutoRepairAndRebuildBuildings(Nod2, 15)
  
  AutoReplaceHarvesters(Nod)
  SetupRefAndSilosCaptureCredits(Nod)
  SetupRefAndSilosCaptureCredits(SubNod)
  
  SellBuildingIfEngyNearWithTaunt(SubNodAfld, GDI)
  SellBuildingIfEngyNearWithTaunt(SubNodHand1, GDI)
  SellBuildingIfEngyNearWithTaunt(SubNodHand2, GDI)
  SellBuildingIfEngyNearWithTaunt(SubNodHand3, GDI)
  
  SellBuildingIfEngyNearWithTaunt(NodHpad1, GDI)
  SellBuildingIfEngyNearWithTaunt(NodHpad2, GDI)
  SellBuildingIfEngyNearWithTaunt(NodHpad3, GDI)
  SellBuildingIfEngyNearWithTaunt(NodHpad4, GDI)
  SellBuildingIfEngyNearWithTaunt(NodHpad5, GDI)
  SellBuildingIfEngyNearWithTaunt(NodHpad6, GDI)
  
  if Difficulty == 'hard' then
    Trigger.AfterDelay(DateTime.Seconds(120), function()
      NodInfantryProduction()
      NodVehicleProduction()
      SubNodProduction()
    end)
  else
    Trigger.AfterDelay(DateTime.Seconds(300), function()
      NodInfantryProduction()
      NodVehicleProduction()
      SubNodProduction()
    end)
  end
  
  Trigger.AfterDelay(Utils.RandomInteger(HeliAttackDelayMin[Difficulty], HeliAttackDelayMax[Difficulty]), HeliProduction)
  
  Utils.Do( {SubNodAfld, SubNodHand1, SubNodHand2, SubNodHand3 }, function(building)
    Trigger.OnKilled(building, function(self, killer)
      BackupSubNodProductionActivated = true
    end)
  end)
  
  --Enemy Predeployed Maneuvers
  Trigger.AfterDelay(DateTime.Seconds(10), function()
    local attackers = Map.ActorsInBox(FirstThrustNW.CenterPosition, FirstThrustSE.CenterPosition, function(a)
      return a.Owner == Nod
    end)
    
    if Difficulty == 'normal' then
      Utils.Do(attackers, function(unit)
        unit.AttackMove(StartCam.Location, 1024 * 3)
        unit.AttackMove(SAPC2.Location)
      end)
    elseif Difficulty == 'hard' then
      Utils.Do(attackers, function(unit)
        unit.AttackMove(StartCam.Location, 1024 * 3)
        unit.AttackMove(FirstThrustDef.Location)
        unit.CallFunc(function()
          Trigger.AfterDelay(DateTime.Seconds(288), function()
            if not unit.IsDead then
              unit.AttackMove(SAPC2.Location)
              unit.Hunt()
            end
          end)
        end)
      end)
    else
      Utils.Do(attackers, function(unit)
        unit.AttackMove(StartCam.Location, 1024 * 3)
        unit.AttackMove(FirstThrustDef.Location)
      end)
    end
    
    Utils.Do({Arty1, Arty2, Arty3, Arty4}, function(unit)
      if not unit.IsDead then
        unit.Move(ArtyMoveTo.Location, 1024 * 2)
        Utils.Do({GDIFact, GDINuk2c, GDINuk2d, GDINuk2e}, function(target)
          if target ~= nil and not target.IsDead then unit.Attack(target) end
        end)
      end
    end)
  end)
  
  Trigger.AfterDelay(DateTime.Seconds(240), function()
    local playerFactories = Map.ActorsInBox(PlayerBaseNW.CenterPosition, PlayerBaseSE.CenterPosition, function(a)
      return IsOwnedByCoopPlayer(a) and (a.Type == 'pyle' or a.Type == 'weap' or a.Type == 'proc')
    end)
    
    if #playerFactories > 0 then
      EngyRushTargetPlayer = GDI
      EngyRushCaptureTargets = { GDINuk2a, GDIPyle, GDIWeap, GDIProc, GDIHq }
      EngyRushPath = { SAPC1.Location, SAPC2.Location }
      Reinforcements.ReinforceWithTransport(Nod, "apc", {"e6", "e6", "e6", "e6", "e6"}, { SAPCSpawn.Location }, null, ExecEngyRush)
    end
  end)
  
  if Difficulty ~= 'easy' then
    Trigger.AfterDelay(DateTime.Seconds(1200), function()
      local playerFactories = Map.ActorsInBox(PlayerBaseNW.CenterPosition, PlayerBaseSE.CenterPosition, function(a)
        return IsOwnedByCoopPlayer(a) and (a.Type == 'pyle' or a.Type == 'weap' or a.Type == 'proc')
      end)
      
      if #playerFactories > 0 then
        EngyRushTargetPlayer = GDI
        EngyRushCaptureTargets = { GDINuk2a, GDIPyle, GDIWeap, GDIProc, GDIFix }
        EngyRushPath = { EngyTranLand.Location }
        Reinforcements.ReinforceWithTransport(Nod, "tran", {"e6", "e6", "e6", "e6", "e6"}, { EngyTranSpawn.Location }, null, ExecEngyRush)
      end
    end)
  end
  
  Utils.Do({TriggerCounter1, TriggerCounter2, TriggerCounter3, TriggerCounter4, TriggerCounter5, TriggerCounter6}, function(waypoint)
    Trigger.OnEnteredProximityTrigger(waypoint.CenterPosition, WDist.New(3 * 1024), function(a, id)
      if IsOwnedByCoopPlayer(a) and a.Type ~= 'camera' then
        Trigger.RemoveProximityTrigger(id)
        if MainBaseCountered == false then
          MainBaseCountered = true
          
          local counterForce = Map.ActorsInBox(MainBaseNW.CenterPosition, MainBaseSE.CenterPosition, function(a)
            return a.Owner == Nod and (a.Type == 'ltnk' or a.Type == 'ftnk' or a.Type == 'arty' or a.Type == 'e1' or a.Type == 'e3' or a.Type == 'e4')
          end)
          
          Utils.Do(counterForce, function(unit) unit.Hunt() end)
        end
      end
    end)
  end)

  --Proximity Triggers/Reveals
  
  --Crate spawns
  
  --Taunts
  Trigger.AfterDelay(DateTime.Seconds(10), function()
    Media.PlaySound('Elena-11M-01.aud')
    Media.DisplayMessage("If you insist, comrade. We do this the hard way.", "Elena Cherkovna", HSLColor.FromHex("FF0000"))
  end)
  
  Utils.Do({GDINuk2a, GDINuk2b, GDIPyle, GDIWeap, GDIProc, GDIHq, GDIFix}, function(building)
    Trigger.OnCapture(building, function(self, captor, oldOwner, newOwner)
      if newOwner == Nod then
        if SawElenaCapturedTaunt == false then
          SawElenaCapturedTaunt = true
          Media.PlaySound('Elena-11M-04.aud')
          Media.DisplayMessage("What's mine is mine, and what's yours is mine.", "Elena Cherkovna", HSLColor.FromHex("FF0000"))
        end
      end
    end)
  end)
  
  Utils.Do({GDIDef1, GDIDef2, GDIDef3, GDIDef4, GDIDef5}, function(building)
    Trigger.OnKilled(building, function(self, killer)
      if SawElenaWinningTaunt1 == false then
        SawElenaWinningTaunt1 = true
        Media.PlaySound('Elena-11M-05.aud')
        Media.DisplayMessage("Struggling, comrade? You can always hand over Dr. Moebius.", "Elena Cherkovna", HSLColor.FromHex("FF0000"))
      end
    end)
  end)
  
  Utils.Do({GDINuk2a, GDINuk2b, GDIPyle, GDIWeap, GDIProc, GDIHq, GDIFix}, function(building)
    Trigger.OnKilled(building, function(self, killer)
      if SawElenaWinningTaunt2 == false then
        if not IsOwnedByCoopPlayer(killer) then
          SawElenaWinningTaunt2 = true
          Media.PlaySound('Elena-11M-06.aud')
          Media.DisplayMessage("Well, is that all, GDI? I expected you to put up better fight.", "Elena Cherkovna", HSLColor.FromHex("FF0000"))
        end
      end
    end)
  end)
  
  --Testing
end


Tick = function()
	Utils.Do(CoopPlayers,function(PID)
		if PID ~= GDI and #PID.GetActorsByType("fact") == 0 then
			Utils.Do(PID.GetActorsByType("harv"),function(UID)
				UID.Owner = GDI
			end)
		end
	end)
	OncePerSecondChecks()
	OncePerThreeSecondChecks()
end

OncePerSecondChecks = function()
  if DateTime.GameTime > 1 and DateTime.GameTime % 25 == 0 then
    --none
  end
end

OncePerThreeSecondChecks = function()
	if DateTime.GameTime > 1 and DateTime.GameTime % 75 == 0 then
    if FirstPlayerBaseDead == false then
      local playerUnits = Map.ActorsInBox(FirstThrustNW.CenterPosition, FirstThrustSE.CenterPosition, function(a)
        return IsOwnedByCoopPlayer(a) and a.Type ~= 'brik' and a.Type ~= 'camera'
      end)
      
      if #playerUnits == 0 then
        FirstPlayerBaseDead = true
        Media.PlaySound('Elena-11M-02.aud')
        Media.DisplayMessage("One base down. One to go.", "Elena Cherkovna", HSLColor.FromHex("FF0000"))
        
        if Difficulty ~= 'easy' then
          Trigger.AfterDelay(DateTime.Seconds(8), function()
            if not NodMCV.IsDead then
              NodMCV.Move(StartCam.Location)
              NodMCV.CallFunc(function()
                NodMCV.Destroy()
                Actor.Create('fact', true, { Owner = Nod2, Location = BuildFact.Location })
                Trigger.AfterDelay(DateTime.Seconds(2), function()
                  ForwardFactExists = true
                  BuildElenaBase()
                  local facts = Nod2.GetActorsByType('fact')
                  ForwardFact = facts[1]
                  SellBuildingIfEngyNearWithTaunt(ForwardFact, GDI)
                  Trigger.OnKilled(ForwardFact, function(self, killer) ForwardFactExists = false end)
                end)
              end)
            end
          end)
        end
        
        if Difficulty ~= 'easy' then
          if Difficulty == 'normal' then
            Utils.Do( { ForwardDefA1, ForwardDefA2, ForwardDefA3 }, function(unit)
              if not unit.IsDead then unit.Move(FirstThrustDef.Location, 1024 * 3) end
            end)
          end
          Utils.Do( { ForwardDefB1, ForwardDefB2, ForwardDefB3 }, function(unit)
            if not unit.IsDead then unit.Move(FirstThrustDefB.Location, 1024 * 3) end
          end)
          Utils.Do( { ForwardDefB1, ForwardDefB2, ForwardDefB3 }, function(unit)
            if not unit.IsDead then unit.Move(FirstThrustDefC.Location, 1024 * 3) end
          end)
        end
      end
    end
    
    if SamsDestroyed == false then
      local samsLeft = SubNod.GetActorsByType('sam')
      UserInterface.SetMissionText("SAM sites remaining: " .. #samsLeft, HSLColor.Yellow)
      
      if #samsLeft == 0 then
        UserInterface.SetMissionText('', HSLColor.Yellow)
        SamsDestroyed = true
        GDI.MarkCompletedObjective(DestroySamsObjective)
        Trigger.AfterDelay(DateTime.Seconds(3), function()
          Media.DisplayMessage("Evac chopper inbound! Get Moebius to the chopper!")
          Media.PlaySpeechNotification(All, "Reinforce")
          local evacChopper = Actor.Create('tran', true, { Owner = FakeGDI, Location = EvacTranSpawn.Location })
          evacChopper.Move(EvacTranLand.Location)
          Actor.Create('flare', true, { Owner = GoodGuy, Location = FlareSpawn.Location })
          
          Trigger.OnKilled(evacChopper, function(self, killer)
            Media.DisplayMessage("The evac chopper was destroyed! Moebius can't be evacuated!", "NOTICE", HSLColor.FromHex("FF0000"))
            GDI.MarkFailedObjective(EvacMoebiusObjective)
          end)
          
          Trigger.OnEnteredProximityTrigger(EvacTranLand.CenterPosition, WDist.New(3 * 1024), function(a, id)
            if IsOwnedByCoopPlayer(a) and a.Type == 'moebius' then
              Trigger.RemoveProximityTrigger(id)
              GDI.MarkCompletedObjective(EvacMoebiusObjective)
              Media.PlaySound("Eva-TargetRescued.aud")
            end
          end)
        end)
      end
    end
    
    if SawElenaLossTaunt == false then
      if HasOneOf(Nod, LossCheckCritical) == false then
        SawElenaLossTaunt = true
        Media.PlaySound('Elena-11M-07.aud')
        Media.DisplayMessage("Incredible. Well played, comrade.\nSo well played I almost wonder if you are cheating.", "Elena Cherkovna", HSLColor.FromHex("FF0000"))
      end
    end
    
    --manipulate AI funds
    ManipulatePlayerFunds(Nod)
    SubNod.Cash = 50000
    
    ControlAircraft(SubNod)
	end
end


PlayerFailMission = function()
  if DestroySamsObjective ~= nil and not GDI.IsObjectiveCompleted(DestroySamsObjective) then
    GDI.MarkFailedObjective(DestroySamsObjective)
  end
  if EvacMoebiusObjective ~= nil and not GDI.IsObjectiveCompleted(EvacMoebiusObjective) then
    GDI.MarkFailedObjective(EvacMoebiusObjective)
  end
end