
GDIAwakened = false


ActorRemovals =
{
  easy = { EZR1,
           Patrol1A, Patrol1B, Patrol1C, Patrol1D, Patrol1E, Patrol2A, Patrol2B, Patrol2C, Patrol2D, Patrol2E,
           Patrol6A, Patrol6B, Patrol6C, Patrol6D, Patrol6E, Patrol7A, Patrol7B, Patrol7C, Patrol7D, Patrol7E,
         },
  normal = {  },
  hard = {  },
}


Sunrise = function()
	local active = false

	if Lighting.Ambient < 0.95 then
		Lighting.Ambient = Lighting.Ambient + 0.0002
		active = true
	end

	if Lighting.Red < 1.0 then
		Lighting.Red = Lighting.Red + 0.0005
		active = true
	end

	if Lighting.Green < 0.85 then
		Lighting.Green = Lighting.Green + 0.0002
		active = true
	end
  
  if Lighting.Blue > 0.5 then
		Lighting.Blue = Lighting.Blue - 0.0002
		active = true
	end

	if active then
		Trigger.AfterDelay(5, function()
			Sunrise()
		end)
	end
end


-- GDI's AI attack production behavior -----

AwakenGDI = function()
  if GDIAwakened == true then return end
  GDIAwakened = true

  local attackers = Map.ActorsInBox(MainBaseNW.CenterPosition, MainBaseSE.CenterPosition, function(a)
    return a.Owner == GDI and (a.Type == "e1")
  end)
  
  Utils.Do(attackers, function(unit) unit.AttackMove(ProxRvlOrca.Location) end)
  
  if Difficulty ~= 'easy' then
    GDIVehicleAttackProduction()
    GDIInfantryAttackProduction()
  end
end


GDIVehicleAttackProduction = function()
  local toBuild = function() return { 'jeep', 'jeep', 'jeep', 'jeep' } end
  local factory = GetAvailableFactory(GDI, 'weap')
  
  if factory ~= nil then
    ProduceUnits(GDI, factory, nil, toBuild, function(units)
      Utils.Do(units, function(unit) unit.Hunt() end)
    end)
  end

  Trigger.AfterDelay(DateTime.Seconds(180), GDIVehicleAttackProduction)
end


GDIInfantryAttackProduction = function()
  local toBuild = function() return { 'e2', 'e2', 'e2', 'e2', 'e2', 'e2', 'e2', 'e2', 'e2', 'e2' } end
  local factory = GetAvailableFactory(GDI, 'pyle')
  
  if factory ~= nil then
    ProduceUnits(GDI, factory, nil, toBuild, function(units)
      Utils.Do(units, function(unit) unit.Hunt() end)
    end)
  end

  Trigger.AfterDelay(DateTime.Seconds(180), GDIInfantryAttackProduction)
end

-- End GDI's AI attack production behavior -----


WorldLoaded = function()
  GDI = Player.GetPlayer("GDI")
  FakeGDI = Player.GetPlayer("FakeGDI")
  SubGDI = Player.GetPlayer("SubGDI")
  Nod = Player.GetPlayer("Nod")
  Neutral = Player.GetPlayer("Neutral")
  
  MissionPlayer = Nod

	BadGuy = Player.GetPlayer("BadGuy")

	coopInfo =
	{
		Mainplayer = Nod,
		MainEnemies = {GDI, SubGDI},
		Dummyplayer = BadGuy
	}
	
	ORAMod = "tibalt"
	CoopInit25(coopInfo)

  Camera.Position = StartCam.CenterPosition
  
  --Remove actors based on difficulty
  Utils.Do(ActorRemovals[Difficulty], function(unit)
    unit.Destroy()
  end)
  
  if #CoopPlayers >= 4 then
	local ExtraAPC = Actor.Create("apc", true, { Owner = Nod, Location = Actor801.Location })
	ExtraAPC.Scatter()
  end
  if #CoopPlayers >= 5 then
	local ExtraAPC = Actor.Create("apc", true, { Owner = Nod, Location = Actor802.Location })
	ExtraAPC.Scatter()
  end
  if #CoopPlayers >= 6 then
	local ExtraAPC = Actor.Create("apc", true, { Owner = Nod, Location = Actor803.Location })
	ExtraAPC.Scatter()
	local ExtraEngi = Actor.Create("e6", true, { Owner = Nod, Location = Actor804.Location })
	ExtraEngi.Scatter()
  end
  Trigger.AfterDelay(1, function()
	AssignToCoopPlayers(Nod.GetActorsByType("e6"), nil, true)
	AssignToCoopPlayers(Nod.GetActorsByType("apc"), nil, true)
  end)
  
  --Special lighting
  Lighting.Ambient = 0.82
  Lighting.Red = 0.8
  Lighting.Blue = 1.0
  Lighting.Green = 0.85
  
  --Player Reinforcements
  Trigger.OnCapture(CtrlStat, function(self, captor, oldOwner, newOwner)
    if IsOwnedByCoopPlayer(captor) then
      local hijackUnits = FakeGDI.GetActorsByTypes({'mtnk', 'jeep'})
      if #hijackUnits == 0 then
        Media.DisplayMessage("Maybe we shouldn't have destroyed all those vehicles.\nThey might have been useful...", "Nod Soldier", HSLColor.FromHex("FF0000"))
        return
      end
    
      Media.DisplayMessage("Maybe using these GDI vehicles can get us past their security.", "Nod Soldier", HSLColor.FromHex("FF0000"))
      Utils.Do(hijackUnits, function(unit)
        unit.Move(HijackMove1.Location,2)
        unit.Move(HijackMove2.Location,2)
        unit.Move(HijackMove3.Location,2)
        unit.Move(HijackMove4.Location,2)
        unit.CallFunc(function() unit.Owner = BadGuy end)
      end)
    end
  end)
  
  --Objectives
  InitObjectives(Nod)

  Trigger.AfterDelay(DateTime.Seconds(2), function()
    DestroyMissObjective = Nod.AddObjective("Destroy the conference center with a GDI unit.")
  end)
  
  Trigger.OnKilled(Miss, function(self, killer)
    if killer.Type == 'e5' or killer.Type == 'e3' then
      Media.DisplayMessage("Commander, the point was to make the world believe GDI destroyed the conference.", "Cabal", HSLColor.FromHex("FF0000"))
      Trigger.AfterDelay(DateTime.Seconds(5), function()
        Media.DisplayMessage("There was no purpose to this if everyone knows it was Nod.", "Cabal", HSLColor.FromHex("FF0000"))
      end)
      Trigger.AfterDelay(DateTime.Seconds(10), function()
        PlayerFailMission()
      end)
    else
      Nod.MarkCompletedObjective(DestroyMissObjective)
    end
  end)
  
  --AI player behavior
  GDI.Resources = GDI.ResourceCapacity - 500
  GDI.Cash = 90000
  
  SetupRefAndSilosCaptureCredits(GDI)
  
  local mainBaseDefenses = { RPG1, RPG2, RPG3, RPG4, RPG5, RPG6, RPG7, RPG8 }
  Utils.Do(mainBaseDefenses, function(def)
    Trigger.OnKilled(def, function(self, killer) AwakenGDI() end)
  end)
  
  Trigger.OnEnteredProximityTrigger(TrigCounter.CenterPosition, WDist.New(4 * 1024), function(a, id)
    if IsOwnedByCoopPlayer(a) and a.Type ~= 'camera' and a.Type ~= 'camera.small' then
      Trigger.RemoveProximityTrigger(id)
      AwakenGDI()
    end
  end)
  
  --Enemy Predeployed Maneuvers
  if Difficulty ~= 'easy' then
    Utils.Do({ Patrol1A, Patrol1B, Patrol1C, Patrol1D, Patrol1E, Patrol2A, Patrol2B, Patrol2C, Patrol2D, Patrol2E }, function(unit)
      unit.Patrol({PatrolRoute1A.Location, PatrolRoute1B.Location, PatrolRoute1C.Location, PatrolRoute1D.Location}, true, DateTime.Seconds(5))
    end)
    
    Utils.Do({ Patrol6A, Patrol6B, Patrol6C, Patrol6D, Patrol6E, Patrol7A, Patrol7B, Patrol7C, Patrol7D, Patrol7E }, function(unit)
      unit.Patrol({PatrolRoute2A.Location, PatrolRoute2B.Location, PatrolRoute2C.Location, PatrolRoute2D.Location}, true, DateTime.Seconds(5))
    end)
  end

  --Proximity Triggers/Reveals
  local defaultReveals = { ProxRvl, ProxRvl2, ProxRvl3, ProxRvl4, ProxRvl5, ProxRvl6, ProxRvl7, ProxRvl12, ProxRvl13, ProxRvl15, ProxRvl16 }
  Utils.Do(defaultReveals, function(reveal)
    Trigger.OnEnteredProximityTrigger(reveal.CenterPosition, WDist.New(12 * 1024), function(a, id)
      if IsOwnedByCoopPlayer(a) and a.Type ~= 'camera' and a.Type ~= 'camera.small' then
        Trigger.RemoveProximityTrigger(id)
        local camActor = Actor.Create("camera", true, { Owner = Nod, Location = reveal.Location })
        Trigger.AfterDelay(DateTime.Seconds(10), function() camActor.Destroy() end)
      end
    end)
  end)

  local baseReveals = { ProxRvl8, ProxRvl9, ProxRvl10, ProxRvl11 }
  Utils.Do(baseReveals, function(reveal)
    Trigger.OnEnteredProximityTrigger(reveal.CenterPosition, WDist.New(12 * 1024), function(a, id)
      if IsOwnedByCoopPlayer(a) and a.Type ~= 'camera' and a.Type ~= 'camera.small' then
        Trigger.RemoveProximityTrigger(id)
        local camActor1 = Actor.Create("camera", true, { Owner = Nod, Location = reveal.Location })
        Trigger.AfterDelay(DateTime.Seconds(10), function() camActor1.Destroy() end)
        
        local orcaCam = Actor.Create("camera.small", true, { Owner = Nod, Location = ProxRvlOrca.Location })
        Trigger.AfterDelay(DateTime.Seconds(10), function() orcaCam.Destroy() end)
      end
    end)
  end)
  
  Trigger.OnEnteredProximityTrigger(ProxRvl14.CenterPosition, WDist.New(12 * 1024), function(a, id)
    if (IsOwnedByCoopPlayer(a) or a.Owner == FakeGDI) and a.Type ~= 'camera' and a.Type ~= 'camera.small' then
      Trigger.RemoveProximityTrigger(id)
      local camActor1 = Actor.Create("camera", true, { Owner = Nod, Location = ProxRvl14.Location })
      Trigger.AfterDelay(DateTime.Seconds(5), function() camActor1.Destroy() end)
      
      local camActor2 = Actor.Create("camera", true, { Owner = Nod, Location = ProxRvl14B.Location })
      Trigger.AfterDelay(DateTime.Seconds(5), function() camActor2.Destroy() end)
      
      Sunrise()
    end
  end)
  
  --Timer
  if Difficulty == 'hard' then
    Trigger.AfterDelay(DateTime.Seconds(10), function()
      Media.DisplayMessage("Destroy the conference center before the conference is concluded.", "Cabal", HSLColor.FromHex("FF0000"))
      
      TimerDuration = 540
      DateTime.TimeLimit = DateTime.Seconds(TimerDuration)
      Media.PlaySound("Eva-MissionTimer.aud")
      
      Trigger.OnTimerExpired(function()
        Media.DisplayMessage("You were too slow. The attendees have left the conference.", "Cabal", HSLColor.FromHex("FF0000"))
        Trigger.AfterDelay(DateTime.Seconds(3), function() PlayerFailMission() end)
      end)
    end)
  end

  --Crate spawns
  
  --Testing
end


Tick = function()
	OncePerSecondChecks()
	OncePerThreeSecondChecks()
end

OncePerSecondChecks = function()
  if DateTime.GameTime > 1 and DateTime.GameTime % 25 == 0 then
    --none
  end
end

OncePerThreeSecondChecks = function()
	if DateTime.GameTime > 1 and DateTime.GameTime % 75 == 0 then
    
	local ObjCounter = 0
    Utils.Do(CoopPlayers,function(PID)
		if HasOneOf(PID, LossCheckAll) == false and HasOneOf(FakeGDI, {'mtnk', 'jeep'}) == false then
			ObjCounter = ObjCounter + 1
		end
	end)
	if ObjCounter >= #CoopPlayers then
      PlayerFailMission()
    end
	
	--[[if HasOneOf(Nod, LossCheckAll) == false and HasOneOf(FakeGDI, {'mtnk', 'jeep'}) == false then
      PlayerFailMission()
    end]]
	end
end


PlayerFailMission = function()
  if DestroyMissObjective ~= nil and not Nod.IsObjectiveCompleted(DestroyMissObjective) then
    Nod.MarkFailedObjective(DestroyMissObjective)
  end
end