
MutantsFreed = false
MutantsFreeable = true
AirstrikeGranted = false
CommsDestroyed = 0
CommsToDestroy = 3
NodAwakened = false
NodCountered = false

PrisonGuards = { Sentry7, Sentry8, Sentry9, Sentry10, Sentry11, Sentry12, Sentry13, Sentry14, Sentry15 }

ActorRemovals =
{
  easy = { EZR1, EZR2, EZR3, EZR4, EZR5, EZR6, EZR7, EZR8, EZR9, EZR10, EZR11, EZR12, EZR13,
           Counter10, Counter11, Counter12, Counter13, Counter14, Counter15, Counter16, Counter17,
           Counter18, Counter19, Counter20, Counter21, Counter22, Counter23, Counter24, Counter25, Counter26},
  normal = {  },
  hard = {  },
}


Sunrise = function()
	local active = false

	if Lighting.Ambient < 0.95 then
		Lighting.Ambient = Lighting.Ambient + 0.0002
		active = true
	end

	if Lighting.Red < 1.0 then
		Lighting.Red = Lighting.Red + 0.0005
		active = true
	end

	if Lighting.Green < 0.85 then
		Lighting.Green = Lighting.Green + 0.0002
		active = true
	end
  
  if Lighting.Blue > 0.5 then
		Lighting.Blue = Lighting.Blue - 0.0002
		active = true
	end

	if active then
		Trigger.AfterDelay(5, function()
			Sunrise()
		end)
	end
end


CommDestroyed = function()
  CommsDestroyed = CommsDestroyed + 1
  local remainingComms = CommsToDestroy - CommsDestroyed
  Media.DisplayMessage("Early warning station destroyed! " .. remainingComms .. " remaining.", "NOTICE", HSLColor.Green)
  
  if Difficulty ~= 'easy' then
    if CommsDestroyed == 1 then
      Utils.Do({Counter17, Counter18, Counter19, Counter20, Counter21}, function(unit) AssaultPlayerBaseOrHunt(unit) end)
    elseif CommsDestroyed == 2 then
      Utils.Do({Counter22, Counter23, Counter24, Counter25, Counter26}, function(unit) AssaultPlayerBaseOrHunt(unit) end)
    end
  end

  CheckDestroyedComms()
end


CheckDestroyedComms = function()
	if CommsDestroyed == CommsToDestroy then
    MainGDILandingForce()
	else
		UserInterface.SetMissionText(CommsDestroyed .. " of 3 early warning stations destroyed.", HSLColor.Yellow)
	end
end


MainGDILandingForce = function()
  Sunrise()
  RmbosDone = true
  DefeatNodObjective = GDI.AddObjective("Destroy the main Nod base.")

  Trigger.AfterDelay(DateTime.Seconds(2), function()
    GDI.MarkCompletedObjective(DestroyCommsObjective)
    Media.DisplayMessage("Reinforcements arriving from the southwest.", "EVA", HSLColor.FromHex("00FF00"))
    Media.PlaySound("Eva-ReinforcementsWest.aud")
  end)
  UserInterface.SetMissionText("", HSLColor.Lime)
  
  Trigger.AfterDelay(DateTime.Seconds(5), function()
    Media.PlaySpeechNotification(All, "Reinforce")
    
    if Difficulty ~= 'hard' then
      Actor.Create("boat", true, { Owner = GoodGuy, Location = BoatSpawn.Location })
    end

    ReinforceWithLandingCraft(GoodGuy, {'e2', 'e2', 'e2', 'e2'}, GDISpawn1.Location, GDIMoveTo1.Location, false)
    ReinforceWithLandingCraft(GoodGuy, {'e2', 'e2', 'e2', 'e2'}, GDISpawn2.Location, GDIMoveTo2.Location, false)
  end)
  
  Trigger.AfterDelay(DateTime.Seconds(10), function()
    Media.PlaySpeechNotification(All, "Reinforce")
    ReinforceWithLandingCraft(GoodGuy, {'jeep'}, GDISpawn3.Location, GDIMoveTo3.Location, false)
    ReinforceWithLandingCraft(GoodGuy, {'jeep'}, GDISpawn4.Location, GDIMoveTo4.Location, false)
  end)
  
  Trigger.AfterDelay(DateTime.Seconds(15), function()
    Media.PlaySpeechNotification(All, "Reinforce")
    ReinforceWithLandingCraft(GoodGuy, {'mtnk'}, GDISpawn5.Location, GDIMoveTo5.Location, false)
  end)
  
  Trigger.AfterDelay(DateTime.Seconds(20), function()
    Media.PlaySpeechNotification(All, "Reinforce")
	local AllMCVs = {}
	Utils.Do(MCVPlayers,function(PID)
		table.insert(AllMCVs,"mcv")
	end)
    ReinforceWithLandingCraft(GoodGuy, AllMCVs, GDISpawn5.Location, GDIMoveTo5.Location, false)
  end)
  
  Trigger.AfterDelay(DateTime.Seconds(160), function() AwakenNod() end)
end


NodCounter = function()
  if NodCountered == true then return end
  NodCountered = true
  AwakenNod()
  
  Utils.Do({Counter27, Counter28}, function(unit) AssaultPlayerBaseOrHunt(unit) end)
  if Difficulty ~= 'easy' then
    Utils.Do({EZR5, EZR6, EZR7}, function(unit) AssaultPlayerBaseOrHunt(unit) end)
  end
end


AwakenNod = function()
  if NodAwakened == true then return end
  NodAwakened = true
  NodVehicleAttackProduction()
  NodInfantryAttackProduction()
  local newBuilding = Actor.Create('proc', true, { Owner = Nod, Location = NodProc.Location })
  AutoRebuildBuilding(newBuilding, Nod)
  AutoReplaceHarvesters(Nod)
  
  Media.DisplayMessage("You've come to the wrong neighborhood, GDI.\nI'll make you wish you'd never been born.", "Slavik", HSLColor.FromHex("FF0000"))
  
  --evil cloaked engy rush
  if Difficulty ~= 'easy' then
    Trigger.AfterDelay(DateTime.Seconds(360), function()
      local prereqs = Nod.GetActorsByTypes({'hand', 'afld'})
      if #prereqs >= 2 then
        EngyRushTargetPlayer = MissionPlayer
        Reinforcements.ReinforceWithTransport(Nod, "apc", {"e6", "e6", "e6", "e6", "e6"}, { EngyRushSpawn.Location }, null, ExecEngyRush)
      end
    end)
  end
end


-- Nod's AI attack production behavior -----

NodAttackDelayMin = { easy = DateTime.Seconds(45), normal = DateTime.Seconds(30), hard = DateTime.Seconds(25) }
NodAttackDelayMax = { easy = DateTime.Seconds(60), normal = DateTime.Seconds(45), hard = DateTime.Seconds(30) }

NodAttackPaths = {
  { NodStage1.Location },
  { NodStage2.Location },
}

NodAttackInfantryTypes = {
  easy = {
    { types = { "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1" } },
    { types = { "e1", "e1", "e1", "e1", "e3", "e3", "e3" } },
    { types = { "e3", "e3", "e3", "e3", "e3", "e3" } },
    { types = { "e4", "e4", "e4", "e4", "e4", "e4" } },
  },
  normal = {
    { types = { "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1" } },
    { types = { "e1", "e1", "e1", "e1", "e3", "e3", "e3", "e3" } },
    { types = { "e3", "e3", "e3", "e3", "e3", "e3", "e3" } },
    { types = { "spy", "spy", "spy", "spy", "spy", "spy", "spy" } },
    { types = { "e4", "e4", "e4", "e4", "e4", "e4", "e4" } },
  },
  hard = {
    { types = { "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1" } },
    { types = { "e1", "e1", "e1", "e1", "e1", "e3", "e3", "e3", "e3", "e3" } },
    { types = { "e3", "e3", "e3", "e3", "e3", "e3", "e3" } },
    { types = { "spy", "spy", "spy", "spy", "spy", "spy", "spy" } },
    { types = { "e4", "e4", "e4", "e4", "e4", "e4", "e4" } },
  }
}

NodAttackVehicleTypes = {
  easy = {
    { types = { "bggy", "bggy", "bggy", "bike" } },
    { types = { "ltnk", "ltnk", "ltnk" } },
    { types = { "ltnk", "ltnk", "arty" } },
  },
  normal = {
    { types = { "bggy", "bggy", "bggy", "bggy", "bike", "bike" } },
    { types = { "ltnk", "ltnk", "ltnk", "ltnk" } },
    { types = { "ltnk", "ltnk", "ltnk", "arty", "arty" } },
  },
  hard = {
    { types = { "bggy", "bggy", "bggy", "bggy", "bike", "bike" } },
    { types = { "ltnk", "ltnk", "ltnk", "ltnk", "ltnk" } },
    { types = { "ltnk", "ltnk", "ltnk", "arty", "arty", "arty" } },
  }
}

NodVehicleAttackProduction = function()
  local production = Utils.Random(NodAttackVehicleTypes[Difficulty])
  local path = Utils.Random(NodAttackPaths)
  local toBuild = function() return production.types end
  local factory = GetAvailableFactory(Nod, 'afld')
  
  if factory ~= nil then
    ProduceUnits(Nod, factory, nil, toBuild, function(units)
      UpdatePlayerBaseLocation()
      Utils.Do(units, function(unit)
        ErrorGuardAttackPatrol(unit, path)
        AssaultPlayerBaseOrHunt(unit)
      end)
      Trigger.AfterDelay(Utils.RandomInteger(NodAttackDelayMin[Difficulty], NodAttackDelayMax[Difficulty]), NodVehicleAttackProduction)
    end)
  else
    Trigger.AfterDelay(Utils.RandomInteger(NodAttackDelayMin[Difficulty], NodAttackDelayMax[Difficulty]), NodVehicleAttackProduction)
  end
end

NodInfantryAttackProduction = function()  
  local production = Utils.Random(NodAttackInfantryTypes[Difficulty])
  local path = Utils.Random(NodAttackPaths)
  local toBuild = function() return production.types end
  local factory = GetAvailableFactory(Nod, 'hand')

  if factory ~= nil then
    ProduceUnits(Nod, factory, nil, toBuild, function(units)
      UpdatePlayerBaseLocation()
      Utils.Do(units, function(unit)
        ErrorGuardAttackPatrol(unit, path)
        AssaultPlayerBaseOrHunt(unit)
      end)
      Trigger.AfterDelay(Utils.RandomInteger(NodAttackDelayMin[Difficulty], NodAttackDelayMax[Difficulty]), NodInfantryAttackProduction)
    end)
  else
    Trigger.AfterDelay(Utils.RandomInteger(NodAttackDelayMin[Difficulty], NodAttackDelayMax[Difficulty]), NodVehicleAttackProduction)
  end
end

-- End Nod's AI attack production behavior -----

WorldLoaded = function()
  GDI = Player.GetPlayer("GDI")
  Nod = Player.GetPlayer("Nod")
  SubNod = Player.GetPlayer("SubNod")
  Neutral = Player.GetPlayer("Neutral")
  
  MissionPlayer = GDI

	GoodGuy = Player.GetPlayer("GoodGuy")

	coopInfo =
	{
		Mainplayer = GDI,
		MainEnemies = {Nod,SubNod},
		Dummyplayer = GoodGuy
	}
	
	ORAMod = "tibalt"
	CoopInit25(coopInfo)

  Camera.Position = RmboUnload.CenterPosition
  
  --Remove actors based on difficulty
  Utils.Do(ActorRemovals[Difficulty], function(unit)
    unit.Destroy()
  end)
  
  --Special lighting
  Lighting.Ambient = 0.75
  Lighting.Red = 0.6
  Lighting.Blue = 1.0
  Lighting.Green = 0.6
  
  --Player Reinforcements
  Media.PlaySpeechNotification(All, "Reinforce")
  local AllRmbos = {}
  Utils.Do(CoopPlayers,function(PID)
	table.insert(AllRmbos,"rmbo")
  end)
  if Difficulty ~= 'hard' then
	table.insert(AllRmbos,"medi")
  end
  RmbosDone = false
  
  ReinforceWithLandingCraft(GoodGuy, AllRmbos, RmboSpawn.Location, RmboUnload.Location, false)
  
--[[  if Difficulty == 'hard' then
    ReinforceWithLandingCraft(GoodGuy, AllRmbos, RmboSpawn.Location, RmboUnload.Location, false)
  else
    ReinforceWithLandingCraft(GoodGuy, {'rmbo', 'medi'}, RmboSpawn.Location, RmboUnload.Location, false)
  end]]

  Trigger.OnAllKilled({Sam1, Sam2}, function()
		SendHeli(GoodGuy)
	end)

  Trigger.OnAllKilled(PrisonGuards, function()
    if MutantsFreeable == false then return end
    MutantsFreed = true
    GDI.MarkCompletedObjective(FreeMutantsObjective)
	
    local mutants = { 'mutsldr', 'mutsldr', 'mutsldr', 'mutsldr', 'mutsldr', 'mutsldr', 'mutsldr', 'mutsldr' }
    if Difficulty == 'normal' then
      mutants = { 'mutsldr', 'mutsldr', 'mutsldr', 'mutsldr', 'mutsldr', 'mutsldr' }
    elseif Difficulty == 'hard' then
      mutants = { 'mutsldr', 'mutsldr', 'mutsldr', 'mutsldr', 'mutsldr' }
    end
    
    Reinforcements.Reinforce(GoodGuy, mutants, { MutSpawn.Location }, 10, function(unit)
      unit.Move(MutMoveTo.Location)
    end)
    
    Media.DisplayMessage("Thanks for the help, blunt! Let's drive these Nod cultists out of our home.", "Mutants", HSLColor.FromHex("00FF00"))
    
    if Difficulty ~= 'easy' then
      Trigger.AfterDelay(DateTime.Seconds(5), function()
        local mutantTargets = {}
		Utils.Do(CoopPlayers,function(PID)
			table.insert(mutantTargets,PID.GetActorsByTypes({'mutsldr'}))
		end)
        Utils.Do({Counter12, Counter13, Counter14, Counter15, Counter16}, function(unit)
          if not unit.IsDead then unit.Attack(Utils.Random(mutantTargets)) end
        end)
      end)
    end
  end)

  --Objectives
  InitObjectives(GDI)
  
  Trigger.OnKilled(Comm1, function(self, killer) CommDestroyed() end)
  Trigger.OnKilled(Comm2, function(self, killer) CommDestroyed() end)
  Trigger.OnKilled(Comm3, function(self, killer) CommDestroyed() end)
  
  Trigger.OnKilled(Miss, function(self, killer)
    if MutantsFreed == false then
      MutantsFreeable = false
      Media.DisplayMessage("Prison destroyed! The friendly mutants have been killed!", "FAILURE", HSLColor.FromHex("FF0000"))
      GDI.MarkFailedObjective(FreeMutantsObjective)
    end
  end)
  
  local civilians = GetAllCivilians(Neutral)
  Utils.Do(civilians, function(civ)
    if civ.Type ~= 'rmv01' then  --church has special easter egg
      Trigger.OnKilled(civ, function(self, killer)
        if IsOwnedByCoopPlayer(killer) and (killer.Type == 'rmbo' or killer.Type == 'mutsldr') then
          Media.DisplayMessage("Commander, what the hell are you doing?! Don't slaughter civilians!", "Carter", HSLColor.FromHex("857833"))
          Trigger.AfterDelay(DateTime.Seconds(3), function() PlayerFailMission() end)
        end
      end)
    end
  end)

  Utils.Do(PrisonGuards, function(unit)
    Trigger.OnKilled(unit, function(self, killer)
      Utils.Do(PrisonGuards, function(grd)
        if not grd.IsDead then AssaultPlayerBaseOrHunt(grd) end
      end)
    end)
  end)
  
  --AI player behavior
  Nod.Resources = Nod.ResourceCapacity - 500
  Nod.Cash = 90000
  
  if Difficulty ~= "easy" then
    AutoRepairAndRebuildBuildings(Nod, 15)
  end
  
  SetupRefAndSilosCaptureCredits(Nod)
  
  --Enemy Predeployed Maneuvers
  Trigger.AfterDelay(DateTime.Seconds(4), function()
    Utils.Do({Counter1, Counter2, Counter3}, function(unit) unit.AttackMove(RmboUnload.Location) end)
  end)
  
  Trigger.OnEnteredProximityTrigger(CounterA.CenterPosition, WDist.New(2 * 1024), function(a, id)
    if IsOwnedByCoopPlayer(a) then
      Trigger.RemoveProximityTrigger(id)
      Utils.Do({Counter4, Counter5, Counter6, Counter7, Counter8, Counter9}, function(unit)
        unit.AttackMove(RmboUnload.Location)
      end)
    end
  end)

  Utils.Do({PatrolBggy1}, function(unit)
     unit.Patrol({PatrolRouteA.Location, PatrolRouteB.Location, PatrolRouteC.Location, PatrolRouteD.Location}, true, DateTime.Seconds(5))
  end)

  Utils.Do({PatrolBggy2}, function(unit)
     unit.Patrol({PatrolRouteE.Location, PatrolRouteF.Location}, true, DateTime.Seconds(10))
  end)
  
  Utils.Do({PatrolBggy3}, function(unit)
     unit.Patrol({PatrolRouteG.Location, PatrolRouteH.Location, PatrolRouteI.Location, PatrolRouteJ.Location}, true, DateTime.Seconds(5))
  end)
  
  Utils.Do({PatrolE1_1, PatrolE1_2, PatrolE1_3, PatrolE1_4, PatrolE1_5}, function(unit)
     unit.Patrol({PatrolRouteG.Location, PatrolRouteH.Location, PatrolRouteK.Location, PatrolRouteH.Location, PatrolRouteG.Location, PatrolRouteL.Location}, true, DateTime.Seconds(5))
  end)
  
  Utils.Do({PatrolE1_6, PatrolE1_7, PatrolE1_8, PatrolE1_9, PatrolE1_10}, function(unit)
     unit.Patrol({PatrolRouteH.Location, PatrolRouteG.Location, PatrolRouteL.Location, PatrolRouteG.Location, PatrolRouteH.Location, PatrolRouteK.Location}, true, DateTime.Seconds(5))
  end)
  
  Utils.Do({Sentry1, Sentry2, Sentry3}, function(unit)
     unit.Patrol({SentryRouteA.Location, SentryRouteB.Location}, true, DateTime.Seconds(3))
  end)
  
  Utils.Do({Sentry4, Sentry5, Sentry6}, function(unit)
     unit.Patrol({SentryRouteC.Location, SentryRouteD.Location}, true, DateTime.Seconds(3))
  end)
  
  if Difficulty ~= 'easy' then
    Trigger.OnKilled(PatrolBggy1, function(self, killer)
      Utils.Do({Counter10, Counter11}, function(unit)
        if not unit.IsDead then AssaultPlayerBaseOrHunt(unit) end
      end)
    end)
    Trigger.OnKilled(PatrolBggy2, function(self, killer)
      Utils.Do({Counter10, Counter11}, function(unit)
        if not unit.IsDead then AssaultPlayerBaseOrHunt(unit) end
      end)
    end)
    Trigger.OnKilled(PatrolBggy3, function(self, killer)
      Utils.Do({Counter10, Counter11}, function(unit)
        if not unit.IsDead then AssaultPlayerBaseOrHunt(unit) end
      end)
    end)
  end

  --Proximity Triggers/Reveals
  local awakenNodPoints = { NodEntry1W, NodEntry2W, NodEntry3W }
  Utils.Do(awakenNodPoints, function(wp)
    Trigger.OnEnteredProximityTrigger(wp.CenterPosition, WDist.New(3 * 1024), function(a, id)
      if IsOwnedByCoopPlayer(a) and a.Type ~= 'camera' and a.Type ~= 'tran' then
        Trigger.RemoveProximityTrigger(id)
        NodCounter()
      end
    end)
  end)
  
  local revealNodPoints = { NodEntry1, NodEntry2, NodEntry3 }
  Utils.Do(revealNodPoints, function(wp)
    Trigger.OnEnteredProximityTrigger(wp.CenterPosition, WDist.New(6 * 1024), function(a, id)
      if IsOwnedByCoopPlayer(a) and a.Type ~= 'camera' then
        Trigger.RemoveProximityTrigger(id)
        local revealCam = Actor.Create("camera", true, { Owner = GDI, Location = wp.Location })
        Trigger.AfterDelay(DateTime.Seconds(10), function()
          revealCam.Destroy()
        end)
      end
    end)
  end)
  
  --Crate spawns
  Trigger.OnKilled(CtrlStat, function()
		Actor.Create("moneycrate", true, { Owner = GDI, Location = CrateSpawn.Location })
	end)
  
  Trigger.OnKilled(Church, function()
		Actor.Create("pvice", true, { Owner = SubNod, Location = ViceSpawn.Location })
	end)
  
  --Testing
  --MainGDILandingForce()
  
  DestroyCommsObjective = GDI.AddObjective("Destroy the early warning stations.")
  FreeMutantsObjective = GDI.AddObjective("Free the captive mutants.", "Secondary", false)
  DestroySamsObjective = GDI.AddObjective("Destroy outer SAM sites to receive air support.", "Tertiary", false)
end


Tick = function()
	Utils.Do(GoodGuy.GetActorsByType("mcv"),function(UID)
		if MCVPlayers[MCVReinCounter] == nil then
			MCVReinCounter = 1
		end
		UID.Owner = MCVPlayers[MCVReinCounter]
		UID.Scatter()
		MCVReinCounter = MCVReinCounter + 1
	end)
	
	RamboTagger()
	OncePerSecondChecks()
	OncePerThreeSecondChecks()
end

OncePerSecondChecks = function()
  if DateTime.GameTime > 1 and DateTime.GameTime % 25 == 0 then
    --none
  end
end

OncePerThreeSecondChecks = function()
	if DateTime.GameTime > 1 and DateTime.GameTime % 75 == 0 then
    
	local ObjCounter = 0
    Utils.Do(CoopPlayers,function(PID)
		if HasOneOf(PID, LossCheckAll) == false then
			ObjCounter = ObjCounter + 1
		end
	end)
	if ObjCounter >= #CoopPlayers then
      PlayerFailMission()
    end
	
	--if HasOneOf(GDI, LossCheckAll) == false then PlayerFailMission() end
    
    if DefeatNodObjective ~= nil and HasOneOf(Nod, LossCheckCritical) == false then
      GDI.MarkCompletedObjective(DefeatNodObjective)
    end
    
    if AirstrikeGranted == false then CheckDestroyedSams() end
    
    --manipulate AI funds
    ManipulatePlayerFunds(Nod)
	end
end


CheckDestroyedSams = function()
  local samsLeft = SubNod.GetActorsByTypes({'sam'})
	if #samsLeft == 0 then
    AirstrikeGranted = true
    GDI.MarkCompletedObjective(DestroySamsObjective)
    Trigger.AfterDelay(DateTime.Seconds(5), function()
      Actor.Create("airstrike.proxy", true, { Owner = GDI })
      Media.DisplayMessage("Armed and ready for airstrikes, Commander!", "Morelli", HSLColor.FromHex("857833"))
    end)
	end
end


PlayerFailMission = function()
  if DefeatNodObjective ~= nil and not GDI.IsObjectiveCompleted(DefeatNodObjective) then
    GDI.MarkFailedObjective(DefeatNodObjective)
  end
  if FreeMutantsObjective ~= nil and not GDI.IsObjectiveCompleted(FreeMutantsObjective) then
    GDI.MarkFailedObjective(FreeMutantsObjective)
  end
  if DestroyCommsObjective ~= nil and not GDI.IsObjectiveCompleted(DestroyCommsObjective) then
    GDI.MarkFailedObjective(DestroyCommsObjective)
  end
  if DestroySamsObjective ~= nil and not GDI.IsObjectiveCompleted(DestroySamsObjective) then
    GDI.MarkFailedObjective(DestroySamsObjective)
  end
end

SendHeli = function(owner)
	Media.PlaySpeechNotification(All, "Reinforce")
	Reinforcements.Reinforce(owner, { 'tran' }, { RmboSpawn.Location }, 15, function(unit)
		CurrentHeli = unit
		unit.Move(TranLand.Location)
		local HeliVacant = false
		Trigger.OnPassengerEntered(unit, function(transporter,passenger)
			if HeliVacant == false then
				transporter.Owner = passenger.Owner
				HeliVacant = true
			end
		end)
		Trigger.OnPassengerEntered(unit, function(transporter,passenger)
			if HeliVacant == false then
				transporter.Owner = passenger.Owner
				HeliVacant = true
			end
		end)
		Trigger.OnPassengerExited(unit, function(transporter,passenger)
			if transporter.HasPassengers == false then
				HeliVacant = false
			end
		end)
		RespawnTrigger(unit)
	end)
end

RespawnTrigger = function(a)
	local UnitOwner
	local UnitType
	Trigger.OnKilled(a, function(self, killer)
		if RmbosDone == false then
			UnitOwner = a.Owner
			UnitType = a.Type
			if UnitType == "tran" then
				if Map.LobbyOption("respawn") == "enabled" or Map.LobbyOption("respawn") == "onlyheli" then
					Media.DisplayMessage("Transport Helicopter down. Sending another one. ETA 30 Seconds.", "EVA",UnitOwner.Color)
					Trigger.AfterDelay(DateTime.Seconds(30), function()
						SendHeli(UnitOwner)
					end)
				end
			elseif UnitType == "rmbo" then
				if Map.LobbyOption("respawn") == "enabled" then
					--Media.DisplayMessage("Returning in 30 Seconds.", UnitOwner.Name, UnitOwner.Color)
					Trigger.AfterDelay(DateTime.Seconds(30), function()
						Media.PlaySpeechNotification(All, "Reinforce")
						if CurrentHeli ~= nil and CurrentHeli.IsDead == false and CurrentHeli.IsInWorld == true then
							local newRmbo = Actor.Create(UnitType, false, { Owner = UnitOwner, Location = RmboUnload.Location })
							CurrentHeli.LoadPassenger(newRmbo)
							Beacon.New(UnitOwner, CurrentHeli.CenterPosition, 125)
						else
							ReinforceWithLandingCraft(UnitOwner, {UnitType}, RmboSpawn.Location, RmboUnload.Location, false)
							Beacon.New(UnitOwner, RmboUnload.CenterPosition, 125)
						end
					end)
				end
			end
		end
	end)
end

RamboTagger = function()
	Utils.Do(CoopPlayers,function(PID)
		Utils.Do(PID.GetActorsByType("rmbo"),function(UID)
			if UID.HasTag("prepped") == false then
				UID.AddTag("prepped")
				RespawnTrigger(UID)
				Trigger.OnKilled(UID, function(self, killer)
					Media.DisplayMessage("Damn, I was careless. I'll exfil for medical attention.\nYou're dead meat next time, Nod scum.", UID.Owner.Name, UID.Owner.Color)
					UID.RemoveTag("prepped")
				end)
			end
		end)
	end)
	if DateTime.GameTime > DateTime.Seconds(10) then
		if #Map.ActorsWithTag("prepped") == 0 and RmbosDone == false then
			RmbosDone = true
		end
	end
end