
ResearchFacilityDestroyed = false
NestsFumigated = 0
NestsToFumigate = 3
Nest1Fumigated = false
Nest2Fumigated = false
Nest3Fumigated = false
TibLifeAttackParity = 1

CarterArriving = false
GDIHasFact = false
EnableAirstrikes = false
GDIAttackParity = 1
GDIAttackFacilityOn = 6
GDIDefeated = false


ActorRemovals = {
  easy = {  },
  normal = {  },
  hard = {  },
}


AirstrikeAttacks = function()
  if EnableAirstrikes == false then return end
  if Difficulty == 'easy' then return end
  
  --[[
  local launchedIt = LaunchAIAirstrike(GDI, { Nod }, { 'a10scrip', 'a10scrip' }, { AirstrikeSpawn1, AirstrikeSpawn2 })
  Utils.Do(CoopPlayers,function(PID)
	if PID ~= Nod then
		LaunchAIAirstrike(GDI, { PID }, { 'a10scrip', 'a10scrip' }, { AirstrikeSpawn1, AirstrikeSpawn2 })
	end
  end)
  if launchedIt == true then
    Media.DisplayMessage("Warning: GDI airstrike incoming.", "Cabal", HSLColor.FromHex("FF0000"))
  end
  ]]

  local StrikeCounter = 0
  local launchedIt = LaunchAIAirstrike(GDI, { Nod }, { 'a10scrip', 'a10scrip' }, { AirstrikeSpawn1, AirstrikeSpawn2 })
  Utils.Do(CoopPlayers,function(PID)
	if PID ~= Nod then
		local ExtraLaunch = LaunchAIAirstrike(GDI, { PID }, { 'a10scrip', 'a10scrip' }, { AirstrikeSpawn1, AirstrikeSpawn2 })
		if ExtraLaunch == true then
			StrikeCounter = StrikeCounter + 1
		end
	end
  end)
  if launchedIt == true then
	StrikeCounter = StrikeCounter + 1
  end
  if StrikeCounter > 0 then
	Media.DisplayMessage("Warning: GDI airstrike incoming.", "Cabal", HSLColor.FromHex("FF0000"))
  end
  
  if Difficulty == 'normal' then Trigger.AfterDelay(DateTime.Seconds(450), function() AirstrikeAttacks() end) end
  if Difficulty == 'hard' then Trigger.AfterDelay(DateTime.Seconds(300), function() AirstrikeAttacks() end) end
end


PrepareNestFumigation = function(nest, var)
  Trigger.OnEnteredProximityTrigger(nest.CenterPosition, WDist.New(3 * 1024), function(a, id)
    if IsOwnedByCoopPlayer(a) and a.Type == 'truck' then
      Trigger.RemoveProximityTrigger(id)
      Actor.Create("flare", true, { Owner = BadGuy, Location = nest.Location })
      if var == 1 then Nest1Fumigated = true
      elseif var == 2 then Nest2Fumigated = true
      elseif var == 3 then Nest3Fumigated = true
      end
      NestsFumigated = NestsFumigated + 1
      if NestsFumigated > NestsToFumigate then NestsFumigated = NestsToFumigate end
      Media.DisplayMessage("Tiberium nest fumigated.", "NOTICE", HSLColor.FromHex("00FF00"))
    end
  end)
end


PrepareNestFumigations = function()
  PrepareNestFumigation(Nest1, 1)
  PrepareNestFumigation(Nest2, 2)
  PrepareNestFumigation(Nest3, 3)
end


-- GDI's AI attack production behavior -----

GDIAttackDelayMin = { easy = DateTime.Seconds(75), normal = DateTime.Seconds(60), hard = DateTime.Seconds(45) }
GDIAttackDelayMax = { easy = DateTime.Seconds(90), normal = DateTime.Seconds(75), hard = DateTime.Seconds(60) }

GDIAttackPaths = {
  { GDIAtk1.Location },
  { GDIAtk2.Location, GDIAtk3.Location },
}

GDIFacilityAttackPaths = {
  { GDIAtk2.Location, GDIAtk4.Location, GDIAtkR.Location },
  { GDIAtk2.Location, GDIAtk3.Location, GDIAtk5.Location, GDIAtkR.Location },
}

GDIAttackInfantryTypes = {
  easy = {
    { factory = GDIPyle, types = { "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1" } },
    { factory = GDIPyle, types = { "e2", "e2", "e2", "e2", "e2" } },
    { factory = GDIPyle, types = { "e3", "e3", "e3", "e3" } },
    { factory = GDIPyle, types = { "e1", "e1", "e1", "e1", "e1", "e3", "e3", "e3" } },
  },
  normal = {
    { factory = GDIPyle, types = { "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1" } },
    { factory = GDIPyle, types = { "e2", "e2", "e2", "e2", "e2", "e2" } },
    { factory = GDIPyle, types = { "e3", "e3", "e3", "e3", "e3" } },
    { factory = GDIPyle, types = { "e1", "e1", "e1", "e1", "e1", "e3", "e3", "e3", "e3" } },
  },
  hard = {
    { factory = GDIPyle, types = { "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1" } },
    { factory = GDIPyle, types = { "e2", "e2", "e2", "e2", "e2", "e2", "e2" } },
    { factory = GDIPyle, types = { "e3", "e3", "e3", "e3", "e3", "e3" } },
    { factory = GDIPyle, types = { "e1", "e1", "e1", "e1", "e1", "e1", "e3", "e3", "e3", "e3" } },
  }
}

GDIAttackVehicleTypes = {
  easy = {
    { factory = GDIWeap, types = { "jeep", "jeep", "jeep" } },
    { factory = GDIWeap, types = { "mtnk", "mtnk" } },
  },
  normal = {
    { factory = GDIWeap, types = { "jeep", "jeep", "jeep", "jeep" } },
    { factory = GDIWeap, types = { "mtnk", "mtnk", "mtnk" } },
    { factory = GDIWeap, types = { "mtnk", "mtnk", "msam", "msam" } },
  },
  hard = {
    { factory = GDIWeap, types = { "jeep", "jeep", "jeep", "jeep", "jeep" } },
    { factory = GDIWeap, types = { "mtnk", "mtnk", "mtnk", "mtnk" } },
    { factory = GDIWeap, types = { "mtnk", "mtnk", "mtnk", "msam", "msam" } },
  }
}


GDIInfantryProduction = function()
  if GDIDefeated == true then return end
  local production = Utils.Random(GDIAttackInfantryTypes[Difficulty])
  local path = Utils.Random(GDIAttackPaths)
  if GDIAttackParity % GDIAttackFacilityOn == 0 then
    Media.DisplayMessage("Warning! GDI is preparing an attack on the research facility!", "Cabal", HSLColor.FromHex("FF0000"))
    path = Utils.Random(GDIFacilityAttackPaths)
  end
  local toBuild = function() return production.types end
  local factory = GetAvailableFactory(GDI, 'pyle')
  
  if factory ~= nil then
    ProduceUnits(GDI, factory, nil, toBuild, function(units)
      UpdatePlayerBaseLocation()
      Utils.Do(units, function(unit)
        ErrorGuardAttackPatrol(unit, path)
        AssaultPlayerBaseOrHunt(unit)
      end)
      Trigger.AfterDelay(Utils.RandomInteger(GDIAttackDelayMin[Difficulty], GDIAttackDelayMax[Difficulty]), GDIInfantryProduction)
    end)
  else
    Trigger.AfterDelay(Utils.RandomInteger(GDIAttackDelayMin[Difficulty], GDIAttackDelayMax[Difficulty]), GDIInfantryProduction)
  end
end


GDIVehicleProduction = function()
  if GDIDefeated == true then return end
  GDIAttackParity = GDIAttackParity + 1
  
  local production = Utils.Random(GDIAttackVehicleTypes[Difficulty])
  local path = Utils.Random(GDIAttackPaths)
  if GDIAttackParity % GDIAttackFacilityOn == 0 then
    Media.DisplayMessage("Warning! GDI is preparing an attack on the research facility!", "Cabal", HSLColor.FromHex("FF0000"))
    path = Utils.Random(GDIFacilityAttackPaths)
  end
  local toBuild = function() return production.types end
  local factory = GetAvailableFactory(GDI, 'weap')
  
  if factory ~= nil then
    ProduceUnits(GDI, factory, nil, toBuild, function(units)
      UpdatePlayerBaseLocation()
      Utils.Do(units, function(unit)
        ErrorGuardAttackPatrol(unit, path)
        AssaultPlayerBaseOrHunt(unit)
      end)
    end)
  end
  
  Trigger.AfterDelay(Utils.RandomInteger(GDIAttackDelayMin[Difficulty], GDIAttackDelayMax[Difficulty]), GDIVehicleProduction)
end

-- End GDI's AI attack production behavior -----


-- Carter's AI base building behavior -----

BuildBaseOrders = {
  ["nuke1"] = { structure = "nuke", loc = GDINuke1.Location, tim = 12 },
  ["pyle"] =  { structure = "pyle", loc = GDIPyle.Location,  tim = 24 },
  ["proc"]  = { structure = "proc", loc = GDIProc.Location,  tim = 60 },
  ["nuke2"] = { structure = "nuke", loc = GDINuke2.Location, tim = 72 },
  ["weap"] =  { structure = "weap", loc = GDIWeap.Location,  tim = 120 },
  ["nuke3"] = { structure = "nuke", loc = GDINuke3.Location, tim = 132 },
  ["hq"] =    { structure = "hq",   loc = GDIHq.Location,    tim = 156 },
  
  ["gtwr1"]  =    { structure = "gtwr",    loc = GDIGtwr1.Location,     tim = 48 },
  ["rpgturr1"]  = { structure = "rpgturr", loc = GDIRPGTurr1.Location,  tim = 72 },
  ["gtwr2"]  =    { structure = "gtwr",    loc = GDIGtwr2.Location,     tim = 96 },
  ["rpgturr2"]  = { structure = "rpgturr", loc = GDIRPGTurr2.Location,  tim = 120 },
  ["gtwr3"]  =    { structure = "gtwr",    loc = GDIGtwr3.Location,     tim = 144 },
  ["rpgturr3"]  = { structure = "rpgturr", loc = GDIRPGTurr3.Location,  tim = 168 },
}

BuildCarterBase = function()
  for id, orders in pairs(BuildBaseOrders) do
    Trigger.AfterDelay(DateTime.Seconds(orders.tim), function()
      if GDIHasFact == true then
        local newBuilding = Actor.Create(orders.structure, true, { Owner = GDI, Location = orders.loc })
        AutoRebuildBuilding(newBuilding, GDI)
        if id == 'pyle' then
          GDIPyle = newBuilding
          Trigger.AfterDelay(DateTime.Seconds(5), function() GDIInfantryProduction() end)
        elseif id == 'weap' then
          GDIWeap = newBuilding
          Trigger.AfterDelay(DateTime.Seconds(5), function() GDIVehicleProduction() end)
        elseif id == 'proc' then
          AutoReplaceHarvesters(GDI)
          SetupRefAndSilosCaptureCredits(GDI)
        elseif id == 'hq' then
          EnableAirstrikes = true
          Trigger.AfterDelay(DateTime.Seconds(120), function()AirstrikeAttacks() end)
        end
      end
    end)
  end
end

-- End Carter's AI base building behavior -----


-- TibLife's AI attack production behavior -----

TibLifeAttackTarget = function(unit)
  if Difficulty == 'easy' then
    unit.AttackMove(GDIDeploy.Location)
  elseif Difficulty == 'normal' then
    if TibLifeAttackParity % 2 == 0 then
      unit.AttackMove(GDIDeploy.Location)
    else
      UpdatePlayerBaseLocation()
      AssaultPlayerBaseOrHunt(unit)
    end
  else
    UpdatePlayerBaseLocation()
    AssaultPlayerBaseOrHunt(unit)
  end
end

TibLifeAttackProduction = function()
	local multiplier
	if Map.LobbyOption("prmp") == "999" then
		multiplier = #CoopPlayers - 1
	else
		multiplier = 1 + tonumber(Map.LobbyOption("prmp", "0"))
	end
	
  TibLifeAttackParity = TibLifeAttackParity + 1
  
  for i = 1, multiplier do
  
  if Nest1Fumigated == false then
    Reinforcements.Reinforce(TibLife, { 'pvice' }, { Nest1.Location }, 15, function(unit)
      unit.AttackMove(NestAtk1.Location)
      TibLifeAttackTarget(unit)
    end)
  end
  
  if Nest2Fumigated == false then
    Reinforcements.Reinforce(TibLife, { 'pvice' }, { Nest2.Location }, 15, function(unit)
      unit.AttackMove(NestAtk2.Location)
      TibLifeAttackTarget(unit)
    end)
  end
  
  if Nest3Fumigated == false then
    Reinforcements.Reinforce(TibLife, { 'tfnd' }, { Nest3.Location }, 15, function(unit)
      unit.AttackMove(NestAtk3.Location)
      TibLifeAttackTarget(unit)
    end)
  end
  
  if Nest1Fumigated == false or Nest2Fumigated == false or Nest3Fumigated == false then
    Reinforcements.Reinforce(TibLife, { 'zombie', 'zombie', 'zombie', 'zombie', 'zombie' }, { ZomSpawn.Location }, 15, function(unit)
      unit.AttackMove(Sci456Run.Location)
      TibLifeAttackTarget(unit)
    end)
  end
  
  end
  
  Trigger.AfterDelay(DateTime.Seconds(240), TibLifeAttackProduction)
end


PrepareNestCounter = function(triggerWP, dist, fumigated, units, nest)
  Trigger.OnEnteredProximityTrigger(triggerWP.CenterPosition, WDist.New(dist * 1024), function(a, id)
    if Difficulty ~= 'easy' and fumigated == false then
      if IsOwnedByCoopPlayer(a) and a.Type ~= 'camera' then
        Trigger.RemoveProximityTrigger(id)
        TibLifeAttackParity = TibLifeAttackParity + 1
        Reinforcements.Reinforce(TibLife, units, { nest.Location }, 15, function(unit)
          unit.AttackMove(triggerWP.Location)
          TibLifeAttackTarget(unit)
        end)
      end
    end
  end)
end

PrepareNestCounters = function()
  PrepareNestCounter(NestTrigger1, 6, Nest1Fumigated, {'pvice', 'pvice', 'tfnd'}, Nest1)
  PrepareNestCounter(NestTrigger2A, 3, Nest2Fumigated, {'pvice', 'pvice', 'pvice'}, Nest2)
  PrepareNestCounter(NestTrigger2B, 3, Nest2Fumigated, {'pvice', 'pvice', 'pvice'}, Nest2)
  PrepareNestCounter(NestTrigger2C, 3, Nest2Fumigated, {'pvice', 'pvice', 'pvice'}, Nest2)
  PrepareNestCounter(NestTrigger3A, 3, Nest3Fumigated, {'tfnd', 'tfnd', 'tfnd'}, Nest3)
  PrepareNestCounter(NestTrigger3B, 3, Nest3Fumigated, {'tfnd', 'tfnd', 'tfnd'}, Nest3)
end

-- End TibLife's AI attack production behavior -----



WorldLoaded = function()
  GDI = Player.GetPlayer("GDI")
  Nod = Player.GetPlayer("Nod")
  FakeNod = Player.GetPlayer("FakeNod")
  Researchers = Player.GetPlayer("Researchers")
  TibLife = Player.GetPlayer("TibLife")

  MissionPlayer = Nod

	BadGuy = Player.GetPlayer("BadGuy")

	coopInfo =
	{
		Mainplayer = Nod,
		MainEnemies = {GDI},
		Dummyplayer = BadGuy
	}
	
	ORAMod = "tibalt"
	CoopInit25(coopInfo)

  Camera.Position = StartCam.CenterPosition
  
  --Remove actors based on difficulty
  Utils.Do(ActorRemovals[Difficulty], function(unit)
    unit.Destroy()
  end)
  
  --Special lighting
  Lighting.Ambient = 0.82
  Lighting.Red = 0.6
  Lighting.Blue = 0.6
  Lighting.Green = 1.3
  
  --Player Reinforcements
  
  --Objectives
  InitObjectives(Nod)
  
  Trigger.OnKilled(ResearchMiss, function(self, killer) ResearchFacilityDestroyed = true end)
  Trigger.OnKilled(ResearchBio, function(self, killer) ResearchFacilityDestroyed = true end)

  --AI player behavior
  GDI.Resources = 90000
  GDI.Cash = 90000
  
  --Enemy Predeployed Maneuvers
  
  --Proximity Triggers/Reveals
  PrepareNestCounters()
  PrepareNestFumigations()
  
  --Crate spawns
  
  --Cutscenes
  PrepareOpeningCutscene()
  
  Trigger.OnEnteredProximityTrigger(GDIAtk1.CenterPosition, WDist.New(5 * 1024), function(a, id)
    if IsOwnedByCoopPlayer(a) then
      Trigger.RemoveProximityTrigger(id)
      GDIArrival()
    end
  end)
  Trigger.OnEnteredProximityTrigger(GDIAtk2.CenterPosition, WDist.New(5 * 1024), function(a, id)
    if IsOwnedByCoopPlayer(a) then
      Trigger.RemoveProximityTrigger(id)
      GDIArrival()
    end
  end)
  
end


PrepareOpeningCutscene = function()
  OpCutsceneCam1 = Actor.Create("camera", true, { Owner = Nod, Location = StartCam.Location })
  
  Media.DisplayMessage("Establishing battlefield control -- stand by.", "Cabal", HSLColor.FromHex("FF0000"))

  Trigger.AfterDelay(DateTime.Seconds(3), function()
    Utils.Do({Vice1, Vice2}, function(unit) unit.AttackMove(Vice12Atk.Location) end)
    Utils.Do({Vice3, Vice4}, function(unit) unit.AttackMove(Vice34Atk.Location) end)
  end)

  Trigger.OnKilled(SciDie1, function(self, killer)
  Media.DisplayMessage("What's going on? The Tiberium life is running out of control!", "Researcher", HSLColor.FromHex("FF0000"))
    local zombies = { 'zombie', 'zombie', 'zombie', 'zombie', 'zombie', 'zombie', 'zombie', 'zombie', 'zombie', 'zombie'}
    Trigger.AfterDelay(DateTime.Seconds(6), function()
      Reinforcements.Reinforce(TibLife, zombies, { ZomSpawn.Location }, 15, function(zom) zom.AttackMove(ZomAtk.Location) end)
      Sci1.Move(Sci1Run.Location)
      Sci2.Move(Sci23Run.Location)
      Sci3.Move(Sci23Run.Location)
    end)
    
    Trigger.AfterDelay(DateTime.Seconds(4), function()
      Media.DisplayMessage("The research subjects have gone berserk! Run for it!", "Researcher", HSLColor.FromHex("FF0000"))
      Utils.Do({Sci4, Sci5, Sci6}, function(sci)
        sci.Move(Sci456Run.Location)
        sci.CallFunc(Car1Flee)
        sci.Destroy()
      end)
    end)
    
    Trigger.AfterDelay(DateTime.Seconds(5), function()
      Reinforcements.Reinforce(Researchers, {'chan', 'chan', 'chan'}, { SciSpawn.Location }, 5, function(sci)
        sci.Move(SciSpawnRun.Location)
        sci.CallFunc(Car2Flee)
        sci.Destroy()
      end)
    end)
  end)
end


Car1Fleeing = false
Car1Flee = function()
  if Car1Fleeing == true then return end
  Car1Fleeing = true
  Camera.Position = Car1.CenterPosition
  Car1.Move(CarRun1.Location)
  Car1.CallFunc(function()
    OpCutsceneCam1.Destroy()
    OpCutsceneCam2 = Actor.Create("camera", true, { Owner = Nod, Location = OpenCam1.Location })
    OpCutsceneCam3 = Actor.Create("camera", true, { Owner = Nod, Location = OpenCam1.Location })

    Trigger.AfterDelay(DateTime.Seconds(2), function()
      Media.DisplayMessage("What the hell are those?! The mutations are running rampant!", "Researcher", HSLColor.FromHex("FF0000"))
      TibFnd1.Move(TibFndWalk1.Location)
      TibFnd1.Move(TibFndWalk2.Location)
      TibFnd2.Move(TibFndWalk2.Location)
      TibFnd2.Move(TibFndWalk1.Location)
      Vice5.Move(ViceWalk5.Location)
    end)
  end)
  Car1.Move(CarRun2.Location)
  Car1.CallFunc(PlayerReinforcements)
  Car1.Move(CarRun3.Location)
  Car1.CallFunc(function()
    OpCutsceneCam2.Destroy()
    OpCutsceneCam3.Destroy()
  end)
  Car1.Destroy()
end


Car2Fleeing = false
Car2Flee = function()
  if Car2Fleeing == true then return end
  Car2Fleeing = true
  Car2.Move(CarRun1.Location)
  Car2.Move(CarRun2.Location)
  Car2.Move(CarRun3.Location)
  Car2.Destroy()
end


PlayerReinforcements = function()
  Media.DisplayMessage("Praise Kane! Reinforcements are here!", "Researcher", HSLColor.FromHex("FF0000"))
  Media.PlaySpeechNotification(All, "Reinforce")
  if Difficulty == 'easy' then
    Reinforcements.Reinforce(BadGuy, {'ltnk', 'bggy'}, { NodSpawn1.Location }, 15, function(unit)
      unit.Move(NodMoveTo1.Location)
    end)
    Reinforcements.Reinforce(BadGuy, {'ltnk', 'bggy'}, { NodSpawn2.Location }, 15, function(unit)
      unit.Move(NodMoveTo2.Location)
    end)
  elseif Difficulty == 'normal' then
    Reinforcements.Reinforce(BadGuy, {'bike', 'bggy'}, { NodSpawn1.Location }, 15, function(unit)
      unit.Move(NodMoveTo1.Location)
    end)
    Reinforcements.Reinforce(BadGuy, {'bike', 'bggy'}, { NodSpawn2.Location }, 15, function(unit)
      unit.Move(NodMoveTo2.Location)
    end)
  else
    Reinforcements.Reinforce(BadGuy, {'bggy'}, { NodSpawn1.Location }, 15, function(unit)
      unit.Move(NodMoveTo1.Location)
    end)
    Reinforcements.Reinforce(BadGuy, {'bggy'}, { NodSpawn2.Location }, 15, function(unit)
      unit.Move(NodMoveTo2.Location)
    end)
  end
  
  Trigger.AfterDelay(DateTime.Seconds(5), function()
    Media.DisplayMessage("You must bring the situation under control! Our research here is too valuable to lose!", "Researcher", HSLColor.FromHex("FF0000"))
    Media.PlaySpeechNotification(All, "Reinforce")
    Utils.Do(MCVPlayers,function(PID)
		Reinforcements.Reinforce(PID, {'mcv'}, { MCVSpawn.Location }, 15, function(unit)
			unit.Move(MCVMoveTo.Location)
		end)
	end)
  end)
  
  Trigger.AfterDelay(DateTime.Seconds(15), function()
    Media.DisplayMessage("Bring these special toxin trucks to the life forms' nests to fumigate them.", "Cabal", HSLColor.FromHex("FF0000"))
    Media.PlaySpeechNotification(All, "Reinforce")
    
    Reinforcements.Reinforce(Nod, {'truck'}, { NodSpawn1.Location }, 15, function(unit)
      unit.Move(NodMoveTo1.Location)
    end)
    Reinforcements.Reinforce(Nod, {'truck'}, { NodSpawn2.Location }, 15, function(unit)
      unit.Move(NodMoveTo2.Location)
    end)
    
    Trigger.AfterDelay(DateTime.Seconds(5), function()
      Media.DisplayMessage("There are no replacements, so do not squander them.", "Cabal", HSLColor.FromHex("FF0000"))
    end)
    
    Trigger.AfterDelay(DateTime.Seconds(10), function()
      ProtectFacilitiesObjective = Nod.AddObjective("Protect the research facilities.")
      FumigateNestsObjective = Nod.AddObjective("Bring toxin trucks to Tiberium nests.")
      DefeatTibLifeObjective = Nod.AddObjective("Destroy all infected life forms.")
    end)
    
    Trigger.AfterDelay(DateTime.Seconds(45), GDIArrival)
    Trigger.AfterDelay(DateTime.Seconds(330), TibLifeAttackProduction)
  end)
end



GDIArrival = function()
  if CarterArriving == true then return end
  CarterArriving = true
  Media.DisplayMessage("Warning: Approaching GDI forces detected.", "Cabal", HSLColor.FromHex("FF0000"))
  Media.PlaySound("Eva-EnemyReinforcements.aud")
  
  Trigger.AfterDelay(DateTime.Seconds(3), function()
    Camera.Position = GDICam.CenterPosition
    CarterCutsceneCam1 = Actor.Create("camera", true, { Owner = Nod, Location = GDICam.Location })
    Actor.Create("boat", true, { Owner = GDI, Location = GDIBoat1.Location })
    if Difficulty ~= 'easy' then Actor.Create("boat", true, { Owner = GDI, Location = GDIBoat2.Location }) end
    if Difficulty == 'hard' then Actor.Create("boat", true, { Owner = GDI, Location = GDIBoat3.Location }) end
  end)
  
  Trigger.AfterDelay(DateTime.Seconds(10), function()
    Media.DisplayMessage("Incoming transmission.", "Cabal", HSLColor.FromHex("FF0000"))
    Reinforcements.Reinforce(GDI, {'mtnk', 'mtnk', 'jeep', 'jeep'}, { GDISpawn.Location }, 15, function(unit)
      unit.Move(GDIDefend1.Location)
    end)
  end)
  
  Trigger.AfterDelay(DateTime.Seconds(13), function()
    Media.DisplayMessage("Get ready for a world of hurt, Nod scum.", "Carter", HSLColor.FromHex("857833"))
    Reinforcements.Reinforce(GDI, {'mtnk', 'mtnk', 'jeep', 'jeep'}, { GDISpawn.Location }, 15, function(unit)
      unit.Move(GDIDefend2.Location)
    end)
  end)
  
  Trigger.AfterDelay(DateTime.Seconds(16), function()
    Media.DisplayMessage("I'm going to put an end to you and your sick Tiberium experiments.", "Carter", HSLColor.FromHex("857833"))
    Reinforcements.Reinforce(GDI, {'mcv'}, { GDISpawn.Location }, 15, function(mcv)
      mcv.Move(GDIDeploy.Location)
      mcv.Deploy()
      mcv.CallFunc(function()
        Trigger.AfterDelay(DateTime.Seconds(2), function()
          GDIHasFact = true
          BuildCarterBase()
          CarterFact = GDI.GetActorsByType('fact')[1]
          Trigger.OnKilled(CarterFact, function(self, killer) GDIHasFact = false end)
        end)
      end)
    end)
  end)
  
  Trigger.AfterDelay(DateTime.Seconds(20), function()
    Media.DisplayMessage("The interlopers must be destroyed. Put this GDI mongrel in his place.", "Cabal", HSLColor.FromHex("FF0000"))
  end)
  
  Trigger.AfterDelay(DateTime.Seconds(25), function()
    DefeatGDIObjective = Nod.AddObjective("Destroy the GDI incursion.")
    CarterCutsceneCam1.Destroy()
  end)
end

  

Tick = function()
	OncePerSecondChecks()
	OncePerThreeSecondChecks()
  
  --Thunder and lightning
	if (Utils.RandomInteger(1, 200) == 10) then
		local delay = Utils.RandomInteger(1, 10)
		Lighting.Flash("LightningStrike", delay)
		Trigger.AfterDelay(delay, function()
			Media.PlaySound("thunder" .. Utils.RandomInteger(1,6) .. ".aud")
		end)
	end
	if (Utils.RandomInteger(1, 200) == 10) then
		Media.PlaySound("thunder-ambient.aud")
	end
end

OncePerSecondChecks = function()
  if DateTime.GameTime > 1 and DateTime.GameTime % 25 == 0 then
    --none
  end
end

OncePerThreeSecondChecks = function()
	if DateTime.GameTime > 1 and DateTime.GameTime % 75 == 0 then
    if ResearchFacilityDestroyed == true and ProtectFacilitiesObjective ~= nil then
      Media.DisplayMessage("A vital research facility has been destroyed!", "Cabal", HSLColor.FromHex("FF0000"))
      Trigger.AfterDelay(DateTime.Seconds(3), function() PlayerFailMission() end)
    end
    
    if FumigateNestsObjective ~= nil and not Nod.IsObjectiveCompleted(FumigateNestsObjective) and not HasOneOf(Nod, {'truck'}) then
      Media.DisplayMessage("All toxin trucks have been destroyed!", "Cabal", HSLColor.FromHex("FF0000"))
      Trigger.AfterDelay(DateTime.Seconds(3), function() PlayerFailMission() end)
    end
    
    if NestsFumigated == NestsToFumigate and FumigateNestsObjective ~= nil and not Nod.IsObjectiveCompleted(FumigateNestsObjective) then
      Nod.MarkCompletedObjective(FumigateNestsObjective)
      local tiblife = TibLife.GetActorsByTypes( {'tfnd', 'pvice'} )
      Utils.Do(tiblife, function(unit) unit.Hunt() end)
    end
    
    if NestsFumigated == NestsToFumigate and DefeatTibLifeObjective ~= nil and
      not Nod.IsObjectiveCompleted(DefeatTibLifeObjective) and HasOneOf(TibLife, LossCheckTibLife) == false
    then Nod.MarkCompletedObjective(DefeatTibLifeObjective) end
    
    if DefeatGDIObjective ~= nil and not Nod.IsObjectiveCompleted(DefeatGDIObjective) and
      HasOneOf(GDI, LossCheckStructures) == false
    then
      Nod.MarkCompletedObjective(DefeatGDIObjective)
      GDIDefeated = true
    end
    
    if DefeatGDIObjective ~= nil and DefeatTibLifeObjective ~= nil then
      if Nod.IsObjectiveCompleted(DefeatGDIObjective) and Nod.IsObjectiveCompleted(DefeatTibLifeObjective) then
        Nod.MarkCompletedObjective(ProtectFacilitiesObjective)
      end
    end
    
    if EnableAirstrikes == true and HasOneOf(GDI, {'hq'}) == false and HasOneOf(GDI, {'fact'}) == false then
      EnableAirstrikes = false
    end
	end
end


PlayerFailMission = function()
  if ProtectFacilitiesObjective ~= nil and not Nod.IsObjectiveCompleted(ProtectFacilitiesObjective) then
    Nod.MarkFailedObjective(ProtectFacilitiesObjective)
  end
  if FumigateNestsObjective ~= nil and not Nod.IsObjectiveCompleted(FumigateNestsObjective) then
    Nod.MarkFailedObjective(FumigateNestsObjective)
  end
  if DefeatTibLifeObjective ~= nil and not Nod.IsObjectiveCompleted(DefeatTibLifeObjective) then
    Nod.MarkFailedObjective(DefeatTibLifeObjective)
  end
  if DefeatGDIObjective ~= nil and not Nod.IsObjectiveCompleted(DefeatGDIObjective) then
    Nod.MarkFailedObjective(DefeatGDIObjective)
  end
end
