
SamSitesDestroyed = 0
GDIBaseFound = false
NodActive = false
SubNodActive = false
VisceroidParity = 1


ActorRemovals =
{
  easy = { EZR1, EZR2, EZR3, EZR4, EZR5, EZR6, EZR7, EZR8 },
  normal = { SubGDIFact },
  hard = { SubGDIFact },
}


SamSiteDestroyed = function()
  SamSitesDestroyed = SamSitesDestroyed + 1
  local remainingSams = 4 - SamSitesDestroyed
  Media.DisplayMessage("SAM site destroyed! " .. remainingSams .. " remaining.", "NOTICE", HSLColor.Green)
  CheckDestroyedSams()
end


CheckDestroyedSams = function()
	if SamSitesDestroyed == 4 then
    GDI.MarkCompletedObjective(DestroySamsObjective)
		UserInterface.SetMissionText("", HSLColor.Lime)
    Trigger.AfterDelay(DateTime.Seconds(5), function()
      Actor.Create("airstrike.proxy", true, { Owner = GDI })
      Media.DisplayMessage("Armed and ready for airstrikes, Commander!", "Morelli", HSLColor.FromHex("857833"))
    end)
	else
		UserInterface.SetMissionText(SamSitesDestroyed .. " of 4 SAM sites destroyed.", HSLColor.Yellow)
	end
end


FindBase = function()
  if GDIBaseFound == false then
    GDIBaseFound = true
    local foundBase = SubGDI.GetActors()
	local foundBaseUnits = SubGDI.GetGroundAttackers()
    Utils.Do(foundBase, function(unit)
      unit.Owner = GDI
    end)
	Utils.Do(foundBaseUnits, function(unit)
      unit.Owner = GoodGuy
    end)
    if Difficulty ~= 'hard' then
      Actor.Create("harv", true, { Owner = GDI, Location = HarvSpawn.Location })
    end
    
    GDI.MarkCompletedObjective(FindBaseObjective)
    Media.PlaySound("Eva-TargetLocated.aud")
    
    Trigger.AfterDelay(DateTime.Seconds(5), function()
      Media.DisplayMessage("Reinforcements, thank God! Are we ever glad to see you!", "GDI", HSLColor.FromHex("857833"))
    end)
    
    Trigger.AfterDelay(Utils.RandomInteger(DateTime.Seconds(180), DateTime.Seconds(240)), SpawnVisceroids)
    Trigger.AfterDelay(DateTime.Seconds(45), function()
      AwakenSubNod()
      AwakenNod()
    end)
  end
end


-- Nod's AI attack production behavior -----

NodAttackDelayMin = { easy = DateTime.Seconds(90), normal = DateTime.Seconds(60), hard = DateTime.Seconds(45) }
NodAttackDelayMax = { easy = DateTime.Seconds(120), normal = DateTime.Seconds(90), hard = DateTime.Seconds(60) }

NodVehicleAttacks = {
  easy = {
    {
      factory = 'afld',
      types = { "bggy", "bggy", "bggy" },
      paths = {
        { NodAtkRoute1.Location, NodAtkRoute2.Location, NodAtkRoute3A.Location, PlayerBase.Location },
        { NodAtkRoute1.Location, NodAtkRoute2.Location, NodAtkRoute3B.Location, PlayerBase.Location },
      }
    },
    {
      factory = 'afld',
      types = { "bike", "bike", "bike" },
      paths = {
        { NodAtkRoute1.Location, NodAtkRoute2.Location, NodAtkRoute3A.Location, PlayerBase.Location },
        { NodAtkRoute1.Location, NodAtkRoute2.Location, NodAtkRoute3B.Location, PlayerBase.Location },
      }
    },
    {
      factory = 'afld',
      types = { "bike", "bike", "bggy", "bggy" },
      paths = {
        { NodAtkRoute1.Location, NodAtkRoute2.Location, NodAtkRoute3A.Location, PlayerBase.Location },
        { NodAtkRoute1.Location, NodAtkRoute2.Location, NodAtkRoute3B.Location, PlayerBase.Location },
      }
    },
    {
      factory = 'afld',
      types = { "ltnk", "ltnk" },
      paths = {
        { NodAtkRoute1.Location, NodAtkRoute2.Location, NodAtkRoute3A.Location, PlayerBase.Location },
        { NodAtkRoute1.Location, NodAtkRoute2.Location, NodAtkRoute3B.Location, PlayerBase.Location },
      }
    },
  },
  normal = {
    {
      factory = 'afld',
      types = { "bike", "bike", "bggy", "bggy", "bggy" },
      paths = {
        { NodAtkRoute1.Location, NodAtkRoute2.Location, NodAtkRoute3A.Location, PlayerBase.Location },
        { NodAtkRoute1.Location, NodAtkRoute2.Location, NodAtkRoute3B.Location, PlayerBase.Location },
      }
    },
    {
      factory = 'afld',
      types = { "ltnk", "ltnk", "ltnk" },
      paths = {
        { NodAtkRoute1.Location, NodAtkRoute2.Location, NodAtkRoute3A.Location, PlayerBase.Location },
        { NodAtkRoute1.Location, NodAtkRoute2.Location, NodAtkRoute3B.Location, PlayerBase.Location },
      }
    },
    {
      factory = 'afld',
      types = { "ltnk", "ltnk", "arty", "arty" },
      paths = {
        { NodAtkRoute1.Location, NodAtkRoute2.Location, NodAtkRoute3A.Location, PlayerBase.Location },
        { NodAtkRoute1.Location, NodAtkRoute2.Location, NodAtkRoute3B.Location, PlayerBase.Location },
      }
    },
    {
      factory = 'afld',
      types = { "arty", "arty" },
      paths = {
        { NodAtkRoute1.Location, NodAtkRoute2.Location, NodAtkRoute3C.Location },
      }
    },
  },
  hard = {
    {
      factory = 'afld',
      types = { "bike", "bike", "bike", "bggy", "bggy", "bggy" },
      paths = {
        { NodAtkRoute1.Location, NodAtkRoute2.Location, NodAtkRoute3A.Location, PlayerBase.Location },
        { NodAtkRoute1.Location, NodAtkRoute2.Location, NodAtkRoute3B.Location, PlayerBase.Location },
      }
    },
    {
      factory = 'afld',
      types = { "ltnk", "ltnk", "ltnk", "ltnk" },
      paths = {
        { NodAtkRoute1.Location, NodAtkRoute2.Location, NodAtkRoute3A.Location, PlayerBase.Location },
        { NodAtkRoute1.Location, NodAtkRoute2.Location, NodAtkRoute3B.Location, PlayerBase.Location },
      }
    },
    {
      factory = 'afld',
      types = { "ltnk", "ltnk", "arty", "arty", "arty" },
      paths = {
        { NodAtkRoute1.Location, NodAtkRoute2.Location, NodAtkRoute3A.Location, PlayerBase.Location },
        { NodAtkRoute1.Location, NodAtkRoute2.Location, NodAtkRoute3B.Location, PlayerBase.Location },
      }
    },
    {
      factory = 'afld',
      types = { "arty", "arty", "arty", "arty" },
      paths = {
        { NodAtkRoute1.Location, NodAtkRoute2.Location, NodAtkRoute3C.Location },
      }
    },
  }
}

NodVehicleAttackProduction = function()
  local production = Utils.Random(NodVehicleAttacks[Difficulty])
  local path = Utils.Random(production.paths)
  local toBuild = function() return production.types end
  local factory = GetAvailableFactory(Nod, production.factory)

  if factory ~= nil then
    ProduceUnits(Nod, factory, nil, toBuild, function(units)
      UpdatePlayerBaseLocation()
      Utils.Do(units, function(unit)
        ErrorGuardAttackPatrol(unit, path)
        AssaultPlayerBaseOrHunt(unit)
      end)
      Trigger.AfterDelay(Utils.RandomInteger(NodAttackDelayMin[Difficulty], NodAttackDelayMax[Difficulty]), NodVehicleAttackProduction)
    end)
  else
    Trigger.AfterDelay(Utils.RandomInteger(NodAttackDelayMin[Difficulty], NodAttackDelayMax[Difficulty]), NodVehicleAttackProduction)
  end
end

NodAttackInfantryTypes = {
  easy =
  {
    { factory = 'hand', types = { "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1" } },
    { factory = 'hand', types = { "e3", "e3", "e3", "e3" } },
    { factory = 'hand', types = { "e1", "e1", "e1", "e1", "e1", "e3", "e3", "e3" } },
  },
  normal =
  {
    { factory = 'hand', types = { "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1" } },
    { factory = 'hand', types = { "e3", "e3", "e3", "e3", "e3" } },
    { factory = 'hand', types = { "e1", "e1", "e1", "e1", "e1", "e3", "e3", "e3", "e3" } },
  },
  hard =
  {
    { factory = 'hand', types = { "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1" } },
    { factory = 'hand', types = { "e3", "e3", "e3", "e3", "e3", "e3" } },
    { factory = 'hand', types = { "e1", "e1", "e1", "e1", "e1", "e1", "e3", "e3", "e3", "e3" } },
  }
}

NodInfantryAttackPaths = {
  { NodAtkRoute1.Location, NodAtkRoute2.Location, NodAtkRoute3A.Location, PlayerBase.Location },
  { NodAtkRoute1.Location, NodAtkRoute2.Location, NodAtkRoute3B.Location, PlayerBase.Location },
}

NodInfantryAttackProduction = function()
  local production = Utils.Random(NodAttackInfantryTypes[Difficulty])
  local path = Utils.Random(NodInfantryAttackPaths)
  local toBuild = function() return production.types end
  local factory = GetAvailableFactory(Nod, production.factory)  

  if factory ~= nil then
    ProduceUnits(Nod, factory, nil, toBuild, function(units)
      UpdatePlayerBaseLocation()
      Utils.Do(units, function(unit)
        ErrorGuardAttackPatrol(unit, path)
        AssaultPlayerBaseOrHunt(unit)
      end)
      Trigger.AfterDelay(Utils.RandomInteger(NodAttackDelayMin[Difficulty], NodAttackDelayMax[Difficulty]), NodInfantryAttackProduction)
    end)
  else
    Trigger.AfterDelay(Utils.RandomInteger(NodAttackDelayMin[Difficulty], NodAttackDelayMax[Difficulty]), NodInfantryAttackProduction)
  end
end

AwakenNod = function()
  if NodActive == true then return end
  NodActive = true
  local newBuilding = Actor.Create('proc', true, { Owner = Nod, Location = NodProc.Location })
  AutoRebuildBuilding(newBuilding, Nod)
  AutoReplaceHarvesters(Nod)
  NodVehicleAttackProduction()
  NodInfantryAttackProduction()
end

NodLaunchCounter = function()
  local attackers = Map.ActorsInBox(NodCounterNW.CenterPosition, NodCounterSE.CenterPosition, function(a)
    return a.Owner == Nod and a.Type == "e1"
  end)
  Utils.Do(attackers, function(unit)
    unit.AttackMove(NodCounterTarget.Location)
  end)

  AwakenSubNod()
  AwakenNod()
end

-- End Nod's AI attack production behavior -----


-- SubNod's AI attack production behavior -----

SubNodAttackDelayMin = { easy = DateTime.Seconds(90), normal = DateTime.Seconds(60), hard = DateTime.Seconds(45) }
SubNodAttackDelayMax = { easy = DateTime.Seconds(120), normal = DateTime.Seconds(90), hard = DateTime.Seconds(60) }
SubNodAttackUnitTypes =
{
  easy =
  {
    { factory = 'hand', types = { "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1" } },
    { factory = 'hand', types = { "e3", "e3", "e3", "e3" } },
    { factory = 'hand', types = { "e1", "e1", "e1", "e1", "e1", "e3", "e3", "e3" } },
  },
  normal =
  {
    { factory = 'hand', types = { "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1" } },
    { factory = 'hand', types = { "e3", "e3", "e3", "e3", "e3" } },
    { factory = 'hand', types = { "e1", "e1", "e1", "e1", "e1", "e3", "e3", "e3", "e3" } },
  },
  hard =
  {
    { factory = 'hand', types = { "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1" } },
    { factory = 'hand', types = { "e3", "e3", "e3", "e3", "e3", "e3" } },
    { factory = 'hand', types = { "e1", "e1", "e1", "e1", "e1", "e1", "e3", "e3", "e3", "e3" } },
  }
}

SubNodAttackPaths =
{
  { PlayerBase.Location }
}

SubNodAttackProduction = function()
  local production = Utils.Random(SubNodAttackUnitTypes[Difficulty])
  local path = Utils.Random(SubNodAttackPaths)
  local toBuild = function() return production.types end
  local factory = GetAvailableFactory(SubNod, production.factory)
  
  if factory ~= nil then
    ProduceUnits(SubNod, factory, nil, toBuild, function(units)
      UpdatePlayerBaseLocation()
      Utils.Do(units, function(unit)
        ErrorGuardAttackPatrol(unit, path)
        AssaultPlayerBaseOrHunt(unit)
      end)
      Trigger.AfterDelay(Utils.RandomInteger(SubNodAttackDelayMin[Difficulty], SubNodAttackDelayMax[Difficulty]), SubNodAttackProduction)
    end)
  else
    Trigger.AfterDelay(Utils.RandomInteger(SubNodAttackDelayMin[Difficulty], SubNodAttackDelayMax[Difficulty]), SubNodAttackProduction)
  end
end

AwakenSubNod = function()
  if SubNodActive == true then return end
  SubNodActive = true
  SubNodAttackProduction()
end

SubNodLaunchCounter = function()
  local attackers = Map.ActorsInBox(SubNodCounterNW.CenterPosition, SubNodCounterSE.CenterPosition, function(a)
    return a.Owner == SubNod and a.Type == "e1"
  end)
  Utils.Do(attackers, function(unit)
    unit.AttackMove(SubNodCounterTarget.Location)
  end)

  AwakenSubNod()
  AwakenNod()
end

-- End SubNod's AI attack production behavior -----


-- TibLife's AI attack production behavior -----

SpawnVisceroids = function()
  local visceroids = { 'pvice', 'pvice', 'pvice' }
  VisceroidParity = VisceroidParity + 1
  
  Reinforcements.Reinforce(TibLife, visceroids, { ViceSpawn.Location }, 15, function(vice)
    if Difficulty == 'easy' then
      local viceTarget = Utils.RandomInteger(1, 2)
      if viceTarget == 1 then vice.AttackMove(NodBase.Location)
      else vice.AttackMove(NodAwake2.Location) end
    elseif Difficulty == 'normal' then
      if VisceroidParity % 2 == 0 then
        vice.AttackMove(PlayerBase.Location)
      else
        local viceTarget = Utils.RandomInteger(1, 2)
        if viceTarget == 1 then vice.AttackMove(NodBase.Location)
        else vice.AttackMove(NodAwake2.Location) end
      end
    else
      vice.AttackMove(PlayerBase.Location)
    end
  end)
  
  Trigger.AfterDelay(Utils.RandomInteger(DateTime.Seconds(180), DateTime.Seconds(240)), SpawnVisceroids)
end

-- TibLife's AI attack production behavior -----




WorldLoaded = function()
  GDI = Player.GetPlayer("GDI")
  Nod = Player.GetPlayer("Nod")
  SubGDI = Player.GetPlayer("SubGDI")
  SubNod = Player.GetPlayer("SubNod")
  TibLife = Player.GetPlayer("TibLife")

	--Override Sharing options
	BaseShared = true
	TechShared = true
	MoneyShareOverride = 100

  --Remove actors based on difficulty
  Utils.Do(ActorRemovals[Difficulty], function(unit)
    unit.Destroy()
  end)

	GoodGuy = Player.GetPlayer("GoodGuy")

	coopInfo =
	{
		Mainplayer = GDI,
		MainEnemies = {Nod,SubNod},
		Dummyplayer = GoodGuy
	}
	
	ORAMod = "tibalt"
	CoopInit25(coopInfo)

  MissionPlayer = GDI



  Camera.Position = StartCam.CenterPosition
  
  --Special lighting
  Lighting.Ambient = 0.82
  Lighting.Red = 0.8
  Lighting.Blue = 1.0
  Lighting.Green = 0.85
  
  --Player Reinforcements
  Trigger.OnEnteredProximityTrigger(FoundBase1.CenterPosition, WDist.New(5 * 1024), function(a, id)
    if IsOwnedByCoopPlayer(a) then
      Trigger.RemoveProximityTrigger(id)
      FindBase()
    end
  end)
  Trigger.OnEnteredProximityTrigger(FoundBase2.CenterPosition, WDist.New(4 * 1024), function(a, id)
    if IsOwnedByCoopPlayer(a) then
      Trigger.RemoveProximityTrigger(id)
      FindBase()
    end
  end)
  Trigger.OnEnteredProximityTrigger(FoundBase3.CenterPosition, WDist.New(4 * 1024), function(a, id)
    if IsOwnedByCoopPlayer(a) then
      Trigger.RemoveProximityTrigger(id)
      FindBase()
    end
  end)
  Trigger.OnEnteredProximityTrigger(FoundBase4.CenterPosition, WDist.New(6 * 1024), function(a, id)
    if IsOwnedByCoopPlayer(a) then
      Trigger.RemoveProximityTrigger(id)
      FindBase()
    end
  end)
  
  UserInterface.SetMissionText(SamSitesDestroyed .. " of 4 SAM sites destroyed.", HSLColor.Yellow)
  
  --Objectives
  InitObjectives(GDI)
  Trigger.AfterDelay(DateTime.Seconds(3), function()
    DefeatNodObjective = GDI.AddObjective("Destroy the main Nod base.")
    FindBaseObjective = GDI.AddObjective("Find the damaged GDI base.", "Secondary", false)
    DestroySamsObjective = GDI.AddObjective("Destroy all SAM sites to receive air support.", "Tertiary", false)
  end)
  
  Trigger.OnKilled(SAM1, function(sam, killer) SamSiteDestroyed() end)
  Trigger.OnKilled(SAM2, function(sam, killer) SamSiteDestroyed() end)
  Trigger.OnKilled(SAM3, function(sam, killer) SamSiteDestroyed() end)
  Trigger.OnKilled(SAM4, function(sam, killer) SamSiteDestroyed() end)
  
  
  --AI player behavior
  Nod.Resources = Nod.ResourceCapacity - 500
  Nod.Cash = 90000
  
  SubNod.Resources = 50000
  SubNod.Cash = 50000
  
  if Difficulty ~= "easy" then
    AutoRepairAndRebuildBuildings(Nod, 15)
  end
  
  SetupRefAndSilosCaptureCredits(Nod)
  
  local nodDefenders = { NodDef1, NodDef2, NodDef3, NodDef4, NodDef5, NodDef6,
                         NodDef7, NodDef8, NodDef9, NodDef10, NodDef11, NodDef12,
                         NodDef13, NodDef14, NodDef15, NodDef16, NodDef17, NodDef18,
                         NodDef19, NodDef20, NodDef21, NodDef22, NodDef23, NodDef24 }
  Utils.Do(nodDefenders, function(unit)
    Trigger.OnKilled(unit, function(self, killer) AwakenNod() end)
  end)
  
  Trigger.OnEnteredProximityTrigger(NodAwake1.CenterPosition, WDist.New(3 * 1024), function(a, id)
    if IsOwnedByCoopPlayer(a) and a.Type ~= 'camera' then
      Trigger.RemoveProximityTrigger(id)
      AwakenNod()
    end
  end)
  
  --Enemy Predeployed Maneuvers
  Trigger.AfterDelay(DateTime.Seconds(6), function()
    Utils.Do({InitialAtk1, InitialAtk2, InitialAtk3, InitialAtk4, InitialAtk5, InitialAtk6}, function(unit)
      unit.AttackMove(StartCam.Location)
    end)
  end)
  
  local subNodDefenders = { SubNodDef1, SubNodDef2, SubNodDef3, SubNodDef4 }
  Utils.Do(subNodDefenders, function(unit)
    Trigger.OnKilled(unit, function(self, killer) SubNodLaunchCounter() end)
  end)
  
  Trigger.OnEnteredProximityTrigger(SubNodAwake.CenterPosition, WDist.New(6 * 1024), function(a, id)
    if IsOwnedByCoopPlayer(a) and a.Type ~= 'camera' then
      Trigger.RemoveProximityTrigger(id)
      SubNodLaunchCounter()
    end
  end)
  
  Trigger.OnEnteredProximityTrigger(NodCounterTrigger.CenterPosition, WDist.New(4 * 1024), function(a, id)
    if IsOwnedByCoopPlayer(a) and a.Type ~= 'camera' then
      Trigger.RemoveProximityTrigger(id)
      NodLaunchCounter()
    end
  end)
  
  --Proximity Triggers/Reveals
  Trigger.OnEnteredProximityTrigger(ProxRvl1.CenterPosition, WDist.New(3 * 1024), function(a, id)
    if IsOwnedByCoopPlayer(a) and a.Type ~= 'camera' then
      Trigger.RemoveProximityTrigger(id)
      ProxRvlCam1Actor = Actor.Create("camera", true, { Owner = GDI, Location = ProxRvlCam1.Location })
      Trigger.AfterDelay(DateTime.Seconds(10), function()
        ProxRvlCam1Actor.Destroy()
      end)
    end
  end)
  
  Trigger.OnEnteredProximityTrigger(ProxRvl2.CenterPosition, WDist.New(12 * 1024), function(a, id)
    if IsOwnedByCoopPlayer(a) and a.Type ~= 'camera' then
      Trigger.RemoveProximityTrigger(id)
      ProxRvl2CamActor = Actor.Create("camera", true, { Owner = GDI, Location = ProxRvl2.Location })
      Trigger.AfterDelay(DateTime.Seconds(10), function()
        ProxRvl2CamActor.Destroy()
      end)
    end
  end)
  
  Trigger.OnEnteredProximityTrigger(ProxRvl3.CenterPosition, WDist.New(9 * 1024), function(a, id)
    if IsOwnedByCoopPlayer(a) and a.Type ~= 'camera' then
      Trigger.RemoveProximityTrigger(id)
      ProxRvl3CamActor = Actor.Create("camera", true, { Owner = GDI, Location = ProxRvl3.Location })
      Trigger.AfterDelay(DateTime.Seconds(10), function()
        ProxRvl3CamActor.Destroy()
      end)
    end
  end)
  
  --Crate spawns
end


Tick = function()
	OncePerSecondChecks()
	OncePerThreeSecondChecks()
end

OncePerSecondChecks = function()
  if DateTime.GameTime > 1 and DateTime.GameTime % 25 == 0 then
    --none
  end
end

OncePerThreeSecondChecks = function()
	if DateTime.GameTime > 1 and DateTime.GameTime % 75 == 0 then

	local ObjCounter = 0
	Utils.Do(CoopPlayers,function(PID)
		if HasOneOf(PID, LossCheckAll) == false then
			ObjCounter = ObjCounter + 1
		end
	end)
	if ObjCounter >= #CoopPlayers then
      PlayerFailMission()
    end

    if HasOneOf(Nod, LossCheckCritical) == false then
      GDI.MarkCompletedObjective(DefeatNodObjective)
    end
    
    --manipulate AI funds
    ManipulatePlayerFunds(Nod)
	end
end


PlayerFailMission = function()
  if DefeatNodObjective ~= nil and not GDI.IsObjectiveCompleted(DefeatNodObjective) then
    GDI.MarkFailedObjective(DefeatNodObjective)
  end
  if FindBaseObjective ~= nil and not GDI.IsObjectiveCompleted(FindBaseObjective) then
    GDI.MarkFailedObjective(FindBaseObjective)
  end
  if DestroySamsObjective ~= nil and not GDI.IsObjectiveCompleted(DestroySamsObjective) then
    GDI.MarkFailedObjective(DestroySamsObjective)
  end
end