
Patrollers = { PatrolA1, PatrolA2, PatrolA3, PatrolA4, PatrolA5, PatrolA6, PatrolA7, PatrolA8, PatrolA9, PatrolA10,
               PatrolB1, PatrolB2, PatrolB3, PatrolB4, PatrolB5, PatrolB6, PatrolB7, PatrolB8, PatrolB9, PatrolB10,
               MTnk1, MTnk2, MTnk3 }

GDIHunting = false
MutantsLiberated = 0
MutantsToLiberate = 5
PlayerKilledMutantInProgress = false

Group1Liberated = false
Group2Liberated = false

Blockade1Awake = false
Blockade2Awake = false
MainBaseAwake = false


ActorRemovals =
{
  easy = { EZR1, EZR2 },
  normal = { Prisoner6, Prisoner7, Prisoner13, Prisoner14, Engy8 },
  hard = { Prisoner6, Prisoner7, Prisoner13, Prisoner14, Engy6, Engy7, Engy8 },
}


LiberateMutants = function(toLiberate)
  MutantsLiberated = MutantsLiberated + 1
  if MutantsLiberated == MutantsToLiberate then Nod.MarkCompletedObjective(LiberateMutantsObjective) end
  Utils.Do(toLiberate, function(unit)
    if unit ~= nil and not unit.IsDead then unit.Owner = BadGuy end
  end)
  
  if Difficulty ~= 'hard' then
    Trigger.AfterDelay(DateTime.Seconds(90), function() BeginGDIHunt() end)
  else
    BeginGDIHunt()
  end
end


PlayerKilledMutant = function(checkGroupLiberated, killer)
  if IsOwnedByCoopPlayer(killer) then
    if PlayerKilledMutantInProgress == true then return end
    PlayerKilledMutantInProgress = true
    if checkGroupLiberated == false then
      Media.DisplayMessage("Nod scum! As if GDI oppressing us wasn't enough!", "Mutant", HSLColor.FromHex("00FF00"))
      Trigger.AfterDelay(DateTime.Seconds(5), function()
        Media.DisplayMessage("Commander, what is this foolishness? The mutants won't help us if you kill them.", "Cabal", HSLColor.FromHex("FF0000"))
      end)
      Trigger.AfterDelay(DateTime.Seconds(10), function() PlayerFailMission() end)
    end
  end
end


-- GDI's AI attack production behavior -----

GDIHunterAttackDelayMin = { easy = DateTime.Seconds(120), normal = DateTime.Seconds(90), hard = DateTime.Seconds(75) }
GDIHunterAttackDelayMax = { easy = DateTime.Seconds(150), normal = DateTime.Seconds(120), hard = DateTime.Seconds(90) }
GDIAttackHunterTypes =
{
  easy =
  {
    { factory = GDIPyle1, types = { "e1", "e1", "e1" } },
  },
  normal =
  {
    { factory = GDIPyle1, types = { "e1", "e1", "e1", "e1" } },
    { factory = GDIPyle1, types = { "e1", "e1", "e1", "e1" } },
    { factory = GDIPyle1, types = { "e2", "e2" } },
  },
  hard =
  {
    { factory = GDIPyle1, types = { "e1", "e1", "e1", "e1", "e1" } },
    { factory = GDIPyle1, types = { "e1", "e1", "e1", "e1", "e1" } },
    { factory = GDIPyle1, types = { "e2", "e2" } },
  }
}

GDIHunterAttackProduction = function()
  local production = Utils.Random(GDIAttackHunterTypes[Difficulty])
  local toBuild = function() return production.types end  

  ProduceUnits(GDI, production.factory, nil, toBuild, function(units)
    UpdatePlayerBaseLocation()
    Utils.Do(units, function(unit) AssaultPlayerBaseOrHunt(unit) end)
  end)

  Trigger.AfterDelay(Utils.RandomInteger(GDIHunterAttackDelayMin[Difficulty], GDIHunterAttackDelayMax[Difficulty]), GDIHunterAttackProduction)
end

BeginGDIHunt = function()
  if GDIHunting == false then
    GDIHunting = true
    GDIHunterAttackProduction()
  end
end


GDIMainBaseAttackDelayMin = { easy = DateTime.Seconds(90), normal = DateTime.Seconds(75), hard = DateTime.Seconds(65) }
GDIMainBaseAttackDelayMax = { easy = DateTime.Seconds(120), normal = DateTime.Seconds(90), hard = DateTime.Seconds(70) }

GDIMainBaseAttackProduction = function()  
  local infantryToBuild = function() return { 'e2', 'e2', 'e2', 'e2', 'e2', 'e3', 'e3', 'e3', 'e3', 'e3' } end
  ProduceUnits(GDI, GDIPyle2, nil, infantryToBuild, function(units)
    UpdatePlayerBaseLocation()
    Utils.Do(units, function(unit) AssaultPlayerBaseOrHunt(unit) end)
  end)
  
  local vehiclesToBuild = function() return { 'jeep', 'jeep', 'jeep' } end
  ProduceUnits(GDI, GDIWeap, nil, vehiclesToBuild, function(units)
    UpdatePlayerBaseLocation()
    Utils.Do(units, function(unit) AssaultPlayerBaseOrHunt(unit) end)
  end)
  
  Trigger.AfterDelay(Utils.RandomInteger(GDIMainBaseAttackDelayMin[Difficulty], GDIMainBaseAttackDelayMax[Difficulty]), GDIMainBaseAttackProduction)
end

AwakenMainBase = function()
  if MainBaseAwake == true then return end
  MainBaseAwake = true
  Utils.Do({MainDef5, MainDef6, MainDef7, MainDef8, MainDef9, MainDef10}, function(responder)
    AssaultPlayerBaseOrHunt(responder)
  end)
  GDIMainBaseAttackProduction()
end

-- End GDI's AI attack production behavior -----

RespawnTrigger = function(a)
	if RespawnEnabled then
		Trigger.OnKilled(a, function(self, killer)
			local name = "Spy"
			Media.DisplayMessage("The " .. name .. " of " .. a.Owner.Name .. " was killed. A new one arrives in 30 seconds.","Cabal",a.Owner.Color)
			Trigger.AfterDelay(DateTime.Seconds(30), function()
				local respawnedActor = Actor.Create(a.Type, true, { Owner = a.Owner, Location = StartCam.Location })
				respawnedActor.Scatter()
				Beacon.New(a.Owner, StartCam.CenterPosition, 125)
				Media.PlaySpeechNotification(a.Owner, "Reinforce")
				RespawnTrigger(respawnedActor)
			end)
		end)
	end
end

WorldLoaded = function()
  GDI = Player.GetPlayer("GDI")
  Nod = Player.GetPlayer("Nod")
  SubGDI = Player.GetPlayer("SubGDI")
  Forgotten = Player.GetPlayer("Forgotten")

  MissionPlayer = Nod
  
	BadGuy = Player.GetPlayer("BadGuy")

	coopInfo =
	{
		Mainplayer = Nod,
		MainEnemies = {GDI,SubGDI},
		Dummyplayer = BadGuy
	}
	
	ORAMod = "tibalt"
	Stopspread = true
	CoopInit25(coopInfo)
	
	RespawnEnabled = Map.LobbyOption("respawn") == "enabled"
	
	local AllSpies = {Actor37}
	Utils.Do(CoopPlayers,function(PID)
		if PID ~= Nod then
			local NewSpy = Actor.Create(Actor37.Type, true, { Owner = PID, Location = Actor37.Location })
			table.insert(AllSpies,NewSpy)
			NewSpy.Scatter()
		end
	end)
	Utils.Do(AllSpies,function(UID)
		RespawnTrigger(UID)
	end)

  Camera.Position = StartCam.CenterPosition
  
  Trigger.AfterDelay(DateTime.Seconds(10), function()
    Stopspread = false
	Media.DisplayMessage("Avoid getting close to infantry or base defenses, or your spy will be detected.", "TIP", HSLColor.FromHex("00FF00"))
  end)
  
  --Remove actors based on difficulty
  Utils.Do(ActorRemovals[Difficulty], function(unit)
    unit.Destroy()
  end)
  
  local AllEngys = Nod.GetActorsByType("e6")
  AssignToCoopPlayers(AllEngys, nil, true)
  
  --Special lighting
  Lighting.Ambient = 0.65
  Lighting.Red = 1.3
  Lighting.Blue = 0.6
  Lighting.Green = 0.6
  
  --Player Reinforcements
  Trigger.OnCapture(Station1, function(self, captor, oldOwner, newOwner)
    if IsOwnedByCoopPlayer(captor) then
      if PlayerKilledMutantInProgress == false then
        Group1Liberated = true
        if not Gate1.IsDead then Gate1.Destroy() end
        LiberateMutants({ Prisoner1, Prisoner2, Prisoner3, Prisoner4, Prisoner5, Prisoner6, Prisoner7 })
        Media.DisplayMessage("Thanks for busting us out! Let's get revenge on those GDI scum!", "Mutants", HSLColor.FromHex("00FF00"))
        Media.PlaySound("Eva-TargetRescued.aud")
        Trigger.AfterDelay(DateTime.Seconds(5), function()
          Media.DisplayMessage("Mutants and Tiberium life forms can heal in Tiberium.", "TIP", HSLColor.FromHex("00FF00"))
        end)
      end
    end
  end)
  
  Trigger.OnCapture(Station2, function(self, captor, oldOwner, newOwner)
    if IsOwnedByCoopPlayer(captor) then
      if PlayerKilledMutantInProgress == false then
        Group2Liberated = true
        if not Gate2.IsDead then Gate2.Destroy() end
        LiberateMutants({ Prisoner8, Prisoner9, Prisoner10, Prisoner11, Prisoner12, Prisoner13, Prisoner14 })
        Media.DisplayMessage("To arms, brothers! GDI will pay!", "Mutants", HSLColor.FromHex("00FF00"))
        Media.PlaySound("Eva-TargetRescued.aud")
      end
    end
  end)
  
  Trigger.OnCapture(Hospital, function(self, captor, oldOwner, newOwner)
    if IsOwnedByCoopPlayer(captor) then
      LiberateMutants( {} )
      local medics = { easy = {'medi', 'medi', 'medi'}, normal = { 'medi', 'medi' }, hard = { 'medi' } }
      Reinforcements.Reinforce(BadGuy, medics[Difficulty], { MediSpawn.Location }, 15, function(medic)
        medic.Move(MediGoto.Location)
      end)
      Media.DisplayMessage("Thanks for the rescue! We'll heal you up.", "Mutants", HSLColor.FromHex("00FF00"))
      Media.PlaySound("Eva-TargetRescued.aud")
    end
  end)
  
  Trigger.OnCapture(Armory, function(self, captor, oldOwner, newOwner)
    if IsOwnedByCoopPlayer(captor) then
      LiberateMutants( {} )
      local e3s = { easy = {'e3', 'e3', 'e3', 'e3', 'e3'}, normal = { 'e3', 'e3', 'e3', 'e3' }, hard = { 'e3', 'e3', 'e3' } }
      Reinforcements.Reinforce(BadGuy, e3s[Difficulty], { E3Spawn.Location }, 15, function(e3)
        e3.Move(E3Goto.Location)
      end)
      Media.DisplayMessage("There's some heavy firepower in this armory. Let's put it to use!", "Mutants", HSLColor.FromHex("00FF00"))
      Media.PlaySound("Eva-TargetRescued.aud")
    end
  end)
  
  Trigger.OnEnteredProximityTrigger(ArtyPark.CenterPosition, WDist.New(2 * 1024), function(a, id)
    if IsOwnedByCoopPlayer(a) then
      LiberateMutants( {} )
      Trigger.RemoveProximityTrigger(id)
      local artyAlive = false
      Utils.Do({ Arty1, Arty2, Arty3, Arty4 }, function(unit)
        if unit ~= nil and not unit.IsDead then
          unit.Owner = BadGuy
          artyAlive = true
        end
      end)
      if artyAlive == true then
        Media.DisplayMessage("These artillery are fully armed! This will bring GDI some pain!", "Mutants", HSLColor.FromHex("00FF00"))
        Media.PlaySound("Eva-TargetRescued.aud")
        Trigger.AfterDelay(DateTime.Seconds(5), function()
          Media.DisplayMessage("Artillery units can outrange all base defenses.", "TIP", HSLColor.FromHex("00FF00"))
        end)
      end
    end
  end)
  
  --Objectives
  InitObjectives(Nod)
  Trigger.AfterDelay(DateTime.Seconds(3), function()
    DefeatGDIObjective = Nod.AddObjective("Destroy the main GDI base.")
    LiberateMutantsObjective = Nod.AddObjective("Liberate all the imprisoned mutants.", "Secondary", false)
  end)
  
  Utils.Do({ Prisoner1, Prisoner2, Prisoner3, Prisoner4, Prisoner5, Prisoner6, Prisoner7 }, function(unit)
    if unit ~= nil then
      Trigger.OnKilled(unit, function(self, killer) PlayerKilledMutant(Group1Liberated, killer) end)
    end
  end)
  
    Utils.Do({ Prisoner8, Prisoner9, Prisoner10, Prisoner11, Prisoner12, Prisoner13, Prisoner14 }, function(unit)
    if unit ~= nil then
      Trigger.OnKilled(unit, function(self, killer) PlayerKilledMutant(Group2Liberated, killer) end)
    end
  end)
  
  --AI player behavior
  GDI.Resources = GDI.ResourceCapacity - 500
  GDI.Cash = 90000
  
  --if Difficulty ~= "easy" then
  --  AutoRepairAndRebuildBuildings(Nod, 15)
  --end
  
  SetupRefAndSilosCaptureCredits(GDI)
  
  Utils.Do(Patrollers, function(unit)
    Trigger.OnKilled(unit, function(self, killer) BeginGDIHunt() end)
  end)
  
  --Enemy Predeployed Maneuvers
  Trigger.AfterDelay(DateTime.Seconds(5), function()
    Utils.Do({ PatrolA1, PatrolA2, PatrolA3, PatrolA4, PatrolA5 }, function(unit)
      if not unit.IsDead then unit.Patrol({ PatrolRouteA1.Location, PatrolRouteA2.Location, PatrolRouteA3.Location, PatrolRouteA4.Location }, true, DateTime.Seconds(8)) end
    end)

    Utils.Do({PatrolA6, PatrolA7, PatrolA8, PatrolA9, PatrolA10}, function(unit)
      if not unit.IsDead then unit.Patrol({PatrolRouteA3.Location, PatrolRouteA4.Location, PatrolRouteA1.Location, PatrolRouteA2.Location}, true, DateTime.Seconds(8)) end
    end)
    
    Utils.Do({PatrolB1, PatrolB2, PatrolB3, PatrolB4, PatrolB5}, function(unit)
      if not unit.IsDead then unit.Patrol({PatrolRouteA4.Location, PatrolRouteA2.Location, PatrolRouteB3.Location, PatrolRouteB4.Location}, true, DateTime.Seconds(8)) end
    end)
    
    Utils.Do({PatrolB6, PatrolB7, PatrolB8, PatrolB9, PatrolB10}, function(unit)
      if not unit.IsDead then unit.Patrol({PatrolRouteB3.Location, PatrolRouteB4.Location, PatrolRouteA4.Location, PatrolRouteA3.Location}, true, DateTime.Seconds(8)) end
    end)
    
    Utils.Do({MTnk1, MTnk2, MTnk3}, function(unit)
      if not unit.IsDead then unit.Patrol({PatrolRouteC1.Location, PatrolRouteC2.Location, PatrolRouteC3.Location, PatrolRouteC4.Location}, true, DateTime.Seconds(8)) end
    end)
  end)
  
  Utils.Do({GDIPyle1, Blockade1, Blockade2, Blockade3, Blockade4, Blockade5, Blockade6, Blockade7, Blockade8, Blockade9}, function(unit)
    Trigger.OnKilled(unit, function(self, killer)
      if Blockade1Awake == false then
        Blockade1Awake = true
        BeginGDIHunt()
        Utils.Do({Blockade7, Blockade8, Blockade9}, function(responder)
          AssaultPlayerBaseOrHunt(responder)
        end)
      end
    end)
  end)
  
  Utils.Do({BlockadeB1, BlockadeB2, BlockadeB3, BlockadeB4, BlockadeB5, BlockadeB6, BlockadeB7 }, function(unit)
    Trigger.OnKilled(unit, function(self, killer)
      if Blockade2Awake == false then
        Blockade2Awake = true
        BeginGDIHunt()
        Utils.Do({BlockadeB5, BlockadeB6, BlockadeB7}, function(responder)
          AssaultPlayerBaseOrHunt(responder)
        end)
      end
    end)
  end)
  
  Utils.Do({GDIPyle2, GDIWeap, GDINuke1, GDINuke2, GDINuke3, MainDef1, MainDef2, MainDef3, MainDef4}, function(unit)
    Trigger.OnKilled(unit, function(self, killer)
      if MainBaseAwake == false then
        AwakenMainBase()
      end
    end)
  end)
  
  Trigger.OnEnteredProximityTrigger(ProxyCam2.CenterPosition, WDist.New(10 * 1024), function(a, id)
    if IsOwnedByCoopPlayer(a) and a.Type ~= "camera" then
      AwakenMainBase()
    end
  end)

  --Proximity Triggers/Reveals
  Trigger.OnEnteredProximityTrigger(ProxyRvl1.CenterPosition, WDist.New(3 * 1024), function(a, id)
    if IsOwnedByCoopPlayer(a) then
      Trigger.RemoveProximityTrigger(id)
      ProxRvl1CamActor = Actor.Create("camera", true, { Owner = Nod, Location = ProxyCam1.Location })
      ProxRvl2CamActor = Actor.Create("camera", true, { Owner = Nod, Location = ProxyCam2.Location })
      Trigger.AfterDelay(DateTime.Seconds(10), function()
        ProxRvl1CamActor.Destroy()
        ProxRvl2CamActor.Destroy()
      end)
    end
  end)
  
  Trigger.OnEnteredProximityTrigger(ProxyRvl2.CenterPosition, WDist.New(7 * 1024), function(a, id)
    if IsOwnedByCoopPlayer(a) then
      Trigger.RemoveProximityTrigger(id)
      ProxRvl1CamActorB = Actor.Create("camera", true, { Owner = Nod, Location = ProxyCam1.Location })
      Trigger.AfterDelay(DateTime.Seconds(10), function()
        ProxRvl1CamActorB.Destroy()
      end)
    end
  end)
  
  Trigger.OnEnteredProximityTrigger(ProxyRvl3.CenterPosition, WDist.New(8 * 1024), function(a, id)
    if IsOwnedByCoopPlayer(a) then
      Trigger.RemoveProximityTrigger(id)
      ProxRvl3CamActor = Actor.Create("camera", true, { Owner = Nod, Location = ProxyRvl3.Location })
      Trigger.AfterDelay(DateTime.Seconds(10), function()
        ProxRvl3CamActor.Destroy()
      end)
    end
  end)
  
    --Crate spawns
  Trigger.OnKilled(Industry, function()
		Actor.Create("moneycrate", true, { Owner = Nod, Location = MoneyCrateSpawn.Location })
	end)

end


Tick = function()
	OncePerSecondChecks()
	OncePerThreeSecondChecks()
end

OncePerSecondChecks = function()
  if DateTime.GameTime > 1 and DateTime.GameTime % 25 == 0 then
    --none
  end
end

OncePerThreeSecondChecks = function()
	if DateTime.GameTime > 1 and DateTime.GameTime % 75 == 0 then
	local ObjCounter = 0
    Utils.Do(CoopPlayers,function(PID)
		if HasOneOf(PID, LossCheckAll) == false then
			ObjCounter = ObjCounter + 1
		end
	end)
	if ObjCounter >= #CoopPlayers then
      PlayerFailMission()
    end
	
	--if HasOneOf(Nod, LossCheckAll) == false then PlayerFailMission() end
    
    if HasOneOf(GDI, LossCheckCritical) == false then
      Nod.MarkCompletedObjective(DefeatGDIObjective)
    end
	end
end


PlayerFailMission = function()
  if DefeatGDIObjective ~= nil and not Nod.IsObjectiveCompleted(DefeatGDIObjective) then
    Nod.MarkFailedObjective(DefeatGDIObjective)
  end
  if LiberateMutantsObjective ~= nil and not Nod.IsObjectiveCompleted(LiberateMutantsObjective) then
    Nod.MarkFailedObjective(LiberateMutantsObjective)
  end
end