
SamSitesDestroyed = 0
AllowPlayerLoss = false

PatrolAlertW = false
PatrolAlertE = false
PatrolAlertS = false

ViceUnleashed = false
BlockadeDestroyed = false
MainBaseAwakened = false


ActorRemovals =
{
  easy = { EZR1, EZR2 },
  normal = { },
  hard = { },
}


BigPatrol = { Patrol1, Patrol2, Patrol3, Patrol4, Patrol5, Patrol6, Patrol7, Patrol8, Patrol9, Patrol10, Patrol11, Patrol12, Patrol13, Patrol14, Patrol15 }
BigPatrolRoute = { PatrolMove1.Location, PatrolMove2.Location, PatrolMove3.Location, PatrolMove4.Location, PatrolMove5.Location, PatrolMove6.Location,
                   PatrolMove7.Location, PatrolMove8.Location, PatrolMove9.Location, PatrolMove10.Location, PatrolMove11.Location }

WallSegments = { Wall1, Wall2, Wall3, Wall4 }
Visceroids = { Vice1, Vice2, Vice3, Vice4, Vice5 }
BlockadeTargets = { BlockadeTurret1, BlockadeTurret2, BlockadeTurret3, BlockadeTurret4, AirstrikeTarget2, AirstrikeTarget3 }


-- Nod's AI attack production behavior -----

NodInfantryAttackDelayMin = { easy = DateTime.Seconds(80), normal = DateTime.Seconds(60), hard = DateTime.Seconds(45) }
NodInfantryAttackDelayMax = { easy = DateTime.Seconds(100), normal = DateTime.Seconds(90), hard = DateTime.Seconds(60) }
NodAttackInfantryTypes = {
  easy =
  {
    { factory = 'hand', types = { "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1" } },
    { factory = 'hand', types = { "e1", "e1", "e1", "e1", "e3", "e3", "e3" } },
    { factory = 'hand', types = { "e3", "e3", "e3", "e3", "e3", "e3" } },
  },
  normal =
  {
    { factory = 'hand', types = { "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1" } },
    { factory = 'hand', types = { "e1", "e1", "e1", "e1", "e3", "e3", "e3", "e3" } },
    { factory = 'hand', types = { "e3", "e3", "e3", "e3", "e3", "e3", "e3" } },
  },
  hard =
  {
    { factory = 'hand', types = { "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1" } },
    { factory = 'hand', types = { "e1", "e1", "e1", "e1", "e1", "e3", "e3", "e3", "e3", "e3" } },
    { factory = 'hand', types = { "e3", "e3", "e3", "e3", "e3", "e3", "e3" } },
  }
}

NodVehicleAttackDelayMin = { easy = DateTime.Seconds(80), normal = DateTime.Seconds(60), hard = DateTime.Seconds(45) }
NodVehicleAttackDelayMax = { easy = DateTime.Seconds(100), normal = DateTime.Seconds(90), hard = DateTime.Seconds(60) }
NodAttackVehicleTypes = {
  easy =
  {
    { factory = 'afld', types = { "bggy", "bggy", "bggy" } },
    { factory = 'afld', types = { "bike", "bike" } },
    { factory = 'afld', types = { "ltnk" } },
  },
  normal =
  {
    { factory = 'afld', types = { "bggy", "bggy", "bggy", "bggy" } },
    { factory = 'afld', types = { "bike", "bike", "bike" } },
    { factory = 'afld', types = { "ltnk", "ltnk" } },
  },
  hard =
  {
    { factory = 'afld', types = { "bggy", "bggy", "bggy", "bggy", "bggy" } },
    { factory = 'afld', types = { "bike", "bike", "bike", "bike" } },
    { factory = 'afld', types = { "ltnk", "ltnk", "ltnk" } },
  }
}

NodVehicleAttackProduction = function()
  local production = Utils.Random(NodAttackVehicleTypes[Difficulty])
  local toBuild = function() return production.types end
  local factory = GetAvailableFactory(Nod, production.factory)

  if factory ~= nil then
    ProduceUnits(Nod, factory, nil, toBuild, function(units)
      UpdatePlayerBaseLocation()
      Utils.Do(units, function(unit)
        if unit.Type ~= 'harv' then
          unit.AttackMove(NodVehicleStaging.Location)
          AssaultPlayerBaseOrHunt(unit)
        end
      end)
      Trigger.AfterDelay(Utils.RandomInteger(NodVehicleAttackDelayMin[Difficulty], NodVehicleAttackDelayMax[Difficulty]), NodVehicleAttackProduction)
    end)
  else
    Trigger.AfterDelay(Utils.RandomInteger(NodVehicleAttackDelayMin[Difficulty], NodVehicleAttackDelayMax[Difficulty]), NodVehicleAttackProduction)
  end
end

NodInfantryAttackProduction = function()
  local production = Utils.Random(NodAttackInfantryTypes[Difficulty])
  local toBuild = function() return production.types end
  local factory = GetAvailableFactory(Nod, production.factory)

  if factory ~= nil then
    ProduceUnits(Nod, factory, nil, toBuild, function(units)
      UpdatePlayerBaseLocation()
      Utils.Do(units, function(unit)
        if unit.Type ~= 'harv' then AssaultPlayerBaseOrHunt(unit) end
      end)
    end)
    Trigger.AfterDelay(Utils.RandomInteger(NodInfantryAttackDelayMin[Difficulty], NodInfantryAttackDelayMax[Difficulty]), NodInfantryAttackProduction)
  else
    Trigger.AfterDelay(Utils.RandomInteger(NodInfantryAttackDelayMin[Difficulty], NodInfantryAttackDelayMax[Difficulty]), NodInfantryAttackProduction)
  end
end

NodAttackProduction = function()
  if MainBaseAwakened == false then
    MainBaseAwakened = true
    NodVehicleAttackProduction()
    NodInfantryAttackProduction()
    local newBuilding = Actor.Create('proc', true, { Owner = Nod, Location = NodProcSpawn.Location })
    AutoRebuildBuilding(newBuilding, Nod)
    AutoReplaceHarvesters(Nod)
  end
end

MainNodBaseCountering = false

MainNodBaseLaunchCounter = function()
  if MainNodBaseCountering == true then return end
  MainNodeBaseCountering = true

  local attackers = Map.ActorsInBox(NodBaseNW.CenterPosition, NodBaseSE.CenterPosition, function(a)
    return a.Owner == Nod and (a.Type == "e4" or a.Type == "bggy")
  end)

  Utils.Do(attackers, function(unit)
    AssaultPlayerBaseOrHunt(unit)
  end)
  
  NodAttackProduction()
end

-- End Nod's AI attack production behavior -----


-- Blockade's AI attack production behavior -----

BlockadeCountering = false

BlockadeCounterInfantry = { 'e1', 'e1', 'e1', 'e1', 'e1', 'e1', 'e1', 'e1', 'e1', 'e1' }
BlockadeCounterVehicles = { 'bggy', 'bggy', 'bggy', 'bggy', 'bggy' }

BlockadeCounterProduction = function(production, units)
  local toBuild = function() return units end

  ProduceUnits(SubNod, production, nil, toBuild, function(units)
    UpdatePlayerBaseLocation()
    Utils.Do(units, function(unit) AssaultPlayerBaseOrHunt(unit) end)
  end)
end

BlockadeLaunchCounter = function()
  if BlockadeCountering == true then return end
  BlockadeCountering = true

  local attackers = Map.ActorsInBox(BlockadeNW.CenterPosition, BlockadeSE.CenterPosition, function(a)
    return a.Owner == SubNod and (a.Type == "e4" or a.Type == "bggy")
  end)

  Utils.Do(attackers, function(unit)
    AssaultPlayerBaseOrHunt(unit)
  end)
  
  BlockadeCounterProduction(BlockadeHand, BlockadeCounterInfantry)
  BlockadeCounterProduction(BlockadeAfld, BlockadeCounterVehicles)
end

-- End Blockade's AI attack production behavior -----


-- EOutpost's AI attack production behavior -----

EOutpostCountering = false

EOutpostCounterInfantry = { 'e1', 'e1', 'e1', 'e1', 'e1', 'e1', 'e1', 'e1', 'e1', 'e1', 'e1', 'e1', 'e1', 'e1', 'e1' }

EOutpostCounterProduction = function(production, units)
  local toBuild = function() return units end

  ProduceUnits(SubNod, production, nil, toBuild, function(units)
    UpdatePlayerBaseLocation()
    Utils.Do(units, function(unit) AssaultPlayerBaseOrHunt(unit) end)
  end)
end

EOutpostLaunchCounter = function()
  if EOutpostCountering == true then return end
  EOutpostCountering = true

  local attackers = Map.ActorsInBox(EOutpostNW.CenterPosition, EOutpostSE.CenterPosition, function(a)
    return a.Owner == SubNod and (a.Type == "e4" or a.Type == "bggy")
  end)

  Utils.Do(attackers, function(unit)
    AssaultPlayerBaseOrHunt(unit)
  end)
  
  EOutpostCounterProduction(EOutpostHand, EOutpostCounterInfantry)
end

-- End EOutpost's AI attack production behavior -----


-- WOutpost Counterattack -----

WOutpostCountering = false

WOutpostLaunchCounter = function()
  if WOutpostCountering == true then return end
  WOutpostCountering = true

  local attackers = Map.ActorsInBox(WOutpostNW.CenterPosition, WOutpostSE.CenterPosition, function(a)
    return a.Owner == SubNod and (a.Type == "e4" or a.Type == "bggy")
  end)

  Utils.Do(attackers, function(unit)
    AssaultPlayerBaseOrHunt(unit)
  end)
end

-- End WOutpost Counterattack -----



AirstrikeAttacks = function()
  if BlockadeDestroyed == false then
    Media.DisplayMessage("Great work, Commander!\nMe and my birds will clear a path for you.", "Morelli", HSLColor.FromHex("857833"))
    Trigger.AfterDelay(DateTime.Seconds(3), function()
      Camera.Position = BlockadeCam.CenterPosition
      Reinforcements.Reinforce(GoodGuy, { "a10scrip" }, { AirstrikeSpawn1.Location }, 15, function(unit)
        unit.Attack(AirstrikeTarget1)
      end)
      Reinforcements.Reinforce(GoodGuy, { "a10scrip" }, { AirstrikeSpawn2.Location }, 15, function(unit)
        unit.Attack(AirstrikeTarget2)
      end)
      Reinforcements.Reinforce(GoodGuy, { "a10scrip" }, { AirstrikeSpawn3.Location }, 15, function(unit)
        unit.Attack(AirstrikeTarget3)
      end)
    end)
  end
end


SamSiteDestroyed = function()
  SamSitesDestroyed = SamSitesDestroyed + 1
  local remainingSams = 7 - SamSitesDestroyed
  Media.DisplayMessage("SAM site destroyed! " .. remainingSams .. " remaining.", "NOTICE", HSLColor.Green)
  CheckDestroyedSams()
end


BlockadeIsCleared = function()
  if BlockadeDestroyed == false then
    BlockadeDestroyed = true
    
    Trigger.AfterDelay(DateTime.Seconds(5), function()
      Media.PlaySpeechNotification(All, "Reinforce")
      if Difficulty ~= "hard" then
        Reinforcements.Reinforce(GoodGuy, { "mtnk", "mtnk", "jeep", "jeep" }, { PlayerReinSpawn.Location }, 25, function(unit)
          unit.Move(BlockadeCam.Location)
        end)
      else
        Reinforcements.Reinforce(GoodGuy, { "mtnk", "jeep" }, { PlayerReinSpawn.Location }, 25, function(unit)
          unit.Move(BlockadeCam.Location)
        end)
      end
    end)
    
    Trigger.AfterDelay(DateTime.Seconds(10), function()
      Media.PlaySpeechNotification(All, "Reinforce")
	  Utils.Do(MCVPlayers,function(PID)
		Reinforcements.Reinforce(PID, { "mcv" }, { PlayerReinSpawn.Location }, 15, function(unit)
			unit.Move(BlockadeCam.Location)
		end)
	  end)
      
      NodAttackProduction()
    end)
  end
end


InitiateBigPatrol = function()
  Media.DisplayMessage("Be careful! There's a big Nod squad patrolling this area.\nWe can keep you informed of its movements.", "Civilian", HSLColor.FromHex("857833"))

  Utils.Do(BigPatrol, function(unit)
    if not unit.IsDead then unit.Patrol(BigPatrolRoute, true, DateTime.Seconds(5)) end
  end)

  PatrolCam1 = Actor.Create("camera.small", true, { Owner = GDI, Location = CivS.Location })
  PatrolCam2 = Actor.Create("camera.small", true, { Owner = GDI, Location = CivNW.Location })
  PatrolCam3 = Actor.Create("camera.small", true, { Owner = GDI, Location = CivNE.Location })
end



WorldLoaded = function()
  GDI = Player.GetPlayer("GDI")
  Nod = Player.GetPlayer("Nod")
  SubNod = Player.GetPlayer("SubNod")
  TibLife = Player.GetPlayer("TibLife")

	GoodGuy = Player.GetPlayer("GoodGuy")

	coopInfo =
	{
		Mainplayer = GDI,
		MainEnemies = {Nod,SubNod},
		Dummyplayer = GoodGuy
	}
	
	ORAMod = "tibalt"
	CoopInit25(coopInfo)

  MissionPlayer = GDI

  Camera.Position = StartCam.CenterPosition
  
  --Remove actors based on difficulty
  Utils.Do(ActorRemovals[Difficulty], function(unit)
    unit.Destroy()
  end)
  
  --Player Reinforcements
  Trigger.AfterDelay(DateTime.Seconds(2), function()
    Media.PlaySpeechNotification(All, "Reinforce")
    if Difficulty ~= 'hard' then
        Reinforcements.ReinforceWithTransport(GoodGuy, "tran.insertion", { "e1", "e1", "e1", "e1", "e1" }, { GDIDropSpawn.Location, GDIDropW.Location }, { GDIDropSpawn.Location })
        Reinforcements.ReinforceWithTransport(GoodGuy, "tran.insertion", { "e2", "e2", "e2", "e2", "medi" }, { GDIDropSpawn.Location, StartCam.Location }, { GDIDropSpawn.Location })
        Reinforcements.ReinforceWithTransport(GoodGuy, "tran.insertion", { "e3", "e3", "e3", "e3", "medi" }, { GDIDropSpawn.Location, GDIDropE.Location }, { GDIDropSpawn.Location })
    else
        Reinforcements.ReinforceWithTransport(GoodGuy, "tran.insertion", { "e1", "e1", "e1", "e1", "e1" }, { GDIDropSpawn.Location, GDIDropW.Location }, { GDIDropSpawn.Location })
        Reinforcements.ReinforceWithTransport(GoodGuy, "tran.insertion", { "e2", "e2", "e2", "e2", "medi" }, { GDIDropSpawn.Location, StartCam.Location }, { GDIDropSpawn.Location })
        Reinforcements.ReinforceWithTransport(GoodGuy, "tran.insertion", { "e3", "e3", "e3", "e3" }, { GDIDropSpawn.Location, GDIDropE.Location }, { GDIDropSpawn.Location })
    end
  end)
  
  if Difficulty == 'easy' then
    Trigger.AfterDelay(DateTime.Seconds(12), function()
      Media.PlaySpeechNotification(All, "Reinforce")
      Reinforcements.ReinforceWithTransport(GoodGuy, "tran.insertion", { "e1", "e1", "e1" }, { GDIDropSpawn.Location, GDIDropW.Location }, { GDIDropSpawn.Location })
      Reinforcements.ReinforceWithTransport(GoodGuy, "tran.insertion", { "e2", "e2", "e3", "e3" }, { GDIDropSpawn.Location, GDIDropE.Location }, { GDIDropSpawn.Location })
    end)
  end
  
  Trigger.OnAllKilled(BlockadeTargets, function() BlockadeIsCleared() end)
  
  --Objectives
  InitObjectives(GDI)
  Trigger.AfterDelay(DateTime.Seconds(5), function()
    DestroySamsObjective = GDI.AddObjective("Destroy all SAM sites.")
    DefeatNodObjective = GDI.AddObjective("Destroy the main Nod base.")
  end)
  
  UserInterface.SetMissionText(SamSitesDestroyed .. " of 7 SAM sites destroyed.", HSLColor.Yellow)
  
  local civvies = { CivS, CivNW, CivNE, Civvie1, Civvie2, Civvie3, CivB1, CivB2, CivB3, CivB4, CivB5, CivB6, CivB7, CivB8 }
  Utils.Do(civvies, function(civ)
    Trigger.OnKilled(civ, function(self, killer)
      if IsOwnedByCoopPlayer(killer) then
        Media.DisplayMessage("Why would you kill our civilian sympathizers?!", "Morelli", HSLColor.FromHex("857833"))
        Trigger.AfterDelay(DateTime.Seconds(3), function() PlayerFailMission() end)
      end
    end)
  end)
  
  Trigger.AfterDelay(DateTime.Seconds(15), function() AllowPlayerLoss = true end)
  
  Trigger.OnKilled(SAM1, function(sam, killer)
    SamSiteDestroyed()
    EOutpostLaunchCounter()
  end)
  
  Trigger.OnKilled(SAM2, function(sam, killer) SamSiteDestroyed() end)
  Trigger.OnKilled(SAM3, function(sam, killer) SamSiteDestroyed() end)
  Trigger.OnKilled(SAM4, function(sam, killer) SamSiteDestroyed() end)
  Trigger.OnKilled(SAM5, function(sam, killer) SamSiteDestroyed() end)
  Trigger.OnKilled(SAM6, function(sam, killer) SamSiteDestroyed() end)
  Trigger.OnKilled(SAM7, function(sam, killer) SamSiteDestroyed() end)
  
  --AI player behavior
  Nod.Resources = Nod.ResourceCapacity - 500
  Nod.Cash = 90000
  SubNod.Resources = SubNod.ResourceCapacity - 500
  SubNod.Cash = 50000
  
  if Difficulty ~= "easy" then
    AutoRepairAndRebuildBuildings(Nod, 15)
  end
  
  SetupRefAndSilosCaptureCredits(Nod)
  SetupRefAndSilosCaptureCredits(SubNod)
  
  --Enemy Predeployed Attacks
  ViceCameraCreated = false
  Utils.Do(WallSegments, function(wall)
    Trigger.OnKilled(wall, function()
      if ViceUnleashed == false then
        ViceUnleashed = true
        Trigger.AfterDelay(DateTime.Seconds(2), function()
          Utils.Do(Visceroids, function(vice)
            if not vice.IsDead then
              vice.Move(ViceMove1.Location)
              vice.CallFunc(function()
                if ViceCameraCreated == false then
                  ViceCameraCreated = true
                  ProxRvl3CamActorB = Actor.Create("camera", true, { Owner = GDI, Location = ProxRvl3Cam.Location })
                  Trigger.AfterDelay(DateTime.Seconds(120), function()
                    ProxRvl3CamActorB.Destroy()
                  end)
                end
              end)
              vice.AttackMove(ViceMove2.Location)
              vice.AttackMove(ViceMove3.Location)
            end
          end)
        end)
      end
    end)
  end)
  
  Trigger.OnEnteredProximityTrigger(BlockadeTrigRsp.CenterPosition, WDist.New(4 * 1024), function(a, id)
    if IsOwnedByCoopPlayer(a) then
      Trigger.RemoveProximityTrigger(id)
      BlockadeLaunchCounter()
    end
  end)
  
  Trigger.OnKilled(BlockadePbox1, function() BlockadeLaunchCounter() end)
  Trigger.OnKilled(BlockadePbox2, function() BlockadeLaunchCounter() end)
  
  Trigger.OnEnteredProximityTrigger(ProxRvl3Cam.CenterPosition, WDist.New(6 * 1024), function(a, id)
    if IsOwnedByCoopPlayer(a) and a.Type ~= "camera" and a.Type ~= "camera.small" then
      Trigger.RemoveProximityTrigger(id)
      EOutpostLaunchCounter()
    end
  end)
  
  Trigger.OnKilled(EOutpostD1, function() EOutpostLaunchCounter() end)
  Trigger.OnKilled(EOutpostD2, function() EOutpostLaunchCounter() end)
  Trigger.OnKilled(EOutpostD3, function() EOutpostLaunchCounter() end)
  
  Trigger.OnEnteredProximityTrigger(ProxRvl1Cam.CenterPosition, WDist.New(6 * 1024), function(a, id)
    if IsOwnedByCoopPlayer(a) and a.Type ~= "camera" and a.Type ~= "camera.small" then
      Trigger.RemoveProximityTrigger(id)
      WOutpostLaunchCounter()
    end
  end)
  
  Trigger.OnKilled(WOutpostD1, function() WOutpostLaunchCounter() end)
  Trigger.OnKilled(WOutpostD2, function() WOutpostLaunchCounter() end)
  Trigger.OnKilled(WOutpostD3, function() WOutpostLaunchCounter() end)
  Trigger.OnKilled(WOutpostD4, function() WOutpostLaunchCounter() end)
  
  Trigger.OnEnteredProximityTrigger(NodBaseTrigRsp.CenterPosition, WDist.New(10 * 1024), function(a, id)
    if IsOwnedByCoopPlayer(a) and a.Type ~= "camera" and a.Type ~= "camera.small" then
      Trigger.RemoveProximityTrigger(id)
      MainNodBaseLaunchCounter()
    end
  end)
  
  local nodAwakenTargets = { NodBaseDef1, NodBaseDef2, NodBaseDef3, NodBaseDef4, NodBaseDef5, NodBaseDef6, NodBaseDef7, NodBaseDef8, NodBaseDef9, NodHand, NodAfld, NodFact }
  Utils.Do(nodAwakenTargets, function(target)
    Trigger.OnKilled(target, function() MainNodBaseLaunchCounter() end)
  end)
  
  --Proximity Triggers/Reveals
  Trigger.AfterDelay(DateTime.Seconds(300), function() LZFlare.Destroy() end)
  
  BlockadeCamActor = Actor.Create("camera", true, { Owner = GDI, Location = BlockadeCam.Location })
  
  Trigger.OnEnteredProximityTrigger(CivS.CenterPosition, WDist.New(4 * 1024), function(a, id)
    if IsOwnedByCoopPlayer(a) then
      Trigger.RemoveProximityTrigger(id)
      InitiateBigPatrol()
    end
  end)
  
  Trigger.OnEnteredProximityTrigger(PatrolMove2.CenterPosition, WDist.New(2 * 1024), function(a, id)
    if PatrolAlertS == false and BlockadeDestroyed == false then
      if a.Owner == Nod then
        PatrolAlertS = true
        Media.DisplayMessage("Nod forces spotted in the south!", "Civilian", HSLColor.FromHex("857833"))
        Trigger.AfterDelay(DateTime.Seconds(45), function() PatrolAlertS = false end)
      end
    end
  end)

  Trigger.OnEnteredProximityTrigger(PatrolMove6.CenterPosition, WDist.New(2 * 1024), function(a, id)
    if PatrolAlertE == false and BlockadeDestroyed == false then
      if a.Owner == Nod then
        PatrolAlertE = true
        Media.DisplayMessage("Nod forces spotted in the east!", "Civilian", HSLColor.FromHex("857833"))
        Trigger.AfterDelay(DateTime.Seconds(45), function() PatrolAlertE = false end)
      end
    end
  end)
  
  Trigger.OnEnteredProximityTrigger(PatrolMove10.CenterPosition, WDist.New(2 * 1024), function(a, id)
    if PatrolAlertW == false and BlockadeDestroyed == false then
      if a.Owner == Nod then
        PatrolAlertW = true
        Media.DisplayMessage("Nod forces spotted in the west!", "Civilian", HSLColor.FromHex("857833"))
        Trigger.AfterDelay(DateTime.Seconds(45), function() PatrolAlertW = false end)
      end
    end
  end)
  
  Trigger.OnEnteredProximityTrigger(ProxRvl1A.CenterPosition, WDist.New(3 * 1024), function(a, id)
    if IsOwnedByCoopPlayer(a) then CreateProximityCam1(id) end
  end)
  
  Trigger.OnEnteredProximityTrigger(ProxRvl1B.CenterPosition, WDist.New(6 * 1024), function(a, id)
    if IsOwnedByCoopPlayer(a) then CreateProximityCam1(id) end
  end)
  
  Trigger.OnEnteredProximityTrigger(ProxRvl1C.CenterPosition, WDist.New(3 * 1024), function(a, id)
    if IsOwnedByCoopPlayer(a) then CreateProximityCam1(id) end
  end)
  
  Trigger.OnEnteredProximityTrigger(ProxRvl1D.CenterPosition, WDist.New(2 * 1024), function(a, id)
    if IsOwnedByCoopPlayer(a) then CreateProximityCam1(id) end
  end)
  
  Trigger.OnEnteredProximityTrigger(ProxRvl2.CenterPosition, WDist.New(4 * 1024), function(a, id)
    if IsOwnedByCoopPlayer(a) then
      Trigger.RemoveProximityTrigger(id)
      ProxRvl2CamAActor = Actor.Create("camera.small", true, { Owner = GDI, Location = ProxRvl2CamA.Location })
      Trigger.AfterDelay(DateTime.Seconds(10), function()
        ProxRvl2CamAActor.Destroy()
      end)
      
      ProxRvl2CamBActor = Actor.Create("camera.small", true, { Owner = GDI, Location = ProxRvl2CamB.Location })
      Trigger.AfterDelay(DateTime.Seconds(10), function()
        ProxRvl2CamBActor.Destroy()
      end)
    end
  end)
  
  Trigger.OnEnteredProximityTrigger(ProxRvl3A.CenterPosition, WDist.New(5 * 1024), function(a, id)
    if IsOwnedByCoopPlayer(a) then CreateProximityCam3(id) end
  end)
  
  Trigger.OnEnteredProximityTrigger(ProxRvl3B.CenterPosition, WDist.New(5 * 1024), function(a, id)
    if IsOwnedByCoopPlayer(a) then CreateProximityCam3(id) end
  end)
  
  Trigger.OnEnteredProximityTrigger(ProxRvl4.CenterPosition, WDist.New(13 * 1024), function(a, id)
    if IsOwnedByCoopPlayer(a) then
      Trigger.RemoveProximityTrigger(id)
      ProxRvl4CamActor = Actor.Create("camera.small", true, { Owner = GDI, Location = ProxRvl4.Location })
      Trigger.AfterDelay(DateTime.Seconds(10), function()
        ProxRvl4CamActor.Destroy()
      end)
    end
  end)
  
  Trigger.OnEnteredProximityTrigger(ViceRvl.CenterPosition, WDist.New(10 * 1024), function(a, id)
    if IsOwnedByCoopPlayer(a) then
      Trigger.RemoveProximityTrigger(id)
      ViceRvlCamActor = Actor.Create("camera.small", true, { Owner = GDI, Location = ViceRvl.Location })
      Trigger.AfterDelay(DateTime.Seconds(10), function()
        ViceRvlCamActor.Destroy()
      end)
      
      if Difficulty == "easy" then
        Media.DisplayMessage("Those critters don't look too friendly...\nI wonder why Nod's got them penned up like that?", "GDI Soldier", HSLColor.FromHex("857833"))
      else
        Media.DisplayMessage("Those critters don't look too friendly...", "GDI Soldier", HSLColor.FromHex("857833"))
      end
    end
  end)
  
  --Crate spawns
  Trigger.OnKilled(BioLab, function()
		Actor.Create("moneycrate", true, { Owner = GDI, Location = CrateSpawn.Location })
	end)
  
  --TESTING
  --Trigger.AfterDelay(DateTime.Seconds(12), function()
  --  AirstrikeAttacks()
  --end)

end


ProximityCam1Created = false
ProximityCam3Created = false

CreateProximityCam1 = function(id)
  Trigger.RemoveProximityTrigger(id)
  if ProximityCam1Created == false then
    ProximityCam1Created = true
    ProxRvl1CamActor = Actor.Create("camera.small", true, { Owner = GDI, Location = ProxRvl1Cam.Location })
    Trigger.AfterDelay(DateTime.Seconds(10), function()
      ProxRvl1CamActor.Destroy()
    end)
  end
end


CreateProximityCam3 = function(id)
  Trigger.RemoveProximityTrigger(id)
  if ProximityCam3Created == false then
    ProximityCam3Created = true
    ProxRvl3CamActor = Actor.Create("camera", true, { Owner = GDI, Location = ProxRvl3Cam.Location })
    Trigger.AfterDelay(DateTime.Seconds(10), function()
      ProxRvl3CamActor.Destroy()
    end)
  end
end


Tick = function()
	OncePerSecondChecks()
	OncePerThreeSecondChecks()
end

OncePerSecondChecks = function()
  if DateTime.GameTime > 1 and DateTime.GameTime % 25 == 0 then
    --none
  end
end

OncePerThreeSecondChecks = function()
	if DateTime.GameTime > 1 and DateTime.GameTime % 75 == 0 then
    	
	local ObjCounter = 0
	Utils.Do(CoopPlayers,function(PID)
		if HasOneOf(PID, LossCheckAll) == false then
			ObjCounter = ObjCounter + 1
		end
	end)
	if ObjCounter >= #CoopPlayers then
      PlayerFailMission()
    end
	
    if HasOneOf(Nod, LossCheckCritical) == false then
      GDI.MarkCompletedObjective(DefeatNodObjective)
    end
    
    --manipulate AI funds
    ManipulatePlayerFunds(Nod)
	end
end


CheckDestroyedSams = function()
	if SamSitesDestroyed == 7 then
    GDI.MarkCompletedObjective(DestroySamsObjective)
		UserInterface.SetMissionText("", HSLColor.Lime)
    AirstrikeAttacks()
    Trigger.AfterDelay(DateTime.Seconds(300), function()
      Actor.Create("airstrike.proxy", true, { Owner = GDI })
      Media.DisplayMessage("Rearmed and ready for another airstrike, Commander!", "Morelli", HSLColor.FromHex("857833"))
    end)
	else
		UserInterface.SetMissionText(SamSitesDestroyed .. " of 7 SAM sites destroyed.", HSLColor.Yellow)
	end
end


PlayerFailMission = function()
  if DefeatNodObjective ~= nil and not GDI.IsObjectiveCompleted(DefeatNodObjective) then
    GDI.MarkFailedObjective(DefeatNodObjective)
  end
  if DestroySamsObjective ~= nil and not GDI.IsObjectiveCompleted(DestroySamsObjective) then
    GDI.MarkFailedObjective(DestroySamsObjective)
  end
end