
ActorRemovals =
{
  easy = { EZR1, EZR2, EZR3, EZR4, EZR5, EZR6, EZR7, EZR8, EZR9, Tank1, Tank2, Vice1, Vice2 },
  normal = { Vice1, EZR4, EZR5, EZR6, EZR7 },
  hard = { },
}

SAMPlaced = false
CounterTriggered = false
SouthCounterTriggers = { GtwrS1, GtwrS2, GtwrS3, GtwrS4, GuardSW1, GuardSW2, GuardSE1, GuardSE2 }
NorthCounterTriggers = { GuardN1, GtwrW1, GtwrW2 }

CounterUnits = {
  Counter1, Counter2, Counter3, Counter4, Counter5, Counter6, Counter7, Counter8, Counter9, Counter10,
  Counter11, Counter12, Counter13, Counter14, Counter15, Counter16, Counter17, Counter18, Counter19, Counter20,
  Counter21, Counter22, Counter23, Counter24, Counter25, Counter26, Counter27, Counter28, Counter29, Counter30,
  Counter31, Counter32, Counter33, Counter34, Counter35, Counter36, Counter37, Counter38, Counter39, Counter40
}

-- GDI's AI attack production behavior -----

GDIAttackDelayMin = { easy = DateTime.Seconds(90), normal = DateTime.Seconds(60), hard = DateTime.Seconds(45) }
GDIAttackDelayMax = { easy = DateTime.Seconds(120), normal = DateTime.Seconds(90), hard = DateTime.Seconds(60) }
GDIAttackUnitTypes =
{
  easy =
  {
    { factory = 'pyle', types = { "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1" } },
    { factory = 'pyle', types = { "e2", "e2", "e2", "e2", "e2", "e2" } },
    { factory = 'weap', types = { "jeep", "jeep" } },
  },
  normal =
  {
    { factory = 'pyle', types = { "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1" } },
    { factory = 'pyle', types = { "e2", "e2", "e2", "e2", "e2", "e2", "e2", "e2" } },
    { factory = 'weap', types = { "jeep", "jeep", "jeep" } },
  },
  hard =
  {
    { factory = 'pyle', types = { "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1" } },
    { factory = 'pyle', types = { "e2", "e2", "e2", "e2", "e2", "e2", "e2", "e2", "e2", "e2" } },
    { factory = 'weap', types = { "jeep", "jeep", "jeep", "jeep" } },
  }
}

GDIAttackPaths =
{
  { GDIAtkA.Location },
  { GDIAtkB.Location },
}

GDIAttackProduction = function()
  local production = Utils.Random(GDIAttackUnitTypes[Difficulty])
  local path = Utils.Random(GDIAttackPaths)
  local toBuild = function() return production.types end
  local factory = GetAvailableFactory(GDI, production.factory)

  if factory ~= nil then
    ProduceUnits(GDI, factory, nil, toBuild, function(units)
      UpdatePlayerBaseLocation()
      Utils.Do(units, function(unit)
        ErrorGuardAttackPatrol(unit, path)
        AssaultPlayerBaseOrHunt(unit)
      end)
      Trigger.AfterDelay(Utils.RandomInteger(GDIAttackDelayMin[Difficulty], GDIAttackDelayMax[Difficulty]), GDIAttackProduction)
    end)
  else
    Trigger.AfterDelay(Utils.RandomInteger(GDIAttackDelayMin[Difficulty], GDIAttackDelayMax[Difficulty]), GDIAttackProduction)
  end
end

-- End GDI's AI attack production behavior -----


-- SubGDI's AI attack production behavior -----

SubGDIAttackDelayMin = { easy = DateTime.Seconds(90), normal = DateTime.Seconds(60), hard = DateTime.Seconds(45) }
SubGDIAttackDelayMax = { easy = DateTime.Seconds(120), normal = DateTime.Seconds(90), hard = DateTime.Seconds(60) }
SubGDIAttackUnitTypes =
{
  easy =
  {
    { factory = 'pyle', types = { "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1" } },
    { factory = 'pyle', types = { "e2", "e2", "e2", "e2", "e2", "e2", "e2", "e2" } },
  },
  normal =
  {
    { factory = 'pyle', types = { "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1" } },
    { factory = 'pyle', types = { "e2", "e2", "e2", "e2", "e2", "e2", "e2", "e2" } },
  },
  hard =
  {
    { factory = 'pyle', types = { "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1" } },
    { factory = 'pyle', types = { "e2", "e2", "e2", "e2", "e2", "e2", "e2", "e2", "e2", "e2" } },
  }
}

SubGDIAttackPaths =
{
  { SubGDIAtkA.Location },
  { SubGDIAtkB.Location },
}

SubGDIAttackProduction = function()
  local production = Utils.Random(SubGDIAttackUnitTypes[Difficulty])
  local path = Utils.Random(SubGDIAttackPaths)
  local toBuild = function() return production.types end
  local factory = GetAvailableFactory(SubGDI, production.factory)

  if factory ~= nil then
    ProduceUnits(SubGDI, factory, nil, toBuild, function(units)
      UpdatePlayerBaseLocation()
      Utils.Do(units, function(unit)
        ErrorGuardAttackPatrol(unit, path)
        AssaultPlayerBaseOrHunt(unit)
      end)
      Trigger.AfterDelay(Utils.RandomInteger(SubGDIAttackDelayMin[Difficulty], SubGDIAttackDelayMax[Difficulty]), SubGDIAttackProduction)
    end)
  else
    Trigger.AfterDelay(Utils.RandomInteger(SubGDIAttackDelayMin[Difficulty], SubGDIAttackDelayMax[Difficulty]), SubGDIAttackProduction)
  end
end

-- End SubGDI's AI attack production behavior -----


-- Seth's AI attack production behavior -----

SethInitialInfantry = { 'e1', 'e1', 'e1', 'e1', 'e1', 'e1', 'e1', 'e1', 'e1', 'e1', 'e1', 'e1', 'e1', 'e1', 'e1', 'e3', 'e3', 'e3', 'e3', 'e3', 'e3', 'e3', 'e3' }
SethInitialVehicles = { 'bggy', 'bggy', 'bggy', 'bike', 'bike', 'bike' }

SethInitialProduction = function(production, units, attackWhenDone)
  local toBuild = function() return units end

  ProduceUnits(Seth, production, nil, toBuild, function(units)
    if attackWhenDone == true then SethLaunchAttack() end
  end)
end

SethLaunchAttack = function()
  SethAttacking = true
  Media.DisplayMessage("I'm launching my attack.\nHit them from the front while I attack from behind!", "Seth", HSLColor.FromHex("FE1100"))
  local attackers = Seth.GetGroundAttackers()
  Utils.Do(attackers, function(unit)
    unit.AttackMove(SethAtk1.Location)
    unit.AttackMove(SethAtk2.Location)
    unit.Hunt()
  end)
  Trigger.AfterDelay(DateTime.Seconds(10), function() SethAttackProduction() end)
end

SethAttackDelayMin = { easy = DateTime.Seconds(60), normal = DateTime.Seconds(60), hard = DateTime.Seconds(60) }
SethAttackDelayMax = { easy = DateTime.Seconds(75), normal = DateTime.Seconds(75), hard = DateTime.Seconds(75) }
SethAttackUnitTypes =
{
  easy =
  {
    { factory = 'hand', types = { "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e3", "e3", "e3" } },
    { factory = 'afld', types = { "bggy", "bggy", "bggy", "bike", "bike" } }
  },
  normal =
  {
    { factory = 'hand', types = { "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e3", "e3", "e3" } },
    { factory = 'afld', types = { "bggy", "bggy", "bggy", "bike", "bike" } }
  },
  hard =
  {
    { factory = 'hand', types = { "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e3", "e3", "e3" } },
    { factory = 'afld', types = { "bggy", "bggy", "bggy", "bike", "bike" } }
  }
}

SethAttackPaths =
{
  { SethAtk1.Location, SethAtk2.Location }
}

SethAttackProduction = function()
  local production = Utils.Random(SethAttackUnitTypes[Difficulty])
  local path = Utils.Random(SethAttackPaths)
  local toBuild = function() return production.types end
  local factory = GetAvailableFactory(Seth, production.factory)

  if factory ~= nil then
    ProduceUnits(Seth, factory, nil, toBuild, function(units)
      Utils.Do(units, function(unit)
        ErrorGuardAttackPatrol(unit, path)
        unit.Hunt()
      end)
      Trigger.AfterDelay(Utils.RandomInteger(SethAttackDelayMin[Difficulty], SethAttackDelayMax[Difficulty]), SethAttackProduction)
    end)
  else
    Trigger.AfterDelay(Utils.RandomInteger(SethAttackDelayMin[Difficulty], SethAttackDelayMax[Difficulty]), SethAttackProduction)
  end
end

-- End Seth's AI attack production behavior -----


-- Seth AI base building behavior -----

SethBaseStarted = false
SethDead = false
SethAttacking = false

SethArrives = function()
  Media.PlaySound("Eva-ReinforcementsNorth.aud")
  Reinforcements.Reinforce(Seth, {'ltnk', 'ltnk', 'bike', 'bike', 'bggy', 'bggy'}, { SethSpawn.Location }, 15, function(unit)
    unit.Move(SethGuards.Location)
  end)
  
  Trigger.AfterDelay(DateTime.Seconds(5), function()
    Media.DisplayMessage("I'm moving into position.\nStand by to launch a pincer attack once my forces are ready.", "Seth", HSLColor.FromHex("FE1100"))
    Reinforcements.Reinforce(Seth, {'mcv'}, { SethSpawn.Location }, 15, function(mcv)
      mcv.Move(MCV1.Location)
      mcv.Move(MCV2.Location)
      mcv.Move(MCV3.Location)
      mcv.CallFunc(function()
        Trigger.AfterDelay(DateTime.Seconds(1), function() BuildSethBase() end)
        Trigger.AfterDelay(DateTime.Seconds(4), function()
          SethBaseStarted = true
          SethFact = Seth.GetActorsByType('fact')[1]
          AirstrikeAttacks()
        end)
			end)
      mcv.Deploy()
    end)
  end)
end


BuildBaseOrders = {
  ["nuke1"] = { structure = "nuke", loc = SethNuke1.Location, tim = 14 },
  ["hand1"] = { structure = "hand", loc = SethHand1.Location, tim = 18 },
  ["proc"]  = { structure = "proc", loc = SethProc.Location,  tim = 22 },
  ["hand2"] = { structure = "hand", loc = SethHand2.Location, tim = 26 },
  ["nuke2"] = { structure = "nuke", loc = SethNuke2.Location, tim = 30 },
  ["afld"]  = { structure = "afld", loc = SethAfld.Location,  tim = 34 },
  ["hq"]    = { structure = "hq",   loc = SethHq.Location,    tim = 38 },
  ["gun1"]  = { structure = "gun",  loc = SethGun1.Location,  tim = 42 },
  ["gun2"]  = { structure = "gun",  loc = SethGun2.Location,  tim = 46 }
}


BuildSethBase = function()
  for id, orders in pairs(BuildBaseOrders) do
    Trigger.AfterDelay(DateTime.Seconds(orders.tim), function()
      if SethDead == false then
        local newBuilding = Actor.Create(orders.structure, true, { Owner = Seth, Location = orders.loc })
        AutoRebuildBuilding(newBuilding, Seth)
        if id == 'hand1' then
          SethHand1 = newBuilding
          Trigger.AfterDelay(DateTime.Seconds(3), function() SethInitialProduction(SethHand1, SethInitialInfantry, false) end)
        elseif id == 'hand2' then
          SethHand2 = newBuilding
          Trigger.AfterDelay(DateTime.Seconds(3), function() SethInitialProduction(SethHand2, SethInitialInfantry, false) end)
        elseif id == 'afld' then
          SethAfld = newBuilding
          Trigger.AfterDelay(DateTime.Seconds(5), function() SethInitialProduction(SethAfld, SethInitialVehicles, true) end)
        end
      end
    end)
  end
end

-- End Seth AI base building behavior -----


AirstrikeAttacks = function()
  if SAMPlaced == true then
    Reinforcements.Reinforce(GDI, { "a10scrip" }, { A10Spawn.Location }, 15, function(unit)
      Trigger.OnKilled(unit, function(self, killer)
        Media.DisplayMessage("Airstrike has been shot down!", "NOTICE", HSLColor.FromHex("00FF00"))
      end)
      unit.Attack(SethFact)
    end)
  else
    Reinforcements.Reinforce(GDI, { "a10scrip" }, { A10AltSpawn.Location }, 15, function(unit)
      Trigger.OnKilled(unit, function(self, killer)
        Media.DisplayMessage("Airstrike has been shot down!", "NOTICE", HSLColor.FromHex("00FF00"))
      end)
      unit.Attack(SethFact)
    end)
  end
end


SpawnExtraCounterAttack = function(counterAttackLimit)
  Reinforcements.Reinforce(GDI, { "e2", }, { CounterSpawnA.Location }, 15, function(unit)
    AssaultPlayerBaseOrHunt(unit)
  end)
  
  if counterAttackLimit % 2 == 0 then
    Reinforcements.Reinforce(GDI, { "jeep", }, { CounterSpawnB.Location }, 15, function(unit)
      AssaultPlayerBaseOrHunt(unit)
    end)
  end
  
  Reinforcements.Reinforce(GDI, { "e2", }, { CounterSpawnC.Location }, 15, function(unit)
    AssaultPlayerBaseOrHunt(unit)
  end)
  
  if counterAttackLimit > 0 then
    Trigger.AfterDelay(DateTime.Seconds(2), function() SpawnExtraCounterAttack(counterAttackLimit-1) end)
  end
end


RevealCounterArea = function(a, id)
  if IsOwnedByCoopPlayer(a) then
    if RevealedCounter == false then
      RevealedCounter = true
      Trigger.RemoveProximityTrigger(id)
      CounterCamera = Actor.Create("camera.small", true, { Owner = Nod, Location = CounterSWP.Location })
      Trigger.AfterDelay(DateTime.Seconds(10), function()
        CounterCamera.Destroy()
      end)
    end
  end
end


WorldLoaded = function()
  GDI = Player.GetPlayer("GDI")
  SubGDI = Player.GetPlayer("SubGDI")
  Seth = Player.GetPlayer("Seth")
  Nod = Player.GetPlayer("Nod")
  MissionPlayer = Nod

	BadGuy = Player.GetPlayer("BadGuy")

	coopInfo =
	{
		Mainplayer = Nod,
		MainEnemies = {GDI, SubGDI},
		Dummyplayer = BadGuy
	}
	
	ORAMod = "tibalt"
	CoopInit25(coopInfo)

  Camera.Position = StartCam.CenterPosition
  
  --Special lighting
  Lighting.Ambient = 0.6
  Lighting.Red = 1.3
  Lighting.Blue = 0.7
  Lighting.Green = 1.1
  
  --Remove actors based on difficulty
  Utils.Do(ActorRemovals[Difficulty], function(unit)
    unit.Destroy()
  end)
  
  --Player Reinforcements
  Trigger.AfterDelay(DateTime.Seconds(3), function()
	Utils.Do(MCVPlayers,function(PID)
		Reinforcements.Reinforce(PID, {'mcv'}, { PlayerSpawn.Location }, 15, function(mcv)
			mcv.Move(PlayerMoveTo.Location)
		end)
	end)
	Media.PlaySpeechNotification(All, "Reinforce")
  end)
  
  --Objectives
  InitObjectives(Nod)
  Trigger.AfterDelay(DateTime.Seconds(6), function()
    DefeatGDIObjective = Nod.AddObjective("Destroy the main GDI base.")
    BuildSAMSiteObjective = Nod.AddObjective("Build a SAM at the flare within the time limit.", "Secondary", false)
    
    SAMFlare = Actor.Create("flare", true, { Owner = BadGuy, Location = Flare.Location })
    
    --Timer
    TimerDuration = 1200
    if Difficulty == 'normal' then TimerDuration = 1050 end
    if Difficulty == 'hard' then TimerDuration = 900 end
    DateTime.TimeLimit = DateTime.Seconds(TimerDuration)
    Media.PlaySound("Eva-MissionTimer.aud")
  end)
  
  Trigger.OnTimerExpired(function()
    SethArrives()
    SAMFlare.Destroy()
  end)
  
  --AI player behavior
  GDI.Resources = GDI.ResourceCapacity - 500
  GDI.Cash = 50000
  SubGDI.Resources = SubGDI.ResourceCapacity - 500
  SubGDI.Cash = 50000
  Seth.Resources = 50000
  Seth.Cash = 50000
  
  if Difficulty ~= "easy" then
    AutoRepairAndRebuildBuildings(GDI, 15)
    AutoReplaceHarvesters(GDI)
  end
  
  SetupRefAndSilosCaptureCredits(GDI)
  SetupRefAndSilosCaptureCredits(SubGDI)
  
  localFirstAttackDelay = 15
  if Difficulty == "easy" then localFirstAttackDelay = 45
  elseif Difficulty == "normal" then localFirstAttackDelay = 30 end
  
  Trigger.AfterDelay(DateTime.Seconds(localFirstAttackDelay), function()
    SubGDIAttackProduction()
    GDIAttackProduction()
  end)
  
  --Enemy Predeployed Attacks
  Utils.Do(SouthCounterTriggers, function(unit)
    Trigger.OnKilled(unit, function(self, killer)
      if CounterTriggered == false and SethAttacking == false then
        CounterTriggered = true
        --Media.DisplayMessage("You have prematurely triggered a massive enemy counterattack!", "WARNING", HSLColor.FromHex("FE1100"))
        Utils.Do(CounterUnits, function(cunit)
          if cunit ~= nil then
            AssaultPlayerBaseOrHunt(cunit)
          end
        end)
        if Difficulty ~= "easy" then
          Trigger.AfterDelay(DateTime.Seconds(10), function()
            SpawnExtraCounterAttack(12)
          end)
        end
      end
    end)
  end)
  
  Utils.Do(NorthCounterTriggers, function(unit)
    Trigger.OnKilled(unit, function(self, killer)
      if CounterTriggered == false then
        CounterTriggered = true
        Utils.Do(CounterUnits, function(cunit)
          if cunit ~= nil then
            cunit.AttackMove(MCV3.Location)
            AssaultPlayerBaseOrHunt(cunit)
          end
        end)
        if Difficulty ~= "easy" then
          Trigger.AfterDelay(DateTime.Seconds(5), function()
            SpawnExtraCounterAttack(5)
          end)
        end
      end
    end)
  end)
  
  --Proximity Reveals
  RevealedCounter = false
  Trigger.OnEnteredProximityTrigger(GDIAtkA.CenterPosition, WDist.New(3 * 1024), function(a, id)
    RevealCounterArea(a, id)
  end)
  
  Trigger.OnEnteredProximityTrigger(RevealCounterW.CenterPosition, WDist.New(3 * 1024), function(a, id)
    RevealCounterArea(a, id)
  end)

end


Tick = function()
	OncePerSecondChecks()
	OncePerThreeSecondChecks()
end

OncePerSecondChecks = function()
  if DateTime.GameTime > 1 and DateTime.GameTime % 25 == 0 then
	local ObjCounter = 0
	Utils.Do(CoopPlayers,function(PID)
		if HasOneOf(PID, LossCheckAll) == false then
			ObjCounter = ObjCounter + 1
		end
	end)
	if ObjCounter >= #CoopPlayers then
      if DefeatGDIObjective ~= nil and not Nod.IsObjectiveCompleted(DefeatGDIObjective) then
        Nod.MarkFailedObjective(DefeatGDIObjective)
      end
      if BuildSAMSiteObjective ~= nil and not Nod.IsObjectiveCompleted(BuildSAMSiteObjective) then
        Nod.MarkFailedObjective(BuildSAMSiteObjective)
      end
    end
  end
end

OncePerThreeSecondChecks = function()
	if DateTime.GameTime > 1 and DateTime.GameTime % 75 == 0 then
  
		if HasOneOf(GDI, LossCheckStructures) == false then
      Nod.MarkCompletedObjective(DefeatGDIObjective)
    end

    if SethBaseStarted == true and SethDead == false and HasOneOf(Seth, LossCheckStructures) == false then
      SethDead = true
      Media.DisplayMessage("Well, so much for that. Great work on the assist.\nLooks like you're on your own now, Commander.", "Seth", HSLColor.FromHex("FE1100"))
    end

    if SAMPlaced == true and SethBaseStarted == false then
		local ObjCounter = 0
		Utils.Do(CoopPlayers,function(PID)
			if TypeExistsInBox(PID, 'sam', SAMCheckUL, SAMCheckLR) == false then
				ObjCounter = ObjCounter + 1
			end
		end)
		if ObjCounter >= #CoopPlayers then
			SAMPlaced = false
			Media.DisplayMessage("The SAM site you built is gone! Build another one before the timer expires!", "WARNING", HSLColor.FromHex("FE1100"))
		end
    end

	if SAMPlaced == false then
		local ObjCounter = 0
		Utils.Do(CoopPlayers,function(PID)
			if TypeExistsInBox(PID, 'sam', SAMCheckUL, SAMCheckLR) == true then
				ObjCounter = ObjCounter + 1
			end
		end)
		if ObjCounter >= #CoopPlayers then
			Nod.MarkCompletedObjective(BuildSAMSiteObjective)
			SAMPlaced = true
		end
    end
    
    --manipulate AI funds
    ManipulatePlayerFunds(GDI)
	end
end
