
NodDefeated = false
Nod2Defeated = false
SubNodDefeated = false
BuiltHelipad = false
Nod2Awake = false
SubNodAwake = false

ActorRemovals =
{
  easy = {  },
  normal = { NRM1, NRM2 },
  hard = { NRM1, NRM2, HRM1, HRM2, HRM3 },
}


AwakenNod = function()
  NodVehicleAttackProduction()
  NodInfantryAttackProduction()
  --local newBuilding = Actor.Create('proc', true, { Owner = Nod, Location = NodProc.Location })
  --AutoRebuildBuilding(newBuilding, Nod)
  --AutoReplaceHarvesters(Nod)
  
  Media.DisplayMessage("I'm delighted to see you again, GDI.\nI'm looking forward to repaying you for our wonderful time before.", "Slavik", HSLColor.FromHex("FF0000"))

  --artillery strikes from ridgeline
  Trigger.AfterDelay(Utils.RandomInteger(ArtyAttackDelayMin[Difficulty], ArtyAttackDelayMax[Difficulty]), ArtyAttackProduction)
  
  --evil cloaked engy rush
  if Difficulty ~= 'easy' then
    Trigger.AfterDelay(DateTime.Seconds(360), function()
      local prereqs = Nod.GetActorsByTypes({'hand', 'afld'})
      if #prereqs >= 2 then
        EngyRushTargetPlayer = MissionPlayer
        Reinforcements.ReinforceWithTransport(Nod, "apc", {"e6", "e6", "e6", "e6", "e6"}, { EngyRushSpawn.Location }, null, ExecEngyRush)
      end
    end)
  end
end


AwakenNod2 = function()
  if Nod2Awake == true then return end
  Nod2Awake = true
  AwakenSubNod()
  Nod2VehicleAttackProduction()
  Nod2InfantryAttackProduction()
  local newBuilding = Actor.Create('proc', true, { Owner = Nod2, Location = Nod2Proc.Location })
  AutoRebuildBuilding(newBuilding, Nod2)
  AutoReplaceHarvesters(Nod2)
  
  Media.DisplayMessage("It's not over yet, GDI. I WILL destroy you!", "Slavik", HSLColor.FromHex("FF0000"))
end


AwakenSubNod = function()
  if SubNodAwake == true then return end
  SubNodAwake = true
  AwakenNod2()
  SubNodVehicleAttackProduction()
  SubNodInfantryAttackProduction()
end


-- SubNod's AI attack production behavior -----

ArtyAttackDelayMin = { easy = DateTime.Seconds(270), normal = DateTime.Seconds(240), hard = DateTime.Seconds(210) }
ArtyAttackDelayMax = { easy = DateTime.Seconds(300), normal = DateTime.Seconds(270), hard = DateTime.Seconds(240) }

SubNodAttackInfantryTypes = {
  easy = {
    { types = { "e3", "e3", "e3", "e3", "e3" } },
  },
  normal = {
    { types = { "e3", "e3", "e3", "e3", "e3", "e3", "e3", "e3", "e3", "e3" } },
  },
  hard = {
    { types = { "e3", "e3", "e3", "e3", "e3", "e3", "e3", "e3", "e3", "e3", "e3", "e3", "e3", "e3", "e3" } },
  }
}

SubNodAttackVehicleTypes = {
  easy = {
    { types = { "bggy", "bggy", "bggy", "ltnk" } },
  },
  normal = {
    { types = { "bggy", "bggy", "bggy", "bggy", "ltnk", "ltnk" } },
  },
  hard = {
    { types = { "bggy", "bggy", "bggy", "bggy", "ltnk", "ltnk", "ltnk", "ltnk" } },
  }
}

SubNodLZCounterTypes = {
  easy = {
    { types = { "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", } },
  },
  normal = {
    { types = { "e4", "e4", "e4", "e4", "e4", "e4", "e4", "e4", "e4", "e4", } },
  },
  hard = {
    { types = { "e4", "e4", "e4", "e4", "e4", "e4", "e4", "e4", "e4", "e4", "e4", "e4", "e4", "e4", "e4", } },
  }
}

ArtyAttackPaths = {
  { ArtyAtk.Location }
}

ArtyAttackTypes =
{
  easy = { { types = { "arty" } }, },
  normal = { { types = { "arty", "arty" } }, },
  hard = { { types = { "arty", "arty", "arty" } }, }
}

ArtyAttackProduction = function()
  local production = Utils.Random(ArtyAttackTypes[Difficulty])
  local path = Utils.Random(ArtyAttackPaths)
  local toBuild = function() return production.types end
  local factory = ArtyAfld
  
  if factory ~= nil then
    ProduceUnits(SubNod, factory, nil, toBuild, function(units)
      Utils.Do(units, function(unit)
        ErrorGuardAttackPatrol(unit, path)
      end)
    end)
  end

  Trigger.AfterDelay(Utils.RandomInteger(ArtyAttackDelayMin[Difficulty], ArtyAttackDelayMax[Difficulty]), ArtyAttackProduction)
end


SubNodVehicleAttackProduction = function()
  local production = Utils.Random(SubNodAttackVehicleTypes[Difficulty])
  local toBuild = function() return production.types end
  local factory = SubNodAfld2
  
  if factory ~= nil then
    ProduceUnits(SubNod, factory, nil, toBuild, function(units)
      Utils.Do(units, function(unit)
        if unit.Type ~= 'harv' then unit.Hunt() end
      end)
    end)
  end
end

SubNodInfantryAttackProduction = function()  
  local production = Utils.Random(SubNodAttackInfantryTypes[Difficulty])
  local toBuild = function() return production.types end
  local factory = SubNodHand2

  if factory ~= nil then
    ProduceUnits(SubNod, factory, nil, toBuild, function(units)
      Utils.Do(units, function(unit)
        unit.Hunt()
      end)
    end)
  end
end

SubNodLZCounterProduction = function()  
  local production = Utils.Random(SubNodLZCounterTypes[Difficulty])
  local toBuild = function() return production.types end
  local factory = SubNodHand1

  if factory ~= nil then
    ProduceUnits(SubNod, factory, nil, toBuild, function(units)
      Utils.Do(units, function(unit)
        unit.AttackMove(LandingZoneA.Location)
        unit.Hunt()
      end)
    end)
  end
end

SubNodAntiAirProduction = function()  
  local production = Utils.Random(SubNodAttackInfantryTypes[Difficulty])
  local toBuild = function() return production.types end
  local factory = SubNodHand1

  if factory ~= nil then
    ProduceUnits(SubNod, factory, nil, toBuild, function(units)
      Utils.Do(units, function(unit)
        --
      end)
    end)
  end
end

-- End SubNod's AI attack production behavior -----


-- Nod's AI attack production behavior -----

NodAttackDelayMin = { easy = DateTime.Seconds(60), normal = DateTime.Seconds(45), hard = DateTime.Seconds(30) }
NodAttackDelayMax = { easy = DateTime.Seconds(90), normal = DateTime.Seconds(60), hard = DateTime.Seconds(45) }

NodAttackPaths = {
  { NodAtkA.Location },
  { NodAtkB.Location },
  { NodAtkC1.Location, NodAtkC2.Location }
}

NodAttackInfantryTypes = {
  easy = {
    { types = { "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1" } },
    { types = { "e1", "e1", "e1", "e1", "e3", "e3", "e3" } },
    { types = { "e3", "e3", "e3", "e3", "e3", "e3" } },
    { types = { "e4", "e4", "e4", "e4", "e4", "e4" } },
    { types = { "spy", "spy", "spy", "spy", "spy", "spy" } },
  },
  normal = {
    { types = { "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1" } },
    { types = { "e1", "e1", "e1", "e1", "e3", "e3", "e3", "e3" } },
    { types = { "e3", "e3", "e3", "e3", "e3", "e3", "e3" } },
    { types = { "spy", "spy", "spy", "spy", "spy", "spy", "spy" } },
    { types = { "e4", "e4", "e4", "e4", "e4", "e4", "e4" } },
  },
  hard = {
    { types = { "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1" } },
    { types = { "e1", "e1", "e1", "e1", "e1", "e3", "e3", "e3", "e3", "e3" } },
    { types = { "e3", "e3", "e3", "e3", "e3", "e3", "e3" } },
    { types = { "spy", "spy", "spy", "spy", "spy", "spy", "spy" } },
    { types = { "e4", "e4", "e4", "e4", "e4", "e4", "e4" } },
  }
}

NodAttackVehicleTypes = {
  easy = {
    { types = { "bggy", "bggy", "bggy", "bike" } },
    { types = { "ltnk", "ltnk", "ltnk" } },
    { types = { "ltnk", "ltnk", "arty" } },
  },
  normal = {
    { types = { "bggy", "bggy", "bggy", "bggy", "bike", "bike" } },
    { types = { "ltnk", "ltnk", "ltnk", "ltnk" } },
    { types = { "ltnk", "ltnk", "ltnk", "arty", "arty" } },
  },
  hard = {
    { types = { "bggy", "bggy", "bggy", "bggy", "bike", "bike" } },
    { types = { "ltnk", "ltnk", "ltnk", "ltnk", "ltnk" } },
    { types = { "ltnk", "ltnk", "ltnk", "arty", "arty", "arty" } },
  }
}

NodVehicleAttackProduction = function()
  local production = Utils.Random(NodAttackVehicleTypes[Difficulty])
  local path = Utils.Random(NodAttackPaths)
  local toBuild = function() return production.types end
  local factory = GetAvailableFactory(Nod, 'afld')
  
  if factory ~= nil then
    ProduceUnits(Nod, factory, nil, toBuild, function(units)
      UpdatePlayerBaseLocation()
      Utils.Do(units, function(unit)
        ErrorGuardAttackPatrol(unit, path)
        AssaultPlayerBaseOrHunt(unit)
      end)
      Trigger.AfterDelay(Utils.RandomInteger(NodAttackDelayMin[Difficulty], NodAttackDelayMax[Difficulty]), NodVehicleAttackProduction)
    end)
  else
    Trigger.AfterDelay(Utils.RandomInteger(NodAttackDelayMin[Difficulty], NodAttackDelayMax[Difficulty]), NodVehicleAttackProduction)
  end
end

NodInfantryAttackProduction = function()  
  local production = Utils.Random(NodAttackInfantryTypes[Difficulty])
  local path = Utils.Random(NodAttackPaths)
  local toBuild = function() return production.types end
  local factory = GetAvailableFactory(Nod, 'hand')

  if factory ~= nil then
    ProduceUnits(Nod, factory, nil, toBuild, function(units)
      UpdatePlayerBaseLocation()
      Utils.Do(units, function(unit)
        ErrorGuardAttackPatrol(unit, path)
        AssaultPlayerBaseOrHunt(unit)
      end)
      Trigger.AfterDelay(Utils.RandomInteger(NodAttackDelayMin[Difficulty], NodAttackDelayMax[Difficulty]), NodVehicleAttackProduction)
    end)
  else
    Trigger.AfterDelay(Utils.RandomInteger(NodAttackDelayMin[Difficulty], NodAttackDelayMax[Difficulty]), NodVehicleAttackProduction)
  end
end

-- End Nod's AI attack production behavior -----


-- Nod2's AI attack production behavior -----

Nod2AttackPaths = {
  { Nod2Stage.Location, Nod2Atk.Location },
}


Nod2VehicleAttackProduction = function()
  local production = Utils.Random(NodAttackVehicleTypes[Difficulty])
  local path = Utils.Random(Nod2AttackPaths)
  local toBuild = function() return production.types end
  local factory = GetAvailableFactory(Nod2, 'afld')
  
  if factory ~= nil then
    ProduceUnits(Nod2, factory, nil, toBuild, function(units)
      UpdatePlayerBaseLocation()
      Utils.Do(units, function(unit)
        ErrorGuardAttackPatrol(unit, path)
        AssaultPlayerBaseOrHunt(unit)
      end)
      Trigger.AfterDelay(Utils.RandomInteger(NodAttackDelayMin[Difficulty], NodAttackDelayMax[Difficulty]), NodVehicleAttackProduction)
    end)
  else
    Trigger.AfterDelay(Utils.RandomInteger(NodAttackDelayMin[Difficulty], NodAttackDelayMax[Difficulty]), NodVehicleAttackProduction)
  end
end

Nod2InfantryAttackProduction = function()  
  local production = Utils.Random(NodAttackInfantryTypes[Difficulty])
  local path = Utils.Random(Nod2AttackPaths)
  local toBuild = function() return production.types end
  local factory = GetAvailableFactory(Nod2, 'hand')

  if factory ~= nil then
    ProduceUnits(Nod2, factory, nil, toBuild, function(units)
      UpdatePlayerBaseLocation()
      Utils.Do(units, function(unit)
        ErrorGuardAttackPatrol(unit, path)
        AssaultPlayerBaseOrHunt(unit)
      end)
      Trigger.AfterDelay(Utils.RandomInteger(NodAttackDelayMin[Difficulty], NodAttackDelayMax[Difficulty]), NodVehicleAttackProduction)
    end)
  else
    Trigger.AfterDelay(Utils.RandomInteger(NodAttackDelayMin[Difficulty], NodAttackDelayMax[Difficulty]), NodVehicleAttackProduction)
  end
end

-- End Nod's AI attack production behavior -----


WorldLoaded = function()
  GDI = Player.GetPlayer("GDI")
  Nod = Player.GetPlayer("Nod")
  Nod2 = Player.GetPlayer("Nod2")
  SubNod = Player.GetPlayer("SubNod")
  Neutral = Player.GetPlayer("Neutral")
  
  MissionPlayer = GDI

	GoodGuy = Player.GetPlayer("GoodGuy")

	coopInfo =
	{
		Mainplayer = GDI,
		MainEnemies = {Nod, Nod2, SubNod},
		Dummyplayer = GoodGuy
	}
	
	ORAMod = "tibalt"
	CoopInit25(coopInfo)
	
	Utils.Do(MCVPlayers,function(PID)
		if PID ~= GDI then
			local NewMCV = Actor.Create("mcv", true, { Owner = PID, Location = Actor380.Location })
			NewMCV.Scatter()
		end
	end)

  Camera.Position = StartCam.CenterPosition
  
  --Remove actors based on difficulty
  Utils.Do(ActorRemovals[Difficulty], function(unit)
    unit.Destroy()
  end)
  
  --Special lighting
  
  --Player Reinforcements
  Trigger.OnAllKilled({ShoreDef1, ShoreDef2, ShoreDef3, ShoreDef4, ShoreDef5}, function()
    Media.PlaySpeechNotification(All, "Reinforce")
    Media.DisplayMessage("Let's show this scumbag what kick-ass is all about!", "Carter", HSLColor.FromHex("857833"))
    
    Actor.Create("boat", true, { Owner = GoodGuy, Location = BoatSpawn.Location })
    
    if Difficulty ~= 'hard' then
      Trigger.AfterDelay(DateTime.Seconds(5), function()
        Actor.Create("boat", true, { Owner = GoodGuy, Location = BoatSpawn.Location })
      end)
    end
    
    if Difficulty == 'easy' then
      Trigger.AfterDelay(DateTime.Seconds(10), function()
        Actor.Create("boat", true, { Owner = GoodGuy, Location = BoatSpawn.Location })
      end)
    end
	end)

  --Objectives
  InitObjectives(GDI)

  Trigger.AfterDelay(DateTime.Seconds(2), function()
    BuildHelipadObjective = GDI.AddObjective("Build a helipad.")
    DefeatNodObjective = GDI.AddObjective("Eradicate all Nod forces.")
  end)
  
  --AI player behavior
  Nod.Resources = Nod.ResourceCapacity - 500
  Nod.Cash = 90000
  
  Nod2.Resources = Nod2.ResourceCapacity - 500
  Nod2.Cash = 90000
  
  SubNod.Resources = SubNod.ResourceCapacity - 500
  SubNod.Cash = 90000
  
  if Difficulty ~= "easy" then
    AutoRepairAndRebuildBuildings(Nod, 15)
    AutoRepairAndRebuildBuildings(Nod2, 15)
  end
  
  AutoReplaceHarvesters(Nod)
  SetupRefAndSilosCaptureCredits(Nod)
  SetupRefAndSilosCaptureCredits(Nod2)
  
  if Difficulty == "easy" then Trigger.AfterDelay(DateTime.Seconds(90), AwakenNod)
  elseif Difficulty == "normal" then Trigger.AfterDelay(DateTime.Seconds(60), AwakenNod)
  elseif Difficulty == "hard" then Trigger.AfterDelay(DateTime.Seconds(45), AwakenNod)
  end
  
  --Enemy Predeployed Maneuvers

  --Proximity Triggers/Reveals
  Trigger.OnEnteredProximityTrigger(AwakenNod2WP.CenterPosition, WDist.New(17 * 1024), function(a, id)
    if IsOwnedByCoopPlayer(a) and a.Type ~= 'camera' then
      Trigger.RemoveProximityTrigger(id)
      AwakenNod2()
    end
  end)
  
  Trigger.OnEnteredProximityTrigger(AwakenSubNodWP.CenterPosition, WDist.New(11 * 1024), function(a, id)
    if IsOwnedByCoopPlayer(a) and a.Type ~= 'camera' then
      Trigger.RemoveProximityTrigger(id)
      AwakenSubNod()
    end
  end)
  
  Trigger.OnEnteredProximityTrigger(LandingZoneA.CenterPosition, WDist.New(3 * 1024), function(a, id)
    if IsOwnedByCoopPlayer(a) and a.Type ~= 'camera' then
      Trigger.RemoveProximityTrigger(id)
      SubNodLZCounterProduction()
    end
  end)
  
  Trigger.OnEnteredProximityTrigger(OrcaProx1.CenterPosition, WDist.New(8 * 1024), function(a, id)
    if IsOwnedByCoopPlayer(a) and (a.Type == 'orca' or a.Type == 'morelli') then
      Trigger.RemoveProximityTrigger(id)
      SubNodAntiAirProduction()
    end
  end)
  
  --Crate spawns
  
  --Testing
end


Tick = function()
	OncePerSecondChecks()
	OncePerThreeSecondChecks()
end

OncePerSecondChecks = function()
	if DateTime.GameTime > 1 and DateTime.GameTime % 25 == 0 then
		if BuiltHelipad == false then
			Utils.Do(CoopPlayers,function(PID)
				if HasOneOf(PID, {'hpad'}) == true then
					BuiltHelipad = true
					GDI.MarkCompletedObjective(BuildHelipadObjective)

					Media.PlaySound('Morelli-09M-01.aud')
					Media.DisplayMessage("All right Commander, let's see what these Orcas can do.\nI await your orders.", "Morelli", HSLColor.FromHex("857833"))

					local hpad = PID.GetActorsByTypes({'hpad'})[1]

					Reinforcements.Reinforce(PID, { 'morelli' }, { MorelliSpawn.Location }, 15, function(unit)
						unit.Move(hpad.Location)
						Trigger.OnKilled(unit, function()
							Media.PlaySound('Morelli-09M-02.aud')
							Media.DisplayMessage("I can't believe they got me! I'm bailing out!", "Morelli", HSLColor.FromHex("857833"))
						end)
					end)
				end
			end)
		end
	end
end

OncePerThreeSecondChecks = function()
	if DateTime.GameTime > 1 and DateTime.GameTime % 75 == 0 then
    --if HasOneOf(GDI, LossCheckAll) == false then PlayerFailMission() end
	TibAltCoopLossCheck()


    if NodDefeated == false then
      if HasOneOf(Nod, LossCheckCritical) == false then NodDefeated = true end
    end
    
    if Nod2Defeated == false then
      if HasOneOf(Nod2, LossCheckCritical) == false then Nod2Defeated = true end
    end
    
    if SubNodDefeated == false then
      if HasOneOf(SubNod, LossCheckCritical) == false then SubNodDefeated = true end
    end
    
    if DefeatNodObjective ~= nil and NodDefeated == true and Nod2Defeated == true and SubNodDefeated == true then
      GDI.MarkCompletedObjective(DefeatNodObjective)
    end
    
    --manipulate AI funds
    ManipulatePlayerFunds(Nod)
    ManipulatePlayerFunds(Nod2)
	end
end


PlayerFailMission = function()
  if DefeatNodObjective ~= nil and not GDI.IsObjectiveCompleted(DefeatNodObjective) then
    GDI.MarkFailedObjective(DefeatNodObjective)
  end
  if BuildHelipadObjective ~= nil and not GDI.IsObjectiveCompleted(BuildHelipadObjective) then
    GDI.MarkFailedObjective(BuildHelipadObjective)
  end
end