
ActorRemovals =
{
  easy = { EasyR1, EasyR2, EasyR3, EasyR4, EasyR5, EasyR6, EasyR7, EasyR8, EasyR9, EasyR10, EasyR11 },
  normal = { },
  hard = { },
}

-- GDI's AI attack production behavior -----

GDIAttackDelayMin = { easy = DateTime.Seconds(90), normal = DateTime.Seconds(60), hard = DateTime.Seconds(45) }
GDIAttackDelayMax = { easy = DateTime.Seconds(120), normal = DateTime.Seconds(90), hard = DateTime.Seconds(60) }
GDIAttackUnitTypes = {
  easy = {
    { factory = 'pyle', types = { "e1", "e1", "e1", "e1", "e1", "e1" } },
    { factory = 'weap', types = { "jeep", "jeep" } },
  },
  normal = {
    { factory = 'pyle', types = { "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1" } },
    { factory = 'pyle', types = { "e2", "e2", "e2", "e2", "e2", "e2", "e2", "e2" } },
    { factory = 'weap', types = { "jeep", "jeep" } },
  },
  hard = {
    { factory = 'pyle', types = { "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1" } },
    { factory = 'pyle', types = { "e2", "e2", "e2", "e2", "e2", "e2", "e2", "e2", "e2", "e2", "e2", "e2" } },
    { factory = 'weap', types = { "jeep", "jeep", "jeep", "jeep" } },
  }
}

GDIAttackPaths = {
  { GDIAtk1.Location, GDIAtk2.Location }
}

GDIAttackProduction = function()
  local production = Utils.Random(GDIAttackUnitTypes[Difficulty])
  local path = Utils.Random(GDIAttackPaths)
  local toBuild = function() return production.types end
  local factory = GetAvailableFactory(GDI, production.factory)

  if factory ~= nil then
    ProduceUnits(GDI, factory, nil, toBuild, function(units)
      UpdatePlayerBaseLocation()
      Utils.Do(units, function(unit)
        ErrorGuardAttackPatrol(unit, path)
        AssaultPlayerBaseOrHunt(unit)
      end)
      Trigger.AfterDelay(Utils.RandomInteger(GDIAttackDelayMin[Difficulty], GDIAttackDelayMax[Difficulty]), GDIAttackProduction)
    end)
  else
    Trigger.AfterDelay(Utils.RandomInteger(GDIAttackDelayMin[Difficulty], GDIAttackDelayMax[Difficulty]), GDIAttackProduction)
  end
end

-- End GDI's AI attack production behavior -----

-- Militia's AI attack production behavior -----

NikAttackDelayMin = { easy = DateTime.Seconds(90), normal = DateTime.Seconds(60), hard = DateTime.Seconds(45) }
NikAttackDelayMax = { easy = DateTime.Seconds(120), normal = DateTime.Seconds(90), hard = DateTime.Seconds(60) }
NikAttackUnitTypes =
{
  easy =
  {
    { factory = 'pyle', types = { "e1", "e1", "e1" } },
    { factory = 'pyle', types = { "e1", "e1", "e3", "e3" } },
  },
  normal =
  {
    { factory = 'pyle', types = { "e1", "e1", "e1", "e1", "e1", "e1" } },
    { factory = 'pyle', types = { "e1", "e1", "e1", "e3", "e3", "e3" } },
  },
  hard =
  {
    { factory = 'pyle', types = { "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1" } },
    { factory = 'pyle', types = { "e1", "e1", "e1", "e1", "e1", "e3", "e3", "e3" } },
  }
}

NikAttackPaths =
{
  { MilitiaAtk1.Location, MilitiaAtk2.Location }
}

NikAttackProduction = function()
  local production = Utils.Random(NikAttackUnitTypes[Difficulty])
  local path = Utils.Random(NikAttackPaths)
  local toBuild = function() return production.types end
  local factory = GetAvailableFactory(Nik, production.factory)

  if factory ~= nil then
    ProduceUnits(Nik, factory, nil, toBuild, function(units)
      UpdatePlayerBaseLocation()
      Utils.Do(units, function(unit)
        ErrorGuardAttackPatrol(unit, path)
        AssaultPlayerBaseOrHunt(unit)
      end)
      Trigger.AfterDelay(Utils.RandomInteger(NikAttackDelayMin[Difficulty], NikAttackDelayMax[Difficulty]), NikAttackProduction)
    end)
  else
    Trigger.AfterDelay(Utils.RandomInteger(NikAttackDelayMin[Difficulty], NikAttackDelayMax[Difficulty]), NikAttackProduction)
  end
end

-- End Militia's AI attack production behavior -----


WorldLoaded = function()
  GDI = Player.GetPlayer("GDI")
  Nik = Player.GetPlayer("LocalMilitia")
  Nod = Player.GetPlayer("Nod")
  MissionPlayer = Nod

	BadGuy = Player.GetPlayer("BadGuy")

	coopInfo =
	{
		Mainplayer = Nod,
		MainEnemies = {GDI, Nik},
		Dummyplayer = BadGuy
	}
	
	ORAMod = "tibalt"
	CoopInit25(coopInfo)
	
	local OriginalMCV = Actor232
	Utils.Do(MCVPlayers,function(PID)
		if PID ~= Nod then
			local ExtraMCV = Actor.Create(OriginalMCV.Type, true, { Owner = PID, Location = OriginalMCV.Location })
			ExtraMCV.Scatter()
		end
	end)

  Camera.Position = StartCam.CenterPosition

  --Remove actors based on difficulty
  Utils.Do(ActorRemovals[Difficulty], function(unit)
    unit.Destroy()
  end)
  
  --Player Reinforcements
  
  --Objectives
  InitObjectives(Nod)
  Trigger.AfterDelay(DateTime.Seconds(1), function()
    KillNikoombaObjective = Nod.AddObjective("Locate and kill Nikoomba.")
    CapturePrisonObjective = Nod.AddObjective("Capture the GDI prison.")
  end)
  
  Trigger.OnKilled(Nikoomba, function(self, killer)
    Nod.MarkCompletedObjective(KillNikoombaObjective)
  end)
  
  Trigger.OnCapture(Prison, function(self, captor, oldOwner, newOwner)
    if newOwner ~= GDI then
      Nod.MarkCompletedObjective(CapturePrisonObjective)
    end
  end)
  
  Trigger.OnKilled(Prison, function(self, killer)
    Nod.MarkFailedObjective(CapturePrisonObjective)
  end)
  
  --AI player behavior
  GDI.Resources = GDI.ResourceCapacity - 1000
  Nik.Resources = Nik.ResourceCapacity - 1000
  
  if Difficulty == "hard" then
    AutoRepairAndRebuildBuildings(GDI, 15)
    AutoReplaceHarvesters(GDI)
  end
  
  SetupRefAndSilosCaptureCredits(GDI)
  SetupRefAndSilosCaptureCredits(Nik)
  
  if Difficulty == "normal" then GDI.Cash = 10000
  elseif Difficulty == "hard" then GDI.Cash = 50000 end
  
  --Enemy Predeployed Attacks
  
  --Proximity Reveals
  Trigger.OnEnteredProximityTrigger(RevealSiteTrig.CenterPosition, WDist.New(4 * 1024), function(a, id)
    if IsOwnedByCoopPlayer(a) then
      Trigger.RemoveProximityTrigger(id)
      Trigger.AfterDelay(DateTime.Seconds(45), function()
        GDIAttackProduction()
        NikAttackProduction()
      end)
      
      Media.PlaySound('Eva-SignalFlareSouth.aud')
      BaseSiteCamera = Actor.Create("camera", true, { Owner = Nod, Location = RevealSiteCam.Location })
      BaseSiteFlare = Actor.Create("flare", true, { Owner = BadGuy, Location = RevealSiteFlare.Location })
      
      Trigger.AfterDelay(DateTime.Seconds(60), function()
        BaseSiteFlare.Destroy()
        BaseSiteCamera.Destroy()
      end)
    end
  end)
  
  Trigger.OnEnteredProximityTrigger(RevealPrisonTrig.CenterPosition, WDist.New(3 * 1024), function(a, id)
    if IsOwnedByCoopPlayer(a) then
      Trigger.RemoveProximityTrigger(id)
      PrisonCamera = Actor.Create("camera", true, { Owner = Nod, Location = RevealPrisonCam.Location })
      Trigger.AfterDelay(DateTime.Seconds(10), function()
        PrisonCamera.Destroy()
      end)
    end
  end)
  
  Trigger.OnEnteredProximityTrigger(Nikoomba.CenterPosition, WDist.New(7 * 1024), function(a, id)
    if IsOwnedByCoopPlayer(a) then
      Trigger.RemoveProximityTrigger(id)
      Media.DisplayMessage("You'll never take me alive, Nod scum!", "Nikoomba", HSLColor.FromHex("0000FF"))
      Media.PlaySound('Eva-TargetLocated.aud')
      
      NikCamera = Actor.Create("camera", true, { Owner = Nod, Location = Nikoomba.Location })
      Trigger.AfterDelay(DateTime.Seconds(10), function()
        NikCamera.Destroy()
      end)
    end
  end)
end


Tick = function()
	OncePerSecondChecks()
	OncePerThreeSecondChecks()
end


OncePerSecondChecks = function()
  if DateTime.GameTime > 1 and DateTime.GameTime % 25 == 0 then
	local ObjCounter = 0
	Utils.Do(CoopPlayers,function(PID)
		if HasOneOf(PID, LossCheckAll) == false then
			ObjCounter = ObjCounter + 1
		end
	end)
	if ObjCounter >= #CoopPlayers then
		PlayerFailMission()
	end
  end
end


OncePerThreeSecondChecks = function()
	if DateTime.GameTime > 1 and DateTime.GameTime % 75 == 0 then
    --manipulate AI funds
    ManipulatePlayerFunds(GDI)
	end
end


PlayerFailMission = function()
  if KillNikoombaObjective ~= nil and not Nod.IsObjectiveCompleted(KillNikoombaObjective) then
    Nod.MarkFailedObjective(KillNikoombaObjective)
  end
  if CapturePrisonObjective ~= nil and not Nod.IsObjectiveCompleted(CapturePrisonObjective) then
    Nod.MarkFailedObjective(CapturePrisonObjective)
  end
end