function getActorsAround(actorselected,actorsToFind, distance)
    actorList = Map.ActorsInCircle(actorselected.CenterPosition, WDist.FromCells(distance), function(a)
        return a.Type == actorsToFind
    end)
    return actorList
end


function setupRefs()

    facts = Map.ActorsInBox(Map.TopLeft, Map.BottomRight, function(actor)
        return actor.Type == "fact" or actor.Type == "mcv"
    end)


    Utils.Do(facts, function(a)
        
            -- Media.DisplayMessage (""..a.Owner.Name, "Mission", HSLColor.Red)
        if a.Owner ~= castlePlayer then
            actorOwner = a.Owner
            --Media.DisplayMessage (""..actorOwner.Name, "Mission", HSLColor.Red)

            toCapture = {}
            toCapture = { "silo","powr","oilb","apwr"}

            Utils.Do(toCapture, function(z)
                actorsToCapture = getActorsAround(a,z,16)
                    
                Utils.Do(actorsToCapture, function(b)
                    b.Owner = actorOwner
                end)
            end)
        end
    end)

    --Create Refs
    Trigger.AfterDelay(DateTime.Seconds(1), function()
        powrs = Map.ActorsInBox(Map.TopLeft, Map.BottomRight, function(actor)
            return 
            actor.Type == "silo"
        end)

        Utils.Do(powrs, function(a)

            actorOwner = a.Owner
            originalLocation = a.Location
            newLocation = originalLocation + CVec.New(0,1)

            --if actorOwner.InternalName ~= "Creeps" then
            if actorOwner.InternalName ~= "Neutral" then
                Actor.Create("proc", true, { Owner = actorOwner, Location = newLocation})
            end
            
             --Media.DisplayMessage (""..actorOwner.InternalName, "Mission", HSLColor.Red)
            -- Media.DisplayMessage(""..newLocation, "Mission", HSLColor.Red)
        end)

    end)


    Trigger.AfterDelay(DateTime.Seconds(2), function()
        neutralActors = getAllNeutral()
        removeactors(neutralActors)

        --creepActors = getAllCreeps()
        --removeactors(creepActors)
        --Media.DisplayMessage(""..#creepActors, "Mission", HSLColor.Red)
    end)
end

function getAllCreeps()
    targets = Utils.Where(Creeps.GetActors(), function(actor)
        return
            actor.Type == "powr" or actor.Type == "silo" or actor.Type == "oilb" or actor.Type == "apwr" or actor.Type == "proc" or actor.Type == "harv"
    end)
    return targets
end

function getAllNeutral()
    targets = Utils.Where(Neutral.GetActors(), function(actor)
        return
            actor.Type == "powr" or actor.Type == "silo" or actor.Type == "oilb" or actor.Type == "apwr" or actor.Type == "proc" or actor.Type == "harv"
    end)
    return targets
end

--Remove Boxes in Table
function removeactors(a)
    Utils.Do(a, function(unit)
        unit.Destroy()
    end)
    return 
end



WorldLoaded = function()
    Creeps = Player.GetPlayer("Creeps") 
    Neutral = Player.GetPlayer("Neutral") 
    Trigger.AfterDelay(DateTime.Seconds(2), function()
        setupRefs()
    end)


    Trigger.AfterDelay(DateTime.Seconds(1),function()
        check_teleport()
    end)

    teleported={}
    Teleports_ActorsIn={}
    Teleports_ActorsOut={}
    Teleports_ActorsDiffX={}
    Teleports_ActorsDiffY={}
    number_time={}
    check_teleport=function(TeleportNumber)
        --Media.DisplayMessage("Checking teleports.","Mission",HSLColor.Green)

        if not init_teleport then
            init_teleport=1
            Tile=WDist.FromCells(1).Length
            AreaSize=WVec.New(Tile*2.5,Tile*2.5,0)
            for i=1,8,1 do

                number_time[i]=5
                Oke = 1
                Media.DisplayMessage("Init teleport: "..i,"Mission",HSLColor.Green)

                TeleportNameIn="ActorTeleportIn"..i
                TeleportActorIn=Map.NamedActor(TeleportNameIn)
                TeleportNameOut="ActorTeleportOut"..i
                TeleportActorOut=Map.NamedActor(TeleportNameOut)

                if TeleportActorIn~=nil and TeleportActorOut~=nil then
                    
                    x_i = TeleportActorIn.CenterPosition.X/Tile
                    y_i = TeleportActorIn.CenterPosition.Y/Tile
                    x_o = TeleportActorOut.CenterPosition.X/Tile
                    y_o = TeleportActorOut.CenterPosition.Y/Tile

                    Teleports_ActorsDiffX[i]=x_o-x_i
                    Teleports_ActorsDiffY[i]=y_o-y_i

                    --TeleportActorDiffY=TeleportActorOut.CenterPosition.Y/Tile-TeleportActorIn.CenterPosition.Y/Tile

                    Teleports_ActorsIn[i] = TeleportActorIn
                    Teleports_ActorsOut[i] = TeleportActorOut

                    --Media.DisplayMessage("Teleport in/out location "..i..": "..x_i..","..y_i.." / "..x_o..","..y_o.." OK!","Mission",HSLColor.Blue);
                    if Oke == 1 then
                        Trigger.AfterDelay(DateTime.Seconds(4+i),function()
                            check_teleport(i)
                        end)
                    --else
                    --    return
                    end
                    --return
                else
                    if TeleportActorIn == nil then
                        Media.DisplayMessage("Teleport in location:  TeleportActorIn"..i..": NOT OK! AAARGHHHHH!!!!","Mission",HSLColor.Blue);
                    else
                        Media.DisplayMessage("Teleport out location: TeleportActorOut"..i..": NOT OK! AAARGHHHHH!!!!","Mission",HSLColor.Blue);
                    end
                    Oke = 0
                    --return
                end

            end
            return
        end

        if TeleportNumber == nil then 
            Media.DisplayMessage("TeleportNumber == nil","Mission",HSLColor.Blue);
        --else
            --Media.DisplayMessage("Checking TeleportNumber: "..TeleportNumber,"Mission",HSLColor.Blue);
        end 

        facts=Map.ActorsInBox(Teleports_ActorsIn[TeleportNumber].CenterPosition-AreaSize,Teleports_ActorsIn[TeleportNumber].CenterPosition+AreaSize,function(actor)
            return actor.Type~="waypoint" and actor.HasProperty("Move")
        end)

        number=0
        local actorId=""

        Utils.Do(facts,function(actor)
            number=number+1
            if number==1 and number_time[TeleportNumber]==5 then
                --Media.DisplayMessage("Teleporter "..TeleportNumber..": Activity Detected...","Mission",HSLColor.Blue);
            end
            actorId=tostring(actor)
            if actor.IsIdle then
                --Media.DisplayMessage("Actor: "..actorId.." is idle.","Mission",HSLColor.Blue);
                if teleported[actorId]==nil then
                    teleported[actorId]=actorId
                    flits_teleport(actor,TeleportNumber)
                end
            else
                --Media.DisplayMessage("Actor: "..actorId.." is NOT idle.","Mission",HSLColor.Blue);
                if teleported[actorId]==nil then
                    teleported[actorId]=actorId
                    flits_teleport(actor,TeleportNumber)
                end
            end
        end)

        TeleportCount=tablelength(teleported)
        if (TeleportCount>0) then
            --Media.DisplayMessage("TeleportCount: "..TeleportCount,"Mission",HSLColor.Blue);

            --Utils.Do(teleported,function(MyId)
            --    Media.DisplayMessage("Teleporting list: ID: "..MyId,"Mission",HSLColor.Blue);
            --end)
            number_time[TeleportNumber]=0.2
        else
            --if number_time[TeleportNumber]~=5 then
            --    Media.DisplayMessage("Teleporter "..TeleportNumber.." Rest...","Mission",HSLColor.Blue);
            --end
            number_time[TeleportNumber]=5
        end

        Trigger.AfterDelay(DateTime.Seconds(number_time[TeleportNumber]),function()
            check_teleport(TeleportNumber)
        end)

        flits_teleport=function(a,TeleportNumber)
            local m_actor=a
            local m_actorId=tostring(m_actor)
            Trigger.AfterDelay(DateTime.Seconds(1),function()
                if not m_actor.IsDead then
                    m_actorId=tostring(m_actor)
                    if teleported[m_actorId]~=nil then
                        teleported[m_actorId] = nil
                        --Media.DisplayMessage("Deleting: "..m_actorId.." from list.","Mission",HSLColor.Blue);
                    else
                        Media.DisplayMessage("Not in list: "..m_actorId,"Mission",HSLColor.Blue);
                        return
                    end

                    --Media.DisplayMessage("Teleporting: "..m_actor.Type.."  ID: "..m_actorId,"Mission",HSLColor.Blue);

                    X=m_actor.CenterPosition.X/Tile
                    Y=m_actor.CenterPosition.Y/Tile
                    --Media.DisplayMessage("Teleporting: "..m_actor.Type.."  from: "..X..","..Y,"Mission",HSLColor.Blue);

                    TeleportActorIn=Teleports_ActorsIn[TeleportNumber]
                    TeleportActorOut=Teleports_ActorsOut[TeleportNumber]
                    TeleportActorDiffX=Teleports_ActorsDiffX[TeleportNumber]
                    TeleportActorDiffY=Teleports_ActorsDiffY[TeleportNumber]

                    --Next_TeleportNumber = (TeleportNumber) % 4 + 1
                    --NEXT_X = Teleports_ActorsIn[Next_TeleportNumber].CenterPosition.X/Tile
                    --NEXT_Y = Teleports_ActorsIn[Next_TeleportNumber].CenterPosition.Y/Tile

                    if m_actor.IsIdle then
                        --Media.DisplayMessage("Actor Idle","Mission",HSLColor.Blue);

                        if (X>=TeleportActorIn.CenterPosition.X/Tile-2.5 and X<=TeleportActorIn.CenterPosition.X/Tile+2.5 and Y>=TeleportActorIn.CenterPosition.Y/Tile-2.5 and Y<=TeleportActorIn.CenterPosition.Y/Tile+2.5) then
                            NewP=CPos.New(X+TeleportActorDiffX,Y+TeleportActorDiffY)
                            --Media.DisplayMessage("Teleporting "..TeleportNumber..": "..m_actor.Type.."  ID: "..m_actorId,"Mission",HSLColor.Blue);
                            m_actor.Teleport(NewP)


                            --NewP=CPos.New(NEXT_X,NEXT_Y)

                            if m_actor.HasProperty("Move") then
                                m_angle=math.rad(Utils.RandomInteger(0,359))
                                XX=TeleportActorOut.CenterPosition.X/Tile + math.sin(m_angle)*5
                                YY=TeleportActorOut.CenterPosition.Y/Tile + math.cos(m_angle)*5

                                NewP=CPos.New(XX,YY)
                                m_actor.Move(NewP)
                            end

                        else
                            --Media.DisplayMessage("Actor not in box","Mission",HSLColor.Blue);
                            if teleported[m_actorId]~=nil then
                                teleported[m_actorId]=nil
                            end
                        end
                    else
                        if (X>=TeleportActorIn.CenterPosition.X/Tile-2.5 and X<=TeleportActorIn.CenterPosition.X/Tile+2.5 and Y>=TeleportActorIn.CenterPosition.Y/Tile-2.5 and Y<=TeleportActorIn.CenterPosition.Y/Tile+2.5) then
                            NewP=CPos.New(X+TeleportActorDiffX,Y+TeleportActorDiffY)
                            --Media.DisplayMessage("Actor Moving and in box","Mission",HSLColor.Blue);
                            m_actor.Stop()
                        else
                            --Media.DisplayMessage("Actor Moving and NOT in box","Mission",HSLColor.Blue);
                            if teleported[m_actorId] ~= nil then
                                teleported[m_actorId]=nil
                            end
                        end
                    end
                else
                    m_actorId=tostring(m_actor)
                    --Media.DisplayMessage("Actor ID: "..m_actorId.." is Dead","Mission",HSLColor.Blue);
                    --Media.DisplayMessage("Teleporting: "..m_actor.Type.."  ID: "..m_actorId,"Mission",HSLColor.Blue);
                    if teleported[m_actorId]~=nil then
                        teleported[m_actorId]=nil
                    end
                end

            end)
            if not m_actor.IsDead then
                X=m_actor.CenterPosition.X/Tile
                Y=m_actor.CenterPosition.Y/Tile
                --Media.DisplayMessage("Teleport in 2 sec: "..m_actor.Type.."  ID: "..m_actorId.."  from: "..X..","..Y,"Mission",HSLColor.Blue);
            end
        end
    end


end

function tablelength(T)
    local count=0
    for _ in pairs(T) do count=count+1 end
    return count
end

Tick = function()
end

