ObjectivesSet = false

MCVReinforcements = {}
InfantryReinforcements = { "e1", "e1", "e1", "e1", "medi" }
GrenadierReinforcements = { "e2", "e2", "e2", "e2", "e2" }
EngineerReinforcements = {}
VehicleReinforcements = { "jeep" }
GDIBaseBuildings = { "pyle", "fact", "nuke" }

MCVReinCounter = 1
EngiCounter = 1

ActorRemovals =
{
  easy = { HardDef1, HardDef2, HardDef3, HardDef4, HardDef5, HardDef6, HardDef7, HardDef8, HardDef9, HardDef10, HardDef11, HardDef12, HardDef13, HardDef14, HardDef15, AtkSquadNE1, AtkSquadNE2, AtkSquadNE3, AtkSquadNE4, AtkSquadNE5, HardTurretN, HardTurretS },
  normal = { HardDef1, HardDef2, HardDef3, HardDef4, HardDef5, HardDef6, HardDef7, HardDef8, HardDef9, HardDef10, HardDef11, HardDef12, HardDef13, HardDef14, HardDef15, HardTurretN, HardTurretS },
  hard = { },
}

AttackSquadNW = { AtkSquadNW1, AtkSquadNW2, AtkSquadNW3, AtkSquadNW4, AtkSquadNW5 }
AttackSquadNE = { AtkSquadNE1, AtkSquadNE2, AtkSquadNE3, AtkSquadNE4, AtkSquadNE5 }
AttackSquadW = { AtkSquadW1, AtkSquadW2, AtkSquadW3, AtkSquadW4, AtkSquadW5 }

NodCounter = { "e1", "e1", "e1", "e1", "e1" }

NodCounterNSpawned = false
NodCounterWSpawned = false


-- AI attack production behavior -----

AttackDelayMin = { easy = DateTime.Seconds(90), normal = DateTime.Seconds(60), hard = DateTime.Seconds(45) }
AttackDelayMax = { easy = DateTime.Seconds(120), normal = DateTime.Seconds(90), hard = DateTime.Seconds(60) }
AttackUnitTypes =
{
  easy =
  {
    { factory = 'hand', types = { "e1", "e1", "e1", "e1" } },
    { factory = 'afld', types = { "bggy" } },
  },
  normal =
  {
    { factory = 'hand', types = { "e1", "e1", "e1", "e1", "e1", "e1", "e1" } },
    { factory = 'afld', types = { "bggy", "bggy" } },
  },
  hard =
  {
    { factory = 'hand', types = { "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1" } },
    { factory = 'afld', types = { "bggy", "bggy", "bggy" } },
  }
}

AttackPaths =
{
  { AttackPathW1.Location, AttackPathW2.Location, PlayerLZ.Location },
  { AttackPathW1.Location, AttackPathW2.Location, PlayerLZ.Location },
  { AttackPathW1.Location, AttackPathW2.Location, PlayerLZ.Location },
  { AttackPathS.Location, PlayerLZ.Location },
}

AttackProduction = function()
  local production = Utils.Random(AttackUnitTypes[Difficulty])
  local path = Utils.Random(AttackPaths)
  local toBuild = function() return production.types end
  local factory = GetAvailableFactory(Nod, production.factory)

  if factory ~= nil then
    ProduceUnits(Nod, factory, nil, toBuild, function(units)
      UpdatePlayerBaseLocation()
      Utils.Do(units, function(unit)
        ErrorGuardAttackPatrol(unit, path)
        AssaultPlayerBaseOrHunt(unit)
      end)
      Trigger.AfterDelay(Utils.RandomInteger(AttackDelayMin[Difficulty], AttackDelayMax[Difficulty]), AttackProduction)
    end)
  else
    Trigger.AfterDelay(Utils.RandomInteger(AttackDelayMin[Difficulty], AttackDelayMax[Difficulty]), AttackProduction)
  end

end

-- End AI attack production behavior -----


Reinforce = function(units, voice, start, destination)
  if voice then
    Media.PlaySpeechNotification(All, "Reinforce")
  end
  ReinforceWithLandingCraft(GoodGuy, units, start.Location, destination.Location, false)
end


SpawnNodCounterNorth = function()
  if NodCounterNSpawned == false then
    NodCounterNSpawned = true
    Utils.Do(AttackSquadNW, function(unit)
      if not unit.IsDead then
        unit.AttackMove(PlayerLZ.Location)
        IdleHunt(unit)
      end
    end)
    if Difficulty ~= "easy" then
      Utils.Do(AttackSquadNE, function(unit)
        if not unit.IsDead then
          unit.AttackMove(PlayerLZ.Location)
          IdleHunt(unit)
        end
      end)
    end
  end
--[[
  if NodCounterNSpawned == false then
    NodCounterNSpawned = true
    Reinforcements.Reinforce(Nod, NodCounter, { NodSpawnN1.Location }, 15, function(soldier)
      soldier.AttackMove(PlayerLZ.Location)
      IdleHunt(soldier)
    end)
    if Difficulty ~= "easy" then
      Reinforcements.Reinforce(Nod, NodCounter, { NodSpawnN2.Location }, 15, function(soldier)
        soldier.AttackMove(PlayerLZ.Location)
        IdleHunt(soldier)
      end)
    end
  end
  ]]
end


SpawnNodCounterWest = function()
  if NodCounterWSpawned == false then
    NodCounterWSpawned = true
    Utils.Do(AttackSquadW, function(unit)
      if not unit.IsDead then
        unit.AttackMove(PlayerLZ.Location)
        IdleHunt(unit)
      end
    end)
  end
--[[
  if NodCounterWSpawned == false then
    NodCounterWSpawned = true
    Reinforcements.Reinforce(Nod, NodCounter, { NodSpawnW.Location }, 15, function(soldier)
      soldier.AttackMove(PlayerLZ.Location)
      IdleHunt(soldier)
    end)
  end
  ]]
end


SetObjectives = function()
  BeachheadObjective = GDI.AddObjective("Establish a beachhead.")
  CaptureRefineryObjective = GDI.AddObjective("Capture the Nod refinery.")
  SecureAreaObjective = GDI.AddObjective("Destroy the rest of the Nod base.")
  ObjectivesSet = true
end


SetUpProximityTriggers = function()
  Trigger.OnEnteredProximityTrigger(NodSpawnN1.CenterPosition, WDist.New(6 * 1024), function(a, id)
    if IsOwnedByCoopPlayer(a) then
      Trigger.RemoveProximityTrigger(id)
      SpawnNodCounterNorth()
    end
  end)
  
  Trigger.OnEnteredProximityTrigger(NodSpawnN2.CenterPosition, WDist.New(6 * 1024), function(a, id)
    if IsOwnedByCoopPlayer(a) then
      Trigger.RemoveProximityTrigger(id)
      SpawnNodCounterNorth()
    end
  end)

  Trigger.OnEnteredProximityTrigger(NodSpawnW.CenterPosition, WDist.New(6 * 1024), function(a, id)
    if IsOwnedByCoopPlayer(a) then
      Trigger.RemoveProximityTrigger(id)
      SpawnNodCounterWest()
    end
  end)
end


WorldLoaded = function()
  GDI = Player.GetPlayer("GDI")
  Nod = Player.GetPlayer("Nod")
  MissionPlayer = GDI

	GoodGuy = Player.GetPlayer("GoodGuy")

	coopInfo =
	{
		Mainplayer = GDI,
		MainEnemies = {Nod},
		Dummyplayer = GoodGuy
	}
	
	ORAMod = "tibalt"
	CoopInit25(coopInfo)

  InitObjectives(GDI)
	
	Utils.Do(MCVPlayers,function(PID)
		table.insert(MCVReinforcements,"mcv")
	end)
	Utils.Do(CoopPlayers,function(PID)
		table.insert(EngineerReinforcements,"e6")
	end)

  Camera.Position = startwp.CenterPosition
--[[
  Lighting.Ambient = 0.75
  Lighting.Red = 0.85
  Lighting.Blue = 2.5
  Lighting.Green = 1.6

  Sunrise()
]]
  --Remove actors based on difficulty
  Utils.Do(ActorRemovals[Difficulty], function(unit)
    unit.Destroy()
  end)
  
  --Player Reinforcements
  Trigger.AfterDelay(DateTime.Seconds(4), function() Reinforce(GrenadierReinforcements, true, LstSpawnW, LstLandW) end)
  Trigger.AfterDelay(DateTime.Seconds(4), function() Reinforce(GrenadierReinforcements, false, LstSpawnE, LstLandE) end)
  Trigger.AfterDelay(DateTime.Seconds(10), function() Reinforce(VehicleReinforcements, true, LstSpawnW2, LstLandW2) end)
  Trigger.AfterDelay(DateTime.Seconds(10), function() Reinforce(VehicleReinforcements, false, LstSpawnE2, LstLandE2) end)
  Trigger.AfterDelay(DateTime.Seconds(30), function() Reinforce(MCVReinforcements, true, LstSpawnC, startwp) end)
  Trigger.AfterDelay(DateTime.Seconds(20), function() Reinforce(InfantryReinforcements, true, LstSpawnW, LstLandW) end)
  Trigger.AfterDelay(DateTime.Seconds(20), function() Reinforce(InfantryReinforcements, false, LstSpawnE, LstLandE) end)
  Trigger.AfterDelay(DateTime.Seconds(40), function() Reinforce(EngineerReinforcements, true, LstSpawnC, startwp) end)
  
  if Difficulty == "easy" then
    Trigger.AfterDelay(DateTime.Seconds(60), function() Reinforce(VehicleReinforcements, true, LstSpawnW2, LstLandW2) end)
    Trigger.AfterDelay(DateTime.Seconds(60), function() Reinforce(VehicleReinforcements, false, LstSpawnE2, LstLandE2) end)
    Trigger.AfterDelay(DateTime.Seconds(60), function() Reinforce(InfantryReinforcements, false, LstSpawnE, LstLandE) end)
  end
  
  --Objectives
  Trigger.AfterDelay(DateTime.Seconds(32), function() SetObjectives() end)
  Trigger.OnCapture(NodRefinery, function(self, captor, oldOwner, newOwner)
    if newOwner ~= Nod then
      GDI.MarkCompletedObjective(CaptureRefineryObjective)
    end
  end)
  
  Trigger.OnKilled(NodRefinery, function(self, killer)
    GDI.MarkFailedObjective(CaptureRefineryObjective)
  end)
  
  --AI player behavior
  Nod.Resources = Nod.ResourceCapacity - 2500
  
  if Difficulty == "hard" then
    AutoRepairAndRebuildBuildings(Nod, 15)
    AutoReplaceHarvesters(Nod)
  end
  
  SetupRefAndSilosCaptureCredits(Nod)
  
  Trigger.AfterDelay(DateTime.Seconds(45), function() AttackProduction() end)
  
  --Enemy Predeployed Attacks
  SetUpProximityTriggers()
  Trigger.AfterDelay(DateTime.Seconds(40), function() SpawnNodCounterNorth() end)
  Trigger.AfterDelay(DateTime.Seconds(90), function() SpawnNodCounterWest() end)
  
  --Spawns
  Trigger.OnKilled(Church, function()
		Actor.Create("pvice", true, { Owner = Nod, Location = Church.Location })
	end)
end


Sunrise = function()
  local active = false

  if Lighting.Ambient < 0.95 then
    Lighting.Ambient = Lighting.Ambient + 0.0001
    active = true
  end

  if Lighting.Blue > 0.9 then
    Lighting.Blue = Lighting.Blue - 0.0002
    active = true
  end

  if Lighting.Green > 0.85 then
    Lighting.Green = Lighting.Green - 0.0002
    active = true
  end
  
  if Lighting.Red < 1.0 then
    Lighting.Red = Lighting.Red + 0.0002
    active = true
  end

  if active then
    Trigger.AfterDelay(5, function()
      Sunrise()
    end)
  end
end


Tick = function()
	Utils.Do(GoodGuy.GetActorsByType("mcv"),function(UID)
		if MCVPlayers[MCVReinCounter] == nil then
			MCVReinCounter = 1
		end
		UID.Owner = MCVPlayers[MCVReinCounter]
		UID.Scatter()
		MCVReinCounter = MCVReinCounter + 1
	end)
	Utils.Do(GoodGuy.GetActorsByType("e6"),function(UID)
		if CoopPlayers[EngiCounter] == nil then
			EngiCounter = 1
		end
		UID.Owner = CoopPlayers[EngiCounter]
		UID.Scatter()
		EngiCounter = EngiCounter + 1
	end)
	OncePerSecondChecks()
	OncePerThreeSecondChecks()
end


OncePerSecondChecks = function()
  if DateTime.GameTime > 1 and DateTime.GameTime % 25 == 0 then
    if ObjectivesSet == true then
      if DateTime.GameTime % DateTime.Seconds(1) == 0 and not GDI.IsObjectiveCompleted(BeachheadObjective) then
        local ObjCounter = 0
		Utils.Do(CoopPlayers,function(PID)
			if CheckForBase(PID, GDIBaseBuildings) == true then
				ObjCounter = ObjCounter + 1
			end
		end)
		if ObjCounter > 0 then
			GDI.MarkCompletedObjective(BeachheadObjective)
		end
      end
      
      if HasOneOf(Nod, LossCheckCritical) == false then
        GDI.MarkCompletedObjective(SecureAreaObjective)
      end
      
      if ObjectivesSet == true then
		local ObjCounter = 0
		Utils.Do(CoopPlayers,function(PID)
			if HasOneOf(PID, LossCheckAll) == false then
				ObjCounter = ObjCounter + 1
			end
		end)
		if ObjCounter >= #CoopPlayers then
			PlayerFailMission()
		end
      end
    end
  end
end


OncePerThreeSecondChecks = function()
	if DateTime.GameTime > 1 and DateTime.GameTime % 75 == 0 then
    --manipulate AI funds
    ManipulatePlayerFunds(Nod)
	end
end


PlayerFailMission = function()
  if SecureAreaObjective ~= nil and not GDI.IsObjectiveCompleted(SecureAreaObjective) then
    GDI.MarkFailedObjective(SecureAreaObjective)
  end
  if CaptureRefineryObjective ~= nil and not GDI.IsObjectiveCompleted(CaptureRefineryObjective) then
    GDI.MarkFailedObjective(CaptureRefineryObjective)
  end
  if BeachheadObjective ~= nil and not GDI.IsObjectiveCompleted(BeachheadObjective) then
    GDI.MarkFailedObjective(BeachheadObjective)
  end
end