--[[
   Copyright (c) The OpenRA Developers and Contributors
   This file is part of OpenRA, which is free software. It is made
   available to you under the terms of the GNU General Public License
   as published by the Free Software Foundation, either version 3 of
   the License, or (at your option) any later version. For more
   information, see COPYING.
]]

if Difficulty == "easy" then
	Rambo = "rmbo.easy"
elseif Difficulty == "hard" then
	Rambo = "rmbo.hard"
else
	Rambo = "rmbo"
end

Civstuff = {"c1", "c2", "c3", "c4", "c5", "c6", "c7", "c8", "c9", "c10", "v20", "v21", "v22", "v23", "v24", "v25", "v26", "v27", "v28", "v29", "v30", "v31", "v32", "v33", "v34", "v35", "v36", "v37"}
GDIBuildings = { ConYard, PowerPlant1, PowerPlant2, PowerPlant3, PowerPlant4, Barracks, CommCenter, WeaponsFactory, GuardTower1, GuardTower2, GuardTower3 }

ReinforceWithChinook = function(_, discoverer)
	if not ChinookTrigger and discoverer == Nod then
		ChinookTrigger = true

		Trigger.AfterDelay(DateTime.Seconds(1), function()
			Actor.Create("flare", true, { Owner = BadGuy, Location = DefaultFlareLocation.Location })
			Media.PlaySpeechNotification(All, "Reinforce")
			TransportHeli = Reinforcements.ReinforceWithTransport(BadGuy, "tran", nil, { ChinookEntry.Location, ChinookTarget.Location })[1]
			if Map.LobbyOption("helicontroller") == "pilot" then
			Trigger.OnPassengerEntered(TransportHeli,function(transporter,enterer)
				if transporter.Owner == BadGuy then
					transporter.Owner = enterer.Owner
				end
			end)
			Trigger.OnPassengerExited(TransportHeli,function(transporter,exiter)
				if not transporter.HasPassengers then
					transporter.Owner = BadGuy
				end
			end)
		elseif Map.LobbyOption("helicontroller") == "playerone" then
			TransportHeli.Owner = Nod
		elseif Map.LobbyOption("helicontroller") == "all" then
			TransportHeli.Owner = Nod
			Utils.Do(CoopPlayers,function(PID)
				if PID ~= Nod then
					Reinforcements.ReinforceWithTransport(PID, 'tran', nil, { ChinookEntry.Location, ChinookTarget.Location })
				end
			end)
		end
			
		end)
	end
end

CreateScientist = function()
	local scientist = Actor.Create("CHAN", true, { Owner = GDI, Location = ScientistLocation.Location })

	KillScientistObjective = AddPrimaryObjective(Nod, "kill-gdi-scientist")
	Nod.MarkCompletedObjective(DestroyTechCenterObjective)

	Trigger.OnKilled(scientist, function()
		Nod.MarkCompletedObjective(KillScientistObjective)
	end)
end

WorldLoaded = function()
	Nod = Player.GetPlayer("Nod")
	GDI = Player.GetPlayer("GDI")
	Creeps = Player.GetPlayer("Creeps")
	Neutral = Player.GetPlayer("Neutral")
	
	BadGuy = Player.GetPlayer("BadGuy")

	coopInfo =
	{
		FMVExtra = "kanepre.vqa",
		FMVBriefing = "nod10a.vqa",
		Mainplayer = Nod,
		MainEnemies = {GDI},
		Dummyplayer = BadGuy
	}
	
	ORAMod = "td"
	
	CoopInit25(coopInfo)
	
	Utils.Do(Neutral.GetActorsByTypes(Civstuff),function(UID)
		UID.Owner = Creeps
	end)
	
	
	GDI.Cash = 10000

	Camera.Position = DefaultCameraPosition.CenterPosition

	InitObjectives(Nod)

	Utils.Do(GDIBuildings, function(building)
		RepairBuilding(GDI, building, 0.75)
	end)

	DestroyTechCenterObjective = AddPrimaryObjective(Nod, "destroy-tech-center")

	Utils.Do(CoopPlayers,function(PID)
		local Commando = Actor.Create(Rambo, true, { Owner = PID, Location = RamboLocation.Location })
		Commando.Scatter()
	end)

	Trigger.OnDiscovered(TechCenter, ReinforceWithChinook)
	Trigger.OnKilled(TechCenter, CreateScientist)
end

Tick = function()
	if DateTime.GameTime > DateTime.Seconds(10) and CoopTeamHasNoRequiredUnits() then
		Nod.MarkFailedObjective(DestroyTechCenterObjective)
	end
end
