--[[
   Copyright (c) The OpenRA Developers and Contributors
   This file is part of OpenRA, which is free software. It is made
   available to you under the terms of the GNU General Public License
   as published by the Free Software Foundation, either version 3 of
   the License, or (at your option) any later version. For more
   information, see COPYING.
]]
StartingUnits = { "mcv" }
BGStartingUnits = {"e4", "e4", "e2", "e2" }
SovietTransportWay = { TransportEntry.Location, TransportStop.Location }

InitialSovietReinforcements = function()
	Trigger.AfterDelay(DateTime.Seconds(2), function()
		Media.PlaySpeechNotification(All, "ReinforcementsArrived")
		Startertransport = Reinforcements.ReinforceWithTransport(USSR, "lst", StartingUnits, SovietTransportWay)[1]
		for i, PID in ipairs(MCVPlayers) do
			if PID ~= USSR then
				ExtraMCV = Actor.Create("mcv", false, { Owner = PID, Location = (Startertransport.Location) })
				Startertransport.LoadPassenger (ExtraMCV)
			end
		end
		for i, UID in ipairs(BGStartingUnits) do
			BadStarters = Actor.Create(UID, false, { Owner = BadGuy, Location = (Startertransport.Location) })
			Startertransport.LoadPassenger (BadStarters)
		end
	end)
end

Tick = function()
	Greece.Cash = 10000
	
	if DateTime.GameTime > DateTime.Seconds(10) then
		Lostcount = 0
		for _, PID in ipairs(CoopPlayers) do
			if PID.HasNoRequiredUnits() then
				Lostcount = Lostcount + 1
			end
		end
		
		if Lostcount >= #CoopPlayers then
			Greece.MarkCompletedObjective(BeatSoviets)
		end
	end
	
	if Greece.HasNoRequiredUnits() then
		for _, PID in ipairs(CoopPlayers) do
			PID.MarkCompletedObjective(DestroyNavalBase)
		end
	end
end

WorldLoaded = function()
	USSR = Player.GetPlayer("USSR")
	Greece = Player.GetPlayer("Greece")

	--Mission specific Information for the Coop Base Script
	FMVBriefing = "soviet11.vqa"
	FMVOpening = "periscop.vqa"
	Enemyplayer = Greece
	Mainplayer = USSR
	Dummyplayer = Player.GetPlayer("BadGuy")
	--
	
	CoopInit()
	
	InitObjectives(USSR)

	DestroyNavalBase = AddPrimaryObjective(USSR, "destroy-allied-units-structures")
	BeatSoviets = AddPrimaryObjective(Greece, "")

	Camera.Position = DefaultCameraPosition.CenterPosition
	InitialSovietReinforcements()
	Trigger.AfterDelay(DateTime.Seconds(5), ActivateAI)
end
