--[[
   Copyright (c) The OpenRA Developers and Contributors
   This file is part of OpenRA, which is free software. It is made
   available to you under the terms of the GNU General Public License
   as published by the Free Software Foundation, either version 3 of
   the License, or (at your option) any later version. For more
   information, see COPYING.
]]
StartingUnits = { "2tnk", "2tnk", "2tnk", "2tnk" }
MammothWays = { MammothWay1.Location, MammothWay2.Location, MammothWay3.Location, MammothWay4.Location, ParaLZ5.Location }
PeekersA = { Peekaboo1, Peekaboo2, Peekaboo3 }
PeekersB = { Peekaboo4, Peekaboo5 }
AmbushTeam = { "3tnk", "v2rl", "e2", "e2", "e4" }
NorthHarassFootprint = { CPos.New(24, 75), CPos.New(25, 75), CPos.New(26, 75), CPos.New(27, 75), CPos.New(36, 72), CPos.New(37, 72), CPos.New(38, 72), CPos.New(39, 72) }
NorthHarassTeam = { "e2", "e2", "e2", "3tnk" }
MissileSilos = { MissileSilo1, MissileSilo2, MissileSilo3, MissileSilo4 }

TimerColor = Player.GetPlayer("USSR").Color
TimerTicks = DateTime.Minutes(59) + DateTime.Seconds(59)

MissionStart = function()
	Utils.Do(USSR.GetGroundAttackers(), function(unit)
		Trigger.OnDamaged(unit, function() IdleHunt(unit) end)
	end)

	Reinforcements.Reinforce(GoodGuy, StartingUnits, { MCVEntry.Location, MCVStop.Location })

	PatrolMammoth.Patrol(MammothWays, true, 20)

	Trigger.AfterDelay(DateTime.Seconds(10), function()
		Utils.Do(PeekersA, function(unit)
			if not unit.IsDead then
				unit.AttackMove(MCVStop.Location)
				IdleHunt(unit)
			end
		end)
	end)

	Trigger.AfterDelay(DateTime.Seconds(45), function()
		Utils.Do(PeekersB, function(unit)
			if not unit.IsDead then
				unit.AttackMove(AttackWaypoint1.Location)
				IdleHunt(unit)
			end
		end)
	end)
end

MissionTriggers = function()
	Trigger.OnKilled(CommandCenter, function()
		USSR.MarkCompletedObjective(HoldOut)
	end)

	Trigger.OnEnteredProximityTrigger(FCom.CenterPosition, WDist.FromCells(15), function(actor, id)
		for _, PID in ipairs(CoopPlayers) do
		if actor.Owner == PID and not MissilesLaunched then
			Trigger.RemoveProximityTrigger(id)
			LaunchMissiles()
		end
		end
	end)

	Trigger.OnTimerExpired(function()
		DateTime.TimeLimit = 0
		Trigger.AfterDelay(1, function() UserInterface.SetMissionText(UserInterface.GetFluentMessage("we-are-too-late"), USSR.Color) end)
		USSR.MarkCompletedObjective(HoldOut)
	end)

	Trigger.OnKilled(BridgeBarrel, function()
		local bridge = Utils.Where(Map.ActorsInWorld, function(actor) return actor.Type == "bridge1" end)[1]
		if not bridge.IsDead then
			bridge.Kill()
		end
	end)

	Trigger.OnEnteredProximityTrigger(OreAmbushTrigger.CenterPosition, WDist.FromCells(5), function(actor, id)
		for _, PID in ipairs(CoopPlayers) do
		if actor.Owner == PID and actor.Type == "harv" and not Map.LobbyOption("difficulty") == "easy" then
			Trigger.RemoveProximityTrigger(id)
			local ambush = Reinforcements.Reinforce(USSR, AmbushTeam, { OreAmbushEntry.Location})
			Utils.Do(ambush, IdleHunt)
		end
		end
	end)

	local northFootTriggered
	Trigger.OnEnteredFootprint(NorthHarassFootprint, function(actor, id)
		for _, PID in ipairs(CoopPlayers) do
		if actor.Owner == PID and not northFootTriggered then
			Trigger.RemoveFootprintTrigger(id)
			northFootTriggered = true

			local northHarass = Reinforcements.Reinforce(USSR, NorthHarassTeam, { OreAmbushEntry.Location})
			Utils.Do(northHarass, IdleHunt)
		end
		end
	end)
end

LaunchMissiles = function()
	MissilesLaunched = true
	Actor.Create("camera", true, { Owner = Greece, Location = FCom.Location })
	Camera.Position = FCom.CenterPosition
	Media.PlaySpeechNotification(All, "AbombLaunchDetected")
	MissileSilo1.ActivateNukePower(CPos.New(127, 127))

	Trigger.AfterDelay(DateTime.Seconds(3), function()
		Media.DisplayMessage(UserInterface.GetFluentMessage("incoming-transmission-capitalized"), UserInterface.GetFluentMessage("landcom-16-capitalized"))
		Media.PlaySpeechNotification(All, "AbombLaunchDetected")
		MissileSilo2.ActivateNukePower(CPos.New(127, 127))
	end)

	Trigger.AfterDelay(DateTime.Seconds(5), function()
		Media.PlaySpeechNotification(All, "AbombLaunchDetected")
		MissileSilo3.ActivateNukePower(CPos.New(127, 127))
	end)

	Trigger.AfterDelay(DateTime.Seconds(6), function()
		Media.PlaySpeechNotification(All, "AbombLaunchDetected")
		MissileSilo4.ActivateNukePower(CPos.New(127, 127))
	end)

	Trigger.AfterDelay(DateTime.Seconds(8), function()
		local fmvStart = DateTime.GameTime
		Media.PlayMovieInRadar("ally10b.vqa", function()
		Media.DisplayMessage(UserInterface.GetFluentMessage("deactivate-four-missiles"), UserInterface.GetFluentMessage("landcom-16-capitalized"))
		end)
	end)

	Trigger.AfterDelay(DateTime.Seconds(9), function()
		CaptureFCom = AddPrimaryObjective(Greece, "capture-enemy-command-center")
		DateTime.TimeLimit = TimerTicks
		Media.PlaySpeechNotification(All, "TimerStarted")
		for _, PID in ipairs(CoopPlayers) do
			PID.MarkCompletedObjective(ApproachBase)
		end
	end)

	Trigger.OnCapture(CommandCenter, function()
		for _, PID in ipairs(CoopPlayers) do
			PID.MarkCompletedObjective(CaptureFCom)
		end
	end)

	Paradrop()
	Trigger.AfterDelay(DateTime.Minutes(2), SendParabombs)
end

SilosDamaged = function()
	if not MissilesLaunched then
		LaunchMissiles()
	end
end

Tick = function()
	USSR.Cash = 50000
	BadGuy.Cash = 50000

	Lostcount = 0
	for _, PID in ipairs(CoopPlayers) do
		if DateTime.GameTime > DateTime.Seconds(10) and PID.HasNoRequiredUnits() then
			Lostcount = Lostcount + 1
		end
	end
	
	if Lostcount >= #CoopPlayers then
		USSR.MarkCompletedObjective(USSRObj)
	end
	
	for _, UID in ipairs(GoodGuy.GetActorsByType("mcv")) do
		CurrentPlayer = CoopPlayers[MCVCount]
		UID.Owner = CurrentPlayer
		MCVCount = MCVCount + 1
		if MCVCount > #CoopPlayers then
			MCVCount = 1
		end
	end
end

WorldLoaded = function()
	Greece = Player.GetPlayer("Greece")
	USSR = Player.GetPlayer("USSR")
	BadGuy = Player.GetPlayer("BadGuy")

	--Mission specific Information for the Coop Base Script
	FMVBriefing = "ally10.vqa"
	FMVOpening = "mcv_land.vqa"
	Enemyplayer = USSR
	--
	CoopInit()
	for _, PID in ipairs(MCVPlayers) do
		table.insert(StartingUnits, "mcv")
	end
	MCVCount = 1

	InitObjectives(Greece)

	HoldOut = AddPrimaryObjective(USSR, "")
	ApproachBase = AddPrimaryObjective(Greece, "disable-atomic-weapons")

	Camera.Position = DefaultCameraPosition.CenterPosition
	StandardDrop = Actor.Create("paradrop", false, { Owner = USSR })
	MissionStart()
	MissionTriggers()
	ActivateAI()
	OnAnyDamaged(MissileSilos, SilosDamaged)
end
