stormTime = 0
worldAmbient = Lighting.Ambient
worldBlue = Lighting.Blue
worldRed = Lighting.Red
blizzards = {}
darkeners = {}

StormTimer = function()
	if stormTime > 0 then
		local minutes = math.floor(stormTime / 60)
		local seconds = stormTime - (minutes * 60)
		local timetext = ""
		if seconds < 10 then
			timetext = "" .. minutes .. ":0" .. seconds .. ""
		else
			timetext = "" .. minutes .. ":" .. seconds .. ""
		end
		Trigger.AfterDelay(DateTime.Seconds(1), function()
			stormTime = stormTime - 1
			UserInterface.SetMissionText("Time until next winter storm " .. timetext, HSLColor.White)
			StormTimer()
		end)
	else
		InitializeStorm()
		UserInterface.SetMissionText("A winter storm us upon you!", HSLColor.White)
	end
end

StormEndTimer = function()
	if stormTime > 0 then
		local minutes = math.floor(stormTime / 60)
		local seconds = stormTime - (minutes * 60)
		local timetext = ""
		if seconds < 10 then
			timetext = "" .. minutes .. ":0" .. seconds .. ""
		else
			timetext = "" .. minutes .. ":" .. seconds .. ""
		end
		Trigger.AfterDelay(DateTime.Seconds(1), function()
			stormTime = stormTime - 1
			UserInterface.SetMissionText("Time until the winter storm ends " .. timetext, HSLColor.White)
			StormEndTimer()
		end)
	else
		EndStorm()
		UserInterface.SetMissionText("The storm has passed!", HSLColor.White)
	end
end

InitializeStorm = function()
	Media.PlayMusic("winterstorm")
	DarkenTheWorld()
	local xLoop = 1
	local yLoop = 1
	local loop = 1
	while yLoop < 98 do
		while xLoop < 98 do
			local actor = Actor.Create("blizzard", true, { Owner = Player.GetPlayer("Neutral"), Location = CPos.New((xLoop), (yLoop)) })
			blizzards[loop] = actor
			loop = loop + 1
			xLoop = xLoop + 12
		end
		xLoop = 0
		yLoop = yLoop + 6
	end
	stormTime = Utils.RandomInteger(20, 80)
	Trigger.AfterDelay(DateTime.Seconds(2), function()
		local actor = Actor.Create("conditioner", true, { Owner = Player.GetPlayer("Multi0"), Location = CPos.New(0, 0) })
	end)
	Trigger.AfterDelay(DateTime.Seconds(4), function()
		local actor = Actor.Create("conditioner2", true, { Owner = Player.GetPlayer("Multi0"), Location = CPos.New(0, 0) })
	end)
	Trigger.AfterDelay(DateTime.Seconds(6), function()
		local actor = Actor.Create("conditioner3", true, { Owner = Player.GetPlayer("Multi0"), Location = CPos.New(0, 0) })
	end)
	Trigger.AfterDelay(DateTime.Seconds(2), function()
		local actor = Actor.Create("conditioner", true, { Owner = Player.GetPlayer("Multi1"), Location = CPos.New(0, 0) })
	end)
	Trigger.AfterDelay(DateTime.Seconds(4), function()
		local actor = Actor.Create("conditioner2", true, { Owner = Player.GetPlayer("Multi1"), Location = CPos.New(0, 0) })
	end)
	Trigger.AfterDelay(DateTime.Seconds(6), function()
		local actor = Actor.Create("conditioner3", true, { Owner = Player.GetPlayer("Multi1"), Location = CPos.New(0, 0) })
	end)
	StormEndTimer()
end

EndStorm = function()
	LightenTheWorld()
	for i = 1, #blizzards do
		blizzards[i].Destroy()
	end
	stormTime = Utils.RandomInteger(30, 210)
	Trigger.AfterDelay(DateTime.Seconds(2), function()
		Player.GetPlayer("Multi0").GetActorsByType("conditioner")[1].Destroy()
	end)
	Trigger.AfterDelay(DateTime.Seconds(4), function()
		Player.GetPlayer("Multi0").GetActorsByType("conditioner2")[1].Destroy()
	end)
	Trigger.AfterDelay(DateTime.Seconds(6), function()
		Player.GetPlayer("Multi0").GetActorsByType("conditioner3")[1].Destroy()
	end)
	Trigger.AfterDelay(DateTime.Seconds(2), function()
		Player.GetPlayer("Multi1").GetActorsByType("conditioner")[1].Destroy()
	end)
	Trigger.AfterDelay(DateTime.Seconds(4), function()
		Player.GetPlayer("Multi1").GetActorsByType("conditioner2")[1].Destroy()
	end)
	Trigger.AfterDelay(DateTime.Seconds(6), function()
		Player.GetPlayer("Multi1").GetActorsByType("conditioner3")[1].Destroy()
	end)
	Media.PlayMusic("")
	StormTimer()
end

DarkenTheWorld = function()
	if worldAmbient > 0.5 then
		Lighting.Ambient = worldAmbient
		Lighting.Blue = worldBlue
		Lighting.Red = worldRed
		worldAmbient = worldAmbient - 0.01
		worldBlue = worldBlue + 0.01
		worldRed = worldRed + 0.001
		Trigger.AfterDelay(2, function()
			DarkenTheWorld()
		end)
	end
end

LightenTheWorld = function()
	if worldAmbient < 1 then
		Lighting.Ambient = worldAmbient
		Lighting.Blue = worldBlue
		Lighting.Red = worldRed
		worldAmbient = worldAmbient + 0.01
		worldBlue = worldBlue - 0.01
		worldRed = worldRed - 0.001
		Trigger.AfterDelay(2, function()
			LightenTheWorld()
		end)
	end
end

WorldLoaded = function()
	stormTime = Utils.RandomInteger(20, 80)
		StormTimer()
end
